# Docker instructions

## Pre-Requisites
Docker can be downloaded and installed from [Docker web site](https://www.docker.com/).

## Build the docker image for template migration tool
cd to

`nms/tools/migration`

and run:

```sh
docker build --tag templatemigration .
```

You will see output like below:

```console
Sending build context to Docker daemon  160.8kB
Step 1/8 : FROM python:2
 ---> fbc983cb5352
Step 2/8 : WORKDIR /migration
 ---> Using cache
 ---> fcc39923bcb7
Step 3/8 : COPY requirements.txt ./
 ---> Using cache
 ---> f1476cb1162e
Step 4/8 : RUN pip install --no-cache-dir -r requirements.txt
 ---> Using cache
 ---> b0508f3d7ef7
Step 5/8 : COPY . .
 ---> Using cache
 ---> 1c7e12b24acb
Step 6/8 : VOLUME ["/migration/FeatureMigration"]
 ---> Using cache
 ---> eab1834a6a05
Step 7/8 : ENTRYPOINT ["python", "./templatemigrations.py"]
 ---> Using cache
 ---> ecca78781ec1
Step 8/8 : CMD []
 ---> Using cache
 ---> 7bbd6e103a00
Successfully built 7bbd6e103a00
Successfully tagged templatemigration:latest
```

The image is now ready to go.

## Run the docker image
Usage:
`docker run -v /<data_path>:/migration/FeatureMigration -it --rm templatemigration <args>`

where:
* `<data_path>` is the directory to store the files created by the migration tool for later inspection.
* `<args>` is the arguments to the migration tool. See [here](README.md#argument-meaning) for details.

Example:
`docker run -v /tmp:/migration/FeatureMigration -it --rm templatemigration -ip 10.34.52.12 -port 9912 -fv 19.2 -tv 20.1 -prefix updated`
