"""
    1. Given the location of a generated InputJSON file containing multiple
       migrations (18.4 -> 20.1, 19.2 -> 20.1 etc), this script finds all unique
       operations and merges the resulting operations per templateType

    Author: Shreyas Ramesh
    Email: shrerame@cisco.com
"""

# ----------------- #
#  Generic Imports  #
# ----------------- #

import os
import sys
import json
import copy
import numbers
from collections import deque, OrderedDict
from operator import itemgetter
import itertools
# ------------------- #
#  Global Parameters  #
# ------------------- #

### NO GLOBAL PARAMETERS DEFINED

class TemplateUtils:
    def __init__(self):
        self.currentDirPath = os.path.dirname(__file__)
        self.obejectPairsHook = OrderedDict


    def readJsonFromPath(self, path):
        with open(path) as JSONFile:
            return json.load(JSONFile)


    def writeJsonToFile(self, directory, JSONFilename, data):
        if not os.path.exists(directory):
            os.makedirs(directory)
        with open(os.path.join(directory, JSONFilename), "w+") as JSONFile:
             json.dump(data, JSONFile, indent=4)



class Squasher():
    def __init__(self, pathToJsonInput, dateToday, toVmanageVersion):
        self.listOfNewDict = []
        self.oldMigrationDict = TemplateUtils().readJsonFromPath(pathToJsonInput)
        self.newMigrationDict = {}
        self.dateToday = dateToday
        self.uniquetemplateTypeTuples = {}
        self.toVmanageVersion = toVmanageVersion


    def initializeSquashedInputJson(self):
        self.newMigrationDict["dateGenerated"] = self.dateToday
        self.newMigrationDict["squashedVmanageVersions"] = []
        self.newMigrationDict["fromvManageVersion"] = "all"
        self.newMigrationDict["tovManageVersion"] = self.toVmanageVersion
        self.newMigrationDict["templateTypeList"] = []


    def changeFromListsToPath(self, listOfOpers):
        for listElement in listOfOpers:
            listElement["fieldHierarchyList"] = '/'.join(listElement["fieldHierarchyList"])


    def cleanListToDict(self, key):
        if len(self.uniquetemplateTypeTuples[key]) == 0:
            return

        removeListOfDicts, defaultListOfDicts, rangeListOfDicts = [], [], []

        for operElement in self.uniquetemplateTypeTuples[key]:
            newDict = {}
            operIndex, operType = 0, ''
            for idx, element in enumerate(operElement):
                if element[0] == 'operation':
                    operIndex = idx
                    operType = element[1]

            if operType == 'remove':
                newDict['operation'] = 'remove'
                for element in operElement:
                    if element[0] == 'fieldHierarchyList':
                        newDict['fieldHierarchyList'] = element[1].split('/')
                removeListOfDicts.append(newDict)

            elif operType == 'default':
                newDict['operation'] = 'default'
                for element in operElement:
                    if element[0] == 'fieldHierarchyList':
                        newDict['fieldHierarchyList'] = element[1].split('/')
                    elif element[0] == 'default':
                        newDict['default'] = element[1]
                    else:
                        # Pass - Opertation Type
                        pass
                defaultListOfDicts.append(newDict)

            elif operType == 'range':
                newDict['operation'] = 'range'
                for element in operElement:
                    if element[0] == 'fieldHierarchyList':
                        newDict['fieldHierarchyList'] = element[1].split('/')
                    elif element[0] == 'rangeMin':
                        newDict['rangeMin'] = element[1]
                    elif element[0] == 'rangeMax':
                        newDict['rangeMax'] = element[1]
                    else:
                        # Pass - Operation Type
                        pass
                rangeListOfDicts.append(newDict)

        finalList = [removeListOfDicts, defaultListOfDicts, rangeListOfDicts]
        finalList = list(itertools.chain.from_iterable(finalList))
        self.uniquetemplateTypeTuples[key] = finalList


    def fetchUniqueTemplateTypeTuples(self):
        self.oldSums = {}
        for inputJsonElement in self.oldMigrationDict:
            self.newMigrationDict["squashedVmanageVersions"].append(inputJsonElement["fromvManageVersion"])
            for templateType in inputJsonElement["templateTypeList"]:
                currentTemplateTypeTuple = (templateType["fromFeatureName"], templateType["toFeatureName"])
                if currentTemplateTypeTuple not in self.uniquetemplateTypeTuples.keys():
                    self.oldSums[currentTemplateTypeTuple] = len(templateType["listOfTasks"])
                    self.uniquetemplateTypeTuples[currentTemplateTypeTuple] = [i for i in templateType["listOfTasks"]]
                else:
                    self.oldSums[currentTemplateTypeTuple] =  self.oldSums[currentTemplateTypeTuple] + len(templateType["listOfTasks"])
                    self.uniquetemplateTypeTuples[currentTemplateTypeTuple].extend(templateType["listOfTasks"])

        for key in self.uniquetemplateTypeTuples.keys():
            self.changeFromListsToPath(self.uniquetemplateTypeTuples[key])
            myListOfDictsSorted = [sorted(d.items()) for d in self.uniquetemplateTypeTuples[key]]
            self.uniquetemplateTypeTuples[key] = list(map(json.loads,set(map(json.dumps, myListOfDictsSorted))))
            self.cleanListToDict(key)
            self.newMigrationDict["templateTypeList"].append({"fromFeatureName": key[0], "toFeatureName": key[1], "listOfTasks": self.uniquetemplateTypeTuples[key]})

        self.listOfNewDict.append(self.newMigrationDict)

        print("Squash Result: templateType | Number of elements before squash | Number of elements after squash")
        for key in self.uniquetemplateTypeTuples.keys():
            print(key, self.oldSums[key], len(self.uniquetemplateTypeTuples[key]))


if __name__ == "__main__":
    squashObj = Squasher("./JSONInput_18_4_19_2_19_3_to_20_1.json", "03/20/2020", "20.1")
    squashObj.initializeSquashedInputJson()
    squashObj.fetchUniqueTemplateTypeTuples()
    TemplateUtils().writeJsonToFile("./", "JSONInput.json", squashObj.listOfNewDict)
