# Template Migration Tool for Cisco vManage

Tool to migrate vEdge-cEdge combined vManage templates to cEdge only vManage templates (20.1 onwards)

## Use Case
Post upgrade to a new version of vManage, for example from vManage 19.2 to 20.1, cEdge (cisco device) feature templates created in an older version of vManage may be rendered invalid. This is due to changes in schema between the two versions.

***NOTE: If you are upgrading vManage from either version 18.4, 19.2 or 19.3 to 20.1, then this tool will be useful.***


## Pre-Requisites

1. The user will first need to have migrated to the new version of vManage from an impacted version.

2. The tool requires Python 2.7 to work. This can be verified by pasting the following to a terminal window:

    `python -c "import sys;assert sys.version_info>(2,7)" && echo "ALL GOOD"`

  If 'ALL GOOD' is printed it means Python requirements are met. If not, download and install the latest 2.x version at Python.org (https://www.python.org/downloads/).

3. Install Python requests package:

    `python -m pip install --upgrade requests`

4. Install Python pathlib2 package:

    `python -m pip install --upgrade pathlib2`

4. Verify that the tool can run:

    `python templatemigration.py --version`


The command line can be structured as follows:

    python templatemigration.py <required parameters> <optional arguments>


## Argument Meaning

- **Ip** (required): IP address of the vManage application

- **Port** (optional): TCP Port to connect to vManage application (default is 443)

- **Fv** (required): Short form of From Version. The vManage version prior to upgrade (18.4, 19.2, 19.3)

- **Tv** (required): Short form of To Version. The vManage version currently running (20.1).

- **Prefix** (optional): this the name that gets added to the feature template name to help indicate that the migration happened on a given template. The default is cisco_.

***NOTE: Fv and Tv arguments are used to check if the feature migration between vManage versions is supported or not. Currently 18.4 to 20.1, 19.2 to 20.1 and 19.3 to 20.1 are supported.***


## Example and Explanation

  `python templatemigrations.py -ip 10.34.52.12 -port 9912 -fv 19.2 -tv 20.1 -prefix updated`

This command means that the user’s vManage application is accessible through URL https://10.34.52.12:9912, the application is currently running version 20.1 and has been updated from 19.2. The name of the new (migrated) templates will be updated_<name of the old feature/device template>. Once the command is executed, the user will be immediately prompted for his/her username and password, so the scripts can authenticate with vmanage. The inputs are hidden to avoid printing credentials in plain text


The script will:
- Precheck: Verify if the vManage version pair (Fv and Tv) is supported
- Precheck: Verify if vmanage_session.py, migration.py, Input/supported_cedge_templates.json and Input/JSONInputs.json are in the appropriate directories
- Credential: Check authorization and authenticate
- Fetch: Acquire device templates and associated feature templates. Both feature templates and device templates will be saved under the Data/feature and Data/master directory respectively.
- Filter: Iterate over the saved feature templates and gather the subset of feature templates that need to be migrated.
- Migrate: Iterate through the filtered list of feature templates that need to be migrated and perform necessary migration operations using migration.py.
- Post Migration: Once the templates are migrated, they will be saved under the directory the user provided. A new device template will be created based on the old device template with the prefix added. The new device template will also have new feature templates associated with it.
- Upload: All newly created device and feature templates are uploaded to vManage.

***NOTE: All operations performed during migration are recorded for verification***
