#!/bin/bash

###############################################################################
#
# Citrix Virtual Apps & Desktops For Linux Script: Detect the Linux distribution and version
#
# SOURCE: http://www.novell.com/coolsolutions/feaure/11251.html

export LC_ALL="en_US.UTF-8"

OS=`uname -s`
REV=`uname -r`
MACH=`uname -m`

function usage {
    echo "Usage: $(basename $0) [-d|r|-help]"
    echo " -d display distribution string"
    echo " -r display release version and revision string"
    echo " --help display this help"
}

if [ "$#" -gt 0 -a "$1" == "--help" ] ; then
    usage
    exit 0
fi

GetVersionFromFile()
{
    VERSION=` cat $1 | tr "\n" ' '| sed s/.*VERSION\ =\ // | sed s/\ PATCHLEVEL.*//`
}

if [ "${OS}" = "Linux" ] ; then
    KERNEL=`uname -r`
    if [ -f /etc/redhat-release ] ; then
        DIST=`cat /etc/redhat-release | tr "\n" ' '| sed s/VERSION.*// | sed s/\ *$//`
        PSUEDONAME=`cat /etc/redhat-release | sed s/.*\(// | sed s/\)//`
        GetVersionFromFile /etc/redhat-release
        REV=`cat /etc/redhat-release | sed s/.*release\ // | sed s/\ .*//`
    elif [ -f /etc/SuSE-release ] ; then
        DIST=`cat /etc/SuSE-release | tr "\n" ' '| sed s/VERSION.*// | sed s/\ *$//`
        GetVersionFromFile /etc/SuSE-release
        REV=`cat /etc/SuSE-release | tr "\n" ' ' | sed s/.*=\ //`
    elif [ -f /etc/mandrake-release ] ; then
        DIST='Mandrake'
        PSUEDONAME=`cat /etc/mandrake-release | sed s/.*\(// | sed s/\)//`
        GetVersionFromFile /etc/mandrake-release
        REV=`cat /etc/mandrake-release | sed s/.*release\ // | sed s/\ .*//`
    elif [ -f /etc/lsb-release ] ; then
        DIST=`cat /etc/lsb-release | sed -E -n 's/DISTRIB_DESCRIPTION.*="(.*)"/\1/p'`
        VERSION=`cat /etc/lsb-release | sed -E -n 's/DISTRIB_ID.*=(.*)/\1/p'`
        REV=`cat /etc/lsb-release | sed -E -n 's/DISTRIB_RELEASE.*=(.*)/\1/p'`
    elif [ -f /etc/os-release ] ; then
        DIST="$(< /etc/os-release grep ^PRETTY_NAME= |cut -d '=' -f2 |tr -d '"' 2>&1)"
        VERSION="$(< /etc/os-release grep ^VERSION= |cut -d '=' -f2 |tr -d '"' 2>&1)"
        REV="$(cut -d "-" -f2 <<< "$VERSION" | sed 's/[^0-9]*//g')"
        VERSION=${VERSION%-*}
    fi
    if [ -f /etc/UnitedLinux-release ] ; then
        DIST="${DIST}[`cat /etc/UnitedLinux-release | tr "\n" ' ' | sed s/VERSION.*//`]"
        GetVersionFromFile /etc/UnitedLinux-release
    fi
fi

if [ "$#" -gt 0 -a "$1" == "-d" ] ; then
    echo "${DIST}"
    exit 0
elif [ "$#" -gt 0 -a "$1" == "-r" ] ; then
    echo "${VERSION}.${REV}"
    exit 0
else
    echo "${DIST} version: ${VERSION}.${REV}"
    exit 0
fi 
