#!/bin/bash

DBUS_DAEMON_PID=$(ps -ef | grep "dbus-daemon --system" | grep -v grep | awk '{ print $2 }')
CURRENT_DBUS_DAEMON_NOFILE_LIMIT=$(awk '$0 ~ "Max open files" { print $4 }' /proc/$DBUS_DAEMON_PID/limits)
MINIMUM_DBUS_DAEMON_NOFILE_LIMIT=3072

if [ "$CURRENT_DBUS_DAEMON_NOFILE_LIMIT" -le "$MINIMUM_DBUS_DAEMON_NOFILE_LIMIT" ]; then
    if hash prlimit 2>/dev/null; then
        prlimit --pid=$DBUS_DAEMON_PID --nofile=$MINIMUM_DBUS_DAEMON_NOFILE_LIMIT:$MINIMUM_DBUS_DAEMON_NOFILE_LIMIT
    else
        echo -n "Max open files=$MINIMUM_DBUS_DAEMON_NOFILE_LIMIT:$MINIMUM_DBUS_DAEMON_NOFILE_LIMIT" > /proc/$DBUS_DAEMON_PID/limits
    fi
fi

sysctl -w kernel.shmmax=18446744073709551615
