#!/bin/bash

#******************************************************************************
# ctx_usb_automount.sh
#
# Copyright 1998-2019, 2019 Citrix Systems, Inc. All Rights Reserved.
#
# Citrix Virtual Apps & Desktops For Linux VDA USB Mount Script.
#
# For ntfs format:
#     Kernel should support first
#
# Input parameters:
# $1 operation
# mount:
#    $2 file_type
#    $3 device_name
#    $4 user
#    $5 mount_path
# umount:
#    $2 mount_path
#
# Return value:
#    0 - [success] Normally return
#    1 - [failed]  Invalid
#
#*******************************************************************************
#exec </dev/null >/tmp/usb.log 2>&1
#set -x

COMM_OPTIONS=relatime,nodev,noexec

if [ "$(id -u)" != 0 ]; then
    exit 1
fi

if [ "$1" == "mount" ];then
    if [ $# -ne 5 ]; then
        exit 1;
    fi

    if [ ! -e "/media/$5" ]; then
        /bin/mkdir -p /media/$5
    fi

    if [ "$2" = "ntfs" ]; then
        MOUNT_OPTIONS="$COMM_OPTIONS,uid=$4,gid=$4,umask=0077,utf8,flush -t ntfs"
    else
        MOUNT_OPTIONS=$COMM_OPTIONS,uid=$4,gid=$4,umask=0077,utf8,flush
    fi

    /bin/mount -o "$MOUNT_OPTIONS" /dev/$3 /media/$5

elif [ "$1" == "umount" ]; then
    if [ $# -ne 2 ]; then
        exit 1;
    fi

    /bin/umount -l /media/$2

    if [ -e "/media/$2" ]; then
        /bin/rmdir /media/$2
    fi
else
    exit 1
fi

exit 0
