#!/bin/bash

################################################################################
#
# Citrix Virtual Apps & Desktops For Linux Final Cleanup Script
# ctxcleanup.sh
#
# This script must be run at least once, prior to uninstalling XDL.
#
# Any changes to the system made by the setup script, or files
# generated during server runtime should be reverted/deleted by this script.
# The only XDL related files remaining on the system afterwards should be
# the ones laid out as part of the RPM install.
#
# While it can be run manually by the user, the RPM will also invoke this script
# automatically as a pre-uninstall step, just in case.
#

source /var/xdl/configure_common.sh
source /var/xdl/configure_platform.sh
source /var/xdl/configure_utilities.sh

function usage {
    /opt/Citrix/VDA/bin/getstr SHELL_CLEANUP_USAGE $0 "$product_name"
}

if [ $EUID -ne 0 ]; then
    /opt/Citrix/VDA/bin/getstr SHELL_SETUP_MUST_ROOT
    echo
    exit 1
fi

upgrade=false

if [ "$1" == "--help" ] || [ "$1" == "-h" ]; then
    /opt/Citrix/VDA/bin/getstr SHELL_CLEANUP_SCRIPT "$product_name"
    echo
    usage
    exit 0
elif [ "$1" == "--upgrade" ]; then
    upgrade=true
elif [ ! -z "$1" ]; then
    /opt/Citrix/VDA/bin/getstr SHELL_CLEANUP_UNKNOWN $1
    echo
    /opt/Citrix/VDA/bin/getstr SHELL_CLEANUP_MORE_INFO $0
    exit 1
fi

cmdlog_start cleanup

service_stop

if $upgrade; then
    cmdlog_stop
    exit 0
fi

postgresql_start

# Remove mcs related configruations if its configured here
remove_mcs_config
# this group is for local mapped account in NDJ feature
delete_localuser_group

# Remove firewall rules before dropping database as may need to read the
# VDA port from the database first
firewall_remove_rules
firewall_try_restart

confdb_drop_database
rm -f /var/xdl/.setup.confdb.populate
rm -f /var/xdl/.setup.confdb

if [ -f /var/xdl/.setup.postgres ]; then
    postgresql_restore_config
    postgresql_restart
    rm -f /var/xdl/.setup.postgres
fi

# Kill services if they have failed to stop properly. This prevents
# respawned services from running after the uninstall for systemd.
service_kill

service_unregister

desktop_environment_restore

selinux_environment_restore

delete_anonymous_group

cmdlog_stop

cleanup_temp_files

