#!/bin/sh

function ldconfig_update {
    function inner {
        /sbin/ldconfig /opt/Citrix/VDA/lib64 || return 1
        /sbin/ldconfig /opt/Citrix/VDA/lib32 || return 1
    }
    cmdlog_exec inner $FUNCNAME "update ldconfig"
}

function postgresql_start {
    function inner {
        /bin/systemctl start postgresql || return 1
    }
    cmdlog_exec inner $FUNCNAME "start PostgreSQL"
}

function postgresql_restart {
    function inner {
        /bin/systemctl restart postgresql || return 1
    }
    cmdlog_exec inner $FUNCNAME "restart PostgreSQL"
}

function service_start {
    function inner {
        /bin/systemctl daemon-reload || return 1
        if [ -f /etc/systemd/system/ctxlogd.service ]; then
            /bin/systemctl start ctxlogd || return 1
        fi

        /bin/systemctl start ctxhdx || return 1
        /bin/systemctl start ctxpolicyd || return 1
        /bin/systemctl start ctxjproxy || return 1
        /bin/systemctl start ctxvda || return 1
        /bin/systemctl start ctxcups
        /bin/systemctl start cups
        /bin/systemctl start ctxvhcid
        /bin/systemctl start ctxusbsd
        /bin/systemctl start ctxceip
        /bin/systemctl start ctxtelemetry.socket
        /bin/systemctl start ctxcdm
        /bin/systemctl start ctxbcrd
        /bin/systemctl start ctxmonitorservice
        smartcard_start
        /bin/systemctl start ctxgdtd
        /bin/systemctl start ctxwcamsd
        /bin/systemctl start ctxsdcd

    }
    cmdlog_exec inner $FUNCNAME "start $short_name"
}

function smartcard_start {
    if [ -f /etc/systemd/system/ctxscardsd.service ]; then
        result=`/opt/Citrix/VDA/bin/ctxreg dump | grep ScardEnable | awk '{print $9}' | cut -d "\"" -f2 | cut -d "\"" -f1`
        if [[ $result == "0x00000001" ]]; then
            /opt/Citrix/VDA/bin/ctxreg create -k "HKLM\Software\Citrix\VirtualDesktopAgent\SmartLogon" -t "REG_DWORD" -v "ScardPreStatus" -d "0" --force || return 1
            /bin/systemctl start ctxscardsd || return 1
        fi
    fi
}

function smartcard_stop {
    if [ -f /etc/systemd/system/ctxscardsd.service ]; then
        #check previous status
        result=`systemctl status ctxscardsd | grep Active | awk '{print $3}' | cut -d "(" -f2 | cut -d ")" -f1`
        if [[ $result == "running" ]]; then
            /opt/Citrix/VDA/bin/ctxreg create -k "HKLM\Software\Citrix\VirtualDesktopAgent\SmartLogon" -t "REG_DWORD" -v "ScardEnable" -d "1" --force || return 1
            /opt/Citrix/VDA/bin/ctxreg create -k "HKLM\Software\Citrix\VirtualDesktopAgent\SmartLogon" -t "REG_DWORD" -v "ScardPreStatus" -d "1" --force || return 1
            /bin/systemctl stop ctxscardsd || return 1
        fi

        result=`/opt/Citrix/VDA/bin/ctxreg dump | grep ScardPreStatus | awk '{print $9}' | cut -d "\"" -f2 | cut -d "\"" -f1`
        if [[ $result != "0x00000001" ]]; then
            /opt/Citrix/VDA/bin/ctxreg create -k "HKLM\Software\Citrix\VirtualDesktopAgent\SmartLogon" -t "REG_DWORD" -v "ScardEnable" -d "0" --force || return 1
        fi
    fi
}

function service_stop {
    function inner {
        /bin/systemctl daemon-reload || return 1
        /bin/systemctl stop ctxsdcd
        /bin/systemctl stop ctxwcamsd
        /bin/systemctl stop ctxgdtd
        smartcard_stop
        /bin/systemctl stop ctxmonitorservice
        /bin/systemctl stop ctxbcrd
        pkill -f /opt/Citrix/VDA/bin/ctxfm

        /bin/systemctl stop ctxcdm
        /bin/systemctl stop ctxcups
        /bin/systemctl stop cups
        /bin/systemctl stop ctxusbsd
        /bin/systemctl stop ctxvhcid
        /bin/systemctl stop ctxceip
        /bin/systemctl stop ctxtelemetry.socket
        /bin/systemctl stop ctxtelemetry@*.service

        /bin/systemctl stop ctxpolicyd || return 1
        /bin/systemctl stop ctxvda || return 1
        /bin/systemctl stop ctxjproxy || return 1
        /bin/systemctl stop ctxhdx || return 1
        if [ -f /etc/systemd/system/ctxlogd.service ]; then
            /bin/systemctl stop ctxlogd || return 1
        fi

    }
    cmdlog_exec inner $FUNCNAME "stop $short_name"
}

function service_kill {
    function inner {
        /bin/systemctl is-active -q ctxsdcd && /bin/systemctl kill ctxsdcd
        /bin/systemctl is-active -q ctxwcamsd && /bin/systemctl kill ctxwcamsd
        /bin/systemctl is-active -q ctxgdtd && /bin/systemctl kill ctxgdtd
        /bin/systemctl is-active -q ctxmonitorservice && /bin/systemctl kill ctxmonitorservice
        /bin/systemctl is-active -q ctxbcrd && /bin/systemctl kill ctxbcrd
        /bin/systemctl is-active -q ctxvda && /bin/systemctl kill ctxvda
        /bin/systemctl is-active -q ctxjproxy && /bin/systemctl kill ctxjproxy
        /bin/systemctl is-active -q ctxtelemetry && /bin/systemctl kill ctxtelemetry
        /bin/systemctl is-active -q ctxhdx && /bin/systemctl kill ctxhdx
        if [ -f /etc/systemd/system/ctxlogd.service ]; then
            /bin/systemctl is-active -q ctxlogd && /bin/systemctl kill ctxlogd
        fi
        if [ -f /etc/systemd/system/ad_join.service ]; then
            /bin/systemctl is-active -q ad_join && /bin/systemctl kill ad_join
        fi

        return 0
    }
    cmdlog_exec inner $FUNCNAME "kill $short_name"
}

function service_register {
    function inner {
        /bin/systemctl daemon-reload || return 1
        if [ -f /etc/systemd/system/ctxlogd.service ]; then
            /bin/systemctl enable ctxlogd || return 1
        fi

        /bin/systemctl enable ctxhdx || return 1
        /bin/systemctl enable ctxvda || return 1
        /bin/systemctl enable ctxjproxy || return 1

        /bin/systemctl enable ctxpolicyd || return 1
        /bin/systemctl enable ctxcups
        /bin/systemctl enable cups
        /bin/systemctl enable ctxceip
        /bin/systemctl enable ctxvhcid
        /bin/systemctl enable ctxusbsd
        /bin/systemctl enable ctxtelemetry.socket
        /bin/systemctl enable ctxcdm

        if [ -f /etc/systemd/system/ctxscardsd.service ]; then
             /bin/systemctl enable ctxscardsd || return 1
        fi

        /bin/systemctl enable ctxbcrd
        /bin/systemctl enable ctxmonitorservice
        /bin/systemctl enable ctxrunatboot
        /bin/systemctl enable ctxgdtd
        /bin/systemctl enable ctxwcamsd
        /bin/systemctl enable ctxsdcd
    }
    cmdlog_exec inner $FUNCNAME "register $short_name services"
}

function service_unregister {
    function inner {
        /bin/systemctl daemon-reload || return 1
        /bin/systemctl disable ctxsdcd
        /bin/systemctl disable ctxwcamsd
        /bin/systemctl disable ctxgdtd
        /bin/systemctl disable ctxmonitorservice
        /bin/systemctl disable ctxbcrd
        /bin/systemctl disable ctxcups
        /bin/systemctl disable cups

        /bin/systemctl disable ctxusbsd
        /bin/systemctl disable ctxvhcid
        /bin/systemctl disable ctxceip
        /bin/systemctl disable ctxtelemetry.socket
        /bin/systemctl disable ctxcdm

        /bin/systemctl disable ctxvda || return 1
        /bin/systemctl disable ctxjproxy || return 1
        /bin/systemctl disable ctxhdx || return 1

        /bin/systemctl disable ctxpolicyd || return 1
        if [ -f /etc/systemd/system/ctxlogd.service ]; then
            /bin/systemctl disable ctxlogd || return 1
        fi

        if [ -f /etc/systemd/system/ad_join.service ]; then
            /bin/systemctl disable ad_join || return 1
        fi

        if [ -f /etc/systemd/system/ctxscardsd.service ]; then
             /bin/systemctl disable ctxscardsd || return 1
        fi

    }
    cmdlog_exec inner $FUNCNAME "unregister $short_name services"
}

function firewall_add_rules {
    function inner {
        if /bin/firewall-cmd --state; then
            /bin/firewall-cmd --permanent --zone=public --add-port=$1/tcp || return 1
            /bin/firewall-cmd --permanent --zone=public --add-port=$2/tcp || return 1
            /bin/firewall-cmd --permanent --zone=public --add-port=$3/tcp || return 1
            /bin/firewall-cmd --permanent --zone=public --add-port=1494/tcp || return 1
            /bin/firewall-cmd --permanent --zone=public --add-port=2598/tcp || return 1
            /bin/firewall-cmd --permanent --zone=public --add-port=1494/udp || return 1
            /bin/firewall-cmd --permanent --zone=public --add-port=2598/udp || return 1
            /bin/firewall-cmd --permanent --zone=public --add-port=8008/tcp || return 1
            /bin/firewall-cmd --permanent --zone=public --add-port=6001-6099/tcp || return 1
        else
            return 0
        fi
    }
    cmdlog_exec inner $FUNCNAME "add firewall rules for $short_name" $1 $2 $3
}

function firewall_update_rules {
    function inner {
        if /bin/firewall-cmd --state; then
            /bin/firewall-cmd --permanent --zone=public --add-port=2598/tcp || return 1
            /bin/firewall-cmd --permanent --zone=public --add-port=1494/udp || return 1
            /bin/firewall-cmd --permanent --zone=public --add-port=2598/udp || return 1
            /bin/firewall-cmd --permanent --zone=public --add-port=8008/tcp || return 1
            /bin/firewall-cmd --permanent --zone=public --add-port=6001-6099/tcp || return 1
        else
            return 0
        fi
    }
    cmdlog_exec inner $FUNCNAME "update firewall rules for $short_name" $1
}

function firewall_remove_rules {
    function inner {
        if /bin/firewall-cmd --state; then
            export vda_port=$(printf "%d" $(/opt/Citrix/VDA/bin/ctxreg read -k "HKLM\Software\Citrix\VirtualDesktopAgent" -v "ControllerRegistrarPort")) || return 1
            export telemetry_socket_port=$(grep -oP '(?<=ListenStream=)\d+' /etc/systemd/system/ctxtelemetry.socket) || return 1
            export telemetry_port=$(printf "%d" $(/opt/Citrix/VDA/bin/ctxreg read -k "HKLM\Software\Citrix\VirtualDesktopAgent" -v "TelemetryServicePort")) || return 1

            /bin/firewall-cmd --permanent --zone=public --remove-port=$telemetry_socket_port/tcp || return 1
            /bin/firewall-cmd --permanent --zone=public --remove-port=$telemetry_port/tcp || return 1
            /bin/firewall-cmd --permanent --zone=public --remove-port=$vda_port/tcp || return 1
            /bin/firewall-cmd --permanent --zone=public --remove-port=1494/tcp || return 1
            /bin/firewall-cmd --permanent --zone=public --remove-port=2598/tcp || return 1
            /bin/firewall-cmd --permanent --zone=public --remove-port=1494/udp || return 1
            /bin/firewall-cmd --permanent --zone=public --remove-port=2598/udp || return 1
            /bin/firewall-cmd --permanent --zone=public --remove-port=8008/tcp || return 1
            /bin/firewall-cmd --permanent --zone=public --remove-port=6001-6099/tcp || return 1
        else
            return 0
        fi
    }
    cmdlog_exec inner $FUNCNAME "remove firewall rules for $short_name"
}

function firewall_try_restart {
    function inner {
        if /bin/firewall-cmd --state; then
            /bin/firewall-cmd --reload || return 1
        else
            return 0
        fi
    }
    cmdlog_exec inner $FUNCNAME "restart the firewall"
}

function ctxXrandrhook {
    BEGIN_PATTERN="# Citrix configuration begin"
    MAIN_CONTENT="export LD_PRELOAD='/usr/\$LIB/libctxXrandrhook.so'"
    END_PATTERN="# Citrix congiguration end"
    XCLIENTS="/etc/X11/xinit/Xclients"
    XCLIENTS_ORIG="/etc/X11/xinit/Xclients.orig"
    [ "$#" -ne "1" ] && return 1
    case $1 in
        "configure")
            if [ -f $XCLIENTS ]; then
                [[ ! -f $XCLIENTS_ORIG ]] && cp $XCLIENTS $XCLIENTS_ORIG
                sed -i -e "/$BEGIN_PATTERN/,/$END_PATTERN/d" $XCLIENTS
                awk -v "txt=$BEGIN_PATTERN\n$MAIN_CONTENT\n$END_PATTERN" '/^[^#]/ && !x {print txt; x=1} 1' "$XCLIENTS" > "${XCLIENTS}.tmp" && mv -f "${XCLIENTS}.tmp" "$XCLIENTS" && chmod a+x+r "$XCLIENTS"
            fi
            ;;
        "restore")
            sed -i -e "/$BEGIN_PATTERN/,/$END_PATTERN/d" $XCLIENTS
            ;;
        *)
            ;;
    esac
}
function pcsclibhook {
    PCSC_LIB_NAME="libpcsclite.so.1.0.0"
    PCSC_HOOK_NAME="libctxpcsc.so"
    PCSC_LIB_LINK="libpcsclite.so.1"
    PCSC_LIB_DIR="/usr/lib64"
    PCSC_BAK_DIR="/var/xdl"
    PCSC_HOOK_DIR="/opt/Citrix/VDA/lib64"

    [ "$#" -ne "1" ] && return 1
    case $1 in
        "configure")
            if [ -e $PCSC_LIB_DIR/$PCSC_LIB_NAME ]; then
                mv $PCSC_LIB_DIR/$PCSC_LIB_NAME $PCSC_BAK_DIR/
                ldconfig

                if [ -e $PCSC_LIB_DIR/$PCSC_LIB_LINK ]; then
                    rm -f $PCSC_LIB_DIR/$PCSC_LIB_LINK
                fi

                ln $PCSC_HOOK_DIR/$PCSC_HOOK_NAME -s $PCSC_LIB_DIR/$PCSC_LIB_LINK

            fi
            ;;
        "restore")
            if [ -e $PCSC_BAK_DIR/$PCSC_LIB_NAME ]; then
                mv $PCSC_BAK_DIR/$PCSC_LIB_NAME $PCSC_LIB_DIR/
                ldconfig
            fi
            ;;
        *)
            ;;
    esac

}

function disable_gnome_smartcard_kit {
    ESC_FILE="/etc/xdg/autostart/esc.desktop"
    SCARD_FILE="/etc/xdg/autostart/org.gnome.SettingsDaemon.Smartcard.desktop"

    [ "$#" -ne "1" ] && return 1
    case $1 in
        "configure")
            if [ -f $ESC_FILE ]; then
                sed -i '$a\Hidden=true' $ESC_FILE
            fi

            if [ -f $SCARD_FILE ]; then
                sed -i '$a\Hidden=true' $SCARD_FILE
            fi
            ;;
        "restore")
            if [ -f $ESC_FILE ]; then
                sed -i '/^Hidden=true/d' $ESC_FILE
            fi

            if [ -f $SCARD_FILE ]; then
                sed -i '/^Hidden=true/d' $SCARD_FILE
            fi
            ;;
        *)
            ;;
    esac

}

function link_pam_pkcs11 {
    SRC_FILE="/usr/lib64/security/pam_pkcs11.so"
    LINK_FILE="/usr/lib64/pam_pkcs11.so"

    [ "$#" -ne "1" ] && return 1
    case $1 in
        "configure")
            if [ -f $SRC_FILE ]; then
                if [ ! -e $LINK_FILE ]; then
                    ln $SRC_FILE -s $LINK_FILE
                fi
            fi
            ;;
        "restore")
            if [ -L $LINK_FILE ]; then
                rm -f $LINK_FILE
            fi
            ;;
        *)
            ;;
    esac

}

function mate_session {
    MATE_SESSION='MSESSION="$(type -p mate-session)"'
    GNOME_SESSION='GSESSION="$(type -p gnome-session)"'
    XCLIENTS="/etc/X11/xinit/Xclients"
    XCLIENTS_ORIG="/etc/X11/xinit/Xclients.orig"
    [ "$#" -ne "1" ] && return 1
    case $1 in
        "configure")
            if [ -f $XCLIENTS ]; then
                [ ! -f $XCLIENTS_ORIG ] && cp $XCLIENTS $XCLIENTS_ORIG
                if [ -z "$(grep '^[^#].*type -p mate-session' $XCLIENTS)" ]; then
                    sed -i "/^$GNOME_SESSION/i $MATE_SESSION" $XCLIENTS
                fi
                if [ -z "$(grep '^[^#]' $XCLIENTS | grep 'exec "$MSESSION"')" ]; then
                    sed -i '/^if \[ -n "$GSESSION"/i if [ -n "$MSESSION" ]; then\n    exec "$MSESSION"' $XCLIENTS
                    sed -i 's/^if \[ -n "$GSESSION"/elif \[ -n "$GSESSION"/' $XCLIENTS
                fi
            fi
            ;;
        "restore")
            if [ -f $XCLIENTS_ORIG ]; then
                cp -f $XCLIENTS_ORIG $XCLIENTS
            fi
            ;;
        *)
            ;;
    esac
}

function mate_session_configure {
    function inner {
        mate_session configure
    }
    cmdlog_exec inner $FUNCNAME "mate session configured"
}

function mate_session_restore {
    function inner {
        mate_session restore
    }
    cmdlog_exec inner $FUNCNAME "mate session restored"
}

function desktop_environment_configure {
    function inner {
        ctxXrandrhook configure
        pcsclibhook configure
        disable_gnome_smartcard_kit configure
        link_pam_pkcs11 configure
        cp -f /var/xdl/10-ctx-media-automount.rules /etc/udev/rules.d
        cp -f /var/xdl/50-ctx-persistent-wcam.rules /etc/udev/rules.d
        cp -f /var/xdl/51-ctx-persistent-v4l.rules  /etc/udev/rules.d
        cp -f /usr/lib/systemd/system/systemd-udevd.service /etc/systemd/system/systemd-udevd.service
        sed -i "s/MountFlags/#MountFlags/g" /etc/systemd/system/systemd-udevd.service
        systemctl daemon-reload
        systemctl restart systemd-udevd.service
        cp -f /var/xdl/10-ctxhdx-disable-power-management.rules /usr/share/polkit-1/rules.d || return 1
        cp -f /var/xdl/20-no-show-color-dialog.pkla  /var/lib/polkit-1/localauthority/10-vendor.d/ || return 1
    }
    cmdlog_exec inner $FUNCNAME "desktop environment configured"
}

function desktop_environment_restore {
    function inner {
        ctxXrandrhook restore
        mate_session restore
        pcsclibhook restore
        disable_gnome_smartcard_kit restore
        link_pam_pkcs11 restore
        rm -f /etc/udev/rules.d/10-ctx-media-automount.rules
        rm -f /etc/udev/rules.d/50-ctx-persistent-wcam.rules
        rm -f /etc/udev/rules.d/51-ctx-persistent-v4l.rules
        rm -f /etc/systemd/system/systemd-udevd.service
        systemctl daemon-reload
        systemctl restart systemd-udevd.service
        rm -f /usr/share/polkit-1/rules.d/10-ctxhdx-disable-power-management.rules || return 1
        rm -f /var/lib/polkit-1/localauthority/10-vendor.d/20-no-show-color-dialog.pkla || return 1
    }
    cmdlog_exec inner $FUNCNAME "desktop environment restored"
}

function remove_mcs_config {
    function inner {
        dbus_service_file_path="/usr/lib/systemd/system/dbus.service"
        sed -i -e '/^ExecStartPre=.*$/ d' "$dbus_service_file_path"
    }
    cmdlog_exec inner $FUNCNAME "Remove mcs configurations"
}
