#!/bin/sh

function ldconfig_update {
    function inner {
        /sbin/ldconfig /opt/Citrix/VDA/lib64 || return 1
        /sbin/ldconfig /opt/Citrix/VDA/lib32 || return 1
    }
    cmdlog_exec inner $FUNCNAME "update ldconfig"
}

function postgresql_start {
    function inner {
        /bin/systemctl start postgresql || return 1
    }
    cmdlog_exec inner $FUNCNAME "start PostgreSQL"
}

function postgresql_restart {
    function inner {
        /bin/systemctl restart postgresql || return 1
    }
    cmdlog_exec inner $FUNCNAME "restart PostgreSQL"
}

function service_start {
    function inner {
        /bin/systemctl daemon-reload || return 1
        if [ -f /etc/systemd/system/ctxlogd.service ]; then
            /bin/systemctl start ctxlogd || return 1
        fi
        /bin/systemctl start ctxhdx || return 1
        /bin/systemctl start ctxpolicyd || return 1
        /bin/systemctl start ctxjproxy || return 1
        /bin/systemctl start ctxvda || return 1
        /bin/systemctl start ctxcups
        /bin/systemctl start cups
        /bin/systemctl start ctxcdm
        /bin/systemctl start ctxceip
        /bin/systemctl start ctxvhcid
        /bin/systemctl start ctxusbsd
        /bin/systemctl start ctxtelemetry.socket
        /bin/systemctl start ctxbcrd
        /bin/systemctl start ctxmonitorservice
        /bin/systemctl start ctxgdtd
        /bin/systemctl start ctxwcamsd
        /bin/systemctl start ctxsdcd
    }
    cmdlog_exec inner $FUNCNAME "start $short_name"
}

function service_stop {
    function inner {
        /bin/systemctl daemon-reload || return 1
        /bin/systemctl stop ctxsdcd
        /bin/systemctl stop ctxwcamsd
        /bin/systemctl stop ctxgdtd
        /bin/systemctl stop ctxmonitorservice
        /bin/systemctl stop ctxbcrd
        pkill -f /opt/Citrix/VDA/bin/ctxfm
        /bin/systemctl stop ctxcdm
        /bin/systemctl stop ctxceip
        /bin/systemctl stop ctxcups
        /bin/systemctl stop cups
        /bin/systemctl stop ctxusbsd
        /bin/systemctl stop ctxvhcid
        /bin/systemctl stop ctxtelemetry.socket
        /bin/systemctl stop ctxtelemetry@*.service
        /bin/systemctl stop ctxpolicyd || return 1

        /bin/systemctl stop ctxvda || return 1
        /bin/systemctl stop ctxjproxy || return 1
        /bin/systemctl stop ctxhdx || return 1
        if [ -f /etc/systemd/system/ctxlogd.service ]; then
            /bin/systemctl stop ctxlogd || return 1
        fi
    }
    cmdlog_exec inner $FUNCNAME "stop $short_name"
}

function service_kill {
    function inner {
        /bin/systemctl is-active -q ctxsdcd && /bin/systemctl kill ctxsdcd
        /bin/systemctl is-active -q ctxwcamsd && /bin/systemctl kill ctxwcamsd
        /bin/systemctl is-active -q ctxgdtd && /bin/systemctl kill ctxgdtd
        /bin/systemctl is-active -q ctxmonitorservice && /bin/systemctl kill ctxmonitorservice
        /bin/systemctl is-active -q ctxbcrd && /bin/systemctl kill ctxbcrd
        /bin/systemctl is-active -q ctxvda && /bin/systemctl kill ctxvda
        /bin/systemctl is-active -q ctxjproxy && /bin/systemctl kill ctxjproxy
        /bin/systemctl is-active -q ctxtelemetry && /bin/systemctl kill ctxtelemetry


        /bin/systemctl is-active -q ctxhdx && /bin/systemctl kill ctxhdx
        if [ -f /etc/systemd/system/ctxlogd.service ]; then
            /bin/systemctl is-active -q ctxlogd && /bin/systemctl kill ctxlogd
        fi
        if [ -f /etc/systemd/system/ad_join.service ]; then
            /bin/systemctl is-active -q ad_join && /bin/systemctl kill ad_join
        fi

        return 0
    }
    cmdlog_exec inner $FUNCNAME "kill $short_name"
}

function service_register {
    function inner {
        /bin/systemctl daemon-reload || return 1
        if [ -f /etc/systemd/system/ctxlogd.service ]; then
            /bin/systemctl enable ctxlogd || return 1
        fi
        /bin/systemctl enable ctxhdx || return 1
        /bin/systemctl enable ctxvda || return 1
        /bin/systemctl enable ctxjproxy || return 1

        /bin/systemctl enable ctxpolicyd || return 1
        /bin/systemctl enable ctxcups
        /bin/systemctl enable cups
        /bin/systemctl enable ctxcdm
        /bin/systemctl enable ctxceip
        /bin/systemctl enable ctxvhcid
        /bin/systemctl enable ctxusbsd
        /bin/systemctl enable ctxtelemetry.socket
        /bin/systemctl enable ctxbcrd
        /bin/systemctl enable ctxmonitorservice
        /bin/systemctl enable ctxrunatboot
        /bin/systemctl enable ctxgdtd
        /bin/systemctl enable ctxwcamsd
        /bin/systemctl enable ctxsdcd
    }
    cmdlog_exec inner $FUNCNAME "register $short_name services"
}

function service_unregister {
    function inner {
        /bin/systemctl daemon-reload || return 1
        /bin/systemctl disable ctxsdcd
        /bin/systemctl disable ctxwcamsd
        /bin/systemctl disable ctxgdtd
        /bin/systemctl disable ctxmonitorservice
        /bin/systemctl disable ctxbcrd
        /bin/systemctl disable ctxcups
        /bin/systemctl disable cups
        /bin/systemctl disable ctxusbsd
        /bin/systemctl disable ctxvhcid
        /bin/systemctl disable ctxpolicyd || return 1
        /bin/systemctl disable ctxcdm
        /bin/systemctl disable ctxceip
        /bin/systemctl disable ctxtelemetry.socket

        /bin/systemctl disable ctxvda || return 1
        /bin/systemctl disable ctxjproxy || return 1
        /bin/systemctl disable ctxhdx || return 1
        if [ -f /etc/systemd/system/ctxlogd.service ]; then
            /bin/systemctl disable ctxlogd || return 1
        fi
        if [ -f /etc/systemd/system/ad_join.service ]; then
            /bin/systemctl disable ad_join || return 1
        fi
    }
    cmdlog_exec inner $FUNCNAME "unregister $short_name services"
}

function firewall_add_rules {
    function inner {
        if /sbin/yast2 -l | grep -i firewall 2>&1 >/dev/null
        then
            /sbin/yast2 firewall services add zone=EXT service=service:ctxhdx || return 1
            /sbin/yast2 firewall services add zone=EXT service=service:ctxvda || return 1
            /sbin/yast2 firewall services add zone=EXT tcpport=$2 || return 1
            /sbin/yast2 firewall services add zone=EXT tcpport=$3 || return 1
        fi
    }
    cmdlog_exec inner $FUNCNAME "add firewall rules for $short_name" $1 $2 $3
}

function firewall_update_rules {
    function inner {
        if /sbin/yast2 -l | grep -i firewall 2>&1 >/dev/null
        then
            /sbin/yast2 firewall services add zone=EXT service=service:ctxhdx || return 1
        fi
    }
    cmdlog_exec inner $FUNCNAME "update firewall rules for $short_name" $1
}

function firewall_remove_rules {
    function inner {
        if /sbin/yast2 -l | grep -i firewall 2>&1 >/dev/null
        then
            /sbin/yast2 firewall services remove zone=EXT service=service:ctxhdx || return 1
            /sbin/yast2 firewall services remove zone=EXT service=service:ctxvda || return 1

            export telemetry_socket_port=$(grep -oP '(?<=ListenStream=)\d+' /etc/systemd/system/ctxtelemetry.socket)
            export telemetry_port=$(printf "%d" $(/opt/Citrix/VDA/bin/ctxreg read -k "HKLM\Software\Citrix\VirtualDesktopAgent" -v "TelemetryServicePort"))
            /sbin/yast2 firewall services remove zone=EXT tcpport=$telemetry_socket_port
            /sbin/yast2 firewall services remove zone=EXT tcpport=$telemetry_port
        fi
    }
    cmdlog_exec inner $FUNCNAME "remove firewall rules for $short_name"
}

function firewall_try_restart {
    function inner {
        if [ -e /sbin/SuSEfirewall2 ]
        then
            if [ `/sbin/SuSEfirewall2 status | wc -l` -gt "1" ]; then
                /sbin/SuSEfirewall2 stop || return 1
                /sbin/SuSEfirewall2 start || return 1
            fi
        fi
    }
    cmdlog_exec inner $FUNCNAME "restart the firewall"
}

function ctxXrandrhook {
    BEGIN_PATTERN="# Citrix configuration begin"
    MAIN_CONTENT="export LD_PRELOAD='/usr/\$LIB/libctxXrandrhook.so'"
    END_PATTERN="# Citrix congiguration end"
    XCLIENTS="/etc/X11/xinit/xinitrc"
    XCLIENTS_ORIG="/etc/X11/xinit/xinitrc.orig"
    [ "$#" -ne "1" ] && return 1
    case $1 in
        "configure")
            if [ -f $XCLIENTS ]; then
                [[ ! -f $XCLIENTS_ORIG ]] && cp $XCLIENTS $XCLIENTS_ORIG
                sed -i -e "/$BEGIN_PATTERN/,/$END_PATTERN/d" $XCLIENTS
                awk -v "txt=$BEGIN_PATTERN\n$MAIN_CONTENT\n$END_PATTERN" '/^[^#]/ && !x {print txt; x=1} 1' "$XCLIENTS" > "${XCLIENTS}.tmp" && mv -f "${XCLIENTS}.tmp" "$XCLIENTS" && chmod a+x+r "$XCLIENTS"
            fi
            ;;
        "restore")
            sed -i -e "/$BEGIN_PATTERN/,/$END_PATTERN/d" $XCLIENTS
            ;;
        *)
            ;;
    esac
}

function mate_session_configure {
    return
}

function mate_session_restore {
    return
}

function desktop_environment_configure {
    function inner {
        ctxXrandrhook configure
        cp -f /var/xdl/10-ctx-media-automount.rules /etc/udev/rules.d
        cp -f /var/xdl/50-ctx-persistent-wcam.rules /etc/udev/rules.d
        cp -f /var/xdl/51-ctx-persistent-v4l.rules  /etc/udev/rules.d
        cp -f /var/xdl/10-ctx-usb-disk-mount.rules /usr/share/polkit-1/rules.d
        cp -f /usr/lib/systemd/system/systemd-udevd.service /etc/systemd/system/systemd-udevd.service
        sed -i "s/MountFlags/#MountFlags/g" /etc/systemd/system/systemd-udevd.service
        systemctl daemon-reload
        systemctl restart systemd-udevd.service
        cp -f /var/xdl/10-ctxhdx-disable-power-management.rules /usr/share/polkit-1/rules.d || return 1
    }
    cmdlog_exec inner $FUNCNAME "desktop environment configured"
}

function desktop_environment_restore {
    function inner {
        ctxXrandrhook restore
        rm -f /etc/udev/rules.d/10-ctx-media-automount.rules
        rm -f /etc/udev/rules.d/50-ctx-persistent-wcam.ruless
        rm -f /etc/udev/rules.d/51-ctx-persistent-v4l.ruless
        rm -f /usr/share/polkit-1/rules.d/10-ctx-usb-disk-mount.rules
        rm -f /etc/systemd/system/systemd-udevd.service
        systemctl daemon-reload
        systemctl restart systemd-udevd.service
        rm -f /usr/share/polkit-1/rules.d/10-ctxhdx-disable-power-management.rules || return 1
    }
    cmdlog_exec inner $FUNCNAME "desktop environment restored"
}

function remove_mcs_config {
    function inner {
        dbus_service_file_path="/usr/lib/systemd/system/dbus.service"
        sed -i -e '/^ExecStartPre=.*$/ d' "$dbus_service_file_path"
        cron_job="/etc/cron.d/mcs_update_password_cronjob"
        if [ -f $cron_job ]; then
            rm -f $cron_job
        fi
    }
    cmdlog_exec inner $FUNCNAME "Remove mcs configurations"
}
