#!/bin/bash

###############################################################################
#
# Citrix Virtual Apps & Desktops For Linux Script: Get icon associated with session and window Id
#
# Copyright (c) Citrix Systems, Inc. All Rights Reserved.
#

function usage {
    echo "Usage: $(basename $0) [session_id] [window_id]"
}

function trim {
    echo $(echo "$1" | sed -r 's/^[[:space:]]+|[[:space:]]+$//g')
}

if [ "$#" -ne 2 ]; then
    usage
    exit 1
fi

if [ "$1" = "--help" ]; then
    usage
    exit 0
fi

sid="$1"
wid="$2"

gfxpid=$(ps h -C ctxgfx -o pid,cmd | grep "-session $sid" | awk '{print $1}')
if [ -z "$gfxpid" ]; then
    echo "Session $sid is not found."
    exit 1
fi

dpy=$(ps h -C ctxvfb,Xorg -o ppid,cmd | grep -e "^[[:space:]]*$gfxpid" | sed -r 's/.*(:[[:digit:]]+).*/\1/')
dpy=$(trim "$dpy")
if [ -z "$dpy" ]; then
    echo "Failed to find display for session $SID, ppid $gfxpid."
    exit 1
fi

fpam="/tmp/icon-$wid-$$.pam"
fpng="/tmp/icon-$wid-$$.png"

xprop -id "$wid" -display "$dpy" -notype 32c _NET_WM_ICON | \
    perl -0777 -pe '@_=/\d+/g; printf "P7\nWIDTH %d\nHEIGHT %d\nDEPTH 4\nMAXVAL 255\nTUPLTYPE RGB_ALPHA\nENDHDR\n", splice@_,0,2; $_=pack "N*", @_; s/(.)(...)/$2$1/gs' \
    > "$fpam"

if [[ "$(source /var/xdl/getosinfo.sh -d)" == SUSE* && "$(source /var/xdl/getosinfo.sh -r)" == 11.3* ]]; then
    pamtopnm "$fpam" | pnmtopng - > "$fpng" 2>/dev/null
else
    convert $fpam $fpng 2>/dev/null
fi

rm -rf "$fpam"

if [ -f "$fpng" ]; then
    echo "$fpng"
fi
