#!/usr/bin/env python
import os
import json
import time
import urllib.request, urllib.error, urllib.parse
from urllib.error import HTTPError


GA_COLLECT_SERVER = "https://www.google-analytics.com/collect"
GA_BATCH_SERVER = "https://www.google-analytics.com/batch"
Tracking_ID = "UA-59929653-29"
Filenames = ["/home/summary-2ab6fc51-f453-4c21-bd80-92f0d77468c2.json", "/home/vdaceip-bafed03f-ef3b-4a66-9db2-349b13d8e25e.json"]
LOG_FILE = os.devnull


class UploadError(Exception):
    def __init__(self, error_code, value):
        self.error_code = error_code
        self.value = value
    def __str__(self):
        return "Error code: {0}, {1}".format(self.error_code, self.value)

def post(url, params, headers, data):
    if params is not None:
        u = url + "?" + urllib.parse.urlencode(params)
    request = urllib.request.Request(u, b'data', headers)
    try:
        res = urllib.request.urlopen(request)
        return res
    except HTTPError as err:
        print(err.reason)
        raise UploadError(err.code, err.reason)

def upload_files(tid, url, *args):
    log = open(LOG_FILE, 'a')
    log.write(time.ctime()+'\n')
    result = '' 
    if tid =='' or url =='' or args == []:
        return
    log.write("tid: "+tid+", url: "+url+'\n')
    filenames = []
    filenames.extend(args)

    with open(LOG_FILE, "a") as log:
        log.write("filenames: "+", ".join(filenames)+'\n')
    
        # Distinguish vdaceip-* and sessionceip-* files
        #print filenames
        for filename in filenames:
            # resolve the file and upload the info
            #print filename+'\n'
            try:
                with open(filename, 'r') as f:
                    data = json.load(f)
                ret = ''
                if "vda" in filename:
                    ret = _upload_vda_file(tid,url,data)
                    result+=("\nFILE "+filename+" upload result: "+ret)
                elif "session" in filename:
                    ret = _upload_session_file(tid,url,data)            
                    result+=("\nFILE "+filename+" upload result:\n"+ret)
                elif "summary" in filename:
                    ret = _upload_summary_file(tid,url,data)
                    result+=("\nFILE "+filename+" upload result: "+ret)                 
                else:
                    result+=("\nFILE "+filename+": unexpected filename. Skip!")
            except UploadError as err:
                result+=("\nFILE "+filename+" UploadException: "+(str(err)))
            except IOError as err1:
                result+=("\nFILE "+filename+" IOException: "+(str(err1)))
            except Exception as err2:
                result+=("\nFILE "+filename+" Other Exception: "+(str(err2)))
            log.write('\n'+result+'\n')
    log.close()
    return result

def _upload_vda_file(tid, url, d):
    # Get system info from json
    #print "upload vda file"
    cid = d['machine_guid']
    cpu_cores = str(d['cpu_cores']) if 'cpu_cores' in d else ''
    cpu_frequency= str(d['cpu_frequency']) if 'cpu_frequency' in d else ''
    memory_size = str(d['memory_size']) if 'memory_size' in d else ''
    gpu_type = d['gpu_type'] if 'gpu_type' in d else ''
    os_name_version = d['os_name_version'] if 'os_name_version' in d else ''
    vda_virtualization = d['vda_virtualization'] if 'vda_virtualization' in d else ''
    kernel_version = d['kernel_version'] if 'kernel_version' in d else ''
    ad_solution = d['ad_solution'] if 'ad_solution' in d else '(not set)'
    system_locale = d['system_locale'] if 'system_locale' in d else ''
    # Get vda info from json
    vda_version = d['vda_version'] if 'vda_version' in d else ''
    update_or_fresh_install = d['update_or_fresh_install'] if 'update_or_fresh_install' in d else '(not set)'
    vdi_mode = d['vdi_mode'] if 'vdi_mode' in d else '(not set)'
    bcr = d['bcr'] if 'bcr' in d else ''
    hdx_3d_pro = d['hdx_3d_pro'] if 'hdx_3d_pro' in d else ''
    install_method = d['install_method'] if 'install_method' in d else '(not set)'
    sessions_maximum = str(d['sessions_maximum']) if 'sessions_maximum' in d else ''

    '''
    Data points             | GA format
    -------------------------------------------------------
    machine_guid            | cid
    machine_guid            | ec=system, ea=cid
    cpu_cores               | ec=system, ea=cpu_cores
    cpu_frequency           | ec=system, ea=cpu_frequency
    memory_size             | ec=system, ea=memory_size
    gpu_type                | ec=system, ea=gpu_type
    vda_virtualization      | ec=system, ea=vda_virtualization
    os_name_version         | cd1:os
    kernel_version          | ec=system, ea=kernel_version
    ad_solution             | cd2:ad
    system_locale           | ul
    vda_version             | cd3:lv
    update_or_fresh_install | cd4:it
    vdi_mode                | cd5:vdi
    bcr                     | ec=vda, ea=bcr
    hdx_3d_pro              | ec=vda, ea=hdx_3d_pro
    install_method          | cd6:im
    sessions_maximum        | ec=vda, ea=sessions_maximum
    '''

    # Construct payloads according to Google Analytics Measurement Protocol for different data points
    required_values = "v=1&tid="+tid+"&cid="+cid
    # Some data points are required to be sent as seperate dimensions
    common_values = "&aip=1"+"&cd1="+os_name_version+"&cd2="+ad_solution+"&ul="+system_locale+"&cd3="+vda_version+"&cd4="+update_or_fresh_install+"&cd5="+vdi_mode+"&cd6="+install_method
    # Construct list of events
    events = []
    events.append("&t=event&ec=system&ea=cid&el="+cid)
    events.append("&t=event&ec=system&ea=kernel_version&el="+kernel_version)
    events.append("&t=event&ec=system&ea=cpu_cores&el="+cpu_cores)
    events.append("&t=event&ec=system&ea=cpu_frequency&el="+cpu_frequency)
    events.append("&t=event&ec=system&ea=vda_virtualization&el="+vda_virtualization)
    events.append("&t=event&ec=system&ea=memory_size&el="+memory_size)
    events.append("&t=event&ec=system&ea=gpu_type&el="+gpu_type)
    events.append("&t=event&ec=vda&ea=bcr&el="+bcr)
    events.append("&t=event&ec=vda&ea=hdx_3d_pro&el="+hdx_3d_pro)
    events.append("&t=event&ec=vda&ea=sessions_maximum&el="+sessions_maximum) 

    return _send_to_ga(url, required_values, events, common_values)


def _upload_summary_file(tid, url, d):
    #print "upload summary file"
    cid = d['machine_guid']
    session_launch = str(d['session_launch']) if 'sessions_launch' in d else '0' 
    '''
    Data points             | GA format
    -------------------------------------------------------
    machine_guid            | cid
    session_launch          | ec=session, ea=session_launch, ev=d['session_launch']
    '''

    # Construct payloads according to Google Analytics Measurement Protocol for different data points
    required_values = "v=1&tid="+tid+"&cid="+cid
    # Some data points are required to be sent as seperate dimensions
    common_values = "&aip=1"

    # Construct list of events
    events = [] 
    events.append("&t=event&ec=session&ea=session_launch&el=&ev="+session_launch)
    return _send_to_ga(url, required_values, events, common_values)


def _upload_session_file(tid, url, data):
    #print "upload session file"
    result = ''
    for d in data:
        # Get system info from json
        cid = d['machine_guid']
        session_key = d['session_key'] if 'session_key' in d else '(not set)' 
        os_name_version = d['os_name_version'] if 'os_name_version' in d else '' 
        vda_version = d['vda_version'] if 'vda_version' in d else ''       
        resource_type = d['resource_type'] if 'resource_type' in d else ''
        receiver_type = str(d['receiver_type']) if 'receiver_type' in d else ''
        receiver_version = d['receiver_version'] if 'receiver_version' in d else ''
        gfx_provider_type = d['gfx_provider_type'] if 'gfx_provider_type' in d else ''
        grahpic_video_codec_type = d['grahpic_video_codec_type'] if 'grahpic_video_codec_type' in d else ''
        graphic_slider_value = d.get('graphic_slider_value', '')
        graphic_slider_event = str(d.get('graphic_slider_event', '0'))
        credentials_type = str(d['credentials_type']) if 'credentials_type' in d else ''
        printing_count = str(d['printing_count']) if 'printing_count' in d else '0'
        usb_redirecting_count = str(d['usb_redirecting_count']) if 'usb_redirecting_count' in d else '0'
        shadow_count = str(d['shadow_count']) if 'shadow_count' in d else '0'
        scard_redirecting_count = str(d['scard_redirecting_count']) if 'scard_redirecting_count' in d else '0'
        user_lang = d['user_lang'] if 'user_lang' in d else ''
        ctxism_select = d['ctxism_select'] if 'ctxism_select' in d else ''
        watermark = d.get('watermark', '')
        watermark_transparency = d.get('watermark_transparency', '')
        watermark_custom_text_len = d.get('watermark_custom_text_len', '')
        mtu = d.get('mtu', '')
        mtu_mss = str(d.get('mtu_mss',''))
        filetrans = str(d.get('filetrans',''))
        filetrans_upload_count =  str(d.get('filetrans_upload_count', ''))
        filetrans_download_count = str(d.get('filetrans_download_count', ''))
        # time  unit is second
        session_duration_time = str(d['session_duration_time']) if 'session_duration_time' in d else ''
        active_session_time = list(map(str,d['active_session_time'])) if 'active_session_time' in d else ''
        screensharing_start = str(d.get('screensharing_start', '0'))
        screensharing_accept = str(d.get('screensharing_accept', '0'))
        screensharing_stop = str(d.get('screensharing_stop', '0'))

        '''
        Data points             | GA format
        -------------------------------------------------------
        os_name_version           | cd1:os
        vda_version               | cd3:lv
        session_key               | cd7:sk
        resource_type             | an
        receiver_type             | ec=session, ea=receiver_type
        receiver_version          | ec=session, ea=receiver_version
        gfx_provider_type         | ec=session, ea=gfx_provider_type
        grahpic_video_codec_type  | ec=session, ea=grahpic_video_codec_type
        graphic_slider_value      | ec=session, ea=graphic_slider_value
        graphic_slider_event      | ec=session, ea=graphic_slider_event
        credentials_type          | ec=session, ea=credentials_type
        printing_count            | ec=session, ea=printing_count
        usb_redirecting_count     | ec=session, ea=usb_redirecting_count
        shadow_count              | ec=session, ea=shadow_count
        user_lang                 | ec=session, ea=user_lang
        ctxism_select             | ec=session, ea=ctxism_select
        watermark                 | ec=session, ea=watermark
        watermark_transparency    | ec=session, ea=watermark_transparency
        watermark_custom_text_len | ec=session, ea=watermark_custom_text_len
        mtu                       | ec=session, ea=mtu
        mtu_mss                   | ec=session, ea=mtu_mss
        filetrans                 | ec=session, ea=filetrans
        filetrans_upload_count    | ec=session, ea=filetrans_upload_count
        filetrans_download_count  | ec=session, ea=filetrans_download_count
        session_duration_time     | utc=session, utv=session_duration_time
        active_session_time       | utc=session, utv=active_session_time
        screensharing_start       | ec=session, ea=screensharing_start
        screensharing_accept      | ec=session, ea=screensharing_accept
        screensharing_stop        | ec=session, ea=screensharing_stop

        '''


        # Construct payloads according to Google Analytics Measurement Protocol for different data points
        required_values = "v=1&tid="+tid+"&cid="+cid
        # Some data points are required to be sent as seperate dimensions
        common_values = "&aip=1"+"&cd1="+os_name_version+"&cd3="+vda_version+"&cd7="+session_key+"&an="+resource_type
        # Construct list of event hits
        events = []
        events.append("&t=event&ec=session&ea=receiver_type&el="+receiver_type)
        events.append("&t=event&ec=session&ea=receiver_version&el="+receiver_version)
        events.append("&t=event&ec=session&ea=gfx_provider_type&el="+gfx_provider_type)         
        events.append("&t=event&ec=session&ea=grahpic_video_codec_type&el="+grahpic_video_codec_type)
        events.append("&t=event&ec=session&ea=graphic_slider_value&el="+graphic_slider_value)
        events.append("&t=event&ec=session&ea=graphic_slider_event&el="+graphic_slider_event)
        events.append("&t=event&ec=session&ea=credentials_type&el="+credentials_type)
        events.append("&t=event&ec=session&ea=printing_count&el="+printing_count)
        events.append("&t=event&ec=session&ea=usb_redirecting_count&el="+usb_redirecting_count)
        events.append("&t=event&ec=session&ea=shadow_count&el="+shadow_count)           
        events.append("&t=event&ec=session&ea=scard_redirecting_count&el="+scard_redirecting_count)     
        events.append("&t=event&ec=session&ea=user_lang&el="+user_lang)
        events.append("&t=event&ec=session&ea=ctxism_select&el="+ctxism_select)
        events.append("&t=event&ec=session&ea=watermark&el="+watermark)
        events.append("&t=event&ec=session&ea=watermark_transparency&el="+watermark_transparency)
        events.append("&t=event&ec=session&ea=watermark_custom_text_len&el="+watermark_custom_text_len)
        events.append("&t=event&ec=session&ea=mtu&el="+mtu)
        events.append("&t=event&ec=session&ea=mtu_mss&el="+mtu_mss)
        events.append("&t=event&ec=session&ea=filetrans&el="+filetrans)
        events.append("&t=event&ec=session&ea=filetrans_upload_count&el="+filetrans_upload_count)
        events.append("&t=event&ec=session&ea=filetrans_download_count&el="+filetrans_download_count)
        events.append("&t=event&ec=session&ea=screensharing_start&el="+screensharing_start)
        events.append("&t=event&ec=session&ea=screensharing_accept&el="+screensharing_accept)
        events.append("&t=event&ec=session&ea=screensharing_stop&el="+screensharing_stop)

        # Construct list of timing hits
        timings = []
        timings.append("&t=timing&utc=session&utv=session_duration_time&utl=&utt="+session_duration_time)
        # active_session_time
        timings.append("&t=timing&utc=session&utv=active_session_time&utl=min&utt="+active_session_time[0])
        timings.append("&t=timing&utc=session&utv=active_session_time&utl=max&utt="+active_session_time[1])
        timings.append("&t=timing&utc=session&utv=active_session_time&utl=sum&utt="+active_session_time[2])
        timings.append("&t=timing&utc=session&utv=active_session_time&utl=count&utt="+active_session_time[3])
        timings.append("&t=timing&utc=session&utv=active_session_time&utl=avg&utt="+active_session_time[4])

        ret = _send_to_ga(url, required_values, events+timings, common_values)
        result+=("    SESSION "+session_key+": "+ret+'.\n')
    return result
    
def _send_to_ga(url, required_values, ets, common_values):
    '''
    The Measurement Protocol will return a 2xx status code if the HTTP request was received. 
    The Measurement Protocol does not return an error code if the payload data was malformed, or if the data in the payload was incorrect or was not processed by Google Analytics. 
    If you do not get a 2xx status code, you should NOT retry the request.
    '''
    response = 'success'
    with open(LOG_FILE, "a") as log:
        for et in ets:
            p = required_values+et+common_values
            log.write("Sending:  "+p+'\n')
            r = post(url, None, {}, data = p) 
            log.write("Reason: "+r.reason+'\n')

        #TODO: use GA batch to send multiple payloads at one time

    return response

if __name__ =="__main__":
    upload_files(Tracking_ID,GA_COLLECT_SERVER,*Filenames)
