const Lang = imports.lang;
const Gio = imports.gi.Gio;
const IBusManager = imports.misc.ibusManager;
const InputSourceManager = imports.ui.status.keyboard;

const CtxKeyboard = new Lang.Class({
    Name: 'CtxKeyboard',
    _DESKTOP_INPUT_SOURCES_SCHEMA: 'org.gnome.desktop.input-sources',
    _KEY_CURRENT: 'current',
    _KEY_SOURCES: 'sources',
    _init: function() {
        this._started = false;
        this._ibusReady = false;
        this._sourcesJustChanged = false;
	    this._gotFirstCurrentChange = false;
        this._currentActived = -1;
        this._settings = new Gio.Settings({ schema_id: this._DESKTOP_INPUT_SOURCES_SCHEMA });
        this._settings.connect('changed::' + this._KEY_SOURCES, Lang.bind(this, this._rcvSourcesChanged));
        this._settings.connect('changed::' + this._KEY_CURRENT, Lang.bind(this, this._rcvCurrentChanged));
        this._inputSourceManager = InputSourceManager.getInputSourceManager();
        this._ibusManager = IBusManager.getIBusManager();
        global.log('citrix extension: _init(), _ibusManager: ' + this._ibusManager);
        if(this._ibusManager){
            this._ibusReady = this._ibusManager._ready;
            this._ibusManager.connect('ready', Lang.bind(this, this._ibusReadyCallback));
        }
    },
    _rcvSourcesChanged: function() {
	global.log('citrix extension: input sources changed');
        this._sourcesJustChanged = true;
    },
    _rcvCurrentChanged: function() {
        if(!this._gotFirstCurrentChange){
            this._gotFirstCurrentChange = true;
            global.log('citrix extension: first current change, just return.');
            return;
        }
        let current = this._getCurrent();
        let sources = this._inputSourceManager.inputSources;
        let idx = current.deep_unpack();
        this._currentActived = idx;
        global.log('citrix extension: set current keyboard idx: ' + idx +', ibusReady: ' + this._ibusReady);
        let currentSource = sources[idx];
        global.log('citrix extension: got current source: ' + currentSource);
        if(currentSource){
            currentSource.activate(true);
            if(this._sourcesJustChanged){
                this._inputSourceManager._keyboardManager.reapply();
	            this._sourcesJustChanged = false;
            }
        }
    },

    _ibusReadyCallback: function(im, ready) {
        if (this._ibusReady == ready)
            return;
        this._ibusReady = ready;
        if (!this._ibusReady) {
            return;
        }
        if (this._currentActived != -1) {
            let current = this._getCurrent();
            this._currentActived = current.deep_unpack();
            global.log('citrix extension: the changed message is missed');
        }
        let sources = this._inputSourceManager.inputSources;
        global.log('citrix extension: change current keyboard idx: ' + this._currentActived + ', after ibus ready');
        let currentSource = sources[this._currentActived];
        if(currentSource){
            currentSource.activate(true);
        }
    },

    _getCurrent: function() {
        return this._settings.get_value(this._KEY_CURRENT);
    },

    get started() {
        return this._started;
    },

    set started(value) {
        this._started = value;
    }
});

let module;

function init() {
    global.log("citrix extension: start to init citrix extension");
    module = new CtxKeyboard();
}

function enable() {
    global.log("citrix extension: enable");
    module.started = true;
    module._rcvCurrentChanged();
}

function disable() {
    global.log("citrix extension: disable");
    module.started = false;
}
