#!/usr/bin/env python3
import requests
import json
import base64
import os
import sys
import time
import commands

MAX_RETRY_CNT = 10

class UploadError(Exception):
    def __init__(self, error_code, value):
        self.error_code = error_code
        self.value = value
    def __str__(self):
        return "Error code: {0}, {1}".format(self.error_code, self.value)

def upload_files(pk_key, url, file_name):
    response = u"-1"
    retry_count = 0
    retry = True

    # upload the file and print the progress
    while retry and retry_count <= MAX_RETRY_CNT:
        try:
            response = _upload_whole_file(pk_key, url, file_name)
            retry = False
        except UploadError as err:
            response = u"Exception: {0}".format(str(err))
        except IOError as err1:
            response = u"Exception: {0}".format(str(err1))
        except Exception:
            response = u"Other exception"
            pass
        retry_count += 1
        #retry uploading  after 1 seconds
        if retry_count <= MAX_RETRY_CNT:
            time.sleep(1)

    return response


########################################
#Upload file
#
########################################
def _upload_whole_file(pd_key, url, filename):
    auth_header = {"content-type": "application/json", "Authorization": "PK "+ pd_key}
    with open(filename, "rb") as f:
        fc = f.read()

    bundle_params = {
        "name": os.path.basename(filename)
    }

    bundle_params["size"] = len(fc)

    payload = {}
    ret = requests.post(url + "feeds/api/bundle/", params=bundle_params, headers=auth_header, data=json.dumps(payload))
    if int(ret.status_code) != 200:
        print("Unable to upload file - HTTP return: {0}".format(ret.status_code))
        raise UploadError(ret.status_code, ret.text)

    upload_id = json.loads(ret.text)["id"]

    CHUNK_SIZE = 5 * 1024 * 1024


    offset = 0
    while offset < len(fc):
        this_chunk_length = CHUNK_SIZE if len(fc) >= (offset + CHUNK_SIZE) else len(fc) - offset
        this_chunk = fc[offset:(offset+this_chunk_length)]
        ret = requests.post(url + "feeds/api/upload_chunk/", headers=auth_header, data=json.dumps({"id": upload_id, "offset": offset, "size": this_chunk_length, "data": base64.b64encode(this_chunk)}))
        if int(ret.status_code) != 200:
            raise UploadError(ret.status_code, ret.text)
#        print("bundle upload for chunk offset {}-{}: {}".format(offset, offset + this_chunk_length, json.loads(ret.text)["status"]))
        offset += this_chunk_length
    return upload_id

def main(upload_file):
    print(upload_files("af741355bd454c9086f714fd25a80c635a448e40", "https://rttf.citrix.com/", upload_file))

main(sys.argv[1])
