#!/bin/bash

which nvidia-xconfig
if [ $? != 0 ]; then
    echo "NVIDIA driver is not installed"
    exit 0
fi

trytimes=0

while [ $trytimes -lt 30 ]
do
    busid=$(nvidia-xconfig --query-gpu-info | awk '/PCI BusID/{print $4;exit}')

    if [ -z "$busid" ]
    then
        echo "Try again ..."
        trytimes=`expr $trytimes + 1`
        sleep 1
    else
        echo $busid
        break
    fi
done

nvidia-smi
if [ $? != 0 ]; then
   echo "GPU is probably removed"
   exit 0
fi

if [ -z "$busid" ]; then
    echo "Failed to query the PCI BusID"
    exit 1
fi

sed -i -r "s/BusID.*/BusID \"$busid\"/" /etc/X11/ctx-nvidia-*.conf

# Add the "AutoAddGPU" option if configured
disableAutoAddGPU=$(/opt/Citrix/VDA/bin/ctxreg read -k "HKLM\System\CurrentControlSet\Control\Citrix\Xorg" -v "DisableAutoAddGPU")
confFiles=$(ls /etc/X11/ctx-nvidia-*.conf)
for confFile in $confFiles
do
    serverFlags=$(grep "ServerFlags" ${confFile})
    autoAddGPU=$(grep "AutoAddGPU" ${confFile})
    if [ "$disableAutoAddGPU" = "0x00000001" ];then
        if [ ! -z "$serverFlags" ]; then
            if [ -z "$autoAddGPU" ]; then
                sed -i '/ServerFlags/a\  Option "AutoAddGPU" "false"' ${confFile}
            else
                sed -i '/AutoAddGPU/s/.*/  Option "AutoAddGPU" "false"/' ${confFile}
            fi
        else
            echo "" >> ${confFile}
            echo "Section \"ServerFlags\"" >> ${confFile}
            echo "  Option \"AutoAddGPU\" \"false\"" >> ${confFile}
            echo "EndSection" >> ${confFile}
        fi
    else
        if [ ! -z "$serverFlags" ] && [ ! -z "$autoAddGPU" ]; then
            sed -i '/AutoAddGPU/d' ${confFile}
        fi    
    fi
done
