#!/bin/bash

source /var/xdl/configure_utilities.sh

osPlatform=""           # OS platform,  red, centos, suse, ubuntu
osVersion=""            # OS version
osPatchVersion=""       # OS Patch version
osType=""               # legal value is workstation or server
osMajorVersion=""       # OS major versoin
pkgManagement=""        # which kind of command will be used (apt, yum)

function printSysInfo()
{
    echo "osPlatform=$osPlatform"
    echo "osVersion=$osVersion"
    echo "osPatchVersion=$osPatchVersion"
    echo "osType=$osType"    
    echo "osMajorVersion=$osMajorVersion"   
    echo "pkgManagement=$pkgManagement"
}


main()
{
    if [[ "$1" == "info" ]]; then
        if ! getOSInfo; then
            exit 1
        fi
        printSysInfo
        exit 0
    elif [[ "$1" == "ctxinstall" ]]; then
        /opt/Citrix/VDA/sbin/ctxinstall.sh "${@:2}"
        local result=$?
        exit $result
    fi
}

main "$@"
