#!/bin/bash

###############################################################################
#
# Citrix Virtual Apps & Desktops For Linux Script: Application termination
#
# Copyright (c) Citrix Systems, Inc. All Rights Reserved.
#

function usage {
    echo "Usage: $(basename $0) [session id] [window id]"
}

function trim {
    echo $(echo "$1" | sed -r 's/^[[:space:]]+|[[:space:]]+$//g')
}

if [ "$1" == "--help" ] ; then
    usage
    exit 0
fi

if [ "$#" -ne 2 ]; then
    usage
    exit 1
fi

sid=$1
wid=$2

gfxpid=$(ps h -C ctxgfx -o pid,cmd | grep "-session $sid" | awk '{print $1}')
if [ -z "$gfxpid" ]; then
    echo "Session $sid is not found."
    exit 1
fi

dpy=$(ps h -C ctxvfb,Xorg -o ppid,cmd | grep -e "^[[:space:]]*$gfxpid" | sed -r 's/.*(:[[:digit:]]+).*/\1/')
dpy=$(trim "$dpy")

pid=$(xprop -display "$dpy" -id "$wid" "_NET_WM_PID" | sed -r 's/_NET_WM_PID\(CARDINAL\) = (.*)/\1/')

if [[ ! "$pid" =~ ^[0-9]+$ ]]; then
    echo "Failed to find pid for session $sid, window $wid, display $dpy."
    exit 1
fi

kill -KILL "$pid"
