#!/usr/bin/env bash
#
###############################################################################
#
# Citrix Virtual Apps & Desktops For Linux Script: split ca bundle
#
# Copyright (c) Citrix Systems, Inc. All Rights Reserved.
#
set -euo pipefail

function get_ca_bundle_file()
{
    if [ -f /etc/redhat-release ] || [ -f /etc/centos-release ] || [ -f /etc/rocky-release ]; then
        echo "/etc/ssl/certs/ca-bundle.crt"
        return 0
    elif [ -f /etc/SuSE-release ]; then
        echo "/etc/ssl/ca-bundle.pem"
        return 0
    elif [ -f /etc/debian_version ]; then
        echo "/etc/ssl/certs/ca-certificates.crt"
        return 0
    else
        local os_release="/etc/os-release"
        if [ -f $os_release ]; then
            local os_platform=""
            os_platform="$(< "$os_release" grep ^ID= |cut -d '=' -f2 |tr '[:upper:]' '[:lower:]' |tr -d '"'  2>&1)"
            if [[ "$os_platform" = "sles" || "$os_platform" = "sled" ]]; then
                echo "/etc/ssl/ca-bundle.pem"
                return 0
            fi
        fi
    fi
    return 1
}

keystore_path=/var/xdl/keystore
cacerts_path=${keystore_path}/cacerts
ca_bundle_file="$(get_ca_bundle_file)"

if [ ! -f "${ca_bundle_file}" ]; then
    >&2 echo "bundle file \"${ca_bundle_file}\" not found!"
    exit 1
fi

umask 022
[ -e ${keystore_path} ] || mkdir ${keystore_path}
[ -e ${cacerts_path} ] || mkdir ${cacerts_path}

rm -f $keystore_path/cacerts/*
cd $keystore_path/cacerts
awk 'BEGIN {i=0;} /BEGIN CERT/{i++} { print > "cert." i ".pem" }' < "${ca_bundle_file}"
