#!/bin/sh

find_gnome_do()
{
    for ppid in "$@"; do
        pid=$(pgrep -fP $ppid Do.exe)
        if [ $? -eq 0 ]; then
            echo "$pid"
            return 0
        fi
        pids=$(pgrep -P $ppid)
        if [ $? -eq 0 ]; then
            find_gnome_do $pids
            if [ $? -eq 0 ]; then
                return 0
            fi
        fi
    done
    return 1
}

if [ -z $CITRIX_DISPLAY ]; then
    exit 0
fi

if [ ! -f /usr/bin/gnome-do ]; then
    exit 0
fi

for _ in `seq 1 30`; do
    gnome_do_pid=$(find_gnome_do $PPID)
    if [ $? -eq 0 ]; then
        kill -TERM $gnome_do_pid
        while kill -0 $gnome_do_pid; do
            sleep 1
        done
        /usr/bin/gnome-do --quiet
        break
    fi
    sleep 2
done
