#!/bin/sh

exec 2>/dev/null

for CTXSESSIONSH_PID in $(pgrep ctxsession.sh); do
    FOUND=$(cat /proc/$CTXSESSIONSH_PID/environ |
        xargs -n1 -0 |
        awk -v session_id="$CITRIX_SESSION_ID" '$0 ~ "CITRIX_SESSION_ID="session_id { print "1" }')
    if [ "$FOUND" = 1 ]; then
        DESKTOP_ENVIRONMENT_PID=$(pstree -p $CTXSESSIONSH_PID |
            sed 's/gnome-session\(-b\)\{0,1\}/gnomesession/' |
            sed 's/x-session-manag/xsessionmanag/' |
	        sed 's/xfce4-session/xfce4session/' |
            sed 's/mate-session/matesession/' |
            awk -F "-" '{
                for (i=1; i<NF; i++) {
                    if ($i ~ /startkde|xsessionmanag|xfce4session|matesession|gnomesession/) {
                        print $i
                    }
                }
            }' | awk -F "[()]" '{ print $2 }')
        DBUS_ADDRESS=$(cat /proc/$DESKTOP_ENVIRONMENT_PID/environ |
            xargs -n1 -0 |
            awk '/DBUS_SESSION_BUS_ADDRESS/ { print }')
        export $DBUS_ADDRESS
        break
    fi;
done

# Send a Logout message via dbus. The parameters to Logout are one of the
# following of type uint32:
#
#    0: Normal
#    1: No confirmation inferface should be shown
#    2: Forcefully logout. No confirmation will be shown and any inhibitors
#       will be ignored
#
# The message must only be sent once.

logout_opt=1
if [ $# -eq 1 ] && [ $1 -eq 1 ]
then
    logout_opt=0
fi

dbus-send --session --type=method_call --dest=org.gnome.SessionManager /org/gnome/SessionManager org.gnome.SessionManager.Logout uint32:$logout_opt

# For KDE, we do the same. There are three parameters:
#
# First parameter:
#
#      0: Do not wait for confirmation
#      1: Wait for confirmation, with a 30 second timeout
#
# Second parameter:
#
#     -1: Prompt for action, defaulting to shutdown
#      0: Logout
#      1: Restart
#      2: Shutdown
#
# Third parameter is "when", however it isn't clear how this parameter works.

logout_opt=0
if [ $# -eq 1 ] && [ $1 -eq 1 ]
then
    logout_opt=1
fi

qdbus org.kde.ksmserver /KSMServer logout $logout_opt 0 0


# For XFCE, we need to use xfce4-session-logout:
#
# Parameter:
#
# --logout
#    Log out without displaying the logout dialog.
# --halt
#    Halt without displaing the logout dialog.
# --reboot
#    Reboot without displaying the logout dialog.
# --suspend
#    Suspend without displaying the logout dialog.
# --hibernate
#    Hibernate without displaying the logout dialog.
# --fast
#    Do a fast shutdown. This instructs the session manager not to save the session, but instead to quit everything quickly.
#
#

logout_opt="--logout"
if [ $# -eq 1 ] && [ $1 -eq 1 ]
then
    logout_opt=""
fi

xfce4-session-logout $logout_opt &

# Mate
mate-session-save --force-logout &