#!/bin/bash


################################################################################
#
# XenDesktop For Linux Script: Machine Creation Service
# Copyright (c) Citrix Systems, Inc. All Rights Reserved.
#

source /var/xdl/mcs/mcs_util.sh

fname=$(basename $0)
scriptName=${fname%.*}  # Script name without extension
logFile="/var/log/$scriptName.log"

# Check if its a MCS created machine

if [ ! -f ${id_disk_mnt_point}/PvsVm/CTXSOSID.INI ]; then
    log "WARNING: Not a MCS created machine, exit"
    exit 1
fi

# Check if its enabled
if [ "$UPDATE_MACHINE_PW" != "enabled" ]; then
    log "WARNING: Update machine password disabled, exit"
    exit 1
fi

#
# Update the password with the AD server to a random password
#
log "Change machine account password"
if [ "$AD_INTEGRATION" == "winbind" ]; then
    net ads changetrustpw  1>> "$logFile" 2>&1
elif [ "$AD_INTEGRATION" == "sssd" ]; then
    net ads changetrustpw  1>> "$logFile" 2>&1
elif [ "$AD_INTEGRATION" == "pbis" ]; then
    log "WARNING: Update machine password not supported, exit"
    exit 1
elif [ "$AD_INTEGRATION" == "centrify" ]; then
    PWD=$(date +%s | md5sum | head -c 32)
    adkeytab -C -w "$PWD" --verbose  1>> "$logFile" 2>&1
    read_id_disk_for_machine_pw
    centrify_validate_pwd_chg
fi

ret=$?
if [[ "$?" -ne "0" ]]; then
    log "ERROR: Update machine account password failed!"
    exit 1
fi

#
# Get Domain info from id disk
#
log "Read domain information from identity disk"
read_id_disk_for_machine_pw

#
# Report the new random password, encode it with base64
#
PWORD=$(tdbdump $SAMBA_SECRETS -k "SECRETS/MACHINE_PASSWORD/${WORKGROUP}" | \
    sed -n "s/\(^\S\+\)\\\00$/\1/p")

PWORD_BASE64=$(echo -n "$PWORD" | base64 | sed 's/\//\\\//g')

log "Change machine password inside identity disk"
change_id_disk_setting "MachinePassword" "$PWORD_BASE64"
