// services/device/public/mojom/usb_device.mojom.m.js is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2020 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

import {mojo} from '../../../../mojo/public/js/bindings.js';

import {
  ReadOnlyBuffer as mojoBase_mojom_ReadOnlyBuffer,
  ReadOnlyBufferSpec as mojoBase_mojom_ReadOnlyBufferSpec
} from '../../../../mojo/public/mojom/base/read_only_buffer.mojom.m.js';

import {
  String16 as mojoBase_mojom_String16,
  String16Spec as mojoBase_mojom_String16Spec
} from '../../../../mojo/public/mojom/base/string16.mojom.m.js';

import {
  Url as url_mojom_Url,
  UrlSpec as url_mojom_UrlSpec
} from '../../../../url/mojom/url.mojom.m.js';


/**
 * @const { !number }
 */
export const USB_AUDIO_CLASS = 0x01;


/**
 * @const { !number }
 */
export const USB_HID_CLASS = 0x03;


/**
 * @const { !number }
 */
export const USB_MASS_STORAGE_CLASS = 0x08;


/**
 * @const { !number }
 */
export const USB_SMART_CARD_CLASS = 0x0B;


/**
 * @const { !number }
 */
export const USB_VIDEO_CLASS = 0x0E;


/**
 * @const { !number }
 */
export const USB_AUDIO_VIDEO_CLASS = 0x10;


/**
 * @const { !number }
 */
export const USB_WIRELESS_CLASS = 0xE0;


/**
 * @const { {$: !mojo.internal.MojomType} }
 */
export const UsbOpenDeviceSuccessSpec = { $: mojo.internal.Enum() };

/**
 * @enum {number}
 */
export const UsbOpenDeviceSuccess = {
  
  OK: 0,
  MIN_VALUE: 0,
  MAX_VALUE: 0,
};

/**
 * @const { {$: !mojo.internal.MojomType} }
 */
export const UsbOpenDeviceErrorSpec = { $: mojo.internal.Enum() };

/**
 * @enum {number}
 */
export const UsbOpenDeviceError = {
  
  ACCESS_DENIED: 0,
  ALREADY_OPEN: 1,
  MIN_VALUE: 0,
  MAX_VALUE: 1,
};

/**
 * @const { {$: !mojo.internal.MojomType} }
 */
export const UsbClaimInterfaceResultSpec = { $: mojo.internal.Enum() };

/**
 * @enum {number}
 */
export const UsbClaimInterfaceResult = {
  
  kSuccess: 0,
  kProtectedClass: 1,
  kFailure: 2,
  MIN_VALUE: 0,
  MAX_VALUE: 2,
};

/**
 * @const { {$: !mojo.internal.MojomType} }
 */
export const UsbTransferDirectionSpec = { $: mojo.internal.Enum() };

/**
 * @enum {number}
 */
export const UsbTransferDirection = {
  
  INBOUND: 0,
  OUTBOUND: 1,
  MIN_VALUE: 0,
  MAX_VALUE: 1,
};

/**
 * @const { {$: !mojo.internal.MojomType} }
 */
export const UsbControlTransferTypeSpec = { $: mojo.internal.Enum() };

/**
 * @enum {number}
 */
export const UsbControlTransferType = {
  
  STANDARD: 0,
  CLASS: 1,
  VENDOR: 2,
  RESERVED: 3,
  MIN_VALUE: 0,
  MAX_VALUE: 3,
};

/**
 * @const { {$: !mojo.internal.MojomType} }
 */
export const UsbControlTransferRecipientSpec = { $: mojo.internal.Enum() };

/**
 * @enum {number}
 */
export const UsbControlTransferRecipient = {
  
  DEVICE: 0,
  INTERFACE: 1,
  ENDPOINT: 2,
  OTHER: 3,
  MIN_VALUE: 0,
  MAX_VALUE: 3,
};

/**
 * @const { {$: !mojo.internal.MojomType} }
 */
export const UsbTransferTypeSpec = { $: mojo.internal.Enum() };

/**
 * @enum {number}
 */
export const UsbTransferType = {
  
  CONTROL: 0,
  ISOCHRONOUS: 1,
  BULK: 2,
  INTERRUPT: 3,
  MIN_VALUE: 0,
  MAX_VALUE: 3,
};

/**
 * @const { {$: !mojo.internal.MojomType} }
 */
export const UsbSynchronizationTypeSpec = { $: mojo.internal.Enum() };

/**
 * @enum {number}
 */
export const UsbSynchronizationType = {
  
  NONE: 0,
  ASYNCHRONOUS: 1,
  ADAPTIVE: 2,
  SYNCHRONOUS: 3,
  MIN_VALUE: 0,
  MAX_VALUE: 3,
};

/**
 * @const { {$: !mojo.internal.MojomType} }
 */
export const UsbUsageTypeSpec = { $: mojo.internal.Enum() };

/**
 * @enum {number}
 */
export const UsbUsageType = {
  
  DATA: 0,
  FEEDBACK: 1,
  EXPLICIT_FEEDBACK: 2,
  PERIODIC: 3,
  NOTIFICATION: 4,
  RESERVED: 5,
  MIN_VALUE: 0,
  MAX_VALUE: 5,
};

/**
 * @const { {$: !mojo.internal.MojomType} }
 */
export const UsbTransferStatusSpec = { $: mojo.internal.Enum() };

/**
 * @enum {number}
 */
export const UsbTransferStatus = {
  
  COMPLETED: 0,
  TRANSFER_ERROR: 1,
  TIMEOUT: 2,
  CANCELLED: 3,
  STALLED: 4,
  DISCONNECT: 5,
  BABBLE: 6,
  SHORT_PACKET: 7,
  PERMISSION_DENIED: 8,
  MIN_VALUE: 0,
  MAX_VALUE: 8,
};



/**
 * @implements {mojo.internal.interfaceSupport.PendingReceiver}
 */
export class UsbDevicePendingReceiver {
  /**
   * @param {!MojoHandle|!mojo.internal.interfaceSupport.Endpoint} handle
   */
  constructor(handle) {
    /** @public {!mojo.internal.interfaceSupport.Endpoint} */
    this.handle = mojo.internal.interfaceSupport.getEndpointForReceiver(handle);
  }

  /** @param {string=} scope */
  bindInBrowser(scope = 'context') {
    mojo.internal.interfaceSupport.bind(
        this.handle, 'device.mojom.UsbDevice', scope);
  }
}

/** @interface */
export class UsbDeviceInterface {
  
  /**
   * @return {!Promise<{
        result: !UsbOpenDeviceResult,
   *  }>}
   */

  open() {}
  
  /**
   * @return {!Promise}
   */

  close() {}
  
  /**
   * @param { !number } value
   * @return {!Promise<{
        success: !boolean,
   *  }>}
   */

  setConfiguration(value) {}
  
  /**
   * @param { !number } interfaceNumber
   * @return {!Promise<{
        result: !UsbClaimInterfaceResult,
   *  }>}
   */

  claimInterface(interfaceNumber) {}
  
  /**
   * @param { !number } interfaceNumber
   * @return {!Promise<{
        success: !boolean,
   *  }>}
   */

  releaseInterface(interfaceNumber) {}
  
  /**
   * @param { !number } interfaceNumber
   * @param { !number } alternateSetting
   * @return {!Promise<{
        success: !boolean,
   *  }>}
   */

  setInterfaceAlternateSetting(interfaceNumber, alternateSetting) {}
  
  /**
   * @return {!Promise<{
        success: !boolean,
   *  }>}
   */

  reset() {}
  
  /**
   * @param { !UsbTransferDirection } direction
   * @param { !number } endpointNumber
   * @return {!Promise<{
        success: !boolean,
   *  }>}
   */

  clearHalt(direction, endpointNumber) {}
  
  /**
   * @param { !UsbControlTransferParams } params
   * @param { !number } length
   * @param { !number } timeout
   * @return {!Promise<{
        status: !UsbTransferStatus,
        data: !mojoBase_mojom_ReadOnlyBuffer,
   *  }>}
   */

  controlTransferIn(params, length, timeout) {}
  
  /**
   * @param { !UsbControlTransferParams } params
   * @param { !mojoBase_mojom_ReadOnlyBuffer } data
   * @param { !number } timeout
   * @return {!Promise<{
        status: !UsbTransferStatus,
   *  }>}
   */

  controlTransferOut(params, data, timeout) {}
  
  /**
   * @param { !number } endpointNumber
   * @param { !number } length
   * @param { !number } timeout
   * @return {!Promise<{
        status: !UsbTransferStatus,
        data: !mojoBase_mojom_ReadOnlyBuffer,
   *  }>}
   */

  genericTransferIn(endpointNumber, length, timeout) {}
  
  /**
   * @param { !number } endpointNumber
   * @param { !mojoBase_mojom_ReadOnlyBuffer } data
   * @param { !number } timeout
   * @return {!Promise<{
        status: !UsbTransferStatus,
   *  }>}
   */

  genericTransferOut(endpointNumber, data, timeout) {}
  
  /**
   * @param { !number } endpointNumber
   * @param { !Array<!number> } packetLengths
   * @param { !number } timeout
   * @return {!Promise<{
        data: !mojoBase_mojom_ReadOnlyBuffer,
        packets: !Array<!UsbIsochronousPacket>,
   *  }>}
   */

  isochronousTransferIn(endpointNumber, packetLengths, timeout) {}
  
  /**
   * @param { !number } endpointNumber
   * @param { !mojoBase_mojom_ReadOnlyBuffer } data
   * @param { !Array<!number> } packetLengths
   * @param { !number } timeout
   * @return {!Promise<{
        packets: !Array<!UsbIsochronousPacket>,
   *  }>}
   */

  isochronousTransferOut(endpointNumber, data, packetLengths, timeout) {}
}

/**
 * @implements { UsbDeviceInterface }
 */
export class UsbDeviceRemote {
  /** @param {MojoHandle|mojo.internal.interfaceSupport.Endpoint=} handle */
  constructor(handle = undefined) {
    /**
     * @private {!mojo.internal.interfaceSupport.InterfaceRemoteBase<!UsbDevicePendingReceiver>}
     */
    this.proxy =
        new mojo.internal.interfaceSupport.InterfaceRemoteBase(
          UsbDevicePendingReceiver,
          handle);

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceRemoteBaseWrapper<!UsbDevicePendingReceiver>}
     */
    this.$ = new mojo.internal.interfaceSupport.InterfaceRemoteBaseWrapper(this.proxy);

    /** @public {!mojo.internal.interfaceSupport.ConnectionErrorEventRouter} */
    this.onConnectionError = this.proxy.getConnectionErrorEventRouter();
  }

  
  /**
   * @return {!Promise<{
        result: !UsbOpenDeviceResult,
   *  }>}
   */

  open() {
    return this.proxy.sendMessage(
        0,
        UsbDevice_Open_ParamsSpec.$,
        UsbDevice_Open_ResponseParamsSpec.$,
        [
        ]);
  }

  
  /**
   * @return {!Promise}
   */

  close() {
    return this.proxy.sendMessage(
        1,
        UsbDevice_Close_ParamsSpec.$,
        UsbDevice_Close_ResponseParamsSpec.$,
        [
        ]);
  }

  
  /**
   * @param { !number } value
   * @return {!Promise<{
        success: !boolean,
   *  }>}
   */

  setConfiguration(
      value) {
    return this.proxy.sendMessage(
        2,
        UsbDevice_SetConfiguration_ParamsSpec.$,
        UsbDevice_SetConfiguration_ResponseParamsSpec.$,
        [
          value
        ]);
  }

  
  /**
   * @param { !number } interfaceNumber
   * @return {!Promise<{
        result: !UsbClaimInterfaceResult,
   *  }>}
   */

  claimInterface(
      interfaceNumber) {
    return this.proxy.sendMessage(
        3,
        UsbDevice_ClaimInterface_ParamsSpec.$,
        UsbDevice_ClaimInterface_ResponseParamsSpec.$,
        [
          interfaceNumber
        ]);
  }

  
  /**
   * @param { !number } interfaceNumber
   * @return {!Promise<{
        success: !boolean,
   *  }>}
   */

  releaseInterface(
      interfaceNumber) {
    return this.proxy.sendMessage(
        4,
        UsbDevice_ReleaseInterface_ParamsSpec.$,
        UsbDevice_ReleaseInterface_ResponseParamsSpec.$,
        [
          interfaceNumber
        ]);
  }

  
  /**
   * @param { !number } interfaceNumber
   * @param { !number } alternateSetting
   * @return {!Promise<{
        success: !boolean,
   *  }>}
   */

  setInterfaceAlternateSetting(
      interfaceNumber,
      alternateSetting) {
    return this.proxy.sendMessage(
        5,
        UsbDevice_SetInterfaceAlternateSetting_ParamsSpec.$,
        UsbDevice_SetInterfaceAlternateSetting_ResponseParamsSpec.$,
        [
          interfaceNumber,
          alternateSetting
        ]);
  }

  
  /**
   * @return {!Promise<{
        success: !boolean,
   *  }>}
   */

  reset() {
    return this.proxy.sendMessage(
        6,
        UsbDevice_Reset_ParamsSpec.$,
        UsbDevice_Reset_ResponseParamsSpec.$,
        [
        ]);
  }

  
  /**
   * @param { !UsbTransferDirection } direction
   * @param { !number } endpointNumber
   * @return {!Promise<{
        success: !boolean,
   *  }>}
   */

  clearHalt(
      direction,
      endpointNumber) {
    return this.proxy.sendMessage(
        7,
        UsbDevice_ClearHalt_ParamsSpec.$,
        UsbDevice_ClearHalt_ResponseParamsSpec.$,
        [
          direction,
          endpointNumber
        ]);
  }

  
  /**
   * @param { !UsbControlTransferParams } params
   * @param { !number } length
   * @param { !number } timeout
   * @return {!Promise<{
        status: !UsbTransferStatus,
        data: !mojoBase_mojom_ReadOnlyBuffer,
   *  }>}
   */

  controlTransferIn(
      params,
      length,
      timeout) {
    return this.proxy.sendMessage(
        8,
        UsbDevice_ControlTransferIn_ParamsSpec.$,
        UsbDevice_ControlTransferIn_ResponseParamsSpec.$,
        [
          params,
          length,
          timeout
        ]);
  }

  
  /**
   * @param { !UsbControlTransferParams } params
   * @param { !mojoBase_mojom_ReadOnlyBuffer } data
   * @param { !number } timeout
   * @return {!Promise<{
        status: !UsbTransferStatus,
   *  }>}
   */

  controlTransferOut(
      params,
      data,
      timeout) {
    return this.proxy.sendMessage(
        9,
        UsbDevice_ControlTransferOut_ParamsSpec.$,
        UsbDevice_ControlTransferOut_ResponseParamsSpec.$,
        [
          params,
          data,
          timeout
        ]);
  }

  
  /**
   * @param { !number } endpointNumber
   * @param { !number } length
   * @param { !number } timeout
   * @return {!Promise<{
        status: !UsbTransferStatus,
        data: !mojoBase_mojom_ReadOnlyBuffer,
   *  }>}
   */

  genericTransferIn(
      endpointNumber,
      length,
      timeout) {
    return this.proxy.sendMessage(
        10,
        UsbDevice_GenericTransferIn_ParamsSpec.$,
        UsbDevice_GenericTransferIn_ResponseParamsSpec.$,
        [
          endpointNumber,
          length,
          timeout
        ]);
  }

  
  /**
   * @param { !number } endpointNumber
   * @param { !mojoBase_mojom_ReadOnlyBuffer } data
   * @param { !number } timeout
   * @return {!Promise<{
        status: !UsbTransferStatus,
   *  }>}
   */

  genericTransferOut(
      endpointNumber,
      data,
      timeout) {
    return this.proxy.sendMessage(
        11,
        UsbDevice_GenericTransferOut_ParamsSpec.$,
        UsbDevice_GenericTransferOut_ResponseParamsSpec.$,
        [
          endpointNumber,
          data,
          timeout
        ]);
  }

  
  /**
   * @param { !number } endpointNumber
   * @param { !Array<!number> } packetLengths
   * @param { !number } timeout
   * @return {!Promise<{
        data: !mojoBase_mojom_ReadOnlyBuffer,
        packets: !Array<!UsbIsochronousPacket>,
   *  }>}
   */

  isochronousTransferIn(
      endpointNumber,
      packetLengths,
      timeout) {
    return this.proxy.sendMessage(
        12,
        UsbDevice_IsochronousTransferIn_ParamsSpec.$,
        UsbDevice_IsochronousTransferIn_ResponseParamsSpec.$,
        [
          endpointNumber,
          packetLengths,
          timeout
        ]);
  }

  
  /**
   * @param { !number } endpointNumber
   * @param { !mojoBase_mojom_ReadOnlyBuffer } data
   * @param { !Array<!number> } packetLengths
   * @param { !number } timeout
   * @return {!Promise<{
        packets: !Array<!UsbIsochronousPacket>,
   *  }>}
   */

  isochronousTransferOut(
      endpointNumber,
      data,
      packetLengths,
      timeout) {
    return this.proxy.sendMessage(
        13,
        UsbDevice_IsochronousTransferOut_ParamsSpec.$,
        UsbDevice_IsochronousTransferOut_ResponseParamsSpec.$,
        [
          endpointNumber,
          data,
          packetLengths,
          timeout
        ]);
  }
}

/**
 * An object which receives request messages for the UsbDevice
 * mojom interface. Must be constructed over an object which implements that
 * interface.
 */
export class UsbDeviceReceiver {
  /**
   * @param {!UsbDeviceInterface } impl
   */
  constructor(impl) {
    /** @private {!mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal<!UsbDeviceRemote>} */
    this.helper_internal_ = new mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal(
        UsbDeviceRemote);

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceReceiverHelper<!UsbDeviceRemote>}
     */
    this.$ = new mojo.internal.interfaceSupport.InterfaceReceiverHelper(this.helper_internal_);


    this.helper_internal_.registerHandler(
        0,
        UsbDevice_Open_ParamsSpec.$,
        UsbDevice_Open_ResponseParamsSpec.$,
        impl.open.bind(impl));
    this.helper_internal_.registerHandler(
        1,
        UsbDevice_Close_ParamsSpec.$,
        UsbDevice_Close_ResponseParamsSpec.$,
        impl.close.bind(impl));
    this.helper_internal_.registerHandler(
        2,
        UsbDevice_SetConfiguration_ParamsSpec.$,
        UsbDevice_SetConfiguration_ResponseParamsSpec.$,
        impl.setConfiguration.bind(impl));
    this.helper_internal_.registerHandler(
        3,
        UsbDevice_ClaimInterface_ParamsSpec.$,
        UsbDevice_ClaimInterface_ResponseParamsSpec.$,
        impl.claimInterface.bind(impl));
    this.helper_internal_.registerHandler(
        4,
        UsbDevice_ReleaseInterface_ParamsSpec.$,
        UsbDevice_ReleaseInterface_ResponseParamsSpec.$,
        impl.releaseInterface.bind(impl));
    this.helper_internal_.registerHandler(
        5,
        UsbDevice_SetInterfaceAlternateSetting_ParamsSpec.$,
        UsbDevice_SetInterfaceAlternateSetting_ResponseParamsSpec.$,
        impl.setInterfaceAlternateSetting.bind(impl));
    this.helper_internal_.registerHandler(
        6,
        UsbDevice_Reset_ParamsSpec.$,
        UsbDevice_Reset_ResponseParamsSpec.$,
        impl.reset.bind(impl));
    this.helper_internal_.registerHandler(
        7,
        UsbDevice_ClearHalt_ParamsSpec.$,
        UsbDevice_ClearHalt_ResponseParamsSpec.$,
        impl.clearHalt.bind(impl));
    this.helper_internal_.registerHandler(
        8,
        UsbDevice_ControlTransferIn_ParamsSpec.$,
        UsbDevice_ControlTransferIn_ResponseParamsSpec.$,
        impl.controlTransferIn.bind(impl));
    this.helper_internal_.registerHandler(
        9,
        UsbDevice_ControlTransferOut_ParamsSpec.$,
        UsbDevice_ControlTransferOut_ResponseParamsSpec.$,
        impl.controlTransferOut.bind(impl));
    this.helper_internal_.registerHandler(
        10,
        UsbDevice_GenericTransferIn_ParamsSpec.$,
        UsbDevice_GenericTransferIn_ResponseParamsSpec.$,
        impl.genericTransferIn.bind(impl));
    this.helper_internal_.registerHandler(
        11,
        UsbDevice_GenericTransferOut_ParamsSpec.$,
        UsbDevice_GenericTransferOut_ResponseParamsSpec.$,
        impl.genericTransferOut.bind(impl));
    this.helper_internal_.registerHandler(
        12,
        UsbDevice_IsochronousTransferIn_ParamsSpec.$,
        UsbDevice_IsochronousTransferIn_ResponseParamsSpec.$,
        impl.isochronousTransferIn.bind(impl));
    this.helper_internal_.registerHandler(
        13,
        UsbDevice_IsochronousTransferOut_ParamsSpec.$,
        UsbDevice_IsochronousTransferOut_ResponseParamsSpec.$,
        impl.isochronousTransferOut.bind(impl));
    /** @public {!mojo.internal.interfaceSupport.ConnectionErrorEventRouter} */
    this.onConnectionError = this.helper_internal_.getConnectionErrorEventRouter();
  }
}

export class UsbDevice {
  /**
   * @return {!string}
   */
  static get $interfaceName() {
    return "device.mojom.UsbDevice";
  }

  /**
   * Returns a remote for this interface which sends messages to the browser.
   * The browser must have an interface request binder registered for this
   * interface and accessible to the calling document's frame.
   *
   * @return {!UsbDeviceRemote}
   */
  static getRemote() {
    let remote = new UsbDeviceRemote;
    remote.$.bindNewPipeAndPassReceiver().bindInBrowser();
    return remote;
  }
}


/**
 * An object which receives request messages for the UsbDevice
 * mojom interface and dispatches them as callbacks. One callback receiver exists
 * on this object for each message defined in the mojom interface, and each
 * receiver can have any number of listeners added to it.
 */
export class UsbDeviceCallbackRouter {
  constructor() {
    this.helper_internal_ = new mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal(
      UsbDeviceRemote);

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceReceiverHelper<!UsbDeviceRemote>}
     */
    this.$ = new mojo.internal.interfaceSupport.InterfaceReceiverHelper(this.helper_internal_);

    this.router_ = new mojo.internal.interfaceSupport.CallbackRouter;

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.open =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        0,
        UsbDevice_Open_ParamsSpec.$,
        UsbDevice_Open_ResponseParamsSpec.$,
        this.open.createReceiverHandler(true /* expectsResponse */));
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.close =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        1,
        UsbDevice_Close_ParamsSpec.$,
        UsbDevice_Close_ResponseParamsSpec.$,
        this.close.createReceiverHandler(true /* expectsResponse */));
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.setConfiguration =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        2,
        UsbDevice_SetConfiguration_ParamsSpec.$,
        UsbDevice_SetConfiguration_ResponseParamsSpec.$,
        this.setConfiguration.createReceiverHandler(true /* expectsResponse */));
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.claimInterface =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        3,
        UsbDevice_ClaimInterface_ParamsSpec.$,
        UsbDevice_ClaimInterface_ResponseParamsSpec.$,
        this.claimInterface.createReceiverHandler(true /* expectsResponse */));
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.releaseInterface =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        4,
        UsbDevice_ReleaseInterface_ParamsSpec.$,
        UsbDevice_ReleaseInterface_ResponseParamsSpec.$,
        this.releaseInterface.createReceiverHandler(true /* expectsResponse */));
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.setInterfaceAlternateSetting =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        5,
        UsbDevice_SetInterfaceAlternateSetting_ParamsSpec.$,
        UsbDevice_SetInterfaceAlternateSetting_ResponseParamsSpec.$,
        this.setInterfaceAlternateSetting.createReceiverHandler(true /* expectsResponse */));
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.reset =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        6,
        UsbDevice_Reset_ParamsSpec.$,
        UsbDevice_Reset_ResponseParamsSpec.$,
        this.reset.createReceiverHandler(true /* expectsResponse */));
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.clearHalt =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        7,
        UsbDevice_ClearHalt_ParamsSpec.$,
        UsbDevice_ClearHalt_ResponseParamsSpec.$,
        this.clearHalt.createReceiverHandler(true /* expectsResponse */));
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.controlTransferIn =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        8,
        UsbDevice_ControlTransferIn_ParamsSpec.$,
        UsbDevice_ControlTransferIn_ResponseParamsSpec.$,
        this.controlTransferIn.createReceiverHandler(true /* expectsResponse */));
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.controlTransferOut =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        9,
        UsbDevice_ControlTransferOut_ParamsSpec.$,
        UsbDevice_ControlTransferOut_ResponseParamsSpec.$,
        this.controlTransferOut.createReceiverHandler(true /* expectsResponse */));
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.genericTransferIn =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        10,
        UsbDevice_GenericTransferIn_ParamsSpec.$,
        UsbDevice_GenericTransferIn_ResponseParamsSpec.$,
        this.genericTransferIn.createReceiverHandler(true /* expectsResponse */));
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.genericTransferOut =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        11,
        UsbDevice_GenericTransferOut_ParamsSpec.$,
        UsbDevice_GenericTransferOut_ResponseParamsSpec.$,
        this.genericTransferOut.createReceiverHandler(true /* expectsResponse */));
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.isochronousTransferIn =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        12,
        UsbDevice_IsochronousTransferIn_ParamsSpec.$,
        UsbDevice_IsochronousTransferIn_ResponseParamsSpec.$,
        this.isochronousTransferIn.createReceiverHandler(true /* expectsResponse */));
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.isochronousTransferOut =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        13,
        UsbDevice_IsochronousTransferOut_ParamsSpec.$,
        UsbDevice_IsochronousTransferOut_ResponseParamsSpec.$,
        this.isochronousTransferOut.createReceiverHandler(true /* expectsResponse */));
    /** @public {!mojo.internal.interfaceSupport.ConnectionErrorEventRouter} */
    this.onConnectionError = this.helper_internal_.getConnectionErrorEventRouter();
  }

  /**
   * @param {number} id An ID returned by a prior call to addListener.
   * @return {boolean} True iff the identified listener was found and removed.
   */
  removeListener(id) {
    return this.router_.removeListener(id);
  }
}


/**
 * @implements {mojo.internal.interfaceSupport.PendingReceiver}
 */
export class UsbDeviceClientPendingReceiver {
  /**
   * @param {!MojoHandle|!mojo.internal.interfaceSupport.Endpoint} handle
   */
  constructor(handle) {
    /** @public {!mojo.internal.interfaceSupport.Endpoint} */
    this.handle = mojo.internal.interfaceSupport.getEndpointForReceiver(handle);
  }

  /** @param {string=} scope */
  bindInBrowser(scope = 'context') {
    mojo.internal.interfaceSupport.bind(
        this.handle, 'device.mojom.UsbDeviceClient', scope);
  }
}

/** @interface */
export class UsbDeviceClientInterface {
  
  /**
   */

  onDeviceOpened() {}
  
  /**
   */

  onDeviceClosed() {}
}

/**
 * @implements { UsbDeviceClientInterface }
 */
export class UsbDeviceClientRemote {
  /** @param {MojoHandle|mojo.internal.interfaceSupport.Endpoint=} handle */
  constructor(handle = undefined) {
    /**
     * @private {!mojo.internal.interfaceSupport.InterfaceRemoteBase<!UsbDeviceClientPendingReceiver>}
     */
    this.proxy =
        new mojo.internal.interfaceSupport.InterfaceRemoteBase(
          UsbDeviceClientPendingReceiver,
          handle);

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceRemoteBaseWrapper<!UsbDeviceClientPendingReceiver>}
     */
    this.$ = new mojo.internal.interfaceSupport.InterfaceRemoteBaseWrapper(this.proxy);

    /** @public {!mojo.internal.interfaceSupport.ConnectionErrorEventRouter} */
    this.onConnectionError = this.proxy.getConnectionErrorEventRouter();
  }

  
  /**
   */

  onDeviceOpened() {
    this.proxy.sendMessage(
        0,
        UsbDeviceClient_OnDeviceOpened_ParamsSpec.$,
        null,
        [
        ]);
  }

  
  /**
   */

  onDeviceClosed() {
    this.proxy.sendMessage(
        1,
        UsbDeviceClient_OnDeviceClosed_ParamsSpec.$,
        null,
        [
        ]);
  }
}

/**
 * An object which receives request messages for the UsbDeviceClient
 * mojom interface. Must be constructed over an object which implements that
 * interface.
 */
export class UsbDeviceClientReceiver {
  /**
   * @param {!UsbDeviceClientInterface } impl
   */
  constructor(impl) {
    /** @private {!mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal<!UsbDeviceClientRemote>} */
    this.helper_internal_ = new mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal(
        UsbDeviceClientRemote);

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceReceiverHelper<!UsbDeviceClientRemote>}
     */
    this.$ = new mojo.internal.interfaceSupport.InterfaceReceiverHelper(this.helper_internal_);


    this.helper_internal_.registerHandler(
        0,
        UsbDeviceClient_OnDeviceOpened_ParamsSpec.$,
        null,
        impl.onDeviceOpened.bind(impl));
    this.helper_internal_.registerHandler(
        1,
        UsbDeviceClient_OnDeviceClosed_ParamsSpec.$,
        null,
        impl.onDeviceClosed.bind(impl));
    /** @public {!mojo.internal.interfaceSupport.ConnectionErrorEventRouter} */
    this.onConnectionError = this.helper_internal_.getConnectionErrorEventRouter();
  }
}

export class UsbDeviceClient {
  /**
   * @return {!string}
   */
  static get $interfaceName() {
    return "device.mojom.UsbDeviceClient";
  }

  /**
   * Returns a remote for this interface which sends messages to the browser.
   * The browser must have an interface request binder registered for this
   * interface and accessible to the calling document's frame.
   *
   * @return {!UsbDeviceClientRemote}
   */
  static getRemote() {
    let remote = new UsbDeviceClientRemote;
    remote.$.bindNewPipeAndPassReceiver().bindInBrowser();
    return remote;
  }
}


/**
 * An object which receives request messages for the UsbDeviceClient
 * mojom interface and dispatches them as callbacks. One callback receiver exists
 * on this object for each message defined in the mojom interface, and each
 * receiver can have any number of listeners added to it.
 */
export class UsbDeviceClientCallbackRouter {
  constructor() {
    this.helper_internal_ = new mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal(
      UsbDeviceClientRemote);

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceReceiverHelper<!UsbDeviceClientRemote>}
     */
    this.$ = new mojo.internal.interfaceSupport.InterfaceReceiverHelper(this.helper_internal_);

    this.router_ = new mojo.internal.interfaceSupport.CallbackRouter;

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.onDeviceOpened =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        0,
        UsbDeviceClient_OnDeviceOpened_ParamsSpec.$,
        null,
        this.onDeviceOpened.createReceiverHandler(false /* expectsResponse */));
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.onDeviceClosed =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        1,
        UsbDeviceClient_OnDeviceClosed_ParamsSpec.$,
        null,
        this.onDeviceClosed.createReceiverHandler(false /* expectsResponse */));
    /** @public {!mojo.internal.interfaceSupport.ConnectionErrorEventRouter} */
    this.onConnectionError = this.helper_internal_.getConnectionErrorEventRouter();
  }

  /**
   * @param {number} id An ID returned by a prior call to addListener.
   * @return {boolean} True iff the identified listener was found and removed.
   */
  removeListener(id) {
    return this.router_.removeListener(id);
  }
}

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const UsbEndpointInfoSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const UsbAlternateInterfaceInfoSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const UsbInterfaceInfoSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const UsbConfigurationInfoSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const UsbDeviceInfoSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const UsbControlTransferParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const UsbIsochronousPacketSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const UsbDevice_Open_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const UsbDevice_Open_ResponseParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const UsbDevice_Close_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const UsbDevice_Close_ResponseParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const UsbDevice_SetConfiguration_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const UsbDevice_SetConfiguration_ResponseParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const UsbDevice_ClaimInterface_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const UsbDevice_ClaimInterface_ResponseParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const UsbDevice_ReleaseInterface_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const UsbDevice_ReleaseInterface_ResponseParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const UsbDevice_SetInterfaceAlternateSetting_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const UsbDevice_SetInterfaceAlternateSetting_ResponseParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const UsbDevice_Reset_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const UsbDevice_Reset_ResponseParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const UsbDevice_ClearHalt_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const UsbDevice_ClearHalt_ResponseParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const UsbDevice_ControlTransferIn_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const UsbDevice_ControlTransferIn_ResponseParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const UsbDevice_ControlTransferOut_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const UsbDevice_ControlTransferOut_ResponseParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const UsbDevice_GenericTransferIn_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const UsbDevice_GenericTransferIn_ResponseParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const UsbDevice_GenericTransferOut_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const UsbDevice_GenericTransferOut_ResponseParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const UsbDevice_IsochronousTransferIn_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const UsbDevice_IsochronousTransferIn_ResponseParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const UsbDevice_IsochronousTransferOut_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const UsbDevice_IsochronousTransferOut_ResponseParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const UsbDeviceClient_OnDeviceOpened_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const UsbDeviceClient_OnDeviceClosed_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType} }
 */
export const UsbOpenDeviceResultSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };




mojo.internal.Struct(
    UsbEndpointInfoSpec.$,
    'UsbEndpointInfo',
    [
      mojo.internal.StructField(
        'endpointNumber', 0,
        0,
        mojo.internal.Uint8,
        0,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'direction', 4,
        0,
        UsbTransferDirectionSpec.$,
        0,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'type', 8,
        0,
        UsbTransferTypeSpec.$,
        0,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'packetSize', 12,
        0,
        mojo.internal.Uint32,
        0,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'synchronizationType', 16,
        0,
        UsbSynchronizationTypeSpec.$,
        0,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'usageType', 20,
        0,
        UsbUsageTypeSpec.$,
        0,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'pollingInterval', 1,
        0,
        mojo.internal.Uint8,
        0,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'extraData', 24,
        0,
        mojo.internal.Array(mojo.internal.Uint8, false),
        null,
        false /* nullable */,
        0,
      ),
    ],
    [[0, 40],]);



/**
 * @record
 */
export class UsbEndpointInfo {
  constructor() {
    /** @type { !number } */
    this.endpointNumber;
    /** @type { !UsbTransferDirection } */
    this.direction;
    /** @type { !UsbTransferType } */
    this.type;
    /** @type { !number } */
    this.packetSize;
    /** @type { !UsbSynchronizationType } */
    this.synchronizationType;
    /** @type { !UsbUsageType } */
    this.usageType;
    /** @type { !number } */
    this.pollingInterval;
    /** @type { !Array<!number> } */
    this.extraData;
  }
}



mojo.internal.Struct(
    UsbAlternateInterfaceInfoSpec.$,
    'UsbAlternateInterfaceInfo',
    [
      mojo.internal.StructField(
        'alternateSetting', 0,
        0,
        mojo.internal.Uint8,
        0,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'classCode', 1,
        0,
        mojo.internal.Uint8,
        0,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'subclassCode', 2,
        0,
        mojo.internal.Uint8,
        0,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'protocolCode', 3,
        0,
        mojo.internal.Uint8,
        0,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'interfaceName', 8,
        0,
        mojoBase_mojom_String16Spec.$,
        null,
        true /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'endpoints', 16,
        0,
        mojo.internal.Array(UsbEndpointInfoSpec.$, false),
        null,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'extraData', 24,
        0,
        mojo.internal.Array(mojo.internal.Uint8, false),
        null,
        false /* nullable */,
        0,
      ),
    ],
    [[0, 40],]);



/**
 * @record
 */
export class UsbAlternateInterfaceInfo {
  constructor() {
    /** @type { !number } */
    this.alternateSetting;
    /** @type { !number } */
    this.classCode;
    /** @type { !number } */
    this.subclassCode;
    /** @type { !number } */
    this.protocolCode;
    /** @type { (mojoBase_mojom_String16|undefined) } */
    this.interfaceName;
    /** @type { !Array<!UsbEndpointInfo> } */
    this.endpoints;
    /** @type { !Array<!number> } */
    this.extraData;
  }
}



mojo.internal.Struct(
    UsbInterfaceInfoSpec.$,
    'UsbInterfaceInfo',
    [
      mojo.internal.StructField(
        'interfaceNumber', 0,
        0,
        mojo.internal.Uint8,
        0,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'firstInterface', 1,
        0,
        mojo.internal.Uint8,
        0,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'alternates', 8,
        0,
        mojo.internal.Array(UsbAlternateInterfaceInfoSpec.$, false),
        null,
        false /* nullable */,
        0,
      ),
    ],
    [[0, 24],]);



/**
 * @record
 */
export class UsbInterfaceInfo {
  constructor() {
    /** @type { !number } */
    this.interfaceNumber;
    /** @type { !number } */
    this.firstInterface;
    /** @type { !Array<!UsbAlternateInterfaceInfo> } */
    this.alternates;
  }
}



mojo.internal.Struct(
    UsbConfigurationInfoSpec.$,
    'UsbConfigurationInfo',
    [
      mojo.internal.StructField(
        'configurationValue', 0,
        0,
        mojo.internal.Uint8,
        0,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'configurationName', 8,
        0,
        mojoBase_mojom_String16Spec.$,
        null,
        true /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'selfPowered', 1,
        0,
        mojo.internal.Bool,
        false,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'remoteWakeup', 1,
        1,
        mojo.internal.Bool,
        false,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'maximumPower', 2,
        0,
        mojo.internal.Uint8,
        0,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'interfaces', 16,
        0,
        mojo.internal.Array(UsbInterfaceInfoSpec.$, false),
        null,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'extraData', 24,
        0,
        mojo.internal.Array(mojo.internal.Uint8, false),
        null,
        false /* nullable */,
        0,
      ),
    ],
    [[0, 40],]);



/**
 * @record
 */
export class UsbConfigurationInfo {
  constructor() {
    /** @type { !number } */
    this.configurationValue;
    /** @type { (mojoBase_mojom_String16|undefined) } */
    this.configurationName;
    /** @type { !boolean } */
    this.selfPowered;
    /** @type { !boolean } */
    this.remoteWakeup;
    /** @type { !number } */
    this.maximumPower;
    /** @type { !Array<!UsbInterfaceInfo> } */
    this.interfaces;
    /** @type { !Array<!number> } */
    this.extraData;
  }
}



mojo.internal.Struct(
    UsbDeviceInfoSpec.$,
    'UsbDeviceInfo',
    [
      mojo.internal.StructField(
        'guid', 0,
        0,
        mojo.internal.String,
        null,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'usbVersionMajor', 8,
        0,
        mojo.internal.Uint8,
        0,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'usbVersionMinor', 9,
        0,
        mojo.internal.Uint8,
        0,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'usbVersionSubminor', 10,
        0,
        mojo.internal.Uint8,
        0,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'classCode', 11,
        0,
        mojo.internal.Uint8,
        0,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'subclassCode', 12,
        0,
        mojo.internal.Uint8,
        0,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'protocolCode', 13,
        0,
        mojo.internal.Uint8,
        0,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'busNumber', 16,
        0,
        mojo.internal.Uint32,
        0,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'portNumber', 20,
        0,
        mojo.internal.Uint32,
        0,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'vendorId', 14,
        0,
        mojo.internal.Uint16,
        0,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'productId', 24,
        0,
        mojo.internal.Uint16,
        0,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'deviceVersionMajor', 26,
        0,
        mojo.internal.Uint8,
        0,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'deviceVersionMinor', 27,
        0,
        mojo.internal.Uint8,
        0,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'deviceVersionSubminor', 28,
        0,
        mojo.internal.Uint8,
        0,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'manufacturerName', 32,
        0,
        mojoBase_mojom_String16Spec.$,
        null,
        true /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'productName', 40,
        0,
        mojoBase_mojom_String16Spec.$,
        null,
        true /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'serialNumber', 48,
        0,
        mojoBase_mojom_String16Spec.$,
        null,
        true /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'webusbLandingPage', 56,
        0,
        url_mojom_UrlSpec.$,
        null,
        true /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'activeConfiguration', 29,
        0,
        mojo.internal.Uint8,
        0,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'configurations', 64,
        0,
        mojo.internal.Array(UsbConfigurationInfoSpec.$, false),
        null,
        false /* nullable */,
        0,
      ),
    ],
    [[0, 80],]);



/**
 * @record
 */
export class UsbDeviceInfo {
  constructor() {
    /** @type { !string } */
    this.guid;
    /** @type { !number } */
    this.usbVersionMajor;
    /** @type { !number } */
    this.usbVersionMinor;
    /** @type { !number } */
    this.usbVersionSubminor;
    /** @type { !number } */
    this.classCode;
    /** @type { !number } */
    this.subclassCode;
    /** @type { !number } */
    this.protocolCode;
    /** @type { !number } */
    this.busNumber;
    /** @type { !number } */
    this.portNumber;
    /** @type { !number } */
    this.vendorId;
    /** @type { !number } */
    this.productId;
    /** @type { !number } */
    this.deviceVersionMajor;
    /** @type { !number } */
    this.deviceVersionMinor;
    /** @type { !number } */
    this.deviceVersionSubminor;
    /** @type { (mojoBase_mojom_String16|undefined) } */
    this.manufacturerName;
    /** @type { (mojoBase_mojom_String16|undefined) } */
    this.productName;
    /** @type { (mojoBase_mojom_String16|undefined) } */
    this.serialNumber;
    /** @type { (url_mojom_Url|undefined) } */
    this.webusbLandingPage;
    /** @type { !number } */
    this.activeConfiguration;
    /** @type { !Array<!UsbConfigurationInfo> } */
    this.configurations;
  }
}

/**
 * @const { !string }
 */
export const UsbControlTransferParams_SECURITY_KEY_AOA_MODEL =
    "12eba9f901039b36";



mojo.internal.Struct(
    UsbControlTransferParamsSpec.$,
    'UsbControlTransferParams',
    [
      mojo.internal.StructField(
        'type', 0,
        0,
        UsbControlTransferTypeSpec.$,
        0,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'recipient', 4,
        0,
        UsbControlTransferRecipientSpec.$,
        0,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'request', 8,
        0,
        mojo.internal.Uint8,
        0,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'value', 10,
        0,
        mojo.internal.Uint16,
        0,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'index', 12,
        0,
        mojo.internal.Uint16,
        0,
        false /* nullable */,
        0,
      ),
    ],
    [[0, 24],]);



/**
 * @record
 */
export class UsbControlTransferParams {
  constructor() {
    /** @type { !UsbControlTransferType } */
    this.type;
    /** @type { !UsbControlTransferRecipient } */
    this.recipient;
    /** @type { !number } */
    this.request;
    /** @type { !number } */
    this.value;
    /** @type { !number } */
    this.index;
  }
}



mojo.internal.Struct(
    UsbIsochronousPacketSpec.$,
    'UsbIsochronousPacket',
    [
      mojo.internal.StructField(
        'length', 0,
        0,
        mojo.internal.Uint32,
        0,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'transferredLength', 4,
        0,
        mojo.internal.Uint32,
        0,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'status', 8,
        0,
        UsbTransferStatusSpec.$,
        0,
        false /* nullable */,
        0,
      ),
    ],
    [[0, 24],]);



/**
 * @record
 */
export class UsbIsochronousPacket {
  constructor() {
    /** @type { !number } */
    this.length;
    /** @type { !number } */
    this.transferredLength;
    /** @type { !UsbTransferStatus } */
    this.status;
  }
}



mojo.internal.Struct(
    UsbDevice_Open_ParamsSpec.$,
    'UsbDevice_Open_Params',
    [
    ],
    [[0, 8],]);



/**
 * @record
 */
export class UsbDevice_Open_Params {
  constructor() {
  }
}



mojo.internal.Struct(
    UsbDevice_Open_ResponseParamsSpec.$,
    'UsbDevice_Open_ResponseParams',
    [
      mojo.internal.StructField(
        'result', 0,
        0,
        UsbOpenDeviceResultSpec.$,
        null,
        false /* nullable */,
        0,
      ),
    ],
    [[0, 24],]);



/**
 * @record
 */
export class UsbDevice_Open_ResponseParams {
  constructor() {
    /** @type { !UsbOpenDeviceResult } */
    this.result;
  }
}



mojo.internal.Struct(
    UsbDevice_Close_ParamsSpec.$,
    'UsbDevice_Close_Params',
    [
    ],
    [[0, 8],]);



/**
 * @record
 */
export class UsbDevice_Close_Params {
  constructor() {
  }
}



mojo.internal.Struct(
    UsbDevice_Close_ResponseParamsSpec.$,
    'UsbDevice_Close_ResponseParams',
    [
    ],
    [[0, 8],]);



/**
 * @record
 */
export class UsbDevice_Close_ResponseParams {
  constructor() {
  }
}



mojo.internal.Struct(
    UsbDevice_SetConfiguration_ParamsSpec.$,
    'UsbDevice_SetConfiguration_Params',
    [
      mojo.internal.StructField(
        'value', 0,
        0,
        mojo.internal.Uint8,
        0,
        false /* nullable */,
        0,
      ),
    ],
    [[0, 16],]);



/**
 * @record
 */
export class UsbDevice_SetConfiguration_Params {
  constructor() {
    /** @type { !number } */
    this.value;
  }
}



mojo.internal.Struct(
    UsbDevice_SetConfiguration_ResponseParamsSpec.$,
    'UsbDevice_SetConfiguration_ResponseParams',
    [
      mojo.internal.StructField(
        'success', 0,
        0,
        mojo.internal.Bool,
        false,
        false /* nullable */,
        0,
      ),
    ],
    [[0, 16],]);



/**
 * @record
 */
export class UsbDevice_SetConfiguration_ResponseParams {
  constructor() {
    /** @type { !boolean } */
    this.success;
  }
}



mojo.internal.Struct(
    UsbDevice_ClaimInterface_ParamsSpec.$,
    'UsbDevice_ClaimInterface_Params',
    [
      mojo.internal.StructField(
        'interfaceNumber', 0,
        0,
        mojo.internal.Uint8,
        0,
        false /* nullable */,
        0,
      ),
    ],
    [[0, 16],]);



/**
 * @record
 */
export class UsbDevice_ClaimInterface_Params {
  constructor() {
    /** @type { !number } */
    this.interfaceNumber;
  }
}



mojo.internal.Struct(
    UsbDevice_ClaimInterface_ResponseParamsSpec.$,
    'UsbDevice_ClaimInterface_ResponseParams',
    [
      mojo.internal.StructField(
        'result', 0,
        0,
        UsbClaimInterfaceResultSpec.$,
        0,
        false /* nullable */,
        0,
      ),
    ],
    [[0, 16],]);



/**
 * @record
 */
export class UsbDevice_ClaimInterface_ResponseParams {
  constructor() {
    /** @type { !UsbClaimInterfaceResult } */
    this.result;
  }
}



mojo.internal.Struct(
    UsbDevice_ReleaseInterface_ParamsSpec.$,
    'UsbDevice_ReleaseInterface_Params',
    [
      mojo.internal.StructField(
        'interfaceNumber', 0,
        0,
        mojo.internal.Uint8,
        0,
        false /* nullable */,
        0,
      ),
    ],
    [[0, 16],]);



/**
 * @record
 */
export class UsbDevice_ReleaseInterface_Params {
  constructor() {
    /** @type { !number } */
    this.interfaceNumber;
  }
}



mojo.internal.Struct(
    UsbDevice_ReleaseInterface_ResponseParamsSpec.$,
    'UsbDevice_ReleaseInterface_ResponseParams',
    [
      mojo.internal.StructField(
        'success', 0,
        0,
        mojo.internal.Bool,
        false,
        false /* nullable */,
        0,
      ),
    ],
    [[0, 16],]);



/**
 * @record
 */
export class UsbDevice_ReleaseInterface_ResponseParams {
  constructor() {
    /** @type { !boolean } */
    this.success;
  }
}



mojo.internal.Struct(
    UsbDevice_SetInterfaceAlternateSetting_ParamsSpec.$,
    'UsbDevice_SetInterfaceAlternateSetting_Params',
    [
      mojo.internal.StructField(
        'interfaceNumber', 0,
        0,
        mojo.internal.Uint8,
        0,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'alternateSetting', 1,
        0,
        mojo.internal.Uint8,
        0,
        false /* nullable */,
        0,
      ),
    ],
    [[0, 16],]);



/**
 * @record
 */
export class UsbDevice_SetInterfaceAlternateSetting_Params {
  constructor() {
    /** @type { !number } */
    this.interfaceNumber;
    /** @type { !number } */
    this.alternateSetting;
  }
}



mojo.internal.Struct(
    UsbDevice_SetInterfaceAlternateSetting_ResponseParamsSpec.$,
    'UsbDevice_SetInterfaceAlternateSetting_ResponseParams',
    [
      mojo.internal.StructField(
        'success', 0,
        0,
        mojo.internal.Bool,
        false,
        false /* nullable */,
        0,
      ),
    ],
    [[0, 16],]);



/**
 * @record
 */
export class UsbDevice_SetInterfaceAlternateSetting_ResponseParams {
  constructor() {
    /** @type { !boolean } */
    this.success;
  }
}



mojo.internal.Struct(
    UsbDevice_Reset_ParamsSpec.$,
    'UsbDevice_Reset_Params',
    [
    ],
    [[0, 8],]);



/**
 * @record
 */
export class UsbDevice_Reset_Params {
  constructor() {
  }
}



mojo.internal.Struct(
    UsbDevice_Reset_ResponseParamsSpec.$,
    'UsbDevice_Reset_ResponseParams',
    [
      mojo.internal.StructField(
        'success', 0,
        0,
        mojo.internal.Bool,
        false,
        false /* nullable */,
        0,
      ),
    ],
    [[0, 16],]);



/**
 * @record
 */
export class UsbDevice_Reset_ResponseParams {
  constructor() {
    /** @type { !boolean } */
    this.success;
  }
}



mojo.internal.Struct(
    UsbDevice_ClearHalt_ParamsSpec.$,
    'UsbDevice_ClearHalt_Params',
    [
      mojo.internal.StructField(
        'direction', 0,
        0,
        UsbTransferDirectionSpec.$,
        0,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'endpointNumber', 4,
        0,
        mojo.internal.Uint8,
        0,
        false /* nullable */,
        0,
      ),
    ],
    [[0, 16],]);



/**
 * @record
 */
export class UsbDevice_ClearHalt_Params {
  constructor() {
    /** @type { !UsbTransferDirection } */
    this.direction;
    /** @type { !number } */
    this.endpointNumber;
  }
}



mojo.internal.Struct(
    UsbDevice_ClearHalt_ResponseParamsSpec.$,
    'UsbDevice_ClearHalt_ResponseParams',
    [
      mojo.internal.StructField(
        'success', 0,
        0,
        mojo.internal.Bool,
        false,
        false /* nullable */,
        0,
      ),
    ],
    [[0, 16],]);



/**
 * @record
 */
export class UsbDevice_ClearHalt_ResponseParams {
  constructor() {
    /** @type { !boolean } */
    this.success;
  }
}



mojo.internal.Struct(
    UsbDevice_ControlTransferIn_ParamsSpec.$,
    'UsbDevice_ControlTransferIn_Params',
    [
      mojo.internal.StructField(
        'params', 0,
        0,
        UsbControlTransferParamsSpec.$,
        null,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'length', 8,
        0,
        mojo.internal.Uint32,
        0,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'timeout', 12,
        0,
        mojo.internal.Uint32,
        0,
        false /* nullable */,
        0,
      ),
    ],
    [[0, 24],]);



/**
 * @record
 */
export class UsbDevice_ControlTransferIn_Params {
  constructor() {
    /** @type { !UsbControlTransferParams } */
    this.params;
    /** @type { !number } */
    this.length;
    /** @type { !number } */
    this.timeout;
  }
}



mojo.internal.Struct(
    UsbDevice_ControlTransferIn_ResponseParamsSpec.$,
    'UsbDevice_ControlTransferIn_ResponseParams',
    [
      mojo.internal.StructField(
        'status', 0,
        0,
        UsbTransferStatusSpec.$,
        0,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'data', 8,
        0,
        mojoBase_mojom_ReadOnlyBufferSpec.$,
        null,
        false /* nullable */,
        0,
      ),
    ],
    [[0, 24],]);



/**
 * @record
 */
export class UsbDevice_ControlTransferIn_ResponseParams {
  constructor() {
    /** @type { !UsbTransferStatus } */
    this.status;
    /** @type { !mojoBase_mojom_ReadOnlyBuffer } */
    this.data;
  }
}



mojo.internal.Struct(
    UsbDevice_ControlTransferOut_ParamsSpec.$,
    'UsbDevice_ControlTransferOut_Params',
    [
      mojo.internal.StructField(
        'params', 0,
        0,
        UsbControlTransferParamsSpec.$,
        null,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'data', 8,
        0,
        mojoBase_mojom_ReadOnlyBufferSpec.$,
        null,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'timeout', 16,
        0,
        mojo.internal.Uint32,
        0,
        false /* nullable */,
        0,
      ),
    ],
    [[0, 32],]);



/**
 * @record
 */
export class UsbDevice_ControlTransferOut_Params {
  constructor() {
    /** @type { !UsbControlTransferParams } */
    this.params;
    /** @type { !mojoBase_mojom_ReadOnlyBuffer } */
    this.data;
    /** @type { !number } */
    this.timeout;
  }
}



mojo.internal.Struct(
    UsbDevice_ControlTransferOut_ResponseParamsSpec.$,
    'UsbDevice_ControlTransferOut_ResponseParams',
    [
      mojo.internal.StructField(
        'status', 0,
        0,
        UsbTransferStatusSpec.$,
        0,
        false /* nullable */,
        0,
      ),
    ],
    [[0, 16],]);



/**
 * @record
 */
export class UsbDevice_ControlTransferOut_ResponseParams {
  constructor() {
    /** @type { !UsbTransferStatus } */
    this.status;
  }
}



mojo.internal.Struct(
    UsbDevice_GenericTransferIn_ParamsSpec.$,
    'UsbDevice_GenericTransferIn_Params',
    [
      mojo.internal.StructField(
        'endpointNumber', 0,
        0,
        mojo.internal.Uint8,
        0,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'length', 4,
        0,
        mojo.internal.Uint32,
        0,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'timeout', 8,
        0,
        mojo.internal.Uint32,
        0,
        false /* nullable */,
        0,
      ),
    ],
    [[0, 24],]);



/**
 * @record
 */
export class UsbDevice_GenericTransferIn_Params {
  constructor() {
    /** @type { !number } */
    this.endpointNumber;
    /** @type { !number } */
    this.length;
    /** @type { !number } */
    this.timeout;
  }
}



mojo.internal.Struct(
    UsbDevice_GenericTransferIn_ResponseParamsSpec.$,
    'UsbDevice_GenericTransferIn_ResponseParams',
    [
      mojo.internal.StructField(
        'status', 0,
        0,
        UsbTransferStatusSpec.$,
        0,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'data', 8,
        0,
        mojoBase_mojom_ReadOnlyBufferSpec.$,
        null,
        false /* nullable */,
        0,
      ),
    ],
    [[0, 24],]);



/**
 * @record
 */
export class UsbDevice_GenericTransferIn_ResponseParams {
  constructor() {
    /** @type { !UsbTransferStatus } */
    this.status;
    /** @type { !mojoBase_mojom_ReadOnlyBuffer } */
    this.data;
  }
}



mojo.internal.Struct(
    UsbDevice_GenericTransferOut_ParamsSpec.$,
    'UsbDevice_GenericTransferOut_Params',
    [
      mojo.internal.StructField(
        'endpointNumber', 0,
        0,
        mojo.internal.Uint8,
        0,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'data', 8,
        0,
        mojoBase_mojom_ReadOnlyBufferSpec.$,
        null,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'timeout', 4,
        0,
        mojo.internal.Uint32,
        0,
        false /* nullable */,
        0,
      ),
    ],
    [[0, 24],]);



/**
 * @record
 */
export class UsbDevice_GenericTransferOut_Params {
  constructor() {
    /** @type { !number } */
    this.endpointNumber;
    /** @type { !mojoBase_mojom_ReadOnlyBuffer } */
    this.data;
    /** @type { !number } */
    this.timeout;
  }
}



mojo.internal.Struct(
    UsbDevice_GenericTransferOut_ResponseParamsSpec.$,
    'UsbDevice_GenericTransferOut_ResponseParams',
    [
      mojo.internal.StructField(
        'status', 0,
        0,
        UsbTransferStatusSpec.$,
        0,
        false /* nullable */,
        0,
      ),
    ],
    [[0, 16],]);



/**
 * @record
 */
export class UsbDevice_GenericTransferOut_ResponseParams {
  constructor() {
    /** @type { !UsbTransferStatus } */
    this.status;
  }
}



mojo.internal.Struct(
    UsbDevice_IsochronousTransferIn_ParamsSpec.$,
    'UsbDevice_IsochronousTransferIn_Params',
    [
      mojo.internal.StructField(
        'endpointNumber', 0,
        0,
        mojo.internal.Uint8,
        0,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'packetLengths', 8,
        0,
        mojo.internal.Array(mojo.internal.Uint32, false),
        null,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'timeout', 4,
        0,
        mojo.internal.Uint32,
        0,
        false /* nullable */,
        0,
      ),
    ],
    [[0, 24],]);



/**
 * @record
 */
export class UsbDevice_IsochronousTransferIn_Params {
  constructor() {
    /** @type { !number } */
    this.endpointNumber;
    /** @type { !Array<!number> } */
    this.packetLengths;
    /** @type { !number } */
    this.timeout;
  }
}



mojo.internal.Struct(
    UsbDevice_IsochronousTransferIn_ResponseParamsSpec.$,
    'UsbDevice_IsochronousTransferIn_ResponseParams',
    [
      mojo.internal.StructField(
        'data', 0,
        0,
        mojoBase_mojom_ReadOnlyBufferSpec.$,
        null,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'packets', 8,
        0,
        mojo.internal.Array(UsbIsochronousPacketSpec.$, false),
        null,
        false /* nullable */,
        0,
      ),
    ],
    [[0, 24],]);



/**
 * @record
 */
export class UsbDevice_IsochronousTransferIn_ResponseParams {
  constructor() {
    /** @type { !mojoBase_mojom_ReadOnlyBuffer } */
    this.data;
    /** @type { !Array<!UsbIsochronousPacket> } */
    this.packets;
  }
}



mojo.internal.Struct(
    UsbDevice_IsochronousTransferOut_ParamsSpec.$,
    'UsbDevice_IsochronousTransferOut_Params',
    [
      mojo.internal.StructField(
        'endpointNumber', 0,
        0,
        mojo.internal.Uint8,
        0,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'data', 8,
        0,
        mojoBase_mojom_ReadOnlyBufferSpec.$,
        null,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'packetLengths', 16,
        0,
        mojo.internal.Array(mojo.internal.Uint32, false),
        null,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'timeout', 4,
        0,
        mojo.internal.Uint32,
        0,
        false /* nullable */,
        0,
      ),
    ],
    [[0, 32],]);



/**
 * @record
 */
export class UsbDevice_IsochronousTransferOut_Params {
  constructor() {
    /** @type { !number } */
    this.endpointNumber;
    /** @type { !mojoBase_mojom_ReadOnlyBuffer } */
    this.data;
    /** @type { !Array<!number> } */
    this.packetLengths;
    /** @type { !number } */
    this.timeout;
  }
}



mojo.internal.Struct(
    UsbDevice_IsochronousTransferOut_ResponseParamsSpec.$,
    'UsbDevice_IsochronousTransferOut_ResponseParams',
    [
      mojo.internal.StructField(
        'packets', 0,
        0,
        mojo.internal.Array(UsbIsochronousPacketSpec.$, false),
        null,
        false /* nullable */,
        0,
      ),
    ],
    [[0, 16],]);



/**
 * @record
 */
export class UsbDevice_IsochronousTransferOut_ResponseParams {
  constructor() {
    /** @type { !Array<!UsbIsochronousPacket> } */
    this.packets;
  }
}



mojo.internal.Struct(
    UsbDeviceClient_OnDeviceOpened_ParamsSpec.$,
    'UsbDeviceClient_OnDeviceOpened_Params',
    [
    ],
    [[0, 8],]);



/**
 * @record
 */
export class UsbDeviceClient_OnDeviceOpened_Params {
  constructor() {
  }
}



mojo.internal.Struct(
    UsbDeviceClient_OnDeviceClosed_ParamsSpec.$,
    'UsbDeviceClient_OnDeviceClosed_Params',
    [
    ],
    [[0, 8],]);



/**
 * @record
 */
export class UsbDeviceClient_OnDeviceClosed_Params {
  constructor() {
  }
}

mojo.internal.Union(
    UsbOpenDeviceResultSpec.$, 'UsbOpenDeviceResult',
    {
      'success': {
        'ordinal': 0,
        'type': UsbOpenDeviceSuccessSpec.$,
      },
      'error': {
        'ordinal': 1,
        'type': UsbOpenDeviceErrorSpec.$,
      },
    });

/**
 * @typedef { {
 *   success: (!UsbOpenDeviceSuccess|undefined),
 *   error: (!UsbOpenDeviceError|undefined),
 * } }
 */
export const UsbOpenDeviceResult = {};
