#version 420 core
precision mediump float;

in mediump vec2 TexCoord;
out mediump vec4 FragColor;

uniform sampler2D y_sampler;
uniform sampler2D uv_sampler;

void main()
{
    // use all test params
    vec4 channels = vec4(texture(y_sampler, TexCoord).x, texture(uv_sampler, TexCoord).xy, 1.0);
    mat4 conversion = mat4(
        1.1643,         0.0,      1.5958, -0.87066875,
        1.1643,    -0.39173,    -0.81290,  0.52954625,
        1.1643,       2.017,         0.0, -1.08126875,
           0.0,         0.0,         0.0,         0.0
    );

    FragColor = vec4((channels * conversion).rgb, 1.0);
}