// third_party/blink/public/mojom/contacts/contacts_manager.mojom.m.js is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2020 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

import {mojo} from '../../../../../mojo/public/js/bindings.js';

import {
  PaymentAddress as payments_mojom_PaymentAddress,
  PaymentAddressSpec as payments_mojom_PaymentAddressSpec
} from '../../../../../components/payments/mojom/payment_request_data.mojom.m.js';




/**
 * @implements {mojo.internal.interfaceSupport.PendingReceiver}
 */
export class ContactsManagerPendingReceiver {
  /**
   * @param {!MojoHandle|!mojo.internal.interfaceSupport.Endpoint} handle
   */
  constructor(handle) {
    /** @public {!mojo.internal.interfaceSupport.Endpoint} */
    this.handle = mojo.internal.interfaceSupport.getEndpointForReceiver(handle);
  }

  /** @param {string=} scope */
  bindInBrowser(scope = 'context') {
    mojo.internal.interfaceSupport.bind(
        this.handle, 'blink.mojom.ContactsManager', scope);
  }
}

/** @interface */
export class ContactsManagerInterface {
  
  /**
   * @param { !boolean } multiple
   * @param { !boolean } includeNames
   * @param { !boolean } includeEmails
   * @param { !boolean } includeTel
   * @param { !boolean } includeAddresses
   * @param { !boolean } includeIcons
   * @return {!Promise<{
        contacts: ?Array<!ContactInfo>,
   *  }>}
   */

  select(multiple, includeNames, includeEmails, includeTel, includeAddresses, includeIcons) {}
}

/**
 * @implements { ContactsManagerInterface }
 */
export class ContactsManagerRemote {
  /** @param {MojoHandle|mojo.internal.interfaceSupport.Endpoint=} handle */
  constructor(handle = undefined) {
    /**
     * @private {!mojo.internal.interfaceSupport.InterfaceRemoteBase<!ContactsManagerPendingReceiver>}
     */
    this.proxy =
        new mojo.internal.interfaceSupport.InterfaceRemoteBase(
          ContactsManagerPendingReceiver,
          handle);

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceRemoteBaseWrapper<!ContactsManagerPendingReceiver>}
     */
    this.$ = new mojo.internal.interfaceSupport.InterfaceRemoteBaseWrapper(this.proxy);

    /** @public {!mojo.internal.interfaceSupport.ConnectionErrorEventRouter} */
    this.onConnectionError = this.proxy.getConnectionErrorEventRouter();
  }

  
  /**
   * @param { !boolean } multiple
   * @param { !boolean } includeNames
   * @param { !boolean } includeEmails
   * @param { !boolean } includeTel
   * @param { !boolean } includeAddresses
   * @param { !boolean } includeIcons
   * @return {!Promise<{
        contacts: ?Array<!ContactInfo>,
   *  }>}
   */

  select(
      multiple,
      includeNames,
      includeEmails,
      includeTel,
      includeAddresses,
      includeIcons) {
    return this.proxy.sendMessage(
        0,
        ContactsManager_Select_ParamsSpec.$,
        ContactsManager_Select_ResponseParamsSpec.$,
        [
          multiple,
          includeNames,
          includeEmails,
          includeTel,
          includeAddresses,
          includeIcons
        ]);
  }
}

/**
 * An object which receives request messages for the ContactsManager
 * mojom interface. Must be constructed over an object which implements that
 * interface.
 */
export class ContactsManagerReceiver {
  /**
   * @param {!ContactsManagerInterface } impl
   */
  constructor(impl) {
    /** @private {!mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal<!ContactsManagerRemote>} */
    this.helper_internal_ = new mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal(
        ContactsManagerRemote);

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceReceiverHelper<!ContactsManagerRemote>}
     */
    this.$ = new mojo.internal.interfaceSupport.InterfaceReceiverHelper(this.helper_internal_);


    this.helper_internal_.registerHandler(
        0,
        ContactsManager_Select_ParamsSpec.$,
        ContactsManager_Select_ResponseParamsSpec.$,
        impl.select.bind(impl));
    /** @public {!mojo.internal.interfaceSupport.ConnectionErrorEventRouter} */
    this.onConnectionError = this.helper_internal_.getConnectionErrorEventRouter();
  }
}

export class ContactsManager {
  /**
   * @return {!string}
   */
  static get $interfaceName() {
    return "blink.mojom.ContactsManager";
  }

  /**
   * Returns a remote for this interface which sends messages to the browser.
   * The browser must have an interface request binder registered for this
   * interface and accessible to the calling document's frame.
   *
   * @return {!ContactsManagerRemote}
   */
  static getRemote() {
    let remote = new ContactsManagerRemote;
    remote.$.bindNewPipeAndPassReceiver().bindInBrowser();
    return remote;
  }
}


/**
 * An object which receives request messages for the ContactsManager
 * mojom interface and dispatches them as callbacks. One callback receiver exists
 * on this object for each message defined in the mojom interface, and each
 * receiver can have any number of listeners added to it.
 */
export class ContactsManagerCallbackRouter {
  constructor() {
    this.helper_internal_ = new mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal(
      ContactsManagerRemote);

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceReceiverHelper<!ContactsManagerRemote>}
     */
    this.$ = new mojo.internal.interfaceSupport.InterfaceReceiverHelper(this.helper_internal_);

    this.router_ = new mojo.internal.interfaceSupport.CallbackRouter;

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.select =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        0,
        ContactsManager_Select_ParamsSpec.$,
        ContactsManager_Select_ResponseParamsSpec.$,
        this.select.createReceiverHandler(true /* expectsResponse */));
    /** @public {!mojo.internal.interfaceSupport.ConnectionErrorEventRouter} */
    this.onConnectionError = this.helper_internal_.getConnectionErrorEventRouter();
  }

  /**
   * @param {number} id An ID returned by a prior call to addListener.
   * @return {boolean} True iff the identified listener was found and removed.
   */
  removeListener(id) {
    return this.router_.removeListener(id);
  }
}

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const ContactIconBlobSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const ContactInfoSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const ContactsManager_Select_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const ContactsManager_Select_ResponseParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };




mojo.internal.Struct(
    ContactIconBlobSpec.$,
    'ContactIconBlob',
    [
      mojo.internal.StructField(
        'mimeType', 0,
        0,
        mojo.internal.String,
        null,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'data', 8,
        0,
        mojo.internal.Array(mojo.internal.Uint8, false),
        null,
        false /* nullable */,
        0,
      ),
    ],
    [[0, 24],]);



/**
 * @record
 */
export class ContactIconBlob {
  constructor() {
    /** @type { !string } */
    this.mimeType;
    /** @type { !Array<!number> } */
    this.data;
  }
}



mojo.internal.Struct(
    ContactInfoSpec.$,
    'ContactInfo',
    [
      mojo.internal.StructField(
        'name', 0,
        0,
        mojo.internal.Array(mojo.internal.String, false),
        null,
        true /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'email', 8,
        0,
        mojo.internal.Array(mojo.internal.String, false),
        null,
        true /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'tel', 16,
        0,
        mojo.internal.Array(mojo.internal.String, false),
        null,
        true /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'address', 24,
        0,
        mojo.internal.Array(payments_mojom_PaymentAddressSpec.$, false),
        null,
        true /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'icon', 32,
        0,
        mojo.internal.Array(ContactIconBlobSpec.$, false),
        null,
        true /* nullable */,
        0,
      ),
    ],
    [[0, 48],]);



/**
 * @record
 */
export class ContactInfo {
  constructor() {
    /** @type { (Array<!string>|undefined) } */
    this.name;
    /** @type { (Array<!string>|undefined) } */
    this.email;
    /** @type { (Array<!string>|undefined) } */
    this.tel;
    /** @type { (Array<!payments_mojom_PaymentAddress>|undefined) } */
    this.address;
    /** @type { (Array<!ContactIconBlob>|undefined) } */
    this.icon;
  }
}



mojo.internal.Struct(
    ContactsManager_Select_ParamsSpec.$,
    'ContactsManager_Select_Params',
    [
      mojo.internal.StructField(
        'multiple', 0,
        0,
        mojo.internal.Bool,
        false,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'includeNames', 0,
        1,
        mojo.internal.Bool,
        false,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'includeEmails', 0,
        2,
        mojo.internal.Bool,
        false,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'includeTel', 0,
        3,
        mojo.internal.Bool,
        false,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'includeAddresses', 0,
        4,
        mojo.internal.Bool,
        false,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'includeIcons', 0,
        5,
        mojo.internal.Bool,
        false,
        false /* nullable */,
        0,
      ),
    ],
    [[0, 16],]);



/**
 * @record
 */
export class ContactsManager_Select_Params {
  constructor() {
    /** @type { !boolean } */
    this.multiple;
    /** @type { !boolean } */
    this.includeNames;
    /** @type { !boolean } */
    this.includeEmails;
    /** @type { !boolean } */
    this.includeTel;
    /** @type { !boolean } */
    this.includeAddresses;
    /** @type { !boolean } */
    this.includeIcons;
  }
}



mojo.internal.Struct(
    ContactsManager_Select_ResponseParamsSpec.$,
    'ContactsManager_Select_ResponseParams',
    [
      mojo.internal.StructField(
        'contacts', 0,
        0,
        mojo.internal.Array(ContactInfoSpec.$, false),
        null,
        true /* nullable */,
        0,
      ),
    ],
    [[0, 16],]);



/**
 * @record
 */
export class ContactsManager_Select_ResponseParams {
  constructor() {
    /** @type { (Array<!ContactInfo>|undefined) } */
    this.contacts;
  }
}

