// third_party/blink/public/mojom/content_index/content_index.mojom.m.js is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2020 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

import {mojo} from '../../../../../mojo/public/js/bindings.js';

import {
  BitmapN32 as skia_mojom_BitmapN32,
  BitmapN32Spec as skia_mojom_BitmapN32Spec
} from '../../../../../skia/public/mojom/bitmap.mojom.m.js';

import {
  Size as gfx_mojom_Size,
  SizeSpec as gfx_mojom_SizeSpec
} from '../../../../../ui/gfx/geometry/mojom/geometry.mojom.m.js';

import {
  Url as url_mojom_Url,
  UrlSpec as url_mojom_UrlSpec
} from '../../../../../url/mojom/url.mojom.m.js';


/**
 * @const { {$: !mojo.internal.MojomType} }
 */
export const ContentIndexErrorSpec = { $: mojo.internal.Enum() };

/**
 * @enum {number}
 */
export const ContentIndexError = {
  
  NONE: 0,
  INVALID_PARAMETER: 1,
  STORAGE_ERROR: 2,
  NO_SERVICE_WORKER: 3,
  MIN_VALUE: 0,
  MAX_VALUE: 3,
};

/**
 * @const { {$: !mojo.internal.MojomType} }
 */
export const ContentCategorySpec = { $: mojo.internal.Enum() };

/**
 * @enum {number}
 */
export const ContentCategory = {
  
  NONE: 0,
  HOME_PAGE: 1,
  ARTICLE: 2,
  VIDEO: 3,
  AUDIO: 4,
  MIN_VALUE: 0,
  MAX_VALUE: 4,
};



/**
 * @implements {mojo.internal.interfaceSupport.PendingReceiver}
 */
export class ContentIndexServicePendingReceiver {
  /**
   * @param {!MojoHandle|!mojo.internal.interfaceSupport.Endpoint} handle
   */
  constructor(handle) {
    /** @public {!mojo.internal.interfaceSupport.Endpoint} */
    this.handle = mojo.internal.interfaceSupport.getEndpointForReceiver(handle);
  }

  /** @param {string=} scope */
  bindInBrowser(scope = 'context') {
    mojo.internal.interfaceSupport.bind(
        this.handle, 'blink.mojom.ContentIndexService', scope);
  }
}

/** @interface */
export class ContentIndexServiceInterface {
  
  /**
   * @param { !ContentCategory } category
   * @return {!Promise<{
        iconSizes: !Array<!gfx_mojom_Size>,
   *  }>}
   */

  getIconSizes(category) {}
  
  /**
   * @param { !bigint } serviceWorkerRegistrationId
   * @param { !url_mojom_Url } launchUrl
   * @return {!Promise<{
        isOfflineCapable: !boolean,
   *  }>}
   */

  checkOfflineCapability(serviceWorkerRegistrationId, launchUrl) {}
  
  /**
   * @param { !bigint } serviceWorkerRegistrationId
   * @param { !ContentDescription } description
   * @param { !Array<!skia_mojom_BitmapN32> } icon
   * @param { !url_mojom_Url } launchUrl
   * @return {!Promise<{
        error: !ContentIndexError,
   *  }>}
   */

  add(serviceWorkerRegistrationId, description, icon, launchUrl) {}
  
  /**
   * @param { !bigint } serviceWorkerRegistrationId
   * @param { !string } id
   * @return {!Promise<{
        error: !ContentIndexError,
   *  }>}
   */

  delete(serviceWorkerRegistrationId, id) {}
  
  /**
   * @param { !bigint } serviceWorkerRegistrationId
   * @return {!Promise<{
        error: !ContentIndexError,
        descriptions: !Array<!ContentDescription>,
   *  }>}
   */

  getDescriptions(serviceWorkerRegistrationId) {}
}

/**
 * @implements { ContentIndexServiceInterface }
 */
export class ContentIndexServiceRemote {
  /** @param {MojoHandle|mojo.internal.interfaceSupport.Endpoint=} handle */
  constructor(handle = undefined) {
    /**
     * @private {!mojo.internal.interfaceSupport.InterfaceRemoteBase<!ContentIndexServicePendingReceiver>}
     */
    this.proxy =
        new mojo.internal.interfaceSupport.InterfaceRemoteBase(
          ContentIndexServicePendingReceiver,
          handle);

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceRemoteBaseWrapper<!ContentIndexServicePendingReceiver>}
     */
    this.$ = new mojo.internal.interfaceSupport.InterfaceRemoteBaseWrapper(this.proxy);

    /** @public {!mojo.internal.interfaceSupport.ConnectionErrorEventRouter} */
    this.onConnectionError = this.proxy.getConnectionErrorEventRouter();
  }

  
  /**
   * @param { !ContentCategory } category
   * @return {!Promise<{
        iconSizes: !Array<!gfx_mojom_Size>,
   *  }>}
   */

  getIconSizes(
      category) {
    return this.proxy.sendMessage(
        0,
        ContentIndexService_GetIconSizes_ParamsSpec.$,
        ContentIndexService_GetIconSizes_ResponseParamsSpec.$,
        [
          category
        ]);
  }

  
  /**
   * @param { !bigint } serviceWorkerRegistrationId
   * @param { !url_mojom_Url } launchUrl
   * @return {!Promise<{
        isOfflineCapable: !boolean,
   *  }>}
   */

  checkOfflineCapability(
      serviceWorkerRegistrationId,
      launchUrl) {
    return this.proxy.sendMessage(
        1,
        ContentIndexService_CheckOfflineCapability_ParamsSpec.$,
        ContentIndexService_CheckOfflineCapability_ResponseParamsSpec.$,
        [
          serviceWorkerRegistrationId,
          launchUrl
        ]);
  }

  
  /**
   * @param { !bigint } serviceWorkerRegistrationId
   * @param { !ContentDescription } description
   * @param { !Array<!skia_mojom_BitmapN32> } icon
   * @param { !url_mojom_Url } launchUrl
   * @return {!Promise<{
        error: !ContentIndexError,
   *  }>}
   */

  add(
      serviceWorkerRegistrationId,
      description,
      icon,
      launchUrl) {
    return this.proxy.sendMessage(
        2,
        ContentIndexService_Add_ParamsSpec.$,
        ContentIndexService_Add_ResponseParamsSpec.$,
        [
          serviceWorkerRegistrationId,
          description,
          icon,
          launchUrl
        ]);
  }

  
  /**
   * @param { !bigint } serviceWorkerRegistrationId
   * @param { !string } id
   * @return {!Promise<{
        error: !ContentIndexError,
   *  }>}
   */

  delete(
      serviceWorkerRegistrationId,
      id) {
    return this.proxy.sendMessage(
        3,
        ContentIndexService_Delete_ParamsSpec.$,
        ContentIndexService_Delete_ResponseParamsSpec.$,
        [
          serviceWorkerRegistrationId,
          id
        ]);
  }

  
  /**
   * @param { !bigint } serviceWorkerRegistrationId
   * @return {!Promise<{
        error: !ContentIndexError,
        descriptions: !Array<!ContentDescription>,
   *  }>}
   */

  getDescriptions(
      serviceWorkerRegistrationId) {
    return this.proxy.sendMessage(
        4,
        ContentIndexService_GetDescriptions_ParamsSpec.$,
        ContentIndexService_GetDescriptions_ResponseParamsSpec.$,
        [
          serviceWorkerRegistrationId
        ]);
  }
}

/**
 * An object which receives request messages for the ContentIndexService
 * mojom interface. Must be constructed over an object which implements that
 * interface.
 */
export class ContentIndexServiceReceiver {
  /**
   * @param {!ContentIndexServiceInterface } impl
   */
  constructor(impl) {
    /** @private {!mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal<!ContentIndexServiceRemote>} */
    this.helper_internal_ = new mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal(
        ContentIndexServiceRemote);

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceReceiverHelper<!ContentIndexServiceRemote>}
     */
    this.$ = new mojo.internal.interfaceSupport.InterfaceReceiverHelper(this.helper_internal_);


    this.helper_internal_.registerHandler(
        0,
        ContentIndexService_GetIconSizes_ParamsSpec.$,
        ContentIndexService_GetIconSizes_ResponseParamsSpec.$,
        impl.getIconSizes.bind(impl));
    this.helper_internal_.registerHandler(
        1,
        ContentIndexService_CheckOfflineCapability_ParamsSpec.$,
        ContentIndexService_CheckOfflineCapability_ResponseParamsSpec.$,
        impl.checkOfflineCapability.bind(impl));
    this.helper_internal_.registerHandler(
        2,
        ContentIndexService_Add_ParamsSpec.$,
        ContentIndexService_Add_ResponseParamsSpec.$,
        impl.add.bind(impl));
    this.helper_internal_.registerHandler(
        3,
        ContentIndexService_Delete_ParamsSpec.$,
        ContentIndexService_Delete_ResponseParamsSpec.$,
        impl.delete.bind(impl));
    this.helper_internal_.registerHandler(
        4,
        ContentIndexService_GetDescriptions_ParamsSpec.$,
        ContentIndexService_GetDescriptions_ResponseParamsSpec.$,
        impl.getDescriptions.bind(impl));
    /** @public {!mojo.internal.interfaceSupport.ConnectionErrorEventRouter} */
    this.onConnectionError = this.helper_internal_.getConnectionErrorEventRouter();
  }
}

export class ContentIndexService {
  /**
   * @return {!string}
   */
  static get $interfaceName() {
    return "blink.mojom.ContentIndexService";
  }

  /**
   * Returns a remote for this interface which sends messages to the browser.
   * The browser must have an interface request binder registered for this
   * interface and accessible to the calling document's frame.
   *
   * @return {!ContentIndexServiceRemote}
   */
  static getRemote() {
    let remote = new ContentIndexServiceRemote;
    remote.$.bindNewPipeAndPassReceiver().bindInBrowser();
    return remote;
  }
}


/**
 * An object which receives request messages for the ContentIndexService
 * mojom interface and dispatches them as callbacks. One callback receiver exists
 * on this object for each message defined in the mojom interface, and each
 * receiver can have any number of listeners added to it.
 */
export class ContentIndexServiceCallbackRouter {
  constructor() {
    this.helper_internal_ = new mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal(
      ContentIndexServiceRemote);

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceReceiverHelper<!ContentIndexServiceRemote>}
     */
    this.$ = new mojo.internal.interfaceSupport.InterfaceReceiverHelper(this.helper_internal_);

    this.router_ = new mojo.internal.interfaceSupport.CallbackRouter;

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.getIconSizes =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        0,
        ContentIndexService_GetIconSizes_ParamsSpec.$,
        ContentIndexService_GetIconSizes_ResponseParamsSpec.$,
        this.getIconSizes.createReceiverHandler(true /* expectsResponse */));
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.checkOfflineCapability =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        1,
        ContentIndexService_CheckOfflineCapability_ParamsSpec.$,
        ContentIndexService_CheckOfflineCapability_ResponseParamsSpec.$,
        this.checkOfflineCapability.createReceiverHandler(true /* expectsResponse */));
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.add =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        2,
        ContentIndexService_Add_ParamsSpec.$,
        ContentIndexService_Add_ResponseParamsSpec.$,
        this.add.createReceiverHandler(true /* expectsResponse */));
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.delete =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        3,
        ContentIndexService_Delete_ParamsSpec.$,
        ContentIndexService_Delete_ResponseParamsSpec.$,
        this.delete.createReceiverHandler(true /* expectsResponse */));
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.getDescriptions =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        4,
        ContentIndexService_GetDescriptions_ParamsSpec.$,
        ContentIndexService_GetDescriptions_ResponseParamsSpec.$,
        this.getDescriptions.createReceiverHandler(true /* expectsResponse */));
    /** @public {!mojo.internal.interfaceSupport.ConnectionErrorEventRouter} */
    this.onConnectionError = this.helper_internal_.getConnectionErrorEventRouter();
  }

  /**
   * @param {number} id An ID returned by a prior call to addListener.
   * @return {boolean} True iff the identified listener was found and removed.
   */
  removeListener(id) {
    return this.router_.removeListener(id);
  }
}

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const ContentIconDefinitionSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const ContentDescriptionSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const ContentIndexService_GetIconSizes_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const ContentIndexService_GetIconSizes_ResponseParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const ContentIndexService_CheckOfflineCapability_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const ContentIndexService_CheckOfflineCapability_ResponseParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const ContentIndexService_Add_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const ContentIndexService_Add_ResponseParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const ContentIndexService_Delete_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const ContentIndexService_Delete_ResponseParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const ContentIndexService_GetDescriptions_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const ContentIndexService_GetDescriptions_ResponseParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };




mojo.internal.Struct(
    ContentIconDefinitionSpec.$,
    'ContentIconDefinition',
    [
      mojo.internal.StructField(
        'src', 0,
        0,
        mojo.internal.String,
        null,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'sizes', 8,
        0,
        mojo.internal.String,
        null,
        true /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'type', 16,
        0,
        mojo.internal.String,
        null,
        true /* nullable */,
        0,
      ),
    ],
    [[0, 32],]);



/**
 * @record
 */
export class ContentIconDefinition {
  constructor() {
    /** @type { !string } */
    this.src;
    /** @type { (string|undefined) } */
    this.sizes;
    /** @type { (string|undefined) } */
    this.type;
  }
}



mojo.internal.Struct(
    ContentDescriptionSpec.$,
    'ContentDescription',
    [
      mojo.internal.StructField(
        'id', 0,
        0,
        mojo.internal.String,
        null,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'title', 8,
        0,
        mojo.internal.String,
        null,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'description', 16,
        0,
        mojo.internal.String,
        null,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'category', 24,
        0,
        ContentCategorySpec.$,
        0,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'icons', 32,
        0,
        mojo.internal.Array(ContentIconDefinitionSpec.$, false),
        null,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'launchUrl', 40,
        0,
        mojo.internal.String,
        null,
        false /* nullable */,
        0,
      ),
    ],
    [[0, 56],]);



/**
 * @record
 */
export class ContentDescription {
  constructor() {
    /** @type { !string } */
    this.id;
    /** @type { !string } */
    this.title;
    /** @type { !string } */
    this.description;
    /** @type { !ContentCategory } */
    this.category;
    /** @type { !Array<!ContentIconDefinition> } */
    this.icons;
    /** @type { !string } */
    this.launchUrl;
  }
}



mojo.internal.Struct(
    ContentIndexService_GetIconSizes_ParamsSpec.$,
    'ContentIndexService_GetIconSizes_Params',
    [
      mojo.internal.StructField(
        'category', 0,
        0,
        ContentCategorySpec.$,
        0,
        false /* nullable */,
        0,
      ),
    ],
    [[0, 16],]);



/**
 * @record
 */
export class ContentIndexService_GetIconSizes_Params {
  constructor() {
    /** @type { !ContentCategory } */
    this.category;
  }
}



mojo.internal.Struct(
    ContentIndexService_GetIconSizes_ResponseParamsSpec.$,
    'ContentIndexService_GetIconSizes_ResponseParams',
    [
      mojo.internal.StructField(
        'iconSizes', 0,
        0,
        mojo.internal.Array(gfx_mojom_SizeSpec.$, false),
        null,
        false /* nullable */,
        0,
      ),
    ],
    [[0, 16],]);



/**
 * @record
 */
export class ContentIndexService_GetIconSizes_ResponseParams {
  constructor() {
    /** @type { !Array<!gfx_mojom_Size> } */
    this.iconSizes;
  }
}



mojo.internal.Struct(
    ContentIndexService_CheckOfflineCapability_ParamsSpec.$,
    'ContentIndexService_CheckOfflineCapability_Params',
    [
      mojo.internal.StructField(
        'serviceWorkerRegistrationId', 0,
        0,
        mojo.internal.Int64,
        BigInt(0),
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'launchUrl', 8,
        0,
        url_mojom_UrlSpec.$,
        null,
        false /* nullable */,
        0,
      ),
    ],
    [[0, 24],]);



/**
 * @record
 */
export class ContentIndexService_CheckOfflineCapability_Params {
  constructor() {
    /** @type { !bigint } */
    this.serviceWorkerRegistrationId;
    /** @type { !url_mojom_Url } */
    this.launchUrl;
  }
}



mojo.internal.Struct(
    ContentIndexService_CheckOfflineCapability_ResponseParamsSpec.$,
    'ContentIndexService_CheckOfflineCapability_ResponseParams',
    [
      mojo.internal.StructField(
        'isOfflineCapable', 0,
        0,
        mojo.internal.Bool,
        false,
        false /* nullable */,
        0,
      ),
    ],
    [[0, 16],]);



/**
 * @record
 */
export class ContentIndexService_CheckOfflineCapability_ResponseParams {
  constructor() {
    /** @type { !boolean } */
    this.isOfflineCapable;
  }
}



mojo.internal.Struct(
    ContentIndexService_Add_ParamsSpec.$,
    'ContentIndexService_Add_Params',
    [
      mojo.internal.StructField(
        'serviceWorkerRegistrationId', 0,
        0,
        mojo.internal.Int64,
        BigInt(0),
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'description', 8,
        0,
        ContentDescriptionSpec.$,
        null,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'icon', 16,
        0,
        mojo.internal.Array(skia_mojom_BitmapN32Spec.$, false),
        null,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'launchUrl', 24,
        0,
        url_mojom_UrlSpec.$,
        null,
        false /* nullable */,
        0,
      ),
    ],
    [[0, 40],]);



/**
 * @record
 */
export class ContentIndexService_Add_Params {
  constructor() {
    /** @type { !bigint } */
    this.serviceWorkerRegistrationId;
    /** @type { !ContentDescription } */
    this.description;
    /** @type { !Array<!skia_mojom_BitmapN32> } */
    this.icon;
    /** @type { !url_mojom_Url } */
    this.launchUrl;
  }
}



mojo.internal.Struct(
    ContentIndexService_Add_ResponseParamsSpec.$,
    'ContentIndexService_Add_ResponseParams',
    [
      mojo.internal.StructField(
        'error', 0,
        0,
        ContentIndexErrorSpec.$,
        0,
        false /* nullable */,
        0,
      ),
    ],
    [[0, 16],]);



/**
 * @record
 */
export class ContentIndexService_Add_ResponseParams {
  constructor() {
    /** @type { !ContentIndexError } */
    this.error;
  }
}



mojo.internal.Struct(
    ContentIndexService_Delete_ParamsSpec.$,
    'ContentIndexService_Delete_Params',
    [
      mojo.internal.StructField(
        'serviceWorkerRegistrationId', 0,
        0,
        mojo.internal.Int64,
        BigInt(0),
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'id', 8,
        0,
        mojo.internal.String,
        null,
        false /* nullable */,
        0,
      ),
    ],
    [[0, 24],]);



/**
 * @record
 */
export class ContentIndexService_Delete_Params {
  constructor() {
    /** @type { !bigint } */
    this.serviceWorkerRegistrationId;
    /** @type { !string } */
    this.id;
  }
}



mojo.internal.Struct(
    ContentIndexService_Delete_ResponseParamsSpec.$,
    'ContentIndexService_Delete_ResponseParams',
    [
      mojo.internal.StructField(
        'error', 0,
        0,
        ContentIndexErrorSpec.$,
        0,
        false /* nullable */,
        0,
      ),
    ],
    [[0, 16],]);



/**
 * @record
 */
export class ContentIndexService_Delete_ResponseParams {
  constructor() {
    /** @type { !ContentIndexError } */
    this.error;
  }
}



mojo.internal.Struct(
    ContentIndexService_GetDescriptions_ParamsSpec.$,
    'ContentIndexService_GetDescriptions_Params',
    [
      mojo.internal.StructField(
        'serviceWorkerRegistrationId', 0,
        0,
        mojo.internal.Int64,
        BigInt(0),
        false /* nullable */,
        0,
      ),
    ],
    [[0, 16],]);



/**
 * @record
 */
export class ContentIndexService_GetDescriptions_Params {
  constructor() {
    /** @type { !bigint } */
    this.serviceWorkerRegistrationId;
  }
}



mojo.internal.Struct(
    ContentIndexService_GetDescriptions_ResponseParamsSpec.$,
    'ContentIndexService_GetDescriptions_ResponseParams',
    [
      mojo.internal.StructField(
        'error', 0,
        0,
        ContentIndexErrorSpec.$,
        0,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'descriptions', 8,
        0,
        mojo.internal.Array(ContentDescriptionSpec.$, false),
        null,
        false /* nullable */,
        0,
      ),
    ],
    [[0, 24],]);



/**
 * @record
 */
export class ContentIndexService_GetDescriptions_ResponseParams {
  constructor() {
    /** @type { !ContentIndexError } */
    this.error;
    /** @type { !Array<!ContentDescription> } */
    this.descriptions;
  }
}

