// third_party/blink/public/mojom/serial/serial.mojom.m.js is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2020 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

import {mojo} from '../../../../../mojo/public/js/bindings.js';

import {
  UUID as bluetooth_mojom_UUID,
  UUIDSpec as bluetooth_mojom_UUIDSpec
} from '../../../../../device/bluetooth/public/mojom/uuid.mojom.m.js';

import {
  UnguessableToken as mojoBase_mojom_UnguessableToken,
  UnguessableTokenSpec as mojoBase_mojom_UnguessableTokenSpec
} from '../../../../../mojo/public/mojom/base/unguessable_token.mojom.m.js';

import {
  SerialPortRemote as device_mojom_SerialPortRemote,
  SerialPortPendingReceiver as device_mojom_SerialPortPendingReceiver,
  SerialPortClientRemote as device_mojom_SerialPortClientRemote,
  SerialPortClientPendingReceiver as device_mojom_SerialPortClientPendingReceiver,
  SerialConnectionOptions as device_mojom_SerialConnectionOptions,
  SerialConnectionOptionsSpec as device_mojom_SerialConnectionOptionsSpec
} from '../../../../../services/device/public/mojom/serial.mojom.m.js';




/**
 * @implements {mojo.internal.interfaceSupport.PendingReceiver}
 */
export class SerialServicePendingReceiver {
  /**
   * @param {!MojoHandle|!mojo.internal.interfaceSupport.Endpoint} handle
   */
  constructor(handle) {
    /** @public {!mojo.internal.interfaceSupport.Endpoint} */
    this.handle = mojo.internal.interfaceSupport.getEndpointForReceiver(handle);
  }

  /** @param {string=} scope */
  bindInBrowser(scope = 'context') {
    mojo.internal.interfaceSupport.bind(
        this.handle, 'blink.mojom.SerialService', scope);
  }
}

/** @interface */
export class SerialServiceInterface {
  
  /**
   * @param { !SerialServiceClientRemote } client
   */

  setClient(client) {}
  
  /**
   * @return {!Promise<{
        ports: !Array<!SerialPortInfo>,
   *  }>}
   */

  getPorts() {}
  
  /**
   * @param { !Array<!SerialPortFilter> } filters
   * @param { !Array<!bluetooth_mojom_UUID> } allowedBluetoothServiceClassIds
   * @return {!Promise<{
        port: ?SerialPortInfo,
   *  }>}
   */

  requestPort(filters, allowedBluetoothServiceClassIds) {}
  
  /**
   * @param { !mojoBase_mojom_UnguessableToken } token
   * @param { !device_mojom_SerialConnectionOptions } options
   * @param { !device_mojom_SerialPortClientRemote } client
   * @return {!Promise<{
        port: ?device_mojom_SerialPortRemote,
   *  }>}
   */

  openPort(token, options, client) {}
  
  /**
   * @param { !mojoBase_mojom_UnguessableToken } token
   * @return {!Promise}
   */

  forgetPort(token) {}
}

/**
 * @implements { SerialServiceInterface }
 */
export class SerialServiceRemote {
  /** @param {MojoHandle|mojo.internal.interfaceSupport.Endpoint=} handle */
  constructor(handle = undefined) {
    /**
     * @private {!mojo.internal.interfaceSupport.InterfaceRemoteBase<!SerialServicePendingReceiver>}
     */
    this.proxy =
        new mojo.internal.interfaceSupport.InterfaceRemoteBase(
          SerialServicePendingReceiver,
          handle);

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceRemoteBaseWrapper<!SerialServicePendingReceiver>}
     */
    this.$ = new mojo.internal.interfaceSupport.InterfaceRemoteBaseWrapper(this.proxy);

    /** @public {!mojo.internal.interfaceSupport.ConnectionErrorEventRouter} */
    this.onConnectionError = this.proxy.getConnectionErrorEventRouter();
  }

  
  /**
   * @param { !SerialServiceClientRemote } client
   */

  setClient(
      client) {
    this.proxy.sendMessage(
        0,
        SerialService_SetClient_ParamsSpec.$,
        null,
        [
          client
        ]);
  }

  
  /**
   * @return {!Promise<{
        ports: !Array<!SerialPortInfo>,
   *  }>}
   */

  getPorts() {
    return this.proxy.sendMessage(
        1,
        SerialService_GetPorts_ParamsSpec.$,
        SerialService_GetPorts_ResponseParamsSpec.$,
        [
        ]);
  }

  
  /**
   * @param { !Array<!SerialPortFilter> } filters
   * @param { !Array<!bluetooth_mojom_UUID> } allowedBluetoothServiceClassIds
   * @return {!Promise<{
        port: ?SerialPortInfo,
   *  }>}
   */

  requestPort(
      filters,
      allowedBluetoothServiceClassIds) {
    return this.proxy.sendMessage(
        2,
        SerialService_RequestPort_ParamsSpec.$,
        SerialService_RequestPort_ResponseParamsSpec.$,
        [
          filters,
          allowedBluetoothServiceClassIds
        ]);
  }

  
  /**
   * @param { !mojoBase_mojom_UnguessableToken } token
   * @param { !device_mojom_SerialConnectionOptions } options
   * @param { !device_mojom_SerialPortClientRemote } client
   * @return {!Promise<{
        port: ?device_mojom_SerialPortRemote,
   *  }>}
   */

  openPort(
      token,
      options,
      client) {
    return this.proxy.sendMessage(
        3,
        SerialService_OpenPort_ParamsSpec.$,
        SerialService_OpenPort_ResponseParamsSpec.$,
        [
          token,
          options,
          client
        ]);
  }

  
  /**
   * @param { !mojoBase_mojom_UnguessableToken } token
   * @return {!Promise}
   */

  forgetPort(
      token) {
    return this.proxy.sendMessage(
        4,
        SerialService_ForgetPort_ParamsSpec.$,
        SerialService_ForgetPort_ResponseParamsSpec.$,
        [
          token
        ]);
  }
}

/**
 * An object which receives request messages for the SerialService
 * mojom interface. Must be constructed over an object which implements that
 * interface.
 */
export class SerialServiceReceiver {
  /**
   * @param {!SerialServiceInterface } impl
   */
  constructor(impl) {
    /** @private {!mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal<!SerialServiceRemote>} */
    this.helper_internal_ = new mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal(
        SerialServiceRemote);

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceReceiverHelper<!SerialServiceRemote>}
     */
    this.$ = new mojo.internal.interfaceSupport.InterfaceReceiverHelper(this.helper_internal_);


    this.helper_internal_.registerHandler(
        0,
        SerialService_SetClient_ParamsSpec.$,
        null,
        impl.setClient.bind(impl));
    this.helper_internal_.registerHandler(
        1,
        SerialService_GetPorts_ParamsSpec.$,
        SerialService_GetPorts_ResponseParamsSpec.$,
        impl.getPorts.bind(impl));
    this.helper_internal_.registerHandler(
        2,
        SerialService_RequestPort_ParamsSpec.$,
        SerialService_RequestPort_ResponseParamsSpec.$,
        impl.requestPort.bind(impl));
    this.helper_internal_.registerHandler(
        3,
        SerialService_OpenPort_ParamsSpec.$,
        SerialService_OpenPort_ResponseParamsSpec.$,
        impl.openPort.bind(impl));
    this.helper_internal_.registerHandler(
        4,
        SerialService_ForgetPort_ParamsSpec.$,
        SerialService_ForgetPort_ResponseParamsSpec.$,
        impl.forgetPort.bind(impl));
    /** @public {!mojo.internal.interfaceSupport.ConnectionErrorEventRouter} */
    this.onConnectionError = this.helper_internal_.getConnectionErrorEventRouter();
  }
}

export class SerialService {
  /**
   * @return {!string}
   */
  static get $interfaceName() {
    return "blink.mojom.SerialService";
  }

  /**
   * Returns a remote for this interface which sends messages to the browser.
   * The browser must have an interface request binder registered for this
   * interface and accessible to the calling document's frame.
   *
   * @return {!SerialServiceRemote}
   */
  static getRemote() {
    let remote = new SerialServiceRemote;
    remote.$.bindNewPipeAndPassReceiver().bindInBrowser();
    return remote;
  }
}


/**
 * An object which receives request messages for the SerialService
 * mojom interface and dispatches them as callbacks. One callback receiver exists
 * on this object for each message defined in the mojom interface, and each
 * receiver can have any number of listeners added to it.
 */
export class SerialServiceCallbackRouter {
  constructor() {
    this.helper_internal_ = new mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal(
      SerialServiceRemote);

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceReceiverHelper<!SerialServiceRemote>}
     */
    this.$ = new mojo.internal.interfaceSupport.InterfaceReceiverHelper(this.helper_internal_);

    this.router_ = new mojo.internal.interfaceSupport.CallbackRouter;

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.setClient =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        0,
        SerialService_SetClient_ParamsSpec.$,
        null,
        this.setClient.createReceiverHandler(false /* expectsResponse */));
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.getPorts =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        1,
        SerialService_GetPorts_ParamsSpec.$,
        SerialService_GetPorts_ResponseParamsSpec.$,
        this.getPorts.createReceiverHandler(true /* expectsResponse */));
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.requestPort =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        2,
        SerialService_RequestPort_ParamsSpec.$,
        SerialService_RequestPort_ResponseParamsSpec.$,
        this.requestPort.createReceiverHandler(true /* expectsResponse */));
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.openPort =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        3,
        SerialService_OpenPort_ParamsSpec.$,
        SerialService_OpenPort_ResponseParamsSpec.$,
        this.openPort.createReceiverHandler(true /* expectsResponse */));
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.forgetPort =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        4,
        SerialService_ForgetPort_ParamsSpec.$,
        SerialService_ForgetPort_ResponseParamsSpec.$,
        this.forgetPort.createReceiverHandler(true /* expectsResponse */));
    /** @public {!mojo.internal.interfaceSupport.ConnectionErrorEventRouter} */
    this.onConnectionError = this.helper_internal_.getConnectionErrorEventRouter();
  }

  /**
   * @param {number} id An ID returned by a prior call to addListener.
   * @return {boolean} True iff the identified listener was found and removed.
   */
  removeListener(id) {
    return this.router_.removeListener(id);
  }
}


/**
 * @implements {mojo.internal.interfaceSupport.PendingReceiver}
 */
export class SerialServiceClientPendingReceiver {
  /**
   * @param {!MojoHandle|!mojo.internal.interfaceSupport.Endpoint} handle
   */
  constructor(handle) {
    /** @public {!mojo.internal.interfaceSupport.Endpoint} */
    this.handle = mojo.internal.interfaceSupport.getEndpointForReceiver(handle);
  }

  /** @param {string=} scope */
  bindInBrowser(scope = 'context') {
    mojo.internal.interfaceSupport.bind(
        this.handle, 'blink.mojom.SerialServiceClient', scope);
  }
}

/** @interface */
export class SerialServiceClientInterface {
  
  /**
   * @param { !SerialPortInfo } portInfo
   */

  onPortConnectedStateChanged(portInfo) {}
}

/**
 * @implements { SerialServiceClientInterface }
 */
export class SerialServiceClientRemote {
  /** @param {MojoHandle|mojo.internal.interfaceSupport.Endpoint=} handle */
  constructor(handle = undefined) {
    /**
     * @private {!mojo.internal.interfaceSupport.InterfaceRemoteBase<!SerialServiceClientPendingReceiver>}
     */
    this.proxy =
        new mojo.internal.interfaceSupport.InterfaceRemoteBase(
          SerialServiceClientPendingReceiver,
          handle);

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceRemoteBaseWrapper<!SerialServiceClientPendingReceiver>}
     */
    this.$ = new mojo.internal.interfaceSupport.InterfaceRemoteBaseWrapper(this.proxy);

    /** @public {!mojo.internal.interfaceSupport.ConnectionErrorEventRouter} */
    this.onConnectionError = this.proxy.getConnectionErrorEventRouter();
  }

  
  /**
   * @param { !SerialPortInfo } portInfo
   */

  onPortConnectedStateChanged(
      portInfo) {
    this.proxy.sendMessage(
        0,
        SerialServiceClient_OnPortConnectedStateChanged_ParamsSpec.$,
        null,
        [
          portInfo
        ]);
  }
}

/**
 * An object which receives request messages for the SerialServiceClient
 * mojom interface. Must be constructed over an object which implements that
 * interface.
 */
export class SerialServiceClientReceiver {
  /**
   * @param {!SerialServiceClientInterface } impl
   */
  constructor(impl) {
    /** @private {!mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal<!SerialServiceClientRemote>} */
    this.helper_internal_ = new mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal(
        SerialServiceClientRemote);

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceReceiverHelper<!SerialServiceClientRemote>}
     */
    this.$ = new mojo.internal.interfaceSupport.InterfaceReceiverHelper(this.helper_internal_);


    this.helper_internal_.registerHandler(
        0,
        SerialServiceClient_OnPortConnectedStateChanged_ParamsSpec.$,
        null,
        impl.onPortConnectedStateChanged.bind(impl));
    /** @public {!mojo.internal.interfaceSupport.ConnectionErrorEventRouter} */
    this.onConnectionError = this.helper_internal_.getConnectionErrorEventRouter();
  }
}

export class SerialServiceClient {
  /**
   * @return {!string}
   */
  static get $interfaceName() {
    return "blink.mojom.SerialServiceClient";
  }

  /**
   * Returns a remote for this interface which sends messages to the browser.
   * The browser must have an interface request binder registered for this
   * interface and accessible to the calling document's frame.
   *
   * @return {!SerialServiceClientRemote}
   */
  static getRemote() {
    let remote = new SerialServiceClientRemote;
    remote.$.bindNewPipeAndPassReceiver().bindInBrowser();
    return remote;
  }
}


/**
 * An object which receives request messages for the SerialServiceClient
 * mojom interface and dispatches them as callbacks. One callback receiver exists
 * on this object for each message defined in the mojom interface, and each
 * receiver can have any number of listeners added to it.
 */
export class SerialServiceClientCallbackRouter {
  constructor() {
    this.helper_internal_ = new mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal(
      SerialServiceClientRemote);

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceReceiverHelper<!SerialServiceClientRemote>}
     */
    this.$ = new mojo.internal.interfaceSupport.InterfaceReceiverHelper(this.helper_internal_);

    this.router_ = new mojo.internal.interfaceSupport.CallbackRouter;

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.onPortConnectedStateChanged =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        0,
        SerialServiceClient_OnPortConnectedStateChanged_ParamsSpec.$,
        null,
        this.onPortConnectedStateChanged.createReceiverHandler(false /* expectsResponse */));
    /** @public {!mojo.internal.interfaceSupport.ConnectionErrorEventRouter} */
    this.onConnectionError = this.helper_internal_.getConnectionErrorEventRouter();
  }

  /**
   * @param {number} id An ID returned by a prior call to addListener.
   * @return {boolean} True iff the identified listener was found and removed.
   */
  removeListener(id) {
    return this.router_.removeListener(id);
  }
}

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const SerialPortInfoSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const SerialPortFilterSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const SerialService_SetClient_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const SerialService_GetPorts_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const SerialService_GetPorts_ResponseParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const SerialService_RequestPort_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const SerialService_RequestPort_ResponseParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const SerialService_OpenPort_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const SerialService_OpenPort_ResponseParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const SerialService_ForgetPort_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const SerialService_ForgetPort_ResponseParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const SerialServiceClient_OnPortConnectedStateChanged_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };




mojo.internal.Struct(
    SerialPortInfoSpec.$,
    'SerialPortInfo',
    [
      mojo.internal.StructField(
        'token', 0,
        0,
        mojoBase_mojom_UnguessableTokenSpec.$,
        null,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'usbVendorId', 8,
        0,
        mojo.internal.Uint16,
        0,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'hasUsbVendorId', 10,
        0,
        mojo.internal.Bool,
        false,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'usbProductId', 12,
        0,
        mojo.internal.Uint16,
        0,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'hasUsbProductId', 10,
        1,
        mojo.internal.Bool,
        false,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'bluetoothServiceClassId', 16,
        0,
        bluetooth_mojom_UUIDSpec.$,
        null,
        true /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'connected', 10,
        2,
        mojo.internal.Bool,
        false,
        false /* nullable */,
        0,
      ),
    ],
    [[0, 32],]);



/**
 * @record
 */
export class SerialPortInfo {
  constructor() {
    /** @type { !mojoBase_mojom_UnguessableToken } */
    this.token;
    /** @type { !number } */
    this.usbVendorId;
    /** @type { !boolean } */
    this.hasUsbVendorId;
    /** @type { !number } */
    this.usbProductId;
    /** @type { !boolean } */
    this.hasUsbProductId;
    /** @type { (bluetooth_mojom_UUID|undefined) } */
    this.bluetoothServiceClassId;
    /** @type { !boolean } */
    this.connected;
  }
}



mojo.internal.Struct(
    SerialPortFilterSpec.$,
    'SerialPortFilter',
    [
      mojo.internal.StructField(
        'vendorId', 0,
        0,
        mojo.internal.Uint32,
        0,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'hasVendorId', 4,
        0,
        mojo.internal.Bool,
        false,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'productId', 6,
        0,
        mojo.internal.Uint16,
        0,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'hasProductId', 4,
        1,
        mojo.internal.Bool,
        false,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'bluetoothServiceClassId', 8,
        0,
        bluetooth_mojom_UUIDSpec.$,
        null,
        true /* nullable */,
        0,
      ),
    ],
    [[0, 24],]);



/**
 * @record
 */
export class SerialPortFilter {
  constructor() {
    /** @type { !number } */
    this.vendorId;
    /** @type { !boolean } */
    this.hasVendorId;
    /** @type { !number } */
    this.productId;
    /** @type { !boolean } */
    this.hasProductId;
    /** @type { (bluetooth_mojom_UUID|undefined) } */
    this.bluetoothServiceClassId;
  }
}



mojo.internal.Struct(
    SerialService_SetClient_ParamsSpec.$,
    'SerialService_SetClient_Params',
    [
      mojo.internal.StructField(
        'client', 0,
        0,
        mojo.internal.InterfaceProxy(SerialServiceClientRemote),
        null,
        false /* nullable */,
        0,
      ),
    ],
    [[0, 16],]);



/**
 * @record
 */
export class SerialService_SetClient_Params {
  constructor() {
    /** @type { !SerialServiceClientRemote } */
    this.client;
  }
}



mojo.internal.Struct(
    SerialService_GetPorts_ParamsSpec.$,
    'SerialService_GetPorts_Params',
    [
    ],
    [[0, 8],]);



/**
 * @record
 */
export class SerialService_GetPorts_Params {
  constructor() {
  }
}



mojo.internal.Struct(
    SerialService_GetPorts_ResponseParamsSpec.$,
    'SerialService_GetPorts_ResponseParams',
    [
      mojo.internal.StructField(
        'ports', 0,
        0,
        mojo.internal.Array(SerialPortInfoSpec.$, false),
        null,
        false /* nullable */,
        0,
      ),
    ],
    [[0, 16],]);



/**
 * @record
 */
export class SerialService_GetPorts_ResponseParams {
  constructor() {
    /** @type { !Array<!SerialPortInfo> } */
    this.ports;
  }
}



mojo.internal.Struct(
    SerialService_RequestPort_ParamsSpec.$,
    'SerialService_RequestPort_Params',
    [
      mojo.internal.StructField(
        'filters', 0,
        0,
        mojo.internal.Array(SerialPortFilterSpec.$, false),
        null,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'allowedBluetoothServiceClassIds', 8,
        0,
        mojo.internal.Array(bluetooth_mojom_UUIDSpec.$, false),
        null,
        false /* nullable */,
        0,
      ),
    ],
    [[0, 24],]);



/**
 * @record
 */
export class SerialService_RequestPort_Params {
  constructor() {
    /** @type { !Array<!SerialPortFilter> } */
    this.filters;
    /** @type { !Array<!bluetooth_mojom_UUID> } */
    this.allowedBluetoothServiceClassIds;
  }
}



mojo.internal.Struct(
    SerialService_RequestPort_ResponseParamsSpec.$,
    'SerialService_RequestPort_ResponseParams',
    [
      mojo.internal.StructField(
        'port', 0,
        0,
        SerialPortInfoSpec.$,
        null,
        true /* nullable */,
        0,
      ),
    ],
    [[0, 16],]);



/**
 * @record
 */
export class SerialService_RequestPort_ResponseParams {
  constructor() {
    /** @type { (SerialPortInfo|undefined) } */
    this.port;
  }
}



mojo.internal.Struct(
    SerialService_OpenPort_ParamsSpec.$,
    'SerialService_OpenPort_Params',
    [
      mojo.internal.StructField(
        'token', 0,
        0,
        mojoBase_mojom_UnguessableTokenSpec.$,
        null,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'options', 8,
        0,
        device_mojom_SerialConnectionOptionsSpec.$,
        null,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'client', 16,
        0,
        mojo.internal.InterfaceProxy(device_mojom_SerialPortClientRemote),
        null,
        false /* nullable */,
        0,
      ),
    ],
    [[0, 32],]);



/**
 * @record
 */
export class SerialService_OpenPort_Params {
  constructor() {
    /** @type { !mojoBase_mojom_UnguessableToken } */
    this.token;
    /** @type { !device_mojom_SerialConnectionOptions } */
    this.options;
    /** @type { !device_mojom_SerialPortClientRemote } */
    this.client;
  }
}



mojo.internal.Struct(
    SerialService_OpenPort_ResponseParamsSpec.$,
    'SerialService_OpenPort_ResponseParams',
    [
      mojo.internal.StructField(
        'port', 0,
        0,
        mojo.internal.InterfaceProxy(device_mojom_SerialPortRemote),
        null,
        true /* nullable */,
        0,
      ),
    ],
    [[0, 16],]);



/**
 * @record
 */
export class SerialService_OpenPort_ResponseParams {
  constructor() {
    /** @type { (device_mojom_SerialPortRemote|undefined) } */
    this.port;
  }
}



mojo.internal.Struct(
    SerialService_ForgetPort_ParamsSpec.$,
    'SerialService_ForgetPort_Params',
    [
      mojo.internal.StructField(
        'token', 0,
        0,
        mojoBase_mojom_UnguessableTokenSpec.$,
        null,
        false /* nullable */,
        0,
      ),
    ],
    [[0, 16],]);



/**
 * @record
 */
export class SerialService_ForgetPort_Params {
  constructor() {
    /** @type { !mojoBase_mojom_UnguessableToken } */
    this.token;
  }
}



mojo.internal.Struct(
    SerialService_ForgetPort_ResponseParamsSpec.$,
    'SerialService_ForgetPort_ResponseParams',
    [
    ],
    [[0, 8],]);



/**
 * @record
 */
export class SerialService_ForgetPort_ResponseParams {
  constructor() {
  }
}



mojo.internal.Struct(
    SerialServiceClient_OnPortConnectedStateChanged_ParamsSpec.$,
    'SerialServiceClient_OnPortConnectedStateChanged_Params',
    [
      mojo.internal.StructField(
        'portInfo', 0,
        0,
        SerialPortInfoSpec.$,
        null,
        false /* nullable */,
        0,
      ),
    ],
    [[0, 16],]);



/**
 * @record
 */
export class SerialServiceClient_OnPortConnectedStateChanged_Params {
  constructor() {
    /** @type { !SerialPortInfo } */
    this.portInfo;
  }
}

