#version 420 core
precision mediump float;

in mediump vec2 TexCoord;
out mediump vec4 FragColor;

uniform sampler2D y_sampler;
uniform sampler2D u_sampler;
uniform sampler2D v_sampler;

uniform bool rgba_static;
uniform sampler2D rgb_sampler;

// test params
uniform bool bool_param;
uniform int int_param;
uniform float float_param;
uniform float float_alpha;

void main()
{
    // use all test params
    if (rgba_static || (bool_param && int_param > 0 && float_param > 0.0)) {
        vec4 texColor = texture(rgb_sampler, TexCoord);

        if (texColor.a < 0.1) {
            discard;
        }
        else {
            FragColor = texColor;
        }

        FragColor = vec4(FragColor.rgb * float_alpha, 1.0);

    } else {
        float yChannel = texture(y_sampler, TexCoord).x;
        float uChannel = texture(u_sampler, TexCoord).x;
        float vChannel = texture(v_sampler, TexCoord).x;
        vec4 channels = vec4(yChannel, uChannel, vChannel, 1.0);
        mat4 conversion = mat4(
            1.1643,         0.0,      1.5958, -0.87066875,
            1.1643,    -0.39173,    -0.81290,  0.52954625,
            1.1643,       2.017,         0.0, -1.08126875,
               0.0,         0.0,         0.0,         0.0
        );

        FragColor = vec4((channels * conversion).rgb, 1.0);
    }
}