/*
Copyright 2000-2020 Citrix Systems, Inc. All rights reserved.
This software and documentation contain valuable trade secrets
and proprietary property belonging to Citrix Systems, Inc.
None of this software and documentation may be copied,
duplicated or disclosed without the express written permission
of Citrix Systems, Inc.
*/

#include "ns_usrdef.h"

/* FUNCTION :	ns_userDefFieldName
   DESCRIPTION:	ns_userDefFieldName is a unresolved
				symbol in nswl library.If a custom based
				log format is specified in the weblog config file,
				this function is called to create an custom field name in
				the header in the log file.
  INPUT :		NONE
  OUTPUT:		RETURNS the string to be appended at the end of record header.

*/

char *ns_userDefFieldName()
{
	/* Return NULL terminated custom field name string here */
	return ("");
}

/* FUNCTION :	ns_userDefFieldVal
   DESCRIPTION:	ns_userDefFieldVal is a unresolved
				symbol in nswl library.If a custom based
				log format is specified in the weblog config file,
				this function is called with Log record header and
				length as input arguments to get the custom field val,
  INPUT :		Log Record header string,and its length
  OUTPUT:		RETURNS the string to be appended at the end of record.

*/

char *ns_userDefFieldVal(const char *header , int len)
{
	/* Implement the custom field value and
		then return it in the form of the NULL terminated string. */
	return ("");
}


