#pragma once
#include <Windows.h>
#include <dshow.h>
#include <stdio.h>
#include "WebCamPreview.h"

#define WM_GRAPHNOTIFY  WM_APP+600


class DSWebCamPreview : public WebCamPreview
{
 public:
    DSWebCamPreview()
    {
        LOG << "DS WebcamPreview started\r\n";
        if (CoInitializeEx(nullptr, COINIT_APARTMENTTHREADED | COINIT_DISABLE_OLE1DDE) != S_OK)
            LOG << "COM initialisation failed.\r\n";
        GetInterfaces();
    }
    ~DSWebCamPreview() override;
    HRESULT ListWebCams() override;
    HRESULT SetWebCam(ULONG index) override;
    HRESULT ListWebCamResolutions() override;
    HRESULT Start(HANDLE& ThreadHandle, ULONG index) override;
    HRESULT Stop() override;

    DSWebCamPreview(DSWebCamPreview const&) = delete;
    DSWebCamPreview& operator=(DSWebCamPreview const&) = delete;
    DSWebCamPreview& operator=(DSWebCamPreview const&&) = delete;

 private:
    // Members:
    // Graph builder
    IGraphBuilder* pGraphBuilder;
    // Selected camera.Set when Webcam is Selected
    IMoniker* pMoniker;
    // Rendering window
    IVideoWindow* pVideoWindow;
    // media(video render) event and control handles
    IMediaEventEx* pMediaEvent;
    IMediaControl* pMediaControl;

    // Functions:
    HRESULT GetInterfaces();
    HRESULT GetMonikerEnumerator(IEnumMoniker** ppMonikerEnum) const;  // helper for ListDevices,ActivateDevice
    HRESULT ListDevices();
    HRESULT ActivateDevice(ULONG index);
    HRESULT ListCaptureFormats();
    HRESULT SetCaptureFormat(ULONG index);
    HRESULT SetupVideoWindow();
    HRESULT FilterCleanup();
};

