#pragma once

#include <Windows.h>
#include <sstream>
#include <iomanip>
#include <cstdarg>
#include <string>
#include <mutex>
#include "resource.h"

extern HWND hDlg;  // main dialog handle


static std::wstring TimeNowStr(bool forFile = false)
{
    SYSTEMTIME st;
    GetLocalTime(&st);
    wchar_t szTime[128] = { 0 };
    if (forFile)
        swprintf_s(szTime, L"%4d%02d%02d%02d%02d%02d%03d", st.wYear, st.wMonth, st.wDay, st.wHour, st.wMinute, st.wSecond, st.wMilliseconds);
    else
        swprintf_s(szTime, L"%4d-%02d-%02d %02d:%02d:%02d.%03d", st.wYear, st.wMonth, st.wDay, st.wHour, st.wMinute, st.wSecond, st.wMilliseconds);
    return std::wstring(szTime);
}


class TEstringstream :public std::wostringstream
{
public:
    TEstringstream() = default;//just to init

    TEstringstream(HWND hWnd, int ID)
    {
        hWndLog = GetDlgItem(hWnd, ID);
        SendMessage(hWndLog, EM_LIMITTEXT, 0, 0);//remove 30,000 char limit for log box
    }

    template<typename T>
    TEstringstream& operator<<(const T& sMessage)
    {        
        m_log_stream << sMessage;
        if(hWndLog)
            appendLogText(m_log_stream.str().c_str());
        m_log_stream.str(std::wstring());
        return *this;
    }
    TEstringstream& operator<<(REFGUID guid) {
        std::wostringstream tmp_stream;
        tmp_stream
            << std::setfill(L'0') << std::hex << std::uppercase
            << std::setw(8) << guid.Data1
            << '-'
            << std::setw(4) << guid.Data2
            << '-'
            << std::setw(4) << guid.Data3
            << '-'
            << std::setw(2) << guid.Data4[0]
            << std::setw(2) << guid.Data4[1]
            << '-'
            << std::setw(2) << guid.Data4[2]
            << std::setw(2) << guid.Data4[3]
            << std::setw(2) << guid.Data4[4]
            << std::setw(2) << guid.Data4[5]
            << std::setw(2) << guid.Data4[6]
            << std::setw(2) << guid.Data4[7]
            << std::nouppercase;
        *this << tmp_stream.str();
        return *this;
    }

private:

    HWND hWndLog = nullptr;
    std::wostringstream m_log_stream;

    void appendLogText(LPCTSTR newText)
    {
        int left = 0;
        int right = 0;
        int len = GetWindowTextLength(hWndLog);
        SendMessage(hWndLog, EM_GETSEL, (WPARAM)&left, (LPARAM)&right);
        SendMessage(hWndLog, EM_SETSEL, len, len);
        SendMessage(hWndLog, EM_REPLACESEL, 0, (LPARAM)newText);
        SendMessage(hWndLog, EM_SETSEL, left, right);
    }
    

};

class TEditLogger
{
public:
    template<typename T>
    TEstringstream& operator<<(const T& sMessage)
    {

        std::lock_guard<std::mutex> lock(mtx);
        m_log_stream << TimeNowStr() << " :    " << sMessage;
        return m_log_stream;
    }
    static TEditLogger& GetLogger()
    {
        static TEditLogger logger;
        return logger;
    }
private:

    TEstringstream m_log_stream;
    std::mutex mtx;

    TEditLogger()
    {
        m_log_stream = TEstringstream(hDlg, IDC_EDIT_INFO);
    }

};


#define LOG TEditLogger::GetLogger()
