#pragma once
#include "WebCamPreview.h"
#include "MFUtils.h"

class MFWebCamPreview : public WebCamPreview
{
 public:
    MFWebCamPreview()
    {
        LOG << "MF Webcam Preview started\r\n";
        if (CoInitializeEx(nullptr, COINIT_APARTMENTTHREADED | COINIT_DISABLE_OLE1DDE) != S_OK)
            LOG << "COM initialisation failed.\r\n";
        if (MFStartup(MF_VERSION) != S_OK)
            LOG << "Media Foundation initialisation failed.\r\n";  // will fail and exit in subsequent function calls
    }
    ~MFWebCamPreview() override;
    HRESULT ListWebCams() override;
    HRESULT SetWebCam(ULONG index) override;
    HRESULT ListWebCamResolutions() override;
    HRESULT Start(HANDLE& ThreadHandle, ULONG index) override;
    HRESULT Stop() override;

    MFWebCamPreview(MFWebCamPreview const&) = delete;
    MFWebCamPreview& operator=(MFWebCamPreview const&) = delete;
    MFWebCamPreview& operator=(MFWebCamPreview const&&) = delete;


 private:
    // Members
    IMFMediaSource* pSource = nullptr;
    IMFMediaSession* pSession = nullptr;

    // functions
    HRESULT BuildTopology(HWND hWnd);
    HRESULT AddSourceNode(IMFTopology* pTopology, IMFMediaSource* pSource, IMFPresentationDescriptor* pPD, IMFStreamDescriptor* pSD, IMFTopologyNode** ppNode);  // helper for BuildTopology
    HRESULT AddOutputNode(IMFTopology* pTopology, IMFActivate* pActivate, DWORD dwId, IMFTopologyNode** ppNode);  // helper for BuildTopology
    HRESULT ListDevices();
    HRESULT ActivateDevice(ULONG index);
    HRESULT GetMediaHandler(IMFMediaTypeHandler** ppHandler);  // helper for capture format
    HRESULT ListCaptureFormats();
    HRESULT SetCaptureFormat(ULONG index);
};

