#include <condition_variable>
#include"PlayerWindow.h"

HWND hWnd;
#ifndef _CONSOLE
extern HWND hDlg;  // main dialog handle
#else
HWND hDlg = NULL;
#endif
std::atomic_bool ready;

LRESULT CALLBACK WindowProc(HWND hwnd, UINT uMsg, WPARAM wParam, LPARAM lParam)
{
    switch (uMsg)
    {
    case WM_CREATE:
    {
        auto monitor = MonitorFromWindow(hDlg, MONITOR_DEFAULTTONEAREST);
        MONITORINFOEX info;
        info.cbSize = sizeof(info);
        GetMonitorInfo(monitor, &info);
        SetWindowPos(hwnd, HWND_TOP, info.rcMonitor.left + 60, info.rcMonitor.top + 60, 0, 0, SWP_NOSIZE);
        return TRUE;
    }
    case WM_DESTROY:
    {
        PostQuitMessage(0);
        return 0;
    }
    case WM_CLOSE:
    {
        PostMessage(hDlg, WM_PREVIEW_COMPLETE, 0, 0);
        DestroyWindow(hwnd);
        return 0;
    }
    default:
        return DefWindowProc(hwnd, uMsg, wParam, lParam);
    }
}


DWORD InitializeWindow(LPVOID lpThreadParameter)
{
    auto rInfo = reinterpret_cast<ResolutionInfo*>(lpThreadParameter);
    HINSTANCE instance = GetModuleHandle(nullptr);

    static WNDCLASS wc = { 0 };
    WNDCLASSEX wcx;
    bool okToRun = true;
    const WCHAR CLASS_NAME[] = L"WebcamPreview";
    const WCHAR WINDOW_NAME[] = L"Webcam Preview";
    if (!GetClassInfoEx(instance, CLASS_NAME, &wcx))
    {
        wc.lpfnWndProc = WindowProc;
        wc.hInstance = instance;
        wc.hCursor = LoadCursor(nullptr, IDC_ARROW);
        wc.lpszClassName = CLASS_NAME;
        okToRun = RegisterClass(&wc) != 0;
    }
    if (okToRun)
    {
        // Adjust window to selected video size
        RECT videoRect = { 0,0,rInfo->width,rInfo->height };
        AdjustWindowRect(&videoRect, WS_OVERLAPPEDWINDOW, false);

        hWnd = CreateWindow(
            CLASS_NAME,
            WINDOW_NAME,
            WS_OVERLAPPED | WS_SYSMENU | WS_MINIMIZEBOX | WS_CLIPCHILDREN,
            CW_USEDEFAULT,
            CW_USEDEFAULT,
            videoRect.right - videoRect.left,
            videoRect.bottom - videoRect.top,
            nullptr,
            nullptr,
            instance,
            nullptr);

        if (hWnd)
        {
            ShowWindow(hWnd, SW_SHOWDEFAULT);
            MSG msg = { 0 };
            ready = true;
            while (GetMessage(&msg, hWnd, 0, 0) > 0)
            {
                TranslateMessage(&msg);
                DispatchMessage(&msg);
            }
        }
    }
    return 0;
}

HRESULT CreatePlayerWindow(ResolutionInfo rInfo, HANDLE& threadHandle)
{
    ready = false;
    // Create a WebCam Preview Window in the separate thread
    threadHandle = CreateThread(nullptr, 0, (LPTHREAD_START_ROUTINE)InitializeWindow, &rInfo, 0, nullptr);
    // Wait a sec to allow window be initialized
    while (!ready)
        std::this_thread::yield();  
    if (hWnd == nullptr)
        return E_FAIL;
    return S_OK;
}
