#pragma once
#include <Windows.h>
#include "Common.h"

class WebCamPreview
{
 public:
    // functions
    WebCamPreview() = default;
    virtual ~WebCamPreview() = default;
    virtual HRESULT ListWebCams() = 0;
    virtual HRESULT SetWebCam(ULONG index) = 0;
    virtual HRESULT ListWebCamResolutions() = 0;
    virtual HRESULT Start(HANDLE& ThreadHandle, ULONG index) = 0;
    virtual HRESULT Stop() = 0;
    std::vector<CameraInfo> GetCameras() const
    {
        return cameraInfos;
    }
    const std::vector<ResolutionInfo> &GetCameraResolutions() const
    {
        return resolutionInfos;
    }
    ULONG &ResIndex()
    {
        return selectedResolutionIndex;
    }   

 protected:
    // members
     std::vector<CameraInfo> cameraInfos{};
     std::vector<ResolutionInfo> resolutionInfos {}; // current cam all available resolution infos
     ULONG selectedCameraIndex = 0;
     ULONG selectedResolutionIndex = 0;
   
};

