@break on
@TITLE Dialogic(R) Clean-up Utility Version 1.12

@REM
@REM Copyright (C) 2003-2007 Dialogic Corporation.  All Rights Reserved.
@REM All names, products, and services mentioned herein are the
@REM trademarks or registered trademarks of their respective
@REM organizations and are the sole property of their respective
@REM owners.

@REM Initialize internal flags and variables
@set DELETESELF=
@set DIALOGICDIR=
@set DIALOGICDRIVE=
@set DIRSPEC=
@set NODISKSCAN=
@set NOPROMPT=

@REM Remember our name, and if called using a full pathname, the drive/directory
@set SELF=%~0

@REM
@REM Customize the defines below for your local system configuration
@REM
@set MYDRIVE=%SystemDrive%
@set MYWINDIR=%WINDIR%
@set MYWININFDIR=%MYWINDIR%\inf
@set MYWINSYSDIR=%MYWINDIR%\system32
@set MYWINDRIVERSDIR=%MYWINSYSDIR%\drivers
@set MYUNINSTALLDIR=%MYDRIVE%\Program Files\InstallShield Installation Information

@REM
@REM	Location of regedit.exe
@REM
@set REGEDIT=%WINDIR%\regedit.exe

@REM
@REM	Process command line arguments
@REM
:getargs

@REM break out of loop if no more command line options
@if "%1"=="" goto doneargs

@REM set flag to delete this batch file when execution is complete
@if "%1"=="-deleteself" set DELETESELF=1

@REM set flag to skip whole-drive file search and delete
@REM this will speed up execution but may cause the utility to
@REM miss files which should be deleted.
@if "%1"=="-nodiskscan" set NODISKSCAN=1

@REM set flag to execute cleanup without prompting user
@if "%1"=="-noprompt" set NOPROMPT=1

@REM allow caller to specify directory path of Dialogic software
@REM note that no checking of the specified directory is done because
@REM it is possible that it may not still exist.
@REM WARNING: Whatever directory is passed will be recursively deleted
@REM WARNING: Passing the wrong directory can be hazardous to your system
@REM WARNING: The directory path must be surrounded by double quotes
@if "%1"=="-dialogicdir" set NEEDMORE=1
@if "%1"=="-dialogicdir" set DIRSPEC=1
@if "%NEEDMORE%"=="1" shift
@if "%NEEDMORE%"=="1" set DIALOGICDIR=%~1
@if "%NEEDMORE%"=="1" set DIALOGICDRIVE=%~d1
@if "%NEEDMORE%"=="1" set NEEDMORE=0
@REM
@REM DO NOT PUT ANY CODE BETWEEN -dialogicdir PARSING AND THE FOLLOWING shift
@REM
@shift

@REM loop until all command line arguments are read
@goto getargs

:doneargs

@REM if the user specified a directory on the command line, then use it
@REM else assume the default location
@if "%DIRSPEC%"=="1" (
@set DIALOGIC=%DIALOGICDIR%
@set MYDRIVE=%DIALOGICDRIVE%) else (
@set DIALOGIC=%MYDRIVE%\Program Files\Dialogic)

@REM Set value of FAX after MYDRIVE is determined
@set FAX=%MYDRIVE%\Fax

@REM allow user to skip prompt - needed in case of automated clean-up invocation
@if "%NOPROMPT%"=="1" goto skipprompt

@cls
@echo This utility will search your system for Dialogic files and registry
@echo entries, deleting them when found.  Some log files can be located in any
@echo directory and the search for these files may take several minutes, so please
@echo be patient.  Enabling the Windows Indexing service will help speed this process.
@echo.
@echo BEFORE USING THIS UTILITY, READ AND UNDERSTAND THE FOLLOWING WARNINGS:
@echo.
@echo 1. All Dialogic software must be uninstalled and the system rebooted
@echo    before running this utility.
@echo 2. Running this utility on a system which has installed Dialogic
@echo    software will render such software inoperable.
@echo 3. All files and directories under the %DIALOGIC% directory
@echo    hierarchy will be deleted.
@echo 4. If the Dialogic software was installed in a directory other than
@echo    the default, then the -dialogicdir command line option must be used to
@echo    specify the install directory.
@echo.
@echo To abort execution of this utility, press Control-C now.
@echo Otherwise to run the utility,
@pause

:skipprompt
REM
REM Stop any installed Dialogic services or system
REM services which may cause Dialogic files to be in use
REM
net stop AnmChannelFactoryServer /Y 2>NUL
net stop AnmChannelServer /Y 2>NUL
net stop AnmLoggerServer /Y 2>NUL
net stop AnmSupplierServer /Y 2>NUL
net stop AntDetect /Y 2>NUL
net stop Boardserver /Y 2>NUL
net stop CTBusBroker /Y 2>NUL
net stop DetectorsProj /Y 2>NUL
net stop DebugAngel /Y 2>NUL
net stop Dialogic /Y 2>NUL
net stop DlgcAntares /Y 2>NUL
net stop DlgcDcm /Y 2>NUL
net stop DLGCDeviceMapper /Y 2>NUL
net stop DlgcH323 /Y 2>NUL
net stop Dlgcmcd /Y 2>NUL
net stop DlgcMemDoler /Y 2>NUL
net stop Dlgcmpd /Y 2>NUL
net stop DlgcS7Srv /Y 2>NUL
net stop DlgcSram /Y 2>NUL
net stop DlgcUpgrade /Y 2>NUL
net stop dlgH323 /Y 2>NUL
net stop DlgPnPObserverService /Y 2>NUL
net stop DM3Config /Y 2>NUL
net stop DM3InsightDrv /Y 2>NUL
net stop EventService /Y 2>NUL
net stop GammaFax /Y 2>NUL
net stop GlfxIsa /Y 2>NUL
net stop GlfxPci /Y 2>NUL
net stop Gloaddrv /Y 2>NUL
net stop IMRService /Y 2>NUL
net stop IPMedia /Y 2>NUL
net stop NamingService /Y 2>NUL
net stop RtfDispatcher /Y 2>NUL
net stop SNMPTRAP /Y 2>NUL
net stop SNMP /Y 2>NUL
net stop Springware_temp /Y 2>NUL

@REM save directory from which we were called
@pushd %MYDRIVE%\

REM Delete Dialogic directory hierarchy and its contents
@set DIR=%DIALOGIC%
@if exist "%DIR%" attrib -r /d /s "%DIR%"
if exist "%DIR%" rmdir /q /s "%DIR%"

REM Delete FAX directory hierarchy and its contents
@set DIR=%FAX%
@if exist "%DIR%" attrib -r /d /s "%DIR%"
if exist "%DIR%" rmdir /q /s "%DIR%"

REM Delete default RTF log file directory and its contents
@set DIR=%MYDRIVE%\rtflog
@if exist "%DIR%" attrib -r /d /s "%DIR%"
if exist %DIR% rmdir /q /s "%DIR%"

REM Delete point release/HMP 1.0 SP1/HMP 1.0 FP1 uninstall directory hierarchy and its contents
@set DIR=%MYUNINSTALLDIR%\{0FC1D5E3-21B9-11D4-A580-00C04F35CB28}
@if exist "%DIR%" attrib -r /d /s "%DIR%"
if exist "%DIR%" rmdir /q /s "%DIR%"

REM Delete SR 5.1.1 FP1 standalone SU uninstall directory hierarchy and its contents
@set DIR=%MYUNINSTALLDIR%\{18D1CB58-7334-41BA-85BF-EF31C321CEBC}
@if exist "%DIR%" attrib -r /d /s "%DIR%"
if exist "%DIR%" rmdir /q /s "%DIR%"

REM Delete SR6.0 PCI, SR 6.1, HMP 1.3, HMP 2.0, HMP 3.0 uninstall
REM directory hierarchy and its contents
@set DIR=%MYUNINSTALLDIR%\{4A6FA71B-C3AA-494D-8D5D-6B5A3C196946}
@if exist "%DIR%" attrib -r /d /s "%DIR%"
if exist "%DIR%" rmdir /q /s "%DIR%"

REM Delete SDK uninstall directory hierarchy and its contents (obsolete, never released)
@set DIR=%MYUNINSTALLDIR%\{57A6B857-C948-427F-979C-CB8AF5331A56}
@if exist "%DIR%" attrib -r /d /s "%DIR%"
if exist "%DIR%" rmdir /q /s "%DIR%"

REM Delete uninstall directory hierarchy for Global Protocols 4.0 and later
@set DIR=%MYUNINSTALLDIR%\{8C1C7C31-AE1E-4EA9-A108-80F23ED7AE1B}
@if exist "%DIR%" attrib -r /d /s "%DIR%"
if exist "%DIR%" rmdir /q /s "%DIR%"

REM Delete SR 6.0 cPCI FP1 uninstall directory hierarchy and its contents
@set DIR=%MYUNINSTALLDIR%\{D43962D0-77A0-11D4-8F9D-00C04F35CB28}
@if exist "%DIR%" attrib -r /d /s "%DIR%"
if exist "%DIR%" rmdir /q /s "%DIR%"

REM Delete Intel(R) Dialogic(R) D4PCI-U HMP 2.0 Gateway Demo uninstall
REM directory and its contents
@set DIR=%MYUNINSTALLDIR%\{D8CA755B-D376-464C-8795-457F8FD698A5}
@if exist "%DIR%" attrib -r /d /s "%DIR%"
if exist "%DIR%" rmdir /q /s "%DIR%"

REM Delete HMP 1.0 and 1.1 uninstall directory hierarchy and its contents
@set DIR=%MYUNINSTALLDIR%\{DF2FE966-3A24-429D-B11C-1AB13E2AD6D0}
@if exist "%DIR%" attrib -r /d /s "%DIR%"
if exist "%DIR%" rmdir /q /s "%DIR%"

REM Delete feature pack/SR 5.1.1 SP1/HMP 1.1 SU uninstall directory hierarchy and its contents
@set DIR=%MYUNINSTALLDIR%\{E62BF0D9-BA88-4227-B079-F2E52100E446}
@if exist "%DIR%" attrib -r /d /s "%DIR%"
if exist "%DIR%" rmdir /q /s "%DIR%"

REM Delete Intel Dialogic System Software folder from start menu
@set DIR=%ALLUSERSPROFILE%\Start Menu\Programs\Intel Dialogic System Software
@if exist "%DIR%" attrib -r /d /s "%DIR%"
if exist "%DIR%" rmdir /q /s "%DIR%"

REM Delete Intel Dialogic System Software folder from start menu (SR 6.0 cPCI FP1 SU, SR 6.0 PCI SU and later)
@set DIR=%ALLUSERSPROFILE%\Start Menu\Programs\Intel Dialogic System Release
@if exist "%DIR%" attrib -r /d /s "%DIR%"
if exist "%DIR%" rmdir /q /s "%DIR%"

REM Delete Intel Dialogic System Software folder from start menu (win 6.0 cPCI FP1)
@set DIR=%ALLUSERSPROFILE%\Start Menu\Programs\Intel Dialogic Release 6.0 cPCI
@if exist "%DIR%" attrib -r /d /s "%DIR%"
if exist "%DIR%" rmdir /q /s "%DIR%"

REM Delete Intel Dialogic System Software folder from start menu (HMP 1.0)
@set DIR=%ALLUSERSPROFILE%\Start Menu\Programs\Intel HMP 1.0
@if exist "%DIR%" attrib -r /d /s "%DIR%"
if exist "%DIR%" rmdir /q /s "%DIR%"

REM Delete Intel Dialogic System Software folder from start menu (HMP 1.1)
@set DIR=%ALLUSERSPROFILE%\Start Menu\Programs\Intel HMP 1.1
@if exist "%DIR%" attrib -r /d /s "%DIR%"
if exist "%DIR%" rmdir /q /s "%DIR%"

REM Delete Intel Dialogic System Software folder from start menu (HMP 1.3 and later)
@set DIR=%ALLUSERSPROFILE%\Start Menu\Programs\Intel NetStructure HMP
@if exist "%DIR%" attrib -r /d /s "%DIR%"
if exist "%DIR%" rmdir /q /s "%DIR%"

REM Delete Intel Dialogic System Software folder from start menu (HMP 1.0 FP1 and SP1)
@set DIR=%ALLUSERSPROFILE%\Start Menu\Programs\Intel NetStructure (TM) HMP 1.0 menu
@if exist "%DIR%" attrib -r /d /s "%DIR%"
if exist "%DIR%" rmdir /q /s "%DIR%"

@REM allow user to skip disk scan to delete log file in order to save time on large drives
@if "%NODISKSCAN%"=="1" goto skipdiskscan

REM Delete frustatus log files from all directories
@set FILE=frustatus.log
del /f /s "%FILE%" 2>NUL

REM Delete RTF error log files from all directories
@set FILE=rtferror.log
del /f /s "%FILE%" 2>NUL

:skipdiskscan

@REM Delete install log file
@REM Commented out to meet requirement that log file not be deleted
@REM @set FILE=%TEMP%\DlgcInstall.log
@REM @if exist "%FILE%" attrib -r "%FILE%"
@REM if exist "%FILE%" del /f /s "%FILE%"

REM
REM
REM Delete files from %MYWINDIR%
REM
REM

REM Delete NCM ini file
@set FILE=%MYWINDIR%\NCM.ini
@if exist "%FILE%" attrib -r "%FILE%"
if exist "%FILE%" del /f "%FILE%"

REM Delete pre-SR 6.0 System Release install log file
@set FILE=%MYWINDIR%\dlgcinst.txt
@if exist "%FILE%" attrib -r "%FILE%"
if exist "%FILE%" del /f "%FILE%"

REM Delete old uninstall log files
@set FILE=%MYWINDIR%\dlgc_un*_log.ini
@if exist "%FILE%" attrib -r "%FILE%"
if exist "%FILE%" del /f /q "%FILE%"

REM Delete old PTR install log file
@set FILE=%MYWINDIR%\dlgcptr.log
@if exist "%FILE%" attrib -r "%FILE%"
if exist "%FILE%" del /f "%FILE%"

REM Delete service pack install log file
@set FILE=%MYWINDIR%\dlgcservicepack.log
@if exist "%FILE%" attrib -r "%FILE%"
if exist "%FILE%" del /f "%FILE%"

REM Delete dialogic uninstall executable
@set FILE=%MYWINDIR%\dlgcunin.exe
@if exist "%FILE%" attrib -r "%FILE%"
if exist "%FILE%" del /f "%FILE%"

REM Delete GfdCp.exe
@set FILE=%MYWINDIR%\GfdCp.exe
@if exist "%FILE%" attrib -r "%FILE%"
if exist "%FILE%" del /f "%FILE%"

REM Delete GfdCpDm3.exe
@set FILE=%MYWINDIR%\GfdCpDm3.exe
@if exist "%FILE%" attrib -r "%FILE%"
if exist "%FILE%" del /f "%FILE%"

REM Delete SerialLd.bat
@set FILE=%MYWINDIR%\SerialLd.bat
@if exist "%FILE%" attrib -r "%FILE%"
if exist "%FILE%" del /f "%FILE%"

REM Delete uninst.exe
@set FILE=%MYWINDIR%\uninst.exe
@if exist "%FILE%" attrib -r "%FILE%"
if exist "%FILE%" del /f "%FILE%"

REM Delete uninstgc.exe
@set FILE=%MYWINDIR%\uninstgc.exe
@if exist "%FILE%" attrib -r "%FILE%"
if exist "%FILE%" del /f "%FILE%"

REM Delete gcunin.exe
@set FILE=%MYWINDIR%\gcunin.exe
@if exist "%FILE%" attrib -r "%FILE%"
if exist "%FILE%" del /f "%FILE%"

REM Delete RtfService.lck
@set FILE=%MYWINDIR%\Temp\RtfService.lck
@if exist "%FILE%" attrib -r "%FILE%"
if exist "%FILE%" del /f "%FILE%"

REM
REM
REM Delete files from %MYWINSYSDIR%
REM
REM

REM Delete anm_debug log file
@set FILE=%MYWINSYSDIR%\anm_debug.log
@if exist "%FILE%" attrib -r "%FILE%"
if exist "%FILE%" del /f "%FILE%"

REM Delete anm_trace log file
@set FILE=%MYWINSYSDIR%\anm_trace.log
@if exist "%FILE%" attrib -r "%FILE%"
if exist "%FILE%" del /f "%FILE%"

REM Delete ClusterPkg log files
@set FILE=%MYWINSYSDIR%\ClusterPkg.log.*
@if exist "%FILE%" attrib -r "%FILE%"
if exist "%FILE%" del /f /q "%FILE%"

REM Delete confslot log file
@set FILE=%MYWINSYSDIR%\confslot.log
@if exist "%FILE%" attrib -r "%FILE%"
if exist "%FILE%" del /f "%FILE%"

REM Delete ctbbapi.log log file
@set FILE=%MYWINSYSDIR%\ctbbapi.log
@if exist "%FILE%" attrib -r "%FILE%"
if exist "%FILE%" del /f "%FILE%"

REM Delete dm3bsp log file
@set FILE=%MYWINSYSDIR%\dm3bsp.log
@if exist "%FILE%" attrib -r "%FILE%"
if exist "%FILE%" del /f "%FILE%"

REM Delete dm3fdspdll log file
@set FILE=%MYWINSYSDIR%\dm3fdspdll.log
@if exist "%FILE%" attrib -r "%FILE%"
if exist "%FILE%" del /f "%FILE%"

REM Delete Genload log file
@set FILE=%MYWINSYSDIR%\Genload.log
@if exist "%FILE%" attrib -r "%FILE%"
if exist "%FILE%" del /f "%FILE%"

REM Delete merc log file
@set FILE=%MYWINSYSDIR%\merc.log
@if exist "%FILE%" attrib -r "%FILE%"
if exist "%FILE%" del /f "%FILE%"

REM Delete mnt log file
@set FILE=%MYWINSYSDIR%\mnt.log
@if exist "%FILE%" attrib -r -s "%FILE%"
if exist "%FILE%" del /f /q "%FILE%"

REM Delete dm3power log file
@set FILE=%MYWINSYSDIR%\power.log
@if exist "%FILE%" attrib -r -s "%FILE%"
if exist "%FILE%" del /f /q "%FILE%"

REM Delete boardserver log file
@set FILE=%MYWINSYSDIR%\boardserver.log
@if exist "%FILE%" attrib -r -s "%FILE%"
if exist "%FILE%" del /f /q "%FILE%"

REM Delete Bristart log file
@set FILE=%MYWINSYSDIR%\Bristart.log
@if exist "%FILE%" attrib -r -s "%FILE%"
if exist "%FILE%" del /f /q "%FILE%"

REM Delete Bristop log file
@set FILE=%MYWINSYSDIR%\Bristop
@if exist "%FILE%" attrib -r -s "%FILE%"
if exist "%FILE%" del /f /q "%FILE%"

REM Delete IPMedia log file
@set FILE=%MYWINSYSDIR%\IPMedia.log
@if exist "%FILE%" attrib -r -s "%FILE%"
if exist "%FILE%" del /f /q "%FILE%"

REM Delete sctsassi log file
@set FILE=%MYWINSYSDIR%\sctsassi.log
@if exist "%FILE%" attrib -r -s "%FILE%"
if exist "%FILE%" del /f /q "%FILE%"

REM Delete StartDrv log file
@set FILE=%MYWINSYSDIR%\StartDrv.log
@if exist "%FILE%" attrib -r -s "%FILE%"
if exist "%FILE%" del /f /q "%FILE%"

REM Delete TSFLoad log file
@set FILE=%MYWINSYSDIR%\TSFLoad.log
@if exist "%FILE%" attrib -r -s "%FILE%"
if exist "%FILE%" del /f /q "%FILE%"

REM Delete adl.dll file
@set FILE=%MYWINSYSDIR%\adl.dll
@if exist "%FILE%" attrib -r "%FILE%"
if exist "%FILE%" del /f "%FILE%"

REM Delete AnmCommon.dll
@set FILE=%MYWINSYSDIR%\AnmCommon.dll
@if exist "%FILE%" attrib -r -s "%FILE%"
if exist "%FILE%" del /f "%FILE%"

REM Delete AnmConsumerCproxy.dll
@set FILE=%MYWINSYSDIR%\AnmConsumerCproxy.dll
@if exist "%FILE%" attrib -r -s "%FILE%"
if exist "%FILE%" del /f "%FILE%"

REM Delete AnmConsumerServer.dll
@set FILE=%MYWINSYSDIR%\AnmConsumerServer.dll
@if exist "%FILE%" attrib -r -s "%FILE%"
if exist "%FILE%" del /f "%FILE%"

REM Delete AnmCproxy.dll
@set FILE=%MYWINSYSDIR%\AnmCproxy.dll
@if exist "%FILE%" attrib -r -s "%FILE%"
if exist "%FILE%" del /f "%FILE%"

REM Delete AnmErrorMsgs.dll
@set FILE=%MYWINSYSDIR%\AnmErrorMsgs.dll
@if exist "%FILE%" attrib -r -s "%FILE%"
if exist "%FILE%" del /f "%FILE%"

REM Delete AnmMsgServer.dll
@set FILE=%MYWINSYSDIR%\AnmMsgServer.dll
@if exist "%FILE%" attrib -r -s "%FILE%"
if exist "%FILE%" del /f "%FILE%"

REM Delete AnmSupplierCproxy.dll
@set FILE=%MYWINSYSDIR%\AnmSupplierCproxy.dll
@if exist "%FILE%" attrib -r -s "%FILE%"
if exist "%FILE%" del /f "%FILE%"

REM Delete antcfg.dll
@set FILE=%MYWINSYSDIR%\antcfg.dll
@if exist "%FILE%" attrib -r -s "%FILE%"
if exist "%FILE%" del /f "%FILE%"

REM Delete antcflib.dll
@set FILE=%MYWINSYSDIR%\antcflib.dll
@if exist "%FILE%" attrib -r -s "%FILE%"
if exist "%FILE%" del /f "%FILE%"

REM Delete antldlib.dll
@set FILE=%MYWINSYSDIR%\antldlib.dll
@if exist "%FILE%" attrib -r -s "%FILE%"
if exist "%FILE%" del /f "%FILE%"

REM Delete ANTNTF.dll
@set FILE=%MYWINSYSDIR%\ANTNTF.dll
@if exist "%FILE%" attrib -r -s "%FILE%"
if exist "%FILE%" del /f "%FILE%"

REM Delete AntPciLib.dll
@set FILE=%MYWINSYSDIR%\AntPciLib.dll
@if exist "%FILE%" attrib -r -s "%FILE%"
if exist "%FILE%" del /f "%FILE%"

REM Delete boardserver.exe
@set FILE=%MYWINSYSDIR%\boardserver.exe
@if exist "%FILE%" attrib -r -s "%FILE%"
if exist "%FILE%" del /f "%FILE%"

REM Delete brintf.dll
@set FILE=%MYWINSYSDIR%\brintf.dll
@if exist "%FILE%" attrib -r -s "%FILE%"
if exist "%FILE%" del /f "%FILE%"

REM Delete cheetah.dll
@set FILE=%MYWINSYSDIR%\cheetah.dll
@if exist "%FILE%" attrib -r -s "%FILE%"
if exist "%FILE%" del /f "%FILE%"

REM Delete cllib.dll
@set FILE=%MYWINSYSDIR%\cllib.dll
@if exist "%FILE%" attrib -r -s "%FILE%"
if exist "%FILE%" del /f "%FILE%"

REM ClusterPkg.log
@set FILE=%MYWINSYSDIR%\ClusterPkg.log
@if exist "%FILE%" attrib -r -s "%FILE%"
if exist "%FILE%" del /f "%FILE%"

REM Delete ConfigGamma.cpl
@set FILE=%MYWINSYSDIR%\ConfigGamma.cpl
@if exist "%FILE%" attrib -r -s "%FILE%"
if exist "%FILE%" del /f "%FILE%"

REM Delete ConfigGDK.cpl
@set FILE=%MYWINSYSDIR%\ConfigGDK.cpl
@if exist "%FILE%" attrib -r -s "%FILE%"
if exist "%FILE%" del /f "%FILE%"

REM Delete ConfigGenerator.dll
@set FILE=%MYWINSYSDIR%\ConfigGenerator.dll
@if exist "%FILE%" attrib -r -s "%FILE%"
if exist "%FILE%" del /f "%FILE%"

REM confslot.log
@set FILE=%MYWINSYSDIR%\confslot.log
@if exist "%FILE%" attrib -r -s "%FILE%"
if exist "%FILE%" del /f "%FILE%"

REM DlgcS7.log
@set FILE=%MYWINSYSDIR%\DlgcS7.log
@if exist "%FILE%" attrib -r -s "%FILE%"
if exist "%FILE%" del /f "%FILE%"

REM Delete CosEvent405.dll
@set FILE=%MYWINSYSDIR%\CosEvent405.dll
@if exist "%FILE%" attrib -r -s "%FILE%"
if exist "%FILE%" del /f "%FILE%"

REM Delete CosEvent405d.dll
@set FILE=%MYWINSYSDIR%\CosEvent405d.dll
@if exist "%FILE%" attrib -r -s "%FILE%"
if exist "%FILE%" del /f "%FILE%"

REM Delete CosNaming405.dll
@set FILE=%MYWINSYSDIR%\CosNaming405.dll
@if exist "%FILE%" attrib -r -s "%FILE%"
if exist "%FILE%" del /f "%FILE%"

REM Delete CosNaming405d.dll
@set FILE=%MYWINSYSDIR%\CosNaming405d.dll
@if exist "%FILE%" attrib -r -s "%FILE%"
if exist "%FILE%" del /f "%FILE%"

REM Delete CosProperty405.dll
@set FILE=%MYWINSYSDIR%\CosProperty405.dll
@if exist "%FILE%" attrib -r -s "%FILE%"
if exist "%FILE%" del /f "%FILE%"

REM Delete CosProperty405d.dll
@set FILE=%MYWINSYSDIR%\CosProperty405d.dll
@if exist "%FILE%" attrib -r -s "%FILE%"
if exist "%FILE%" del /f "%FILE%"

REM Delete CosTime405.dll
@set FILE=%MYWINSYSDIR%\CosTime405.dll
@if exist "%FILE%" attrib -r -s "%FILE%"
if exist "%FILE%" del /f "%FILE%"

REM Delete CosTime405d.dll
@set FILE=%MYWINSYSDIR%\CosTime405d.dll
@if exist "%FILE%" attrib -r -s "%FILE%"
if exist "%FILE%" del /f "%FILE%"

REM Delete counters.h
@set FILE=%MYWINSYSDIR%\counters.h
@if exist "%FILE%" attrib -r -s "%FILE%"
if exist "%FILE%" del /f "%FILE%"

REM Delete counters.ini
@set FILE=%MYWINSYSDIR%\counters.ini
@if exist "%FILE%" attrib -r -s "%FILE%"
if exist "%FILE%" del /f "%FILE%"

REM Delete Csapi32x.dll
@set FILE=%MYWINSYSDIR%\Csapi32x.dll
@if exist "%FILE%" attrib -r -s "%FILE%"
if exist "%FILE%" del /f "%FILE%"

REM Delete Csgui.dll
@set FILE=%MYWINSYSDIR%\Csgui.dll
@if exist "%FILE%" attrib -r -s "%FILE%"
if exist "%FILE%" del /f "%FILE%"

REM ctbbapi.log
@set FILE=%MYWINSYSDIR%\ctbbapi.log
@if exist "%FILE%" attrib -r -s "%FILE%"
if exist "%FILE%" del /f "%FILE%"

REM Delete ctbbface.dll
@set FILE=%MYWINSYSDIR%\ctbbface.dll
@if exist "%FILE%" attrib -r -s "%FILE%"
if exist "%FILE%" del /f "%FILE%"

REM Delete d41mt.cnt
@set FILE=%MYWINSYSDIR%\d41mt.cnt
@if exist "%FILE%" attrib -r -s "%FILE%"
if exist "%FILE%" del /f "%FILE%"

REM Delete d41mt.hlp
@set FILE=%MYWINSYSDIR%\d41mt.hlp
@if exist "%FILE%" attrib -r -s "%FILE%"
if exist "%FILE%" del /f "%FILE%"

REM Delete d41mt.ini
@set FILE=%MYWINSYSDIR%\d41mt.ini
@if exist "%FILE%" attrib -r -s "%FILE%"
if exist "%FILE%" del /f "%FILE%"

REM Delete d41mt.tsp
@set FILE=%MYWINSYSDIR%\d41mt.tsp
@if exist "%FILE%" attrib -r -s "%FILE%"
if exist "%FILE%" del /f "%FILE%"

REM Delete d42ntf.dll
@set FILE=%MYWINSYSDIR%\d42ntf.dll
@if exist "%FILE%" attrib -r -s "%FILE%"
if exist "%FILE%" del /f "%FILE%"

REM Delete DCMObj.exe
@set FILE=%MYWINSYSDIR%\DCMObj.exe
@if exist "%FILE%" attrib -r -s "%FILE%"
if exist "%FILE%" del /f "%FILE%"

REM Delete DCMObjps.dll
@set FILE=%MYWINSYSDIR%\DCMObjps.dll
@if exist "%FILE%" attrib -r -s "%FILE%"
if exist "%FILE%" del /f "%FILE%"

REM Delete DlgcAtf.dll
@set FILE=%MYWINSYSDIR%\DlgcAtf.dll
@if exist "%FILE%" attrib -r -s "%FILE%"
if exist "%FILE%" del /f "%FILE%"

REM Delete dlgcbric.dll
@set FILE=%MYWINSYSDIR%\dlgcbric.dll
@if exist "%FILE%" attrib -r -s "%FILE%"
if exist "%FILE%" del /f "%FILE%"

REM Delete dlgcdiag.dll
@set FILE=%MYWINSYSDIR%\dlgcdiag.dll
@if exist "%FILE%" attrib -r -s "%FILE%"
if exist "%FILE%" del /f "%FILE%"

REM Delete DlgcDk.dll
@set FILE=%MYWINSYSDIR%\DlgcDk.dll
@if exist "%FILE%" attrib -r -s "%FILE%"
if exist "%FILE%" del /f "%FILE%"

REM Delete DlgcHost.dll
@set FILE=%MYWINSYSDIR%\DlgcHost.dll
@if exist "%FILE%" attrib -r -s "%FILE%"
if exist "%FILE%" del /f "%FILE%"

REM Delete dlgcOrbUtil.dll
@set FILE=%MYWINSYSDIR%\dlgcOrbUtil.dll
@if exist "%FILE%" attrib -r -s "%FILE%"
if exist "%FILE%" del /f "%FILE%"

REM Delete dlgcs7srvps.dll
@set FILE=%MYWINSYSDIR%\dlgcs7srvps.dll
@if exist "%FILE%" attrib -r -s "%FILE%"
if exist "%FILE%" del /f /q "%FILE%"

REM Delete dlgcSNMP.dll
@set FILE=%MYWINSYSDIR%\dlgcSNMP.dll
@if exist "%FILE%" attrib -r -s "%FILE%"
if exist "%FILE%" del /f "%FILE%"

REM Delete dlgcSRAMPerf.dll
@set FILE=%MYWINSYSDIR%\dlgcSRAMPerf.dll
@if exist "%FILE%" attrib -r -s "%FILE%"
if exist "%FILE%" del /f "%FILE%"

REM Delete dlgcstopprotocol.dll
@set FILE=%MYWINSYSDIR%\dlgcstopprotocol.dll
@if exist "%FILE%" attrib -r -s "%FILE%"
if exist "%FILE%" del /f "%FILE%"

REM Delete dlgServiceResults.dll
@set FILE=%MYWINSYSDIR%\dlgServiceResults.dll
@if exist "%FILE%" attrib -r -s "%FILE%"
if exist "%FILE%" del /f "%FILE%"

REM Delete dlgwave.dll
@set FILE=%MYWINSYSDIR%\dlgwave.dll
@if exist "%FILE%" attrib -r -s "%FILE%"
if exist "%FILE%" del /f "%FILE%"

REM Delete dlreg.dll
@set FILE=%MYWINSYSDIR%\dlreg.dll
@if exist "%FILE%" attrib -r -s "%FILE%"
if exist "%FILE%" del /f "%FILE%"

REM Delete dm3adl.dll
@set FILE=%MYWINSYSDIR%\dm3adl.dll
@if exist "%FILE%" attrib -r -s "%FILE%"
if exist "%FILE%" del /f "%FILE%"

REM Delete dm3autodump.dll
@set FILE=%MYWINSYSDIR%\dm3autodump.dll
@if exist "%FILE%" attrib -r -s "%FILE%"
if exist "%FILE%" del /f "%FILE%"

REM Delete dm3be.dll
@set FILE=%MYWINSYSDIR%\dm3be.dll
@if exist "%FILE%" attrib -r -s "%FILE%"
if exist "%FILE%" del /f "%FILE%"

REM Delete dm3bsp.dll
@set FILE=%MYWINSYSDIR%\dm3bsp.dll
@if exist "%FILE%" attrib -r -s "%FILE%"
if exist "%FILE%" del /f "%FILE%"

REM dm3bsp.log
@set FILE=%MYWINSYSDIR%\dm3bsp.log
@if exist "%FILE%" attrib -r -s "%FILE%"
if exist "%FILE%" del /f "%FILE%"

REM Delete Dm3FaxLib.dll
@set FILE=%MYWINSYSDIR%\Dm3FaxLib.dll
@if exist "%FILE%" attrib -r -s "%FILE%"
if exist "%FILE%" del /f "%FILE%"

REM Delete dm3fdsp.dll
@set FILE=%MYWINSYSDIR%\dm3fdsp.dll
@if exist "%FILE%" attrib -r -s "%FILE%"
if exist "%FILE%" del /f "%FILE%"

REM Delete dm3leo.dll
@set FILE=%MYWINSYSDIR%\dm3leo.dll
@if exist "%FILE%" attrib -r -s "%FILE%"
if exist "%FILE%" del /f "%FILE%"

REM Delete Dm3Odi.dll
@set FILE=%MYWINSYSDIR%\Dm3Odi.dll
@if exist "%FILE%" attrib -r -s "%FILE%"
if exist "%FILE%" del /f "%FILE%"

REM Delete Dm3OdiUtility.dll
@set FILE=%MYWINSYSDIR%\Dm3OdiUtility.dll
@if exist "%FILE%" attrib -r -s "%FILE%"
if exist "%FILE%" del /f "%FILE%"

REM Delete Dm3Oti.dll
@set FILE=%MYWINSYSDIR%\Dm3Oti.dll
@if exist "%FILE%" attrib -r -s "%FILE%"
if exist "%FILE%" del /f "%FILE%"

REM Delete dmr4cleo.dll
@set FILE=%MYWINSYSDIR%\dmr4cleo.dll
@if exist "%FILE%" attrib -r -s "%FILE%"
if exist "%FILE%" del /f "%FILE%"

REM Delete dtintf.dll
@set FILE=%MYWINSYSDIR%\dtintf.dll
@if exist "%FILE%" attrib -r -s "%FILE%"
if exist "%FILE%" del /f "%FILE%"

REM Delete FruStatus.dll
@set FILE=%MYWINSYSDIR%\FruStatus.dll
@if exist "%FILE%" attrib -r -s "%FILE%"
if exist "%FILE%" del /f "%FILE%"

REM Delete frustatus.log
@set FILE=%MYWINSYSDIR%\frustatus.log
@if exist "%FILE%" attrib -r -s "%FILE%"
if exist "%FILE%" del /f "%FILE%"

REM Delete genload.dll
@set FILE=%MYWINSYSDIR%\genload.dll
@if exist "%FILE%" attrib -r -s "%FILE%"
if exist "%FILE%" del /f "%FILE%"

REM Delete GlfxIf.dll
@set FILE=%MYWINSYSDIR%\GlfxIf.dll
@if exist "%FILE%" attrib -r -s "%FILE%"
if exist "%FILE%" del /f "%FILE%"

REM Delete GlfxStd.dll
@set FILE=%MYWINSYSDIR%\GlfxStd.dll
@if exist "%FILE%" attrib -r -s "%FILE%"
if exist "%FILE%" del /f "%FILE%"

REM Delete HotDll.dll
@set FILE=%MYWINSYSDIR%\HotDll.dll
@if exist "%FILE%" attrib -r -s "%FILE%"
if exist "%FILE%" del /f "%FILE%"

REM Delete icudata.dll
@set FILE=%MYWINSYSDIR%\icudata.dll
@if exist "%FILE%" attrib -r -s "%FILE%"
if exist "%FILE%" del /f "%FILE%"

REM Delete icuuc.dll
@set FILE=%MYWINSYSDIR%\icuuc.dll
@if exist "%FILE%" attrib -r -s "%FILE%"
if exist "%FILE%" del /f "%FILE%"

REM Delete idl405.dll
@set FILE=%MYWINSYSDIR%\idl405.dll
@if exist "%FILE%" attrib -r -s "%FILE%"
if exist "%FILE%" del /f "%FILE%"

REM Delete idl405d.dll
@set FILE=%MYWINSYSDIR%\idl405d.dll
@if exist "%FILE%" attrib -r -s "%FILE%"
if exist "%FILE%" del /f "%FILE%"

REM Delete imr405.dll
@set FILE=%MYWINSYSDIR%\imr405.dll
@if exist "%FILE%" attrib -r -s "%FILE%"
if exist "%FILE%" del /f "%FILE%"

REM Delete imr405d.dll
@set FILE=%MYWINSYSDIR%\imr405d.dll
@if exist "%FILE%" attrib -r -s "%FILE%"
if exist "%FILE%" del /f "%FILE%"

REM Delete ipmedia.dll
@set FILE=%MYWINSYSDIR%\ipmedia.dll
@if exist "%FILE%" attrib -r -s "%FILE%"
if exist "%FILE%" del /f "%FILE%"

REM IPTConf.log
@set FILE=%MYWINSYSDIR%\IPTConf.log
@if exist "%FILE%" attrib -r -s "%FILE%"
if exist "%FILE%" del /f "%FILE%"

REM Delete isdnspan.dll
@set FILE=%MYWINSYSDIR%\isdnspan.dll
@if exist "%FILE%" attrib -r -s "%FILE%"
if exist "%FILE%" del /f "%FILE%"

REM Delete jtc1014.dll
@set FILE=%MYWINSYSDIR%\jtc1014.dll
@if exist "%FILE%" attrib -r -s "%FILE%"
if exist "%FILE%" del /f "%FILE%"

REM Delete jtc1014d.dll
@set FILE=%MYWINSYSDIR%\jtc1014d.dll
@if exist "%FILE%" attrib -r -s "%FILE%"
if exist "%FILE%" del /f "%FILE%"

REM Delete kvscscu.dll
@set FILE=%MYWINSYSDIR%\kvscscu.dll
@if exist "%FILE%" attrib -r -s "%FILE%"
if exist "%FILE%" del /f "%FILE%"

REM Delete libadi.dll
@set FILE=%MYWINSYSDIR%\libadi.dll
@if exist "%FILE%" attrib -r -s "%FILE%"
if exist "%FILE%" del /f "%FILE%"

REM Delete libantmt.dll
@set FILE=%MYWINSYSDIR%\libantmt.dll
@if exist "%FILE%" attrib -r -s "%FILE%"
if exist "%FILE%" del /f "%FILE%"

REM Delete libcspdm3.dll
@set FILE=%MYWINSYSDIR%\libcspdm3.dll
@if exist "%FILE%" attrib -r -s "%FILE%"
if exist "%FILE%" del /f "%FILE%"

REM Delete libd300mt.dll
@set FILE=%MYWINSYSDIR%\libd300mt.dll
@if exist "%FILE%" attrib -r -s "%FILE%"
if exist "%FILE%" del /f "%FILE%"

REM Delete libd42mt.dll
@set FILE=%MYWINSYSDIR%\libd42mt.dll
@if exist "%FILE%" attrib -r -s "%FILE%"
if exist "%FILE%" del /f "%FILE%"

REM Delete libdevmap.dll
@set FILE=%MYWINSYSDIR%\libdevmap.dll
@if exist "%FILE%" attrib -r -s "%FILE%"
if exist "%FILE%" del /f "%FILE%"

REM Delete libdevmgmt.dll
@set FILE=%MYWINSYSDIR%\libdevmgmt.dll
@if exist "%FILE%" attrib -r -s "%FILE%"
if exist "%FILE%" del /f "%FILE%"

REM Delete libdevnamedoler.dll
@set FILE=%MYWINSYSDIR%\libdevnamedoler.dll
@if exist "%FILE%" attrib -r -s "%FILE%"
if exist "%FILE%" del /f "%FILE%"

REM Delete libdlgadminconsumerfw.dll
@set FILE=%MYWINSYSDIR%\libdlgadminconsumerfw.dll
@if exist "%FILE%" attrib -r -s "%FILE%"
if exist "%FILE%" del /f "%FILE%"

REM Delete libdlgadminconsumerfwd.dll
@set FILE=%MYWINSYSDIR%\libdlgadminconsumerfwd.dll
@if exist "%FILE%" attrib -r -s "%FILE%"
if exist "%FILE%" del /f "%FILE%"

REM Delete libdlgadminsupplierfw.dll
@set FILE=%MYWINSYSDIR%\libdlgadminsupplierfw.dll
@if exist "%FILE%" attrib -r -s "%FILE%"
if exist "%FILE%" del /f "%FILE%"

REM Delete libdlgadminsupplierfwd.dll
@set FILE=%MYWINSYSDIR%\libdlgadminsupplierfwd.dll
@if exist "%FILE%" attrib -r -s "%FILE%"
if exist "%FILE%" del /f "%FILE%"

REM Delete libdlgerrors.dll
@set FILE=%MYWINSYSDIR%\libdlgerrors.dll
@if exist "%FILE%" attrib -r -s "%FILE%"
if exist "%FILE%" del /f "%FILE%"

REM Delete libdlgoslayer.dll
@set FILE=%MYWINSYSDIR%\libdlgoslayer.dll
@if exist "%FILE%" attrib -r -s "%FILE%"
if exist "%FILE%" del /f "%FILE%"

REM Delete libdlgpmacadmininterface.dll
@set FILE=%MYWINSYSDIR%\libdlgpmacadmininterface.dll
@if exist "%FILE%" attrib -r -s "%FILE%"
if exist "%FILE%" del /f "%FILE%"

REM Delete libdlgpmacbsp.dll
@set FILE=%MYWINSYSDIR%\libdlgpmacbsp.dll
@if exist "%FILE%" attrib -r -s "%FILE%"
if exist "%FILE%" del /f "%FILE%"

REM Delete libdlgpmacdetector.dll
@set FILE=%MYWINSYSDIR%\libdlgpmacdetector.dll
@if exist "%FILE%" attrib -r -s "%FILE%"
if exist "%FILE%" del /f "%FILE%"

REM Delete libdlgpmacfdsp.dll
@set FILE=%MYWINSYSDIR%\libdlgpmacfdsp.dll
@if exist "%FILE%" attrib -r -s "%FILE%"
if exist "%FILE%" del /f "%FILE%"

REM Delete libdlgpmacinitializer.dll
@set FILE=%MYWINSYSDIR%\libdlgpmacinitializer.dll
@if exist "%FILE%" attrib -r -s "%FILE%"
if exist "%FILE%" del /f "%FILE%"

REM Delete libdlgpmacparser.dll
@set FILE=%MYWINSYSDIR%\libdlgpmacparser.dll
@if exist "%FILE%" attrib -r -s "%FILE%"
if exist "%FILE%" del /f "%FILE%"

REM Delete libdlgpmactimeslotassigner.dll
@set FILE=%MYWINSYSDIR%\libdlgpmactimeslotassigner.dll
@if exist "%FILE%" attrib -r -s "%FILE%"
if exist "%FILE%" del /f "%FILE%"

REM Delete libdlgpmacutilities.dll
@set FILE=%MYWINSYSDIR%\libdlgpmacutilities.dll
@if exist "%FILE%" attrib -r -s "%FILE%"
if exist "%FILE%" del /f "%FILE%"

REM Delete libdlgregister.dll
@set FILE=%MYWINSYSDIR%\libdlgregister.dll
@if exist "%FILE%" attrib -r -s "%FILE%"
if exist "%FILE%" del /f "%FILE%"

REM Delete libdlgsysloggerclient.dll
@set FILE=%MYWINSYSDIR%\libdlgsysloggerclient.dll
@if exist "%FILE%" attrib -r -s "%FILE%"
if exist "%FILE%" del /f "%FILE%"

REM Delete libdm3cc.dll
@set FILE=%MYWINSYSDIR%\libdm3cc.dll
@if exist "%FILE%" attrib -r -s "%FILE%"
if exist "%FILE%" del /f "%FILE%"

REM Delete libdm3dcb.dll
@set FILE=%MYWINSYSDIR%\libdm3dcb.dll
@if exist "%FILE%" attrib -r -s "%FILE%"
if exist "%FILE%" del /f "%FILE%"

REM Delete libdm3devmgmt.dll
@set FILE=%MYWINSYSDIR%\libdm3devmgmt.dll
@if exist "%FILE%" attrib -r -s "%FILE%"
if exist "%FILE%" del /f "%FILE%"

REM Delete libdm3fax.dll
@set FILE=%MYWINSYSDIR%\libdm3fax.dll
@if exist "%FILE%" attrib -r -s "%FILE%"
if exist "%FILE%" del /f "%FILE%"

REM Delete libdm3msi.dll
@set FILE=%MYWINSYSDIR%\libdm3msi.dll
@if exist "%FILE%" attrib -r -s "%FILE%"
if exist "%FILE%" del /f "%FILE%"

REM Delete libdtidm3.dll
@set FILE=%MYWINSYSDIR%\libdtidm3.dll
@if exist "%FILE%" attrib -r -s "%FILE%"
if exist "%FILE%" del /f "%FILE%"

REM Delete libdtimt.dll
@set FILE=%MYWINSYSDIR%\libdtimt.dll
@if exist "%FILE%" attrib -r -s "%FILE%"
if exist "%FILE%" del /f "%FILE%"

REM Delete libdxxdm3.dll
@set FILE=%MYWINSYSDIR%\libdxxdm3.dll
@if exist "%FILE%" attrib -r -s "%FILE%"
if exist "%FILE%" del /f "%FILE%"

REM Delete LIBDXXMT.dll
@set FILE=%MYWINSYSDIR%\LIBDXXMT.dll
@if exist "%FILE%" attrib -r -s "%FILE%"
if exist "%FILE%" del /f "%FILE%"

REM Delete libecmt.dll
@set FILE=%MYWINSYSDIR%\libecmt.dll
@if exist "%FILE%" attrib -r -s "%FILE%"
if exist "%FILE%" del /f "%FILE%"

REM Delete libfaxmt.dll
@set FILE=%MYWINSYSDIR%\libfaxmt.dll
@if exist "%FILE%" attrib -r -s "%FILE%"
if exist "%FILE%" del /f "%FILE%"

REM Delete libgc.dll
@set FILE=%MYWINSYSDIR%\libgc.dll
@if exist "%FILE%" attrib -r -s "%FILE%"
if exist "%FILE%" del /f "%FILE%"

REM Delete libgcan.dll
@set FILE=%MYWINSYSDIR%\libgcan.dll
@if exist "%FILE%" attrib -r -s "%FILE%"
if exist "%FILE%" del /f "%FILE%"

REM Delete libgch3r.dll
@set FILE=%MYWINSYSDIR%\libgch3r.dll
@if exist "%FILE%" attrib -r -s "%FILE%"
if exist "%FILE%" del /f "%FILE%"

REM Delete libgcipm.dll
@set FILE=%MYWINSYSDIR%\libgcipm.dll
@if exist "%FILE%" attrib -r -s "%FILE%"
if exist "%FILE%" del /f "%FILE%"

REM Delete libgcis.dll
@set FILE=%MYWINSYSDIR%\libgcis.dll
@if exist "%FILE%" attrib -r -s "%FILE%"
if exist "%FILE%" del /f "%FILE%"

REM Delete libgcr2.dll
@set FILE=%MYWINSYSDIR%\libgcr2.dll
@if exist "%FILE%" attrib -r -s "%FILE%"
if exist "%FILE%" del /f "%FILE%"

REM Delete Libgcs7.dll
@set FILE=%MYWINSYSDIR%\Libgcs7.dll
@if exist "%FILE%" attrib -r -s "%FILE%"
if exist "%FILE%" del /f "%FILE%"

REM Delete Libipm.dll
@set FILE=%MYWINSYSDIR%\Libipm.dll
@if exist "%FILE%" attrib -r -s "%FILE%"
if exist "%FILE%" del /f "%FILE%"

REM Delete libipm_fax.dll
@set FILE=%MYWINSYSDIR%\libipm_fax.dll
@if exist "%FILE%" attrib -r -s "%FILE%"
if exist "%FILE%" del /f "%FILE%"

REM Delete libipm_ipvsc.dll
@set FILE=%MYWINSYSDIR%\libipm_ipvsc.dll
@if exist "%FILE%" attrib -r -s "%FILE%"
if exist "%FILE%" del /f "%FILE%"

REM Delete libipm_nettsc.dll
@set FILE=%MYWINSYSDIR%\libipm_nettsc.dll
@if exist "%FILE%" attrib -r -s "%FILE%"
if exist "%FILE%" del /f "%FILE%"

REM Delete libipm_pmac.dll
@set FILE=%MYWINSYSDIR%\libipm_pmac.dll
@if exist "%FILE%" attrib -r -s "%FILE%"
if exist "%FILE%" del /f "%FILE%"

REM Delete libisdnr4.dll
@set FILE=%MYWINSYSDIR%\libisdnr4.dll
@if exist "%FILE%" attrib -r -s "%FILE%"
if exist "%FILE%" del /f "%FILE%"

REM Delete liblmode.dll
@set FILE=%MYWINSYSDIR%\liblmode.dll
@if exist "%FILE%" attrib -r -s "%FILE%"
if exist "%FILE%" del /f "%FILE%"

REM Delete libs7admin.dll
@set FILE=%MYWINSYSDIR%\libs7admin.dll
@if exist "%FILE%" attrib -r -s "%FILE%"
if exist "%FILE%" del /f "%FILE%"

REM Delete libmsir4.dll
@set FILE=%MYWINSYSDIR%\libmsir4.dll
@if exist "%FILE%" attrib -r -s "%FILE%"
if exist "%FILE%" del /f "%FILE%"

REM Delete libpcmt.dll
@set FILE=%MYWINSYSDIR%\libpcmt.dll
@if exist "%FILE%" attrib -r -s "%FILE%"
if exist "%FILE%" del /f "%FILE%"

REM Delete libprds.dll
@set FILE=%MYWINSYSDIR%\libprds.dll
@if exist "%FILE%" attrib -r -s "%FILE%"
if exist "%FILE%" del /f "%FILE%"

REM Delete libprtms.dll
@set FILE=%MYWINSYSDIR%\libprtms.dll
@if exist "%FILE%" attrib -r -s "%FILE%"
if exist "%FILE%" del /f "%FILE%"

REM Delete libprtmsnj.dll
@set FILE=%MYWINSYSDIR%\libprtmsnj.dll
@if exist "%FILE%" attrib -r -s "%FILE%"
if exist "%FILE%" del /f "%FILE%"

REM Delete librtfmt.dll
@set FILE=%MYWINSYSDIR%\librtfmt.dll
@if exist "%FILE%" attrib -r -s "%FILE%"
if exist "%FILE%" del /f "%FILE%"

REM Delete libsigal.dll
@set FILE=%MYWINSYSDIR%\libsigal.dll
@if exist "%FILE%" attrib -r -s "%FILE%"
if exist "%FILE%" del /f "%FILE%"

REM Delete libsipsigal.dll
@set FILE=%MYWINSYSDIR%\libsipsigal.dll
@if exist "%FILE%" attrib -r -s "%FILE%"
if exist "%FILE%" del /f "%FILE%"

REM Delete libsrlmt.dll
@set FILE=%MYWINSYSDIR%\libsrlmt.dll
@if exist "%FILE%" attrib -r -s "%FILE%"
if exist "%FILE%" del /f "%FILE%"

REM Delete libxlog.dll
@set FILE=%MYWINSYSDIR%\libxlog.dll
@if exist "%FILE%" attrib -r -s "%FILE%"
if exist "%FILE%" del /f "%FILE%"

REM Delete LicenseManager.dll
@set FILE=%MYWINSYSDIR%\LicenseManager.dll
@if exist "%FILE%" attrib -r -s "%FILE%"
if exist "%FILE%" del /f "%FILE%"

REM Delete LMode.dll
@set FILE=%MYWINSYSDIR%\LMode.dll
@if exist "%FILE%" attrib -r -s "%FILE%"
if exist "%FILE%" del /f "%FILE%"

REM merc.log
@set FILE=%MYWINSYSDIR%\merc.log
@if exist "%FILE%" attrib -r -s "%FILE%"
if exist "%FILE%" del /f "%FILE%"

REM Delete mercconfig.dll
@set FILE=%MYWINSYSDIR%\mercconfig.dll
@if exist "%FILE%" attrib -r -s "%FILE%"
if exist "%FILE%" del /f "%FILE%"

REM Delete mercperf.dll
@set FILE=%MYWINSYSDIR%\mercperf.dll
@if exist "%FILE%" attrib -r -s "%FILE%"
if exist "%FILE%" del /f "%FILE%"

REM Delete MM_Fax.dll
@set FILE=%MYWINSYSDIR%\MM_Fax.dll
@if exist "%FILE%" attrib -r -s "%FILE%"
if exist "%FILE%" del /f "%FILE%"

REM Delete mnti.dll
@set FILE=%MYWINSYSDIR%\mnti.dll
@if exist "%FILE%" attrib -r -s "%FILE%"
if exist "%FILE%" del /f "%FILE%"

REM Delete msintf.dll
@set FILE=%MYWINSYSDIR%\msintf.dll
@if exist "%FILE%" attrib -r -s "%FILE%"
if exist "%FILE%" del /f "%FILE%"

REM Delete NCMAhw.dll
@set FILE=%MYWINSYSDIR%\NCMAhw.dll
@if exist "%FILE%" attrib -r -s "%FILE%"
if exist "%FILE%" del /f "%FILE%"

REM Delete NCMApi.dll
@set FILE=%MYWINSYSDIR%\NCMApi.dll
@if exist "%FILE%" attrib -r -s "%FILE%"
if exist "%FILE%" del /f "%FILE%"

REM Delete NCMCconf.dll
@set FILE=%MYWINSYSDIR%\NCMCconf.dll
@if exist "%FILE%" attrib -r -s "%FILE%"
if exist "%FILE%" del /f "%FILE%"

REM Delete NCMData.dll
@set FILE=%MYWINSYSDIR%\NCMData.dll
@if exist "%FILE%" attrib -r -s "%FILE%"
if exist "%FILE%" del /f "%FILE%"

REM Delete NCMProp.dll
@set FILE=%MYWINSYSDIR%\NCMProp.dll
@if exist "%FILE%" attrib -r -s "%FILE%"
if exist "%FILE%" del /f "%FILE%"

REM Delete ndi.dll
@set FILE=%MYWINSYSDIR%\ndi.dll
@if exist "%FILE%" attrib -r -s "%FILE%"
if exist "%FILE%" del /f "%FILE%"

REM Delete NtGdk.dll
@set FILE=%MYWINSYSDIR%\NtGdk.dll
@if exist "%FILE%" attrib -r -s "%FILE%"
if exist "%FILE%" del /f "%FILE%"

REM Delete NtGdkMsg.dll
@set FILE=%MYWINSYSDIR%\NtGdkMsg.dll
@if exist "%FILE%" attrib -r -s "%FILE%"
if exist "%FILE%" del /f "%FILE%"

REM Delete ob405.dll
@set FILE=%MYWINSYSDIR%\ob405.dll
@if exist "%FILE%" attrib -r -s "%FILE%"
if exist "%FILE%" del /f "%FILE%"

REM Delete ob405d.dll
@set FILE=%MYWINSYSDIR%\ob405d.dll
@if exist "%FILE%" attrib -r -s "%FILE%"
if exist "%FILE%" del /f "%FILE%"

REM Delete OBBiDir405.dll
@set FILE=%MYWINSYSDIR%\OBBiDir405.dll
@if exist "%FILE%" attrib -r -s "%FILE%"
if exist "%FILE%" del /f "%FILE%"

REM Delete OBBiDir405d.dll
@set FILE=%MYWINSYSDIR%\OBBiDir405d.dll
@if exist "%FILE%" attrib -r -s "%FILE%"
if exist "%FILE%" del /f "%FILE%"

REM Delete OBEvent405.dll
@set FILE=%MYWINSYSDIR%\OBEvent405.dll
@if exist "%FILE%" attrib -r -s "%FILE%"
if exist "%FILE%" del /f "%FILE%"

REM Delete OBEvent405d.dll
@set FILE=%MYWINSYSDIR%\OBEvent405d.dll
@if exist "%FILE%" attrib -r -s "%FILE%"
if exist "%FILE%" del /f "%FILE%"

REM Delete OBEventService405.dll
@set FILE=%MYWINSYSDIR%\OBEventService405.dll
@if exist "%FILE%" attrib -r -s "%FILE%"
if exist "%FILE%" del /f "%FILE%"

REM Delete OBEventService405d.dll
@set FILE=%MYWINSYSDIR%\OBEventService405d.dll
@if exist "%FILE%" attrib -r -s "%FILE%"
if exist "%FILE%" del /f "%FILE%"

REM Delete OBNaming405.dll
@set FILE=%MYWINSYSDIR%\OBNaming405.dll
@if exist "%FILE%" attrib -r -s "%FILE%"
if exist "%FILE%" del /f "%FILE%"

REM Delete OBNaming405d.dll
@set FILE=%MYWINSYSDIR%\OBNaming405d.dll
@if exist "%FILE%" attrib -r -s "%FILE%"
if exist "%FILE%" del /f "%FILE%"

REM Delete OBNamingService405.dll
@set FILE=%MYWINSYSDIR%\OBNamingService405.dll
@if exist "%FILE%" attrib -r -s "%FILE%"
if exist "%FILE%" del /f "%FILE%"

REM Delete OBNamingService405d.dll
@set FILE=%MYWINSYSDIR%\OBNamingService405d.dll
@if exist "%FILE%" attrib -r -s "%FILE%"
if exist "%FILE%" del /f "%FILE%"

REM Delete PBXpert.dll
@set FILE=%MYWINSYSDIR%\PBXpert.dll
@if exist "%FILE%" attrib -r -s "%FILE%"
if exist "%FILE%" del /f "%FILE%"

REM Delete PBXpertWizard.dll
@set FILE=%MYWINSYSDIR%\PBXpertWizard.dll
@if exist "%FILE%" attrib -r -s "%FILE%"
if exist "%FILE%" del /f "%FILE%"

REM Delete pdi.dll
@set FILE=%MYWINSYSDIR%\pdi.dll
@if exist "%FILE%" attrib -r -s "%FILE%"
if exist "%FILE%" del /f "%FILE%"

REM Delete pdkrt.dll
@set FILE=%MYWINSYSDIR%\pdkrt.dll
@if exist "%FILE%" attrib -r -s "%FILE%"
if exist "%FILE%" del /f "%FILE%"

REM Delete pmac_transport.dll
@set FILE=%MYWINSYSDIR%\pmac_transport.dll
@if exist "%FILE%" attrib -r -s "%FILE%"
if exist "%FILE%" del /f "%FILE%"

REM Delete pmacadl.dll
@set FILE=%MYWINSYSDIR%\pmacadl.dll
@if exist "%FILE%" attrib -r -s "%FILE%"
if exist "%FILE%" del /f "%FILE%"

REM Delete pnpapi.dll
@set FILE=%MYWINSYSDIR%\pnpapi.dll
@if exist "%FILE%" attrib -r -s "%FILE%"
if exist "%FILE%" del /f "%FILE%"

REM Delete prtmsspan.dll
@set FILE=%MYWINSYSDIR%\prtmsspan.dll
@if exist "%FILE%" attrib -r -s "%FILE%"
if exist "%FILE%" del /f "%FILE%"

REM Delete r4bsp.dll
@set FILE=%MYWINSYSDIR%\r4bsp.dll
@if exist "%FILE%" attrib -r -s "%FILE%"
if exist "%FILE%" del /f "%FILE%"

REM Delete RNCMapi.dll
@set FILE=%MYWINSYSDIR%\RNCMapi.dll
@if exist "%FILE%" attrib -r -s "%FILE%"
if exist "%FILE%" del /f "%FILE%"

REM Delete rv32h323.dll
@set FILE=%MYWINSYSDIR%\rv32h323.dll
@if exist "%FILE%" attrib -r -s "%FILE%"
if exist "%FILE%" del /f "%FILE%"

REM Delete rv32rtp.dll
@set FILE=%MYWINSYSDIR%\rv32rtp.dll
@if exist "%FILE%" attrib -r -s "%FILE%"
if exist "%FILE%" del /f "%FILE%"

REM Delete rvads.dll
@set FILE=%MYWINSYSDIR%\rvads.dll
@if exist "%FILE%" attrib -r -s "%FILE%"
if exist "%FILE%" del /f "%FILE%"

REM Delete rvasn1.dll
@set FILE=%MYWINSYSDIR%\rvasn1.dll
@if exist "%FILE%" attrib -r -s "%FILE%"
if exist "%FILE%" del /f "%FILE%"

REM Delete rvcommon.dll
@set FILE=%MYWINSYSDIR%\rvcommon.dll
@if exist "%FILE%" attrib -r -s "%FILE%"
if exist "%FILE%" del /f "%FILE%"

REM Delete rvcore.dll
@set FILE=%MYWINSYSDIR%\rvcore.dll
@if exist "%FILE%" attrib -r -s "%FILE%"
if exist "%FILE%" del /f "%FILE%"

REM Delete rvsdp.dll
@set FILE=%MYWINSYSDIR%\rvsdp.dll
@if exist "%FILE%" attrib -r -s "%FILE%"
if exist "%FILE%" del /f "%FILE%"

REM Delete rvsip.dll
@set FILE=%MYWINSYSDIR%\rvsip.dll
@if exist "%FILE%" attrib -r -s "%FILE%"
if exist "%FILE%" del /f "%FILE%"

REM Delete S7Cfg.dll
@set FILE=%MYWINSYSDIR%\S7Cfg.dll
@if exist "%FILE%" attrib -r -s "%FILE%"
if exist "%FILE%" del /f "%FILE%"

REM Delete SCEventMsg.dll
@set FILE=%MYWINSYSDIR%\SCEventMsg.dll
@if exist "%FILE%" attrib -r -s "%FILE%"
if exist "%FILE%" del /f "%FILE%"

REM Delete sdntf.dll
@set FILE=%MYWINSYSDIR%\sdntf.dll
@if exist "%FILE%" attrib -r -s "%FILE%"
if exist "%FILE%" del /f "%FILE%"

REM Delete SnmpConfigUtility.exe
@set FILE=%MYWINSYSDIR%\SnmpConfigUtility.exe
@if exist "%FILE%" attrib -r -s "%FILE%"
if exist "%FILE%" del /f "%FILE%"

REM Delete SoftFaxRM.dll
@set FILE=%MYWINSYSDIR%\SoftFaxRM.dll
@if exist "%FILE%" attrib -r -s "%FILE%"
if exist "%FILE%" del /f "%FILE%"

REM Delete sramperf.dll
@set FILE=%MYWINSYSDIR%\sramperf.dll
@if exist "%FILE%" attrib -r -s "%FILE%"
if exist "%FILE%" del /f "%FILE%"

REM Delete sse.dll
@set FILE=%MYWINSYSDIR%\sse.dll
@if exist "%FILE%" attrib -r -s "%FILE%"
if exist "%FILE%" del /f "%FILE%"

REM Delete supserve.dll
@set FILE=%MYWINSYSDIR%\supserve.dll
@if exist "%FILE%" attrib -r -s "%FILE%"
if exist "%FILE%" del /f "%FILE%"

REM Delete swadl.dll
@set FILE=%MYWINSYSDIR%\swadl.dll
@if exist "%FILE%" attrib -r -s "%FILE%"
if exist "%FILE%" del /f "%FILE%"

REM Delete swfdsp.dll
@set FILE=%MYWINSYSDIR%\swfdsp.dll
@if exist "%FILE%" attrib -r -s "%FILE%"
if exist "%FILE%" del /f "%FILE%"

REM Delete tascscu.dll
@set FILE=%MYWINSYSDIR%\tascscu.dll
@if exist "%FILE%" attrib -r -s "%FILE%"
if exist "%FILE%" del /f "%FILE%"

REM Delete tcutil.dll
@set FILE=%MYWINSYSDIR%\tcutil.dll
@if exist "%FILE%" attrib -r -s "%FILE%"
if exist "%FILE%" del /f "%FILE%"

REM Delete syntellect.dll
@set FILE=%MYWINSYSDIR%\syntellect.dll
@if exist "%FILE%" attrib -r -s "%FILE%"
if exist "%FILE%" del /f "%FILE%"

REM Delete tascscu.dll
@set FILE=%MYWINSYSDIR%\tascscu.dll
@if exist "%FILE%" attrib -r -s "%FILE%"
if exist "%FILE%" del /f "%FILE%"

REM Delete ThirdPartyBsp.dll
@set FILE=%MYWINSYSDIR%\ThirdPartyBsp.dll
@if exist "%FILE%" attrib -r -s "%FILE%"
if exist "%FILE%" del /f "%FILE%"

REM Delete ThirdPartyDetector.dll
@set FILE=%MYWINSYSDIR%\ThirdPartyDetector.dll
@if exist "%FILE%" attrib -r -s "%FILE%"
if exist "%FILE%" del /f "%FILE%"

REM Delete vfxntf.dll
@set FILE=%MYWINSYSDIR%\vfxntf.dll
@if exist "%FILE%" attrib -r -s "%FILE%"
if exist "%FILE%" del /f "%FILE%"

REM Delete voxspan.dll
@set FILE=%MYWINSYSDIR%\voxspan.dll
@if exist "%FILE%" attrib -r -s "%FILE%"
if exist "%FILE%" del /f "%FILE%"

REM Delete xerces-c_1_1.dll
@set FILE=%MYWINSYSDIR%\xerces-c_1_1.dll
@if exist "%FILE%" attrib -r -s "%FILE%"
if exist "%FILE%" del /f "%FILE%"

REM Delete xlog.bin
@set FILE=%MYWINSYSDIR%\xlog.bin
@if exist "%FILE%" attrib -r -s "%FILE%"
if exist "%FILE%" del /f "%FILE%"

REM
REM
REM Delete files from %MYWINDRIVERSDIR%
REM
REM

REM Delete AntDetect.sys
@set FILE=%MYWINDRIVERSDIR%\AntDetect.sys
@if exist "%FILE%" attrib -r -s "%FILE%"
if exist "%FILE%" del /f "%FILE%"

REM Delete apicdrv.sys
@set FILE=%MYWINDRIVERSDIR%\apicdrv.sys
@if exist "%FILE%" attrib -r -s "%FILE%"
if exist "%FILE%" del /f "%FILE%"

REM Delete BrgRes.sys
@set FILE=%MYWINDRIVERSDIR%\BrgRes.sys
@if exist "%FILE%" attrib -r -s "%FILE%"
if exist "%FILE%" del /f "%FILE%"

REM Delete DlgcAntares.sys
@set FILE=%MYWINDRIVERSDIR%\DlgcAntares.sys
@if exist "%FILE%" attrib -r -s "%FILE%"
if exist "%FILE%" del /f "%FILE%"

REM Delete dlgcbri.sys
@set FILE=%MYWINDRIVERSDIR%\dlgcbri.sys
@if exist "%FILE%" attrib -r -s "%FILE%"
if exist "%FILE%" del /f "%FILE%"

REM Delete dlgccore.sys
@set FILE=%MYWINDRIVERSDIR%\dlgccore.sys
@if exist "%FILE%" attrib -r -s "%FILE%"
if exist "%FILE%" del /f "%FILE%"

REM Delete dlgcdcm.sys
@set FILE=%MYWINDRIVERSDIR%\dlgcdcm.sys
@if exist "%FILE%" attrib -r -s "%FILE%"
if exist "%FILE%" del /f "%FILE%"

REM Delete dlgcmcd.sys
@set FILE=%MYWINDRIVERSDIR%\dlgcmcd.sys
@if exist "%FILE%" attrib -r -s "%FILE%"
if exist "%FILE%" del /f "%FILE%"

REM Delete dlgcmpd.sys
@set FILE=%MYWINDRIVERSDIR%\dlgcmpd.sys
@if exist "%FILE%" attrib -r -s "%FILE%"
if exist "%FILE%" del /f "%FILE%"

REM Delete dlgcsram.sys
@set FILE=%MYWINDRIVERSDIR%\dlgcsram.sys
@if exist "%FILE%" attrib -r -s "%FILE%"
if exist "%FILE%" del /f "%FILE%"

REM Delete dlgcupgrade.sys
@set FILE=%MYWINDRIVERSDIR%\dlgcupgrade.sys
@if exist "%FILE%" attrib -r -s "%FILE%"
if exist "%FILE%" del /f "%FILE%"

REM Delete DM3InsightDrv.sys
@set FILE=%MYWINDRIVERSDIR%\DM3InsightDrv.sys
@if exist "%FILE%" attrib -r -s "%FILE%"
if exist "%FILE%" del /f "%FILE%"

REM Delete Dm3nk.sys
@set FILE=%MYWINDRIVERSDIR%\Dm3nk.sys
@if exist "%FILE%" attrib -r -s "%FILE%"
if exist "%FILE%" del /f "%FILE%"

REM Delete glfxisa.sys
@set FILE=%MYWINDRIVERSDIR%\glfxisa.sys
@if exist "%FILE%" attrib -r -s "%FILE%"
if exist "%FILE%" del /f "%FILE%"

REM Delete glfxpci.sys
@set FILE=%MYWINDRIVERSDIR%\glfxpci.sys
@if exist "%FILE%" attrib -r -s "%FILE%"
if exist "%FILE%" del /f "%FILE%"

REM Delete gloaddrv.sys
@set FILE=%MYWINDRIVERSDIR%\gloaddrv.sys
@if exist "%FILE%" attrib -r -s "%FILE%"
if exist "%FILE%" del /f "%FILE%"

REM Delete KMBC.sys
@set FILE=%MYWINDRIVERSDIR%\kmbc.sys
@if exist "%FILE%" attrib -r -s "%FILE%"
if exist "%FILE%" del /f "%FILE%"

REM Delete pcd.sys
@set FILE=%MYWINDRIVERSDIR%\pcd.sys
@if exist "%FILE%" attrib -r -s "%FILE%"
if exist "%FILE%" del /f "%FILE%"

REM Delete pcdd.sys
@set FILE=%MYWINDRIVERSDIR%\pcdd.sys
@if exist "%FILE%" attrib -r -s "%FILE%"
if exist "%FILE%" del /f "%FILE%"

REM Delete pmac_wdm.inf
@set FILE=%MYWININFDIR%\pmac_wdm.inf
@if exist "%FILE%" attrib -r -s "%FILE%"
if exist "%FILE%" del /f "%FILE%"

REM Delete ppd.sys
@set FILE=%MYWINDRIVERSDIR%\ppd.sys
@if exist "%FILE%" attrib -r -s "%FILE%"
if exist "%FILE%" del /f "%FILE%"

REM Delete ppdd.sys
@set FILE=%MYWINDRIVERSDIR%\ppdd.sys
@if exist "%FILE%" attrib -r -s "%FILE%"
if exist "%FILE%" del /f "%FILE%"

REM Delete smtkstub.dll
@set FILE=%MYWINDRIVERSDIR%\smtkstub.dll
@if exist "%FILE%" attrib -r -s "%FILE%"
if exist "%FILE%" del /f "%FILE%"

REM Delete ssp.mlm.sys
@set FILE=%MYWINDRIVERSDIR%\ssp.mlm.sys
@if exist "%FILE%" attrib -r -s "%FILE%"
if exist "%FILE%" del /f "%FILE%"

REM Delete sspIntf.sys
@set FILE=%MYWINDRIVERSDIR%\sspIntf.sys
@if exist "%FILE%" attrib -r -s "%FILE%"
if exist "%FILE%" del /f "%FILE%"

REM Delete wdm_ant.inf
@set FILE=%MYWINDRIVERSDIR%\wdm_ant.inf
@if exist "%FILE%" attrib -r -s "%FILE%"
if exist "%FILE%" del /f "%FILE%"

REM Delete Dialogic files from %MYWININFDIR%
REM Checking for oem*.inf files to delete.
@for %%i in ("%MYWININFDIR%\oem*.inf") do @call:RM_OEM "%%i"


@REM ---------------------------------------------------------------
@REM skip over this subroutine.  It should only be CALLed
@GOTO :RM_OEM_SKIP
@REM ---------------------------------------------------------------
:RM_OEM
@REM this label should be CALLed with a single parameter which
@REM is the name of a file name to delete if it is one of ours.
@REM -
@REM We'll check the contents of the file passed as the first param
@REM for some special strings.  If those strings exist in the file
@REM then it will need to be deleted.

@REM check if file contains "dialogic" string
@find /I /C "dialogic" %1 > NUL
@If Errorlevel 0 SET ERRLEV=0
@If Errorlevel 1 SET ERRLEV=1
@if "%ERRLEV%" == "0" GOTO :RM_OEM_DELETE

@REM check if file contains "Intel NetStructure" string
@find /I /C "Intel NetStructure" %1 > NUL
@If Errorlevel 0 SET ERRLEV=0
@If Errorlevel 1 SET ERRLEV=1
@if "%ERRLEV%" == "0" GOTO :RM_OEM_DELETE

@REM if get here then nothing to delete so jump over delete.
@GOTO :RM_OEM_NO_DELETE

:RM_OEM_DELETE
@REM do the deletion here
@echo deleting file %~1
@set FILE=%~1
@if exist "%FILE%" attrib -r -s "%FILE%"
if exist "%FILE%" del /f "%FILE%"

REM check for corresponding .pnf file and delete if exists
@set FILE=%~d1%~p1%~n1.pnf
@if exist "%FILE%" attrib -r -s "%FILE%"
if exist "%FILE%" del /f "%FILE%"


:RM_OEM_NO_DELETE

@REM This goto is the last command in the RM_OEM function.
@REM Goto end of file really just returns from call
@goto :EOF
@REM ---------------------------------------------------------------
:RM_OEM_SKIP
@REM ---------------------------------------------------------------





@REM
@REM The following code generates a registry file which, when run
@REM will delete various keys which were not removed by the uninstall.
@REM
REM
REM Generating temporary file containing list of registry keys to be removed
REM

@set regpath=
@call:makestr "%DIALOGIC%" 2>NUL
@set DIALOGICREGPATH=%regpath%

@set regpath=
@call:makestr "%MYWINSYSDIR%" 2>NUL
@set WINSYSREGPATH=%regpath%

@set regpath=
@call:makestr "%MYWINDRIVERSDIR%" 2>NUL
@set WINDRVREGPATH=%regpath%

@REM ---------------------------------------------------------------
@REM This subroutine makes path strings with double back slashes "\\"
@REM which is needed for some registry values
@REM But first we skip over this subroutine. It should only be CALLed
@goto mkregfile
@REM ---------------------------------------------------------------

:makestr

@for /F "usebackq tokens=1* delims=\" %%i IN ('%~1') DO @set regpath=%regpath%%%i\\& @if not "%%j"=="" (@call:makestr "%%j")
@goto :EOF

:mkregfile
@if exist "%TEMP%\dlgc_reg_clean.reg" del /f "%TEMP%\dlgc_reg_clean.reg"

@echo REGEDIT4>> %TEMP%\dlgc_reg_clean.reg
@echo.>> %TEMP%\dlgc_reg_clean.reg
@echo #####>> %TEMP%\dlgc_reg_clean.reg
@echo ##### Copyright (C) 2003-2007 Dialogic Corporation.  All Rights Reserved.>> %TEMP%\dlgc_reg_clean.reg
@echo ##### All names, products, and services mentioned herein are the>> %TEMP%\dlgc_reg_clean.reg
@echo ##### trademarks or registered trademarks of their respective>> %TEMP%\dlgc_reg_clean.reg
@echo ##### organizations and are the sole property of their respective>> %TEMP%\dlgc_reg_clean.reg
@echo ##### owners.>> %TEMP%\dlgc_reg_clean.reg
@echo #####>> %TEMP%\dlgc_reg_clean.reg
@echo.>> %TEMP%\dlgc_reg_clean.reg
@echo #####>> %TEMP%\dlgc_reg_clean.reg
@echo ##### Dialogic key hierarchy is common to all releases>> %TEMP%\dlgc_reg_clean.reg
@echo #####>> %TEMP%\dlgc_reg_clean.reg
@echo.>> %TEMP%\dlgc_reg_clean.reg
@echo [-HKEY_LOCAL_MACHINE\SOFTWARE\Dialogic]>> %TEMP%\dlgc_reg_clean.reg
@echo.>> %TEMP%\dlgc_reg_clean.reg
@echo #####>> %TEMP%\dlgc_reg_clean.reg
@echo ##### GammaLink still writes config information outside the Dialogic hierarchy>> %TEMP%\dlgc_reg_clean.reg
@echo #####>> %TEMP%\dlgc_reg_clean.reg
@echo [-HKEY_LOCAL_MACHINE\SOFTWARE\GammaLink]>> %TEMP%\dlgc_reg_clean.reg
@echo [-HKEY_LOCAL_MACHINE\SOFTWARE\Microsoft\Windows\CurrentVersion\Control Panel\Cpls]>> %TEMP%\dlgc_reg_clean.reg
@echo "ConfigGamma"=->> %TEMP%\dlgc_reg_clean.reg
@echo "ConfigGDK"=->> %TEMP%\dlgc_reg_clean.reg
@echo.>> %TEMP%\dlgc_reg_clean.reg
@echo #####>> %TEMP%\dlgc_reg_clean.reg
@echo ##### Global Call Protocols 3.0 and earlier>> %TEMP%\dlgc_reg_clean.reg
@echo #####>> %TEMP%\dlgc_reg_clean.reg
@echo [-HKEY_LOCAL_MACHINE\SOFTWARE\Intel Dialogic]>> %TEMP%\dlgc_reg_clean.reg
@echo.>> %TEMP%\dlgc_reg_clean.reg
@echo #####>> %TEMP%\dlgc_reg_clean.reg
@echo ##### SNMP support>> %TEMP%\dlgc_reg_clean.reg
@echo #####>> %TEMP%\dlgc_reg_clean.reg
@echo [-HKEY_LOCAL_MACHINE\SOFTWARE\Intel\Dialogic SNMP]>> %TEMP%\dlgc_reg_clean.reg
@echo.>> %TEMP%\dlgc_reg_clean.reg
@echo.>> %TEMP%\dlgc_reg_clean.reg
@echo #####>> %TEMP%\dlgc_reg_clean.reg
@echo ##### From the SR 6.0 cPCI FP1 release>> %TEMP%\dlgc_reg_clean.reg
@echo #####>> %TEMP%\dlgc_reg_clean.reg
@echo [-HKEY_LOCAL_MACHINE\SOFTWARE\INTEL\Intel(R) Dialogic(R) System Release 6.0 cPCI Feature Pack 1 for Windows]>> %TEMP%\dlgc_reg_clean.reg
@echo.>> %TEMP%\dlgc_reg_clean.reg
@echo #####>> %TEMP%\dlgc_reg_clean.reg
@echo ##### These keys were used in very old releases>> %TEMP%\dlgc_reg_clean.reg
@echo #####>> %TEMP%\dlgc_reg_clean.reg
@echo.>> %TEMP%\dlgc_reg_clean.reg
@echo [-HKEY_LOCAL_MACHINE\Dialogic System Release]>> %TEMP%\dlgc_reg_clean.reg
@echo [-HKEY_LOCAL_MACHINE\SOFTWARE\Microsoft\Windows\CurrentVersion\Uninstall\DialogicR4X]>> %TEMP%\dlgc_reg_clean.reg
@echo.>> %TEMP%\dlgc_reg_clean.reg
@echo #####>> %TEMP%\dlgc_reg_clean.reg
@echo ##### Intel Dialogic services>> %TEMP%\dlgc_reg_clean.reg
@echo #####>> %TEMP%\dlgc_reg_clean.reg
@echo.>> %TEMP%\dlgc_reg_clean.reg
@echo # CurrentControlSet>> %TEMP%\dlgc_reg_clean.reg
@echo [-HKEY_LOCAL_MACHINE\SYSTEM\CurrentControlSet\Services\AnmChannelFactoryServer]>> %TEMP%\dlgc_reg_clean.reg
@echo [-HKEY_LOCAL_MACHINE\SYSTEM\CurrentControlSet\Services\AnmChannelServer]>> %TEMP%\dlgc_reg_clean.reg
@echo [-HKEY_LOCAL_MACHINE\SYSTEM\CurrentControlSet\Services\AnmLoggerServer]>> %TEMP%\dlgc_reg_clean.reg
@echo [-HKEY_LOCAL_MACHINE\SYSTEM\CurrentControlSet\Services\AnmSupplierServer]>> %TEMP%\dlgc_reg_clean.reg
@echo [-HKEY_LOCAL_MACHINE\SYSTEM\CurrentControlSet\Services\AntDetect]>> %TEMP%\dlgc_reg_clean.reg
@echo [-HKEY_LOCAL_MACHINE\SYSTEM\CurrentControlSet\Services\Boardserver]>> %TEMP%\dlgc_reg_clean.reg
@echo [-HKEY_LOCAL_MACHINE\SYSTEM\CurrentControlSet\Services\CTBusBroker]>> %TEMP%\dlgc_reg_clean.reg
@echo [-HKEY_LOCAL_MACHINE\SYSTEM\CurrentControlSet\Services\DetectorsProj]>> %TEMP%\dlgc_reg_clean.reg
@echo [-HKEY_LOCAL_MACHINE\SYSTEM\CurrentControlSet\Services\DebugAngel]>> %TEMP%\dlgc_reg_clean.reg
@echo [-HKEY_LOCAL_MACHINE\SYSTEM\CurrentControlSet\Services\Dialogic]>> %TEMP%\dlgc_reg_clean.reg
@echo [-HKEY_LOCAL_MACHINE\SYSTEM\CurrentControlSet\Services\DlgcAntares]>> %TEMP%\dlgc_reg_clean.reg
@echo [-HKEY_LOCAL_MACHINE\SYSTEM\CurrentControlSet\Services\DlgcDcm]>> %TEMP%\dlgc_reg_clean.reg
@echo [-HKEY_LOCAL_MACHINE\SYSTEM\CurrentControlSet\Services\DLGCDeviceMapper]>> %TEMP%\dlgc_reg_clean.reg
@echo [-HKEY_LOCAL_MACHINE\SYSTEM\CurrentControlSet\Services\DlgcH323]>> %TEMP%\dlgc_reg_clean.reg
@echo [-HKEY_LOCAL_MACHINE\SYSTEM\CurrentControlSet\Services\Dlgcmcd]>> %TEMP%\dlgc_reg_clean.reg
@echo [-HKEY_LOCAL_MACHINE\SYSTEM\CurrentControlSet\Services\DlgcMemDoler]>> %TEMP%\dlgc_reg_clean.reg
@echo [-HKEY_LOCAL_MACHINE\SYSTEM\CurrentControlSet\Services\Dlgcmpd]>> %TEMP%\dlgc_reg_clean.reg
@echo [-HKEY_LOCAL_MACHINE\SYSTEM\CurrentControlSet\Services\DlgcS7Srv]>> %TEMP%\dlgc_reg_clean.reg
@echo [-HKEY_LOCAL_MACHINE\SYSTEM\CurrentControlSet\Services\DlgcSram]>> %TEMP%\dlgc_reg_clean.reg
@echo [-HKEY_LOCAL_MACHINE\SYSTEM\CurrentControlSet\Services\DlgcUpgrade]>> %TEMP%\dlgc_reg_clean.reg
@echo [-HKEY_LOCAL_MACHINE\SYSTEM\CurrentControlSet\Services\dlgH323]>> %TEMP%\dlgc_reg_clean.reg
@echo [-HKEY_LOCAL_MACHINE\SYSTEM\CurrentControlSet\Services\DlgPnPObserverService]>> %TEMP%\dlgc_reg_clean.reg
@echo [-HKEY_LOCAL_MACHINE\SYSTEM\CurrentControlSet\Services\DM3Config]>> %TEMP%\dlgc_reg_clean.reg
@echo [-HKEY_LOCAL_MACHINE\SYSTEM\CurrentControlSet\Services\DM3InsightDrv]>> %TEMP%\dlgc_reg_clean.reg
@echo [-HKEY_LOCAL_MACHINE\SYSTEM\CurrentControlSet\Services\EventService]>> %TEMP%\dlgc_reg_clean.reg
@echo [-HKEY_LOCAL_MACHINE\SYSTEM\CurrentControlSet\Services\GammaFax]>> %TEMP%\dlgc_reg_clean.reg
@echo [-HKEY_LOCAL_MACHINE\SYSTEM\CurrentControlSet\Services\GlfxIsa]>> %TEMP%\dlgc_reg_clean.reg
@echo [-HKEY_LOCAL_MACHINE\SYSTEM\CurrentControlSet\Services\GlfxPci]>> %TEMP%\dlgc_reg_clean.reg
@echo [-HKEY_LOCAL_MACHINE\SYSTEM\CurrentControlSet\Services\Gloaddrv]>> %TEMP%\dlgc_reg_clean.reg
@echo [-HKEY_LOCAL_MACHINE\SYSTEM\CurrentControlSet\Services\IMRService]>> %TEMP%\dlgc_reg_clean.reg
@echo [-HKEY_LOCAL_MACHINE\SYSTEM\CurrentControlSet\Services\IPMedia]>> %TEMP%\dlgc_reg_clean.reg
@echo [-HKEY_LOCAL_MACHINE\SYSTEM\CurrentControlSet\Services\NamingService]>> %TEMP%\dlgc_reg_clean.reg
@echo [-HKEY_LOCAL_MACHINE\SYSTEM\CurrentControlSet\Services\RtfDispatcher]>> %TEMP%\dlgc_reg_clean.reg
@echo [-HKEY_LOCAL_MACHINE\SYSTEM\CurrentControlSet\Services\Springware_temp]>> %TEMP%\dlgc_reg_clean.reg
@echo.>> %TEMP%\dlgc_reg_clean.reg
@echo.>> %TEMP%\dlgc_reg_clean.reg
@echo.>> %TEMP%\dlgc_reg_clean.reg
@echo # ControlSet001>> %TEMP%\dlgc_reg_clean.reg
@echo [-HKEY_LOCAL_MACHINE\SYSTEM\ControlSet001\Services\AnmChannelFactoryServer]>> %TEMP%\dlgc_reg_clean.reg
@echo [-HKEY_LOCAL_MACHINE\SYSTEM\ControlSet001\Services\AnmChannelServer]>> %TEMP%\dlgc_reg_clean.reg
@echo [-HKEY_LOCAL_MACHINE\SYSTEM\ControlSet001\Services\AnmLoggerServer]>> %TEMP%\dlgc_reg_clean.reg
@echo [-HKEY_LOCAL_MACHINE\SYSTEM\ControlSet001\Services\AnmSupplierServer]>> %TEMP%\dlgc_reg_clean.reg
@echo [-HKEY_LOCAL_MACHINE\SYSTEM\ControlSet001\Services\AntDetect]>> %TEMP%\dlgc_reg_clean.reg
@echo [-HKEY_LOCAL_MACHINE\SYSTEM\ControlSet001\Services\Boardserver]>> %TEMP%\dlgc_reg_clean.reg
@echo [-HKEY_LOCAL_MACHINE\SYSTEM\ControlSet001\Services\CTBusBroker]>> %TEMP%\dlgc_reg_clean.reg
@echo [-HKEY_LOCAL_MACHINE\SYSTEM\ControlSet001\Services\DetectorsProj]>> %TEMP%\dlgc_reg_clean.reg
@echo [-HKEY_LOCAL_MACHINE\SYSTEM\ControlSet001\Services\DebugAngel]>> %TEMP%\dlgc_reg_clean.reg
@echo [-HKEY_LOCAL_MACHINE\SYSTEM\ControlSet001\Services\Dialogic]>> %TEMP%\dlgc_reg_clean.reg
@echo [-HKEY_LOCAL_MACHINE\SYSTEM\ControlSet001\Services\DlgcAntares]>> %TEMP%\dlgc_reg_clean.reg
@echo [-HKEY_LOCAL_MACHINE\SYSTEM\ControlSet001\Services\DlgcDcm]>> %TEMP%\dlgc_reg_clean.reg
@echo [-HKEY_LOCAL_MACHINE\SYSTEM\ControlSet001\Services\DLGCDeviceMapper]>> %TEMP%\dlgc_reg_clean.reg
@echo [-HKEY_LOCAL_MACHINE\SYSTEM\ControlSet001\Services\DlgcH323]>> %TEMP%\dlgc_reg_clean.reg
@echo [-HKEY_LOCAL_MACHINE\SYSTEM\ControlSet001\Services\Dlgcmcd]>> %TEMP%\dlgc_reg_clean.reg
@echo [-HKEY_LOCAL_MACHINE\SYSTEM\ControlSet001\Services\DlgcMemDoler]>> %TEMP%\dlgc_reg_clean.reg
@echo [-HKEY_LOCAL_MACHINE\SYSTEM\ControlSet001\Services\Dlgcmpd]>> %TEMP%\dlgc_reg_clean.reg
@echo [-HKEY_LOCAL_MACHINE\SYSTEM\ControlSet001\Services\DlgcS7Srv]>> %TEMP%\dlgc_reg_clean.reg
@echo [-HKEY_LOCAL_MACHINE\SYSTEM\ControlSet001\Services\DlgcSram]>> %TEMP%\dlgc_reg_clean.reg
@echo [-HKEY_LOCAL_MACHINE\SYSTEM\ControlSet001\Services\DlgcUpgrade]>> %TEMP%\dlgc_reg_clean.reg
@echo [-HKEY_LOCAL_MACHINE\SYSTEM\ControlSet001\Services\dlgH323]>> %TEMP%\dlgc_reg_clean.reg
@echo [-HKEY_LOCAL_MACHINE\SYSTEM\ControlSet001\Services\DlgPnPObserverService]>> %TEMP%\dlgc_reg_clean.reg
@echo [-HKEY_LOCAL_MACHINE\SYSTEM\ControlSet001\Services\DM3Config]>> %TEMP%\dlgc_reg_clean.reg
@echo [-HKEY_LOCAL_MACHINE\SYSTEM\ControlSet001\Services\DM3InsightDrv]>> %TEMP%\dlgc_reg_clean.reg
@echo [-HKEY_LOCAL_MACHINE\SYSTEM\ControlSet001\Services\EventService]>> %TEMP%\dlgc_reg_clean.reg
@echo [-HKEY_LOCAL_MACHINE\SYSTEM\ControlSet001\Services\GammaFax]>> %TEMP%\dlgc_reg_clean.reg
@echo [-HKEY_LOCAL_MACHINE\SYSTEM\ControlSet001\Services\GlfxIsa]>> %TEMP%\dlgc_reg_clean.reg
@echo [-HKEY_LOCAL_MACHINE\SYSTEM\ControlSet001\Services\GlfxPci]>> %TEMP%\dlgc_reg_clean.reg
@echo [-HKEY_LOCAL_MACHINE\SYSTEM\ControlSet001\Services\Gloaddrv]>> %TEMP%\dlgc_reg_clean.reg
@echo [-HKEY_LOCAL_MACHINE\SYSTEM\ControlSet001\Services\IMRService]>> %TEMP%\dlgc_reg_clean.reg
@echo [-HKEY_LOCAL_MACHINE\SYSTEM\ControlSet001\Services\IPMedia]>> %TEMP%\dlgc_reg_clean.reg
@echo [-HKEY_LOCAL_MACHINE\SYSTEM\ControlSet001\Services\NamingService]>> %TEMP%\dlgc_reg_clean.reg
@echo [-HKEY_LOCAL_MACHINE\SYSTEM\ControlSet001\Services\RtfDispatcher]>> %TEMP%\dlgc_reg_clean.reg
@echo [-HKEY_LOCAL_MACHINE\SYSTEM\ControlSet001\Services\Springware_temp]>> %TEMP%\dlgc_reg_clean.reg
@echo.>> %TEMP%\dlgc_reg_clean.reg
@echo.>> %TEMP%\dlgc_reg_clean.reg
@echo # ControlSet002>> %TEMP%\dlgc_reg_clean.reg
@echo [-HKEY_LOCAL_MACHINE\SYSTEM\ControlSet002\Services\AnmChannelFactoryServer]>> %TEMP%\dlgc_reg_clean.reg
@echo [-HKEY_LOCAL_MACHINE\SYSTEM\ControlSet002\Services\AnmChannelServer]>> %TEMP%\dlgc_reg_clean.reg
@echo [-HKEY_LOCAL_MACHINE\SYSTEM\ControlSet002\Services\AnmLoggerServer]>> %TEMP%\dlgc_reg_clean.reg
@echo [-HKEY_LOCAL_MACHINE\SYSTEM\ControlSet002\Services\AnmSupplierServer]>> %TEMP%\dlgc_reg_clean.reg
@echo [-HKEY_LOCAL_MACHINE\SYSTEM\ControlSet002\Services\AntDetect]>> %TEMP%\dlgc_reg_clean.reg
@echo [-HKEY_LOCAL_MACHINE\SYSTEM\ControlSet002\Services\Boardserver]>> %TEMP%\dlgc_reg_clean.reg
@echo [-HKEY_LOCAL_MACHINE\SYSTEM\ControlSet002\Services\CTBusBroker]>> %TEMP%\dlgc_reg_clean.reg
@echo [-HKEY_LOCAL_MACHINE\SYSTEM\ControlSet002\Services\DetectorsProj]>> %TEMP%\dlgc_reg_clean.reg
@echo [-HKEY_LOCAL_MACHINE\SYSTEM\ControlSet002\Services\DebugAngel]>> %TEMP%\dlgc_reg_clean.reg
@echo [-HKEY_LOCAL_MACHINE\SYSTEM\ControlSet002\Services\Dialogic]>> %TEMP%\dlgc_reg_clean.reg
@echo [-HKEY_LOCAL_MACHINE\SYSTEM\ControlSet002\Services\DlgcAntares]>> %TEMP%\dlgc_reg_clean.reg
@echo [-HKEY_LOCAL_MACHINE\SYSTEM\ControlSet002\Services\DlgcDcm]>> %TEMP%\dlgc_reg_clean.reg
@echo [-HKEY_LOCAL_MACHINE\SYSTEM\ControlSet002\Services\DLGCDeviceMapper]>> %TEMP%\dlgc_reg_clean.reg
@echo [-HKEY_LOCAL_MACHINE\SYSTEM\ControlSet002\Services\DlgcH323]>> %TEMP%\dlgc_reg_clean.reg
@echo [-HKEY_LOCAL_MACHINE\SYSTEM\ControlSet002\Services\Dlgcmcd]>> %TEMP%\dlgc_reg_clean.reg
@echo [-HKEY_LOCAL_MACHINE\SYSTEM\ControlSet002\Services\DlgcMemDoler]>> %TEMP%\dlgc_reg_clean.reg
@echo [-HKEY_LOCAL_MACHINE\SYSTEM\ControlSet002\Services\Dlgcmpd]>> %TEMP%\dlgc_reg_clean.reg
@echo [-HKEY_LOCAL_MACHINE\SYSTEM\ControlSet002\Services\DlgcS7Srv]>> %TEMP%\dlgc_reg_clean.reg
@echo [-HKEY_LOCAL_MACHINE\SYSTEM\ControlSet002\Services\DlgcSram]>> %TEMP%\dlgc_reg_clean.reg
@echo [-HKEY_LOCAL_MACHINE\SYSTEM\ControlSet002\Services\DlgcUpgrade]>> %TEMP%\dlgc_reg_clean.reg
@echo [-HKEY_LOCAL_MACHINE\SYSTEM\ControlSet002\Services\dlgH323]>> %TEMP%\dlgc_reg_clean.reg
@echo [-HKEY_LOCAL_MACHINE\SYSTEM\ControlSet002\Services\DlgPnPObserverService]>> %TEMP%\dlgc_reg_clean.reg
@echo [-HKEY_LOCAL_MACHINE\SYSTEM\ControlSet002\Services\DM3Config]>> %TEMP%\dlgc_reg_clean.reg
@echo [-HKEY_LOCAL_MACHINE\SYSTEM\ControlSet002\Services\DM3InsightDrv]>> %TEMP%\dlgc_reg_clean.reg
@echo [-HKEY_LOCAL_MACHINE\SYSTEM\ControlSet002\Services\EventService]>> %TEMP%\dlgc_reg_clean.reg
@echo [-HKEY_LOCAL_MACHINE\SYSTEM\ControlSet002\Services\GammaFax]>> %TEMP%\dlgc_reg_clean.reg
@echo [-HKEY_LOCAL_MACHINE\SYSTEM\ControlSet002\Services\GlfxIsa]>> %TEMP%\dlgc_reg_clean.reg
@echo [-HKEY_LOCAL_MACHINE\SYSTEM\ControlSet002\Services\GlfxPci]>> %TEMP%\dlgc_reg_clean.reg
@echo [-HKEY_LOCAL_MACHINE\SYSTEM\ControlSet002\Services\Gloaddrv]>> %TEMP%\dlgc_reg_clean.reg
@echo [-HKEY_LOCAL_MACHINE\SYSTEM\ControlSet002\Services\IMRService]>> %TEMP%\dlgc_reg_clean.reg
@echo [-HKEY_LOCAL_MACHINE\SYSTEM\ControlSet002\Services\IPMedia]>> %TEMP%\dlgc_reg_clean.reg
@echo [-HKEY_LOCAL_MACHINE\SYSTEM\ControlSet002\Services\NamingService]>> %TEMP%\dlgc_reg_clean.reg
@echo [-HKEY_LOCAL_MACHINE\SYSTEM\ControlSet002\Services\RtfDispatcher]>> %TEMP%\dlgc_reg_clean.reg
@echo [-HKEY_LOCAL_MACHINE\SYSTEM\ControlSet002\Services\Springware_temp]>> %TEMP%\dlgc_reg_clean.reg
@echo.>> %TEMP%\dlgc_reg_clean.reg
@echo.>> %TEMP%\dlgc_reg_clean.reg
@echo #####>> %TEMP%\dlgc_reg_clean.reg
@echo ##### Intel Dialogic SNMP Extension agents>> %TEMP%\dlgc_reg_clean.reg
@echo #####>> %TEMP%\dlgc_reg_clean.reg
@echo.>> %TEMP%\dlgc_reg_clean.reg
@echo # CurrentControlSet>> %TEMP%\dlgc_reg_clean.reg
@echo [HKEY_LOCAL_MACHINE\SYSTEM\CurrentControlSet\Services\SNMP\Parameters\ExtensionAgents]>> %TEMP%\dlgc_reg_clean.reg
@echo "DialogicPerformanceAgent" =->> %TEMP%\dlgc_reg_clean.reg
@echo "DialogicSnmpAgent" =->> %TEMP%\dlgc_reg_clean.reg
@echo "DLG_HWAGENT"=->> %TEMP%\dlgc_reg_clean.reg
@echo "DLG_PERFINFO"=->> %TEMP%\dlgc_reg_clean.reg
@echo "DLG_R4AGENT"=->> %TEMP%\dlgc_reg_clean.reg
@echo "DLG_ISDN"=->> %TEMP%\dlgc_reg_clean.reg
@echo "DLG_T1E1AGENT"=->> %TEMP%\dlgc_reg_clean.reg
@echo "DLG_DM3EXTPLAT"=->> %TEMP%\dlgc_reg_clean.reg
@echo.>> %TEMP%\dlgc_reg_clean.reg
@echo # ControlSet001>> %TEMP%\dlgc_reg_clean.reg
@echo [HKEY_LOCAL_MACHINE\SYSTEM\ControlSet001\Services\SNMP\Parameters\ExtensionAgents]>> %TEMP%\dlgc_reg_clean.reg
@echo "DialogicPerformanceAgent" =->> %TEMP%\dlgc_reg_clean.reg
@echo "DialogicSnmpAgent" =->> %TEMP%\dlgc_reg_clean.reg
@echo "DLG_HWAGENT"=->> %TEMP%\dlgc_reg_clean.reg
@echo "DLG_PERFINFO"=->> %TEMP%\dlgc_reg_clean.reg
@echo "DLG_R4AGENT"=->> %TEMP%\dlgc_reg_clean.reg
@echo "DLG_ISDN"=->> %TEMP%\dlgc_reg_clean.reg
@echo "DLG_T1E1AGENT"=->> %TEMP%\dlgc_reg_clean.reg
@echo "DLG_DM3EXTPLAT"=->> %TEMP%\dlgc_reg_clean.reg
@echo.>> %TEMP%\dlgc_reg_clean.reg
@echo # ControlSet002>> %TEMP%\dlgc_reg_clean.reg
@echo [HKEY_LOCAL_MACHINE\SYSTEM\ControlSet002\Services\SNMP\Parameters\ExtensionAgents]>> %TEMP%\dlgc_reg_clean.reg
@echo "DialogicPerformanceAgent" =->> %TEMP%\dlgc_reg_clean.reg
@echo "DialogicSnmpAgent" =->> %TEMP%\dlgc_reg_clean.reg
@echo "DLG_HWAGENT"=->> %TEMP%\dlgc_reg_clean.reg
@echo "DLG_PERFINFO"=->> %TEMP%\dlgc_reg_clean.reg
@echo "DLG_R4AGENT"=->> %TEMP%\dlgc_reg_clean.reg
@echo "DLG_ISDN"=->> %TEMP%\dlgc_reg_clean.reg
@echo "DLG_T1E1AGENT"=->> %TEMP%\dlgc_reg_clean.reg
@echo "DLG_DM3EXTPLAT"=->> %TEMP%\dlgc_reg_clean.reg
@echo.>> %TEMP%\dlgc_reg_clean.reg
@echo.>> %TEMP%\dlgc_reg_clean.reg
@echo #####>> %TEMP%\dlgc_reg_clean.reg
@echo ##### Legacy keys can't be deleted until security permissions are changed>> %TEMP%\dlgc_reg_clean.reg
@echo #####>> %TEMP%\dlgc_reg_clean.reg
@echo.>> %TEMP%\dlgc_reg_clean.reg
@echo # CurrentControlSet>> %TEMP%\dlgc_reg_clean.reg
@echo [-HKEY_LOCAL_MACHINE\SYSTEM\CurrentControlSet\Enum\Root\DIALOGIC_CP_FAX_DEVICES]>> %TEMP%\dlgc_reg_clean.reg
@echo [-HKEY_LOCAL_MACHINE\SYSTEM\CurrentControlSet\Enum\Root\LEGACY_ANMCHANNELFACTORYSERVER]>> %TEMP%\dlgc_reg_clean.reg
@echo [-HKEY_LOCAL_MACHINE\SYSTEM\CurrentControlSet\Enum\Root\LEGACY_ANMCHANNELSERVER]>> %TEMP%\dlgc_reg_clean.reg
@echo [-HKEY_LOCAL_MACHINE\SYSTEM\CurrentControlSet\Enum\Root\LEGACY_ANMLOGGERSERVER]>> %TEMP%\dlgc_reg_clean.reg
@echo [-HKEY_LOCAL_MACHINE\SYSTEM\CurrentControlSet\Enum\Root\LEGACY_ANMSUPPLIERSERVER]>> %TEMP%\dlgc_reg_clean.reg
@echo [-HKEY_LOCAL_MACHINE\SYSTEM\CurrentControlSet\Enum\Root\LEGACY_ANTDETECT]>> %TEMP%\dlgc_reg_clean.reg
@echo [-HKEY_LOCAL_MACHINE\SYSTEM\CurrentControlSet\Enum\Root\LEGACY_BOARDSERVER]>> %TEMP%\dlgc_reg_clean.reg
@echo [-HKEY_LOCAL_MACHINE\SYSTEM\CurrentControlSet\Enum\Root\LEGACY_BRGRES]>> %TEMP%\dlgc_reg_clean.reg
@echo [-HKEY_LOCAL_MACHINE\SYSTEM\CurrentControlSet\Enum\Root\LEGACY_CTBUSBROKER]>> %TEMP%\dlgc_reg_clean.reg
@echo [-HKEY_LOCAL_MACHINE\SYSTEM\CurrentControlSet\Enum\Root\LEGACY_DEBUGANGEL]>> %TEMP%\dlgc_reg_clean.reg
@echo [-HKEY_LOCAL_MACHINE\SYSTEM\CurrentControlSet\Enum\Root\LEGACY_DETECTORSPROJ]>> %TEMP%\dlgc_reg_clean.reg
@echo [-HKEY_LOCAL_MACHINE\SYSTEM\CurrentControlSet\Enum\Root\LEGACY_DIALOGIC]>> %TEMP%\dlgc_reg_clean.reg
@echo [-HKEY_LOCAL_MACHINE\SYSTEM\CurrentControlSet\Enum\Root\LEGACY_DLGCDCM]>> %TEMP%\dlgc_reg_clean.reg
@echo [-HKEY_LOCAL_MACHINE\SYSTEM\CurrentControlSet\Enum\Root\LEGACY_DLGCDEVICEMAPPER]>> %TEMP%\dlgc_reg_clean.reg
@echo [-HKEY_LOCAL_MACHINE\SYSTEM\CurrentControlSet\Enum\Root\LEGACY_DLGCMCD]>> %TEMP%\dlgc_reg_clean.reg
@echo [-HKEY_LOCAL_MACHINE\SYSTEM\CurrentControlSet\Enum\Root\LEGACY_DLGCMPD]>> %TEMP%\dlgc_reg_clean.reg
@echo [-HKEY_LOCAL_MACHINE\SYSTEM\CurrentControlSet\Enum\Root\LEGACY_DLGPNPOBSERVERSERVICE]>> %TEMP%\dlgc_reg_clean.reg
@echo [-HKEY_LOCAL_MACHINE\SYSTEM\CurrentControlSet\Enum\Root\LEGACY_DLGCSRAM]>> %TEMP%\dlgc_reg_clean.reg
@echo [-HKEY_LOCAL_MACHINE\SYSTEM\CurrentControlSet\Enum\Root\LEGACY_DLGCUPGRADE]>> %TEMP%\dlgc_reg_clean.reg
@echo [-HKEY_LOCAL_MACHINE\SYSTEM\CurrentControlSet\Enum\Root\LEGACY_DLGH323]>> %TEMP%\dlgc_reg_clean.reg
@echo [-HKEY_LOCAL_MACHINE\SYSTEM\CurrentControlSet\Enum\Root\LEGACY_DM3CONFIG]>> %TEMP%\dlgc_reg_clean.reg
@echo [-HKEY_LOCAL_MACHINE\SYSTEM\CurrentControlSet\Enum\Root\LEGACY_DM3INSIGHTDRV]>> %TEMP%\dlgc_reg_clean.reg
@echo [-HKEY_LOCAL_MACHINE\SYSTEM\CurrentControlSet\Enum\Root\LEGACY_EVENTSERVICE]>> %TEMP%\dlgc_reg_clean.reg
@echo [-HKEY_LOCAL_MACHINE\SYSTEM\CurrentControlSet\Enum\Root\LEGACY_GLFXISA]>> %TEMP%\dlgc_reg_clean.reg
@echo [-HKEY_LOCAL_MACHINE\SYSTEM\CurrentControlSet\Enum\Root\LEGACY_GLFXPCI]>> %TEMP%\dlgc_reg_clean.reg
@echo [-HKEY_LOCAL_MACHINE\SYSTEM\CurrentControlSet\Enum\Root\LEGACY_GLOADDRV]>> %TEMP%\dlgc_reg_clean.reg
@echo [-HKEY_LOCAL_MACHINE\SYSTEM\CurrentControlSet\Enum\Root\LEGACY_IMRSERVICE]>> %TEMP%\dlgc_reg_clean.reg
@echo [-HKEY_LOCAL_MACHINE\SYSTEM\CurrentControlSet\Enum\Root\LEGACY_NAMINGSERVICE]>> %TEMP%\dlgc_reg_clean.reg
@echo [-HKEY_LOCAL_MACHINE\SYSTEM\CurrentControlSet\Enum\Root\LEGACY_RTFDISPATCHER]>> %TEMP%\dlgc_reg_clean.reg
@echo.>> %TEMP%\dlgc_reg_clean.reg
@echo # ControlSet001>> %TEMP%\dlgc_reg_clean.reg
@echo [-HKEY_LOCAL_MACHINE\SYSTEM\ControlSet001\Enum\Root\DIALOGIC_CP_FAX_DEVICES]>> %TEMP%\dlgc_reg_clean.reg
@echo [-HKEY_LOCAL_MACHINE\SYSTEM\ControlSet001\Enum\Root\LEGACY_ANMCHANNELFACTORYSERVER]>> %TEMP%\dlgc_reg_clean.reg
@echo [-HKEY_LOCAL_MACHINE\SYSTEM\ControlSet001\Enum\Root\LEGACY_ANMCHANNELSERVER]>> %TEMP%\dlgc_reg_clean.reg
@echo [-HKEY_LOCAL_MACHINE\SYSTEM\ControlSet001\Enum\Root\LEGACY_ANMLOGGERSERVER]>> %TEMP%\dlgc_reg_clean.reg
@echo [-HKEY_LOCAL_MACHINE\SYSTEM\ControlSet001\Enum\Root\LEGACY_ANMSUPPLIERSERVER]>> %TEMP%\dlgc_reg_clean.reg
@echo [-HKEY_LOCAL_MACHINE\SYSTEM\ControlSet001\Enum\Root\LEGACY_ANTDETECT]>> %TEMP%\dlgc_reg_clean.reg
@echo [-HKEY_LOCAL_MACHINE\SYSTEM\ControlSet001\Enum\Root\LEGACY_BOARDSERVER]>> %TEMP%\dlgc_reg_clean.reg
@echo [-HKEY_LOCAL_MACHINE\SYSTEM\ControlSet001\Enum\Root\LEGACY_BRGRES]>> %TEMP%\dlgc_reg_clean.reg
@echo [-HKEY_LOCAL_MACHINE\SYSTEM\ControlSet001\Enum\Root\LEGACY_CTBUSBROKER]>> %TEMP%\dlgc_reg_clean.reg
@echo [-HKEY_LOCAL_MACHINE\SYSTEM\ControlSet001\Enum\Root\LEGACY_DEBUGANGEL]>> %TEMP%\dlgc_reg_clean.reg
@echo [-HKEY_LOCAL_MACHINE\SYSTEM\ControlSet001\Enum\Root\LEGACY_DETECTORSPROJ]>> %TEMP%\dlgc_reg_clean.reg
@echo [-HKEY_LOCAL_MACHINE\SYSTEM\ControlSet001\Enum\Root\LEGACY_DIALOGIC]>> %TEMP%\dlgc_reg_clean.reg
@echo [-HKEY_LOCAL_MACHINE\SYSTEM\ControlSet001\Enum\Root\LEGACY_DLGCDCM]>> %TEMP%\dlgc_reg_clean.reg
@echo [-HKEY_LOCAL_MACHINE\SYSTEM\ControlSet001\Enum\Root\LEGACY_DLGCDEVICEMAPPER]>> %TEMP%\dlgc_reg_clean.reg
@echo [-HKEY_LOCAL_MACHINE\SYSTEM\ControlSet001\Enum\Root\LEGACY_DLGCMCD]>> %TEMP%\dlgc_reg_clean.reg
@echo [-HKEY_LOCAL_MACHINE\SYSTEM\ControlSet001\Enum\Root\LEGACY_DLGCMPD]>> %TEMP%\dlgc_reg_clean.reg
@echo [-HKEY_LOCAL_MACHINE\SYSTEM\ControlSet001\Enum\Root\LEGACY_DLGPNPOBSERVERSERVICE]>> %TEMP%\dlgc_reg_clean.reg
@echo [-HKEY_LOCAL_MACHINE\SYSTEM\ControlSet001\Enum\Root\LEGACY_DLGCSRAM]>> %TEMP%\dlgc_reg_clean.reg
@echo [-HKEY_LOCAL_MACHINE\SYSTEM\ControlSet001\Enum\Root\LEGACY_DLGCUPGRADE]>> %TEMP%\dlgc_reg_clean.reg
@echo [-HKEY_LOCAL_MACHINE\SYSTEM\ControlSet001\Enum\Root\LEGACY_DLGH323]>> %TEMP%\dlgc_reg_clean.reg
@echo [-HKEY_LOCAL_MACHINE\SYSTEM\ControlSet001\Enum\Root\LEGACY_DM3CONFIG]>> %TEMP%\dlgc_reg_clean.reg
@echo [-HKEY_LOCAL_MACHINE\SYSTEM\ControlSet001\Enum\Root\LEGACY_DM3INSIGHTDRV]>> %TEMP%\dlgc_reg_clean.reg
@echo [-HKEY_LOCAL_MACHINE\SYSTEM\ControlSet001\Enum\Root\LEGACY_EVENTSERVICE]>> %TEMP%\dlgc_reg_clean.reg
@echo [-HKEY_LOCAL_MACHINE\SYSTEM\ControlSet001\Enum\Root\LEGACY_GLFXISA]>> %TEMP%\dlgc_reg_clean.reg
@echo [-HKEY_LOCAL_MACHINE\SYSTEM\ControlSet001\Enum\Root\LEGACY_GLFXPCI]>> %TEMP%\dlgc_reg_clean.reg
@echo [-HKEY_LOCAL_MACHINE\SYSTEM\ControlSet001\Enum\Root\LEGACY_GLOADDRV]>> %TEMP%\dlgc_reg_clean.reg
@echo [-HKEY_LOCAL_MACHINE\SYSTEM\ControlSet001\Enum\Root\LEGACY_IMRSERVICE]>> %TEMP%\dlgc_reg_clean.reg
@echo [-HKEY_LOCAL_MACHINE\SYSTEM\ControlSet001\Enum\Root\LEGACY_NAMINGSERVICE]>> %TEMP%\dlgc_reg_clean.reg
@echo [-HKEY_LOCAL_MACHINE\SYSTEM\ControlSet001\Enum\Root\LEGACY_RTFDISPATCHER]>> %TEMP%\dlgc_reg_clean.reg
@echo.>> %TEMP%\dlgc_reg_clean.reg
@echo # ControlSet002>> %TEMP%\dlgc_reg_clean.reg
@echo [-HKEY_LOCAL_MACHINE\SYSTEM\ControlSet002\Enum\Root\DIALOGIC_CP_FAX_DEVICES]>> %TEMP%\dlgc_reg_clean.reg
@echo [-HKEY_LOCAL_MACHINE\SYSTEM\ControlSet002\Enum\Root\LEGACY_ANMCHANNELFACTORY]>> %TEMP%\dlgc_reg_clean.reg
@echo [-HKEY_LOCAL_MACHINE\SYSTEM\ControlSet002\Enum\Root\LEGACY_ANMCHANNELFACTORYSERVER]>> %TEMP%\dlgc_reg_clean.reg
@echo [-HKEY_LOCAL_MACHINE\SYSTEM\ControlSet002\Enum\Root\LEGACY_ANMCHANNELSERVER]>> %TEMP%\dlgc_reg_clean.reg
@echo [-HKEY_LOCAL_MACHINE\SYSTEM\ControlSet002\Enum\Root\LEGACY_ANMLOGGERSERVER]>> %TEMP%\dlgc_reg_clean.reg
@echo [-HKEY_LOCAL_MACHINE\SYSTEM\ControlSet002\Enum\Root\LEGACY_ANMSUPPLIERSERVER]>> %TEMP%\dlgc_reg_clean.reg
@echo [-HKEY_LOCAL_MACHINE\SYSTEM\ControlSet002\Enum\Root\LEGACY_ANTDETECT]>> %TEMP%\dlgc_reg_clean.reg
@echo [-HKEY_LOCAL_MACHINE\SYSTEM\ControlSet002\Enum\Root\LEGACY_BOARDSERVER]>> %TEMP%\dlgc_reg_clean.reg
@echo [-HKEY_LOCAL_MACHINE\SYSTEM\ControlSet002\Enum\Root\LEGACY_BRGRES]>> %TEMP%\dlgc_reg_clean.reg
@echo [-HKEY_LOCAL_MACHINE\SYSTEM\ControlSet002\Enum\Root\LEGACY_CTBUSBROKER]>> %TEMP%\dlgc_reg_clean.reg
@echo [-HKEY_LOCAL_MACHINE\SYSTEM\ControlSet002\Enum\Root\LEGACY_DEBUGANGEL]>> %TEMP%\dlgc_reg_clean.reg
@echo [-HKEY_LOCAL_MACHINE\SYSTEM\ControlSet002\Enum\Root\LEGACY_DETECTORSPROJ]>> %TEMP%\dlgc_reg_clean.reg
@echo [-HKEY_LOCAL_MACHINE\SYSTEM\ControlSet002\Enum\Root\LEGACY_DIALOGIC]>> %TEMP%\dlgc_reg_clean.reg
@echo [-HKEY_LOCAL_MACHINE\SYSTEM\ControlSet002\Enum\Root\LEGACY_DLGCDCM]>> %TEMP%\dlgc_reg_clean.reg
@echo [-HKEY_LOCAL_MACHINE\SYSTEM\ControlSet002\Enum\Root\LEGACY_DLGCDEVICEMAPPER]>> %TEMP%\dlgc_reg_clean.reg
@echo [-HKEY_LOCAL_MACHINE\SYSTEM\ControlSet002\Enum\Root\LEGACY_DLGCMCD]>> %TEMP%\dlgc_reg_clean.reg
@echo [-HKEY_LOCAL_MACHINE\SYSTEM\ControlSet002\Enum\Root\LEGACY_DLGCMPD]>> %TEMP%\dlgc_reg_clean.reg
@echo [-HKEY_LOCAL_MACHINE\SYSTEM\ControlSet002\Enum\Root\LEGACY_DLGPNPOBSERVERSERVICE]>> %TEMP%\dlgc_reg_clean.reg
@echo [-HKEY_LOCAL_MACHINE\SYSTEM\ControlSet002\Enum\Root\LEGACY_DLGCSRAM]>> %TEMP%\dlgc_reg_clean.reg
@echo [-HKEY_LOCAL_MACHINE\SYSTEM\ControlSet002\Enum\Root\LEGACY_DLGCUPGRADE]>> %TEMP%\dlgc_reg_clean.reg
@echo [-HKEY_LOCAL_MACHINE\SYSTEM\ControlSet002\Enum\Root\LEGACY_DLGH323]>> %TEMP%\dlgc_reg_clean.reg
@echo [-HKEY_LOCAL_MACHINE\SYSTEM\ControlSet002\Enum\Root\LEGACY_DM3CONFIG]>> %TEMP%\dlgc_reg_clean.reg
@echo [-HKEY_LOCAL_MACHINE\SYSTEM\ControlSet002\Enum\Root\LEGACY_DM3INSIGHTDRV]>> %TEMP%\dlgc_reg_clean.reg
@echo [-HKEY_LOCAL_MACHINE\SYSTEM\ControlSet002\Enum\Root\LEGACY_EVENTSERVICE]>> %TEMP%\dlgc_reg_clean.reg
@echo [-HKEY_LOCAL_MACHINE\SYSTEM\ControlSet002\Enum\Root\LEGACY_GLFXISA]>> %TEMP%\dlgc_reg_clean.reg
@echo [-HKEY_LOCAL_MACHINE\SYSTEM\ControlSet002\Enum\Root\LEGACY_GLFXPCI]>> %TEMP%\dlgc_reg_clean.reg
@echo [-HKEY_LOCAL_MACHINE\SYSTEM\ControlSet002\Enum\Root\LEGACY_GLOADDRV]>> %TEMP%\dlgc_reg_clean.reg
@echo [-HKEY_LOCAL_MACHINE\SYSTEM\ControlSet002\Enum\Root\LEGACY_IMRSERVICE]>> %TEMP%\dlgc_reg_clean.reg
@echo [-HKEY_LOCAL_MACHINE\SYSTEM\ControlSet002\Enum\Root\LEGACY_NAMINGSERVICE]>> %TEMP%\dlgc_reg_clean.reg
@echo [-HKEY_LOCAL_MACHINE\SYSTEM\ControlSet002\Enum\Root\LEGACY_RTFDISPATCHER]>> %TEMP%\dlgc_reg_clean.reg
@echo.>> %TEMP%\dlgc_reg_clean.reg
@echo #####>> %TEMP%\dlgc_reg_clean.reg
@echo ##### ANM>> %TEMP%\dlgc_reg_clean.reg
@echo #####>> %TEMP%\dlgc_reg_clean.reg
@echo.>> %TEMP%\dlgc_reg_clean.reg
@echo [-HKEY_LOCAL_MACHINE\SOFTWARE\Classes\AppID\AnmChannelFactoryServer.EXE]>> %TEMP%\dlgc_reg_clean.reg
@echo [-HKEY_CLASSES_ROOT\AppID\AnmChannelFactoryServer.EXE]>> %TEMP%\dlgc_reg_clean.reg
@echo [-HKEY_LOCAL_MACHINE\SOFTWARE\Classes\AppID\AnmChannelServer.EXE]>> %TEMP%\dlgc_reg_clean.reg
@echo [-HKEY_CLASSES_ROOT\AppID\AnmChannelServer.EXE]>> %TEMP%\dlgc_reg_clean.reg
@echo [-HKEY_LOCAL_MACHINE\SOFTWARE\Classes\AppID\AnmLoggerServer.EXE]>> %TEMP%\dlgc_reg_clean.reg
@echo [-HKEY_CLASSES_ROOT\AppID\AnmLoggerServer.EXE]>> %TEMP%\dlgc_reg_clean.reg
@echo [-HKEY_LOCAL_MACHINE\SOFTWARE\Classes\AppID\AnmSupplierServer.EXE]>> %TEMP%\dlgc_reg_clean.reg
@echo [-HKEY_CLASSES_ROOT\AppID\AnmSupplierServer.EXE]>> %TEMP%\dlgc_reg_clean.reg
@echo.>> %TEMP%\dlgc_reg_clean.reg
@echo #####>> %TEMP%\dlgc_reg_clean.reg
@echo ##### DlgcS7Srv Service>> %TEMP%\dlgc_reg_clean.reg
@echo #####>> %TEMP%\dlgc_reg_clean.reg
@echo.>> %TEMP%\dlgc_reg_clean.reg
@echo [-HKEY_LOCAL_MACHINE\SOFTWARE\Classes\AppID\DlgcS7Srv.EXE]>> %TEMP%\dlgc_reg_clean.reg
@echo [-HKEY_CLASSES_ROOT\AppID\DlgcS7Srv.EXE]>> %TEMP%\dlgc_reg_clean.reg
@echo [-HKEY_LOCAL_MACHINE\SOFTWARE\Classes\AppID\{78D5DEE1-859B-11D2-BCEA-00AA00A0E423}]>> %TEMP%\dlgc_reg_clean.reg
@echo [-HKEY_CLASSES_ROOT\AppID\{78D5DEE1-859B-11D2-BCEA-00AA00A0E423}]>> %TEMP%\dlgc_reg_clean.reg
@echo [-HKEY_LOCAL_MACHINE\SOFTWARE\Classes\DlgcS7Srv.DlgcS7Config]>> %TEMP%\dlgc_reg_clean.reg
@echo [-HKEY_CLASSES_ROOT\DlgcS7Srv.DlgcS7Config]>> %TEMP%\dlgc_reg_clean.reg
@echo [-HKEY_LOCAL_MACHINE\SOFTWARE\Classes\DlgcS7Srv.DlgcS7Config.1]>> %TEMP%\dlgc_reg_clean.reg
@echo [-HKEY_CLASSES_ROOT\DlgcS7Srv.DlgcS7Config.1]>> %TEMP%\dlgc_reg_clean.reg
@echo [-HKEY_LOCAL_MACHINE\SOFTWARE\Classes\DlgcS7Srv.DlgcS7ProcSession]>> %TEMP%\dlgc_reg_clean.reg
@echo [-HKEY_CLASSES_ROOT\DlgcS7Srv.DlgcS7ProcSession]>> %TEMP%\dlgc_reg_clean.reg
@echo [-HKEY_LOCAL_MACHINE\SOFTWARE\Classes\DlgcS7Srv.DlgcS7ProcSession.1]>> %TEMP%\dlgc_reg_clean.reg
@echo [-HKEY_CLASSES_ROOT\DlgcS7Srv.DlgcS7ProcSession.1]>> %TEMP%\dlgc_reg_clean.reg
@echo.>> %TEMP%\dlgc_reg_clean.reg
@echo.>> %TEMP%\dlgc_reg_clean.reg
@echo #####>> %TEMP%\dlgc_reg_clean.reg
@echo #####	DCMObj>> %TEMP%\dlgc_reg_clean.reg
@echo #####>> %TEMP%\dlgc_reg_clean.reg
@echo [-HKEY_CLASSES_ROOT\AppID\{C463BA48-8A69-11D3-AE7A-00C04F9FED7F}]>> %TEMP%\dlgc_reg_clean.reg
@echo [-HKEY_CLASSES_ROOT\AppID\DCMObj.EXE]>> %TEMP%\dlgc_reg_clean.reg
@echo [-HKEY_CLASSES_ROOT\DCM.DCM]>> %TEMP%\dlgc_reg_clean.reg
@echo [-HKEY_CLASSES_ROOT\DCM.DCM.1]>> %TEMP%\dlgc_reg_clean.reg
@echo [-HKEY_CLASSES_ROOT\Dm3Detector.Dm3Detector]>> %TEMP%\dlgc_reg_clean.reg
@echo [-HKEY_CLASSES_ROOT\Dm3Detector.Dm3Detector.1]>> %TEMP%\dlgc_reg_clean.reg
@echo [-HKEY_CLASSES_ROOT\Interface\{F09F3850-BC92-11D3-B4A0-00104B2B2DCF}]>> %TEMP%\dlgc_reg_clean.reg
@echo.>> %TEMP%\dlgc_reg_clean.reg
@echo.>> %TEMP%\dlgc_reg_clean.reg
@echo #####>> %TEMP%\dlgc_reg_clean.reg
@echo #####	DetectorsProj>> %TEMP%\dlgc_reg_clean.reg
@echo #####>> %TEMP%\dlgc_reg_clean.reg
@echo.>> %TEMP%\dlgc_reg_clean.reg
@echo [-HKEY_LOCAL_MACHINE\SOFTWARE\Classes\AppID\DetectorsProj.EXE]>> %TEMP%\dlgc_reg_clean.reg
@echo [-HKEY_CLASSES_ROOT\AppID\DetectorsProj.EXE]>> %TEMP%\dlgc_reg_clean.reg
@echo [-HKEY_CLASSES_ROOT\AppID\{3AA32E53-1A02-11D4-AE27-00C04F35BF96}]>> %TEMP%\dlgc_reg_clean.reg
@echo.>> %TEMP%\dlgc_reg_clean.reg
@echo #####>> %TEMP%\dlgc_reg_clean.reg
@echo #####	INTERFACE CLASSES>> %TEMP%\dlgc_reg_clean.reg
@echo #####>> %TEMP%\dlgc_reg_clean.reg
@echo.>> %TEMP%\dlgc_reg_clean.reg
@echo # ILoggerServer>> %TEMP%\dlgc_reg_clean.reg
@echo [-HKEY_LOCAL_MACHINE\SOFTWARE\Classes\Interface\{1B0FE3BF-A2A7-11D3-ADF9-00C04F35BF96}]>> %TEMP%\dlgc_reg_clean.reg
@echo [-HKEY_CLASSES_ROOT\Interface\{1B0FE3BF-A2A7-11D3-ADF9-00C04F35BF96}]>> %TEMP%\dlgc_reg_clean.reg
@echo.>> %TEMP%\dlgc_reg_clean.reg
@echo # IAnmBaseMsg>> %TEMP%\dlgc_reg_clean.reg
@echo [-HKEY_LOCAL_MACHINE\SOFTWARE\Classes\Interface\{35DC75AD-6C3C-11D3-ADEE-00C04F35BF96}]>> %TEMP%\dlgc_reg_clean.reg
@echo [-HKEY_CLASSES_ROOT\Interface\{35DC75AD-6C3C-11D3-ADEE-00C04F35BF96}]>> %TEMP%\dlgc_reg_clean.reg
@echo.>> %TEMP%\dlgc_reg_clean.reg
@echo # IBaseDetector>> %TEMP%\dlgc_reg_clean.reg
@echo [-HKEY_LOCAL_MACHINE\SOFTWARE\Classes\Interface\{3AA32E5F-1A02-11D4-AE27-00C04F35BF96}]>> %TEMP%\dlgc_reg_clean.reg
@echo.>> %TEMP%\dlgc_reg_clean.reg
@echo # IDM3Detector>> %TEMP%\dlgc_reg_clean.reg
@echo [-HKEY_LOCAL_MACHINE\SOFTWARE\Classes\Interface\{3AA32E60-1A02-11D4-AE27-00C04F35BF96}]>> %TEMP%\dlgc_reg_clean.reg
@echo.>> %TEMP%\dlgc_reg_clean.reg
@echo # ILogMsg>> %TEMP%\dlgc_reg_clean.reg
@echo [-HKEY_LOCAL_MACHINE\SOFTWARE\Classes\Interface\{35DC75B0-6C3C-11D3-ADEE-00C04F35BF96}]>> %TEMP%\dlgc_reg_clean.reg
@echo [-HKEY_CLASSES_ROOT\Interface\{35DC75B0-6C3C-11D3-ADEE-00C04F35BF96}]>> %TEMP%\dlgc_reg_clean.reg
@echo.>> %TEMP%\dlgc_reg_clean.reg
@echo # IDlgcS7ProcSession>> %TEMP%\dlgc_reg_clean.reg
@echo [-HKEY_LOCAL_MACHINE\SOFTWARE\Classes\Interface\{78D5DEED-859B-11D2-BCEA-00AA00A0E423}]>> %TEMP%\dlgc_reg_clean.reg
@echo [-HKEY_CLASSES_ROOT\Interface\{78D5DEED-859B-11D2-BCEA-00AA00A0E423}]>> %TEMP%\dlgc_reg_clean.reg
@echo.>> %TEMP%\dlgc_reg_clean.reg
@echo # IDlgcS7HostCallBack>> %TEMP%\dlgc_reg_clean.reg
@echo [-HKEY_LOCAL_MACHINE\SOFTWARE\Classes\Interface\{78D5DEF0-859B-11D2-BCEA-00AA00A0E423}]>> %TEMP%\dlgc_reg_clean.reg
@echo [-HKEY_CLASSES_ROOT\Interface\{78D5DEF0-859B-11D2-BCEA-00AA00A0E423}]>> %TEMP%\dlgc_reg_clean.reg
@echo.>> %TEMP%\dlgc_reg_clean.reg
@echo # IDlgcS7HostSession>> %TEMP%\dlgc_reg_clean.reg
@echo [-HKEY_LOCAL_MACHINE\SOFTWARE\Classes\Interface\{78D5DEF2-859B-11D2-BCEA-00AA00A0E423}]>> %TEMP%\dlgc_reg_clean.reg
@echo [-HKEY_CLASSES_ROOT\Interface\{78D5DEF2-859B-11D2-BCEA-00AA00A0E423}]>> %TEMP%\dlgc_reg_clean.reg
@echo.>> %TEMP%\dlgc_reg_clean.reg
@echo # IDlgcS7TsAssigner>> %TEMP%\dlgc_reg_clean.reg
@echo [-HKEY_LOCAL_MACHINE\SOFTWARE\Classes\Interface\{78D5DEF4-859B-11D2-BCEA-00AA00A0E423}]>> %TEMP%\dlgc_reg_clean.reg
@echo [-HKEY_CLASSES_ROOT\Interface\{78D5DEF4-859B-11D2-BCEA-00AA00A0E423}]>> %TEMP%\dlgc_reg_clean.reg
@echo.>> %TEMP%\dlgc_reg_clean.reg
@echo # IDlgcS7TelephonyConfig>> %TEMP%\dlgc_reg_clean.reg
@echo [-HKEY_LOCAL_MACHINE\SOFTWARE\Classes\Interface\{78D5DEF6-859B-11D2-BCEA-00AA00A0E423}]>> %TEMP%\dlgc_reg_clean.reg
@echo [-HKEY_CLASSES_ROOT\Interface\{78D5DEF6-859B-11D2-BCEA-00AA00A0E423}]>> %TEMP%\dlgc_reg_clean.reg
@echo.>> %TEMP%\dlgc_reg_clean.reg
@echo # IPMACDetector>> %TEMP%\dlgc_reg_clean.reg
@echo [-HKEY_LOCAL_MACHINE\SOFTWARE\Classes\Interface\{A0A08F03-2C6E-47DC-8D4E-0102548C50CD}]>> %TEMP%\dlgc_reg_clean.reg
@echo.>> %TEMP%\dlgc_reg_clean.reg
@echo # IDCM>> %TEMP%\dlgc_reg_clean.reg
@echo [-HKEY_LOCAL_MACHINE\SOFTWARE\Classes\Interface\{C463BA56-8A69-11D3-AE7A-00C04F9FED7F}]>> %TEMP%\dlgc_reg_clean.reg
@echo [-HKEY_CLASSES_ROOT\Interface\{C463BA56-8A69-11D3-AE7A-00C04F9FED7F}]>> %TEMP%\dlgc_reg_clean.reg
@echo.>> %TEMP%\dlgc_reg_clean.reg
@echo # ISPWDetector>> %TEMP%\dlgc_reg_clean.reg
@echo [-HKEY_LOCAL_MACHINE\SOFTWARE\Classes\Interface\{C5F00682-1A03-11D4-AE27-00C04F35BF96}]>> %TEMP%\dlgc_reg_clean.reg
@echo.>> %TEMP%\dlgc_reg_clean.reg
@echo # IAnmChannelFactory>> %TEMP%\dlgc_reg_clean.reg
@echo [-HKEY_LOCAL_MACHINE\SOFTWARE\Classes\Interface\{F3D330CF-A2A1-11D3-ADF9-00C04F35BF96}]>> %TEMP%\dlgc_reg_clean.reg
@echo [-HKEY_CLASSES_ROOT\Interface\{F3D330CF-A2A1-11D3-ADF9-00C04F35BF96}]>> %TEMP%\dlgc_reg_clean.reg
@echo.>> %TEMP%\dlgc_reg_clean.reg
@echo # IAnmChannelServer>> %TEMP%\dlgc_reg_clean.reg
@echo [-HKEY_LOCAL_MACHINE\SOFTWARE\Classes\Interface\{6E131B4F-A2A9-11D3-ADF9-00C04F35BF96}]>> %TEMP%\dlgc_reg_clean.reg
@echo [-HKEY_CLASSES_ROOT\Interface\{6E131B4F-A2A9-11D3-ADF9-00C04F35BF96}]>> %TEMP%\dlgc_reg_clean.reg
@echo.>> %TEMP%\dlgc_reg_clean.reg
@echo # IConsumerEnumCO>> %TEMP%\dlgc_reg_clean.reg
@echo [-HKEY_LOCAL_MACHINE\SOFTWARE\Classes\Interface\{6E131B51-A2A9-11D3-ADF9-00C04F35BF96}]>> %TEMP%\dlgc_reg_clean.reg
@echo [-HKEY_CLASSES_ROOT\Interface\{6E131B51-A2A9-11D3-ADF9-00C04F35BF96}]>> %TEMP%\dlgc_reg_clean.reg
@echo.>> %TEMP%\dlgc_reg_clean.reg
@echo # IAnmSupplierServer>> %TEMP%\dlgc_reg_clean.reg
@echo [-HKEY_LOCAL_MACHINE\SOFTWARE\Classes\Interface\{6E131B5F-A2A9-11D3-ADF9-00C04F35BF96}]>> %TEMP%\dlgc_reg_clean.reg
@echo [-HKEY_CLASSES_ROOT\Interface\{6E131B5F-A2A9-11D3-ADF9-00C04F35BF96}]>> %TEMP%\dlgc_reg_clean.reg
@echo.>> %TEMP%\dlgc_reg_clean.reg
@echo # IAnmConsumerServer>> %TEMP%\dlgc_reg_clean.reg
@echo [-HKEY_LOCAL_MACHINE\SOFTWARE\Classes\Interface\{7773D9DE-6BAB-11D3-ADEE-00C04F35BF96}]>> %TEMP%\dlgc_reg_clean.reg
@echo [-HKEY_CLASSES_ROOT\Interface\{7773D9DE-6BAB-11D3-ADEE-00C04F35BF96}]>> %TEMP%\dlgc_reg_clean.reg
@echo.>> %TEMP%\dlgc_reg_clean.reg
@echo #####>> %TEMP%\dlgc_reg_clean.reg
@echo #####	Class Type Libraries>> %TEMP%\dlgc_reg_clean.reg
@echo #####>> %TEMP%\dlgc_reg_clean.reg
@echo.>> %TEMP%\dlgc_reg_clean.reg
@echo # AnmLoggerServer 1.0 Type Library>> %TEMP%\dlgc_reg_clean.reg
@echo [-HKEY_LOCAL_MACHINE\SOFTWARE\Classes\TypeLib\{1B0FE3B2-A2A7-11D3-ADF9-00C04F35BF96}]>> %TEMP%\dlgc_reg_clean.reg
@echo [-HKEY_CLASSES_ROOT\TypeLib\{1B0FE3B2-A2A7-11D3-ADF9-00C04F35BF96}]>> %TEMP%\dlgc_reg_clean.reg
@echo.>> %TEMP%\dlgc_reg_clean.reg
@echo # AnmMsgServer 1.0 Type Library>> %TEMP%\dlgc_reg_clean.reg
@echo [-HKEY_LOCAL_MACHINE\SOFTWARE\Classes\TypeLib\{35DC75A0-6C3C-11D3-ADEE-00C04F35BF96}]>> %TEMP%\dlgc_reg_clean.reg
@echo [-HKEY_CLASSES_ROOT\TypeLib\{35DC75A0-6C3C-11D3-ADEE-00C04F35BF96}]>> %TEMP%\dlgc_reg_clean.reg
@echo.>> %TEMP%\dlgc_reg_clean.reg
@echo # DetectorsProj 1.0 Type Library>> %TEMP%\dlgc_reg_clean.reg
@echo [-HKEY_LOCAL_MACHINE\SOFTWARE\Classes\TypeLib\{3AA32E52-1A02-11D4-AE27-00C04F35BF96}]>> %TEMP%\dlgc_reg_clean.reg
@echo [-HKEY_CLASSES_ROOT\TypeLib\{3AA32E52-1A02-11D4-AE27-00C04F35BF96}]>> %TEMP%\dlgc_reg_clean.reg
@echo.>> %TEMP%\dlgc_reg_clean.reg
@echo # AnmChannelServer 1.0 Type Library>> %TEMP%\dlgc_reg_clean.reg
@echo [-HKEY_LOCAL_MACHINE\SOFTWARE\Classes\TypeLib\{6E131B42-A2A9-11D3-ADF9-00C04F35BF96}]>> %TEMP%\dlgc_reg_clean.reg
@echo [-HKEY_CLASSES_ROOT\TypeLib\{6E131B42-A2A9-11D3-ADF9-00C04F35BF96}]>> %TEMP%\dlgc_reg_clean.reg
@echo.>> %TEMP%\dlgc_reg_clean.reg
@echo # AnmSupplierServer 1.0 Type Library>> %TEMP%\dlgc_reg_clean.reg
@echo [-HKEY_LOCAL_MACHINE\SOFTWARE\Classes\TypeLib\{6E131B52-A2A9-11D3-ADF9-00C04F35BF96}]>> %TEMP%\dlgc_reg_clean.reg
@echo [-HKEY_CLASSES_ROOT\TypeLib\{6E131B52-A2A9-11D3-ADF9-00C04F35BF96}]>> %TEMP%\dlgc_reg_clean.reg
@echo.>> %TEMP%\dlgc_reg_clean.reg
@echo # AnmConsumerServer 1.0 Type Library>> %TEMP%\dlgc_reg_clean.reg
@echo [-HKEY_LOCAL_MACHINE\SOFTWARE\Classes\TypeLib\{7773D9D1-6BAB-11D3-ADEE-00C04F35BF96}]>> %TEMP%\dlgc_reg_clean.reg
@echo [-HKEY_CLASSES_ROOT\TypeLib\{7773D9D1-6BAB-11D3-ADEE-00C04F35BF96}]>> %TEMP%\dlgc_reg_clean.reg
@echo.>> %TEMP%\dlgc_reg_clean.reg
@echo # DlgcS7Srv 1.0 Type Library>> %TEMP%\dlgc_reg_clean.reg
@echo [-HKEY_LOCAL_MACHINE\SOFTWARE\Classes\TypeLib\{78D5DEE0-859B-11D2-BCEA-00AA00A0E423}]>> %TEMP%\dlgc_reg_clean.reg
@echo [-HKEY_CLASSES_ROOT\TypeLib\{78D5DEE0-859B-11D2-BCEA-00AA00A0E423}]>> %TEMP%\dlgc_reg_clean.reg
@echo.>> %TEMP%\dlgc_reg_clean.reg
@echo # DCMObj 1.0 Type Library>> %TEMP%\dlgc_reg_clean.reg
@echo [-HKEY_LOCAL_MACHINE\SOFTWARE\Classes\TypeLib\{C463BA47-8A69-11D3-AE7A-00C04F9FED7F}]>> %TEMP%\dlgc_reg_clean.reg
@echo [-HKEY_CLASSES_ROOT\TypeLib\{C463BA47-8A69-11D3-AE7A-00C04F9FED7F}]>> %TEMP%\dlgc_reg_clean.reg
@echo.>> %TEMP%\dlgc_reg_clean.reg
@echo # AnmChannelFactoryServer 1.0 Type Library>> %TEMP%\dlgc_reg_clean.reg
@echo [-HKEY_LOCAL_MACHINE\SOFTWARE\Classes\TypeLib\{F3D330C2-A2A1-11D3-ADF9-00C04F35BF96}]>> %TEMP%\dlgc_reg_clean.reg
@echo [-HKEY_CLASSES_ROOT\TypeLib\{F3D330C2-A2A1-11D3-ADF9-00C04F35BF96}]>> %TEMP%\dlgc_reg_clean.reg
@echo.>> %TEMP%\dlgc_reg_clean.reg
@echo.>> %TEMP%\dlgc_reg_clean.reg
@echo #####>> %TEMP%\dlgc_reg_clean.reg
@echo ##### shared DLL's both in Dialogic directory and in system32>> %TEMP%\dlgc_reg_clean.reg
@echo #####>> %TEMP%\dlgc_reg_clean.reg
@echo.>> %TEMP%\dlgc_reg_clean.reg
@echo [HKEY_LOCAL_MACHINE\SOFTWARE\Microsoft\Windows\CurrentVersion\SharedDLLs]>> %TEMP%\dlgc_reg_clean.reg
@echo "%DIALOGICREGPATH%lib\\adl.dll"=->> %TEMP%\dlgc_reg_clean.reg
@echo "%DIALOGICREGPATH%lib\\AnmCommon.dll"=->> %TEMP%\dlgc_reg_clean.reg
@echo "%DIALOGICREGPATH%lib\\AnmConsumerServer.dll"=->> %TEMP%\dlgc_reg_clean.reg
@echo "%DIALOGICREGPATH%lib\\AnmErrorMsgs.dll"=->> %TEMP%\dlgc_reg_clean.reg
@echo "%DIALOGICREGPATH%lib\\AnmMsgServer.dll"=->> %TEMP%\dlgc_reg_clean.reg
@echo "%DIALOGICREGPATH%lib\\brintf.dll"=->> %TEMP%\dlgc_reg_clean.reg
@echo "%DIALOGICREGPATH%lib\\cheetah.dll"=->> %TEMP%\dlgc_reg_clean.reg
@echo "%DIALOGICREGPATH%lib\\CosEvent405.dll"=->> %TEMP%\dlgc_reg_clean.reg
@echo "%DIALOGICREGPATH%lib\\CosEvent405d.dll"=->> %TEMP%\dlgc_reg_clean.reg
@echo "%DIALOGICREGPATH%lib\\CosNaming405.dll"=->> %TEMP%\dlgc_reg_clean.reg
@echo "%DIALOGICREGPATH%lib\\CosNaming405d.dll"=->> %TEMP%\dlgc_reg_clean.reg
@echo "%DIALOGICREGPATH%lib\\CosProperty405.dll"=->> %TEMP%\dlgc_reg_clean.reg
@echo "%DIALOGICREGPATH%lib\\CosProperty405d.dll"=->> %TEMP%\dlgc_reg_clean.reg
@echo "%DIALOGICREGPATH%lib\\CosTime405.dll"=->> %TEMP%\dlgc_reg_clean.reg
@echo "%DIALOGICREGPATH%lib\\CosTime405d.dll"=->> %TEMP%\dlgc_reg_clean.reg
@echo "%DIALOGICREGPATH%lib\\Csapi32x.dll"=->> %TEMP%\dlgc_reg_clean.reg
@echo "%DIALOGICREGPATH%lib\\Csgui.dll"=->> %TEMP%\dlgc_reg_clean.reg
@echo "%DIALOGICREGPATH%lib\\ctbbface.dll"=->> %TEMP%\dlgc_reg_clean.reg
@echo "%DIALOGICREGPATH%lib\\d42ntf.dll"=->> %TEMP%\dlgc_reg_clean.reg
@echo "%DIALOGICREGPATH%bin\\DCMObj.exe"=->> %TEMP%\dlgc_reg_clean.reg
@echo "%DIALOGICREGPATH%lib\\DCMObjps.dll"=->> %TEMP%\dlgc_reg_clean.reg
@echo "%DIALOGICREGPATH%lib\\DlgcAtf.dll"=->> %TEMP%\dlgc_reg_clean.reg
@echo "%DIALOGICREGPATH%lib\\dlgcbric.dll"=->> %TEMP%\dlgc_reg_clean.reg
@echo "%DIALOGICREGPATH%lib\\dlgcdiag.dll"=->> %TEMP%\dlgc_reg_clean.reg
@echo "%DIALOGICREGPATH%lib\\DlgcDk.dll"=->> %TEMP%\dlgc_reg_clean.reg
@echo "%DIALOGICREGPATH%lib\\DlgcHost.dll"=->> %TEMP%\dlgc_reg_clean.reg
@echo "%DIALOGICREGPATH%lib\\dlgcOrbUtil.dll"=->> %TEMP%\dlgc_reg_clean.reg
@echo "%DIALOGICREGPATH%lib\\dlgcSNMP.dll"=->> %TEMP%\dlgc_reg_clean.reg
@echo "%DIALOGICREGPATH%lib\\dlgcSRAMPerf.dll"=->> %TEMP%\dlgc_reg_clean.reg
@echo "%DIALOGICREGPATH%lib\\dlgstopprotocol.dll"=->> %TEMP%\dlgc_reg_clean.reg
@echo "%DIALOGICREGPATH%lib\\dlgServiceResults.dll"=->> %TEMP%\dlgc_reg_clean.reg
@echo "%DIALOGICREGPATH%lib\\dlgwave.dll"=->> %TEMP%\dlgc_reg_clean.reg
@echo "%DIALOGICREGPATH%lib\\dlreg.dll"=->> %TEMP%\dlgc_reg_clean.reg
@echo "%DIALOGICREGPATH%lib\\dm3adl.dll"=->> %TEMP%\dlgc_reg_clean.reg
@echo "%DIALOGICREGPATH%lib\\dm3autodump.dll"=->> %TEMP%\dlgc_reg_clean.reg
@echo "%DIALOGICREGPATH%lib\\dm3be.dll"=->> %TEMP%\dlgc_reg_clean.reg
@echo "%DIALOGICREGPATH%lib\\dm3bsp.dll"=->> %TEMP%\dlgc_reg_clean.reg
@echo "%DIALOGICREGPATH%lib\\Dm3FaxLib.dll"=->> %TEMP%\dlgc_reg_clean.reg
@echo "%DIALOGICREGPATH%lib\\dm3fdsp.dll"=->> %TEMP%\dlgc_reg_clean.reg
@echo "%DIALOGICREGPATH%lib\\dm3leo.dll"=->> %TEMP%\dlgc_reg_clean.reg
@echo "%DIALOGICREGPATH%lib\\Dm3Odi.dll"=->> %TEMP%\dlgc_reg_clean.reg
@echo "%DIALOGICREGPATH%lib\\Dm3OdiUtility.dll"=->> %TEMP%\dlgc_reg_clean.reg
@echo "%DIALOGICREGPATH%lib\\Dm3Oti.dll"=->> %TEMP%\dlgc_reg_clean.reg
@echo "%DIALOGICREGPATH%lib\\dmr4cleo.dll"=->> %TEMP%\dlgc_reg_clean.reg
@echo "%DIALOGICREGPATH%lib\\dtintf.dll"=->> %TEMP%\dlgc_reg_clean.reg
@echo "%DIALOGICREGPATH%lib\\FruStatus.dll"=->> %TEMP%\dlgc_reg_clean.reg
@echo "%DIALOGICREGPATH%lib\\GENLOAD.dll"=->> %TEMP%\dlgc_reg_clean.reg
@echo "%DIALOGICREGPATH%lib\\HotDll.dll"=->> %TEMP%\dlgc_reg_clean.reg
@echo "%DIALOGICREGPATH%lib\\icudata.dll"=->> %TEMP%\dlgc_reg_clean.reg
@echo "%DIALOGICREGPATH%lib\\icuuc.dll"=->> %TEMP%\dlgc_reg_clean.reg
@echo "%DIALOGICREGPATH%lib\\idl405.dll"=->> %TEMP%\dlgc_reg_clean.reg
@echo "%DIALOGICREGPATH%lib\\idl405d.dll"=->> %TEMP%\dlgc_reg_clean.reg
@echo "%DIALOGICREGPATH%lib\\imr405.dll"=->> %TEMP%\dlgc_reg_clean.reg
@echo "%DIALOGICREGPATH%lib\\imr405d.dll"=->> %TEMP%\dlgc_reg_clean.reg
@echo "%DIALOGICREGPATH%lib\\isdnspan.dll"=->> %TEMP%\dlgc_reg_clean.reg
@echo "%DIALOGICREGPATH%lib\\jtc1014.dll"=->> %TEMP%\dlgc_reg_clean.reg
@echo "%DIALOGICREGPATH%lib\\jtc1014d.dll"=->> %TEMP%\dlgc_reg_clean.reg
@echo "%DIALOGICREGPATH%lib\\kvscscu.dll"=->> %TEMP%\dlgc_reg_clean.reg
@echo "%DIALOGICREGPATH%lib\\libcspdm3.dll"=->> %TEMP%\dlgc_reg_clean.reg
@echo "%DIALOGICREGPATH%lib\\libd300mt.dll"=->> %TEMP%\dlgc_reg_clean.reg
@echo "%DIALOGICREGPATH%lib\\libd42mt.dll"=->> %TEMP%\dlgc_reg_clean.reg
@echo "%DIALOGICREGPATH%lib\\libdevmap.dll"=->> %TEMP%\dlgc_reg_clean.reg
@echo "%DIALOGICREGPATH%lib\\libdevnamedoler.dll"=->> %TEMP%\dlgc_reg_clean.reg
@echo "%DIALOGICREGPATH%lib\\libdlgadminconsumerfw.dll"=->> %TEMP%\dlgc_reg_clean.reg
@echo "%DIALOGICREGPATH%lib\\libdlgadminsupplierfw.dll"=->> %TEMP%\dlgc_reg_clean.reg
@echo "%DIALOGICREGPATH%lib\\libdlgerrors.dll"=->> %TEMP%\dlgc_reg_clean.reg
@echo "%DIALOGICREGPATH%lib\\libdlgoslayer.dll"=->> %TEMP%\dlgc_reg_clean.reg
@echo "%DIALOGICREGPATH%lib\\libdlgpmacadmininterface.dll"=->> %TEMP%\dlgc_reg_clean.reg
@echo "%DIALOGICREGPATH%lib\\libdlgpmacbsp.dll"=->> %TEMP%\dlgc_reg_clean.reg
@echo "%DIALOGICREGPATH%lib\\libdlgpmacdetector.dll"=->> %TEMP%\dlgc_reg_clean.reg
@echo "%DIALOGICREGPATH%lib\\libdlgpmacfdsp.dll"=->> %TEMP%\dlgc_reg_clean.reg
@echo "%DIALOGICREGPATH%lib\\libdlgpmacinitializer.dll"=->> %TEMP%\dlgc_reg_clean.reg
@echo "%DIALOGICREGPATH%lib\\libdlgpmacparser.dll"=->> %TEMP%\dlgc_reg_clean.reg
@echo "%DIALOGICREGPATH%lib\\libdlgpmactimeslotassigner.dll"=->> %TEMP%\dlgc_reg_clean.reg
@echo "%DIALOGICREGPATH%lib\\libdlgpmacutilities.dll"=->> %TEMP%\dlgc_reg_clean.reg
@echo "%DIALOGICREGPATH%lib\\libdlgregister.dll"=->> %TEMP%\dlgc_reg_clean.reg
@echo "%DIALOGICREGPATH%lib\\libdlgsysloggerclient.dll"=->> %TEMP%\dlgc_reg_clean.reg
@echo "%DIALOGICREGPATH%lib\\libdm3cc.dll"=->> %TEMP%\dlgc_reg_clean.reg
@echo "%DIALOGICREGPATH%lib\\libdm3dcb.dll"=->> %TEMP%\dlgc_reg_clean.reg
@echo "%DIALOGICREGPATH%lib\\libdm3fax.dll"=->> %TEMP%\dlgc_reg_clean.reg
@echo "%DIALOGICREGPATH%lib\\libdm3msi.dll"=->> %TEMP%\dlgc_reg_clean.reg
@echo "%DIALOGICREGPATH%lib\\libdtidm3.dll"=->> %TEMP%\dlgc_reg_clean.reg
@echo "%DIALOGICREGPATH%lib\\libdtimt.dll"=->> %TEMP%\dlgc_reg_clean.reg
@echo "%DIALOGICREGPATH%lib\\libdxxdm3.dll"=->> %TEMP%\dlgc_reg_clean.reg
@echo "%DIALOGICREGPATH%lib\\LIBDXXMT.dll"=->> %TEMP%\dlgc_reg_clean.reg
@echo "%DIALOGICREGPATH%lib\\libecmt.dll"=->> %TEMP%\dlgc_reg_clean.reg
@echo "%DIALOGICREGPATH%lib\\libfaxmt.dll"=->> %TEMP%\dlgc_reg_clean.reg
@echo "%DIALOGICREGPATH%lib\\libgc.dll"=->> %TEMP%\dlgc_reg_clean.reg
@echo "%DIALOGICREGPATH%lib\\libgcan.dll"=->> %TEMP%\dlgc_reg_clean.reg
@echo "%DIALOGICREGPATH%lib\\libgch3r.dll"=->> %TEMP%\dlgc_reg_clean.reg
@echo "%DIALOGICREGPATH%lib\\libgcipm.dll"=->> %TEMP%\dlgc_reg_clean.reg
@echo "%DIALOGICREGPATH%lib\\libgcis.dll"=->> %TEMP%\dlgc_reg_clean.reg
@echo "%DIALOGICREGPATH%lib\\libgcr2.dll"=->> %TEMP%\dlgc_reg_clean.reg
@echo "%DIALOGICREGPATH%lib\\Libgcs7.dll"=->> %TEMP%\dlgc_reg_clean.reg
@echo "%DIALOGICREGPATH%lib\\Libipm.dll"=->> %TEMP%\dlgc_reg_clean.reg
@echo "%DIALOGICREGPATH%lib\\libipm_ipvsc.dll"=->> %TEMP%\dlgc_reg_clean.reg
@echo "%DIALOGICREGPATH%lib\\libipm_nettsc.dll"=->> %TEMP%\dlgc_reg_clean.reg
@echo "%DIALOGICREGPATH%lib\\libipm_pmac.dll"=->> %TEMP%\dlgc_reg_clean.reg
@echo "%DIALOGICREGPATH%lib\\libisdnr4.dll"=->> %TEMP%\dlgc_reg_clean.reg
@echo "%DIALOGICREGPATH%lib\\liblmode.dll"=->> %TEMP%\dlgc_reg_clean.reg
@echo "%DIALOGICREGPATH%lib\\libmsir4.dll"=->> %TEMP%\dlgc_reg_clean.reg
@echo "%DIALOGICREGPATH%lib\\libprds.dll"=->> %TEMP%\dlgc_reg_clean.reg
@echo "%DIALOGICREGPATH%lib\\libprtms.dll"=->> %TEMP%\dlgc_reg_clean.reg
@echo "%DIALOGICREGPATH%lib\\librtfmt.dll"=->> %TEMP%\dlgc_reg_clean.reg
@echo "%DIALOGICREGPATH%lib\\libsigal.dll"=->> %TEMP%\dlgc_reg_clean.reg
@echo "%DIALOGICREGPATH%lib\\libsipsigal.dll"=->> %TEMP%\dlgc_reg_clean.reg
@echo "%DIALOGICREGPATH%lib\\libsrlmt.dll"=->> %TEMP%\dlgc_reg_clean.reg
@echo "%DIALOGICREGPATH%lib\\Lmode.dll"=->> %TEMP%\dlgc_reg_clean.reg
@echo "%DIALOGICREGPATH%lib\\mercconfig.dll"=->> %TEMP%\dlgc_reg_clean.reg
@echo "%DIALOGICREGPATH%lib\\mercperf.dll"=->> %TEMP%\dlgc_reg_clean.reg
@echo "%DIALOGICREGPATH%lib\\mnti.dll"=->> %TEMP%\dlgc_reg_clean.reg
@echo "%DIALOGICREGPATH%lib\\msintf.dll"=->> %TEMP%\dlgc_reg_clean.reg
@echo "%DIALOGICREGPATH%lib\\NCMAhw.dll"=->> %TEMP%\dlgc_reg_clean.reg
@echo "%DIALOGICREGPATH%lib\\NCMApi.dll"=->> %TEMP%\dlgc_reg_clean.reg
@echo "%DIALOGICREGPATH%lib\\NCMCconf.dll"=->> %TEMP%\dlgc_reg_clean.reg
@echo "%DIALOGICREGPATH%lib\\NCMData.dll"=->> %TEMP%\dlgc_reg_clean.reg
@echo "%DIALOGICREGPATH%lib\\NCMProp.dll"=->> %TEMP%\dlgc_reg_clean.reg
@echo "%DIALOGICREGPATH%lib\\ndi.dll"=->> %TEMP%\dlgc_reg_clean.reg
@echo "%DIALOGICREGPATH%lib\\ob405.dll"=->> %TEMP%\dlgc_reg_clean.reg
@echo "%DIALOGICREGPATH%lib\\ob405d.dll"=->> %TEMP%\dlgc_reg_clean.reg
@echo "%DIALOGICREGPATH%lib\\OBBiDir405.dll"=->> %TEMP%\dlgc_reg_clean.reg
@echo "%DIALOGICREGPATH%lib\\OBBiDir405d.dll"=->> %TEMP%\dlgc_reg_clean.reg
@echo "%DIALOGICREGPATH%lib\\OBEvent405.dll"=->> %TEMP%\dlgc_reg_clean.reg
@echo "%DIALOGICREGPATH%lib\\OBEvent405d.dll"=->> %TEMP%\dlgc_reg_clean.reg
@echo "%DIALOGICREGPATH%lib\\OBEventService405.dll"=->> %TEMP%\dlgc_reg_clean.reg
@echo "%DIALOGICREGPATH%lib\\OBEventService405d.dll"=->> %TEMP%\dlgc_reg_clean.reg
@echo "%DIALOGICREGPATH%lib\\OBNaming405.dll"=->> %TEMP%\dlgc_reg_clean.reg
@echo "%DIALOGICREGPATH%lib\\OBNaming405d.dll"=->> %TEMP%\dlgc_reg_clean.reg
@echo "%DIALOGICREGPATH%lib\\OBNamingService405.dll"=->> %TEMP%\dlgc_reg_clean.reg
@echo "%DIALOGICREGPATH%lib\\OBNamingService405d.dll"=->> %TEMP%\dlgc_reg_clean.reg
@echo "%DIALOGICREGPATH%lib\\PBXpert.dll"=->> %TEMP%\dlgc_reg_clean.reg
@echo "%DIALOGICREGPATH%lib\\PBXpertWizard.dll"=->> %TEMP%\dlgc_reg_clean.reg
@echo "%DIALOGICREGPATH%lib\\pdi.dll"=->> %TEMP%\dlgc_reg_clean.reg
@echo "%DIALOGICREGPATH%lib\\pdkrt.dll"=->> %TEMP%\dlgc_reg_clean.reg
@echo "%DIALOGICREGPATH%lib\\pmac_transport.dll"=->> %TEMP%\dlgc_reg_clean.reg
@echo "%DIALOGICREGPATH%lib\\pmacadl.dll"=->> %TEMP%\dlgc_reg_clean.reg
@echo "%DIALOGICREGPATH%lib\\pnpapi.dll"=->> %TEMP%\dlgc_reg_clean.reg
@echo "%DIALOGICREGPATH%lib\\prtmsspan.dll"=->> %TEMP%\dlgc_reg_clean.reg
@echo "%DIALOGICREGPATH%lib\\r4bsp.dll"=->> %TEMP%\dlgc_reg_clean.reg
@echo "%DIALOGICREGPATH%lib\\RNCMapi.dll"=->> %TEMP%\dlgc_reg_clean.reg
@echo "%DIALOGICREGPATH%lib\\rv32h323.dll"=->> %TEMP%\dlgc_reg_clean.reg
@echo "%DIALOGICREGPATH%lib\\rv32rtp.dll"=->> %TEMP%\dlgc_reg_clean.reg
@echo "%DIALOGICREGPATH%lib\\rv32core.dll"=->> %TEMP%\dlgc_reg_clean.reg
@echo "%DIALOGICREGPATH%lib\\rv32sdp.dll"=->> %TEMP%\dlgc_reg_clean.reg
@echo "%DIALOGICREGPATH%lib\\rv32sip.dll"=->> %TEMP%\dlgc_reg_clean.reg
@echo "%DIALOGICREGPATH%lib\\S7Cfg.dll"=->> %TEMP%\dlgc_reg_clean.reg
@echo "%DIALOGICREGPATH%lib\\SCEventMsg.dll"=->> %TEMP%\dlgc_reg_clean.reg
@echo "%DIALOGICREGPATH%lib\\sdntf.dll"=->> %TEMP%\dlgc_reg_clean.reg
@echo "%DIALOGICREGPATH%lib\\SoftFaxRM.dll"=->> %TEMP%\dlgc_reg_clean.reg
@echo "%DIALOGICREGPATH%lib\\sramperf.dll"=->> %TEMP%\dlgc_reg_clean.reg
@echo "%DIALOGICREGPATH%lib\\swadl.dll"=->> %TEMP%\dlgc_reg_clean.reg
@echo "%DIALOGICREGPATH%lib\\swfdsp.dll"=->> %TEMP%\dlgc_reg_clean.reg
@echo "%DIALOGICREGPATH%lib\\syntellect.dll"=->> %TEMP%\dlgc_reg_clean.reg
@echo "%DIALOGICREGPATH%lib\\tascscu.dll"=->> %TEMP%\dlgc_reg_clean.reg
@echo "%DIALOGICREGPATH%lib\\TCUtil.dll"=->> %TEMP%\dlgc_reg_clean.reg
@echo "%DIALOGICREGPATH%lib\\ThirdPartyBsp.dll"=->> %TEMP%\dlgc_reg_clean.reg
@echo "%DIALOGICREGPATH%lib\\thirdpartydetector.dll"=->> %TEMP%\dlgc_reg_clean.reg
@echo "%DIALOGICREGPATH%lib\\vfxntf.dll"=->> %TEMP%\dlgc_reg_clean.reg
@echo "%DIALOGICREGPATH%lib\\voxspan.dll"=->> %TEMP%\dlgc_reg_clean.reg
@echo "%DIALOGICREGPATH%lib\\xerces-c_1_1.dll"=->> %TEMP%\dlgc_reg_clean.reg
@echo "%WINSYSREGPATH%adl.dll"=->> %TEMP%\dlgc_reg_clean.reg
@echo "%WINSYSREGPATH%AnmCommon.dll"=->> %TEMP%\dlgc_reg_clean.reg
@echo "%WINSYSREGPATH%AnmConsumerServer.dll"=->> %TEMP%\dlgc_reg_clean.reg
@echo "%WINSYSREGPATH%AnmErrorMsgs.dll"=->> %TEMP%\dlgc_reg_clean.reg
@echo "%WINSYSREGPATH%AnmMsgServer.dll"=->> %TEMP%\dlgc_reg_clean.reg
@echo "%WINSYSREGPATH%brintf.dll"=->> %TEMP%\dlgc_reg_clean.reg
@echo "%WINSYSREGPATH%cheetah.dll"=->> %TEMP%\dlgc_reg_clean.reg
@echo "%WINSYSREGPATH%CosEvent405.dll"=->> %TEMP%\dlgc_reg_clean.reg
@echo "%WINSYSREGPATH%CosEvent405d.dll"=->> %TEMP%\dlgc_reg_clean.reg
@echo "%WINSYSREGPATH%CosNaming405.dll"=->> %TEMP%\dlgc_reg_clean.reg
@echo "%WINSYSREGPATH%CosNaming405d.dll"=->> %TEMP%\dlgc_reg_clean.reg
@echo "%WINSYSREGPATH%CosProperty405.dll"=->> %TEMP%\dlgc_reg_clean.reg
@echo "%WINSYSREGPATH%CosProperty405d.dll"=->> %TEMP%\dlgc_reg_clean.reg
@echo "%WINSYSREGPATH%CosTime405.dll"=->> %TEMP%\dlgc_reg_clean.reg
@echo "%WINSYSREGPATH%CosTime405d.dll"=->> %TEMP%\dlgc_reg_clean.reg
@echo "%WINSYSREGPATH%Csapi32x.dll"=->> %TEMP%\dlgc_reg_clean.reg
@echo "%WINSYSREGPATH%Csgui.dll"=->> %TEMP%\dlgc_reg_clean.reg
@echo "%WINSYSREGPATH%ctbbface.dll"=->> %TEMP%\dlgc_reg_clean.reg
@echo "%WINSYSREGPATH%d42ntf.dll"=->> %TEMP%\dlgc_reg_clean.reg
@echo "%WINSYSREGPATH%DCMObjps.dll"=->> %TEMP%\dlgc_reg_clean.reg
@echo "%WINSYSREGPATH%DlgcAtf.dll"=->> %TEMP%\dlgc_reg_clean.reg
@echo "%WINSYSREGPATH%dlgcbric.dll"=->> %TEMP%\dlgc_reg_clean.reg
@echo "%WINSYSREGPATH%dlgcdiag.dll"=->> %TEMP%\dlgc_reg_clean.reg
@echo "%WINSYSREGPATH%DlgcDk.dll"=->> %TEMP%\dlgc_reg_clean.reg
@echo "%WINSYSREGPATH%DlgcHost.dll"=->> %TEMP%\dlgc_reg_clean.reg
@echo "%WINSYSREGPATH%dlgcOrbUtil.dll"=->> %TEMP%\dlgc_reg_clean.reg
@echo "%WINSYSREGPATH%dlgcSNMP.dll"=->> %TEMP%\dlgc_reg_clean.reg
@echo "%WINSYSREGPATH%dlgcSRAMPerf.dll"=->> %TEMP%\dlgc_reg_clean.reg
@echo "%WINSYSREGPATH%dlgcstopprotocol.dll"=->> %TEMP%\dlgc_reg_clean.reg
@echo "%WINSYSREGPATH%dlgServiceResults.dll"=->> %TEMP%\dlgc_reg_clean.reg
@echo "%WINSYSREGPATH%dlgwave.dll"=->> %TEMP%\dlgc_reg_clean.reg
@echo "%WINSYSREGPATH%dlreg.dll"=->> %TEMP%\dlgc_reg_clean.reg
@echo "%WINSYSREGPATH%dm3adl.dll"=->> %TEMP%\dlgc_reg_clean.reg
@echo "%WINSYSREGPATH%dm3autodump.dll"=->> %TEMP%\dlgc_reg_clean.reg
@echo "%WINSYSREGPATH%dm3be.dll"=->> %TEMP%\dlgc_reg_clean.reg
@echo "%WINSYSREGPATH%dm3bsp.dll"=->> %TEMP%\dlgc_reg_clean.reg
@echo "%WINSYSREGPATH%Dm3FaxLib.dll"=->> %TEMP%\dlgc_reg_clean.reg
@echo "%WINSYSREGPATH%dm3fdsp.dll"=->> %TEMP%\dlgc_reg_clean.reg
@echo "%WINSYSREGPATH%dm3leo.dll"=->> %TEMP%\dlgc_reg_clean.reg
@echo "%WINSYSREGPATH%Dm3Odi.dll"=->> %TEMP%\dlgc_reg_clean.reg
@echo "%WINSYSREGPATH%Dm3OdiUtility.dll"=->> %TEMP%\dlgc_reg_clean.reg
@echo "%WINSYSREGPATH%Dm3Oti.dll"=->> %TEMP%\dlgc_reg_clean.reg
@echo "%WINSYSREGPATH%Dmr4cleo.dll"=->> %TEMP%\dlgc_reg_clean.reg
@echo "%WINSYSREGPATH%dtintf.dll"=->> %TEMP%\dlgc_reg_clean.reg
@echo "%WINSYSREGPATH%FruStatus.dll"=->> %TEMP%\dlgc_reg_clean.reg
@echo "%WINSYSREGPATH%GENLOAD.dll"=->> %TEMP%\dlgc_reg_clean.reg
@echo "%WINSYSREGPATH%HotDll.dll"=->> %TEMP%\dlgc_reg_clean.reg
@echo "%WINSYSREGPATH%icudata.dll"=->> %TEMP%\dlgc_reg_clean.reg
@echo "%WINSYSREGPATH%icuuc.dll"=->> %TEMP%\dlgc_reg_clean.reg
@echo "%WINSYSREGPATH%idl405.dll"=->> %TEMP%\dlgc_reg_clean.reg
@echo "%WINSYSREGPATH%idl405d.dll"=->> %TEMP%\dlgc_reg_clean.reg
@echo "%WINSYSREGPATH%imr405.dll"=->> %TEMP%\dlgc_reg_clean.reg
@echo "%WINSYSREGPATH%imr405d.dll"=->> %TEMP%\dlgc_reg_clean.reg
@echo "%WINSYSREGPATH%isdnspan.dll"=->> %TEMP%\dlgc_reg_clean.reg
@echo "%WINSYSREGPATH%jtc1014.dll"=->> %TEMP%\dlgc_reg_clean.reg
@echo "%WINSYSREGPATH%jtc1014d.dll"=->> %TEMP%\dlgc_reg_clean.reg
@echo "%WINSYSREGPATH%kvscscu.dll"=->> %TEMP%\dlgc_reg_clean.reg
@echo "%WINSYSREGPATH%libcspdm3.dll"=->> %TEMP%\dlgc_reg_clean.reg
@echo "%WINSYSREGPATH%libd300mt.dll"=->> %TEMP%\dlgc_reg_clean.reg
@echo "%WINSYSREGPATH%libd42mt.dll"=->> %TEMP%\dlgc_reg_clean.reg
@echo "%WINSYSREGPATH%libdevmap.dll"=->> %TEMP%\dlgc_reg_clean.reg
@echo "%WINSYSREGPATH%libdevnamedoler.dll"=->> %TEMP%\dlgc_reg_clean.reg
@echo "%WINSYSREGPATH%libdlgadminconsumerfw.dll"=->> %TEMP%\dlgc_reg_clean.reg
@echo "%WINSYSREGPATH%libdlgadminsupplierfw.dll"=->> %TEMP%\dlgc_reg_clean.reg
@echo "%WINSYSREGPATH%libdlgerrors.dll"=->> %TEMP%\dlgc_reg_clean.reg
@echo "%WINSYSREGPATH%libdlgoslayer.dll"=->> %TEMP%\dlgc_reg_clean.reg
@echo "%WINSYSREGPATH%libdlgpmacadmininterface.dll"=->> %TEMP%\dlgc_reg_clean.reg
@echo "%WINSYSREGPATH%libdlgpmacbsp.dll"=->> %TEMP%\dlgc_reg_clean.reg
@echo "%WINSYSREGPATH%libdlgpmacdetector.dll"=->> %TEMP%\dlgc_reg_clean.reg
@echo "%WINSYSREGPATH%libdlgpmacfdsp.dll"=->> %TEMP%\dlgc_reg_clean.reg
@echo "%WINSYSREGPATH%libdlgpmacinitializer.dll"=->> %TEMP%\dlgc_reg_clean.reg
@echo "%WINSYSREGPATH%libdlgpmacparser.dll"=->> %TEMP%\dlgc_reg_clean.reg
@echo "%WINSYSREGPATH%libdlgpmactimeslotassigner.dll"=->> %TEMP%\dlgc_reg_clean.reg
@echo "%WINSYSREGPATH%libdlgpmacutilities.dll"=->> %TEMP%\dlgc_reg_clean.reg
@echo "%WINSYSREGPATH%libdlgregister.dll"=->> %TEMP%\dlgc_reg_clean.reg
@echo "%WINSYSREGPATH%libdlgsysloggerclient.dll"=->> %TEMP%\dlgc_reg_clean.reg
@echo "%WINSYSREGPATH%libdm3cc.dll"=->> %TEMP%\dlgc_reg_clean.reg
@echo "%WINSYSREGPATH%libdm3dcb.dll"=->> %TEMP%\dlgc_reg_clean.reg
@echo "%WINSYSREGPATH%libdm3fax.dll"=->> %TEMP%\dlgc_reg_clean.reg
@echo "%WINSYSREGPATH%libdm3msi.dll"=->> %TEMP%\dlgc_reg_clean.reg
@echo "%WINSYSREGPATH%libdtidm3.dll"=->> %TEMP%\dlgc_reg_clean.reg
@echo "%WINSYSREGPATH%libdtimt.dll"=->> %TEMP%\dlgc_reg_clean.reg
@echo "%WINSYSREGPATH%libdxxdm3.dll"=->> %TEMP%\dlgc_reg_clean.reg
@echo "%WINSYSREGPATH%LIBDXXMT.dll"=->> %TEMP%\dlgc_reg_clean.reg
@echo "%WINSYSREGPATH%libecmt.dll"=->> %TEMP%\dlgc_reg_clean.reg
@echo "%WINSYSREGPATH%libfaxmt.dll"=->> %TEMP%\dlgc_reg_clean.reg
@echo "%WINSYSREGPATH%libgc.dll"=->> %TEMP%\dlgc_reg_clean.reg
@echo "%WINSYSREGPATH%libgcan.dll"=->> %TEMP%\dlgc_reg_clean.reg
@echo "%WINSYSREGPATH%libgch3r.dll"=->> %TEMP%\dlgc_reg_clean.reg
@echo "%WINSYSREGPATH%libgcipm.dll"=->> %TEMP%\dlgc_reg_clean.reg
@echo "%WINSYSREGPATH%libgcis.dll"=->> %TEMP%\dlgc_reg_clean.reg
@echo "%WINSYSREGPATH%libgcr2.dll"=->> %TEMP%\dlgc_reg_clean.reg
@echo "%WINSYSREGPATH%Libgcs7.dll"=->> %TEMP%\dlgc_reg_clean.reg
@echo "%WINSYSREGPATH%Libipm.dll"=->> %TEMP%\dlgc_reg_clean.reg
@echo "%WINSYSREGPATH%libipm_ipvsc.dll"=->> %TEMP%\dlgc_reg_clean.reg
@echo "%WINSYSREGPATH%libipm_nettsc.dll"=->> %TEMP%\dlgc_reg_clean.reg
@echo "%WINSYSREGPATH%libipm_pmac.dll"=->> %TEMP%\dlgc_reg_clean.reg
@echo "%WINSYSREGPATH%libisdnr4.dll"=->> %TEMP%\dlgc_reg_clean.reg
@echo "%WINSYSREGPATH%liblmode.dll"=->> %TEMP%\dlgc_reg_clean.reg
@echo "%WINSYSREGPATH%libmsir4.dll"=->> %TEMP%\dlgc_reg_clean.reg
@echo "%WINSYSREGPATH%libprds.dll"=->> %TEMP%\dlgc_reg_clean.reg
@echo "%WINSYSREGPATH%libprtms.dll"=->> %TEMP%\dlgc_reg_clean.reg
@echo "%WINSYSREGPATH%librtfmt.dll"=->> %TEMP%\dlgc_reg_clean.reg
@echo "%WINSYSREGPATH%libsigal.dll"=->> %TEMP%\dlgc_reg_clean.reg
@echo "%WINSYSREGPATH%libsipsigal.dll"=->> %TEMP%\dlgc_reg_clean.reg
@echo "%WINSYSREGPATH%libsrlmt.dll"=->> %TEMP%\dlgc_reg_clean.reg
@echo "%WINSYSREGPATH%Lmode.dll"=->> %TEMP%\dlgc_reg_clean.reg
@echo "%WINSYSREGPATH%mercconfig.dll"=->> %TEMP%\dlgc_reg_clean.reg
@echo "%WINSYSREGPATH%mercperf.dll"=->> %TEMP%\dlgc_reg_clean.reg
@echo "%WINSYSREGPATH%mnti.dll"=->> %TEMP%\dlgc_reg_clean.reg
@echo "%WINSYSREGPATH%msintf.dll"=->> %TEMP%\dlgc_reg_clean.reg
@echo "%WINSYSREGPATH%NCMAhw.dll"=->> %TEMP%\dlgc_reg_clean.reg
@echo "%WINSYSREGPATH%NCMApi.dll"=->> %TEMP%\dlgc_reg_clean.reg
@echo "%WINSYSREGPATH%NCMCconf.dll"=->> %TEMP%\dlgc_reg_clean.reg
@echo "%WINSYSREGPATH%NCMData.dll"=->> %TEMP%\dlgc_reg_clean.reg
@echo "%WINSYSREGPATH%NCMProp.dll"=->> %TEMP%\dlgc_reg_clean.reg
@echo "%WINSYSREGPATH%ndi.dll"=->> %TEMP%\dlgc_reg_clean.reg
@echo "%WINSYSREGPATH%ob405.dll"=->> %TEMP%\dlgc_reg_clean.reg
@echo "%WINSYSREGPATH%ob405d.dll"=->> %TEMP%\dlgc_reg_clean.reg
@echo "%WINSYSREGPATH%OBBiDir405.dll"=->> %TEMP%\dlgc_reg_clean.reg
@echo "%WINSYSREGPATH%OBBiDir405d.dll"=->> %TEMP%\dlgc_reg_clean.reg
@echo "%WINSYSREGPATH%OBEvent405.dll"=->> %TEMP%\dlgc_reg_clean.reg
@echo "%WINSYSREGPATH%OBEvent405d.dll"=->> %TEMP%\dlgc_reg_clean.reg
@echo "%WINSYSREGPATH%OBEventService405.dll"=->> %TEMP%\dlgc_reg_clean.reg
@echo "%WINSYSREGPATH%OBEventService405d.dll"=->> %TEMP%\dlgc_reg_clean.reg
@echo "%WINSYSREGPATH%OBNaming405.dll"=->> %TEMP%\dlgc_reg_clean.reg
@echo "%WINSYSREGPATH%OBNaming405d.dll"=->> %TEMP%\dlgc_reg_clean.reg
@echo "%WINSYSREGPATH%OBNamingService405.dll"=->> %TEMP%\dlgc_reg_clean.reg
@echo "%WINSYSREGPATH%OBNamingService405d.dll"=->> %TEMP%\dlgc_reg_clean.reg
@echo "%WINSYSREGPATH%PBXpert.dll"=->> %TEMP%\dlgc_reg_clean.reg
@echo "%WINSYSREGPATH%PBXpertWizard.dll"=->> %TEMP%\dlgc_reg_clean.reg
@echo "%WINSYSREGPATH%pdi.dll"=->> %TEMP%\dlgc_reg_clean.reg
@echo "%WINSYSREGPATH%pdkrt.dll"=->> %TEMP%\dlgc_reg_clean.reg
@echo "%WINSYSREGPATH%pmac_transport.dll"=->> %TEMP%\dlgc_reg_clean.reg
@echo "%WINSYSREGPATH%pmacadl.dll"=->> %TEMP%\dlgc_reg_clean.reg
@echo "%WINSYSREGPATH%pnpapi.dll"=->> %TEMP%\dlgc_reg_clean.reg
@echo "%WINSYSREGPATH%prtmsspan.dll"=->> %TEMP%\dlgc_reg_clean.reg
@echo "%WINSYSREGPATH%r4bsp.dll"=->> %TEMP%\dlgc_reg_clean.reg
@echo "%WINSYSREGPATH%RNCMapi.dll"=->> %TEMP%\dlgc_reg_clean.reg
@echo "%WINSYSREGPATH%rv32h323.dll"=->> %TEMP%\dlgc_reg_clean.reg
@echo "%WINSYSREGPATH%rv32rtp.dll"=->> %TEMP%\dlgc_reg_clean.reg
@echo "%WINSYSREGPATH%rvcore.dll"=->> %TEMP%\dlgc_reg_clean.reg
@echo "%WINSYSREGPATH%rvsdp.dll"=->> %TEMP%\dlgc_reg_clean.reg
@echo "%WINSYSREGPATH%rvsip.dll"=->> %TEMP%\dlgc_reg_clean.reg
@echo "%WINSYSREGPATH%S7Cfg.dll"=->> %TEMP%\dlgc_reg_clean.reg
@echo "%WINSYSREGPATH%SCEventMsg.dll"=->> %TEMP%\dlgc_reg_clean.reg
@echo "%WINSYSREGPATH%sdntf.dll"=->> %TEMP%\dlgc_reg_clean.reg
@echo "%WINSYSREGPATH%SoftFaxRM.dll"=->> %TEMP%\dlgc_reg_clean.reg
@echo "%WINSYSREGPATH%sramperf.dll"=->> %TEMP%\dlgc_reg_clean.reg
@echo "%WINSYSREGPATH%swadl.dll"=->> %TEMP%\dlgc_reg_clean.reg
@echo "%WINSYSREGPATH%swfdsp.dll"=->> %TEMP%\dlgc_reg_clean.reg
@echo "%WINSYSREGPATH%syntellect.dll"=->> %TEMP%\dlgc_reg_clean.reg
@echo "%WINSYSREGPATH%tascscu.dll"=->> %TEMP%\dlgc_reg_clean.reg
@echo "%WINSYSREGPATH%TCUtil.dll"=->> %TEMP%\dlgc_reg_clean.reg
@echo "%WINSYSREGPATH%ThirdPartyBsp.dll"=->> %TEMP%\dlgc_reg_clean.reg
@echo "%WINSYSREGPATH%thirdpartydetector.dll"=->> %TEMP%\dlgc_reg_clean.reg
@echo "%WINSYSREGPATH%vfxntf.dll"=->> %TEMP%\dlgc_reg_clean.reg
@echo "%WINSYSREGPATH%voxspan.dll"=->> %TEMP%\dlgc_reg_clean.reg
@echo "%WINSYSREGPATH%xerces-c_1_1.dll"=->> %TEMP%\dlgc_reg_clean.reg
@echo "%WINSYSREGPATH%ConfigGamma.cpl"=->> %TEMP%\dlgc_reg_clean.reg
@echo "%WINSYSREGPATH%ConfigGDK.cpl"=->> %TEMP%\dlgc_reg_clean.reg
@echo "%WINSYSREGPATH%GlfxIf.dll"=->> %TEMP%\dlgc_reg_clean.reg
@echo "%WINSYSREGPATH%GlfxStd.dll"=->> %TEMP%\dlgc_reg_clean.reg
@echo "%WINSYSREGPATH%NtGdk.dll"=->> %TEMP%\dlgc_reg_clean.reg
@echo "%WINSYSREGPATH%NtGdkMsg.dll"=->> %TEMP%\dlgc_reg_clean.reg
@echo.>> %TEMP%\dlgc_reg_clean.reg
@echo.>> %TEMP%\dlgc_reg_clean.reg
@echo #####>> %TEMP%\dlgc_reg_clean.reg
@echo #####	CLSIDs>> %TEMP%\dlgc_reg_clean.reg
@echo #####>> %TEMP%\dlgc_reg_clean.reg
@echo.>> %TEMP%\dlgc_reg_clean.reg
@echo # PMACDetector.PMACDetector.1>> %TEMP%\dlgc_reg_clean.reg
@echo [-HKEY_CLASSES_ROOT\CLSID\{0815E881-19DF-11D4-AE27-00C04F35BF96}]>> %TEMP%\dlgc_reg_clean.reg
@echo [-HKEY_LOCAL_MACHINE\SOFTWARE\Classes\CLSID\{0815E881-19DF-11D4-AE27-00C04F35BF96}]>> %TEMP%\dlgc_reg_clean.reg
@echo.>> %TEMP%\dlgc_reg_clean.reg
@echo # SPWDetector.SPWDetector.1>> %TEMP%\dlgc_reg_clean.reg
@echo [-HKEY_CLASSES_ROOT\CLSID\{0815E883-19DF-11D4-AE27-00C04F35BF96}]>> %TEMP%\dlgc_reg_clean.reg
@echo [-HKEY_LOCAL_MACHINE\SOFTWARE\Classes\CLSID\{0815E883-19DF-11D4-AE27-00C04F35BF96}]>> %TEMP%\dlgc_reg_clean.reg
@echo.>> %TEMP%\dlgc_reg_clean.reg
@echo # DCM.DCM.1>> %TEMP%\dlgc_reg_clean.reg
@echo [-HKEY_CLASSES_ROOT\CLSID\{C463BA58-8A69-11D3-AE7A-00C04F9FED7F}]>> %TEMP%\dlgc_reg_clean.reg
@echo [-HKEY_LOCAL_MACHINE\SOFTWARE\Classes\CLSID\{C463BA58-8A69-11D3-AE7A-00C04F9FED7F}]>> %TEMP%\dlgc_reg_clean.reg
@echo.>> %TEMP%\dlgc_reg_clean.reg
@echo # C:\Program Files\Dialogic\lib\dcmobjps.dll>> %TEMP%\dlgc_reg_clean.reg
@echo [-HKEY_CLASSES_ROOT\CLSID\{F09F3850-BC92-11D3-B4A0-00104B2B2DCF}]>> %TEMP%\dlgc_reg_clean.reg
@echo [-HKEY_LOCAL_MACHINE\SOFTWARE\Classes\CLSID\{F09F3850-BC92-11D3-B4A0-00104B2B2DCF}]>> %TEMP%\dlgc_reg_clean.reg
@echo.>> %TEMP%\dlgc_reg_clean.reg
@echo # C:\Program Files\Dialogic\bin\DetectorsServer.exe>> %TEMP%\dlgc_reg_clean.reg
@echo [-HKEY_CLASSES_ROOT\TypeLib\{3AA32E52-1A02-11D4-AE27-00C04F35BF96}]>> %TEMP%\dlgc_reg_clean.reg
@echo [-HKEY_LOCAL_MACHINE\SOFTWARE\Classes\TypeLib\{3AA32E52-1A02-11D4-AE27-00C04F35BF96}]>> %TEMP%\dlgc_reg_clean.reg
@echo.>> %TEMP%\dlgc_reg_clean.reg
@echo # C:\Program Files\Dialogic\bin\DlgcS7Srvps.dll>> %TEMP%\dlgc_reg_clean.reg
@echo [-HKEY_LOCAL_MACHINE\SOFTWARE\Classes\CLSID\{78D5DEED-859B-11D2-BCEA-00AA00A0E423}]>> %TEMP%\dlgc_reg_clean.reg
@echo [-HKEY_CLASSES_ROOT\CLSID\{78D5DEED-859B-11D2-BCEA-00AA00A0E423}]>> %TEMP%\dlgc_reg_clean.reg
@echo.>> %TEMP%\dlgc_reg_clean.reg
@echo # C:\Program Files\Dialogic\bin\DlgcS7~1.exe>> %TEMP%\dlgc_reg_clean.reg
@echo [-HKEY_LOCAL_MACHINE\SOFTWARE\Classes\CLSID\{78D5DEEE-859B-11D2-BCEA-00AA00A0E423}]>> %TEMP%\dlgc_reg_clean.reg
@echo [-HKEY_CLASSES_ROOT\CLSID\{78D5DEEE-859B-11D2-BCEA-00AA00A0E423}]>> %TEMP%\dlgc_reg_clean.reg
@echo [-HKEY_LOCAL_MACHINE\SOFTWARE\Classes\CLSID\{78D5DEF5-859B-11D2-BCEA-00AA00A0E423}]>> %TEMP%\dlgc_reg_clean.reg
@echo [-HKEY_CLASSES_ROOT\CLSID\{78D5DEF5-859B-11D2-BCEA-00AA00A0E423}]>> %TEMP%\dlgc_reg_clean.reg
@echo.>> %TEMP%\dlgc_reg_clean.reg
@echo # SetupLogServices Class>> %TEMP%\dlgc_reg_clean.reg
@echo [-HKEY_LOCAL_MACHINE\SOFTWARE\Classes\CLSID\{8c3c1b17-e59d-11d2-b40b-00a024b9dddd}]0>> %TEMP%\dlgc_reg_clean.reg
@echo.>> %TEMP%\dlgc_reg_clean.reg
@echo.>> %TEMP%\dlgc_reg_clean.reg
@echo.>> %TEMP%\dlgc_reg_clean.reg
@echo #####>> %TEMP%\dlgc_reg_clean.reg
@echo ##### Start Menu Item>> %TEMP%\dlgc_reg_clean.reg
@echo #####>> %TEMP%\dlgc_reg_clean.reg
@echo [-HKEY_CURRENT_USER\Software\Microsoft\Windows\CurrentVersion\Explorer\MenuOrder\Start Menu\Programs\Intel Dialogic System Release 6.0 PCI]>> %TEMP%\dlgc_reg_clean.reg
@echo [-HKEY_CURRENT_USER\Software\Microsoft\Windows\CurrentVersion\Explorer\MenuOrder\Start Menu\Programs\Intel Dialogic System Software]>> %TEMP%\dlgc_reg_clean.reg
@echo [-HKEY_CURRENT_USER\Software\Microsoft\Windows\CurrentVersion\Explorer\MenuOrder\Start Menu\Programs\Intel Dialogic System Release]>> %TEMP%\dlgc_reg_clean.reg
@echo [-HKEY_CURRENT_USER\Software\Microsoft\Windows\CurrentVersion\Explorer\MenuOrder\Start Menu\Programs\Intel HMP 1.0]>> %TEMP%\dlgc_reg_clean.reg
@echo [-HKEY_CURRENT_USER\Software\Microsoft\Windows\CurrentVersion\Explorer\MenuOrder\Start Menu\Programs\Intel NetStructure (TM) HMP 1.0 menu]>> %TEMP%\dlgc_reg_clean.reg
@echo [-HKEY_CURRENT_USER\Software\Microsoft\Windows\CurrentVersion\Explorer\MenuOrder\Start Menu\Programs\Intel HMP 1.1]>> %TEMP%\dlgc_reg_clean.reg
@echo [-HKEY_CURRENT_USER\Software\Microsoft\Windows\CurrentVersion\Explorer\MenuOrder\Start Menu\Programs\Intel NetStructure HMP]>> %TEMP%\dlgc_reg_clean.reg
@echo.>> %TEMP%\dlgc_reg_clean.reg
@echo.>> %TEMP%\dlgc_reg_clean.reg
@echo #####>> %TEMP%\dlgc_reg_clean.reg
@echo ##### Install GUIDs>> %TEMP%\dlgc_reg_clean.reg
@echo #####>> %TEMP%\dlgc_reg_clean.reg
@echo.>> %TEMP%\dlgc_reg_clean.reg
@echo ##### Point Releases, HMP 1.0 SP1 and FP1 Runtime>> %TEMP%\dlgc_reg_clean.reg
@echo [-HKEY_LOCAL_MACHINE\SOFTWARE\Microsoft\Windows\CurrentVersion\Uninstall\{0FC1D5E3-21B9-11D4-A580-00C04F35CB28}]>> %TEMP%\dlgc_reg_clean.reg
@echo.>> %TEMP%\dlgc_reg_clean.reg
@echo ##### Service Packs (SR 5.1.1 SP3 and later)>> %TEMP%\dlgc_reg_clean.reg
@echo [-HKEY_LOCAL_MACHINE\SOFTWARE\Microsoft\Windows\CurrentVersion\Uninstall\{18D1CB58-7334-41BA-85BF-EF31C321CEBC}]>> %TEMP%\dlgc_reg_clean.reg
@echo.>> %TEMP%\dlgc_reg_clean.reg
@echo ##### SR 6.0 Runtime, SR 6.1, HMP 1.3, HMP 2.0, HMP 3.0>> %TEMP%\dlgc_reg_clean.reg
@echo [-HKEY_LOCAL_MACHINE\SOFTWARE\Microsoft\Windows\CurrentVersion\Uninstall\{4A6FA71B-C3AA-494D-8D5D-6B5A3C196946}]>> %TEMP%\dlgc_reg_clean.reg
@echo.>> %TEMP%\dlgc_reg_clean.reg
@echo ##### SR 6.0 SDK (obsolete, never released)>> %TEMP%\dlgc_reg_clean.reg
@echo [-HKEY_LOCAL_MACHINE\SOFTWARE\Microsoft\Windows\CurrentVersion\Uninstall\{57A6B857-C948-427F-979C-CB8AF5331A56}]>> %TEMP%\dlgc_reg_clean.reg
@echo.>> %TEMP%\dlgc_reg_clean.reg
@echo ##### Global Call Protocols 4.0 and later>> %TEMP%\dlgc_reg_clean.reg
@echo [-HKEY_LOCAL_MACHINE\SOFTWARE\Microsoft\Windows\CurrentVersion\Uninstall\{8C1C7C31-AE1E-4EA9-A108-80F23ED7AE1B}]>> %TEMP%\dlgc_reg_clean.reg
@echo [-HKEY_LOCAL_MACHINE\SOFTWARE\Microsoft\Windows\CurrentVersion\Uninstall\Intel Dialogic Global Call Protocols]>> %TEMP%\dlgc_reg_clean.reg
@echo.>> %TEMP%\dlgc_reg_clean.reg
@echo ##### SR 6.0 cPCI FP1>> %TEMP%\dlgc_reg_clean.reg
@echo [-HKEY_LOCAL_MACHINE\SOFTWARE\Microsoft\Windows\CurrentVersion\Uninstall\{D43962D0-77A0-11D4-8F9D-00C04F35CB28}]>> %TEMP%\dlgc_reg_clean.reg
@echo.>> %TEMP%\dlgc_reg_clean.reg
@echo ##### Intel(R) Dialogic(R) D4PCI-U HMP 2.0 Gateway Demo>> %TEMP%\dlgc_reg_clean.reg
@echo [-HKEY_LOCAL_MACHINE\SOFTWARE\Microsoft\Windows\CurrentVersion\Uninstall\{D8CA755B-D376-464C-8795-457F8FD698A5}]>> %TEMP%\dlgc_reg_clean.reg
@echo.>> %TEMP%\dlgc_reg_clean.reg
@echo ##### HMP 1.0 and 1.1 Runtime>> %TEMP%\dlgc_reg_clean.reg
@echo [-HKEY_LOCAL_MACHINE\SOFTWARE\Microsoft\Windows\CurrentVersion\Uninstall\{DF2FE966-3A24-429D-B11C-1AB13E2AD6D0}]>> %TEMP%\dlgc_reg_clean.reg
@echo.>> %TEMP%\dlgc_reg_clean.reg
@echo ##### Feature and Old Service Packs, HMP 1.1 SU Runtime>> %TEMP%\dlgc_reg_clean.reg
@echo [-HKEY_LOCAL_MACHINE\SOFTWARE\Microsoft\Windows\CurrentVersion\Uninstall\{E62BF0D9-BA88-4227-B079-F2E52100E446}]>> %TEMP%\dlgc_reg_clean.reg
@echo.>> %TEMP%\dlgc_reg_clean.reg
@echo ##### Global Call Protocols 3.0 and earlier>> %TEMP%\dlgc_reg_clean.reg
@echo [-HKEY_LOCAL_MACHINE\SOFTWARE\Microsoft\Windows\CurrentVersion\Uninstall\Global Call Protocols]>> %TEMP%\dlgc_reg_clean.reg
@echo.>> %TEMP%\dlgc_reg_clean.reg
@echo.>> %TEMP%\dlgc_reg_clean.reg
@echo #####>> %TEMP%\dlgc_reg_clean.reg
@echo ##### Install setup.exe path>> %TEMP%\dlgc_reg_clean.reg
@echo #####>> %TEMP%\dlgc_reg_clean.reg
@echo [-HKEY_LOCAL_MACHINE\SOFTWARE\Microsoft\Windows\CurrentVersion\App Paths\setup.exe]>> %TEMP%\dlgc_reg_clean.reg
@echo.>> %TEMP%\dlgc_reg_clean.reg
@echo.>> %TEMP%\dlgc_reg_clean.reg
@echo #####>> %TEMP%\dlgc_reg_clean.reg
@echo ##### Dialogic and Intel Dialogic environment variables>> %TEMP%\dlgc_reg_clean.reg
@echo #####>> %TEMP%\dlgc_reg_clean.reg
@echo.>> %TEMP%\dlgc_reg_clean.reg
@echo # CurrentControlSet>> %TEMP%\dlgc_reg_clean.reg
@echo [HKEY_LOCAL_MACHINE\SYSTEM\CurrentControlSet\Control\Session Manager\Environment]>> %TEMP%\dlgc_reg_clean.reg
@echo "DIALOGICDIR"=->> %TEMP%\dlgc_reg_clean.reg
@echo "DIALOGICDRV"=->> %TEMP%\dlgc_reg_clean.reg
@echo "DIALOGICSNMPDIR"=->> %TEMP%\dlgc_reg_clean.reg
@echo "DLCFGPATH"=->> %TEMP%\dlgc_reg_clean.reg
@echo "DLFWLPATH"=->> %TEMP%\dlgc_reg_clean.reg
@echo "DLG_TRACE_LEVEL"=->> %TEMP%\dlgc_reg_clean.reg
@echo "DLGCDESTDIR"=->> %TEMP%\dlgc_reg_clean.reg
@echo "DLINFPATH"=->> %TEMP%\dlgc_reg_clean.reg
@echo "DNASDKDIR"=->> %TEMP%\dlgc_reg_clean.reg
@echo "GFAX"=->> %TEMP%\dlgc_reg_clean.reg
@echo "INTEL_DIALOGIC_BASE"=->> %TEMP%\dlgc_reg_clean.reg
@echo "INTEL_DIALOGIC_BIN"=->> %TEMP%\dlgc_reg_clean.reg
@echo "INTEL_DIALOGIC_CFG"=->> %TEMP%\dlgc_reg_clean.reg
@echo "INTEL_DIALOGIC_CPFAX"=->> %TEMP%\dlgc_reg_clean.reg
@echo "INTEL_DIALOGIC_DIR"=->> %TEMP%\dlgc_reg_clean.reg
@echo "INTEL_DIALOGIC_FWL"=->> %TEMP%\dlgc_reg_clean.reg
@echo "INTEL_DIALOGIC_INC"=->> %TEMP%\dlgc_reg_clean.reg
@echo "INTEL_DIALOGIC_LIB"=->> %TEMP%\dlgc_reg_clean.reg
@echo "INTEL_DIALOGIC_NAME"=->> %TEMP%\dlgc_reg_clean.reg
@echo "INTEL_DIALOGIC_QSCRIPT"=->> %TEMP%\dlgc_reg_clean.reg
@echo "INTEL_DIALOGIC_RELEASE"=->> %TEMP%\dlgc_reg_clean.reg
@echo "ORBACUS_CONFIG"=->> %TEMP%\dlgc_reg_clean.reg
@echo "QSCRIPT_DIR"=->> %TEMP%\dlgc_reg_clean.reg
@echo.>> %TEMP%\dlgc_reg_clean.reg
@echo.>> %TEMP%\dlgc_reg_clean.reg
@echo # ControlSet001>> %TEMP%\dlgc_reg_clean.reg
@echo [HKEY_LOCAL_MACHINE\SYSTEM\ControlSet001\Control\Session Manager\Environment]>> %TEMP%\dlgc_reg_clean.reg
@echo "DIALOGICDIR"=->> %TEMP%\dlgc_reg_clean.reg
@echo "DIALOGICDRV"=->> %TEMP%\dlgc_reg_clean.reg
@echo "DIALOGICSNMPDIR"=->> %TEMP%\dlgc_reg_clean.reg
@echo "DLCFGPATH"=->> %TEMP%\dlgc_reg_clean.reg
@echo "DLFWLPATH"=->> %TEMP%\dlgc_reg_clean.reg
@echo "DLG_TRACE_LEVEL"=->> %TEMP%\dlgc_reg_clean.reg
@echo "DLGCDESTDIR"=->> %TEMP%\dlgc_reg_clean.reg
@echo "DLINFPATH"=->> %TEMP%\dlgc_reg_clean.reg
@echo "DNASDKDIR"=->> %TEMP%\dlgc_reg_clean.reg
@echo "GFAX"=->> %TEMP%\dlgc_reg_clean.reg
@echo "INTEL_DIALOGIC_BASE"=->> %TEMP%\dlgc_reg_clean.reg
@echo "INTEL_DIALOGIC_BIN"=->> %TEMP%\dlgc_reg_clean.reg
@echo "INTEL_DIALOGIC_CFG"=->> %TEMP%\dlgc_reg_clean.reg
@echo "INTEL_DIALOGIC_CPFAX"=->> %TEMP%\dlgc_reg_clean.reg
@echo "INTEL_DIALOGIC_DIR"=->> %TEMP%\dlgc_reg_clean.reg
@echo "INTEL_DIALOGIC_FWL"=->> %TEMP%\dlgc_reg_clean.reg
@echo "INTEL_DIALOGIC_INC"=->> %TEMP%\dlgc_reg_clean.reg
@echo "INTEL_DIALOGIC_LIB"=->> %TEMP%\dlgc_reg_clean.reg
@echo "INTEL_DIALOGIC_NAME"=->> %TEMP%\dlgc_reg_clean.reg
@echo "INTEL_DIALOGIC_QSCRIPT"=->> %TEMP%\dlgc_reg_clean.reg
@echo "INTEL_DIALOGIC_RELEASE"=->> %TEMP%\dlgc_reg_clean.reg
@echo "ORBACUS_CONFIG"=->> %TEMP%\dlgc_reg_clean.reg
@echo "QSCRIPT_DIR"=->> %TEMP%\dlgc_reg_clean.reg
@echo.>> %TEMP%\dlgc_reg_clean.reg
@echo.>> %TEMP%\dlgc_reg_clean.reg
@echo # ControlSet002>> %TEMP%\dlgc_reg_clean.reg
@echo [HKEY_LOCAL_MACHINE\SYSTEM\ControlSet002\Control\Session Manager\Environment]>> %TEMP%\dlgc_reg_clean.reg
@echo "DIALOGICDIR"=->> %TEMP%\dlgc_reg_clean.reg
@echo "DIALOGICDRV"=->> %TEMP%\dlgc_reg_clean.reg
@echo "DIALOGICSNMPDIR"=->> %TEMP%\dlgc_reg_clean.reg
@echo "DLCFGPATH"=->> %TEMP%\dlgc_reg_clean.reg
@echo "DLFWLPATH"=->> %TEMP%\dlgc_reg_clean.reg
@echo "DLG_TRACE_LEVEL"=->> %TEMP%\dlgc_reg_clean.reg
@echo "DLGCDESTDIR"=->> %TEMP%\dlgc_reg_clean.reg
@echo "DLINFPATH"=->> %TEMP%\dlgc_reg_clean.reg
@echo "DNASDKDIR"=->> %TEMP%\dlgc_reg_clean.reg
@echo "GFAX"=->> %TEMP%\dlgc_reg_clean.reg
@echo "INTEL_DIALOGIC_BASE"=->> %TEMP%\dlgc_reg_clean.reg
@echo "INTEL_DIALOGIC_BIN"=->> %TEMP%\dlgc_reg_clean.reg
@echo "INTEL_DIALOGIC_CFG"=->> %TEMP%\dlgc_reg_clean.reg
@echo "INTEL_DIALOGIC_CPFAX"=->> %TEMP%\dlgc_reg_clean.reg
@echo "INTEL_DIALOGIC_DIR"=->> %TEMP%\dlgc_reg_clean.reg
@echo "INTEL_DIALOGIC_FWL"=->> %TEMP%\dlgc_reg_clean.reg
@echo "INTEL_DIALOGIC_INC"=->> %TEMP%\dlgc_reg_clean.reg
@echo "INTEL_DIALOGIC_LIB"=->> %TEMP%\dlgc_reg_clean.reg
@echo "INTEL_DIALOGIC_NAME"=->> %TEMP%\dlgc_reg_clean.reg
@echo "INTEL_DIALOGIC_QSCRIPT"=->> %TEMP%\dlgc_reg_clean.reg
@echo "INTEL_DIALOGIC_RELEASE"=->> %TEMP%\dlgc_reg_clean.reg
@echo "ORBACUS_CONFIG"=->> %TEMP%\dlgc_reg_clean.reg
@echo "QSCRIPT_DIR"=->> %TEMP%\dlgc_reg_clean.reg
@echo.>> %TEMP%\dlgc_reg_clean.reg
@echo.>> %TEMP%\dlgc_reg_clean.reg
@echo ### TO-DO: Remove Dialogic directories from the path.  Can't do with reg file!>> %TEMP%\dlgc_reg_clean.reg
@echo.>> %TEMP%\dlgc_reg_clean.reg
@echo #####>> %TEMP%\dlgc_reg_clean.reg
@echo ##### Event Logger Event Sources>> %TEMP%\dlgc_reg_clean.reg
@echo #####>> %TEMP%\dlgc_reg_clean.reg
@echo.>> %TEMP%\dlgc_reg_clean.reg
@echo # CurrentControlSet>> %TEMP%\dlgc_reg_clean.reg
@echo [-HKEY_LOCAL_MACHINE\SYSTEM\CurrentControlSet\Services\Eventlog\Application\DLGCDeviceMapper]>> %TEMP%\dlgc_reg_clean.reg
@echo [-HKEY_LOCAL_MACHINE\SYSTEM\CurrentControlSet\Services\Eventlog\Application\DM3Config]>> %TEMP%\dlgc_reg_clean.reg
@echo [-HKEY_LOCAL_MACHINE\SYSTEM\CurrentControlSet\Services\Eventlog\Application\GammaFax]>> %TEMP%\dlgc_reg_clean.reg
@echo [-HKEY_LOCAL_MACHINE\SYSTEM\CurrentControlSet\Services\Eventlog\Application\Implementation Repository]>> %TEMP%\dlgc_reg_clean.reg
@echo [-HKEY_LOCAL_MACHINE\SYSTEM\CurrentControlSet\Services\Eventlog\Application\IPMedia]>> %TEMP%\dlgc_reg_clean.reg
@echo [-HKEY_LOCAL_MACHINE\SYSTEM\CurrentControlSet\Services\Eventlog\Application\NCM]>> %TEMP%\dlgc_reg_clean.reg
@echo [-HKEY_LOCAL_MACHINE\SYSTEM\CurrentControlSet\Services\Eventlog\Application\RTFAPI]>> %TEMP%\dlgc_reg_clean.reg
@echo [-HKEY_LOCAL_MACHINE\SYSTEM\CurrentControlSet\Services\Eventlog\System\BriStart]>> %TEMP%\dlgc_reg_clean.reg
@echo [-HKEY_LOCAL_MACHINE\SYSTEM\CurrentControlSet\Services\Eventlog\System\BriStop]>> %TEMP%\dlgc_reg_clean.reg
@echo [-HKEY_LOCAL_MACHINE\SYSTEM\CurrentControlSet\Services\Eventlog\System\ClusterPkg]>> %TEMP%\dlgc_reg_clean.reg
@echo [-HKEY_LOCAL_MACHINE\SYSTEM\CurrentControlSet\Services\Eventlog\System\Confslot]>> %TEMP%\dlgc_reg_clean.reg
@echo [-HKEY_LOCAL_MACHINE\SYSTEM\CurrentControlSet\Services\Eventlog\System\CTBBAPI]>> %TEMP%\dlgc_reg_clean.reg
@echo [-HKEY_LOCAL_MACHINE\SYSTEM\CurrentControlSet\Services\Eventlog\System\ctbbserv]>> %TEMP%\dlgc_reg_clean.reg
@echo [-HKEY_LOCAL_MACHINE\SYSTEM\CurrentControlSet\Services\Eventlog\System\CTBusBroker]>> %TEMP%\dlgc_reg_clean.reg
@echo [-HKEY_LOCAL_MACHINE\SYSTEM\CurrentControlSet\Services\Eventlog\System\dcmobj]>> %TEMP%\dlgc_reg_clean.reg
@echo [-HKEY_LOCAL_MACHINE\SYSTEM\CurrentControlSet\Services\Eventlog\System\DetectorsProj]>> %TEMP%\dlgc_reg_clean.reg
@echo [-HKEY_LOCAL_MACHINE\SYSTEM\CurrentControlSet\Services\Eventlog\System\DetectorsServer]>> %TEMP%\dlgc_reg_clean.reg
@echo [-HKEY_LOCAL_MACHINE\SYSTEM\CurrentControlSet\Services\Eventlog\System\devmapserver]>> %TEMP%\dlgc_reg_clean.reg
@echo [-HKEY_LOCAL_MACHINE\SYSTEM\CurrentControlSet\Services\Eventlog\System\Dlgc_log]>> %TEMP%\dlgc_reg_clean.reg
@echo [-HKEY_LOCAL_MACHINE\SYSTEM\CurrentControlSet\Services\Eventlog\System\dlgc_srv]>> %TEMP%\dlgc_reg_clean.reg
@echo [-HKEY_LOCAL_MACHINE\SYSTEM\CurrentControlSet\Services\Eventlog\System\DlgcDcm]>> %TEMP%\dlgc_reg_clean.reg
@echo [-HKEY_LOCAL_MACHINE\SYSTEM\CurrentControlSet\Services\Eventlog\System\DlgcMemDoler]>> %TEMP%\dlgc_reg_clean.reg
@echo [-HKEY_LOCAL_MACHINE\SYSTEM\CurrentControlSet\Services\Eventlog\System\dlgcmpd]>> %TEMP%\dlgc_reg_clean.reg
@echo [-HKEY_LOCAL_MACHINE\SYSTEM\CurrentControlSet\Services\Eventlog\System\DlgPnPObserverService]>> %TEMP%\dlgc_reg_clean.reg
@echo [-HKEY_LOCAL_MACHINE\SYSTEM\CurrentControlSet\Services\Eventlog\System\dlgsysmonitorserver]>> %TEMP%\dlgc_reg_clean.reg
@echo [-HKEY_LOCAL_MACHINE\SYSTEM\CurrentControlSet\Services\Eventlog\System\dm3bsp]>> %TEMP%\dlgc_reg_clean.reg
@echo [-HKEY_LOCAL_MACHINE\SYSTEM\CurrentControlSet\Services\Eventlog\System\DM3Config]>> %TEMP%\dlgc_reg_clean.reg
@echo [-HKEY_LOCAL_MACHINE\SYSTEM\CurrentControlSet\Services\Eventlog\System\DM3Detector]>> %TEMP%\dlgc_reg_clean.reg
@echo [-HKEY_LOCAL_MACHINE\SYSTEM\CurrentControlSet\Services\Eventlog\System\dm3enumerate]>> %TEMP%\dlgc_reg_clean.reg
@echo [-HKEY_LOCAL_MACHINE\SYSTEM\CurrentControlSet\Services\Eventlog\System\GenLoad]>> %TEMP%\dlgc_reg_clean.reg
@echo [-HKEY_LOCAL_MACHINE\SYSTEM\CurrentControlSet\Services\Eventlog\System\IPMedia]>> %TEMP%\dlgc_reg_clean.reg
@echo [-HKEY_LOCAL_MACHINE\SYSTEM\CurrentControlSet\Services\Eventlog\System\IPTConf]>> %TEMP%\dlgc_reg_clean.reg
@echo [-HKEY_LOCAL_MACHINE\SYSTEM\CurrentControlSet\Services\Eventlog\System\lineadapt]>> %TEMP%\dlgc_reg_clean.reg
@echo [-HKEY_LOCAL_MACHINE\SYSTEM\CurrentControlSet\Services\Eventlog\System\MSILineActivate]>> %TEMP%\dlgc_reg_clean.reg
@echo [-HKEY_LOCAL_MACHINE\SYSTEM\CurrentControlSet\Services\Eventlog\System\NCM]>> %TEMP%\dlgc_reg_clean.reg
@echo [-HKEY_LOCAL_MACHINE\SYSTEM\CurrentControlSet\Services\Eventlog\System\ncmpdkwrapper]>> %TEMP%\dlgc_reg_clean.reg
@echo [-HKEY_LOCAL_MACHINE\SYSTEM\CurrentControlSet\Services\Eventlog\System\nfascfg]>> %TEMP%\dlgc_reg_clean.reg
@echo [-HKEY_LOCAL_MACHINE\SYSTEM\CurrentControlSet\Services\Eventlog\System\ObserverService]>> %TEMP%\dlgc_reg_clean.reg
@echo [-HKEY_LOCAL_MACHINE\SYSTEM\CurrentControlSet\Services\Eventlog\System\pnpfirst]>> %TEMP%\dlgc_reg_clean.reg
@echo [-HKEY_LOCAL_MACHINE\SYSTEM\CurrentControlSet\Services\Eventlog\System\regvox]>> %TEMP%\dlgc_reg_clean.reg
@echo [-HKEY_LOCAL_MACHINE\SYSTEM\CurrentControlSet\Services\Eventlog\System\SctsAssi]>> %TEMP%\dlgc_reg_clean.reg
@echo [-HKEY_LOCAL_MACHINE\SYSTEM\CurrentControlSet\Services\Eventlog\System\sctsdtdx]>> %TEMP%\dlgc_reg_clean.reg
@echo [-HKEY_LOCAL_MACHINE\SYSTEM\CurrentControlSet\Services\Eventlog\System\sctsunas]>> %TEMP%\dlgc_reg_clean.reg
@echo [-HKEY_LOCAL_MACHINE\SYSTEM\CurrentControlSet\Services\Eventlog\System\ServiceControl]>> %TEMP%\dlgc_reg_clean.reg
@echo [-HKEY_LOCAL_MACHINE\SYSTEM\CurrentControlSet\Services\Eventlog\System\StartDrv]>> %TEMP%\dlgc_reg_clean.reg
@echo [-HKEY_LOCAL_MACHINE\SYSTEM\CurrentControlSet\Services\Eventlog\System\StartDti]>> %TEMP%\dlgc_reg_clean.reg
@echo [-HKEY_LOCAL_MACHINE\SYSTEM\CurrentControlSet\Services\Eventlog\System\StopDrv]>> %TEMP%\dlgc_reg_clean.reg
@echo [-HKEY_LOCAL_MACHINE\SYSTEM\CurrentControlSet\Services\Eventlog\System\TSFLoader]>> %TEMP%\dlgc_reg_clean.reg
@echo.>> %TEMP%\dlgc_reg_clean.reg
@echo.>> %TEMP%\dlgc_reg_clean.reg
@echo # ControlSet001>> %TEMP%\dlgc_reg_clean.reg
@echo [-HKEY_LOCAL_MACHINE\SYSTEM\ControlSet001\Services\Eventlog\Application\DLGCDeviceMapper]>> %TEMP%\dlgc_reg_clean.reg
@echo [-HKEY_LOCAL_MACHINE\SYSTEM\ControlSet001\Services\Eventlog\Application\DM3Config]>> %TEMP%\dlgc_reg_clean.reg
@echo [-HKEY_LOCAL_MACHINE\SYSTEM\ControlSet001\Services\Eventlog\Application\GammaFax]>> %TEMP%\dlgc_reg_clean.reg
@echo [-HKEY_LOCAL_MACHINE\SYSTEM\ControlSet001\Services\Eventlog\Application\Implementation Repository]>> %TEMP%\dlgc_reg_clean.reg
@echo [-HKEY_LOCAL_MACHINE\SYSTEM\ControlSet001\Services\Eventlog\Application\IPMedia]>> %TEMP%\dlgc_reg_clean.reg
@echo [-HKEY_LOCAL_MACHINE\SYSTEM\ControlSet001\Services\Eventlog\Application\RTFAPI]>> %TEMP%\dlgc_reg_clean.reg
@echo [-HKEY_LOCAL_MACHINE\SYSTEM\ControlSet001\Services\Eventlog\Application\NCM]>> %TEMP%\dlgc_reg_clean.reg
@echo [-HKEY_LOCAL_MACHINE\SYSTEM\ControlSet001\Services\Eventlog\System\BriStart]>> %TEMP%\dlgc_reg_clean.reg
@echo [-HKEY_LOCAL_MACHINE\SYSTEM\ControlSet001\Services\Eventlog\System\BriStop]>> %TEMP%\dlgc_reg_clean.reg
@echo [-HKEY_LOCAL_MACHINE\SYSTEM\ControlSet001\Services\Eventlog\System\ClusterPkg]>> %TEMP%\dlgc_reg_clean.reg
@echo [-HKEY_LOCAL_MACHINE\SYSTEM\ControlSet001\Services\Eventlog\System\Confslot]>> %TEMP%\dlgc_reg_clean.reg
@echo [-HKEY_LOCAL_MACHINE\SYSTEM\ControlSet001\Services\Eventlog\System\CTBBAPI]>> %TEMP%\dlgc_reg_clean.reg
@echo [-HKEY_LOCAL_MACHINE\SYSTEM\ControlSet001\Services\Eventlog\System\ctbbserv]>> %TEMP%\dlgc_reg_clean.reg
@echo [-HKEY_LOCAL_MACHINE\SYSTEM\ControlSet001\Services\Eventlog\System\CTBusBroker]>> %TEMP%\dlgc_reg_clean.reg
@echo [-HKEY_LOCAL_MACHINE\SYSTEM\ControlSet001\Services\Eventlog\System\dcmobj]>> %TEMP%\dlgc_reg_clean.reg
@echo [-HKEY_LOCAL_MACHINE\SYSTEM\ControlSet001\Services\Eventlog\System\DetectorsProj]>> %TEMP%\dlgc_reg_clean.reg
@echo [-HKEY_LOCAL_MACHINE\SYSTEM\ControlSet001\Services\Eventlog\System\DetectorsServer]>> %TEMP%\dlgc_reg_clean.reg
@echo [-HKEY_LOCAL_MACHINE\SYSTEM\ControlSet001\Services\Eventlog\System\devmapserver]>> %TEMP%\dlgc_reg_clean.reg
@echo [-HKEY_LOCAL_MACHINE\SYSTEM\ControlSet001\Services\Eventlog\System\Dlgc_log]>> %TEMP%\dlgc_reg_clean.reg
@echo [-HKEY_LOCAL_MACHINE\SYSTEM\ControlSet001\Services\Eventlog\System\dlgc_srv]>> %TEMP%\dlgc_reg_clean.reg
@echo [-HKEY_LOCAL_MACHINE\SYSTEM\ControlSet001\Services\Eventlog\System\DlgcDcm]>> %TEMP%\dlgc_reg_clean.reg
@echo [-HKEY_LOCAL_MACHINE\SYSTEM\ControlSet001\Services\Eventlog\System\DlgcMemDoler]>> %TEMP%\dlgc_reg_clean.reg
@echo [-HKEY_LOCAL_MACHINE\SYSTEM\ControlSet001\Services\Eventlog\System\dlgcmpd]>> %TEMP%\dlgc_reg_clean.reg
@echo [-HKEY_LOCAL_MACHINE\SYSTEM\ControlSet001\Services\Eventlog\System\DlgPnPObserverService]>> %TEMP%\dlgc_reg_clean.reg
@echo [-HKEY_LOCAL_MACHINE\SYSTEM\ControlSet001\Services\Eventlog\System\dlgsysmonitorserver]>> %TEMP%\dlgc_reg_clean.reg
@echo [-HKEY_LOCAL_MACHINE\SYSTEM\ControlSet001\Services\Eventlog\System\dm3bsp]>> %TEMP%\dlgc_reg_clean.reg
@echo [-HKEY_LOCAL_MACHINE\SYSTEM\ControlSet001\Services\Eventlog\System\DM3Config]>> %TEMP%\dlgc_reg_clean.reg
@echo [-HKEY_LOCAL_MACHINE\SYSTEM\ControlSet001\Services\Eventlog\System\DM3Detector]>> %TEMP%\dlgc_reg_clean.reg
@echo [-HKEY_LOCAL_MACHINE\SYSTEM\ControlSet001\Services\Eventlog\System\dm3enumerate]>> %TEMP%\dlgc_reg_clean.reg
@echo [-HKEY_LOCAL_MACHINE\SYSTEM\ControlSet001\Services\Eventlog\System\GenLoad]>> %TEMP%\dlgc_reg_clean.reg
@echo [-HKEY_LOCAL_MACHINE\SYSTEM\ControlSet001\Services\Eventlog\System\IPMedia]>> %TEMP%\dlgc_reg_clean.reg
@echo [-HKEY_LOCAL_MACHINE\SYSTEM\ControlSet001\Services\Eventlog\System\IPTConf]>> %TEMP%\dlgc_reg_clean.reg
@echo [-HKEY_LOCAL_MACHINE\SYSTEM\ControlSet001\Services\Eventlog\System\lineadapt]>> %TEMP%\dlgc_reg_clean.reg
@echo [-HKEY_LOCAL_MACHINE\SYSTEM\ControlSet001\Services\Eventlog\System\MSILineActivate]>> %TEMP%\dlgc_reg_clean.reg
@echo [-HKEY_LOCAL_MACHINE\SYSTEM\ControlSet001\Services\Eventlog\System\NCM]>> %TEMP%\dlgc_reg_clean.reg
@echo [-HKEY_LOCAL_MACHINE\SYSTEM\ControlSet001\Services\Eventlog\System\ncmpdkwrapper]>> %TEMP%\dlgc_reg_clean.reg
@echo [-HKEY_LOCAL_MACHINE\SYSTEM\ControlSet001\Services\Eventlog\System\nfascfg]>> %TEMP%\dlgc_reg_clean.reg
@echo [-HKEY_LOCAL_MACHINE\SYSTEM\ControlSet001\Services\Eventlog\System\ObserverService]>> %TEMP%\dlgc_reg_clean.reg
@echo [-HKEY_LOCAL_MACHINE\SYSTEM\ControlSet001\Services\Eventlog\System\pnpfirst]>> %TEMP%\dlgc_reg_clean.reg
@echo [-HKEY_LOCAL_MACHINE\SYSTEM\ControlSet001\Services\Eventlog\System\regvox]>> %TEMP%\dlgc_reg_clean.reg
@echo [-HKEY_LOCAL_MACHINE\SYSTEM\ControlSet001\Services\Eventlog\System\SctsAssi]>> %TEMP%\dlgc_reg_clean.reg
@echo [-HKEY_LOCAL_MACHINE\SYSTEM\ControlSet001\Services\Eventlog\System\sctsdtdx]>> %TEMP%\dlgc_reg_clean.reg
@echo [-HKEY_LOCAL_MACHINE\SYSTEM\ControlSet001\Services\Eventlog\System\sctsunas]>> %TEMP%\dlgc_reg_clean.reg
@echo [-HKEY_LOCAL_MACHINE\SYSTEM\ControlSet001\Services\Eventlog\System\ServiceControl]>> %TEMP%\dlgc_reg_clean.reg
@echo [-HKEY_LOCAL_MACHINE\SYSTEM\ControlSet001\Services\Eventlog\System\StartDrv]>> %TEMP%\dlgc_reg_clean.reg
@echo [-HKEY_LOCAL_MACHINE\SYSTEM\ControlSet001\Services\Eventlog\System\StartDti]>> %TEMP%\dlgc_reg_clean.reg
@echo [-HKEY_LOCAL_MACHINE\SYSTEM\ControlSet001\Services\Eventlog\System\StopDrv]>> %TEMP%\dlgc_reg_clean.reg
@echo [-HKEY_LOCAL_MACHINE\SYSTEM\ControlSet001\Services\Eventlog\System\TSFLoader]>> %TEMP%\dlgc_reg_clean.reg
@echo.>> %TEMP%\dlgc_reg_clean.reg
@echo # ControlSet002>> %TEMP%\dlgc_reg_clean.reg
@echo [-HKEY_LOCAL_MACHINE\SYSTEM\ControlSet002\Services\Eventlog\Application\DLGCDeviceMapper]>> %TEMP%\dlgc_reg_clean.reg
@echo [-HKEY_LOCAL_MACHINE\SYSTEM\ControlSet002\Services\Eventlog\Application\DM3Config]>> %TEMP%\dlgc_reg_clean.reg
@echo [-HKEY_LOCAL_MACHINE\SYSTEM\ControlSet002\Services\Eventlog\Application\GammaFax]>> %TEMP%\dlgc_reg_clean.reg
@echo [-HKEY_LOCAL_MACHINE\SYSTEM\ControlSet002\Services\Eventlog\Application\Implementation Repository]>> %TEMP%\dlgc_reg_clean.reg
@echo [-HKEY_LOCAL_MACHINE\SYSTEM\ControlSet002\Services\Eventlog\Application\IPMedia]>> %TEMP%\dlgc_reg_clean.reg
@echo [-HKEY_LOCAL_MACHINE\SYSTEM\ControlSet002\Services\Eventlog\Application\RTFAPI]>> %TEMP%\dlgc_reg_clean.reg
@echo [-HKEY_LOCAL_MACHINE\SYSTEM\ControlSet002\Services\Eventlog\Application\NCM]>> %TEMP%\dlgc_reg_clean.reg
@echo [-HKEY_LOCAL_MACHINE\SYSTEM\ControlSet002\Services\Eventlog\System\BriStart]>> %TEMP%\dlgc_reg_clean.reg
@echo [-HKEY_LOCAL_MACHINE\SYSTEM\ControlSet002\Services\Eventlog\System\BriStop]>> %TEMP%\dlgc_reg_clean.reg
@echo [-HKEY_LOCAL_MACHINE\SYSTEM\ControlSet002\Services\Eventlog\System\ClusterPkg]>> %TEMP%\dlgc_reg_clean.reg
@echo [-HKEY_LOCAL_MACHINE\SYSTEM\ControlSet002\Services\Eventlog\System\Confslot]>> %TEMP%\dlgc_reg_clean.reg
@echo [-HKEY_LOCAL_MACHINE\SYSTEM\ControlSet002\Services\Eventlog\System\CTBBAPI]>> %TEMP%\dlgc_reg_clean.reg
@echo [-HKEY_LOCAL_MACHINE\SYSTEM\ControlSet002\Services\Eventlog\System\ctbbserv]>> %TEMP%\dlgc_reg_clean.reg
@echo [-HKEY_LOCAL_MACHINE\SYSTEM\ControlSet002\Services\Eventlog\System\CTBusBroker]>> %TEMP%\dlgc_reg_clean.reg
@echo [-HKEY_LOCAL_MACHINE\SYSTEM\ControlSet002\Services\Eventlog\System\dcmobj]>> %TEMP%\dlgc_reg_clean.reg
@echo [-HKEY_LOCAL_MACHINE\SYSTEM\ControlSet002\Services\Eventlog\System\DetectorsProj]>> %TEMP%\dlgc_reg_clean.reg
@echo [-HKEY_LOCAL_MACHINE\SYSTEM\ControlSet002\Services\Eventlog\System\DetectorsServer]>> %TEMP%\dlgc_reg_clean.reg
@echo [-HKEY_LOCAL_MACHINE\SYSTEM\ControlSet002\Services\Eventlog\System\devmapserver]>> %TEMP%\dlgc_reg_clean.reg
@echo [-HKEY_LOCAL_MACHINE\SYSTEM\ControlSet002\Services\Eventlog\System\Dlgc_log]>> %TEMP%\dlgc_reg_clean.reg
@echo [-HKEY_LOCAL_MACHINE\SYSTEM\ControlSet002\Services\Eventlog\System\dlgc_srv]>> %TEMP%\dlgc_reg_clean.reg
@echo [-HKEY_LOCAL_MACHINE\SYSTEM\ControlSet002\Services\Eventlog\System\DlgcDcm]>> %TEMP%\dlgc_reg_clean.reg
@echo [-HKEY_LOCAL_MACHINE\SYSTEM\ControlSet002\Services\Eventlog\System\DlgcMemDoler]>> %TEMP%\dlgc_reg_clean.reg
@echo [-HKEY_LOCAL_MACHINE\SYSTEM\ControlSet002\Services\Eventlog\System\dlgcmpd]>> %TEMP%\dlgc_reg_clean.reg
@echo [-HKEY_LOCAL_MACHINE\SYSTEM\ControlSet002\Services\Eventlog\System\DlgPnPObserverService]>> %TEMP%\dlgc_reg_clean.reg
@echo [-HKEY_LOCAL_MACHINE\SYSTEM\ControlSet002\Services\Eventlog\System\dlgsysmonitorserver]>> %TEMP%\dlgc_reg_clean.reg
@echo [-HKEY_LOCAL_MACHINE\SYSTEM\ControlSet002\Services\Eventlog\System\dm3bsp]>> %TEMP%\dlgc_reg_clean.reg
@echo [-HKEY_LOCAL_MACHINE\SYSTEM\ControlSet002\Services\Eventlog\System\DM3Config]>> %TEMP%\dlgc_reg_clean.reg
@echo [-HKEY_LOCAL_MACHINE\SYSTEM\ControlSet002\Services\Eventlog\System\DM3Detector]>> %TEMP%\dlgc_reg_clean.reg
@echo [-HKEY_LOCAL_MACHINE\SYSTEM\ControlSet002\Services\Eventlog\System\dm3enumerate]>> %TEMP%\dlgc_reg_clean.reg
@echo [-HKEY_LOCAL_MACHINE\SYSTEM\ControlSet002\Services\Eventlog\System\GenLoad]>> %TEMP%\dlgc_reg_clean.reg
@echo [-HKEY_LOCAL_MACHINE\SYSTEM\ControlSet002\Services\Eventlog\System\IPMedia]>> %TEMP%\dlgc_reg_clean.reg
@echo [-HKEY_LOCAL_MACHINE\SYSTEM\ControlSet002\Services\Eventlog\System\IPTConf]>> %TEMP%\dlgc_reg_clean.reg
@echo [-HKEY_LOCAL_MACHINE\SYSTEM\ControlSet002\Services\Eventlog\System\lineadapt]>> %TEMP%\dlgc_reg_clean.reg
@echo [-HKEY_LOCAL_MACHINE\SYSTEM\ControlSet002\Services\Eventlog\System\MSILineActivate]>> %TEMP%\dlgc_reg_clean.reg
@echo [-HKEY_LOCAL_MACHINE\SYSTEM\ControlSet002\Services\Eventlog\System\NCM]>> %TEMP%\dlgc_reg_clean.reg
@echo [-HKEY_LOCAL_MACHINE\SYSTEM\ControlSet002\Services\Eventlog\System\ncmpdkwrapper]>> %TEMP%\dlgc_reg_clean.reg
@echo [-HKEY_LOCAL_MACHINE\SYSTEM\ControlSet002\Services\Eventlog\System\nfascfg]>> %TEMP%\dlgc_reg_clean.reg
@echo [-HKEY_LOCAL_MACHINE\SYSTEM\ControlSet002\Services\Eventlog\System\ObserverService]>> %TEMP%\dlgc_reg_clean.reg
@echo [-HKEY_LOCAL_MACHINE\SYSTEM\ControlSet002\Services\Eventlog\System\pnpfirst]>> %TEMP%\dlgc_reg_clean.reg
@echo [-HKEY_LOCAL_MACHINE\SYSTEM\ControlSet002\Services\Eventlog\System\regvox]>> %TEMP%\dlgc_reg_clean.reg
@echo [-HKEY_LOCAL_MACHINE\SYSTEM\ControlSet002\Services\Eventlog\System\SctsAssi]>> %TEMP%\dlgc_reg_clean.reg
@echo [-HKEY_LOCAL_MACHINE\SYSTEM\ControlSet002\Services\Eventlog\System\sctsdtdx]>> %TEMP%\dlgc_reg_clean.reg
@echo [-HKEY_LOCAL_MACHINE\SYSTEM\ControlSet002\Services\Eventlog\System\sctsunas]>> %TEMP%\dlgc_reg_clean.reg
@echo [-HKEY_LOCAL_MACHINE\SYSTEM\ControlSet002\Services\Eventlog\System\ServiceControl]>> %TEMP%\dlgc_reg_clean.reg
@echo [-HKEY_LOCAL_MACHINE\SYSTEM\ControlSet002\Services\Eventlog\System\StartDrv]>> %TEMP%\dlgc_reg_clean.reg
@echo [-HKEY_LOCAL_MACHINE\SYSTEM\ControlSet002\Services\Eventlog\System\StartDti]>> %TEMP%\dlgc_reg_clean.reg
@echo [-HKEY_LOCAL_MACHINE\SYSTEM\ControlSet002\Services\Eventlog\System\StopDrv]>> %TEMP%\dlgc_reg_clean.reg
@echo [-HKEY_LOCAL_MACHINE\SYSTEM\ControlSet002\Services\Eventlog\System\TSFLoader]>> %TEMP%\dlgc_reg_clean.reg
@echo.>> %TEMP%\dlgc_reg_clean.reg
@echo #####>> %TEMP%\dlgc_reg_clean.reg
@echo ##### Driver-related>> %TEMP%\dlgc_reg_clean.reg
@echo #####>> %TEMP%\dlgc_reg_clean.reg
@echo.>> %TEMP%\dlgc_reg_clean.reg
@echo # Intel NetStructure DM/HDSI Devices>> %TEMP%\dlgc_reg_clean.reg
@echo [-HKEY_LOCAL_MACHINE\SYSTEM\CurrentControlSet\Control\Class\{8CF4CA66-A2CC-48FA-BC1D-6A64E47F6D27}]>> %TEMP%\dlgc_reg_clean.reg
@echo [-HKEY_LOCAL_MACHINE\SYSTEM\ControlSet001\Control\Class\{8CF4CA66-A2CC-48FA-BC1D-6A64E47F6D27}]>> %TEMP%\dlgc_reg_clean.reg
@echo [-HKEY_LOCAL_MACHINE\SYSTEM\ControlSet002\Control\Class\{8CF4CA66-A2CC-48FA-BC1D-6A64E47F6D27}]>> %TEMP%\dlgc_reg_clean.reg
@echo [-HKEY_LOCAL_MACHINE\SYSTEM\CurrentControlSet\Control\DeviceClasses\{8CF4CA66-A2CC-48FA-BC1D-6A64E47F6D27}]>> %TEMP%\dlgc_reg_clean.reg
@echo [-HKEY_LOCAL_MACHINE\SYSTEM\ControlSet001\Control\DeviceClasses\{8CF4CA66-A2CC-48FA-BC1D-6A64E47F6D27}]>> %TEMP%\dlgc_reg_clean.reg
@echo [-HKEY_LOCAL_MACHINE\SYSTEM\ControlSet002\Control\DeviceClasses\{8CF4CA66-A2CC-48FA-BC1D-6A64E47F6D27}]>> %TEMP%\dlgc_reg_clean.reg
@echo.>> %TEMP%\dlgc_reg_clean.reg
@echo # Dialogic SpringWare Devices>> %TEMP%\dlgc_reg_clean.reg
@echo [-HKEY_LOCAL_MACHINE\SYSTEM\CurrentControlSet\Control\Class\{93CA11A8-9239-4193-85CF-40754F08082A}]>> %TEMP%\dlgc_reg_clean.reg
@echo [-HKEY_LOCAL_MACHINE\SYSTEM\ControlSet001\Control\Class\{93CA11A8-9239-4193-85CF-40754F08082A}]>> %TEMP%\dlgc_reg_clean.reg
@echo [-HKEY_LOCAL_MACHINE\SYSTEM\ControlSet002\Control\Class\{93CA11A8-9239-4193-85CF-40754F08082A}]>> %TEMP%\dlgc_reg_clean.reg
@echo [-HKEY_LOCAL_MACHINE\SYSTEM\CurrentControlSet\Control\DeviceClasses\{93CA11A8-9239-4193-85CF-40754F08082A}]>> %TEMP%\dlgc_reg_clean.reg
@echo [-HKEY_LOCAL_MACHINE\SYSTEM\ControlSet001\Control\DeviceClasses\{93CA11A8-9239-4193-85CF-40754F08082A}]>> %TEMP%\dlgc_reg_clean.reg
@echo [-HKEY_LOCAL_MACHINE\SYSTEM\ControlSet002\Control\DeviceClasses\{93CA11A8-9239-4193-85CF-40754F08082A}]>> %TEMP%\dlgc_reg_clean.reg
@echo.>> %TEMP%\dlgc_reg_clean.reg
@echo # Dialogic CP Fax Devices>> %TEMP%\dlgc_reg_clean.reg
@echo [-HKEY_LOCAL_MACHINE\SYSTEM\CurrentControlSet\Control\Class\{A60CCEFF-E267-492C-9862-26DB230FFB62}]>> %TEMP%\dlgc_reg_clean.reg
@echo [-HKEY_LOCAL_MACHINE\SYSTEM\ControlSet001\Control\Class\{A60CCEFF-E267-492C-9862-26DB230FFB62}]>> %TEMP%\dlgc_reg_clean.reg
@echo [-HKEY_LOCAL_MACHINE\SYSTEM\ControlSet002\Control\Class\{A60CCEFF-E267-492C-9862-26DB230FFB62}]>> %TEMP%\dlgc_reg_clean.reg
@echo [-HKEY_LOCAL_MACHINE\SYSTEM\CurrentControlSet\Control\DeviceClasses\{A60CCEFF-E267-492C-9862-26DB230FFB62}]>> %TEMP%\dlgc_reg_clean.reg
@echo [-HKEY_LOCAL_MACHINE\SYSTEM\ControlSet001\Control\DeviceClasses\{A60CCEFF-E267-492C-9862-26DB230FFB62}]>> %TEMP%\dlgc_reg_clean.reg
@echo [-HKEY_LOCAL_MACHINE\SYSTEM\ControlSet002\Control\DeviceClasses\{A60CCEFF-E267-492C-9862-26DB230FFB62}]>> %TEMP%\dlgc_reg_clean.reg
@echo.>> %TEMP%\dlgc_reg_clean.reg
@echo # PMAC Devices>> %TEMP%\dlgc_reg_clean.reg
@echo [-HKEY_LOCAL_MACHINE\SYSTEM\CurrentControlSet\Control\Class\{876F5AC0-CD28-11d4-AAB2-00A0CC661441}]>> %TEMP%\dlgc_reg_clean.reg
@echo [-HKEY_LOCAL_MACHINE\SYSTEM\ControlSet001\Control\Class\{876F5AC0-CD28-11d4-AAB2-00A0CC661441}]>> %TEMP%\dlgc_reg_clean.reg
@echo [-HKEY_LOCAL_MACHINE\SYSTEM\ControlSet002\Control\Class\{876F5AC0-CD28-11d4-AAB2-00A0CC661441}]>> %TEMP%\dlgc_reg_clean.reg
@echo [-HKEY_LOCAL_MACHINE\SYSTEM\CurrentControlSet\Control\DeviceClasses\{876F5AC0-CD28-11d4-AAB2-00A0CC661441}]>> %TEMP%\dlgc_reg_clean.reg
@echo [-HKEY_LOCAL_MACHINE\SYSTEM\ControlSet001\Control\DeviceClasses\{876F5AC0-CD28-11d4-AAB2-00A0CC661441}]>> %TEMP%\dlgc_reg_clean.reg
@echo [-HKEY_LOCAL_MACHINE\SYSTEM\ControlSet002\Control\DeviceClasses\{876F5AC0-CD28-11d4-AAB2-00A0CC661441}]>> %TEMP%\dlgc_reg_clean.reg
@echo.>> %TEMP%\dlgc_reg_clean.reg
@echo.>> %TEMP%\dlgc_reg_clean.reg
@echo.>> %TEMP%\dlgc_reg_clean.reg
@echo #####>> %TEMP%\dlgc_reg_clean.reg
@echo ##### WDM Driver performance entries>> %TEMP%\dlgc_reg_clean.reg
@echo #####>> %TEMP%\dlgc_reg_clean.reg
@echo.>> %TEMP%\dlgc_reg_clean.reg
@echo [HKEY_LOCAL_MACHINE\SOFTWARE\Microsoft\WBEM\WDM]>> %TEMP%\dlgc_reg_clean.reg
@echo "%WINDRVREGPATH%dlgcmcd.sys[MofResourceName]"=->> %TEMP%\dlgc_reg_clean.reg
@echo "%WINDRVREGPATH%dlgcmpd.sys[MofResourceName]"=->> %TEMP%\dlgc_reg_clean.reg
@echo.>> %TEMP%\dlgc_reg_clean.reg
@echo [HKEY_LOCAL_MACHINE\SOFTWARE\Microsoft\WBEM\WDM\DREDGE]>> %TEMP%\dlgc_reg_clean.reg
@echo "%WINDRVREGPATH%dlgcmcd.sys[MofResourceName]"=->> %TEMP%\dlgc_reg_clean.reg
@echo "%WINDRVREGPATH%dlgcmpd.sys[MofResourceName]"=->> %TEMP%\dlgc_reg_clean.reg
@echo.>> %TEMP%\dlgc_reg_clean.reg
@echo.>> %TEMP%\dlgc_reg_clean.reg
@echo #####>> %TEMP%\dlgc_reg_clean.reg
@echo ##### Misc>> %TEMP%\dlgc_reg_clean.reg
@echo #####>> %TEMP%\dlgc_reg_clean.reg
@echo.>> %TEMP%\dlgc_reg_clean.reg
@echo # DialCfg>> %TEMP%\dlgc_reg_clean.reg
@echo [-HKEY_LOCAL_MACHINE\SYSTEM\ControlSet001\Control\DialCfg]>> %TEMP%\dlgc_reg_clean.reg
@echo [-HKEY_LOCAL_MACHINE\SYSTEM\ControlSet002\Control\DialCfg]>> %TEMP%\dlgc_reg_clean.reg
@echo [-HKEY_LOCAL_MACHINE\SYSTEM\CurrentControlSet\Control\DialCfg]>> %TEMP%\dlgc_reg_clean.reg
@echo.>> %TEMP%\dlgc_reg_clean.reg
@echo # PMACDetector related>> %TEMP%\dlgc_reg_clean.reg
@echo [-HKEY_CLASSES_ROOT\PMACDetector.PMACDetector]>> %TEMP%\dlgc_reg_clean.reg
@echo [-HKEY_CLASSES_ROOT\PMACDetector.PMACDetector.1]>> %TEMP%\dlgc_reg_clean.reg
@echo.>> %TEMP%\dlgc_reg_clean.reg
@echo # SPWDetector related>> %TEMP%\dlgc_reg_clean.reg
@echo [-HKEY_CLASSES_ROOT\SPWDetector.SPWDetector]>> %TEMP%\dlgc_reg_clean.reg
@echo [-HKEY_CLASSES_ROOT\SPWDetector.SPWDetector.1]>> %TEMP%\dlgc_reg_clean.reg
@echo.>> %TEMP%\dlgc_reg_clean.reg
@echo [-HKEY_USERS\.DEFAULT\Software\Dialogic]>> %TEMP%\dlgc_reg_clean.reg
@echo [-HKEY_CURRENT_USER\Software\Dialogic]>> %TEMP%\dlgc_reg_clean.reg
@echo.>> %TEMP%\dlgc_reg_clean.reg
@echo [HKEY_LOCAL_MACHINE\Software\Microsoft\Windows\CurrentVersion\RunOnce]>> %TEMP%\dlgc_reg_clean.reg
@echo "DlgcNotRebooted"=->> %TEMP%\dlgc_reg_clean.reg
@echo.>> %TEMP%\dlgc_reg_clean.reg

@REM
@REM Copyright (C) 2003-2007 Dialogic Corporation.  All Rights Reserved.
@REM All names, products, and services mentioned herein are the
@REM trademarks or registered trademarks of their respective
@REM organizations and are the sole property of their respective
@REM owners.

REM
REM   Temporary registry file generation is complete
REM

REM
REM	Verify that regedit.exe is on the system.  If not,
REM	abort the cleanup and leave the generated registry
REM	file so it can be manually run.
@if exist "%REGEDIT%" goto found_regedit
@echo FATAL ERROR:
@echo FATAL ERROR: %REGEDIT% not found.  Registry cleanup aborted.
@echo FATAL_ERROR: Please install %REGEDIT% and run
@echo FATAL_ERROR: "regedit.exe /s %TEMP%\dlgc_reg_clean.reg"
@echo FATAL ERROR:
@echo.
@REM pause so the user can see the fatal error.
@if not "%NOPROMPT%"=="1" pause
@REM abort but leave .reg file in %TEMP% so user can run it.
@goto end

:found_regedit
REM
REM   Now run the generated registry file
REM   which will delete most of the remaining keys.
REM
if exist %TEMP%\dlgc_reg_clean.reg "%REGEDIT%" /s "%TEMP%\dlgc_reg_clean.reg"
@if errorlevel 1 goto regerror
@if errorlevel 0 echo Registry cleanup was successful.
@goto finish

:regerror
@echo Initial execution of registry cleanup failed.  Retrying...
"%REGEDIT%" /s "%TEMP%\dlgc_reg_clean.reg"
if errorlevel 1 goto regerror2
if errorlevel 0 goto finish

:regerror2
@echo FATAL ERROR:
@echo FATAL ERROR: Second execution of registry cleanup failed.
@echo FATAL ERROR: Please manually run %REGEDIT% /s %TEMP%\dlgc_reg_clean.reg
@echo FATAL ERROR:
@if not "%NOPROMPT%"=="1" pause
goto end

:finish
REM
REM Delete the generated registry file
REM
if exist "%TEMP%\dlgc_reg_clean.reg" del "%TEMP%\dlgc_reg_clean.reg"

REM
REM Clean-up is complete.
REM

:end
@REM return to the original drive and directory from which the utility was called
@popd

:deleteself
@REM Delete ourself if the caller asked us to
@if "%DELETESELF%"=="1" if exist "%SELF%" del /f "%SELF%" >NUL 2>&1

:exit

