/* CYGNUS LOCAL: Entire file.  */

/* Definitions of target machine for GNU compiler.
   NEC VR5000 version.
   Copyright (c) 1996,1999 Cygnus Support Inc.

This file is part of GNU CC.

GNU CC is free software; you can redistribute it and/or modify
it under the terms of the GNU General Public License as published by
the Free Software Foundation; either version 2, or (at your option)
any later version.

GNU CC is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with GNU CC; see the file COPYING.  If not, write to
the Free Software Foundation, 675 Mass Ave, Cambridge, MA 02139, USA.  */

#define MIPS_CPU_STRING_DEFAULT "VR5000"

/* We use the MIPS EABI by default.  */
#define MIPS_ABI_DEFAULT ABI_EABI

/* Allow -mabi=32. */
#define MIPS_ENABLE_EMBEDDED_O32 1

/* Add dwarf2 option. */
#define DWARF2_DEBUGGING_INFO

#include "mips/elf64.h"
#include "mips/abi64.h"

#undef MULTILIB_DEFAULTS
#define MULTILIB_DEFAULTS { "EB", "mabi=eabi", "mips4" }

#undef CPP_PREDEFINES
#define CPP_PREDEFINES "-Dmips -DMIPSEB -DR5000 -D_mips -D_MIPSEB -D_R5000"

#undef SUBTARGET_CPP_SPEC
#define SUBTARGET_CPP_SPEC "\
%{!mips1:%{!mips2:%{!mabi=32:-U__mips -D__mips=3 -D__mips64}}} \
%{mcpu=*:-UR5000 -U_R5000 -U__R5000 -U__R5000__} \
%{mcpu=vr5000:-D_R5000 -D__R5000 -D__R5000__ %{!ansi:-DR5000}} \
%{mcpu=vr5400:-D_R5400 -D__R5400 -D__R5400__ %{!ansi:-DR5400}} \
%{!mabi=*: -D__mips_eabi}"

#undef MIPS_ISA_DEFAULT
#define MIPS_ISA_DEFAULT 4

/* This must be done after including mips.h so that the 
   ABI_{EABI,O64,O32,...} are #defined. */
 
#undef SUBTARGET_CPP_SIZE_SPEC
#if MIPS_ABI_DEFAULT == ABI_EABI
#define SUBTARGET_CPP_SIZE_SPEC "\
%{mabi=eabi|!mabi=*:\
  %{mips1|mips2|mlong32: -D__SIZE_TYPE__=unsigned\\ int -D__PTRDIFF_TYPE__=int} \
  %{!mips1:%{!mips2:%{!mlong32:-D__SIZE_TYPE__=long\\ unsigned\\ int -D__PTRDIFF_TYPE__=long\\ int}}}} \
%{mabi=o64:\
 %{mlong64:-D__SIZE_TYPE__=long\\ unsigned\\ int -D__PTRDIFF_TYPE__=long\\ int} \
 %{!mlong64:-D__SIZE_TYPE__=unsigned\\ int -D__PTRDIFF_TYPE__=int}} \
%{mabi=32:-D__SIZE_TYPE__=unsigned\\ int -D__PTRDIFF_TYPE__=int} \
"
#elif MIPS_ABI_DEFAULT == ABI_O64
#define SUBTARGET_CPP_SIZE_SPEC "\
%{mabi=eabi:\
  %{mips1|mips2|mlong32: -D__SIZE_TYPE__=unsigned\\ int -D__PTRDIFF_TYPE__=int} \
  %{!mips1:%{!mips2:%{!mlong32:-D__SIZE_TYPE__=long\\ unsigned\\ int -D__PTRDIFF_TYPE__=long\\ int}}}} \
%{mabi=o64:\
 %{mlong64:-D__SIZE_TYPE__=long\\ unsigned\\ int -D__PTRDIFF_TYPE__=long\\ int} \
 %{!mlong64:-D__SIZE_TYPE__=unsigned\\ int -D__PTRDIFF_TYPE__=int}} \
%{mabi=32:-D__SIZE_TYPE__=unsigned\\ int -D__PTRDIFF_TYPE__=int} \
%{!mabi=*:\
 %{mips1|mips2:-D__SIZE_TYPE__=unsigned\\ int -D__PTRDIFF_TYPE__=int} \
 %{!mips1:%{!mips2:\
  %{mlong64:-D__SIZE_TYPE__=long\\ unsigned\\ int -D__PTRDIFF_TYPE__=long\\ int} \
  %{!mlong64:-D__SIZE_TYPE__=unsigned\\ int -D__PTRDIFF_TYPE__=int}}}} \
"
#else
#define SUBTARGET_CPP_SIZE_SPEC "\
%{mabi=eabi:\
  %{mips1|mips2|mlong32: -D__SIZE_TYPE__=unsigned\\ int -D__PTRDIFF_TYPE__=int} \
  %{!mips1:%{!mips2:%{!mlong32:-D__SIZE_TYPE__=long\\ unsigned\\ int -D__PTRDIFF_TYPE__=long\\ int}}}} \
%{mabi=o64:\
 %{mlong64:-D__SIZE_TYPE__=long\\ unsigned\\ int -D__PTRDIFF_TYPE__=long\\ int} \
 %{!mlong64:-D__SIZE_TYPE__=unsigned\\ int -D__PTRDIFF_TYPE__=int}} \
%{mabi=32:-D__SIZE_TYPE__=unsigned\\ int -D__PTRDIFF_TYPE__=int} \
%{!mabi=*:\
 %{mips1|mips2:-D__SIZE_TYPE__=unsigned\\ int -D__PTRDIFF_TYPE__=int} \
 %{!mips1:%{!mips2:\
  %{mlong64:-D__SIZE_TYPE__=long\\ unsigned\\ int -D__PTRDIFF_TYPE__=long\\ int} \
  %{!mlong64:-D__SIZE_TYPE__=unsigned\\ int -D__PTRDIFF_TYPE__=int}}}} \
"
#endif

