/* Support for Intel x86-based NetApp box.
   Based on code Copyright 1988, 1991, 1992, 1993, 1994 Free Software
   Foundation, Inc.

This file is part of GDB.

This program is free software; you can redistribute it and/or modify
it under the terms of the GNU General Public License as published by
the Free Software Foundation; either version 2 of the License, or
(at your option) any later version.

This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with this program; if not, write to the Free Software
Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.  */

#include "defs.h"
#include "symtab.h"

/* Get the value of the "call_firmware_ebp" variable. */
CORE_ADDR
netapp_get_call_firmware_ebp ()
{
  struct minimal_symbol *call_firmware_ebp_symp;
  static CORE_ADDR call_firmware_ebp_addr;
  char buf[TARGET_PTR_BIT / TARGET_CHAR_BIT];
  CORE_ADDR call_firmware_ebp;

  /* Get the address of "call_firmware_ebp" if we don't already
     have it. */
  if (call_firmware_ebp_addr == 0)
    {
      call_firmware_ebp_symp = lookup_minimal_symbol ("call_firmware_ebp", NULL,
	(struct objfile *) NULL);
      if (call_firmware_ebp_symp == NULL)
	return 0;		/* not defined? */

      call_firmware_ebp_addr = SYMBOL_VALUE_ADDRESS (call_firmware_ebp_symp);
    }

  /* Get the value of "call_firmware_ebp".
     XXX - if it returns a non-zero value, we should fail! */
  target_read_memory (call_firmware_ebp_addr, buf,
			  TARGET_PTR_BIT / TARGET_CHAR_BIT);
  call_firmware_ebp = extract_address (buf, TARGET_PTR_BIT / TARGET_CHAR_BIT);

  return call_firmware_ebp;
}
