/* Support for the generic parts of PE/PEI, for BFD.
   Copyright 1995, 1996, 1997, 1998, 1999, 2000 Free Software Foundation, Inc.
   Written by Cygnus Solutions.

This file is part of BFD, the Binary File Descriptor library.

This program is free software; you can redistribute it and/or modify
it under the terms of the GNU General Public License as published by
the Free Software Foundation; either version 2 of the License, or
(at your option) any later version.

This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with this program; if not, write to the Free Software
Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.  */

/*
Most of this hacked by  Steve Chamberlain,
			sac@cygnus.com

*/

/* Hey look, some documentation [and in a place you expect to find it]!

   The main reference for the pei format is "Microsoft Portable Executable
   and Common Object File Format Specification 4.1".  Get it if you need to
   do some serious hacking on this code.

   Another reference:
   "Peering Inside the PE: A Tour of the Win32 Portable Executable
   File Format", MSJ 1994, Volume 9.

   The *sole* difference between the pe format and the pei format is that the
   latter has an MSDOS 2.0 .exe header on the front that prints the message
   "This app must be run under Windows." (or some such).
   (FIXME: Whether that statement is *really* true or not is unknown.
   Are there more subtle differences between pe and pei formats?
   For now assume there aren't.  If you find one, then for God sakes
   document it here!)

   The Microsoft docs use the word "image" instead of "executable" because
   the former can also refer to a DLL (shared library).  Confusion can arise
   because the `i' in `pei' also refers to "image".  The `pe' format can
   also create images (i.e. executables), it's just that to run on a win32
   system you need to use the pei format.

   FIXME: Please add more docs here so the next poor fool that has to hack
   on this code has a chance of getting something accomplished without
   wasting too much time.
*/

#ifdef coff_bfd_print_private_bfd_data
static boolean (*pe_saved_coff_bfd_print_private_bfd_data)
     PARAMS ((bfd *, PTR))
     = coff_bfd_print_private_bfd_data;
#undef coff_bfd_print_private_bfd_data
#else
static boolean (*pe_saved_coff_bfd_print_private_bfd_data)
     PARAMS ((bfd *, PTR))
     = NULL;
#endif
#define coff_bfd_print_private_bfd_data pe_print_private_bfd_data

#define coff_mkobject      pe_mkobject
#define coff_mkobject_hook pe_mkobject_hook

#ifndef GET_FCN_LNNOPTR
#define GET_FCN_LNNOPTR(abfd, ext) \
     bfd_h_get_32(abfd, (bfd_byte *) ext->x_sym.x_fcnary.x_fcn.x_lnnoptr)
#endif

#ifndef GET_FCN_ENDNDX
#define GET_FCN_ENDNDX(abfd, ext)  \
	bfd_h_get_32(abfd, (bfd_byte *) ext->x_sym.x_fcnary.x_fcn.x_endndx)
#endif

#ifndef PUT_FCN_LNNOPTR
#define PUT_FCN_LNNOPTR(abfd, in, ext)  bfd_h_put_32(abfd,  in, (bfd_byte *) ext->x_sym.x_fcnary.x_fcn.x_lnnoptr)
#endif
#ifndef PUT_FCN_ENDNDX
#define PUT_FCN_ENDNDX(abfd, in, ext) bfd_h_put_32(abfd, in, (bfd_byte *) ext->x_sym.x_fcnary.x_fcn.x_endndx)
#endif
#ifndef GET_LNSZ_LNNO
#define GET_LNSZ_LNNO(abfd, ext) bfd_h_get_16(abfd, (bfd_byte *) ext->x_sym.x_misc.x_lnsz.x_lnno)
#endif
#ifndef GET_LNSZ_SIZE
#define GET_LNSZ_SIZE(abfd, ext) bfd_h_get_16(abfd, (bfd_byte *) ext->x_sym.x_misc.x_lnsz.x_size)
#endif
#ifndef PUT_LNSZ_LNNO
#define PUT_LNSZ_LNNO(abfd, in, ext) bfd_h_put_16(abfd, in, (bfd_byte *)ext->x_sym.x_misc.x_lnsz.x_lnno)
#endif
#ifndef PUT_LNSZ_SIZE
#define PUT_LNSZ_SIZE(abfd, in, ext) bfd_h_put_16(abfd, in, (bfd_byte*) ext->x_sym.x_misc.x_lnsz.x_size)
#endif
#ifndef GET_SCN_SCNLEN
#define GET_SCN_SCNLEN(abfd,  ext) bfd_h_get_32(abfd, (bfd_byte *) ext->x_scn.x_scnlen)
#endif
#ifndef GET_SCN_NRELOC
#define GET_SCN_NRELOC(abfd,  ext) bfd_h_get_16(abfd, (bfd_byte *)ext->x_scn.x_nreloc)
#endif
#ifndef GET_SCN_NLINNO
#define GET_SCN_NLINNO(abfd, ext)  bfd_h_get_16(abfd, (bfd_byte *)ext->x_scn.x_nlinno)
#endif
#ifndef PUT_SCN_SCNLEN
#define PUT_SCN_SCNLEN(abfd,in, ext) bfd_h_put_32(abfd, in, (bfd_byte *) ext->x_scn.x_scnlen)
#endif
#ifndef PUT_SCN_NRELOC
#define PUT_SCN_NRELOC(abfd,in, ext) bfd_h_put_16(abfd, in, (bfd_byte *)ext->x_scn.x_nreloc)
#endif
#ifndef PUT_SCN_NLINNO
#define PUT_SCN_NLINNO(abfd,in, ext)  bfd_h_put_16(abfd,in, (bfd_byte  *) ext->x_scn.x_nlinno)
#endif
#ifndef GET_LINENO_LNNO
#define GET_LINENO_LNNO(abfd, ext) bfd_h_get_16(abfd, (bfd_byte *) (ext->l_lnno));
#endif
#ifndef PUT_LINENO_LNNO
#define PUT_LINENO_LNNO(abfd,val, ext) bfd_h_put_16(abfd,val,  (bfd_byte *) (ext->l_lnno));
#endif

/* The f_symptr field in the filehdr is sometimes 64 bits.  */
#ifndef GET_FILEHDR_SYMPTR
#define GET_FILEHDR_SYMPTR bfd_h_get_32
#endif
#ifndef PUT_FILEHDR_SYMPTR
#define PUT_FILEHDR_SYMPTR bfd_h_put_32
#endif

/* Some fields in the aouthdr are sometimes 64 bits.  */
#ifndef GET_AOUTHDR_TSIZE
#define GET_AOUTHDR_TSIZE bfd_h_get_32
#endif
#ifndef PUT_AOUTHDR_TSIZE
#define PUT_AOUTHDR_TSIZE bfd_h_put_32
#endif
#ifndef GET_AOUTHDR_DSIZE
#define GET_AOUTHDR_DSIZE bfd_h_get_32
#endif
#ifndef PUT_AOUTHDR_DSIZE
#define PUT_AOUTHDR_DSIZE bfd_h_put_32
#endif
#ifndef GET_AOUTHDR_BSIZE
#define GET_AOUTHDR_BSIZE bfd_h_get_32
#endif
#ifndef PUT_AOUTHDR_BSIZE
#define PUT_AOUTHDR_BSIZE bfd_h_put_32
#endif
#ifndef GET_AOUTHDR_ENTRY
#define GET_AOUTHDR_ENTRY bfd_h_get_32
#endif
#ifndef PUT_AOUTHDR_ENTRY
#define PUT_AOUTHDR_ENTRY bfd_h_put_32
#endif
#ifndef GET_AOUTHDR_TEXT_START
#define GET_AOUTHDR_TEXT_START bfd_h_get_32
#endif
#ifndef PUT_AOUTHDR_TEXT_START
#define PUT_AOUTHDR_TEXT_START bfd_h_put_32
#endif
#ifndef GET_AOUTHDR_DATA_START
#define GET_AOUTHDR_DATA_START bfd_h_get_32
#endif
#ifndef PUT_AOUTHDR_DATA_START
#define PUT_AOUTHDR_DATA_START bfd_h_put_32
#endif

/* Some fields in the scnhdr are sometimes 64 bits.  */
#ifndef GET_SCNHDR_PADDR
#define GET_SCNHDR_PADDR bfd_h_get_32
#endif
#ifndef PUT_SCNHDR_PADDR
#define PUT_SCNHDR_PADDR bfd_h_put_32
#endif
#ifndef GET_SCNHDR_VADDR
#define GET_SCNHDR_VADDR bfd_h_get_32
#endif
#ifndef PUT_SCNHDR_VADDR
#define PUT_SCNHDR_VADDR bfd_h_put_32
#endif
#ifndef GET_SCNHDR_SIZE
#define GET_SCNHDR_SIZE bfd_h_get_32
#endif
#ifndef PUT_SCNHDR_SIZE
#define PUT_SCNHDR_SIZE bfd_h_put_32
#endif
#ifndef GET_SCNHDR_SCNPTR
#define GET_SCNHDR_SCNPTR bfd_h_get_32
#endif
#ifndef PUT_SCNHDR_SCNPTR
#define PUT_SCNHDR_SCNPTR bfd_h_put_32
#endif
#ifndef GET_SCNHDR_RELPTR
#define GET_SCNHDR_RELPTR bfd_h_get_32
#endif
#ifndef PUT_SCNHDR_RELPTR
#define PUT_SCNHDR_RELPTR bfd_h_put_32
#endif
#ifndef GET_SCNHDR_LNNOPTR
#define GET_SCNHDR_LNNOPTR bfd_h_get_32
#endif
#ifndef PUT_SCNHDR_LNNOPTR
#define PUT_SCNHDR_LNNOPTR bfd_h_put_32
#endif

#ifndef NO_COFF_RELOCS
static void coff_swap_reloc_in PARAMS ((bfd *, PTR, PTR));
static unsigned int coff_swap_reloc_out PARAMS ((bfd *, PTR, PTR));
#endif
static void coff_swap_filehdr_in PARAMS ((bfd *, PTR, PTR));
static unsigned int coff_swap_filehdr_out PARAMS ((bfd *, PTR, PTR));
static void coff_swap_sym_in PARAMS ((bfd *, PTR, PTR));
static unsigned int coff_swap_sym_out PARAMS ((bfd *, PTR, PTR));
static void coff_swap_aux_in PARAMS ((bfd *, PTR, int, int, int, int, PTR));
static unsigned int coff_swap_aux_out
  PARAMS ((bfd *, PTR, int, int, int, int, PTR));
static void coff_swap_lineno_in PARAMS ((bfd *, PTR, PTR));
static unsigned int coff_swap_lineno_out PARAMS ((bfd *, PTR, PTR));
static void coff_swap_aouthdr_in PARAMS ((bfd *, PTR, PTR));
static void add_data_entry
  PARAMS ((bfd *, struct internal_extra_pe_aouthdr *, int, char *, bfd_vma));
static unsigned int coff_swap_aouthdr_out PARAMS ((bfd *, PTR, PTR));
static void coff_swap_scnhdr_in PARAMS ((bfd *, PTR, PTR));
static unsigned int coff_swap_scnhdr_out PARAMS ((bfd *, PTR, PTR));
static boolean pe_print_idata PARAMS ((bfd *, PTR));
static boolean pe_print_edata PARAMS ((bfd *, PTR));
static boolean pe_print_pdata PARAMS ((bfd *, PTR));
static boolean pe_print_reloc PARAMS ((bfd *, PTR));
static boolean pe_print_private_bfd_data PARAMS ((bfd *, PTR));
static boolean pe_mkobject PARAMS ((bfd *));
static PTR pe_mkobject_hook PARAMS ((bfd *, PTR, PTR));
static boolean pe_bfd_copy_private_bfd_data PARAMS ((bfd *, bfd *));

#ifdef COFF_IMAGE_WITH_PE
/* This structure contains static variables used by the ILF code.  */
typedef asection * asection_ptr;

typedef struct
{
  bfd *			abfd;
  bfd_byte *		data;
  struct bfd_in_memory * bim;
  unsigned short        magic;
  
  arelent *		reltab;
  unsigned int 		relcount;

  coff_symbol_type * 	sym_cache;
  coff_symbol_type * 	sym_ptr;
  unsigned int       	sym_index;
  
  unsigned int * 	sym_table;
  unsigned int * 	table_ptr;
  
  combined_entry_type * native_syms;
  combined_entry_type * native_ptr;

  coff_symbol_type **	sym_ptr_table;
  coff_symbol_type **	sym_ptr_ptr;
  
  unsigned int		sec_index;

  char *                string_table;
  char *                string_ptr;
  char *		end_string_ptr;
  
  SYMENT *              esym_table;
  SYMENT *              esym_ptr;

  struct internal_reloc * int_reltab;
}
pe_ILF_vars;

static asection_ptr       pe_ILF_make_a_section   PARAMS ((pe_ILF_vars *, const char *, unsigned int, flagword));
static void               pe_ILF_make_a_reloc     PARAMS ((pe_ILF_vars *, bfd_vma, bfd_reloc_code_real_type, asection_ptr));
static void               pe_ILF_make_a_symbol    PARAMS ((pe_ILF_vars *, const char *, const char *, asection_ptr, flagword));
static void               pe_ILF_save_relocs      PARAMS ((pe_ILF_vars *, asection_ptr));
static void		  pe_ILF_make_a_symbol_reloc  PARAMS ((pe_ILF_vars *, bfd_vma, bfd_reloc_code_real_type,	   struct symbol_cache_entry **, unsigned int));
static boolean            pe_ILF_build_a_bfd      PARAMS ((bfd *, unsigned short, bfd_byte *, bfd_byte *, unsigned int, unsigned int));
static const bfd_target * pe_ILF_object_p         PARAMS ((bfd *));
static const bfd_target * pe_bfd_object_p 	  PARAMS ((bfd *));
#endif /* COFF_IMAGE_WITH_PE */

/**********************************************************************/

#ifndef NO_COFF_RELOCS
static void
coff_swap_reloc_in (abfd, src, dst)
     bfd *abfd;
     PTR src;
     PTR dst;
{
  RELOC *reloc_src = (RELOC *) src;
  struct internal_reloc *reloc_dst = (struct internal_reloc *) dst;

  reloc_dst->r_vaddr = bfd_h_get_32(abfd, (bfd_byte *)reloc_src->r_vaddr);
  reloc_dst->r_symndx = bfd_h_get_signed_32(abfd, (bfd_byte *) reloc_src->r_symndx);

  reloc_dst->r_type = bfd_h_get_16(abfd, (bfd_byte *) reloc_src->r_type);

#ifdef SWAP_IN_RELOC_OFFSET
  reloc_dst->r_offset = SWAP_IN_RELOC_OFFSET(abfd,
					     (bfd_byte *) reloc_src->r_offset);
#endif
}


static unsigned int
coff_swap_reloc_out (abfd, src, dst)
     bfd       *abfd;
     PTR	src;
     PTR	dst;
{
  struct internal_reloc *reloc_src = (struct internal_reloc *)src;
  struct external_reloc *reloc_dst = (struct external_reloc *)dst;
  bfd_h_put_32(abfd, reloc_src->r_vaddr, (bfd_byte *) reloc_dst->r_vaddr);
  bfd_h_put_32(abfd, reloc_src->r_symndx, (bfd_byte *) reloc_dst->r_symndx);

  bfd_h_put_16(abfd, reloc_src->r_type, (bfd_byte *)
	       reloc_dst->r_type);

#ifdef SWAP_OUT_RELOC_OFFSET
  SWAP_OUT_RELOC_OFFSET(abfd,
			reloc_src->r_offset,
			(bfd_byte *) reloc_dst->r_offset);
#endif
#ifdef SWAP_OUT_RELOC_EXTRA
  SWAP_OUT_RELOC_EXTRA(abfd,reloc_src, reloc_dst);
#endif
  return RELSZ;
}
#endif /* not NO_COFF_RELOCS */

static void
coff_swap_filehdr_in (abfd, src, dst)
     bfd            *abfd;
     PTR	     src;
     PTR	     dst;
{
  FILHDR *filehdr_src = (FILHDR *) src;
  struct internal_filehdr *filehdr_dst = (struct internal_filehdr *) dst;
  filehdr_dst->f_magic = bfd_h_get_16(abfd, (bfd_byte *) filehdr_src->f_magic);
  filehdr_dst->f_nscns = bfd_h_get_16(abfd, (bfd_byte *)filehdr_src-> f_nscns);
  filehdr_dst->f_timdat = bfd_h_get_32(abfd, (bfd_byte *)filehdr_src-> f_timdat);

  filehdr_dst->f_nsyms = bfd_h_get_32(abfd, (bfd_byte *)filehdr_src-> f_nsyms);
  filehdr_dst->f_flags = bfd_h_get_16(abfd, (bfd_byte *)filehdr_src-> f_flags);
  filehdr_dst->f_symptr = bfd_h_get_32 (abfd, (bfd_byte *) filehdr_src->f_symptr);

#ifdef COFF_IMAGE_WITH_PE
  /* There are really two magic numbers involved; the magic number
     that says this is a NT executable (PEI) and the magic number that
     determines the architecture.  The former is DOSMAGIC, stored in
     the e_magic field.  The latter is stored in the f_magic field.
     If the NT magic number isn't valid, the architecture magic number
     could be mimicked by some other field (specifically, the number
     of relocs in section 3).  Since this routine can only be called
     correctly for a PEI file, check the e_magic number here, and, if
     it doesn't match, clobber the f_magic number so that we don't get
     a false match.  */
  if (bfd_h_get_16 (abfd, (bfd_byte *) filehdr_src->e_magic) != DOSMAGIC)
    filehdr_dst->f_magic = -1;
#endif

  /* Other people's tools sometimes generate headers with an nsyms but
     a zero symptr.  */
  if (filehdr_dst->f_nsyms != 0 && filehdr_dst->f_symptr == 0)
    {
      filehdr_dst->f_nsyms = 0;
      filehdr_dst->f_flags |= F_LSYMS;
    }

  filehdr_dst->f_opthdr = bfd_h_get_16(abfd, 
				       (bfd_byte *)filehdr_src-> f_opthdr);
}

#ifdef COFF_IMAGE_WITH_PE

static  unsigned int
coff_swap_filehdr_out (abfd, in, out)
     bfd       *abfd;
     PTR	in;
     PTR	out;
{
  int idx;
  struct internal_filehdr *filehdr_in = (struct internal_filehdr *)in;
  FILHDR *filehdr_out = (FILHDR *)out;

  if (pe_data (abfd)->has_reloc_section)
    filehdr_in->f_flags &= ~F_RELFLG;

  if (pe_data (abfd)->dll)
    filehdr_in->f_flags |= F_DLL;

  filehdr_in->pe.e_magic    = DOSMAGIC;
  filehdr_in->pe.e_cblp     = 0x90;
  filehdr_in->pe.e_cp       = 0x3;
  filehdr_in->pe.e_crlc     = 0x0;
  filehdr_in->pe.e_cparhdr  = 0x4;
  filehdr_in->pe.e_minalloc = 0x0;
  filehdr_in->pe.e_maxalloc = 0xffff;
  filehdr_in->pe.e_ss       = 0x0;
  filehdr_in->pe.e_sp       = 0xb8;
  filehdr_in->pe.e_csum     = 0x0;
  filehdr_in->pe.e_ip       = 0x0;
  filehdr_in->pe.e_cs       = 0x0;
  filehdr_in->pe.e_lfarlc   = 0x40;
  filehdr_in->pe.e_ovno     = 0x0;

  for (idx=0; idx < 4; idx++)
    filehdr_in->pe.e_res[idx] = 0x0;

  filehdr_in->pe.e_oemid   = 0x0;
  filehdr_in->pe.e_oeminfo = 0x0;

  for (idx=0; idx < 10; idx++)
    filehdr_in->pe.e_res2[idx] = 0x0;

  filehdr_in->pe.e_lfanew = 0x80;

  /* this next collection of data are mostly just characters.  It appears
     to be constant within the headers put on NT exes */
  filehdr_in->pe.dos_message[0]  = 0x0eba1f0e;
  filehdr_in->pe.dos_message[1]  = 0xcd09b400;
  filehdr_in->pe.dos_message[2]  = 0x4c01b821;
  filehdr_in->pe.dos_message[3]  = 0x685421cd;
  filehdr_in->pe.dos_message[4]  = 0x70207369;
  filehdr_in->pe.dos_message[5]  = 0x72676f72;
  filehdr_in->pe.dos_message[6]  = 0x63206d61;
  filehdr_in->pe.dos_message[7]  = 0x6f6e6e61;
  filehdr_in->pe.dos_message[8]  = 0x65622074;
  filehdr_in->pe.dos_message[9]  = 0x6e757220;
  filehdr_in->pe.dos_message[10] = 0x206e6920;
  filehdr_in->pe.dos_message[11] = 0x20534f44;
  filehdr_in->pe.dos_message[12] = 0x65646f6d;
  filehdr_in->pe.dos_message[13] = 0x0a0d0d2e;
  filehdr_in->pe.dos_message[14] = 0x24;
  filehdr_in->pe.dos_message[15] = 0x0;
  filehdr_in->pe.nt_signature = NT_SIGNATURE;



  bfd_h_put_16(abfd, filehdr_in->f_magic, (bfd_byte *) filehdr_out->f_magic);
  bfd_h_put_16(abfd, filehdr_in->f_nscns, (bfd_byte *) filehdr_out->f_nscns);

  bfd_h_put_32(abfd, time (0), (bfd_byte *) filehdr_out->f_timdat);
  PUT_FILEHDR_SYMPTR (abfd, (bfd_vma) filehdr_in->f_symptr,
		      (bfd_byte *) filehdr_out->f_symptr);
  bfd_h_put_32(abfd, filehdr_in->f_nsyms, (bfd_byte *) filehdr_out->f_nsyms);
  bfd_h_put_16(abfd, filehdr_in->f_opthdr, (bfd_byte *) filehdr_out->f_opthdr);
  bfd_h_put_16(abfd, filehdr_in->f_flags, (bfd_byte *) filehdr_out->f_flags);

  /* put in extra dos header stuff.  This data remains essentially
     constant, it just has to be tacked on to the beginning of all exes 
     for NT */
  bfd_h_put_16(abfd, filehdr_in->pe.e_magic, (bfd_byte *) filehdr_out->e_magic);
  bfd_h_put_16(abfd, filehdr_in->pe.e_cblp, (bfd_byte *) filehdr_out->e_cblp);
  bfd_h_put_16(abfd, filehdr_in->pe.e_cp, (bfd_byte *) filehdr_out->e_cp);
  bfd_h_put_16(abfd, filehdr_in->pe.e_crlc, (bfd_byte *) filehdr_out->e_crlc);
  bfd_h_put_16(abfd, filehdr_in->pe.e_cparhdr, 
	       (bfd_byte *) filehdr_out->e_cparhdr);
  bfd_h_put_16(abfd, filehdr_in->pe.e_minalloc, 
	       (bfd_byte *) filehdr_out->e_minalloc);
  bfd_h_put_16(abfd, filehdr_in->pe.e_maxalloc, 
	       (bfd_byte *) filehdr_out->e_maxalloc);
  bfd_h_put_16(abfd, filehdr_in->pe.e_ss, (bfd_byte *) filehdr_out->e_ss);
  bfd_h_put_16(abfd, filehdr_in->pe.e_sp, (bfd_byte *) filehdr_out->e_sp);
  bfd_h_put_16(abfd, filehdr_in->pe.e_csum, (bfd_byte *) filehdr_out->e_csum);
  bfd_h_put_16(abfd, filehdr_in->pe.e_ip, (bfd_byte *) filehdr_out->e_ip);
  bfd_h_put_16(abfd, filehdr_in->pe.e_cs, (bfd_byte *) filehdr_out->e_cs);
  bfd_h_put_16(abfd, filehdr_in->pe.e_lfarlc, (bfd_byte *) filehdr_out->e_lfarlc);
  bfd_h_put_16(abfd, filehdr_in->pe.e_ovno, (bfd_byte *) filehdr_out->e_ovno);
  {
    int idx;
    for (idx=0; idx < 4; idx++)
      bfd_h_put_16(abfd, filehdr_in->pe.e_res[idx], 
		   (bfd_byte *) filehdr_out->e_res[idx]);
  }
  bfd_h_put_16(abfd, filehdr_in->pe.e_oemid, (bfd_byte *) filehdr_out->e_oemid);
  bfd_h_put_16(abfd, filehdr_in->pe.e_oeminfo,
	       (bfd_byte *) filehdr_out->e_oeminfo);
  {
    int idx;
    for (idx=0; idx < 10; idx++)
      bfd_h_put_16(abfd, filehdr_in->pe.e_res2[idx],
		   (bfd_byte *) filehdr_out->e_res2[idx]);
  }
  bfd_h_put_32(abfd, filehdr_in->pe.e_lfanew, (bfd_byte *) filehdr_out->e_lfanew);

  {
    int idx;
    for (idx=0; idx < 16; idx++)
      bfd_h_put_32(abfd, filehdr_in->pe.dos_message[idx],
		   (bfd_byte *) filehdr_out->dos_message[idx]);
  }

  /* also put in the NT signature */
  bfd_h_put_32(abfd, filehdr_in->pe.nt_signature, 
	       (bfd_byte *) filehdr_out->nt_signature);




  return FILHSZ;
}
#else

static  unsigned int
coff_swap_filehdr_out (abfd, in, out)
     bfd       *abfd;
     PTR	in;
     PTR	out;
{
  struct internal_filehdr *filehdr_in = (struct internal_filehdr *)in;
  FILHDR *filehdr_out = (FILHDR *)out;

  bfd_h_put_16(abfd, filehdr_in->f_magic, (bfd_byte *) filehdr_out->f_magic);
  bfd_h_put_16(abfd, filehdr_in->f_nscns, (bfd_byte *) filehdr_out->f_nscns);
  bfd_h_put_32(abfd, filehdr_in->f_timdat, (bfd_byte *) filehdr_out->f_timdat);
  PUT_FILEHDR_SYMPTR (abfd, (bfd_vma) filehdr_in->f_symptr,
		      (bfd_byte *) filehdr_out->f_symptr);
  bfd_h_put_32(abfd, filehdr_in->f_nsyms, (bfd_byte *) filehdr_out->f_nsyms);
  bfd_h_put_16(abfd, filehdr_in->f_opthdr, (bfd_byte *) filehdr_out->f_opthdr);
  bfd_h_put_16(abfd, filehdr_in->f_flags, (bfd_byte *) filehdr_out->f_flags);

  return FILHSZ;
}

#endif


static void
coff_swap_sym_in (abfd, ext1, in1)
     bfd            *abfd;
     PTR ext1;
     PTR in1;
{
  SYMENT *ext = (SYMENT *)ext1;
  struct internal_syment      *in = (struct internal_syment *)in1;

  if( ext->e.e_name[0] == 0) {
    in->_n._n_n._n_zeroes = 0;
    in->_n._n_n._n_offset = bfd_h_get_32(abfd, (bfd_byte *) ext->e.e.e_offset);
  }
  else {
#if SYMNMLEN != E_SYMNMLEN
    -> Error, we need to cope with truncating or extending SYMNMLEN!;
#else
    memcpy(in->_n._n_name, ext->e.e_name, SYMNMLEN);
#endif
  }

  in->n_value = bfd_h_get_32(abfd, (bfd_byte *) ext->e_value); 
  in->n_scnum = bfd_h_get_16(abfd, (bfd_byte *) ext->e_scnum);
  if (sizeof(ext->e_type) == 2){
    in->n_type = bfd_h_get_16(abfd, (bfd_byte *) ext->e_type);
  }
  else {
    in->n_type = bfd_h_get_32(abfd, (bfd_byte *) ext->e_type);
  }
  in->n_sclass = bfd_h_get_8(abfd, ext->e_sclass);
  in->n_numaux = bfd_h_get_8(abfd, ext->e_numaux);

  /* The section symbols for the .idata$ sections have class 0x68
     (C_SECTION), which MS documentation indicates is a section
     symbol.  Unfortunately, the value field in the symbol is simply a
     copy of the .idata section's flags rather than something useful.
     When these symbols are encountered, change the value to 0 so that
     they will be handled somewhat correctly in the bfd code.  */
  if (in->n_sclass == C_SECTION)
    {
      in->n_value = 0x0;

#if 0
      /* FIXME: This is clearly wrong.  The problem seems to be that
         undefined C_SECTION symbols appear in the first object of a
         MS generated .lib file, and the symbols are not defined
         anywhere.  */
      in->n_scnum = 1;

      /* I have tried setting the class to 3 and using the following
	 to set the section number.  This will put the address of the
	 pointer to the string kernel32.dll at addresses 0 and 0x10
	 off start of idata section which is not correct */
      /*    if (strcmp (in->_n._n_name, ".idata$4") == 0) */
      /*      in->n_scnum = 3; */
      /*    else */
      /*      in->n_scnum = 2; */
#else
      /* Create synthetic empty sections as needed.  DJ */
      if (in->n_scnum == 0)
	{
	  asection *sec;
	  for (sec=abfd->sections; sec; sec=sec->next)
	    {
	      if (strcmp (sec->name, in->n_name) == 0)
		{
		  in->n_scnum = sec->target_index;
		  break;
		}
	    }
	}
      if (in->n_scnum == 0)
	{
	  int unused_section_number = 0;
	  asection *sec;
	  char *name;
	  for (sec=abfd->sections; sec; sec=sec->next)
	    if (unused_section_number <= sec->target_index)
	      unused_section_number = sec->target_index+1;

	  name = bfd_alloc (abfd, strlen (in->n_name) + 10);
	  if (name == NULL)
	    return;
	  strcpy (name, in->n_name);
	  sec = bfd_make_section_anyway (abfd, name);

	  sec->vma = 0;
	  sec->lma = 0;
	  sec->_cooked_size = 0;
	  sec->_raw_size = 0;
	  sec->filepos = 0;
	  sec->rel_filepos = 0;
	  sec->reloc_count = 0;
	  sec->line_filepos = 0;
	  sec->lineno_count = 0;
	  sec->userdata = NULL;
	  sec->next = (asection *) NULL;
	  sec->flags = 0;
	  sec->alignment_power = 2;
	  sec->flags = SEC_HAS_CONTENTS | SEC_ALLOC | SEC_DATA | SEC_LOAD;

	  sec->target_index = unused_section_number;

	  in->n_scnum = unused_section_number;
	}
      in->n_sclass = C_STAT;
#endif
    }

#ifdef coff_swap_sym_in_hook
  coff_swap_sym_in_hook(abfd, ext1, in1);
#endif
}

static unsigned int
coff_swap_sym_out (abfd, inp, extp)
     bfd       *abfd;
     PTR	inp;
     PTR	extp;
{
  struct internal_syment *in = (struct internal_syment *)inp;
  SYMENT *ext =(SYMENT *)extp;
  if(in->_n._n_name[0] == 0) {
    bfd_h_put_32(abfd, 0, (bfd_byte *) ext->e.e.e_zeroes);
    bfd_h_put_32(abfd, in->_n._n_n._n_offset, (bfd_byte *)  ext->e.e.e_offset);
  }
  else {
#if SYMNMLEN != E_SYMNMLEN
    -> Error, we need to cope with truncating or extending SYMNMLEN!;
#else
    memcpy(ext->e.e_name, in->_n._n_name, SYMNMLEN);
#endif
  }

  bfd_h_put_32(abfd,  in->n_value , (bfd_byte *) ext->e_value);
  bfd_h_put_16(abfd,  in->n_scnum , (bfd_byte *) ext->e_scnum);
  if (sizeof(ext->e_type) == 2)
    {
      bfd_h_put_16(abfd,  in->n_type , (bfd_byte *) ext->e_type);
    }
  else
    {
      bfd_h_put_32(abfd,  in->n_type , (bfd_byte *) ext->e_type);
    }
  bfd_h_put_8(abfd,  in->n_sclass , ext->e_sclass);
  bfd_h_put_8(abfd,  in->n_numaux , ext->e_numaux);

  return SYMESZ;
}

static void
coff_swap_aux_in (abfd, ext1, type, class, indx, numaux, in1)
     bfd            *abfd;
     PTR 	      ext1;
     int             type;
     int             class;
     int	      indx ATTRIBUTE_UNUSED;
     int	      numaux ATTRIBUTE_UNUSED;
     PTR 	      in1;
{
  AUXENT    *ext = (AUXENT *)ext1;
  union internal_auxent *in = (union internal_auxent *)in1;

  switch (class) {
  case C_FILE:
    if (ext->x_file.x_fname[0] == 0) {
      in->x_file.x_n.x_zeroes = 0;
      in->x_file.x_n.x_offset = 
	bfd_h_get_32(abfd, (bfd_byte *) ext->x_file.x_n.x_offset);
    } else {
#if FILNMLEN != E_FILNMLEN
      -> Error, we need to cope with truncating or extending FILNMLEN!;
#else
      memcpy (in->x_file.x_fname, ext->x_file.x_fname, FILNMLEN);
#endif
    }
    return;


  case C_STAT:
#ifdef C_LEAFSTAT
  case C_LEAFSTAT:
#endif
  case C_HIDDEN:
    if (type == T_NULL) {
      in->x_scn.x_scnlen = GET_SCN_SCNLEN(abfd, ext);
      in->x_scn.x_nreloc = GET_SCN_NRELOC(abfd, ext);
      in->x_scn.x_nlinno = GET_SCN_NLINNO(abfd, ext);
      in->x_scn.x_checksum = bfd_h_get_32 (abfd,
					   (bfd_byte *) ext->x_scn.x_checksum);
      in->x_scn.x_associated =
	bfd_h_get_16 (abfd, (bfd_byte *) ext->x_scn.x_associated);
      in->x_scn.x_comdat = bfd_h_get_8 (abfd,
					(bfd_byte *) ext->x_scn.x_comdat);
      return;
    }
    break;
  }

  in->x_sym.x_tagndx.l = bfd_h_get_32(abfd, (bfd_byte *) ext->x_sym.x_tagndx);
#ifndef NO_TVNDX
  in->x_sym.x_tvndx = bfd_h_get_16(abfd, (bfd_byte *) ext->x_sym.x_tvndx);
#endif

  if (class == C_BLOCK || class == C_FCN || ISFCN (type) || ISTAG (class))
    {
      in->x_sym.x_fcnary.x_fcn.x_lnnoptr = GET_FCN_LNNOPTR (abfd, ext);
      in->x_sym.x_fcnary.x_fcn.x_endndx.l = GET_FCN_ENDNDX (abfd, ext);
    }
  else
    {
#if DIMNUM != E_DIMNUM
 #error we need to cope with truncating or extending DIMNUM
#endif
      in->x_sym.x_fcnary.x_ary.x_dimen[0] =
	bfd_h_get_16 (abfd, (bfd_byte *) ext->x_sym.x_fcnary.x_ary.x_dimen[0]);
      in->x_sym.x_fcnary.x_ary.x_dimen[1] =
	bfd_h_get_16 (abfd, (bfd_byte *) ext->x_sym.x_fcnary.x_ary.x_dimen[1]);
      in->x_sym.x_fcnary.x_ary.x_dimen[2] =
	bfd_h_get_16 (abfd, (bfd_byte *) ext->x_sym.x_fcnary.x_ary.x_dimen[2]);
      in->x_sym.x_fcnary.x_ary.x_dimen[3] =
	bfd_h_get_16 (abfd, (bfd_byte *) ext->x_sym.x_fcnary.x_ary.x_dimen[3]);
    }

  if (ISFCN(type)) {
    in->x_sym.x_misc.x_fsize = bfd_h_get_32(abfd, (bfd_byte *) ext->x_sym.x_misc.x_fsize);
  }
  else {
    in->x_sym.x_misc.x_lnsz.x_lnno = GET_LNSZ_LNNO(abfd, ext);
    in->x_sym.x_misc.x_lnsz.x_size = GET_LNSZ_SIZE(abfd, ext);
  }
}

static unsigned int
coff_swap_aux_out (abfd, inp, type, class, indx, numaux, extp)
     bfd   *abfd;
     PTR 	inp;
     int   type;
     int   class;
     int   indx ATTRIBUTE_UNUSED;
     int   numaux ATTRIBUTE_UNUSED;
     PTR	extp;
{
  union internal_auxent *in = (union internal_auxent *)inp;
  AUXENT *ext = (AUXENT *)extp;

  memset((PTR)ext, 0, AUXESZ);
  switch (class) {
  case C_FILE:
    if (in->x_file.x_fname[0] == 0) {
      bfd_h_put_32(abfd, 0, (bfd_byte *) ext->x_file.x_n.x_zeroes);
      bfd_h_put_32(abfd,
	      in->x_file.x_n.x_offset,
	      (bfd_byte *) ext->x_file.x_n.x_offset);
    }
    else {
#if FILNMLEN != E_FILNMLEN
      -> Error, we need to cope with truncating or extending FILNMLEN!;
#else
      memcpy (ext->x_file.x_fname, in->x_file.x_fname, FILNMLEN);
#endif
    }
    return AUXESZ;


  case C_STAT:
#ifdef C_LEAFSTAT
  case C_LEAFSTAT:
#endif
  case C_HIDDEN:
    if (type == T_NULL) {
      PUT_SCN_SCNLEN(abfd, in->x_scn.x_scnlen, ext);
      PUT_SCN_NRELOC(abfd, in->x_scn.x_nreloc, ext);
      PUT_SCN_NLINNO(abfd, in->x_scn.x_nlinno, ext);
      bfd_h_put_32 (abfd, in->x_scn.x_checksum,
		    (bfd_byte *) ext->x_scn.x_checksum);
      bfd_h_put_16 (abfd, in->x_scn.x_associated,
		    (bfd_byte *) ext->x_scn.x_associated);
      bfd_h_put_8 (abfd, in->x_scn.x_comdat,
		   (bfd_byte *) ext->x_scn.x_comdat);
      return AUXESZ;
    }
    break;
  }

  bfd_h_put_32(abfd, in->x_sym.x_tagndx.l, (bfd_byte *) ext->x_sym.x_tagndx);
#ifndef NO_TVNDX
  bfd_h_put_16(abfd, in->x_sym.x_tvndx , (bfd_byte *) ext->x_sym.x_tvndx);
#endif

  if (class == C_BLOCK || class == C_FCN || ISFCN (type) || ISTAG (class))
    {
      PUT_FCN_LNNOPTR(abfd,  in->x_sym.x_fcnary.x_fcn.x_lnnoptr, ext);
      PUT_FCN_ENDNDX(abfd,  in->x_sym.x_fcnary.x_fcn.x_endndx.l, ext);
    }
  else
    {
#if DIMNUM != E_DIMNUM
 #error we need to cope with truncating or extending DIMNUM
#endif
      bfd_h_put_16 (abfd, in->x_sym.x_fcnary.x_ary.x_dimen[0],
		    (bfd_byte *) ext->x_sym.x_fcnary.x_ary.x_dimen[0]);
      bfd_h_put_16 (abfd, in->x_sym.x_fcnary.x_ary.x_dimen[1],
		    (bfd_byte *) ext->x_sym.x_fcnary.x_ary.x_dimen[1]);
      bfd_h_put_16 (abfd, in->x_sym.x_fcnary.x_ary.x_dimen[2],
		    (bfd_byte *) ext->x_sym.x_fcnary.x_ary.x_dimen[2]);
      bfd_h_put_16 (abfd, in->x_sym.x_fcnary.x_ary.x_dimen[3],
		    (bfd_byte *) ext->x_sym.x_fcnary.x_ary.x_dimen[3]);
    }

  if (ISFCN (type))
    bfd_h_put_32 (abfd, in->x_sym.x_misc.x_fsize,
	     (bfd_byte *)  ext->x_sym.x_misc.x_fsize);
  else
    {
      PUT_LNSZ_LNNO (abfd, in->x_sym.x_misc.x_lnsz.x_lnno, ext);
      PUT_LNSZ_SIZE (abfd, in->x_sym.x_misc.x_lnsz.x_size, ext);
    }

  return AUXESZ;
}


static void
coff_swap_lineno_in (abfd, ext1, in1)
     bfd            *abfd;
     PTR ext1;
     PTR in1;
{
  LINENO *ext = (LINENO *)ext1;
  struct internal_lineno      *in = (struct internal_lineno *)in1;

  in->l_addr.l_symndx = bfd_h_get_32(abfd, (bfd_byte *) ext->l_addr.l_symndx);
  in->l_lnno = GET_LINENO_LNNO(abfd, ext);
}

static unsigned int
coff_swap_lineno_out (abfd, inp, outp)
     bfd       *abfd;
     PTR	inp;
     PTR	outp;
{
  struct internal_lineno *in = (struct internal_lineno *)inp;
  struct external_lineno *ext = (struct external_lineno *)outp;
  bfd_h_put_32(abfd, in->l_addr.l_symndx, (bfd_byte *)
	  ext->l_addr.l_symndx);

  PUT_LINENO_LNNO (abfd, in->l_lnno, ext);
  return LINESZ;
}



static void
coff_swap_aouthdr_in (abfd, aouthdr_ext1, aouthdr_int1)
     bfd            *abfd;
     PTR aouthdr_ext1;
     PTR aouthdr_int1;
{
  struct internal_extra_pe_aouthdr *a;
  PEAOUTHDR *src = (PEAOUTHDR *)(aouthdr_ext1);
  AOUTHDR        *aouthdr_ext = (AOUTHDR *) aouthdr_ext1;
  struct internal_aouthdr *aouthdr_int = (struct internal_aouthdr *)aouthdr_int1;

  aouthdr_int->magic = bfd_h_get_16(abfd, (bfd_byte *) aouthdr_ext->magic);
  aouthdr_int->vstamp = bfd_h_get_16(abfd, (bfd_byte *) aouthdr_ext->vstamp);
  aouthdr_int->tsize =
    GET_AOUTHDR_TSIZE (abfd, (bfd_byte *) aouthdr_ext->tsize);
  aouthdr_int->dsize =
    GET_AOUTHDR_DSIZE (abfd, (bfd_byte *) aouthdr_ext->dsize);
  aouthdr_int->bsize =
    GET_AOUTHDR_BSIZE (abfd, (bfd_byte *) aouthdr_ext->bsize);
  aouthdr_int->entry =
    GET_AOUTHDR_ENTRY (abfd, (bfd_byte *) aouthdr_ext->entry);
  aouthdr_int->text_start =
    GET_AOUTHDR_TEXT_START (abfd, (bfd_byte *) aouthdr_ext->text_start);
  aouthdr_int->data_start =
    GET_AOUTHDR_DATA_START (abfd, (bfd_byte *) aouthdr_ext->data_start);

  a = &aouthdr_int->pe;
  a->ImageBase = bfd_h_get_32 (abfd, (bfd_byte *) src->ImageBase);
  a->SectionAlignment = bfd_h_get_32 (abfd, (bfd_byte *) src->SectionAlignment);
  a->FileAlignment = bfd_h_get_32 (abfd, (bfd_byte *) src->FileAlignment);
  a->MajorOperatingSystemVersion = 
    bfd_h_get_16 (abfd, (bfd_byte *) src->MajorOperatingSystemVersion);
  a->MinorOperatingSystemVersion = 
    bfd_h_get_16 (abfd, (bfd_byte *) src->MinorOperatingSystemVersion);
  a->MajorImageVersion = bfd_h_get_16 (abfd, (bfd_byte *) src->MajorImageVersion);
  a->MinorImageVersion = bfd_h_get_16 (abfd, (bfd_byte *) src->MinorImageVersion);
  a->MajorSubsystemVersion = bfd_h_get_16 (abfd, (bfd_byte *) src->MajorSubsystemVersion);
  a->MinorSubsystemVersion = bfd_h_get_16 (abfd, (bfd_byte *) src->MinorSubsystemVersion);
  a->Reserved1 = bfd_h_get_32 (abfd, (bfd_byte *) src->Reserved1);
  a->SizeOfImage = bfd_h_get_32 (abfd, (bfd_byte *) src->SizeOfImage);
  a->SizeOfHeaders = bfd_h_get_32 (abfd, (bfd_byte *) src->SizeOfHeaders);
  a->CheckSum = bfd_h_get_32 (abfd, (bfd_byte *) src->CheckSum);
  a->Subsystem = bfd_h_get_16 (abfd, (bfd_byte *) src->Subsystem);
  a->DllCharacteristics = bfd_h_get_16 (abfd, (bfd_byte *) src->DllCharacteristics);
  a->SizeOfStackReserve = bfd_h_get_32 (abfd, (bfd_byte *) src->SizeOfStackReserve);
  a->SizeOfStackCommit = bfd_h_get_32 (abfd, (bfd_byte *) src->SizeOfStackCommit);
  a->SizeOfHeapReserve = bfd_h_get_32 (abfd, (bfd_byte *) src->SizeOfHeapReserve);
  a->SizeOfHeapCommit = bfd_h_get_32 (abfd, (bfd_byte *) src->SizeOfHeapCommit);
  a->LoaderFlags = bfd_h_get_32 (abfd, (bfd_byte *) src->LoaderFlags);
  a->NumberOfRvaAndSizes = bfd_h_get_32 (abfd, (bfd_byte *) src->NumberOfRvaAndSizes);

  {
    int idx;
    for (idx=0; idx < 16; idx++)
      {
	a->DataDirectory[idx].VirtualAddress =
	  bfd_h_get_32 (abfd, (bfd_byte *) src->DataDirectory[idx][0]);
	a->DataDirectory[idx].Size =
	  bfd_h_get_32 (abfd, (bfd_byte *) src->DataDirectory[idx][1]);
      }
  }

  if (aouthdr_int->entry)
    {
      aouthdr_int->entry += a->ImageBase;
      aouthdr_int->entry &= 0xffffffff;
    }
  if (aouthdr_int->tsize) 
    {
      aouthdr_int->text_start += a->ImageBase;
      aouthdr_int->text_start &= 0xffffffff;
    }
  if (aouthdr_int->dsize) 
    {
      aouthdr_int->data_start += a->ImageBase;
      aouthdr_int->data_start &= 0xffffffff;
    }

#ifdef POWERPC_LE_PE
  /* These three fields are normally set up by ppc_relocate_section.
     In the case of reading a file in, we can pick them up from
     the DataDirectory.
  */
  first_thunk_address = a->DataDirectory[12].VirtualAddress ;
  thunk_size = a->DataDirectory[12].Size;
  import_table_size = a->DataDirectory[1].Size;
#endif
}


static void add_data_entry (abfd, aout, idx, name, base)
     bfd *abfd;
     struct internal_extra_pe_aouthdr *aout;
     int idx;
     char *name;
     bfd_vma base;
{
  asection *sec = bfd_get_section_by_name (abfd, name);

  /* add import directory information if it exists */
  if ((sec != NULL)
      && (coff_section_data (abfd, sec) != NULL)
      && (pei_section_data (abfd, sec) != NULL))
    {
      aout->DataDirectory[idx].VirtualAddress = (sec->vma - base) & 0xffffffff;
      aout->DataDirectory[idx].Size = pei_section_data (abfd, sec)->virt_size;
      sec->flags |= SEC_DATA;
    }
}

static unsigned int
coff_swap_aouthdr_out (abfd, in, out)
     bfd       *abfd;
     PTR	in;
     PTR	out;
{
  struct internal_aouthdr *aouthdr_in = (struct internal_aouthdr *)in;
  struct internal_extra_pe_aouthdr *extra = &pe_data (abfd)->pe_opthdr;
  PEAOUTHDR *aouthdr_out = (PEAOUTHDR *)out;

  bfd_vma sa = extra->SectionAlignment;
  bfd_vma fa = extra->FileAlignment;
  bfd_vma ib = extra->ImageBase ;

  if (aouthdr_in->tsize) 
    {
      aouthdr_in->text_start -= ib;
      aouthdr_in->text_start &= 0xffffffff;
    }
  if (aouthdr_in->dsize) 
    {
      aouthdr_in->data_start -= ib;
      aouthdr_in->data_start &= 0xffffffff;
    }
  if (aouthdr_in->entry) 
    {
      aouthdr_in->entry -= ib;
      aouthdr_in->entry &= 0xffffffff;
    }

#define FA(x)  (((x) + fa -1 ) & (- fa))
#define SA(x)  (((x) + sa -1 ) & (- sa))

  /* We like to have the sizes aligned */

  aouthdr_in->bsize = FA (aouthdr_in->bsize);


  extra->NumberOfRvaAndSizes = IMAGE_NUMBEROF_DIRECTORY_ENTRIES;

  /* first null out all data directory entries .. */
  memset (extra->DataDirectory, sizeof (extra->DataDirectory), 0);

  add_data_entry (abfd, extra, 0, ".edata", ib);
  add_data_entry (abfd, extra, 1, ".idata", ib);
  add_data_entry (abfd, extra, 2, ".rsrc" ,ib);

#ifdef POWERPC_LE_PE
  /* FIXME: do other PE platforms use this? */
  add_data_entry (abfd, extra, 3, ".pdata" ,ib);
#endif

  add_data_entry (abfd, extra, 5, ".reloc", ib);

#ifdef POWERPC_LE_PE
  /* On the PPC NT system, this field is set up as follows. It is
     not an "officially" reserved field, so it currently has no title.
     first_thunk_address is idata$5, and the thunk_size is the size
     of the idata$5 chunk of the idata section.
  */
  extra->DataDirectory[12].VirtualAddress = first_thunk_address;
  extra->DataDirectory[12].Size = thunk_size;

  /* On the PPC NT system, the size of the directory entry is not the
     size of the entire section. It's actually offset to the end of 
     the idata$3 component of the idata section. This is the size of
     the entire import table. (also known as the start of idata$4)
  */
  extra->DataDirectory[1].Size = import_table_size;
#endif

  {
    asection *sec;
    bfd_vma dsize= 0;
    bfd_vma isize = SA(abfd->sections->filepos);
    bfd_vma tsize= 0;

    for (sec = abfd->sections; sec; sec = sec->next)
      {
	int rounded = FA(sec->_raw_size);

	if (sec->flags & SEC_DATA) 
	  dsize += rounded;
	if (sec->flags & SEC_CODE)
	  tsize += rounded;
	isize += SA(rounded);
      }

    aouthdr_in->dsize = dsize;
    aouthdr_in->tsize = tsize;
    extra->SizeOfImage = isize;
  }

  extra->SizeOfHeaders = abfd->sections->filepos;
  bfd_h_put_16(abfd, aouthdr_in->magic, (bfd_byte *) aouthdr_out->standard.magic);

#ifdef POWERPC_LE_PE
  /* this little piece of magic sets the "linker version" field to 2.60 */
  bfd_h_put_16(abfd, 2  + 60 * 256, (bfd_byte *) aouthdr_out->standard.vstamp);
#else
  /* this little piece of magic sets the "linker version" field to 2.55 */
  bfd_h_put_16(abfd, 2  + 55 * 256, (bfd_byte *) aouthdr_out->standard.vstamp);
#endif

  PUT_AOUTHDR_TSIZE (abfd, aouthdr_in->tsize, (bfd_byte *) aouthdr_out->standard.tsize);
  PUT_AOUTHDR_DSIZE (abfd, aouthdr_in->dsize, (bfd_byte *) aouthdr_out->standard.dsize);
  PUT_AOUTHDR_BSIZE (abfd, aouthdr_in->bsize, (bfd_byte *) aouthdr_out->standard.bsize);
  PUT_AOUTHDR_ENTRY (abfd, aouthdr_in->entry, (bfd_byte *) aouthdr_out->standard.entry);
  PUT_AOUTHDR_TEXT_START (abfd, aouthdr_in->text_start,
			  (bfd_byte *) aouthdr_out->standard.text_start);

  PUT_AOUTHDR_DATA_START (abfd, aouthdr_in->data_start,
			  (bfd_byte *) aouthdr_out->standard.data_start);


  bfd_h_put_32 (abfd, extra->ImageBase, 
		(bfd_byte *) aouthdr_out->ImageBase);
  bfd_h_put_32 (abfd, extra->SectionAlignment,
		(bfd_byte *) aouthdr_out->SectionAlignment);
  bfd_h_put_32 (abfd, extra->FileAlignment,
		(bfd_byte *) aouthdr_out->FileAlignment);
  bfd_h_put_16 (abfd, extra->MajorOperatingSystemVersion,
		(bfd_byte *) aouthdr_out->MajorOperatingSystemVersion);
  bfd_h_put_16 (abfd, extra->MinorOperatingSystemVersion,
		(bfd_byte *) aouthdr_out->MinorOperatingSystemVersion);
  bfd_h_put_16 (abfd, extra->MajorImageVersion,
		(bfd_byte *) aouthdr_out->MajorImageVersion);
  bfd_h_put_16 (abfd, extra->MinorImageVersion,
		(bfd_byte *) aouthdr_out->MinorImageVersion);
  bfd_h_put_16 (abfd, extra->MajorSubsystemVersion,
		(bfd_byte *) aouthdr_out->MajorSubsystemVersion);
  bfd_h_put_16 (abfd, extra->MinorSubsystemVersion,
		(bfd_byte *) aouthdr_out->MinorSubsystemVersion);
  bfd_h_put_32 (abfd, extra->Reserved1,
		(bfd_byte *) aouthdr_out->Reserved1);
  bfd_h_put_32 (abfd, extra->SizeOfImage,
		(bfd_byte *) aouthdr_out->SizeOfImage);
  bfd_h_put_32 (abfd, extra->SizeOfHeaders,
		(bfd_byte *) aouthdr_out->SizeOfHeaders);
  bfd_h_put_32 (abfd, extra->CheckSum,
		(bfd_byte *) aouthdr_out->CheckSum);
  bfd_h_put_16 (abfd, extra->Subsystem,
		(bfd_byte *) aouthdr_out->Subsystem);
  bfd_h_put_16 (abfd, extra->DllCharacteristics,
		(bfd_byte *) aouthdr_out->DllCharacteristics);
  bfd_h_put_32 (abfd, extra->SizeOfStackReserve,
		(bfd_byte *) aouthdr_out->SizeOfStackReserve);
  bfd_h_put_32 (abfd, extra->SizeOfStackCommit,
		(bfd_byte *) aouthdr_out->SizeOfStackCommit);
  bfd_h_put_32 (abfd, extra->SizeOfHeapReserve,
		(bfd_byte *) aouthdr_out->SizeOfHeapReserve);
  bfd_h_put_32 (abfd, extra->SizeOfHeapCommit,
		(bfd_byte *) aouthdr_out->SizeOfHeapCommit);
  bfd_h_put_32 (abfd, extra->LoaderFlags,
		(bfd_byte *) aouthdr_out->LoaderFlags);
  bfd_h_put_32 (abfd, extra->NumberOfRvaAndSizes,
		(bfd_byte *) aouthdr_out->NumberOfRvaAndSizes);
  {
    int idx;
    for (idx=0; idx < 16; idx++)
      {
	bfd_h_put_32 (abfd, extra->DataDirectory[idx].VirtualAddress,
		      (bfd_byte *) aouthdr_out->DataDirectory[idx][0]);
	bfd_h_put_32 (abfd, extra->DataDirectory[idx].Size,
		      (bfd_byte *) aouthdr_out->DataDirectory[idx][1]);
      }
  }

  return AOUTSZ;
}

static void
coff_swap_scnhdr_in (abfd, ext, in)
  bfd *      abfd;
  PTR	     ext;
  PTR	     in;
{
  SCNHDR *scnhdr_ext = (SCNHDR *) ext;
  struct internal_scnhdr *scnhdr_int = (struct internal_scnhdr *) in;

  memcpy(scnhdr_int->s_name, scnhdr_ext->s_name, sizeof(scnhdr_int->s_name));
  scnhdr_int->s_vaddr =
    GET_SCNHDR_VADDR (abfd, (bfd_byte *) scnhdr_ext->s_vaddr);
  scnhdr_int->s_paddr =
    GET_SCNHDR_PADDR (abfd, (bfd_byte *) scnhdr_ext->s_paddr);
  scnhdr_int->s_size =
    GET_SCNHDR_SIZE (abfd, (bfd_byte *) scnhdr_ext->s_size);
  scnhdr_int->s_scnptr =
    GET_SCNHDR_SCNPTR (abfd, (bfd_byte *) scnhdr_ext->s_scnptr);
  scnhdr_int->s_relptr =
    GET_SCNHDR_RELPTR (abfd, (bfd_byte *) scnhdr_ext->s_relptr);
  scnhdr_int->s_lnnoptr =
    GET_SCNHDR_LNNOPTR (abfd, (bfd_byte *) scnhdr_ext->s_lnnoptr);
  scnhdr_int->s_flags = bfd_h_get_32(abfd, (bfd_byte *) scnhdr_ext->s_flags);

  scnhdr_int->s_nreloc = bfd_h_get_16(abfd, (bfd_byte *) scnhdr_ext->s_nreloc);
  scnhdr_int->s_nlnno = bfd_h_get_16(abfd, (bfd_byte *) scnhdr_ext->s_nlnno);

  if (scnhdr_int->s_vaddr != 0) 
    {
      scnhdr_int->s_vaddr += pe_data (abfd)->pe_opthdr.ImageBase;
      scnhdr_int->s_vaddr &= 0xffffffff;
    }
#ifndef COFF_NO_HACK_SCNHDR_SIZE
  if (strcmp (scnhdr_int->s_name, _BSS) == 0) 
    {
      scnhdr_int->s_size = scnhdr_int->s_paddr;
      scnhdr_int->s_paddr = 0;
    }
#endif
}

static unsigned int
coff_swap_scnhdr_out (abfd, in, out)
     bfd       *abfd;
     PTR	in;
     PTR	out;
{
  struct internal_scnhdr *scnhdr_int = (struct internal_scnhdr *)in;
  SCNHDR *scnhdr_ext = (SCNHDR *)out;
  unsigned int ret = SCNHSZ;
  bfd_vma ps;
  bfd_vma ss;

  memcpy(scnhdr_ext->s_name, scnhdr_int->s_name, sizeof(scnhdr_int->s_name));

  PUT_SCNHDR_VADDR (abfd, 
		    ((scnhdr_int->s_vaddr 
		      - pe_data(abfd)->pe_opthdr.ImageBase)
		     & 0xffffffff),
		    (bfd_byte *) scnhdr_ext->s_vaddr);

  /* NT wants the size data to be rounded up to the next NT_FILE_ALIGNMENT
     value except for the BSS section, its s_size should be 0 */


  if (strcmp (scnhdr_int->s_name, _BSS) == 0) 
    {
      ps = scnhdr_int->s_size;
      ss = 0;
    }
  else
    {
      ps = scnhdr_int->s_paddr;
      ss = scnhdr_int->s_size;
    }

  PUT_SCNHDR_SIZE (abfd, ss,
		   (bfd_byte *) scnhdr_ext->s_size);


  PUT_SCNHDR_PADDR (abfd, ps, (bfd_byte *) scnhdr_ext->s_paddr);

  PUT_SCNHDR_SCNPTR (abfd, scnhdr_int->s_scnptr,
		     (bfd_byte *) scnhdr_ext->s_scnptr);
  PUT_SCNHDR_RELPTR (abfd, scnhdr_int->s_relptr,
		     (bfd_byte *) scnhdr_ext->s_relptr);
  PUT_SCNHDR_LNNOPTR (abfd, scnhdr_int->s_lnnoptr,
		      (bfd_byte *) scnhdr_ext->s_lnnoptr);

  /* Extra flags must be set when dealing with NT.  All sections should also
     have the IMAGE_SCN_MEM_READ (0x40000000) flag set.  In addition, the
     .text section must have IMAGE_SCN_MEM_EXECUTE (0x20000000) and the data
     sections (.idata, .data, .bss, .CRT) must have IMAGE_SCN_MEM_WRITE set
     (this is especially important when dealing with the .idata section since
     the addresses for routines from .dlls must be overwritten).  If .reloc
     section data is ever generated, we must add IMAGE_SCN_MEM_DISCARDABLE
     (0x02000000).  Also, the resource data should also be read and
     writable.  */

  /* FIXME: alignment is also encoded in this field, at least on ppc (krk) */
  /* FIXME: even worse, I don't see how to get the original alignment field*/
  /*        back...                                                        */

  /* FIXME: Basing this on section names is bogus.  Also, this should
     be in sec_to_styp_flags.  */

  {
    int flags = scnhdr_int->s_flags;
    if (strcmp (scnhdr_int->s_name, ".data")  == 0 ||
	strcmp (scnhdr_int->s_name, ".CRT")   == 0 ||
	strcmp (scnhdr_int->s_name, ".bss")   == 0)
      flags |= IMAGE_SCN_MEM_READ | IMAGE_SCN_MEM_WRITE;
    else if (strcmp (scnhdr_int->s_name, ".text") == 0)
      flags |= IMAGE_SCN_MEM_READ | IMAGE_SCN_MEM_EXECUTE;
    else if (strcmp (scnhdr_int->s_name, ".reloc") == 0)
      flags = (SEC_DATA | IMAGE_SCN_MEM_READ | IMAGE_SCN_MEM_DISCARDABLE
	       | IMAGE_SCN_MEM_SHARED);
    else if (strcmp (scnhdr_int->s_name, ".idata") == 0)
      flags = IMAGE_SCN_MEM_READ | IMAGE_SCN_MEM_WRITE | SEC_DATA;     
    else if (strcmp (scnhdr_int->s_name, ".rdata") == 0
	     || strcmp (scnhdr_int->s_name, ".edata") == 0)
      flags =  IMAGE_SCN_MEM_READ | SEC_DATA;     
    else if (strcmp (scnhdr_int->s_name, ".pdata") == 0)
      flags = IMAGE_SCN_CNT_INITIALIZED_DATA | IMAGE_SCN_ALIGN_4BYTES |
			  IMAGE_SCN_MEM_READ ;
    /* Remember this field is a max of 8 chars, so the null is _not_ there
       for an 8 character name like ".reldata". (yep. Stupid bug) */
    else if (strncmp (scnhdr_int->s_name, ".reldata", 8) == 0)
      flags =  IMAGE_SCN_CNT_INITIALIZED_DATA | IMAGE_SCN_ALIGN_8BYTES |
	       IMAGE_SCN_MEM_READ | IMAGE_SCN_MEM_WRITE ;
    else if (strcmp (scnhdr_int->s_name, ".ydata") == 0)
      flags =  IMAGE_SCN_CNT_INITIALIZED_DATA | IMAGE_SCN_ALIGN_8BYTES |
	       IMAGE_SCN_MEM_READ | IMAGE_SCN_MEM_WRITE ;
    else if (strncmp (scnhdr_int->s_name, ".drectve", 8) == 0)
      flags =  IMAGE_SCN_LNK_INFO | IMAGE_SCN_LNK_REMOVE ;
    else if (strncmp (scnhdr_int->s_name, ".stab", 5) == 0)
      flags |= (IMAGE_SCN_LNK_INFO | IMAGE_SCN_MEM_DISCARDABLE
		| IMAGE_SCN_MEM_SHARED | IMAGE_SCN_MEM_READ);
    else if (strcmp (scnhdr_int->s_name, ".rsrc")  == 0)
      flags |= IMAGE_SCN_MEM_READ | IMAGE_SCN_MEM_SHARED;
    else
      {
	flags |= IMAGE_SCN_MEM_READ;
	if (! (flags & SEC_READONLY))
	  flags |= IMAGE_SCN_MEM_WRITE;
      }

    bfd_h_put_32(abfd, flags, (bfd_byte *) scnhdr_ext->s_flags);
  }

  if (scnhdr_int->s_nlnno <= 0xffff)
    bfd_h_put_16(abfd, scnhdr_int->s_nlnno, (bfd_byte *) scnhdr_ext->s_nlnno);
  else
    {
      (*_bfd_error_handler) (_("%s: line number overflow: 0x%lx > 0xffff"),
			     bfd_get_filename (abfd),
			     scnhdr_int->s_nlnno);
      bfd_set_error (bfd_error_file_truncated);
      bfd_h_put_16 (abfd, 0xffff, (bfd_byte *) scnhdr_ext->s_nlnno);
      ret = 0;
    }
  if (scnhdr_int->s_nreloc <= 0xffff)
    bfd_h_put_16(abfd, scnhdr_int->s_nreloc, (bfd_byte *) scnhdr_ext->s_nreloc);
  else
    {
      (*_bfd_error_handler) (_("%s: reloc overflow: 0x%lx > 0xffff"),
			     bfd_get_filename (abfd),
			     scnhdr_int->s_nreloc);
      bfd_set_error (bfd_error_file_truncated);
      bfd_h_put_16 (abfd, 0xffff, (bfd_byte *) scnhdr_ext->s_nreloc);
      ret = 0;
    }
  return ret;
}

static char * dir_names[IMAGE_NUMBEROF_DIRECTORY_ENTRIES] = 
{
  N_ ("Export Directory [.edata (or where ever we found it)]"),
  N_ ("Import Directory [parts of .idata]"),
  N_ ("Resource Directory [.rsrc]"),
  N_ ("Exception Directory [.pdata]"),
  N_ ("Security Directory"),
  N_ ("Base Relocation Directory [.reloc]"),
  N_ ("Debug Directory"),
  N_ ("Description Directory"),
  N_ ("Special Directory"),
  N_ ("Thread Storage Directory [.tls]"),
  N_ ("Load Configuration Directory"),
  N_ ("Bound Import Directory"),
  N_ ("Import Address Table Directory"),
  N_ ("Reserved"),
  N_ ("Reserved"),
  N_ ("Reserved")
};

/**********************************************************************/
static boolean
pe_print_idata(abfd, vfile)
     bfd *abfd;
     PTR vfile;
{
  FILE *file = (FILE *) vfile;
  bfd_byte *data = 0;
  asection *section = bfd_get_section_by_name (abfd, ".idata");
  unsigned long adj;

#ifdef POWERPC_LE_PE
  asection *rel_section = bfd_get_section_by_name (abfd, ".reldata");
#endif

  bfd_size_type datasize;
  bfd_size_type dataoff;
  bfd_size_type secsize;
  bfd_size_type i;
  bfd_size_type start, stop;
  int onaline = 20;

  pe_data_type *pe = pe_data (abfd);
  struct internal_extra_pe_aouthdr *extra = &pe->pe_opthdr;

  if (section != NULL)
    {
      datasize = bfd_section_size (abfd, section);
      dataoff = 0;

      if (datasize == 0)
	return true;
    }
  else
    {
      bfd_vma addr, size;

      addr = extra->DataDirectory[1].VirtualAddress;
      size = extra->DataDirectory[1].Size;

      if (addr == 0 || size == 0)
	return true;

      for (section = abfd->sections; section != NULL; section = section->next)
	{
	  if (section->vma - extra->ImageBase <= addr
	      && ((section->vma - extra->ImageBase
		   + bfd_section_size (abfd, section))
		  >= addr + size))
	    break;
	}
      if (section == NULL)
	return true;

      /* For some reason the import table size is not reliable.  The
         import data will extend past the indicated size, and before
         the indicated address.  */
      dataoff = addr - (section->vma - extra->ImageBase);
      datasize = size;
    }

#ifdef POWERPC_LE_PE
  if (rel_section != 0 && bfd_section_size (abfd, rel_section) != 0)
    {
      /* The toc address can be found by taking the starting address,
	 which on the PPC locates a function descriptor. The descriptor
	 consists of the function code starting address followed by the
	 address of the toc. The starting address we get from the bfd,
	 and the descriptor is supposed to be in the .reldata section. 
      */

      bfd_vma loadable_toc_address;
      bfd_vma toc_address;
      bfd_vma start_address;
      bfd_byte *data = 0;
      int offset;
      data = (bfd_byte *) bfd_malloc ((size_t) bfd_section_size (abfd, 
								 rel_section));
      if (data == NULL && bfd_section_size (abfd, rel_section) != 0)
	return false;

      datasize = bfd_section_size (abfd, rel_section);
  
      bfd_get_section_contents (abfd, 
				rel_section, 
				(PTR) data, 0, 
				bfd_section_size (abfd, rel_section));

      offset = abfd->start_address - rel_section->vma;

      start_address = bfd_get_32(abfd, data+offset);
      loadable_toc_address = bfd_get_32(abfd, data+offset+4);
      toc_address = loadable_toc_address - 32768;

      fprintf(file,
	      _("\nFunction descriptor located at the start address: %04lx\n"),
	      (unsigned long int) (abfd->start_address));
      fprintf (file,
	       _("\tcode-base %08lx toc (loadable/actual) %08lx/%08lx\n"), 
	       start_address, loadable_toc_address, toc_address);
    }
  else 
    {
      fprintf(file,
	      _("\nNo reldata section! Function descriptor not decoded.\n"));
    }
#endif

  fprintf(file,
	  _("\nThe Import Tables (interpreted .idata section contents)\n"));
  fprintf(file,
	  _(" vma:            Hint    Time      Forward  DLL       First\n"));
  fprintf(file,
	  _("                 Table   Stamp     Chain    Name      Thunk\n"));

  secsize = bfd_section_size (abfd, section);
  data = (bfd_byte *) bfd_malloc (secsize);
  if (data == NULL && secsize != 0)
    return false;

  if (! bfd_get_section_contents (abfd, section, (PTR) data, 0, secsize))
    return false;

  adj = (extra->ImageBase - section->vma) & 0xffffffff;

  start = dataoff;
  stop = dataoff + datasize;
  for (i = start; i < stop; i += onaline)
    {
      bfd_vma hint_addr;
      bfd_vma time_stamp;
      bfd_vma forward_chain;
      bfd_vma dll_name;
      bfd_vma first_thunk;
      int idx = 0;
      bfd_size_type j;
      char *dll;

      fprintf (file,
	       " %08lx\t", 
	       (unsigned long int) (i + section->vma + dataoff));
      
      if (i+20 > stop)
	{
	  /* check stuff */
	  ;
	}
      
      hint_addr = bfd_get_32(abfd, data+i);
      time_stamp = bfd_get_32(abfd, data+i+4);
      forward_chain = bfd_get_32(abfd, data+i+8);
      dll_name = bfd_get_32(abfd, data+i+12);
      first_thunk = bfd_get_32(abfd, data+i+16);
      
      fprintf (file, "%08lx %08lx %08lx %08lx %08lx\n",
	       hint_addr,
	       time_stamp,
	       forward_chain,
	       dll_name,
	       first_thunk);

      if (hint_addr == 0 && first_thunk == 0)
	break;

      /* The image base is present in the section->vma.  */
      dll = (char *) data + dll_name + adj;
      fprintf (file, _("\n\tDLL Name: %s\n"), dll);

      if (hint_addr != 0)
	{
	  fprintf (file, _("\tvma:  Hint/Ord Member-Name\n"));

	  idx = hint_addr + adj;

	  for (j = 0; j < stop; j += 4)
	    {
	      unsigned long member = bfd_get_32 (abfd, data + idx + j);

	      if (member == 0)
		break;
	      
	      if (member & 0x80000000UL)
		fprintf (file, "\t%04lx\t %4lu", member,
			 member & 0x7fffffff);
	      else
		{
		  bfd_byte * member_name;
		  
		  member_name = (char *) data + member + adj;

		  if (member_name > data + secsize)
		    fprintf (file, _("\t** corrupt ? %lx"), member);
		  else
		    {
		      int ordinal;
		      
		      ordinal = bfd_get_16 (abfd, data + member + adj);
		      fprintf (file, "\t%04lx\t %4d  %s",
			       member, ordinal, member_name + 2);
		    }
		}

	      /* If the time stamp is not zero, the import address
                 table holds actual addresses.  */
	      if (time_stamp != 0
		  && first_thunk != 0
		  && first_thunk != hint_addr)
		fprintf (file, "\t%04lx",
			 bfd_get_32 (abfd, data + first_thunk + adj + j));

	      fprintf (file, "\n");
	    }
	}

      if (hint_addr != first_thunk && time_stamp == 0)
	{
	  int differ = 0;
	  int idx2;

	  idx2 = first_thunk + adj;

	  for (j=0;j<stop;j+=4)
	    {
	      int ordinal;
	      bfd_vma hint_member = 0;
	      bfd_vma iat_member;

	      if (hint_addr != 0)
		hint_member = bfd_get_32 (abfd, data + idx + j);
	      if (idx2 < secsize)
		iat_member = bfd_get_32 (abfd, data + idx2 + j);
	      else
		iat_member = 0;

	      if (hint_addr == 0 && iat_member == 0)
		break;

	      if (hint_addr == 0 || hint_member != iat_member)
		{
		  if (differ == 0)
		    {
		      fprintf (file, 
			       _("\tThe Import Address Table (difference found)\n"));
		      fprintf (file, _("\tvma:  Hint/Ord Member-Name\n"));
		      differ = 1;
		    }
		  if (iat_member == 0)
		    fprintf (file, _("\t>>> Ran out of IAT members!\n"));
		  else 
		    {
		      bfd_byte * member_name;
		      
		      member_name = (char *) data + iat_member + adj;

		      if (member_name > data + secsize)
			fprintf (file, _("\t** corrupt ? %lx\n"), iat_member);
		      else
			{
			  ordinal = bfd_get_16 (abfd, member_name);
			  fprintf (file, "\t%04lx\t %4d  %s\n",
				   iat_member, ordinal, member_name + 2);
			}
		    }
		}

	      if (hint_addr != 0 && hint_member == 0)
		break;
	    }
	      
	  if (differ == 0)
	    fprintf (file, _("\tThe Import Address Table is identical\n"));
	}

      fprintf (file, "\n");
    }

  free (data);

  return true;
}

static boolean
pe_print_edata (abfd, vfile)
     bfd *abfd;
     PTR vfile;
{
  FILE *file = (FILE *) vfile;
  bfd_byte *data = 0;
  asection *section = bfd_get_section_by_name (abfd, ".edata");

  bfd_size_type datasize;
  bfd_size_type dataoff;
  bfd_size_type i;

  int adj;
  struct EDT_type 
    {
      long export_flags;             /* reserved - should be zero */
      long time_stamp;
      short major_ver;
      short minor_ver;
      bfd_vma name;                  /* rva - relative to image base */
      long base;                     /* ordinal base */
      unsigned long num_functions;   /* Number in the export address table */
      unsigned long num_names;       /* Number in the name pointer table */
      bfd_vma eat_addr;    /* rva to the export address table */
      bfd_vma npt_addr;        /* rva to the Export Name Pointer Table */
      bfd_vma ot_addr; /* rva to the Ordinal Table */
    } edt;

  pe_data_type *pe = pe_data (abfd);
  struct internal_extra_pe_aouthdr *extra = &pe->pe_opthdr;

  if (section != NULL)
    {
      datasize = bfd_section_size (abfd, section);
      dataoff = 0;
    }
  else
    {
      bfd_vma addr, size;

      addr = extra->DataDirectory[0].VirtualAddress;
      size = extra->DataDirectory[0].Size;

      if (addr == 0 || size == 0)
	return true;

      for (section = abfd->sections; section != NULL; section = section->next)
	{
	  if (section->vma - extra->ImageBase <= addr
	      && ((section->vma - extra->ImageBase
		   + bfd_section_size (abfd, section))
		  >= addr + size))
	    break;
	}
      if (section == NULL)
	return true;

      datasize = size;
      dataoff = addr - (section->vma - extra->ImageBase);
    }

  data = (bfd_byte *) bfd_malloc (datasize);
  if (data == NULL && datasize != 0)
    return false;

  if (! bfd_get_section_contents (abfd, section, (PTR) data, dataoff,
				  datasize))
    return false;

  /* Go get Export Directory Table */
  edt.export_flags   = bfd_get_32(abfd, data+0); 
  edt.time_stamp     = bfd_get_32(abfd, data+4);
  edt.major_ver      = bfd_get_16(abfd, data+8);
  edt.minor_ver      = bfd_get_16(abfd, data+10);
  edt.name           = bfd_get_32(abfd, data+12);
  edt.base           = bfd_get_32(abfd, data+16);
  edt.num_functions  = bfd_get_32(abfd, data+20); 
  edt.num_names      = bfd_get_32(abfd, data+24); 
  edt.eat_addr       = bfd_get_32(abfd, data+28);
  edt.npt_addr       = bfd_get_32(abfd, data+32); 
  edt.ot_addr        = bfd_get_32(abfd, data+36);

  adj = (extra->ImageBase - (section->vma + dataoff)) & 0xffffffff;


  /* Dump the EDT first first */
  fprintf(file,
	  _("\nThe Export Tables (interpreted .edata section contents)\n\n"));

  fprintf(file,
	  _("Export Flags \t\t\t%lx\n"), (unsigned long) edt.export_flags);

  fprintf(file,
	  _("Time/Date stamp \t\t%lx\n"), (unsigned long) edt.time_stamp);

  fprintf(file,
	  _("Major/Minor \t\t\t%d/%d\n"), edt.major_ver, edt.minor_ver);

  fprintf (file,
	   _("Name \t\t\t\t"));
  fprintf_vma (file, edt.name);
  fprintf (file,
	   " %s\n", data + edt.name + adj);

  fprintf(file,
	  _("Ordinal Base \t\t\t%ld\n"), edt.base);

  fprintf(file,
	  _("Number in:\n"));

  fprintf(file,
	  _("\tExport Address Table \t\t%lx\n"),
	  edt.num_functions);

  fprintf(file,
	  _("\t[Name Pointer/Ordinal] Table\t%lu\n"), edt.num_names);

  fprintf(file,
	  _("Table Addresses\n"));

  fprintf (file,
	   _("\tExport Address Table \t\t"));
  fprintf_vma (file, edt.eat_addr);
  fprintf (file, "\n");

  fprintf (file,
	  _("\tName Pointer Table \t\t"));
  fprintf_vma (file, edt.npt_addr);
  fprintf (file, "\n");

  fprintf (file,
	   _("\tOrdinal Table \t\t\t"));
  fprintf_vma (file, edt.ot_addr);
  fprintf (file, "\n");

  
  /* The next table to find si the Export Address Table. It's basically
     a list of pointers that either locate a function in this dll, or
     forward the call to another dll. Something like:
      typedef union 
      {
        long export_rva;
        long forwarder_rva;
      } export_address_table_entry;
  */

  fprintf(file,
	  _("\nExport Address Table -- Ordinal Base %ld\n"),
	  edt.base);

  for (i = 0; i < edt.num_functions; ++i)
    {
      bfd_vma eat_member = bfd_get_32 (abfd, 
				       data + edt.eat_addr + (i * 4) + adj);
      bfd_vma eat_actual = (extra->ImageBase + eat_member) & 0xffffffff;
      bfd_vma edata_start = bfd_get_section_vma (abfd,section) + dataoff;
      bfd_vma edata_end = edata_start + datasize;

      if (eat_member == 0)
	continue;

      if (edata_start < eat_actual && eat_actual < edata_end) 
	{
	  /* this rva is to a name (forwarding function) in our section */
	  /* Should locate a function descriptor */
	  fprintf(file,
		  "\t[%4ld] +base[%4ld] %04lx %s -- %s\n", 
		  (long) i, (long) (i + edt.base), eat_member,
		  "Forwarder RVA", data + eat_member + adj);
	}
      else
	{
	  /* Should locate a function descriptor in the reldata section */
	  fprintf(file,
		  "\t[%4ld] +base[%4ld] %04lx %s\n", 
		  (long) i, (long) (i + edt.base), eat_member, "Export RVA");
	}
    }

  /* The Export Name Pointer Table is paired with the Export Ordinal Table */
  /* Dump them in parallel for clarity */
  fprintf(file,
	  _("\n[Ordinal/Name Pointer] Table\n"));

  for (i = 0; i < edt.num_names; ++i)
    {
      bfd_vma name_ptr = bfd_get_32(abfd, 
				    data + 
				    edt.npt_addr
				    + (i*4) + adj);
      
      char *name = (char *) data + name_ptr + adj;

      bfd_vma ord = bfd_get_16(abfd, 
				    data + 
				    edt.ot_addr
				    + (i*2) + adj);
      fprintf(file,
	      "\t[%4ld] %s\n", (long) ord, name);

    }

  free (data);

  return true;
}

static boolean
pe_print_pdata (abfd, vfile)
     bfd  *abfd;
     PTR vfile;
{
  FILE *file = (FILE *) vfile;
  bfd_byte *data = 0;
  asection *section = bfd_get_section_by_name (abfd, ".pdata");
  bfd_size_type datasize = 0;
  bfd_size_type i;
  bfd_size_type start, stop;
  int onaline = 20;

  if (section == 0)
    return true;

  stop = bfd_section_size (abfd, section);
  if ((stop % onaline) != 0)
    fprintf (file, _("Warning, .pdata section size (%ld) is not a multiple of %d\n"),
	     (long)stop, onaline);

  fprintf(file,
	  _("\nThe Function Table (interpreted .pdata section contents)\n"));
  fprintf(file,
	  _(" vma:\t\tBegin    End      EH       EH       PrologEnd\n"));
  fprintf(file,
	  _("     \t\tAddress  Address  Handler  Data     Address\n"));

  if (bfd_section_size (abfd, section) == 0)
    return true;

  data = (bfd_byte *) bfd_malloc ((size_t) bfd_section_size (abfd, section));
  datasize = bfd_section_size (abfd, section);
  if (data == NULL && datasize != 0)
    return false;

  bfd_get_section_contents (abfd, 
			    section, 
			    (PTR) data, 0, 
			    bfd_section_size (abfd, section));

  start = 0;

  for (i = start; i < stop; i += onaline)
    {
      bfd_vma begin_addr;
      bfd_vma end_addr;
      bfd_vma eh_handler;
      bfd_vma eh_data;
      bfd_vma prolog_end_addr;

      if (i+20 > stop)
	  break;
      
      begin_addr = bfd_get_32(abfd, data+i);
      end_addr = bfd_get_32(abfd, data+i+4);
      eh_handler = bfd_get_32(abfd, data+i+8);
      eh_data = bfd_get_32(abfd, data+i+12);
      prolog_end_addr = bfd_get_32(abfd, data+i+16);
      
      if (begin_addr == 0 && end_addr == 0 && eh_handler == 0
	  && eh_data == 0 && prolog_end_addr == 0)
	{
	  /* We are probably into the padding of the
	     section now */
	  break;
	}

      fprintf (file,
	       " %08lx\t", 
	       (unsigned long int) (i + section->vma));

      fprintf(file, "%08lx %08lx %08lx %08lx %08lx",
	      begin_addr,
	      end_addr,
	      eh_handler,
	      eh_data,
	      prolog_end_addr);

#ifdef POWERPC_LE_PE
      if (eh_handler == 0 && eh_data != 0)
	{
	  /* Special bits here, although the meaning may */
	  /* be a little mysterious. The only one I know */
	  /* for sure is 0x03.                           */
	  /* Code Significance                           */
	  /* 0x00 None                                   */
	  /* 0x01 Register Save Millicode                */
	  /* 0x02 Register Restore Millicode             */
	  /* 0x03 Glue Code Sequence                     */
	  switch (eh_data)
	    {
	    case 0x01:
	      fprintf(file, _(" Register save millicode"));
	      break;
	    case 0x02:
	      fprintf(file, _(" Register restore millicode"));
	      break;
	    case 0x03:
	      fprintf(file, _(" Glue code sequence"));
	      break;
	    default:
	      break;
	    }
	}
#endif	   
      fprintf(file, "\n");
    }

  free (data);

  return true;
}

#define IMAGE_REL_BASED_HIGHADJ 4
static const char *tbl[6] =
{
"ABSOLUTE",
"HIGH",
"LOW",
"HIGHLOW",
"HIGHADJ",
"MIPS_JMPADDR"
};

static boolean
pe_print_reloc (abfd, vfile)
     bfd *abfd;
     PTR vfile;
{
  FILE *file = (FILE *) vfile;
  bfd_byte *data = 0;
  asection *section = bfd_get_section_by_name (abfd, ".reloc");
  bfd_size_type datasize = 0;
  bfd_size_type i;
  bfd_size_type start, stop;

  if (section == 0)
    return true;

  if (bfd_section_size (abfd, section) == 0)
    return true;

  fprintf(file,
	  _("\n\nPE File Base Relocations (interpreted .reloc section contents)\n"));

  data = (bfd_byte *) bfd_malloc ((size_t) bfd_section_size (abfd, section));
  datasize = bfd_section_size (abfd, section);
  if (data == NULL && datasize != 0)
    return false;

  bfd_get_section_contents (abfd, 
			    section, 
			    (PTR) data, 0, 
			    bfd_section_size (abfd, section));

  start = 0;

  stop = bfd_section_size (abfd, section);

  for (i = start; i < stop;)
    {
      int j;
      bfd_vma virtual_address;
      long number, size;

      /* The .reloc section is a sequence of blocks, with a header consisting
	 of two 32 bit quantities, followed by a number of 16 bit entries */

      virtual_address = bfd_get_32(abfd, data+i);
      size = bfd_get_32(abfd, data+i+4);
      number = (size - 8) / 2;

      if (size == 0) 
	{
	  break;
	}

      fprintf (file,
	       _("\nVirtual Address: %08lx Chunk size %ld (0x%lx) Number of fixups %ld\n"),
	       virtual_address, size, size, number);

      for (j = 0; j < number; ++j)
	{
	  unsigned short e = bfd_get_16(abfd, data + i + 8 + j*2);
	  int t =   (e & 0xF000) >> 12;
	  int off = e & 0x0FFF;

	  if (t > 5) 
	    abort();

	  fprintf (file,
		   _("\treloc %4d offset %4x [%4lx] %s"), 
		   j, off, (long) (off + virtual_address), tbl[t]);
	  
	  /* HIGHADJ takes an argument, - the next record *is* the
	     low 16 bits of addend.  */ 
	  if (t == IMAGE_REL_BASED_HIGHADJ)
	    {
	       fprintf (file, " (%4x)",
			((unsigned int)
			 bfd_get_16 (abfd, data + i + 8 + j * 2 + 2)));
	       j++;
	    }
	  
	  fprintf (file, "\n");
	}
      i += size;
    }

  free (data);

  return true;
}

static boolean
pe_print_private_bfd_data (abfd, vfile)
     bfd *abfd;
     PTR vfile;
{
  FILE *file = (FILE *) vfile;
  int j;
  pe_data_type *pe = pe_data (abfd);
  struct internal_extra_pe_aouthdr *i = &pe->pe_opthdr;

  /* The MS dumpbin program reportedly ands with 0xff0f before
     printing the characteristics field.  Not sure why.  No reason to
     emulate it here.  */
  fprintf (file, _("\nCharacteristics 0x%x\n"), pe->real_flags);
#undef PF
#define PF(x, y)    if (pe->real_flags & x) { fprintf (file, "\t%s\n", y); }
  PF (F_RELFLG, "relocations stripped");
  PF (F_EXEC, "executable");
  PF (F_LNNO, "line numbers stripped");
  PF (F_LSYMS, "symbols stripped");
  PF (0x80, "little endian");
  PF (F_AR32WR, "32 bit words");
  PF (0x200, "debugging information removed");
  PF (0x1000, "system file");
  PF (F_DLL, "DLL");
  PF (0x8000, "big endian");
#undef PF

  fprintf (file,"\nImageBase\t\t");
  fprintf_vma (file, i->ImageBase);
  fprintf (file,"\nSectionAlignment\t");
  fprintf_vma (file, i->SectionAlignment);
  fprintf (file,"\nFileAlignment\t\t");
  fprintf_vma (file, i->FileAlignment);
  fprintf (file,"\nMajorOSystemVersion\t%d\n", i->MajorOperatingSystemVersion);
  fprintf (file,"MinorOSystemVersion\t%d\n", i->MinorOperatingSystemVersion);
  fprintf (file,"MajorImageVersion\t%d\n", i->MajorImageVersion);
  fprintf (file,"MinorImageVersion\t%d\n", i->MinorImageVersion);
  fprintf (file,"MajorSubsystemVersion\t%d\n", i->MajorSubsystemVersion);
  fprintf (file,"MinorSubsystemVersion\t%d\n", i->MinorSubsystemVersion);
  fprintf (file,"Reserved1\t\t%08lx\n", i->Reserved1);
  fprintf (file,"SizeOfImage\t\t%08lx\n", i->SizeOfImage);
  fprintf (file,"SizeOfHeaders\t\t%08lx\n", i->SizeOfHeaders);
  fprintf (file,"CheckSum\t\t%08lx\n", i->CheckSum);
  fprintf (file,"Subsystem\t\t%08x\n", i->Subsystem);
  fprintf (file,"DllCharacteristics\t%08x\n", i->DllCharacteristics);
  fprintf (file,"SizeOfStackReserve\t");
  fprintf_vma (file, i->SizeOfStackReserve);
  fprintf (file,"\nSizeOfStackCommit\t");
  fprintf_vma (file, i->SizeOfStackCommit);
  fprintf (file,"\nSizeOfHeapReserve\t");
  fprintf_vma (file, i->SizeOfHeapReserve);
  fprintf (file,"\nSizeOfHeapCommit\t");
  fprintf_vma (file, i->SizeOfHeapCommit);
  fprintf (file,"\nLoaderFlags\t\t%08lx\n", i->LoaderFlags);
  fprintf (file,"NumberOfRvaAndSizes\t%08lx\n", i->NumberOfRvaAndSizes);

  fprintf (file,"\nThe Data Directory\n");
  for (j = 0; j < IMAGE_NUMBEROF_DIRECTORY_ENTRIES; j++) 
    {
      fprintf (file, "Entry %1x ", j);
      fprintf_vma (file, i->DataDirectory[j].VirtualAddress);
      fprintf (file, " %08lx ", i->DataDirectory[j].Size);
      fprintf (file, "%s\n", dir_names[j]);
    }

  pe_print_idata (abfd, vfile);
  pe_print_edata (abfd, vfile);
  pe_print_pdata (abfd, vfile);
  pe_print_reloc (abfd, vfile);

  if (pe_saved_coff_bfd_print_private_bfd_data != NULL)
    {
      fputc ('\n', file);
  
      return pe_saved_coff_bfd_print_private_bfd_data (abfd, vfile);
    }

  return true;
}

static boolean
pe_mkobject (abfd)
     bfd * abfd;
{
  pe_data_type *pe;
  abfd->tdata.pe_obj_data = 
    (struct pe_tdata *) bfd_zalloc (abfd, sizeof (pe_data_type));

  if (abfd->tdata.pe_obj_data == 0)
    return false;

  pe = pe_data (abfd);

  pe->coff.pe = 1;
  pe->in_reloc_p = in_reloc_p;
  return true;
}

/* Create the COFF backend specific information.  */
static PTR
pe_mkobject_hook (abfd, filehdr, aouthdr)
     bfd * abfd;
     PTR filehdr;
     PTR aouthdr ATTRIBUTE_UNUSED;
{
  struct internal_filehdr *internal_f = (struct internal_filehdr *) filehdr;
  pe_data_type *pe;

  if (pe_mkobject (abfd) == false)
    return NULL;

  pe = pe_data (abfd);
  pe->coff.sym_filepos = internal_f->f_symptr;
  /* These members communicate important constants about the symbol
     table to GDB's symbol-reading code.  These `constants'
     unfortunately vary among coff implementations...  */
  pe->coff.local_n_btmask = N_BTMASK;
  pe->coff.local_n_btshft = N_BTSHFT;
  pe->coff.local_n_tmask = N_TMASK;
  pe->coff.local_n_tshift = N_TSHIFT;
  pe->coff.local_symesz = SYMESZ;
  pe->coff.local_auxesz = AUXESZ;
  pe->coff.local_linesz = LINESZ;

  obj_raw_syment_count (abfd) =
    obj_conv_table_size (abfd) =
      internal_f->f_nsyms;

  pe->real_flags = internal_f->f_flags;

  if ((internal_f->f_flags & F_DLL) != 0)
    pe->dll = 1;

#ifdef COFF_IMAGE_WITH_PE
  if (aouthdr) 
    pe->pe_opthdr = ((struct internal_aouthdr *)aouthdr)->pe;
#endif

#ifdef ARM 
  if (! _bfd_coff_arm_set_private_flags (abfd, internal_f->f_flags))
    coff_data (abfd) ->flags = 0;
#endif
  
  return (PTR) pe;
}



/* Copy any private info we understand from the input bfd
   to the output bfd.  */

#ifdef coff_bfd_copy_private_bfd_data
static boolean (*pe_saved_coff_bfd_copy_private_bfd_data)
     PARAMS ((bfd *, bfd *))
     = coff_bfd_copy_private_bfd_data;
#undef coff_bfd_copy_private_bfd_data
#else
static boolean (*pe_saved_coff_bfd_copy_private_bfd_data)
     PARAMS ((bfd *, bfd *))
     = NULL;
#endif
#define coff_bfd_copy_private_bfd_data pe_bfd_copy_private_bfd_data

static boolean
pe_bfd_copy_private_bfd_data (ibfd, obfd)
     bfd *ibfd, *obfd;
{
  /* One day we may try to grok other private data.  */
  if (ibfd->xvec->flavour != bfd_target_coff_flavour
      || obfd->xvec->flavour != bfd_target_coff_flavour)
    return true;

  pe_data (obfd)->pe_opthdr = pe_data (ibfd)->pe_opthdr;
  pe_data (obfd)->dll = pe_data (ibfd)->dll;

  if (pe_saved_coff_bfd_copy_private_bfd_data)
    return pe_saved_coff_bfd_copy_private_bfd_data (ibfd, obfd);
  
  return true;
}

#ifdef COFF_IMAGE_WITH_PE

/* Copy private section data.  */

#define coff_bfd_copy_private_section_data pe_bfd_copy_private_section_data

static boolean pe_bfd_copy_private_section_data
  PARAMS ((bfd *, asection *, bfd *, asection *));

static boolean
pe_bfd_copy_private_section_data (ibfd, isec, obfd, osec)
     bfd *ibfd;
     asection *isec;
     bfd *obfd;
     asection *osec;
{
  if (bfd_get_flavour (ibfd) != bfd_target_coff_flavour
      || bfd_get_flavour (obfd) != bfd_target_coff_flavour)
    return true;

  if (coff_section_data (ibfd, isec) != NULL
      && pei_section_data (ibfd, isec) != NULL)
    {
      if (coff_section_data (obfd, osec) == NULL)
	{
	  osec->used_by_bfd =
	    (PTR) bfd_zalloc (obfd, sizeof (struct coff_section_tdata));
	  if (osec->used_by_bfd == NULL)
	    return false;
	}
      if (pei_section_data (obfd, osec) == NULL)
	{
	  coff_section_data (obfd, osec)->tdata =
	    (PTR) bfd_zalloc (obfd, sizeof (struct pei_section_tdata));
	  if (coff_section_data (obfd, osec)->tdata == NULL)
	    return false;
	}
      pei_section_data (obfd, osec)->virt_size =
	pei_section_data (ibfd, isec)->virt_size;
    }

  return true;
}


/* Code to handle Microsoft's Image Library Format.
   Also known as LINK6 format.
   Documentation about this format can be found at: 

   http://msdn.microsoft.com/library/specs/pecoff_section8.htm  */

/* The following constants specify the sizes of the various data
   structures that we have to create in order to build a bfd describing
   an ILF object file.  The final "+ 1" in the definitions of SIZEOF_IDATA6
   and SIZEOF_IDATA7 below is to allow for the possibility that we might
   need a padding byte in order to ensure 16 bit alignment for the section's
   contents.

   The value for SIZEOF_ILF_STRINGS is computed as follows:

      There will be NUM_ILF_SECTIONS section symbols.  Allow 9 characters
      per symbol for their names (longest section name is .idata$x).

      There will be two symbols for the imported value, one the symbol name
      and one with _imp__ prefixed.  Allowing for the terminating nul's this
      is strlen (symbol_name) * 2 + 8 + 21 + strlen (source_dll).

      The strings in the string table must start STRING__SIZE_SIZE bytes into
      the table in order to for the string lookup code in coffgen/coffcode to
      work.  */
#define NUM_ILF_RELOCS		8
#define NUM_ILF_SECTIONS        6
#define NUM_ILF_SYMS 		(2 + NUM_ILF_SECTIONS)
  
#define SIZEOF_ILF_SYMS		(NUM_ILF_SYMS * sizeof (* vars.sym_cache))
#define SIZEOF_ILF_SYM_TABLE	(NUM_ILF_SYMS * sizeof (* vars.sym_table))
#define SIZEOF_ILF_NATIVE_SYMS	(NUM_ILF_SYMS * sizeof (* vars.native_syms))
#define SIZEOF_ILF_SYM_PTR_TABLE (NUM_ILF_SYMS * sizeof (* vars.sym_ptr_table))
#define SIZEOF_ILF_EXT_SYMS	(NUM_ILF_SYMS * sizeof (* vars.esym_table))
#define SIZEOF_ILF_RELOCS	(NUM_ILF_RELOCS * sizeof (* vars.reltab))
#define SIZEOF_ILF_INT_RELOCS	(NUM_ILF_RELOCS * sizeof (* vars.int_reltab))
#define SIZEOF_ILF_STRINGS	(strlen (symbol_name) * 2 + 8 \
					+ 21 + strlen (source_dll) \
					+ NUM_ILF_SECTIONS * 9 \
					+ STRING_SIZE_SIZE)
#define SIZEOF_IDATA2		(5 * 4)
#define SIZEOF_IDATA4		(1 * 4)
#define SIZEOF_IDATA5		(1 * 4)
#define SIZEOF_IDATA6		(2 + strlen (symbol_name) + 1 + 1)
#define SIZEOF_IDATA7		(strlen (source_dll) + 1 + 1)
#define SIZEOF_ILF_SECTIONS     (NUM_ILF_SECTIONS * sizeof (struct coff_section_tdata))
  
#define ILF_DATA_SIZE				\
      sizeof (* vars.bim)			\
    + SIZEOF_ILF_SYMS				\
    + SIZEOF_ILF_SYM_TABLE			\
    + SIZEOF_ILF_NATIVE_SYMS			\
    + SIZEOF_ILF_SYM_PTR_TABLE			\
    + SIZEOF_ILF_EXT_SYMS			\
    + SIZEOF_ILF_RELOCS				\
    + SIZEOF_ILF_INT_RELOCS			\
    + SIZEOF_ILF_STRINGS			\
    + SIZEOF_IDATA2				\
    + SIZEOF_IDATA4				\
    + SIZEOF_IDATA5				\
    + SIZEOF_IDATA6				\
    + SIZEOF_IDATA7				\
    + SIZEOF_ILF_SECTIONS			\
    + MAX_TEXT_SECTION_SIZE


/* Create an empty relocation against the given symbol.  */
static void
pe_ILF_make_a_symbol_reloc (pe_ILF_vars *                 vars,
			    bfd_vma                       address,
			    bfd_reloc_code_real_type      reloc,
			    struct symbol_cache_entry **  sym,
			    unsigned int                  sym_index)
{
  arelent * entry;
  struct internal_reloc * internal;

  entry = vars->reltab + vars->relcount;
  internal = vars->int_reltab + vars->relcount;
  
  entry->address     = address;
  entry->addend      = 0;
  entry->howto       = bfd_reloc_type_lookup (vars->abfd, reloc);
  entry->sym_ptr_ptr = sym;

  internal->r_vaddr  = address;
  internal->r_symndx = sym_index;
  internal->r_type   = entry->howto->type;
#if 0  /* These fields do not need to be initialised.  */
  internal->r_size   = 0;
  internal->r_extern = 0;
  internal->r_offset = 0;
#endif
  
  vars->relcount ++;
  
  BFD_ASSERT (vars->relcount <= NUM_ILF_RELOCS);
}

/* Create an empty relocation against the given section.  */
static void
pe_ILF_make_a_reloc (pe_ILF_vars *             vars,
		     bfd_vma                   address,
		     bfd_reloc_code_real_type  reloc,
		     asection_ptr              sec)
{
  pe_ILF_make_a_symbol_reloc (vars, address, reloc, sec->symbol_ptr_ptr,
			      coff_section_data (vars->abfd, sec)->i);
}

/* Move the queued relocs into the given section.  */
static void
pe_ILF_save_relocs (pe_ILF_vars * vars,
		    asection_ptr  sec)
{
  /* Make sure that there is somewhere to store the internal relocs.  */
  if (coff_section_data (vars->abfd, sec) == NULL)
    /* We should probably return an error indication here.  */
    abort ();

  coff_section_data (vars->abfd, sec)->relocs = vars->int_reltab;
  coff_section_data (vars->abfd, sec)->keep_relocs = true;

  sec->relocation  = vars->reltab;
  sec->reloc_count = vars->relcount;
  sec->flags      |= SEC_RELOC;

  vars->reltab     += vars->relcount;
  vars->int_reltab += vars->relcount;
  vars->relcount   = 0;

  BFD_ASSERT ((bfd_byte *)vars->int_reltab < (bfd_byte *)vars->string_table);
}

/* Create a global symbol and add it to the relevant tables.  */
static void
pe_ILF_make_a_symbol (pe_ILF_vars *  vars,
		      const char *   prefix,
		      const char *   symbol_name,
		      asection_ptr   section,
		      flagword       extra_flags)
{
  coff_symbol_type * sym;
  combined_entry_type * ent;
  SYMENT * esym;
  unsigned short sclass;

  if (extra_flags & BSF_LOCAL)
    sclass = C_STAT;
  else
    sclass = C_EXT;
  
#ifdef THUMBPEMAGIC  
  if (vars->magic == THUMBPEMAGIC)
    {
      if (extra_flags & BSF_FUNCTION)
	sclass = C_THUMBEXTFUNC;
      else if (extra_flags & BSF_LOCAL)
	sclass = C_THUMBSTAT;
      else
	sclass = C_THUMBEXT;
    }
#endif

  BFD_ASSERT (vars->sym_index < NUM_ILF_SYMS);
  
  sym = vars->sym_ptr;
  ent = vars->native_ptr;
  esym = vars->esym_ptr;

  /* Copy the symbol's name into the string table.  */
  sprintf (vars->string_ptr, "%s%s", prefix, symbol_name);

  if (section == NULL)
    section = (asection_ptr) & bfd_und_section;
  
  /* Initialise the external symbol.  */
  bfd_h_put_32 (vars->abfd, vars->string_ptr - vars->string_table, (bfd_byte *) esym->e.e.e_offset);
  bfd_h_put_16 (vars->abfd, section->target_index, (bfd_byte *) esym->e_scnum);
  esym->e_sclass[0] = sclass;

  /* The following initialisations are unnecessary - the memory is
     zero initialised.  They are just kept here as reminders.  */
#if 0
  esym->e.e.e_zeroes = 0;
  esym->e_value = 0;
  esym->e_type = T_NULL;
  esym->e_numaux = 0;
#endif
  
  /* Initialise the internal symbol structure.  */
  ent->u.syment.n_sclass          = sclass;
  ent->u.syment.n_scnum           = section->target_index;
  ent->u.syment._n._n_n._n_offset = (long) sym;
  
#if 0 /* See comment above.  */
  ent->u.syment.n_value  = 0;
  ent->u.syment.n_flags  = 0;
  ent->u.syment.n_type   = T_NULL;
  ent->u.syment.n_numaux = 0;
  ent->fix_value         = 0;
#endif
  
  sym->symbol.the_bfd = vars->abfd;
  sym->symbol.name    = vars->string_ptr;
  sym->symbol.flags   = BSF_EXPORT | BSF_GLOBAL | extra_flags;
  sym->symbol.section = section;
  sym->native         = ent;
  
#if 0 /* See comment above.  */
  sym->symbol.value   = 0;
  sym->symbol.udata.i = 0;
  sym->done_lineno    = false;
  sym->lineno         = NULL;
#endif
  
  * vars->table_ptr = vars->sym_index;
  * vars->sym_ptr_ptr = sym;
  
  /* Adjust pointers for the next symbol.  */
  vars->sym_index ++;
  vars->sym_ptr ++;
  vars->sym_ptr_ptr ++;
  vars->table_ptr ++;
  vars->native_ptr ++;
  vars->esym_ptr ++;
  vars->string_ptr += strlen (symbol_name) + strlen (prefix) + 1;

  BFD_ASSERT (vars->string_ptr < vars->end_string_ptr);
}

/* Create a section.  */
static asection_ptr
pe_ILF_make_a_section (pe_ILF_vars * vars,
		       const char *  name,
		       unsigned int  size,
		       flagword      extra_flags)
{
  asection_ptr sec;
  flagword     flags;
  
  sec = bfd_make_section_old_way (vars->abfd, name);
  if (sec == NULL)
    return NULL;
  
  flags = SEC_HAS_CONTENTS | SEC_ALLOC | SEC_LOAD | SEC_KEEP | SEC_IN_MEMORY;
  
  bfd_set_section_flags (vars->abfd, sec, flags | extra_flags);
     
  bfd_set_section_alignment (vars->abfd, sec, 2);
  
  /* Check that we will not run out of space.  */
  BFD_ASSERT (vars->data + size < vars->bim->buffer + vars->bim->size);
  
  /* Set the section size and contents.  The actual
     contents are filled in by our parent.  */
  bfd_set_section_size (vars->abfd, sec, size);
  sec->contents = vars->data;
  sec->target_index = vars->sec_index ++;

  /* Advance data pointer in the vars structure.  */
  vars->data += size;
  
  /* Skip the padding byte if it was not needed.
     The logic here is that if the string length is odd,
     then the entire string length, including the null byte,
     is even and so the extra, padding byte, is not needed.  */
  if (size & 1)
    vars->data --;
  
  /* Create a coff_section_tdata structure for our use.  */
  sec->used_by_bfd = (struct coff_section_tdata *) vars->data;
  vars->data += sizeof (struct coff_section_tdata);

  BFD_ASSERT (vars->data <= vars->bim->buffer + vars->bim->size);
  
  /* Create a symbol to refer to this section.  */
  pe_ILF_make_a_symbol (vars, "", name, sec, BSF_LOCAL);

  /* Cache the index to the symbol in the coff_section_data structure.  */
  coff_section_data (vars->abfd, sec)->i = vars->sym_index - 1;
  
  return sec;
}

/* This structure contains the code that goes into the .text section
   in order to perform a jump into the DLL lookup table.  The entries
   in the table are index by the magic number used to represent the
   machine type in the PE file.  The contents of the data[] arrays in
   these entries are stolen from the jtab[] arrays in ld/pe-dll.c.
   The SIZE field says how many bytes in the DATA array are actually
   used.  The OFFSET field says where in the data array the address
   of the .idata$5 section should be placed.  */
#define MAX_TEXT_SECTION_SIZE 32

typedef struct
{
  unsigned short magic;
  unsigned char  data[MAX_TEXT_SECTION_SIZE];
  unsigned int   size;
  unsigned int   offset;
}
jump_table;

static jump_table jtab[] =
{
#ifdef I386MAGIC
  { I386MAGIC,
    { 0xff, 0x25, 0x00, 0x00, 0x00, 0x00, 0x90, 0x90 },
    8, 2
  },
#endif
  
#ifdef  MC68MAGIC
  { MC68MAGIC, { /* XXX fill me in */ }, 0, 0 },
#endif
#ifdef  MIPS_ARCH_MAGIC_WINCE
  { MIPS_ARCH_MAGIC_WINCE,
    { 0x00, 0x00, 0x08, 0x3c, 0x00, 0x00, 0x08, 0x8d,
      0x08, 0x00, 0x00, 0x01, 0x00, 0x00, 0x00, 0x00 },
    16, 0
  },
#endif
  
#ifdef  SH_ARCH_MAGIC_WINCE
  { SH_ARCH_MAGIC_WINCE,
    { 0x01, 0xd0, 0x02, 0x60, 0x2b, 0x40,
      0x09, 0x00, 0x00, 0x00, 0x00, 0x00 },
    12, 8
  },
#endif
  
#ifdef  ARMPEMAGIC
  { ARMPEMAGIC,
    { 0x00, 0xc0, 0x9f, 0xe5, 0x00, 0xf0,
      0x9c, 0xe5, 0x00, 0x00, 0x00, 0x00},
    12, 8
  },
#endif
  
#ifdef  THUMBPEMAGIC
  { THUMBPEMAGIC,
    { 0x40, 0xb4, 0x02, 0x4e, 0x36, 0x68, 0xb4, 0x46,
      0x40, 0xbc, 0x60, 0x47, 0x00, 0x00, 0x00, 0x00 },
    16, 12
  },
#endif
  { 0, { 0 }, 0, 0 }
};

#ifndef NUM_ENTRIES
#define NUM_ENTRIES(a) (sizeof (a) / sizeof (a)[0])
#endif

/* Build a full BFD from the information supplied in a ILF object.  */
static boolean
pe_ILF_build_a_bfd (bfd *           abfd,
		    unsigned short  magic,
		    bfd_byte *      symbol_name,
		    bfd_byte *      source_dll,
		    unsigned int    ordinal,
		    unsigned int    types)
{ 
  bfd_byte *               ptr;
  pe_ILF_vars              vars;
  struct internal_filehdr  internal_f;
  unsigned int             import_type;
  unsigned int             import_name_type;
  asection_ptr             id4, id5, id6 = NULL, text = NULL;
  coff_symbol_type **      imp_sym;
  unsigned int             imp_index;

  /* Decode and verify the types field of the ILF structure.  */
  import_type = types & 0x3;
  import_name_type = (types & 0x1c) >> 2;

  switch (import_type)
    {
    case IMPORT_CODE:
    case IMPORT_DATA:
      break;
      
    case IMPORT_CONST:
      /* XXX code yet to be written.  */
      _bfd_error_handler (_("%s: Unhandled import type; %x"),
			  bfd_get_filename (abfd), import_type);
      return false;
      
    default:
      _bfd_error_handler (_("%s: Unrecognised import type; %x"),
			  bfd_get_filename (abfd), import_type);
      return false;
    }

  switch (import_name_type)
    {
    case IMPORT_ORDINAL:
    case IMPORT_NAME:
    case IMPORT_NAME_NOPREFIX:
    case IMPORT_NAME_UNDECORATE:
      break;
      
    default:
      _bfd_error_handler (_("%s: Unrecognised import name type; %x"),
			  bfd_get_filename (abfd), import_name_type);
      return false;
    }

  /* Initialise local variables.
     
     Note these are kept in a structure rather than being
     declared as statics since bfd frowns on global variables.
     
     We are going to construct the contents of the BFD in memory,
     so allocate all the space that we will need right now.  */
  ptr = bfd_zalloc (abfd, ILF_DATA_SIZE);
  if (ptr == NULL)
    return false;

  /* Create a bfd_in_memory structure.  */
  vars.bim = (struct bfd_in_memory *) ptr;
  vars.bim->buffer = ptr;
  vars.bim->size   = ILF_DATA_SIZE;
  ptr += sizeof (* vars.bim);
  
  /* Initialise the pointers to regions of the memory and the
     other contents of the pe_ILF_vars structure as well.  */
  vars.sym_cache = (coff_symbol_type *) ptr;
  vars.sym_ptr   = (coff_symbol_type *) ptr;
  vars.sym_index = 0;
  ptr += SIZEOF_ILF_SYMS;
  
  vars.sym_table = (unsigned int *) ptr;
  vars.table_ptr = (unsigned int *) ptr;
  ptr += SIZEOF_ILF_SYM_TABLE;

  vars.native_syms = (combined_entry_type *) ptr;
  vars.native_ptr  = (combined_entry_type *) ptr;
  ptr += SIZEOF_ILF_NATIVE_SYMS;

  vars.sym_ptr_table = (coff_symbol_type **) ptr;
  vars.sym_ptr_ptr   = (coff_symbol_type **) ptr;
  ptr += SIZEOF_ILF_SYM_PTR_TABLE;
  
  vars.esym_table = (SYMENT *) ptr;
  vars.esym_ptr   = (SYMENT *) ptr;
  ptr += SIZEOF_ILF_EXT_SYMS;
  
  vars.reltab   = (arelent *) ptr;
  vars.relcount = 0;
  ptr += SIZEOF_ILF_RELOCS;

  vars.int_reltab  = (struct internal_reloc *) ptr;
  ptr += SIZEOF_ILF_INT_RELOCS;

  vars.string_table = ptr;
  vars.string_ptr   = ptr + STRING_SIZE_SIZE;
  ptr += SIZEOF_ILF_STRINGS;
  vars.end_string_ptr = ptr;
  
  /* The remaining space in bim->buffer is used
     by the pe_ILF_make_a_section() function.  */
  vars.data = ptr;
  vars.abfd = abfd;
  vars.sec_index = 0;
  vars.magic = magic;
  
  /* Create the initial .idata$<n> sections:
     [.idata$2:  Import Directory Table -- not needed]
     .idata$4:  Import Lookup Table
     .idata$5:  Import Address Table

     Note we do not create a .idata$3 section as this is
     created for us by the linker script.  */
  id4 = pe_ILF_make_a_section (& vars, ".idata$4", SIZEOF_IDATA4, 0);
  id5 = pe_ILF_make_a_section (& vars, ".idata$5", SIZEOF_IDATA5, 0);
  if (id4 == NULL || id5 == NULL)
    return false;
  
  /* Fill in the contents of these sections.  */
  if (import_name_type == IMPORT_ORDINAL)
    {
      if (ordinal == 0)
	/* XXX - treat as IMPORT_NAME ??? */
	abort ();
      
      * (unsigned int *) id4->contents = ordinal | 0x80000000UL;
      * (unsigned int *) id5->contents = ordinal | 0x80000000UL;
    }
  else
    {
      char * symbol;
      
      /* Create .idata$6 - the Hint Name Table.  */
      id6 = pe_ILF_make_a_section (& vars, ".idata$6", SIZEOF_IDATA6, 0);
      if (id6 == NULL)
	return false;

      /* If necessary, trim the import symbol name.  */
      symbol = symbol_name;

      if (import_name_type != IMPORT_NAME)
	/* Skip any prefix in symbol_name.  */
	while (*symbol == '@' || * symbol == '?' || * symbol == '_')
	  ++ symbol;

      if (import_name_type == IMPORT_NAME_UNDECORATE)
	{
	  /* Truncate at the first '@'  */
	  while (* symbol != 0 && * symbol != '@')
	    symbol ++;

	  * symbol = 0;
	}
      
      id6->contents[0] = ordinal & 0xff;
      id6->contents[1] = ordinal >> 8;
      
      strcpy (id6->contents + 2, symbol);
    }

  if (import_name_type != IMPORT_ORDINAL)
    {
      pe_ILF_make_a_reloc (& vars, 0, BFD_RELOC_RVA, id6);
      pe_ILF_save_relocs (& vars, id4);
      
      pe_ILF_make_a_reloc (& vars, 0, BFD_RELOC_RVA, id6);
      pe_ILF_save_relocs (& vars, id5);
    }

  /* Create extra sections depending upon the type of import we are dealing with.  */
  switch (import_type)
    {
      int i;
      
    case IMPORT_CODE:
      /* Create a .text section.
	 First we need to look up its contents in the jump table.  */
      for (i = NUM_ENTRIES (jtab); i--;)
	{
	  if (jtab[i].size == 0)
	    continue;
	  if (jtab[i].magic == magic)
	    break;
	}
      /* If we did not find a matching entry something is wrong.  */
      if (i < 0)
	abort ();

      /* Create the .text section.  */
      text = pe_ILF_make_a_section (& vars, ".text", jtab[i].size, SEC_CODE);
      if (text == NULL)
	return false;

      /* Copy in the jump code.  */
      memcpy (text->contents, jtab[i].data, jtab[i].size);

      /* Create an import symbol.  */
      pe_ILF_make_a_symbol (& vars, "__imp_", symbol_name, id5, 0);
      imp_sym   = vars.sym_ptr_ptr - 1;
      imp_index = vars.sym_index - 1;
    
      /* Create a reloc for the data in the text section.  */
#ifdef MIPS_ARCH_MAGIC_WINCE      
      if (magic == MIPS_ARCH_MAGIC_WINCE)
	{
	  pe_ILF_make_a_symbol_reloc (& vars, 0, BFD_RELOC_HI16_S,
				      (asection **) imp_sym, imp_index);
	  pe_ILF_make_a_reloc (& vars, 0, BFD_RELOC_LO16, text);
	  pe_ILF_make_a_symbol_reloc (& vars, 4, BFD_RELOC_LO16,
				      (asection **) imp_sym, imp_index);
	}
      else
#endif
	pe_ILF_make_a_symbol_reloc (& vars, jtab[i].offset, BFD_RELOC_32,
				    (asymbol **) imp_sym, imp_index);
      
      pe_ILF_save_relocs (& vars, text);
      break;

    case IMPORT_DATA:
      break;

    default:
      /* XXX code not yet written.  */
      abort ();
    }
  
  /* Initialise the bfd.  */
  memset (& internal_f, 0, sizeof (internal_f));
  
  internal_f.f_magic  = magic;
  internal_f.f_symptr = 0;
  internal_f.f_nsyms  = 0;
  internal_f.f_flags  = F_AR32WR | F_LNNO; /* XXX is this correct ?  */
  
  if (   ! bfd_set_start_address (abfd, 0)
      || ! bfd_coff_set_arch_mach_hook (abfd, & internal_f))
    return false;

  if (bfd_coff_mkobject_hook (abfd, (PTR) & internal_f, NULL) == NULL)
    return false;

  coff_data (abfd)->pe = 1;
#ifdef THUMBPEMAGIC  
  if (vars.magic == THUMBPEMAGIC)
    /* Stop some linker warnings about thumb code not supporting interworking.  */
    coff_data (abfd)->flags |= F_INTERWORK | F_INTERWORK_SET;
#endif
    
  /* Switch from file contents to memory contents.  */
  bfd_cache_close (abfd);

  abfd->iostream = (PTR) vars.bim;
  abfd->flags |= BFD_IN_MEMORY /* | HAS_LOCALS */;
  abfd->where = 0;
  obj_sym_filepos (abfd) = 0;

  /* Now create a symbol describing the imported value.  */
  switch (import_type)
    {
      bfd_byte * ptr;
      
    case IMPORT_CODE:
      pe_ILF_make_a_symbol (& vars, "", symbol_name, text,
			    BSF_NOT_AT_END | BSF_FUNCTION);
      
      /* Create an import symbol for the DLL, without the
       .dll suffix.  */
      ptr = strrchr (source_dll, '.');
      if (ptr)
	* ptr = 0;
      pe_ILF_make_a_symbol (& vars, "__IMPORT_DESCRIPTOR_", source_dll, NULL, 0);
      if (ptr)
	* ptr = '.';
      break;

    case IMPORT_DATA:
      /* Nothing to do here.  */
      break;
      
    default:
      /* XXX code not yet written.  */
      abort ();
    }

  /* Point the bfd at the symbol table.  */
  obj_symbols (abfd) = vars.sym_cache;
  bfd_get_symcount (abfd) = vars.sym_index;
  
  obj_raw_syments (abfd) = vars.native_syms;
  obj_raw_syment_count (abfd) = vars.sym_index;

  obj_coff_external_syms (abfd) = (PTR) vars.esym_table;
  obj_coff_keep_syms (abfd) = true;
  
  obj_convert (abfd) = vars.sym_table;
  obj_conv_table_size (abfd) = vars.sym_index;
  
  obj_coff_strings (abfd) = vars.string_table;
  obj_coff_keep_strings (abfd) = true;

  abfd->flags |= HAS_SYMS;

  return true;
}

/* We have detected a Image Library Format archive element.
   Decode the element and return the appropriate target.  */
static const bfd_target *
pe_ILF_object_p (bfd * abfd)
{
  bfd_byte        buffer[16];
  bfd_byte *      ptr;
  bfd_byte *      symbol_name;
  bfd_byte *      source_dll;
  unsigned int    machine;
  unsigned long   size;
  unsigned int    ordinal;
  unsigned int    types;
  unsigned short  magic;
  
  /* Upon entry the first four buyes of the ILF header have
      already been read.  Now read the rest of the header.  */
  if (bfd_read (buffer, 1, 16, abfd) != 16)
    return NULL;

  ptr = buffer;
  
  /*  We do not bother to check the version number.
      version = bfd_h_get_16 (abfd, ptr);  */
  ptr += 2;

  machine = bfd_h_get_16 (abfd, ptr);
  ptr += 2;

  /* Check that the machine type is recognised.  */
  magic = 0;
  
  switch (machine)
    {
    case IMAGE_FILE_MACHINE_UNKNOWN:
    case IMAGE_FILE_MACHINE_ALPHA:
    case IMAGE_FILE_MACHINE_ALPHA64:
    case IMAGE_FILE_MACHINE_IA64:
      break;
      
    case IMAGE_FILE_MACHINE_I386:
#ifdef I386MAGIC
      magic = I386MAGIC;
#endif
      break;
      
    case IMAGE_FILE_MACHINE_M68K:
#ifdef MC68AGIC
      magic = MC68MAGIC;
#endif
      break;
      
    case IMAGE_FILE_MACHINE_R3000:
    case IMAGE_FILE_MACHINE_R4000:
    case IMAGE_FILE_MACHINE_R10000:
      
    case IMAGE_FILE_MACHINE_MIPS16:
    case IMAGE_FILE_MACHINE_MIPSFPU:
    case IMAGE_FILE_MACHINE_MIPSFPU16:
#ifdef MIPS_ARCH_MAGIC_WINCE
      magic = MIPS_ARCH_MAGIC_WINCE;
#endif
      break;
      
    case IMAGE_FILE_MACHINE_SH3:
    case IMAGE_FILE_MACHINE_SH4:
#ifdef SH_ARCH_MAGIC_WINCE
      magic = SH_ARCH_MAGIC_WINCE;
#endif
      break;
      
    case IMAGE_FILE_MACHINE_ARM:
#ifdef ARMPEMAGIC
      magic = ARMPEMAGIC;
#endif      
      break;
      
    case IMAGE_FILE_MACHINE_THUMB:
#ifdef THUMBPEMAGIC
      {
	extern bfd_target armpei_little_vec;
	
	if (abfd->xvec == & armpei_little_vec)
	  magic = THUMBPEMAGIC;
      }
#endif      
      break;
      
    case IMAGE_FILE_MACHINE_POWERPC:
      /* We no longer support PowerPC.  */
    default:
      _bfd_error_handler
	(
_("%s: Unrecognised machine type (0x%x) in Import Library Format archive"),
         bfd_get_filename (abfd), machine);
      bfd_set_error (bfd_error_malformed_archive);
	
      return NULL;
      break;
    }

  if (magic == 0)
    {
      _bfd_error_handler
	(
_("%s: Recognised but unhandled machine type (0x%x) in Import Library Format archive"),
	 bfd_get_filename (abfd), machine);
      bfd_set_error (bfd_error_wrong_format);
	
      return NULL;
    }  

  /* We do not bother to check the date.
     date = bfd_h_get_32 (abfd, ptr);  */
  ptr += 4;
  
  size = bfd_h_get_32 (abfd, ptr);
  ptr += 4;

  if (size == 0)
    {
      _bfd_error_handler
	(_("%s: size field is zero in Import Library Format header"),
	 bfd_get_filename (abfd));
      bfd_set_error (bfd_error_malformed_archive);
	
      return NULL;
    }

  ordinal = bfd_h_get_16 (abfd, ptr);
  ptr += 2;

  types = bfd_h_get_16 (abfd, ptr);
  /* ptr += 2; */

  /* Now read in the two strings that follow.  */
  ptr = bfd_alloc (abfd, size);
  if (ptr == NULL)
    return NULL;
  
  if (bfd_read (ptr, 1, size, abfd) != size)
    return NULL;

  symbol_name = ptr;
  source_dll  = ptr + strlen (ptr) + 1;
  
  /* Verify that the strings are null terminated.  */
  if (ptr[size - 1] != 0 || ((unsigned long) (source_dll - ptr) >= size))
    {
      _bfd_error_handler
	(_("%s: string not null terminated in ILF object file."),
	 bfd_get_filename (abfd));
      bfd_set_error (bfd_error_malformed_archive);
	
      return NULL;
    }
  
  /* Now construct the bfd.  */
  if (! pe_ILF_build_a_bfd (abfd, magic, symbol_name,
			    source_dll, ordinal, types))
    return NULL;
  
  return abfd->xvec;
}

static const bfd_target *
pe_bfd_object_p (bfd * abfd)
{
  /* We need to handle a PE image correctly.  In PE images created by
     the GNU linker, the offset to the COFF header is always the size.
     However, this is not the case in images generated by other PE
     linkers.  The PE format stores a four byte offset to the PE
     signature just before the COFF header at location 0x3c of the file.
     We pick up that offset, verify that the PE signature is there, and
     then set ourselves up to read in the COFF header.  */
  bfd_byte buffer[4];
  file_ptr offset;
  unsigned long signature;

  /* Detect if this a Microsoft Import Library Format element.  */
  if (bfd_seek (abfd, 0x00, SEEK_SET) != 0
      || bfd_read (buffer, 1, 4, abfd) != 4)
    {
      if (bfd_get_error () != bfd_error_system_call)
	bfd_set_error (bfd_error_wrong_format);
      return NULL;
    }
  
  signature = bfd_h_get_32 (abfd, buffer);
  
  if (signature == 0xffff0000)
    return pe_ILF_object_p (abfd);
  
  if (bfd_seek (abfd, 0x3c, SEEK_SET) != 0
      || bfd_read (buffer, 1, 4, abfd) != 4)
    {
      if (bfd_get_error () != bfd_error_system_call)
	bfd_set_error (bfd_error_wrong_format);
      return NULL;
    }

  offset = bfd_h_get_32 (abfd, buffer);

  if (bfd_seek (abfd, offset, SEEK_SET) != 0
      || bfd_read (buffer, 1, 4, abfd) != 4)
    {
      if (bfd_get_error () != bfd_error_system_call)
	bfd_set_error (bfd_error_wrong_format);
      return NULL;
    }

  signature = bfd_h_get_32 (abfd, buffer);

  if (signature != 0x4550)
    {
      bfd_set_error (bfd_error_wrong_format);
      return NULL;
    }
  
  /* Here is the hack.  coff_object_p wants to read filhsz bytes to
     pick up the COFF header.  We adjust so that that will work.  20
     is the size of the i386 COFF filehdr.  */
  if (bfd_seek (abfd,
		(bfd_tell (abfd)
		 - bfd_coff_filhsz (abfd)
		 + 20),
		SEEK_SET)
      != 0)
    {
      if (bfd_get_error () != bfd_error_system_call)
	bfd_set_error (bfd_error_wrong_format);
      return NULL;
    }

  return coff_object_p (abfd);
}

#define coff_object_p pe_bfd_object_p
#endif /* COFF_IMAGE_WITH_PE */
