/* CYGNUS LOCAL whole file */

#ifndef _MMINTRIN_H_INCLUDED
#define _MMINTRIN_H_INCLUDED

typedef unsigned long long __m64;
typedef int __v2si __attribute__ ((mode (V2SI)));
typedef int __v4hi __attribute__ ((mode (V4HI)));
typedef int __v8qi __attribute__ ((mode (V8QI)));

#define _m_empty		__builtin_ia32_emms
#define _m_from_int(A)		((__m64)__builtin_ia32_m_from_int ((A)))
#define _m_to_int(A)		(__builtin_ia32_m_to_int ((A)))
#define _m_packsswb(A,B)	((__m64)__builtin_ia32_packsswb ((__v4hi)(A), (__v4hi)(B)))
#define _m_packssdw(A,B)	((__m64)__builtin_ia32_packssdw ((__v2si)(A), (__v2si)(B)))
#define _m_packuswb(A,B)	((__m64)__builtin_ia32_packuswb ((__v4hi)(A), (__v4hi)(B)))
#define _m_punpckhbw(A,B)	((__m64)__builtin_ia32_punpckhbw ((__v8qi)(A), (__v8qi)(B)))
#define _m_punpckhwd(A,B)	((__m64)__builtin_ia32_punpckhwd ((__v4hi)(A), (__v4hi)(B)))
#define _m_punpckhdq(A,B)	((__m64)__builtin_ia32_punpckhdq ((__v2si)(A), (__v2si)(B)))
#define _m_punpcklbw(A,B)	((__m64)__builtin_ia32_punpcklbw ((__v8qi)(A), (__v8qi)(B)))
#define _m_punpcklwd(A,B)	((__m64)__builtin_ia32_punpcklwd ((__v4hi)(A), (__v4hi)(B)))
#define _m_punpckldq(A,B)	((__m64)__builtin_ia32_punpckldq ((__v2si)(A), (__v2si)(B)))
#define _m_paddb(A,B)		((__m64)__builtin_ia32_paddb ((__v8qi)(A), (__v8qi)(B)))
#define _m_paddw(A,B)		((__m64)__builtin_ia32_paddw ((__v4hi)(A), (__v4hi)(B)))
#define _m_paddd(A,B)		((__m64)__builtin_ia32_paddd ((__v2si)(A), (__v2si)(B)))
#define _m_paddsb(A,B)		((__m64)__builtin_ia32_paddsb ((__v8qi)(A), (__v8qi)(B)))
#define _m_paddsw(A,B)		((__m64)__builtin_ia32_paddsw ((__v4hi)(A), (__v4hi)(B)))
#define _m_paddusb(A,B)		((__m64)__builtin_ia32_paddusb ((__v8qi)(A), (__v8qi)(B)))
#define _m_paddusw(A,B)		((__m64)__builtin_ia32_paddusw ((__v4hi)(A), (__v4hi)(B)))
#define _m_psubb(A,B)		((__m64)__builtin_ia32_psubb ((__v8qi)(A), (__v8qi)(B)))
#define _m_psubw(A,B)		((__m64)__builtin_ia32_psubw ((__v4hi)(A), (__v4hi)(B)))
#define _m_psubd(A,B)		((__m64)__builtin_ia32_psubd ((__v2si)(A), (__v2si)(B)))
#define _m_psubsb(A,B)		((__m64)__builtin_ia32_psubsb ((__v8qi)(A), (__v8qi)(B)))
#define _m_psubsw(A,B)		((__m64)__builtin_ia32_psubsw ((__v4hi)(A), (__v4hi)(B)))
#define _m_psubusb(A,B)		((__m64)__builtin_ia32_psubusb ((__v8qi)(A), (__v8qi)(B)))
#define _m_psubusw(A,B)		((__m64)__builtin_ia32_psubusw ((__v4hi)(A), (__v4hi)(B)))

#define _m_pmaddwd(A,B)		((__m64)__builtin_ia32_pmaddwd ((__v4hi)(A), (__v4hi)(B)))

#define _m_pmulhw(A,B)		((__m64)__builtin_ia32_pmulhw ((__v4hi)(A), (__v4hi)(B)))
#define _m_pmullw(A,B)		((__m64)__builtin_ia32_pmullw ((__v4hi)(A), (__v4hi)(B)))

#define _m_psllw(A,B)		((__m64)__builtin_ia32_psllw ((__v4hi)(A), (B)))
#define _m_pslld(A,B)		((__m64)__builtin_ia32_pslld ((__v2si)(A), (B)))
#define _m_psllq(A,B)		((__m64)__builtin_ia32_psllq ((A), (B)))
#define _m_psraw(A,B)		((__m64)__builtin_ia32_psraw ((__v4hi)(A), (B)))
#define _m_psrad(A,B)		((__m64)__builtin_ia32_psrad ((A), (B)))
#define _m_psrlw(A,B)		((__m64)__builtin_ia32_psrlw ((__v4hi)(A), (B)))
#define _m_psrld(A,B)		((__m64)__builtin_ia32_psrld ((__v2si)(A), (B)))
#define _m_psrlq(A,B)		((__m64)__builtin_ia32_psrlq ((A), (B)))
#define _m_psllwi(A,B)		((__m64)__builtin_ia32_psllw ((__v4hi)(A), (B)))
#define _m_pslldi(A,B)		((__m64)__builtin_ia32_pslld ((__v2si)(A), (B)))
#define _m_psllqi(A,B)		((__m64)__builtin_ia32_psllq ((A), (B)))
#define _m_psrawi(A,B)		((__m64)__builtin_ia32_psraw ((__v4hi)(A), (B)))
#define _m_psradi(A,B)		((__m64)__builtin_ia32_psrad ((A), (B)))
#define _m_psrlwi(A,B)		((__m64)__builtin_ia32_psrlw ((__v4hi)(A), (B)))
#define _m_psrldi(A,B)		((__m64)__builtin_ia32_psrld ((__v2si)(A), (B)))
#define _m_psrlqi(A,B)		((__m64)__builtin_ia32_psrlq ((A), (B)))

#define _m_pand(A,B)		((__m64)__builtin_ia32_pand ((A), (B)))
#define _m_pandn(A,B)		((__m64)__builtin_ia32_pandn ((A), (B)))
#define _m_por(A,B)		((__m64)__builtin_ia32_por ((A), (B)))
#define _m_pxor(A,B)		((__m64)__builtin_ia32_pxor ((A), (B)))

#define _m_pcmpeqb(A,B)		((__m64)__builtin_ia32_pcmpeqb ((__v8qi)(A), (__v8qi)(B)))
#define _m_pcmpeqw(A,B)		((__m64)__builtin_ia32_pcmpeqw ((__v4hi)(A), (__v4hi)(B)))
#define _m_pcmpeqd(A,B)		((__m64)__builtin_ia32_pcmpeqd ((__v2si)(A), (__v2si)(B)))
#define _m_pcmpgtb(A,B)		((__m64)__builtin_ia32_pcmpgtb ((__v8qi)(A), (__v8qi)(B)))
#define _m_pcmpgtw(A,B)		((__m64)__builtin_ia32_pcmpgtw ((__v4hi)(A), (__v4hi)(B)))
#define _m_pcmpgtd(A,B)		((__m64)__builtin_ia32_pcmpgtd ((__v2si)(A), (__v2si)(B)))


/* Utility intrinsics */
#define _mm_setzero_si64	__builtin_ia32_mmx_zero

#if 0

__m64 _mm_set_pi32(int i1, int i0);
__m64 _mm_set_pi16(short s3, short s2, short s1, short s0);
__m64 _mm_set_pi8(char b7, char b6, char b5, char b4,
		  char b3, char b2, char b1, char b0);
__m64 _mm_set1_pi32(int i);
__m64 _mm_set1_pi16(short s);
__m64 _mm_set1_pi8(char b);
__m64 _mm_setr_pi32(int i1, int i0);
__m64 _mm_setr_pi16(short s3, short s2, short s1, short s0);
__m64 _mm_setr_pi8(char b7, char b6, char b5, char b4,
		   char b3, char b2, char b1, char b0);

#endif

#endif /* _MMINTRIN_H_INCLUDED */

