/* Definitions to target GDB to XScale embedded systems.
   Copyright 2000 Free Software Foundation, Inc.

   This file is part of GDB.

   This program is free software; you can redistribute it and/or modify
   it under the terms of the GNU General Public License as published by
   the Free Software Foundation; either version 2 of the License, or
   (at your option) any later version.

   This program is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
   GNU General Public License for more details.

   You should have received a copy of the GNU General Public License
   along with this program; if not, write to the Free Software
   Foundation, Inc., 59 Temple Place - Suite 330,
   Boston, MA 02111-1307, USA.  */

#ifndef TM_ARMXSCALE_H
#define TM_ARMXSCALE_H

/* Start with the embedded target definitions. */
#include "arm/tm-embed.h"

/* Add HW watchpoint/breakpoint support */

#define TARGET_HW_BREAK_LIMIT 2
#define TARGET_HW_WATCH_LIMIT 1

#define TARGET_HAS_HARDWARE_WATCHPOINTS

#define TARGET_CAN_USE_HARDWARE_WATCHPOINT(type, cnt, ot) \
	arm_check_watch_resources (type, cnt, ot)

/* When a hardware watchpoint fires off the PC will be left at the
   instruction which caused the watchpoint.  It will be necessary for
   GDB to step over the watchpoint. */

/*#define HAVE_STEPPABLE_WATCHPOINT 1*/

#define STOPPED_BY_WATCHPOINT(W) \
   remote_stopped_by_watchpoint()

/* Use these macros for watchpoint insertion/deletion.  */
#define target_insert_watchpoint(addr, len, type) \
		remote_insert_watchpoint (addr, len, type)
#define target_remove_watchpoint(addr, len, type) \
		remote_remove_watchpoint (addr, len, type)
#define target_insert_hw_breakpoint(addr, len) \
		remote_insert_hw_breakpoint (addr, len)
#define target_remove_hw_breakpoint(addr, len) \
		remote_remove_hw_breakpoint (addr, len)
#define target_stopped_data_address() \
		remote_stopped_data_address()

extern int arm_check_watch_resources (int type, int cnt, int ot);
#endif
