unit Voxdec;

interface

uses
  SysUtils, WinTypes, WinProcs, Messages, Classes, Graphics, Controls,
  Forms, Dialogs, StdCtrls, ExtCtrls, Buttons;

type
  TForm1 = class(TForm)
    Panel1: TPanel;
    OpenDialog1: TOpenDialog;
    BitBtn2: TBitBtn;
    BitBtn3: TBitBtn;
    Panel2: TPanel;
    ComboBox1: TComboBox;
    Label3: TLabel;
    BitBtn1: TBitBtn;
    GroupBox1: TGroupBox;
    Panel3: TPanel;
    Label2: TLabel;
    Label1: TLabel;
    procedure Button1Click(Sender: TObject);
    procedure Button2Click(Sender: TObject);
    procedure BitBtn3Click(Sender: TObject);
  private
    { Private declarations }
  public
    { Public declarations }
  end;
type wavefile = record
     wavehdr : array[0..39] of byte;
     wavelenght : longint;
     end;
const
MLN : array[0..7] of integer = (-1,-1,-1,-1,+2,+4,+6,+8);
SS : array[0..48] of word =    (16,17,19,21,23,25,28,31,34,37,41,45,50,55,
                                60,66,73,80,88,97,107,118,130,143,157,173,190,
                                209,230,253,279,307,337,371,408,449,494,544,
                                598,658,724,796,876,963,1060,1166,1282,1411,1552);


var
  Form1: TForm1;
  head:wavefile;
  inbuffer:array[0..1028] of byte;
  outbuffer:array[0..1028] of byte;
  SSpointer: integer;
  Xp: integer;
  X: integer;

implementation

uses voxdec2;



{$R *.DFM}
{
WELCOME TO VOX2WAV a freeware utility copyright 1996 Genialogic Team
Coded by Giovanni Tummarello

Dialogic gives a nice DOC about how to go from wox to wav and vice versa BUT
they forget to mention 2-3 IMPORTANT details :-)  without those i think its
impossible to write a converter..
After bugging them for a month they finally sent me some better examples and i
could finish them.

Vox format its their copyright, so check with them if you need to do
anything that involves this format..

This source code can be include in your programs as long as creadits to
us and a mention to our homepage is in your about screen
please e mail me at tummarel@ascu.unian.it for more information
WE ARE THE MAKERS OF *VOCOM* a complete dialogic toolkit.. so please look for
vocom on the web and visit our homepage!

This is not optimized or good looking code.. but it works.. :)
}



procedure TForm1.Button1Click(Sender: TObject);
{/* standard wave file header */
/****************************************************************
* 'RIFF'
* length in bytes of all that follows(long)
* 'WAVE'
* 'fmt '
* length in bytes of the format block = 16(long)
* format = 1(int)
* number of channels = 1(int) - mono
* sample rate(long)
* bytes per second during play(long)
* bytes per sample = 2(int)
* bits per sample = 16(int)
* 'data'
* length in bytes of the data block(long)
****************************************************************/}
const
wavehdr: array [0..10] of longint = ($46464952,$ffffffdb,$45564157,$20746d66,16,$10001,6000,
                   6000,$80001,$61746164,-1);

var
fi,fo:file;
a,b,c: integer;
letti: integer;
counter: integer;
dn: integer;
sample: word;
ssvalue:integer;
lettitot:longint;
cippo,cippo2,cippo3 : integer;
begin
opendialog1.filterindex:=2;
if opendialog1.execute then
  begin
  wavehdr[6]:=strtoint(combobox1.text);
  wavehdr[7]:=strtoint(combobox1.text);
  dn:=0;
  counter:=0;
  sspointer:=0;
  xp:=2048;
  cippo2:=2048;
  cippo3:=2048;
  ssvalue:=16;
  assignfile(fi,opendialog1.filename);
  reset(fi,1);
  assignfile(fo,changefileext(opendialog1.filename,'.wav'));
  rewrite(fo,1);
  lettitot:=0;
  blockwrite(fo,wavehdr,sizeof(wavehdr)); { scrivo header wav }
    repeat
    blockread(fi,inbuffer,200,letti);
    inc(lettitot,letti*2);
    for counter:=0 to ((letti*2)-1)  do
      begin
      if (counter mod 2) = 0 then
        sample:=inbuffer[counter div 2] and $f0 div 16
                             else
        sample:=inbuffer[counter div 2] and $f;

      dn := (ssvalue*((sample and $4) div 4))+((ssvalue div 2)*((sample and $2) div 2))
             +((ssvalue div 4)*(sample and $1))+ (ssvalue div 8);

      inc(sspointer,MLN[sample and $7]);
      if sspointer<0 then sspointer:=0;
      if sspointer>48 then sspointer:=48;
      ssvalue:=ss[sspointer];

      if (sample and $8) = 8 then dn:=-dn;
      cippo:=xp+dn;
      if cippo>4095 then cippo:=4095;
      if cippo<0 then cippo:=0;
      if cippo2<cippo then cippo2:=cippo;
      if cippo3>cippo then cippo3:=cippo;

      outbuffer[counter]:=byte(cippo div 16);
      xp:=cippo {xp+dn};
      end;
      blockwrite(fo,outbuffer,letti*2); { scrivo header wav }
    until letti<>200;
  label1.caption:='Max value :'+inttostr(cippo2);
  label2.caption:='Min value :'+inttostr(cippo3);
  seek(fo,0);
  wavehdr[1]:=lettitot+36;
  wavehdr[10]:=lettitot;
  blockwrite(fo,wavehdr,sizeof(wavehdr)); { scrivo header wav }
  closefile(fi);
  closefile(fo);
  Showmessage(changefileext(opendialog1.filename,'.wav')+' was succesfully written!');
  end;
end;

procedure TForm1.Button2Click(Sender: TObject);

function adpcm( csig : integer) : byte;
var
diff,step: integer;
encodedato : byte;
begin
step:=ss[sspointer];
if (csig>4095) then csig:=4095;
if (csig<0) then csig:=0;
diff:=csig-Xp;
if diff<0 then
  begin
  encodedato:=8;
  diff:=-diff;
  end     else encodedato:=0;
if diff>=step then
  begin
  inc(encodedato,4);
  dec(diff,step)
  end;
step:=step div 2;
if diff>=step then
  begin
  inc(encodedato,2);
  dec(diff,step)
  end;
step:=step div 2;
if diff>=step then
  inc(encodedato,1);
step:=ss[sspointer];
diff := ((step)*((encodedato and $4) div 4))+((step div 2)*((encodedato and $2) div 2))
            +((step div 4)*(encodedato and $1))+ (step div 8);
if (encodedato and $8) = 8 then diff:=-diff;
inc(sspointer,MLN[encodedato and $7]);
if sspointer<0 then sspointer:=0;
if sspointer>48 then sspointer:=48;
xp:=xp+diff;
adpcm:=encodedato;
end;



var
fi: file;
fo: file;
datolong,length: longint;
datoword: word;
valid: boolean;
formato: integer;
offset: integer;
encoded : byte;
begin
opendialog1.filterindex:=1;
sspointer:=0;
xp:=2048;
if opendialog1.execute then
  begin
  assignfile(fi,opendialog1.filename);
  reset(fi,1);
  if ioresult=0 then
    begin
    valid:=true;
    blockread(fi,datolong,4);
    if datolong<>$46464952 then valid:=false;  { 'RIFF'}
    blockread(fi,datolong,4);
    blockread(fi,datolong,4);
    if datolong<>$45564157 then valid:=false;   {'WAVE'}
    blockread(fi,datolong,4);
    if datolong<>$20746d66 then valid:=false;   {'fmt '}

    blockread(fi,datolong,4);
    blockread(fi,datoword,2);
    formato:=datoword;
    length:=datolong;
    if not (((length=16) and (formato=1))  or
            ((length=20) and (formato=16)) or
            ((length=18) and (formato=6))  or
            ((length=18) and (formato=7))) then valid:=false;
    if not ((formato=16) or (formato=1)) then valid:=false;

    blockread(fi,datoword,2);
    if datoword<>1 then valid:=false;
    blockread(fi,datolong,4);
    if (datolong<>6000) and (datolong<>8000) then
      if MessageDlg('Sample rate in .wav file is not 6000 or 8000 should i convert anyway?',
           mtconfirmation, [mbYes, mbNo], 0) = mrno then valid:=false;
    blockread(fi,inbuffer,word(length-8));
    blockread(fi,datolong,4);
    if datolong<>$61746164 then valid:=false;   {'data'}
    blockread(fi,datolong,4);
    if valid then
      begin
      assignfile(fo,changefileext(opendialog1.filename,'.vox'));
      rewrite(fo,1);
      if ioresult=0 then
        begin
        length:=1000;
        while length=1000 do
          begin
          blockread(fi,inbuffer,1000,integer(length));
          for offset:=0 to ((length div 2)-1) do
            begin
            encoded:=byte(adpcm(inbuffer[offset*2]*16))*16;
            inc(encoded,byte(adpcm(inbuffer[offset*2+1]*16)));
            outbuffer[offset]:=encoded;
            end;
          blockwrite(fo,outbuffer,length div 2);
          end;
        closefile(fo);
        Showmessage(changefileext(opendialog1.filename,'.vox')+' was succesfully written!');
        end;
      end else showmessage('File is not valid for conversion (must be PCM 8 bit mono to be converted)');
    closefile(fi);
    end;
  end;
end;


procedure TForm1.BitBtn3Click(Sender: TObject);
begin
form2.show;
end;

end.
