/*
 * Decompiled with CFR 0.152.
 */
package com.installshield.archive;

import com.installshield.archive.ArchiveEntry;
import com.installshield.archive.ArchiveFilter;
import com.installshield.archive.ArchiveWriterRecord;
import com.installshield.archive.DirectoryResourceWriterFactory;
import com.installshield.archive.ResourceReader;
import com.installshield.archive.ResourceReaderFactory;
import com.installshield.archive.ResourceWriter;
import com.installshield.archive.ResourceWriterFactory;
import com.installshield.archive.StandardResourceReaderFactory;
import com.installshield.archive.UnknownResourceTypeException;
import com.installshield.archive.ZipResourceWriterFactory;
import com.installshield.util.ClassUtils;
import com.installshield.util.GenericProgress;
import com.installshield.util.LogListener;
import java.io.EOFException;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.lang.reflect.Method;
import java.net.URL;
import java.util.Date;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Locale;
import java.util.Vector;
import java.util.zip.ZipOutputStream;

public class ArchiveWriter {
    public static final String WRITE_STARTED = "msg1.write.started";
    public static final String WRITE_FINISHED = "msg1.write.finished";
    public static final String PROGRESS = "progress";
    private Hashtable resources = new Hashtable();
    private ResourceReaderFactory readerFactory;
    private ResourceWriterFactory writerFactory;
    private ArchiveWriterRecord record = null;
    private boolean calculateProgress = true;
    private Hashtable addedPackages = new Hashtable();
    private Vector logListeners = new Vector();
    private boolean canceled = false;

    protected ArchiveWriter() {
    }

    public ArchiveWriter(ResourceReaderFactory resourceReaderFactory, ResourceWriterFactory resourceWriterFactory) {
        this.initialize(resourceReaderFactory, resourceWriterFactory);
    }

    public void addLogListener(LogListener logListener) {
        this.logListeners.addElement(logListener);
    }

    public void cancel() {
        this.canceled = true;
    }

    public static ArchiveWriter createDirectoryArchiveWriter(String string, String string2, String string3) throws IOException {
        return new ArchiveWriter(new StandardResourceReaderFactory(string), new DirectoryResourceWriterFactory(string2, string3));
    }

    public static ArchiveWriter createZipArchiveWriter(String string, ZipOutputStream zipOutputStream, String string2) throws IOException {
        return new ArchiveWriter(new StandardResourceReaderFactory(string), new ZipResourceWriterFactory(zipOutputStream, string2));
    }

    public boolean getCalculateProgress() {
        return this.calculateProgress;
    }

    public ArchiveWriterRecord getRecord() {
        return this.record;
    }

    public ResourceReaderFactory getResourceReaderFactory() {
        return this.readerFactory;
    }

    public String getResourceRoot() {
        return this.writerFactory.getResourceRoot();
    }

    public ResourceWriterFactory getResourceWriterFactory() {
        return this.writerFactory;
    }

    private String getTypeDescription(Object object) {
        if (object instanceof Class) {
            try {
                Method method = ((Class)object).getMethod("getTypeDescription", new Class[0]);
                return (String)method.invoke(null, new Object[0]);
            }
            catch (Throwable throwable) {
            }
        }
        return ClassUtils.createObjectDisplayName(object);
    }

    protected void initialize(ResourceReaderFactory resourceReaderFactory, ResourceWriterFactory resourceWriterFactory) {
        if (resourceWriterFactory == null) {
            throw new IllegalArgumentException("writerFactory cannot be null");
        }
        this.writerFactory = resourceWriterFactory;
        if (resourceReaderFactory == null) {
            throw new IllegalArgumentException("readerFactory cannot be null");
        }
        this.readerFactory = resourceReaderFactory;
    }

    public boolean isCanceled() {
        return this.canceled;
    }

    public void logEvent(String string, Object object) {
        int n = 0;
        while (n < this.logListeners.size()) {
            ((LogListener)this.logListeners.elementAt(n)).eventLogged(this, string, object);
            ++n;
        }
    }

    public void putArchive(String string, ArchiveFilter archiveFilter) throws IOException {
        Enumeration enumeration = this.readerFactory.archiveEntries(string);
        while (enumeration.hasMoreElements()) {
            ArchiveEntry archiveEntry = (ArchiveEntry)enumeration.nextElement();
            if (archiveEntry.getName().toLowerCase().endsWith("manifest.mf")) continue;
            archiveEntry.setWriter(this.writerFactory.createClassResourceWriter(archiveEntry.getName()));
            if (!archiveFilter.filter(archiveEntry, this.writerFactory)) continue;
            if (archiveEntry.getReader() == null) {
                throw new IllegalStateException("entry reader has been set to null");
            }
            if (archiveEntry.getWriter() == null) {
                throw new IllegalStateException("entry writer has been set to null");
            }
            this.putResource(archiveEntry.getReader(), archiveEntry.getWriter());
        }
    }

    public void putClass(String string) throws IOException {
        this.putResource(this.readerFactory.createClassResourceReader(String.valueOf(string.replace('.', '/')) + ".class"), this.writerFactory.createClassWriter(string));
    }

    public void putClassResource(InputStream inputStream, String string) throws IOException {
        this.putResource(this.readerFactory.createResourceReader(inputStream), this.writerFactory.createClassResourceWriter(string));
    }

    public void putClassResource(String string) throws IOException {
        this.putResource(this.readerFactory.createClassResourceReader(string), this.writerFactory.createClassResourceWriter(string));
    }

    public void putDefinition(Object object, Class clazz, String string) throws IOException {
        this.putResource(this.readerFactory.createDefinitionReader(object, clazz), this.writerFactory.createDefinitionWriter(string));
        this.putClassResource(String.valueOf(clazz.getName().replace('.', '/')) + ".qjml");
    }

    public void putDefinition(URL uRL, String string) throws IOException {
        this.putResource(this.readerFactory.createResourceReader(uRL), this.writerFactory.createDefinitionWriter(string));
    }

    public void putOther(String string, Object object, Object object2) throws UnknownResourceTypeException, IOException {
        this.putResource(this.readerFactory.createOtherReader(string, object), this.writerFactory.createOtherWriter(string, object2));
    }

    public void putPackage(String string) throws IOException {
        this.putPackage(string, false);
    }

    public void putPackage(String string, boolean bl) throws IOException {
        if (!this.addedPackages.containsKey(String.valueOf(string) + bl)) {
            Enumeration enumeration = this.readerFactory.packageResources(string, bl);
            while (enumeration.hasMoreElements()) {
                this.putClassResource((String)enumeration.nextElement());
            }
            this.addedPackages.put(String.valueOf(string) + bl, "");
        }
    }

    private void putResource(ResourceReader resourceReader, ResourceWriter resourceWriter) {
        Hashtable<ResourceReader, ResourceWriter> hashtable = (Hashtable<ResourceReader, ResourceWriter>)this.resources.get(resourceReader.getClass());
        if (hashtable == null) {
            hashtable = new Hashtable<ResourceReader, ResourceWriter>();
            this.resources.put(resourceReader.getClass(), hashtable);
        }
        hashtable.put(resourceReader, resourceWriter);
    }

    public void putResource(InputStream inputStream, String string) throws IOException {
        this.putResource(this.readerFactory.createResourceReader(inputStream), this.writerFactory.createFileResourceWriter(string));
    }

    public void putResource(String string, String string2) throws IOException {
        this.putResource(this.readerFactory.createResourceReader(new URL("file", "", -1, string)), this.writerFactory.createFileResourceWriter(string2));
    }

    public void putResource(URL uRL, String string) throws IOException {
        this.putResource(this.readerFactory.createResourceReader(uRL), this.writerFactory.createFileResourceWriter(string));
    }

    public void putResourceBundles(String string, Locale[] localeArray) throws IOException {
        boolean bl = false;
        boolean[] blArray = new boolean[localeArray.length];
        try {
            this.putClass(string);
            bl = true;
        }
        catch (IOException iOException) {
            bl = false;
        }
        int n = 0;
        while (n < localeArray.length) {
            try {
                this.putClass(String.valueOf(string) + "_" + localeArray[n].toString());
                blArray[n] = true;
            }
            catch (IOException iOException) {
                blArray[n] = false;
            }
            ++n;
        }
        String string2 = string.replace('.', '/');
        if (!bl) {
            try {
                this.putClassResource(String.valueOf(string2) + ".properties");
                bl = true;
            }
            catch (IOException iOException) {}
        }
        int n2 = 0;
        while (n2 < localeArray.length) {
            try {
                if (!blArray[n2]) {
                    this.putClassResource(String.valueOf(string2) + "_" + localeArray[n2].toString() + ".properties");
                    blArray[n2] = true;
                }
            }
            catch (IOException iOException) {}
            ++n2;
        }
        if (!bl) {
            throw new IOException("could not find default resource bundle for " + string);
        }
        int n3 = 0;
        while (n3 < blArray.length) {
            if (!blArray[n3]) {
                this.logEvent("wrn", "could not find resource bundle for " + string + " (" + localeArray[n3] + ")");
            }
            ++n3;
        }
    }

    private boolean readerWrittenBy(ResourceReader resourceReader, ResourceWriter resourceWriter) {
        if (this.record == null) {
            return false;
        }
        return this.record.readerWrittenBy(resourceReader, resourceWriter);
    }

    private void recordResourceWrite(ResourceReader resourceReader, ResourceWriter resourceWriter) {
        if (this.record != null) {
            this.record.record(resourceReader, resourceWriter);
        }
    }

    public void removeLogListener(LogListener logListener) {
        this.logListeners.removeElement(logListener);
    }

    private boolean resourceChanged(ResourceReader resourceReader) {
        if (this.record == null) {
            return true;
        }
        Date date = this.record.getDate(resourceReader);
        return date == null || !date.equals(resourceReader.getDate());
    }

    private boolean resourceChanged(ResourceWriter resourceWriter) {
        if (this.record == null) {
            return true;
        }
        Date date = this.record.getDate(resourceWriter);
        return date == null || !date.equals(resourceWriter.getDate());
    }

    public void setCalculateProgress(boolean bl) {
        this.calculateProgress = bl;
    }

    public void setRecord(ArchiveWriterRecord archiveWriterRecord) {
        this.record = archiveWriterRecord;
    }

    public void write() {
        this.logEvent(WRITE_STARTED, "Started writing archive");
        byte[] byArray = new byte[5120];
        int n = 0;
        GenericProgress genericProgress = new GenericProgress();
        Enumeration enumeration = this.resources.keys();
        while (!this.canceled && enumeration.hasMoreElements()) {
            Enumeration enumeration2;
            Object k = enumeration.nextElement();
            Hashtable hashtable = (Hashtable)this.resources.get(k);
            genericProgress.setStatusDescription("Writing " + this.getTypeDescription(k) + "...");
            Hashtable<ResourceReader, String> hashtable2 = new Hashtable<ResourceReader, String>();
            long l = 0L;
            if (this.calculateProgress) {
                enumeration2 = hashtable.keys();
                while (!this.canceled && enumeration2.hasMoreElements()) {
                    ResourceWriter resourceWriter;
                    ResourceReader resourceReader = (ResourceReader)enumeration2.nextElement();
                    if (this.readerWrittenBy(resourceReader, resourceWriter = (ResourceWriter)hashtable.get(resourceReader)) && !this.resourceChanged(resourceReader) && !this.resourceChanged(resourceWriter)) {
                        hashtable2.put(resourceReader, "");
                        continue;
                    }
                    try {
                        l += (long)resourceReader.getSize();
                    }
                    catch (IOException iOException) {
                        this.logEvent("wrn", "Error reading size for " + resourceReader + ": " + iOException);
                    }
                }
            }
            enumeration2 = hashtable.keys();
            long l2 = 0L;
            while (!this.canceled && enumeration2.hasMoreElements()) {
                ResourceReader resourceReader = (ResourceReader)enumeration2.nextElement();
                if (hashtable2.containsKey(resourceReader)) continue;
                ResourceWriter resourceWriter = (ResourceWriter)hashtable.get(resourceReader);
                try {
                    OutputStream outputStream;
                    InputStream inputStream;
                    block14: {
                        inputStream = resourceReader.open();
                        outputStream = resourceWriter.open();
                        int n2 = 0;
                        if (inputStream != null && outputStream != null) {
                            try {
                                while (!this.canceled && (n = inputStream.read(byArray)) != -1) {
                                    outputStream.write(byArray, 0, n);
                                    if (!this.calculateProgress) continue;
                                    n2 += n;
                                    genericProgress.setPercentComplete(l2 += (long)n, l);
                                    this.logEvent(PROGRESS, genericProgress);
                                }
                            }
                            catch (EOFException eOFException) {
                                if (inputStream.available() <= 0) break block14;
                                throw eOFException;
                            }
                        }
                    }
                    resourceReader.close(inputStream);
                    resourceWriter.close(outputStream);
                    this.recordResourceWrite(resourceReader, resourceWriter);
                }
                catch (IOException iOException) {
                    this.logEvent("wrn", "Error writing " + resourceReader + " to " + resourceWriter + ": " + iOException);
                    if (System.getProperty("is.debug") == null) continue;
                    iOException.printStackTrace();
                }
            }
        }
        if (!this.canceled) {
            this.logEvent(WRITE_FINISHED, "Finished writing archive ");
        }
    }
}

