/*
 * Decompiled with CFR 0.152.
 */
package com.installshield.archive.ijar;

import com.installshield.archive.ijar.IJAREntry;
import com.installshield.util.FileAttributes;
import java.io.ByteArrayInputStream;
import java.io.DataInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Vector;
import java.util.zip.InflaterInputStream;

class IJARIndexReader {
    private int currentPacket = -1;
    private int packetSize;
    private Vector compressed;
    private Vector currentEntries;

    IJARIndexReader(InputStream inputStream) throws IOException {
        DataInputStream dataInputStream = new DataInputStream(inputStream);
        this.packetSize = dataInputStream.readInt();
        this.currentEntries = new Vector(this.packetSize);
        int n = dataInputStream.readInt();
        this.compressed = new Vector(n);
        int n2 = 0;
        while (n2 < n) {
            byte[] byArray = new byte[dataInputStream.readInt()];
            dataInputStream.readFully(byArray);
            this.compressed.addElement(byArray);
            ++n2;
        }
    }

    IJAREntry getEntry(int n) throws IOException {
        int n2 = n / this.packetSize;
        if (n2 != this.currentPacket) {
            this.setCurrentPacket(n2);
        }
        int n3 = n % this.packetSize;
        return (IJAREntry)this.currentEntries.elementAt(n3);
    }

    private void setCurrentPacket(int n) throws IOException {
        this.currentEntries.removeAllElements();
        System.gc();
        byte[] byArray = (byte[])this.compressed.elementAt(n);
        InflaterInputStream inflaterInputStream = new InflaterInputStream(new ByteArrayInputStream(byArray));
        DataInputStream dataInputStream = new DataInputStream(inflaterInputStream);
        int n2 = dataInputStream.readInt();
        int n3 = 0;
        while (n3 < n2) {
            byte[] byArray2 = new byte[16];
            dataInputStream.readFully(byArray2);
            String string = dataInputStream.readUTF();
            int n4 = dataInputStream.readInt();
            long l = dataInputStream.readLong();
            FileAttributes fileAttributes = null;
            if (dataInputStream.readBoolean()) {
                fileAttributes = new FileAttributes();
                fileAttributes.read(dataInputStream);
            }
            long l2 = dataInputStream.readLong();
            byte[] byArray3 = new byte[dataInputStream.readInt()];
            dataInputStream.readFully(byArray3);
            this.currentEntries.addElement(new IJAREntry(byArray2, string, n4, l, fileAttributes, l2, byArray3));
            ++n3;
        }
        this.currentPacket = n;
    }
}

