/*
 * Decompiled with CFR 0.152.
 */
package com.installshield.product.actions;

import com.installshield.product.Locatable;
import com.installshield.product.ProductAction;
import com.installshield.product.ProductActionSupport;
import com.installshield.product.ProductBuilderSupport;
import com.installshield.product.ProductException;
import com.installshield.product.actions.JVMResolutionExtra;
import com.installshield.util.FileUtils;
import com.installshield.util.jvm.JVMFile;
import com.installshield.wizard.service.OperationKey;
import com.installshield.wizard.service.ServiceException;
import com.installshield.wizard.service.WizardLog;
import com.installshield.wizard.service.file.FileService;
import com.installshield.wizard.service.jvm.JVMService;
import com.installshield.wizard.service.system.SystemUtilService;
import java.util.Dictionary;
import java.util.Enumeration;
import java.util.Vector;

public class JVMResolution
extends ProductAction
implements Locatable {
    public static final int CURRENT_SEARCH_INSTALL = 1;
    public static final int SEARCH_CURRENT_INSTALL = 2;
    public static final String UNSPECIFIED = "unspecified";
    public static final String YES = "$L(com.installshield.wizard.i18n.WizardResources, yes)";
    public static final String NO = "$L(com.installshield.wizard.i18n.WizardResources, no)";
    public static final String CANCEL = "$L(com.installshield.wizard.i18n.WizardResources, cancel)";
    private static final int EST_COPY_TIME = 10;
    private static final int EST_INSTALL_TIME = 20;
    private static final int EST_SEARCH_TIME = 40;
    private String jvmId = "jvm";
    private String installLocation = "_jvm";
    private String replaceJVMResponse = "unspecified";
    private boolean useInstalledJVM = true;
    private String installedDirectory = null;
    static Class class$com$installshield$util$jvm$JVMInstaller;
    static Class class$com$installshield$product$actions$JVMResolutionExtra;

    public void build(ProductBuilderSupport productbuildersupport) {
        try {
            productbuildersupport.putRequiredService("jvmService");
            productbuildersupport.putRequiredService("fileService");
            productbuildersupport.putRequiredService("systemUtilService");
            productbuildersupport.putClass((class$com$installshield$util$jvm$JVMInstaller == null ? (class$com$installshield$util$jvm$JVMInstaller = JVMResolution.class$("com.installshield.util.jvm.JVMInstaller")) : class$com$installshield$util$jvm$JVMInstaller).getName());
            productbuildersupport.putClass((class$com$installshield$product$actions$JVMResolutionExtra == null ? (class$com$installshield$product$actions$JVMResolutionExtra = JVMResolution.class$("com.installshield.product.actions.JVMResolutionExtra")) : class$com$installshield$product$actions$JVMResolutionExtra).getName());
            boolean flag = false;
            Dictionary dictionary = this.getExtendedProperties();
            Enumeration enumeration = dictionary.keys();
            while (enumeration.hasMoreElements()) {
                String s = (String)enumeration.nextElement();
                if (!(dictionary.get(s) instanceof JVMResolutionExtra)) continue;
                JVMResolutionExtra jvmresolutionextra = (JVMResolutionExtra)dictionary.get(s);
                JVMFile[] ajvmfile = jvmresolutionextra.getJVMFileSources();
                String[] as = new String[ajvmfile.length];
                int i = 0;
                while (i < ajvmfile.length) {
                    JVMFile jvmfile = ajvmfile[i];
                    as[i] = this.createJVMResourceName(s, jvmfile.getName());
                    productbuildersupport.putResource(jvmfile.getInputStream(), as[i]);
                    if (as[i] != null && !as[i].equals("")) {
                        productbuildersupport.excludeUninstallerResource(as[i]);
                    }
                    ++i;
                }
                jvmresolutionextra.setJVMFileResources(as);
                String s1 = jvmresolutionextra.getBundledJVMSource();
                if (s1 != null && s1.length() > 0) {
                    String s2 = this.createJVMResourceName(s, FileUtils.getName(s1));
                    jvmresolutionextra.setBundledJVMResource(s2);
                    productbuildersupport.putResource(s1, s2);
                    if (s2 != null && !s2.equals("")) {
                        productbuildersupport.excludeUninstallerResource(s2);
                    }
                }
                flag = true;
            }
            if (this.isActive() && !flag) {
                productbuildersupport.logEvent(this, "err", "No platform specific JVM resolution properties included -- will not resolve at runtime");
            }
        }
        catch (Exception exception) {
            productbuildersupport.logEvent(this, "err", exception);
        }
    }

    protected boolean checkTarget(String s, ProductActionSupport productactionsupport) {
        try {
            FileService fileservice = (FileService)this.getService("fileService");
            String[] as = fileservice.getDirectoryList(s, 2);
            if (as != null && as.length > 0) {
                return this.promptToInstall(s, productactionsupport) && !productactionsupport.getOperationState().isCanceled();
            }
        }
        catch (ServiceException serviceException) {
            this.logEvent(this, "err", "Cannot verify that JVM target \"" + s + "\" is empty -- JVM will not be installed");
            return false;
        }
        return true;
    }

    static Class class$(String s) {
        try {
            return Class.forName(s);
        }
        catch (ClassNotFoundException classnotfoundexception) {
            throw new NoClassDefFoundError(classnotfoundexception.getMessage());
        }
    }

    private String createJVMResourceName(String s, String s1) {
        return String.valueOf(this.getBeanId()) + "/" + s + "/" + s1;
    }

    public int getEstimatedTimeToInstall() {
        try {
            String s1;
            JVMService jvmservice = (JVMService)this.getService("jvmService");
            String s = jvmservice.getPlatformId();
            JVMResolutionExtra jvmresolutionextra = this.getExtra(s);
            if (jvmresolutionextra == null) {
                return 0;
            }
            int i = 0;
            int j = 0;
            if (jvmresolutionextra.getUseCurrentJVM()) {
                i += jvmservice.isCurrentJVMTemporary() ? 10 : 0;
                ++j;
            }
            if ((s1 = jvmresolutionextra.getBundledJVMResource()) != null && s1.trim().length() > 0) {
                i += 20;
                ++j;
            }
            if (jvmresolutionextra.getJVMFileResources().length > 0) {
                i += 40;
                ++j;
            }
            return j <= 0 ? 0 : i / j;
        }
        catch (ServiceException serviceexception) {
            this.logEvent(this, "err", serviceexception);
            return 0;
        }
    }

    private JVMResolutionExtra getExtra(String s) {
        Dictionary dictionary = this.getExtendedProperties();
        if (dictionary != null) {
            Enumeration enumeration = dictionary.keys();
            while (enumeration.hasMoreElements()) {
                String s1 = (String)enumeration.nextElement();
                Object obj = dictionary.get(s1);
                if (obj == null || !(obj instanceof JVMResolutionExtra) || !s.equals(((JVMResolutionExtra)obj).getPlatformId())) continue;
                return (JVMResolutionExtra)dictionary.get(s1);
            }
        }
        return null;
    }

    private Enumeration getExtras() {
        Vector<JVMResolutionExtra> vector = new Vector<JVMResolutionExtra>();
        Dictionary dictionary = this.getExtendedProperties();
        Enumeration enumeration = dictionary.keys();
        while (enumeration.hasMoreElements()) {
            String s = (String)enumeration.nextElement();
            if (!(dictionary.get(s) instanceof JVMResolutionExtra)) continue;
            vector.addElement((JVMResolutionExtra)dictionary.get(s));
        }
        return vector.elements();
    }

    public String getInstallLocation() {
        return this.installLocation;
    }

    public String getInstalledDirectory() {
        return this.installedDirectory;
    }

    public String getJVMId() {
        return this.jvmId;
    }

    public String getReplaceJVMResponse() {
        return this.replaceJVMResponse;
    }

    public boolean getUseInstalledJVM() {
        return this.useInstalledJVM;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void install(ProductActionSupport productactionsupport) throws ProductException {
        int i = this.getEstimatedTimeToInstall();
        productactionsupport.getOperationState().resetUpdateCounter();
        boolean flag = false;
        try {
            String s1;
            FileService fileservice;
            JVMService jvmservice = (JVMService)this.getService("jvmService");
            if (this.getUseInstalledJVM() && this.getInstalledDirectory() != null && (fileservice = (FileService)this.getService("fileService")).fileExists(s1 = FileUtils.createFileName(this.getInstalledDirectory(), "jvm"))) {
                this.logDebugEvent("resolved to " + s1);
                jvmservice.associateJVM(this.getJVMId(), s1);
                flag = true;
            }
            if (!flag) {
                String s = jvmservice.getPlatformId();
                JVMResolutionExtra jvmresolutionextra = this.getExtra(s);
                if (jvmresolutionextra != null) {
                    if (jvmresolutionextra.getJVMResolution() == 1) {
                        flag = this.useCurrentJVM(jvmresolutionextra, jvmservice, productactionsupport, i) || this.searchForJVM(jvmresolutionextra, jvmservice, productactionsupport, i) || this.installJVM(jvmresolutionextra, jvmservice, productactionsupport, i);
                    } else {
                        if (jvmresolutionextra.getJVMResolution() != 2) throw new ProductException(601, "Unknown JVMResolution property " + jvmresolutionextra.getJVMResolution() + " -- unable to resolve JVM");
                        flag = this.searchForJVM(jvmresolutionextra, jvmservice, productactionsupport, i) || this.useCurrentJVM(jvmresolutionextra, jvmservice, productactionsupport, i) || this.installJVM(jvmresolutionextra, jvmservice, productactionsupport, i);
                    }
                } else {
                    this.logEvent(this, "wrn", "Cannot find JVM resolution information for platform key \"" + s + "\" -- unable to resolve JVM");
                }
            }
        }
        catch (ServiceException serviceexception) {
            this.logEvent(this, "err", serviceexception.toString());
        }
        long l = (long)i - productactionsupport.getOperationState().getUpdateCounter();
        productactionsupport.getOperationState().updatePercentComplete(i, l, i);
        if (flag) return;
        throw new ProductException(601, "Failed to resolve JVM");
    }

    protected boolean installJVM(JVMResolutionExtra jvmresolutionextra, JVMService jvmservice, ProductActionSupport productactionsupport, int i) {
        block13: {
            if (productactionsupport.getOperationState().isCanceled()) {
                return false;
            }
            if (jvmresolutionextra.getBundledJVMResource() == null || jvmresolutionextra.getBundledJVMResource().trim().length() == 0) {
                return false;
            }
            this.logDebugEvent("installing the bundled JVM");
            try {
                boolean flag1;
                String s = this.getProductTree().getInstallLocation(this);
                if (!this.checkTarget(s, productactionsupport)) break block13;
                OperationKey operationkey = jvmservice.installJVM(this.jvmId, jvmresolutionextra.getBundledJVMResource(), jvmresolutionextra.getBundledJVMArguments(), s);
                int j = jvmresolutionextra.getTimeout() * 1000;
                long l = System.currentTimeMillis() + (long)j;
                boolean flag = false;
                int k = 0;
                while (!flag && !jvmservice.isOperationEnded(operationkey)) {
                    OperationKey operationKey = operationkey;
                    synchronized (operationKey) {
                        try {
                            operationkey.wait(1000L);
                            if (k < 20) {
                                productactionsupport.getOperationState().updatePercentComplete(i, 10L, i);
                                k += 10;
                            }
                            flag = System.currentTimeMillis() >= l;
                        }
                        catch (InterruptedException interruptedException) {
                            this.logEvent(this, "wrn", "JVM install operation timed out after " + j / 1000 + " seconds");
                        }
                    }
                }
                if (flag) {
                    this.logEvent(this, "err", "JVM resolution timed out");
                }
                boolean bl = flag1 = !flag && jvmservice.getJVMFile(this.jvmId) != null;
                if (flag1) {
                    this.setInstalledDirectory(s);
                }
                return flag1;
            }
            catch (ServiceException serviceexception) {
                this.logEvent(this, "wrn", "Install current JVM failed: " + serviceexception.getMessage());
            }
        }
        return false;
    }

    private void logDebugEvent(String s) {
        this.logEvent(this, WizardLog.subclassEvent("dbg", "jvm"), s);
    }

    protected boolean promptToInstall(String s, ProductActionSupport productactionsupport) {
        return true;
    }

    protected boolean searchForJVM(JVMResolutionExtra jvmresolutionextra, JVMService jvmservice, ProductActionSupport productactionsupport, int i) {
        this.logDebugEvent("searching for a JVM");
        if (productactionsupport.getOperationState().isCanceled()) {
            return false;
        }
        if (jvmresolutionextra.getJVMFileResources().length == 0) {
            return false;
        }
        try {
            OperationKey operationkey = jvmservice.findJVM(this.jvmId, jvmresolutionextra.getJVMFileResources());
            int j = jvmresolutionextra.getTimeout() * 1000;
            long l = System.currentTimeMillis() + (long)j;
            boolean flag = false;
            int k = 0;
            while (!flag && !jvmservice.isOperationEnded(operationkey)) {
                OperationKey operationKey = operationkey;
                synchronized (operationKey) {
                    try {
                        operationkey.wait(1000L);
                        if (k < 40) {
                            productactionsupport.getOperationState().updatePercentComplete(i, 10L, i);
                            k += 10;
                        }
                        flag = System.currentTimeMillis() >= l;
                    }
                    catch (InterruptedException interruptedException) {
                        this.logEvent(this, "wrn", "JVM search operation timed out after " + j / 1000 + " seconds");
                    }
                }
            }
            if (flag) {
                this.logEvent(this, "err", "JVM resolution timed out");
            }
            this.logDebugEvent("resolved to JVM file: " + jvmservice.getJVMFile(this.jvmId) + " with JVM_HOME = " + jvmservice.getJVMHome(this.jvmId));
            return !flag && jvmservice.getJVMFile(this.jvmId) != null;
        }
        catch (ServiceException serviceexception) {
            this.logEvent(this, "wrn", "an error occurred while searching for JVM: " + serviceexception);
            return false;
        }
    }

    public void setInstallLocation(String s) {
        this.installLocation = s;
    }

    public void setInstalledDirectory(String s) {
        this.installedDirectory = s;
    }

    public void setJVMId(String s) {
        this.jvmId = s;
    }

    public void setReplaceJVMResponse(String s) {
        this.replaceJVMResponse = s;
    }

    public void setUseInstalledJVM(boolean flag) {
        this.useInstalledJVM = flag;
    }

    public void uninstall(ProductActionSupport productactionsupport) throws ProductException {
        if (this.getInstalledDirectory() != null) {
            try {
                SystemUtilService systemutilservice = (SystemUtilService)this.getService("systemUtilService");
                systemutilservice.deleteDirectoryOnExit(this.getInstalledDirectory(), true);
            }
            catch (Exception exception) {
                throw new ProductException(exception);
            }
        }
    }

    protected boolean useCurrentJVM(JVMResolutionExtra jvmresolutionextra, JVMService jvmservice, ProductActionSupport productactionsupport, int i) {
        if (productactionsupport.getOperationState().isCanceled()) {
            return false;
        }
        if (!jvmresolutionextra.getUseCurrentJVM()) {
            return false;
        }
        this.logDebugEvent("attempting to use the current JVM");
        boolean flag = false;
        try {
            if (jvmservice.isCurrentJVMDefined()) {
                if (jvmservice.isCurrentJVMTemporary()) {
                    String s = this.getProductTree().getInstallLocation(this);
                    if (this.checkTarget(s, productactionsupport)) {
                        this.logDebugEvent("copying the current JVM");
                        jvmservice.copyCurrentJVM(this.jvmId, s);
                        this.setInstalledDirectory(s);
                        productactionsupport.getOperationState().updatePercentComplete(i, 10L, i);
                        flag = true;
                    }
                } else {
                    this.logDebugEvent("resolved to the current jvm file: " + jvmservice.getJVMFile(this.jvmId) + " with JVM_HOME = " + jvmservice.getJVMHome(this.jvmId));
                    jvmservice.associateCurrentJVM(this.jvmId);
                    flag = true;
                }
            }
        }
        catch (ServiceException serviceexception) {
            this.logEvent(this, "wrn", "An error occurred attempting to copy the current JVM: " + serviceexception);
        }
        return flag;
    }
}

