/*
 * Decompiled with CFR 0.152.
 */
package com.installshield.product.iterators;

import com.installshield.product.BaseProductTreeIterator;
import com.installshield.product.FilteredProductTreeIterator;
import com.installshield.product.ProductBean;
import com.installshield.product.ProductBeanFilter;
import com.installshield.product.ProductException;
import com.installshield.product.ProductReference;
import com.installshield.product.ProductTree;
import com.installshield.product.service.product.ProductTreeSource;
import com.installshield.util.Log;
import com.installshield.wizard.service.ServiceException;
import java.util.Hashtable;

public class MultiProductTreeIterator
implements FilteredProductTreeIterator {
    public static final String ITERATOR_KEY = "iterator";
    private BaseProductTreeIterator iter;
    private ProductTreeSource productTreeSource;
    private Log log;
    private Hashtable roots = new Hashtable();
    private Hashtable productRefs = new Hashtable();

    public MultiProductTreeIterator(BaseProductTreeIterator baseProductTreeIterator, ProductTreeSource productTreeSource, Log log) {
        this.iter = baseProductTreeIterator;
        this.productTreeSource = productTreeSource;
        this.log = log;
        this.roots.put(baseProductTreeIterator.getRoot().getProductTree(), baseProductTreeIterator.getRoot());
    }

    public void addFilter(ProductBeanFilter productBeanFilter) {
        this.iter.addFilter(productBeanFilter);
    }

    public ProductBean begin() {
        return this.iter.begin();
    }

    private ProductBean dereferenceNext(ProductReference productReference) throws ProductException {
        this.updateIterator(productReference);
        return this.iter.getNext(this.iter.begin());
    }

    private ProductBean dereferencePrevious(ProductReference productReference) throws ProductException {
        this.updateIterator(productReference);
        return this.iter.getPrevious(this.iter.end());
    }

    public ProductBean end() {
        return this.iter.end();
    }

    public ProductBean getNext(ProductBean productBean) {
        ProductReference productReference;
        ProductBean productBean2;
        ProductTree productTree = productBean.getProductTree();
        if (productTree != null && (productBean2 = (ProductBean)this.roots.get(productBean.getProductTree())) != null && productBean2 != this.iter.getRoot()) {
            this.iter.setRoot(productBean2);
        }
        if ((productBean2 = this.iter.getNext(productBean)) instanceof ProductReference) {
            try {
                productBean2 = this.dereferenceNext((ProductReference)productBean2);
            }
            catch (ProductException productException) {
                this.logError(productException);
                productBean2 = this.getNext(productBean2);
            }
        } else if (productBean2 == this.iter.end() && productTree != null && (productReference = (ProductReference)this.productRefs.get(productBean.getProductTree())) != null) {
            productBean2 = this.getNext(productReference);
        }
        return productBean2;
    }

    public ProductBean getPrevious(ProductBean productBean) {
        ProductReference productReference;
        ProductBean productBean2;
        ProductTree productTree = productBean.getProductTree();
        if (productTree != null && (productBean2 = (ProductBean)this.roots.get(productBean.getProductTree())) != null && productBean2 != this.iter.getRoot()) {
            this.iter.setRoot(productBean2);
        }
        if ((productBean2 = this.iter.getPrevious(productBean)) instanceof ProductReference) {
            try {
                productBean2 = this.dereferencePrevious((ProductReference)productBean2);
            }
            catch (ProductException productException) {
                this.logError(productException);
                productBean2 = this.getPrevious(productBean2);
            }
        } else if (productBean2 == this.iter.begin() && productTree != null && (productReference = (ProductReference)this.productRefs.get(productTree)) != null) {
            productBean2 = this.getPrevious(productReference);
        }
        return productBean2;
    }

    private void logError(Exception exception) {
        if (this.log != null) {
            this.log.logEvent(this, "err", exception);
        } else {
            exception.printStackTrace();
        }
    }

    public void removeFilter(ProductBeanFilter productBeanFilter) {
        this.iter.removeFilter(productBeanFilter);
    }

    private void updateIterator(ProductReference productReference) throws ProductException {
        try {
            ProductTree productTree = this.productTreeSource.getProductTree(productReference.getInstaller(), "/product.xml");
            this.roots.put(productTree, productTree.getRoot());
            this.productRefs.put(productTree, productReference);
            this.iter.setRoot(productTree.getRoot());
        }
        catch (ServiceException serviceException) {
            throw new ProductException(serviceException);
        }
    }
}

