/*
 * Decompiled with CFR 0.152.
 */
package com.installshield.product.service.product;

import com.installshield.archive.ArchiveWriter;
import com.installshield.archive.StandardResourceReaderFactory;
import com.installshield.archive.ZipResourceWriterFactory;
import com.installshield.beans.ISIntrospector;
import com.installshield.product.FilteredProductTreeIterator;
import com.installshield.product.GenericSoftwareObject;
import com.installshield.product.Product;
import com.installshield.product.ProductAction;
import com.installshield.product.ProductActionSupport;
import com.installshield.product.ProductBean;
import com.installshield.product.ProductBeanPlaceHolder;
import com.installshield.product.ProductComponent;
import com.installshield.product.ProductComponentReference;
import com.installshield.product.ProductException;
import com.installshield.product.ProductFeature;
import com.installshield.product.ProductTree;
import com.installshield.product.ProductTreeIterator;
import com.installshield.product.ProductTreeIteratorFactory;
import com.installshield.product.RequiredBytesTable;
import com.installshield.product.SoftwareObject;
import com.installshield.product.SoftwareObjectKey;
import com.installshield.product.SoftwareObjectReference;
import com.installshield.product.StandardProductTreeIterator;
import com.installshield.product.Suite;
import com.installshield.product.actions.UninstallerArchive;
import com.installshield.product.actions.UninstallerLauncher;
import com.installshield.product.iterators.ActiveProductTreeIterator;
import com.installshield.product.iterators.ChildrenProductTreeIterator;
import com.installshield.product.iterators.ConditionalProductTreeIterator;
import com.installshield.product.iterators.ProductActionTreeIterator;
import com.installshield.product.iterators.ProductTypeTreeIterator;
import com.installshield.product.service.product.InstallCheck;
import com.installshield.product.service.product.InstallableObjectVisitor;
import com.installshield.product.service.product.ProductServiceImplementor;
import com.installshield.product.service.product.ProductTreeSource;
import com.installshield.product.service.product.RequiredBytes;
import com.installshield.product.service.product.TimeToInstall;
import com.installshield.product.service.registry.RegistryService;
import com.installshield.qjml.QJML;
import com.installshield.util.CommandLineTokenizer;
import com.installshield.util.FileUtils;
import com.installshield.util.LocalizedStringResolver;
import com.installshield.util.Log;
import com.installshield.util.LogListener;
import com.installshield.util.PropertyAssignmentParser;
import com.installshield.util.PropertyReadParser;
import com.installshield.wizard.service.AbstractServiceImplementor;
import com.installshield.wizard.service.AsynchronousOperation;
import com.installshield.wizard.service.MutableOperationState;
import com.installshield.wizard.service.OperationKey;
import com.installshield.wizard.service.ServiceException;
import com.installshield.wizard.service.ServiceFactory;
import com.installshield.wizard.service.WizardLog;
import com.installshield.wizard.service.WizardServices;
import com.installshield.wizard.service.exitcode.ExitCodeService;
import com.installshield.wizard.service.file.FileService;
import com.installshield.wizard.service.log.LogService;
import com.installshield.wizard.service.system.SystemUtilService;
import java.beans.BeanInfo;
import java.beans.IntrospectionException;
import java.beans.PropertyDescriptor;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.lang.reflect.Method;
import java.net.URL;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Properties;
import java.util.Vector;
import java.util.zip.ZipException;
import java.util.zip.ZipOutputStream;

public class PureJavaProductServiceImpl
extends AbstractServiceImplementor
implements ProductServiceImplementor,
Log {
    private Hashtable redirectedProductSources = new Hashtable();
    private RegistryService registryService = null;
    static /* synthetic */ Class class$com$installshield$product$ProductTree;

    private void addLogSummary(LogSummary logSummary, int n, String string) throws ServiceException {
        this.getServices().setValue(this.createLogSummaryKey(n, string), logSummary);
    }

    private void addParentInVPD(ProductBean productBean, SoftwareObjectKey softwareObjectKey) throws ServiceException {
        ProductBean productBean2 = productBean.getProductTree().getParent(productBean);
        SoftwareObjectKey softwareObjectKey2 = null;
        if (productBean2 == null) {
            softwareObjectKey2 = softwareObjectKey;
        } else if (productBean2 instanceof SoftwareObject) {
            softwareObjectKey2 = ((SoftwareObject)((Object)productBean2)).getKey();
        } else if (productBean2 instanceof SoftwareObjectReference) {
            softwareObjectKey2 = ((SoftwareObjectReference)productBean2).getKey();
        }
        if (softwareObjectKey2 != null && this.installingParent(productBean.getProductTree(), softwareObjectKey2)) {
            this.getRegistryService().addParentSoftwareObjects(softwareObjectKey, new SoftwareObjectKey[]{softwareObjectKey2});
        }
    }

    private void addToVPD(SoftwareObject softwareObject) throws ServiceException {
        SoftwareObjectKey softwareObjectKey = this.getRegistryService().setSoftwareObject(softwareObject);
        softwareObject.getKey().setInstance(softwareObjectKey.getInstance());
    }

    private String appendLogFileToMsg(String string) {
        String string2 = new String(string);
        try {
            LogService logService = (LogService)this.getServices().getService("logService");
            String string3 = logService.getLogOutput();
            if (string3 != null && string3.length() > 0) {
                string2 = String.valueOf(string2) + "  ";
                string2 = String.valueOf(string2) + LocalizedStringResolver.resolve("com.installshield.product.i18n.ProductResources", "PureJavaProductServiceImpl.seeLogFile", new String[]{string3});
            }
        }
        catch (ServiceException serviceException) {}
        return string2;
    }

    private boolean canContinueInstall(int n) {
        return n == 0 || n == 1;
    }

    protected boolean canDeleteUninstaller(ProductTree productTree) {
        SoftwareObject softwareObject = (SoftwareObject)((Object)productTree.getRoot());
        return softwareObject.getInstallStatus() == 4;
    }

    private boolean childrenInstalled(SoftwareObject softwareObject, ProductTree productTree) {
        boolean bl = false;
        SoftwareObject softwareObject2 = null;
        SoftwareObjectReference softwareObjectReference = null;
        ProductTreeIterator productTreeIterator = ProductTreeIteratorFactory.createChildComponentIterator((ProductBean)((Object)softwareObject), true);
        ProductBean productBean = productTreeIterator.getNext(productTreeIterator.begin());
        while (!bl && productBean != productTreeIterator.end()) {
            if (productBean instanceof SoftwareObject) {
                softwareObject2 = (SoftwareObject)((Object)productBean);
            } else if (productBean instanceof SoftwareObjectReference) {
                softwareObjectReference = (SoftwareObjectReference)productBean;
                softwareObject2 = productTree.resolveKey(softwareObjectReference.getKey());
            }
            if (softwareObject2 != null) {
                bl = softwareObject2.getInstallStatus() == 3;
            }
            productBean = productTreeIterator.getNext(productBean);
        }
        return bl;
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    protected void configureUninstallerForCreation(ProductTree productTree) {
        UninstallerArchive uninstallerArchive = productTree.getUninstallerArchive();
        String string = productTree.getInstallLocation(uninstallerArchive);
        File file = new File(string);
        String string2 = uninstallerArchive.getInstallLocation();
        int n = 2;
        while (file.exists() && file.isDirectory()) {
            file = new File(String.valueOf(string) + n);
            string2 = String.valueOf(uninstallerArchive.getInstallLocation()) + n;
            ++n;
        }
        uninstallerArchive.setInstallLocation(string2);
    }

    protected void configureWizardLogForInstall(ProductTree productTree) {
        if (productTree.getLogFile() != null && productTree.getLogFile().trim().length() > 0) {
            WizardLog wizardLog = this.getServices().getWizardLog();
            String string = FileUtils.createFileName(productTree.getInstallLocation(productTree.getRoot()), productTree.getLogFile());
            wizardLog.copyLogOutput(string, true);
            wizardLog.setLogOutput(string);
        }
    }

    private void createActiveNodeTable(ProductBean productBean, ProductTree productTree, Hashtable hashtable, Vector vector, ProductActionSupport productActionSupport, int n) throws ServiceException {
        ProductTreeIterator productTreeIterator = ProductTreeIteratorFactory.createUninstallerComponentIterator(productBean, n);
        ProductBean productBean2 = productTreeIterator.getNext(productTreeIterator.begin());
        while (productBean2 != productTreeIterator.end()) {
            SoftwareObject softwareObject = null;
            SoftwareObjectReference softwareObjectReference = null;
            if (productBean2 instanceof SoftwareObject) {
                softwareObject = (SoftwareObject)((Object)productBean2);
            } else if (productBean2 instanceof SoftwareObjectReference) {
                softwareObjectReference = (SoftwareObjectReference)productBean2;
                softwareObject = productTree.resolveKey(softwareObjectReference.getKey());
                if (softwareObject != null) {
                    if (!hashtable.containsKey(softwareObject.getKey())) {
                        this.createActiveNodeTable((ProductBean)((Object)softwareObject), productTree, hashtable, vector, productActionSupport, n);
                    }
                } else {
                    GenericSoftwareObject genericSoftwareObject;
                    softwareObject = this.getRegistryService().getSoftwareObject(softwareObjectReference.getKey());
                    if (softwareObject != null && softwareObject instanceof GenericSoftwareObject && (genericSoftwareObject = (GenericSoftwareObject)softwareObject).getRequired().length > 0) {
                        this.createActiveNodeTable(genericSoftwareObject, productTree, hashtable, vector, productActionSupport, n);
                    }
                }
            }
            if (softwareObject != null) {
                if (!hashtable.containsKey(softwareObject.getKey())) {
                    hashtable.put(softwareObject.getKey(), new Node((ProductBean)((Object)softwareObject)));
                    vector.addElement(softwareObject.getKey());
                }
            } else {
                this.getServices().logEvent(this, "wrn", "Unable to resolve reference with displayName = " + this.getProductBeanDisplayName(softwareObjectReference) + " and UID = " + softwareObjectReference.getKey().getUID() + " in Product Tree or in VPD.");
            }
            productBean2 = productTreeIterator.getNext(productBean2);
        }
    }

    private InstallCheck[] createChecks(String string) {
        DiskSpaceCheck diskSpaceCheck = new DiskSpaceCheck();
        DependenciesCheck dependenciesCheck = new DependenciesCheck();
        InstallCheck[] installCheckArray = this.getAdditionalChecks(string);
        if (installCheckArray == null) {
            installCheckArray = new InstallCheck[]{};
        }
        InstallCheck[] installCheckArray2 = new InstallCheck[installCheckArray.length + 2];
        installCheckArray2[0] = diskSpaceCheck;
        installCheckArray2[1] = dependenciesCheck;
        int n = 0;
        while (n < installCheckArray.length) {
            installCheckArray2[n + 2] = installCheckArray[n];
            ++n;
        }
        return installCheckArray2;
    }

    private String createLogSummaryKey(int n, String string) {
        return "productService.logSummary(" + n + ", " + string;
    }

    protected ProductActionSupport createProductActionSupport(ArchiveWriter archiveWriter, MutableOperationState mutableOperationState, UninstallerArchive uninstallerArchive) {
        return new ProductActionSupport(archiveWriter, mutableOperationState, uninstallerArchive);
    }

    protected boolean deleteUninstaller(ProductTree productTree) {
        String string = ((GenericSoftwareObject)productTree.getRoot()).getUninstaller();
        try {
            SystemUtilService systemUtilService = (SystemUtilService)this.getServices().getService("systemUtilService");
            systemUtilService.deleteFileOnExit(string);
            return true;
        }
        catch (ServiceException serviceException) {
            return false;
        }
    }

    protected void executeCheck(InstallCheck installCheck, String string, WizardServices wizardServices, LogSummary logSummary) {
        WizardServicesLog wizardServicesLog = new WizardServicesLog(this.getServices());
        this.getServices().addLogListener(logSummary);
        installCheck.execute(string, wizardServices, wizardServicesLog);
        this.getServices().removeLogListener(logSummary);
    }

    public Properties executeChecks(String string, String[] stringArray, String string2) {
        InstallCheck[] installCheckArray;
        Hashtable<String, String> hashtable = new Hashtable<String, String>();
        int n = 0;
        while (n < stringArray.length) {
            hashtable.put(stringArray[n], "");
            ++n;
        }
        LogSummary logSummary = new LogSummary(" ");
        try {
            installCheckArray = this.getChecksForProduct(string);
            int n2 = 0;
            while (n2 < installCheckArray.length) {
                if (hashtable.containsKey(installCheckArray[n2].getName())) {
                    this.executeCheck(installCheckArray[n2], string, this.getServices(), logSummary);
                }
                ++n2;
            }
        }
        catch (ServiceException serviceException) {
            installCheckArray = new InstallCheck[]{};
            logSummary.eventLogged(this, "err", serviceException);
        }
        Properties properties = new Properties();
        ((Hashtable)properties).put("summary.msg", this.getLogSummaryMsg(logSummary, string, string2, 1));
        ((Hashtable)properties).put("summary.error.count", String.valueOf(logSummary.errorCount()));
        ((Hashtable)properties).put("summary.warning.count", String.valueOf(logSummary.warningCount()));
        ((Hashtable)properties).put("summary.message.count", String.valueOf(logSummary.messageCount()));
        int n3 = 0;
        while (n3 < installCheckArray.length) {
            ((Hashtable)properties).put(String.valueOf(installCheckArray[n3].getName()) + "." + "passed", new Integer(installCheckArray[n3].getStatus()));
            ++n3;
        }
        return properties;
    }

    private String getAbsoluteInstallLocation(ProductBean productBean) {
        return productBean.getProductTree().getInstallLocation(productBean);
    }

    protected InstallCheck[] getAdditionalChecks(String string) {
        return null;
    }

    private ProductTree getCachedProductTree(String string) {
        return (ProductTree)this.getServices().getValue(string);
    }

    private InstallCheck[] getChecksForProduct(String string) throws ServiceException {
        InstallCheck[] installCheckArray;
        Hashtable<String, InstallCheck[]> hashtable = (Hashtable<String, InstallCheck[]>)this.getServices().getValue("checks");
        if (hashtable == null) {
            hashtable = new Hashtable<String, InstallCheck[]>();
            this.getServices().setValue("checks", hashtable);
        }
        if ((installCheckArray = (InstallCheck[])hashtable.get(string)) == null) {
            installCheckArray = this.createChecks(string);
            hashtable.put(string, installCheckArray);
        }
        return installCheckArray;
    }

    private Class getFilterClass(Properties properties) {
        String string = (String)((Hashtable)properties).get("filter.class");
        if (string != null) {
            try {
                return Class.forName(string);
            }
            catch (ClassNotFoundException classNotFoundException) {
            }
        }
        return null;
    }

    public String[] getInstallCheckNames(String string) throws ServiceException {
        InstallCheck[] installCheckArray = this.getChecksForProduct(string);
        String[] stringArray = new String[installCheckArray.length];
        int n = 0;
        while (n < stringArray.length) {
            stringArray[n] = installCheckArray[n].getName();
            ++n;
        }
        return stringArray;
    }

    private LogSummary getLogSummary(int n, String string) throws ServiceException {
        return (LogSummary)this.getServices().getValue(this.createLogSummaryKey(n, string));
    }

    private String getLogSummaryMsg(LogSummary logSummary, String string, String string2, int n) {
        Object object;
        if (logSummary == null) {
            StringBuffer stringBuffer = new StringBuffer();
            stringBuffer.append(LocalizedStringResolver.resolve("com.installshield.product.i18n.ProductResources", "PureJavaProductServiceImpl.noSummary"));
            if (string2.equals("html")) {
                stringBuffer.append("<p>");
            } else if (string2.equals("html")) {
                stringBuffer.append("\n\n");
            }
            stringBuffer.append(LocalizedStringResolver.resolve("com.installshield.product.i18n.ProductResources", "PureJavaProductServiceImpl.invalidSummaryRequest"));
            return stringBuffer.toString();
        }
        StringBuffer stringBuffer = new StringBuffer();
        if (logSummary.hasErrors()) {
            object = n == 4 ? "uninstallationError" : "installationError";
            stringBuffer.append(LocalizedStringResolver.resolve("com.installshield.product.i18n.ProductResources", (String)object));
            if (string2.equals("html")) {
                stringBuffer.append("<ul>");
            } else if (string2.equals("text")) {
                stringBuffer.append("\n\n");
            }
            Enumeration enumeration = logSummary.errors();
            while (enumeration.hasMoreElements()) {
                if (string2.equals("html")) {
                    stringBuffer.append("<li>");
                } else if (string2.equals("text")) {
                    stringBuffer.append(" - ");
                }
                stringBuffer.append(enumeration.nextElement());
                if (!string2.equals("text")) continue;
                stringBuffer.append("\n");
            }
            if (string2.equals("html")) {
                stringBuffer.append("</ul>");
            }
        } else {
            stringBuffer.append(logSummary.getDescription());
        }
        if (logSummary.hasWarnings()) {
            if (!logSummary.hasErrors()) {
                stringBuffer.append(LocalizedStringResolver.resolve("com.installshield.product.i18n.ProductResources", "PureJavaProductServiceImpl.warningGeneratedH"));
            } else {
                if (string2.equals("text")) {
                    stringBuffer.append("\n");
                }
                stringBuffer.append(LocalizedStringResolver.resolve("com.installshield.product.i18n.ProductResources", "PureJavaProductServiceImpl.warningGenerated"));
            }
            if (string2.equals("html")) {
                stringBuffer.append("<ul>");
            } else if (string2.equals("text")) {
                stringBuffer.append("\n\n");
            }
            object = logSummary.warnings();
            while (object.hasMoreElements()) {
                if (string2.equals("html")) {
                    stringBuffer.append("<li>");
                } else if (string2.equals("text")) {
                    stringBuffer.append(" - ");
                }
                stringBuffer.append(object.nextElement());
                if (!string2.equals("text")) continue;
                stringBuffer.append("\n");
            }
            if (string2.equals("html")) {
                stringBuffer.append("</ul>");
            }
        }
        if (logSummary.hasMessages()) {
            if (!logSummary.hasErrors() && !logSummary.hasWarnings()) {
                stringBuffer.append(" ");
            } else if (string2.equals("text")) {
                stringBuffer.append("\n");
            }
            stringBuffer.append(LocalizedStringResolver.resolve("com.installshield.product.i18n.ProductResources", "PureJavaProductServiceImpl.warningGenerated"));
            if (string2.equals("html")) {
                stringBuffer.append("<ul>");
            } else if (string2.equals("text")) {
                stringBuffer.append("\n\n");
            }
            object = logSummary.messages();
            while (object.hasMoreElements()) {
                if (string2.equals("html")) {
                    stringBuffer.append("<li>");
                } else if (string2.equals("text")) {
                    stringBuffer.append(" - ");
                }
                stringBuffer.append(object.nextElement());
                if (!string2.equals("text")) continue;
                stringBuffer.append("\n");
            }
            if (string2.equals("html")) {
                stringBuffer.append("</ul>");
            }
        }
        return stringBuffer.toString();
    }

    private String getMemoryDebugMessage(String string) {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("JVM memory ");
        stringBuffer.append(string);
        stringBuffer.append(": free=");
        stringBuffer.append(Runtime.getRuntime().freeMemory());
        stringBuffer.append(" total=");
        stringBuffer.append(Runtime.getRuntime().totalMemory());
        return stringBuffer.toString();
    }

    private SoftwareObjectKey getNewestInstanceKey(SoftwareObject softwareObject, int n) {
        block3: {
            if (softwareObject.getInstallStatus() == 3) break block3;
            try {
                RegistryService registryService = (RegistryService)this.getServices().getService("registryService");
                int n2 = registryService.getNextNewestInstance(softwareObject.getKey(), n);
                if (n2 != -1) {
                    SoftwareObjectKey softwareObjectKey = new SoftwareObjectKey();
                    softwareObjectKey.setInstance(n2);
                    softwareObjectKey.setUID(softwareObject.getKey().getUID());
                    softwareObjectKey.setVersion(softwareObject.getKey().getVersion());
                    return softwareObjectKey;
                }
            }
            catch (Exception exception) {
                this.logEvent(this, "err", exception);
            }
        }
        return softwareObject.getKey();
    }

    protected AsynchronousOperation getOperation(OperationKey operationKey) throws ServiceException {
        return super.getOperation(operationKey);
    }

    protected Properties getPostInstallSummary(String string, String string2) throws ServiceException {
        Properties properties = new Properties();
        ((Hashtable)properties).put("summary.msg", this.getLogSummaryMsg(this.getLogSummary(2, string), string, string2, 2));
        return properties;
    }

    protected Properties getPostUninstallSummary(String string, String string2) throws ServiceException {
        Properties properties = new Properties();
        ((Hashtable)properties).put("summary.msg", this.getLogSummaryMsg(this.getLogSummary(4, string), string, string2, 4));
        return properties;
    }

    protected Properties getPreInstallSummary(String string, String string2) throws ServiceException {
        Properties properties = new Properties();
        ProductTree productTree = this.getProductTree(string);
        if (productTree.getRoot() instanceof Product) {
            ((Hashtable)properties).put("summary.msg", this.getProductInstallSummary((Product)productTree.getRoot(), string2));
        }
        return properties;
    }

    protected Properties getPreUninstallSummary(String string, String string2) throws ServiceException {
        Properties properties = new Properties();
        ProductTree productTree = this.getProductTree(string);
        if (productTree.getRoot() instanceof Product) {
            ((Hashtable)properties).put("summary.msg", this.getProductUninstallSummary((Product)productTree.getRoot(), string2));
        }
        return properties;
    }

    protected ProductBean getProductBean(String string, String string2) throws ServiceException {
        ProductTree productTree = this.getProductTree(string);
        if (string2 == null) {
            return productTree.getRoot();
        }
        StandardProductTreeIterator standardProductTreeIterator = new StandardProductTreeIterator(productTree);
        ProductBean productBean = standardProductTreeIterator.getNext(standardProductTreeIterator.begin());
        while (productBean != standardProductTreeIterator.end()) {
            if (productBean.getBeanId().equals(string2)) {
                return productBean;
            }
            productBean = standardProductTreeIterator.getNext(productBean);
        }
        throw new ServiceException(315, "product bean " + string2 + " does not exist");
    }

    public Properties[] getProductBeanChildren(String string, String string2, String[] stringArray, Properties properties) throws ServiceException {
        Class clazz;
        ProductTree productTree = this.getProductTree(string);
        ProductTreeIterator productTreeIterator = string2 != null ? new StandardProductTreeIterator(productTree.getBean(string2)) : new StandardProductTreeIterator(productTree);
        productTreeIterator = new ChildrenProductTreeIterator((FilteredProductTreeIterator)productTreeIterator);
        if (properties == null) {
            properties = new Properties();
        }
        if (this.useActiveFilter(properties)) {
            productTreeIterator = new ActiveProductTreeIterator((FilteredProductTreeIterator)productTreeIterator);
        }
        if (this.useConditionFilter(properties)) {
            productTreeIterator = new ConditionalProductTreeIterator((FilteredProductTreeIterator)productTreeIterator);
        }
        if ((clazz = this.getFilterClass(properties)) != null) {
            productTreeIterator = new ProductTypeTreeIterator(productTreeIterator, clazz);
        }
        ProductBean productBean = productTreeIterator.getNext(productTreeIterator.begin());
        Vector<ProductBean> vector = new Vector<ProductBean>();
        while (productBean != productTreeIterator.end()) {
            vector.addElement(productBean);
            productBean = productTreeIterator.getNext(productBean);
        }
        Object[] objectArray = new ProductBean[vector.size()];
        if (vector.size() > 0) {
            vector.copyInto(objectArray);
        }
        return this.getPropertiesFromProductBeans((ProductBean[])objectArray, stringArray);
    }

    private String getProductBeanDisplayName(ProductBean productBean) {
        String string;
        if (productBean instanceof GenericSoftwareObject && (string = ((GenericSoftwareObject)productBean).getLocalizedDisplayName()) != null && string.trim().length() > 0) {
            return string;
        }
        return productBean.getDisplayName();
    }

    private Object getProductBeanProperty(ProductBean productBean, String string) throws ServiceException {
        Object object = this.getSpecialProductBeanProperty(productBean, string);
        if (object == null) {
            try {
                object = PropertyReadParser.processReadExpression(productBean, string);
            }
            catch (Exception exception) {
                throw new ServiceException(315, "could not read property " + string + " for bean " + productBean.getBeanId() + " because the following error occurred: " + exception);
            }
        }
        return object;
    }

    public Object getProductBeanProperty(String string, String string2, String string3) throws ServiceException {
        ProductBean productBean = this.getProductBean(string, string2);
        return this.getProductBeanProperty(productBean, string3);
    }

    protected String getProductInstallSummary(Product product, String string) {
        Object object;
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(LocalizedStringResolver.resolve("com.installshield.product.i18n.ProductResources", "PureJavaProductServiceImpl.beInstalledInDir", new String[]{this.getProductBeanDisplayName(product)}));
        if (string.equals("html")) {
            stringBuffer.append("<blockquote>");
        } else if (string.equals("text")) {
            stringBuffer.append("\n\n   ");
        }
        stringBuffer.append(product.getProductTree().getInstallLocation(product));
        if (string.equals("html")) {
            stringBuffer.append("</blockquote>");
        }
        ProductTreeIterator productTreeIterator = product instanceof Suite ? ProductTreeIteratorFactory.createInstallableProductIterator(product, new ProductTreeSource(this.getServices()), this) : ProductTreeIteratorFactory.createInstallableFeatureIterator(product);
        ProductBean productBean = productTreeIterator.getNext(productTreeIterator.begin());
        boolean bl = false;
        while (productBean != productTreeIterator.end()) {
            if (!bl) {
                if (string.equals("text")) {
                    stringBuffer.append("\n\n");
                }
                stringBuffer.append(LocalizedStringResolver.resolve("com.installshield.product.i18n.ProductResources", "PureJavaProductServiceImpl.withFeatures"));
                if (string.equals("html")) {
                    stringBuffer.append("<blockquote>");
                }
                bl = true;
            } else if (string.equals("html")) {
                stringBuffer.append("<br>");
            } else if (string.equals("text")) {
                stringBuffer.append("\n");
            }
            if (string.equals("text")) {
                stringBuffer.append("   ");
            }
            try {
                object = FileUtils.formatSizeAsBytes(new RequiredBytes().getEstimatedRequiredBytes(productBean, product.getProductTree(), new ProductTreeSource(this.getServices()), this.getRegistryService(), this).getTotalBytes());
                stringBuffer.append(String.valueOf(this.getProductBeanDisplayName(productBean)) + " (" + (String)object + ")");
            }
            catch (ServiceException serviceException) {
                if (serviceException.getErrorCode() == 305) {
                    this.getServices().logEvent(this, "wrn", "Feature size required is not supported by current file service implementation.");
                } else {
                    this.getServices().logEvent(this, "err", serviceException);
                }
                stringBuffer.append(this.getProductBeanDisplayName(productBean));
            }
            productBean = productTreeIterator.getNext(productBean);
        }
        if (!bl) {
            if (string.equals("text")) {
                stringBuffer.append("\n\n");
            } else if (string.equals("html")) {
                stringBuffer.append("<blockquote>");
            }
            bl = true;
        }
        if (bl) {
            if (string.equals("html")) {
                stringBuffer.append("</blockquote>");
            } else if (string.equals("text")) {
                stringBuffer.append("\b\n");
            }
        }
        stringBuffer.append(LocalizedStringResolver.resolve("com.installshield.product.i18n.ProductResources", "PureJavaProductServiceImpl.forTotalSize"));
        if (string.equals("html")) {
            stringBuffer.append("<blockquote>");
        } else if (string.equals("text")) {
            stringBuffer.append("\n\n   ");
        }
        try {
            object = new RequiredBytes().getEstimatedRequiredBytes(product, product.getProductTree(), new ProductTreeSource(this.getServices()), this.getRegistryService(), this);
            String string2 = FileUtils.formatSizeAsBytes(((RequiredBytesTable)object).getTotalBytes());
            stringBuffer.append(string2);
        }
        catch (ServiceException serviceException) {
            if (serviceException.getErrorCode() == 305) {
                this.getServices().logEvent(this, "wrn", "Total size required is not supported by current file service implementation.");
            } else {
                this.getServices().logEvent(this, "err", serviceException);
            }
            stringBuffer.append(LocalizedStringResolver.resolve("com.installshield.product.i18n.ProductResources", "PureJavaProductServiceImpl.totalSizeNotSupported"));
        }
        if (string.equals("html")) {
            stringBuffer.append("</blockquote>");
        }
        return stringBuffer.toString();
    }

    public String[] getProductLocales(String string) throws ServiceException {
        Object object;
        Vector<Object[]> vector = new Vector<Object[]>();
        ProductBean productBean = this.getProductTree(string).getRoot();
        ProductTreeIterator productTreeIterator = ProductTreeIteratorFactory.createFindLocalesTreeIterator(productBean);
        ProductBean productBean2 = productTreeIterator.getNext(productTreeIterator.begin());
        while (productBean2 != productTreeIterator.end()) {
            SoftwareObject softwareObject;
            object = null;
            if (productBean2 instanceof SoftwareObject) {
                object = ((SoftwareObject)((Object)productBean2)).getLocale();
            } else if (productBean2 instanceof SoftwareObjectReference && (softwareObject = productBean2.getProductTree().resolveKey(((SoftwareObjectReference)productBean2).getKey())) != null) {
                object = softwareObject.getLocale();
            }
            if (object != null && !vector.contains(object)) {
                vector.addElement((Object[])object);
            }
            productBean2 = productTreeIterator.getNext(productBean2);
        }
        object = new String[vector.size()];
        vector.copyInto((Object[])object);
        return object;
    }

    public Properties getProductSummary(String string, int n, String string2) throws ServiceException {
        if (n == 1) {
            return this.getPreInstallSummary(string, string2);
        }
        if (n == 2) {
            return this.getPostInstallSummary(string, string2);
        }
        if (n == 3) {
            return this.getPreUninstallSummary(string, string2);
        }
        if (n == 4) {
            return this.getPostUninstallSummary(string, string2);
        }
        throw new ServiceException(399, "illegal summary type " + n);
    }

    public ProductTree getProductTree(String string) throws ServiceException {
        ProductTree productTree = this.getCachedProductTree(string);
        if (productTree == null) {
            try {
                productTree = this.loadProductTree(string);
                SoftwareObject softwareObject = (SoftwareObject)((Object)productTree.getRoot());
                SoftwareObjectKey softwareObjectKey = this.getNewestInstanceKey(softwareObject, Integer.MAX_VALUE);
                boolean bl = false;
                while (!bl && !this.isUninstallerInfoCurrent(productTree, softwareObjectKey)) {
                    UninstallerInfo uninstallerInfo = this.getUninstallerInfo(softwareObjectKey);
                    if (uninstallerInfo.getUninstallerStatus() == 3) {
                        this.obtainUninstaller(uninstallerInfo);
                    }
                    if (uninstallerInfo.getUninstallerStatus() == 2) {
                        ProductTree productTree2 = productTree;
                        String string2 = uninstallerInfo.getAbsoluteDataFileName();
                        this.getServices().putResourceLocation(string2);
                        try {
                            productTree = this.loadProductTree(string);
                            this.redirectedProductSources.put(string, string2);
                            this.updateUninstaller(productTree, uninstallerInfo);
                        }
                        catch (Exception exception) {
                            this.logEvent(this, "err", exception);
                            productTree = productTree2;
                            this.getServices().removeResourceLocation(string2);
                        }
                        bl = true;
                        continue;
                    }
                    softwareObjectKey = this.getNewestInstanceKey(softwareObject, softwareObjectKey.getInstance());
                }
                this.setCachedProductTree(string, productTree);
            }
            catch (IOException iOException) {
                throw new ServiceException(315, "cannot find product " + string);
            }
            catch (Exception exception) {
                exception.printStackTrace();
                throw new ServiceException(exception);
            }
        }
        return productTree;
    }

    public Object getProductTreeProperty(String string, String string2) throws ServiceException {
        ProductTree productTree = this.getProductTree(string);
        try {
            return PropertyReadParser.processReadExpression(productTree, string2);
        }
        catch (Exception exception) {
            throw new ServiceException(315, "could not read property " + string2 + " for product tree " + "because the following error occurred: " + exception);
        }
    }

    public String getProductTreeRoot(String string) throws ServiceException {
        ProductTree productTree = this.getProductTree(string);
        return productTree.getRoot().getBeanId();
    }

    protected String getProductUninstallSummary(Product product, String string) {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(LocalizedStringResolver.resolve("com.installshield.product.i18n.ProductResources", "PureJavaProductServiceImpl.beUninstalledFromDir", new String[]{this.getProductBeanDisplayName(product)}));
        if (string.equals("html")) {
            stringBuffer.append("<blockquote>");
        } else if (string.equals("text")) {
            stringBuffer.append("\n\n   ");
        }
        stringBuffer.append(product.getProductTree().getInstallLocation(product));
        if (string.equals("html")) {
            stringBuffer.append("</blockquote>");
        }
        ProductTreeIterator productTreeIterator = ProductTreeIteratorFactory.createActiveSoftwareObjectIterator(product);
        ProductBean productBean = productTreeIterator.getNext(productTreeIterator.begin());
        boolean bl = false;
        while (productBean != productTreeIterator.end()) {
            if (!(productBean instanceof ProductFeature)) {
                throw new Error();
            }
            ProductFeature productFeature = (ProductFeature)productBean;
            if (!bl) {
                if (string.equals("text")) {
                    stringBuffer.append("\n\n");
                }
                stringBuffer.append(LocalizedStringResolver.resolve("com.installshield.product.i18n.ProductResources", "PureJavaProductServiceImpl.withFeatures"));
                if (string.equals("html")) {
                    stringBuffer.append("<blockquote>");
                }
                bl = true;
            }
            stringBuffer.append(this.getProductBeanDisplayName(productFeature));
            if (string.equals("html")) {
                stringBuffer.append("<br>");
            } else if (string.equals("text")) {
                stringBuffer.append("\n");
            }
            productBean = productTreeIterator.getNext(productBean);
        }
        if (bl && string.equals("html")) {
            stringBuffer.append("</blockquote>");
        }
        return stringBuffer.toString();
    }

    private Properties[] getPropertiesFromProductBeans(ProductBean[] productBeanArray, String[] stringArray) {
        Properties[] propertiesArray = new Properties[productBeanArray.length];
        int n = 0;
        while (n < productBeanArray.length) {
            propertiesArray[n] = new Properties();
            ProductBean productBean = productBeanArray[n];
            int n2 = 0;
            while (n2 < stringArray.length) {
                try {
                    Object object = this.getProductBeanProperty(productBean, stringArray[n2]);
                    if (object != null) {
                        ((Hashtable)propertiesArray[n]).put(stringArray[n2], object);
                    }
                }
                catch (ServiceException serviceException) {
                    this.logEvent(this, "err", "Could not read bean property " + stringArray[n2] + " of bean " + productBean + ": " + serviceException.getMessage());
                }
                ++n2;
            }
            ++n;
        }
        return propertiesArray;
    }

    private PropertyDescriptor getPropertyDescriptor(Object object, String string) throws IntrospectionException, ServiceException {
        BeanInfo beanInfo = ISIntrospector.getBeanInfo(object.getClass());
        PropertyDescriptor[] propertyDescriptorArray = beanInfo.getPropertyDescriptors();
        int n = 0;
        while (n < propertyDescriptorArray.length) {
            if (propertyDescriptorArray[n].getName().equals(string)) {
                return propertyDescriptorArray[n];
            }
            ++n;
        }
        throw new ServiceException(315, String.valueOf(object.toString()) + " does not have a property named " + string + " (note that property names are case sensitive)");
    }

    private Method getReadMethod(ProductBean productBean, String string) throws IntrospectionException, ServiceException {
        PropertyDescriptor propertyDescriptor = this.getPropertyDescriptor(productBean, string);
        if (propertyDescriptor != null) {
            return propertyDescriptor.getReadMethod();
        }
        return null;
    }

    private RegistryService getRegistryService() throws ServiceException {
        if (this.registryService == null) {
            this.registryService = (RegistryService)this.getServices().getService("registryService");
        }
        return this.registryService;
    }

    public Properties[] getRequiredByFeatures(String string, String string2, boolean bl) throws ServiceException {
        Object object;
        ProductTree productTree = this.getProductTree(string);
        ProductBean productBean = this.getProductBean(string, string2);
        ProductTreeIterator productTreeIterator = ProductTreeIteratorFactory.createRequiringSoftwareObjectIterator(productTree.getRoot(), (GenericSoftwareObject)productBean, bl);
        ProductBean productBean2 = productTreeIterator.getNext(productTreeIterator.begin());
        Vector<Object> vector = new Vector<Object>();
        while (productBean2 != productTreeIterator.end()) {
            if (productBean2 instanceof ProductFeature && !vector.contains(productBean2)) {
                vector.addElement(productBean2);
            } else if ((productBean2 instanceof ProductComponent || productBean2 instanceof ProductComponentReference) && (object = productTree.getParent(productBean2)) instanceof ProductFeature && !vector.contains(object)) {
                vector.addElement(object);
            }
            productBean2 = productTreeIterator.getNext(productBean2);
        }
        object = new ProductBean[vector.size()];
        if (vector.size() > 0) {
            vector.copyInto((Object[])object);
        }
        return this.getPropertiesFromProductBeans((ProductBean[])object, new String[]{"beanId", "displayName", "active", "installStatus"});
    }

    protected RequiredBytesTable getRequiredBytes(ProductTree productTree, ProductBean productBean) throws ServiceException {
        return new RequiredBytes().getEstimatedRequiredBytes(productBean, productTree, new ProductTreeSource(this.getServices()), this.getRegistryService(), this);
    }

    public RequiredBytesTable getRequiredBytes(String string, String string2) throws ServiceException {
        ProductBean productBean = null;
        productBean = this.getProductBean(string, string2);
        if (productBean == null) {
            return new RequiredBytesTable();
        }
        return this.getRequiredBytes(this.getProductTree(string), productBean);
    }

    private void getRequiredFeatures(ProductTree productTree, ProductBean productBean, Vector vector, boolean bl) {
        ProductTreeIterator productTreeIterator = ProductTreeIteratorFactory.createFeaturesRequiredBySoftwareObjectIterator((GenericSoftwareObject)productBean, bl);
        ProductBean productBean2 = productTreeIterator.getNext(productTreeIterator.begin());
        while (productBean2 != productTreeIterator.end()) {
            SoftwareObject softwareObject;
            ProductFeature productFeature = null;
            if (productBean2 instanceof ProductFeature) {
                productFeature = (ProductFeature)productBean2;
            } else if (productBean2 instanceof SoftwareObjectReference && (softwareObject = productTree.resolveKey(((SoftwareObjectReference)productBean2).getKey())) instanceof ProductFeature) {
                productFeature = (ProductFeature)softwareObject;
            }
            if (productFeature != null && !vector.contains(productFeature)) {
                vector.addElement(productFeature);
            }
            productBean2 = productTreeIterator.getNext(productBean2);
        }
    }

    public Properties[] getRequiredFeatures(String string, String string2, boolean bl) throws ServiceException {
        Object object;
        ProductTree productTree = this.getProductTree(string);
        ProductBean productBean = this.getProductBean(string, string2);
        Vector vector = new Vector();
        boolean bl2 = true;
        if (productBean instanceof Product) {
            bl2 = false;
        }
        ProductTreeIterator productTreeIterator = ProductTreeIteratorFactory.createSoftwareObjectIterator(productBean);
        ProductBean productBean2 = productTreeIterator.getNext(productTreeIterator.begin());
        while (productBean2 != productTreeIterator.end()) {
            if (productBean2 instanceof SoftwareObjectReference) {
                object = productTree.resolveKey(((SoftwareObjectReference)productBean2).getKey());
                if (object instanceof GenericSoftwareObject) {
                    this.getRequiredFeatures(productTree, (GenericSoftwareObject)object, vector, bl);
                }
            } else if (bl2 || !(productBean2 instanceof ProductFeature)) {
                this.getRequiredFeatures(productTree, productBean2, vector, bl);
            }
            productBean2 = productTreeIterator.getNext(productBean2);
        }
        object = new ProductBean[vector.size()];
        if (vector.size() > 0) {
            vector.copyInto((Object[])object);
        }
        return this.getPropertiesFromProductBeans((ProductBean[])object, new String[]{"beanId", "displayName", "active", "installStatus"});
    }

    protected Object getSpecialProductBeanProperty(ProductBean productBean, String string) throws ServiceException {
        if (string.equals("absoluteInstallLocation")) {
            return this.getAbsoluteInstallLocation(productBean);
        }
        if (string.equals("installed")) {
            return new Boolean(this.isInstalled(productBean));
        }
        if (string.equals("displayName")) {
            return this.getProductBeanDisplayName(productBean);
        }
        return null;
    }

    private String getSummaryTypeDesc(int n) {
        if (n == 1 || n == 2) {
            return LocalizedStringResolver.resolve("com.installshield.product.i18n.ProductResources", "PureJavaProductServiceImpl.installedWithoutErrors", new String[]{"$P(displayName)"});
        }
        if (n == 3 || n == 4) {
            return LocalizedStringResolver.resolve("com.installshield.product.i18n.ProductResources", "PureJavaProductServiceImpl.uninstalledWithoutErrors", new String[]{"$P(displayName)"});
        }
        throw new Error();
    }

    public int getSystemCompatibility() {
        return 1;
    }

    protected UninstallerInfo getUninstallerInfo(SoftwareObjectKey softwareObjectKey) throws ServiceException {
        UninstallerInfo uninstallerInfo = new UninstallerInfo();
        RegistryService registryService = (RegistryService)this.getServices().getService("registryService");
        SoftwareObject softwareObject = registryService.getSoftwareObject(softwareObjectKey);
        if (softwareObject != null) {
            uninstallerInfo.decodeRegistryValue(softwareObject.getUninstaller());
            uninstallerInfo.setProductInstallLocation(softwareObject.getInstallLocation());
            FileService fileService = (FileService)this.getServices().getService("fileService");
            if (fileService.fileExists(uninstallerInfo.getAbsoluteDataFileName())) {
                uninstallerInfo.setUninstallerStatus(2);
            }
        }
        return uninstallerInfo;
    }

    private Method getWriteMethod(Object object, String string) {
        try {
            PropertyDescriptor propertyDescriptor = this.getPropertyDescriptor(object, string);
            if (propertyDescriptor != null) {
                return propertyDescriptor.getWriteMethod();
            }
            return null;
        }
        catch (Throwable throwable) {
            return null;
        }
    }

    private void initializeActiveNodeTable(Hashtable hashtable, ProductActionSupport productActionSupport, Vector vector) throws ServiceException {
        Vector vector2 = (Vector)vector.clone();
        while (!vector2.isEmpty()) {
            Vector<SoftwareObjectKey> vector3 = new Vector<SoftwareObjectKey>();
            int n = 0;
            while (n < vector2.size()) {
                SoftwareObjectKey softwareObjectKey = (SoftwareObjectKey)vector2.elementAt(n);
                Node node = (Node)hashtable.get(softwareObjectKey);
                SoftwareObject softwareObject = this.getRegistryService().getSoftwareObject(softwareObjectKey);
                if (softwareObject != null) {
                    SoftwareObjectKey[] softwareObjectKeyArray = softwareObject.getParents();
                    int n2 = 0;
                    while (n2 < softwareObjectKeyArray.length) {
                        Node node2 = (Node)hashtable.get(softwareObjectKeyArray[n2]);
                        if (node2 == null) {
                            SoftwareObject softwareObject2 = this.getRegistryService().getSoftwareObject(softwareObjectKeyArray[n2]);
                            if (softwareObject2 != null) {
                                node2 = new Node((ProductBean)((Object)softwareObject2));
                                hashtable.put(softwareObject2.getKey(), node2);
                                vector3.addElement(softwareObject2.getKey());
                            } else {
                                this.getServices().logEvent(this, "wrn", "Parent Component with UID = " + softwareObjectKeyArray[n2].getUID() + " of installed Component with displayName = " + this.getProductBeanDisplayName((ProductBean)((Object)softwareObject)) + " was not found in the VPD.");
                            }
                        }
                        if (node2 != null) {
                            node2.children.addElement(node);
                            node.parents.addElement(node2);
                        }
                        ++n2;
                    }
                } else {
                    this.getServices().logEvent(this, "wrn", "Installed Component with UID = " + softwareObjectKey.getUID() + " was not found in the VPD.");
                }
                ++n;
            }
            vector2 = (Vector)vector3.clone();
        }
    }

    protected static void initializeTree(ProductTree productTree, WizardServices wizardServices) throws ProductException {
        if (wizardServices == null) {
            throw new IllegalStateException("product service not initialized -- cannot initialize tree");
        }
        productTree.getUninstallerArchive().initialize(wizardServices);
        productTree.getUninstallerJVMResolution().initialize(wizardServices);
        productTree.getUninstallerLauncher().initialize(wizardServices);
        StandardProductTreeIterator standardProductTreeIterator = new StandardProductTreeIterator(productTree);
        ProductBean productBean = standardProductTreeIterator.getNext(standardProductTreeIterator.begin());
        while (productBean != standardProductTreeIterator.end()) {
            if (productBean instanceof ProductBeanPlaceHolder) {
                throw new ProductException(401, ((ProductBeanPlaceHolder)productBean).getPlaceHolderMessage());
            }
            productBean.initialize(wizardServices);
            productBean = standardProductTreeIterator.getNext(productBean);
        }
    }

    public OperationKey installProduct(String string) throws ServiceException {
        Installer installer = new Installer(string, this);
        this.startOperation(installer);
        return installer.getKey();
    }

    protected void installProductAction(ProductAction productAction, ProductActionSupport productActionSupport) throws ProductException {
        if (this.isDebugEventLogged("install")) {
            this.logDebugEvent("install", this.getMemoryDebugMessage("before installing " + productAction));
        }
        this.logEvent(this, "msg1", "installing " + productAction);
        productAction.install(productActionSupport);
        if (this.isDebugEventLogged("install")) {
            this.logDebugEvent("install", this.getMemoryDebugMessage("after installing " + productAction));
        }
    }

    private boolean installingParent(ProductTree productTree, SoftwareObjectKey softwareObjectKey) {
        boolean bl = true;
        SoftwareObject softwareObject = productTree.resolveKey(softwareObjectKey);
        if (softwareObject != null && softwareObject.getInstallStatus() != 2) {
            bl = false;
        }
        return bl;
    }

    private void invalidateChecksForProduct(String string) throws ServiceException {
        InstallCheck[] installCheckArray = this.getChecksForProduct(string);
        int n = 0;
        while (n < installCheckArray.length) {
            installCheckArray[n].invalidate();
            ++n;
        }
    }

    protected boolean isDebugEventLogged(String string) {
        return this.isEventLogged(WizardLog.subclassEvent("dbg", string));
    }

    private boolean isInstalled(ProductBean productBean) {
        if (productBean instanceof SoftwareObject) {
            return ((SoftwareObject)((Object)productBean)).getInstallStatus() == 3;
        }
        if (productBean instanceof ProductAction) {
            return ((ProductAction)productBean).getTransientInstallState();
        }
        return false;
    }

    protected boolean isUninstallerInfoCurrent(ProductTree productTree, SoftwareObjectKey softwareObjectKey) {
        SoftwareObjectKey softwareObjectKey2 = ((SoftwareObject)((Object)productTree.getRoot())).getKey();
        return softwareObjectKey2.getUID().equals(softwareObjectKey.getUID()) && softwareObjectKey2.getVersion().equals(softwareObjectKey.getVersion()) && softwareObjectKey2.getInstance() == softwareObjectKey.getInstance();
    }

    private ProductTree loadProductTree(String string) throws IOException, ProductException {
        URL uRL = this.getResource(string);
        ProductTree productTree = (ProductTree)QJML.read(uRL, class$com$installshield$product$ProductTree != null ? class$com$installshield$product$ProductTree : (class$com$installshield$product$ProductTree = PureJavaProductServiceImpl.class$("com.installshield.product.ProductTree")));
        PureJavaProductServiceImpl.initializeTree(productTree, this.getServices());
        return productTree;
    }

    protected void logDebugEvent(String string, String string2) {
        this.logEvent(this, WizardLog.subclassEvent("dbg", string), string2);
    }

    public void logEvent(Object object, String string, Object object2) {
        super.logEvent(object, string, object2);
    }

    private void markNodesInactive(ProductTree productTree, Hashtable hashtable, Vector vector) throws ServiceException {
        ProductBean productBean = productTree.getRoot();
        Enumeration enumeration = hashtable.elements();
        while (enumeration.hasMoreElements()) {
            Node node = (Node)enumeration.nextElement();
            node.checkAncestors(vector, productBean, new Vector());
        }
    }

    private void markProductBeanInstalled(ProductBean productBean, ProductTree productTree, ProductActionSupport productActionSupport) throws ServiceException {
        ProductTreeIterator productTreeIterator = ProductTreeIteratorFactory.createRegisteredComponentIterator(productBean);
        ProductBean productBean2 = productTreeIterator.getPrevious(productTreeIterator.end());
        while (productBean2 != productTreeIterator.begin()) {
            this.markSoftwareObjectInstalled(productTree, productBean2, productActionSupport);
            productBean2 = productTreeIterator.getPrevious(productBean2);
        }
    }

    private void markSoftwareObjectInstalled(ProductTree productTree, ProductBean productBean, ProductActionSupport productActionSupport) throws ServiceException {
        SoftwareObjectReference softwareObjectReference;
        SoftwareObject softwareObject = null;
        SoftwareObjectKey softwareObjectKey = null;
        if (productBean instanceof SoftwareObject) {
            softwareObject = (SoftwareObject)((Object)productBean);
            if (softwareObject instanceof ProductComponent || this.childrenInstalled(softwareObject, productTree)) {
                softwareObject.setInstallStatus(3);
                this.getRegistryService().setSoftwareObject(softwareObject);
            } else {
                softwareObject.setInstallStatus(5);
                this.getRegistryService().removeSoftwareObject(softwareObject.getKey());
            }
        } else if (productBean instanceof SoftwareObjectReference && (softwareObject = productTree.resolveKey(softwareObjectKey = (softwareObjectReference = (SoftwareObjectReference)productBean).getKey())) != null) {
            this.markProductBeanInstalled((ProductBean)((Object)softwareObject), productTree, productActionSupport);
        }
    }

    private String normalizePath(String string) {
        return this.getServices().resolveString(FileUtils.normalizeFileName(string));
    }

    protected void obtainUninstaller(UninstallerInfo uninstallerInfo) {
    }

    public void overrideChecks(String string, String[] stringArray) throws ServiceException {
        Hashtable<String, String> hashtable = new Hashtable<String, String>();
        int n = 0;
        while (n < stringArray.length) {
            hashtable.put(stringArray[n], "");
            ++n;
        }
        InstallCheck[] installCheckArray = this.getChecksForProduct(string);
        int n2 = 0;
        while (n2 < installCheckArray.length) {
            if (hashtable.containsKey(installCheckArray[n2].getName())) {
                installCheckArray[n2].override();
            }
            ++n2;
        }
    }

    protected void postInstallProduct(ProductTree productTree, ProductActionSupport productActionSupport) throws ServiceException {
    }

    protected void postInstallProductComponent(ProductBean productBean, ProductActionSupport productActionSupport) throws ServiceException {
    }

    protected void postUninstallProduct(ProductActionSupport productActionSupport, String string) throws ServiceException {
    }

    protected void preInstallProduct(ProductTree productTree, ProductActionSupport productActionSupport) throws ServiceException {
    }

    protected boolean preInstallProductComponent(ProductBean productBean, ProductActionSupport productActionSupport) throws ServiceException {
        return true;
    }

    protected void preUninstallProduct(ProductActionSupport productActionSupport, String string) throws ServiceException {
    }

    public void processProductBeanPropertiesOption(String string, String string2) throws ServiceException {
        String string3;
        String string4 = null;
        int n = string2.indexOf(".");
        if (n != -1) {
            string4 = string2.substring(0, n);
            string3 = string2.substring(n + 1);
        } else {
            string3 = string2;
        }
        ProductBean productBean = this.getProductBean(string, string4);
        if (productBean == null) {
            throw new ServiceException(399, "could not find bean " + string4);
        }
        try {
            PropertyAssignmentParser.processAssignmentExpression(productBean, string3);
        }
        catch (Exception exception) {
            throw new ServiceException(399, exception.getMessage());
        }
    }

    private boolean processSpecialProductBeanProperty(String string, ProductBean productBean, String string2, Object object) throws ServiceException {
        ProductTree productTree;
        if (string2.equals("installLocation") && productBean == (productTree = this.getProductTree(string)).getRoot()) {
            this.verifyProductSourceChange(string, (GenericSoftwareObject)productBean, object.toString());
            return true;
        }
        return false;
    }

    protected void registerUninstaller(ProductTree productTree) throws ServiceException {
    }

    private void rollbackProductComponent(ProductComponent productComponent) throws ServiceException {
        SoftwareObject softwareObject = this.getRegistryService().getSoftwareObject(productComponent.getKey());
        if (softwareObject != null) {
            SoftwareObjectKey[] softwareObjectKeyArray = softwareObject.getParents();
            SoftwareObjectKey softwareObjectKey = (SoftwareObjectKey)softwareObject.getKey().clone();
            softwareObjectKey.setInstance(0);
            int n = 0;
            while (n < softwareObjectKeyArray.length) {
                this.getRegistryService().updateRequiredSoftwareObject(softwareObjectKeyArray[n], softwareObjectKey);
                ++n;
            }
            this.getRegistryService().removeSoftwareObject(softwareObject.getKey());
        }
    }

    private Hashtable setActiveStateForUninstallation(ProductTree productTree, ProductActionSupport productActionSupport, int n) throws ServiceException {
        Hashtable hashtable = new Hashtable();
        Vector vector = new Vector();
        this.createActiveNodeTable(productTree.getRoot(), productTree, hashtable, vector, productActionSupport, n);
        this.initializeActiveNodeTable(hashtable, productActionSupport, vector);
        this.markNodesInactive(productTree, hashtable, vector);
        return hashtable;
    }

    private void setCachedProductTree(String string, ProductTree productTree) {
        this.getServices().setValue(string, productTree);
    }

    private void setExitCode(int n) {
        try {
            ExitCodeService exitCodeService = (ExitCodeService)this.getServices().getService("exitCodeService");
            exitCodeService.setExitCode(n);
        }
        catch (Exception exception) {}
    }

    public void setProductBeanProperty(String string, String string2, String string3, Object object) throws ServiceException {
        ProductBean productBean = this.getProductBean(string, string2);
        if (!this.processSpecialProductBeanProperty(string, productBean, string3, object)) {
            try {
                Method method = this.getWriteMethod(productBean, string3);
                if (method == null) {
                    productBean.getExtendedProperties().put(string3, object);
                } else {
                    if (method.getParameterTypes().length > 1) {
                        throw new ServiceException(315, "property " + string3 + " takes more than one parameter for beans of type " + productBean.getClass().getName());
                    }
                    method.invoke((Object)productBean, object);
                    this.invalidateChecksForProduct(string);
                }
            }
            catch (Exception exception) {
                throw new ServiceException(315, "could not write property " + string3 + " for bean " + string2 + "because the following error occurred: " + exception);
            }
        }
    }

    public void setProductTreeProperty(String string, String string2, Object object) throws ServiceException {
        ProductTree productTree = this.getProductTree(string);
        try {
            Method method = this.getWriteMethod(productTree, string2);
            if (method == null) {
                throw new ServiceException(315, "property " + string2 + " cannot be written for product trees");
            }
            if (method.getParameterTypes().length > 1) {
                throw new ServiceException(315, "property " + string2 + " takes more than one parameter for product trees ");
            }
            method.invoke((Object)productTree, object);
        }
        catch (Exception exception) {
            throw new ServiceException(315, "could not write property " + string2 + " for product tree " + "because the following error occurred: " + exception);
        }
        this.invalidateChecksForProduct(string);
    }

    protected void setProductUninstaller(ProductTree productTree) {
        UninstallerInfo uninstallerInfo = new UninstallerInfo();
        uninstallerInfo.setInstallLocation(productTree.getUninstallerArchive().getInstallLocation());
        uninstallerInfo.setArchiveFileName(productTree.getUninstallerArchive().getArchiveName());
        uninstallerInfo.setDataFileName(productTree.getUninstallerArchive().getResourcesFileName());
        if (productTree.getUninstallerLauncher().isActive() && productTree.getUninstallerLauncher().getInstalledFileName() != null) {
            uninstallerInfo.setLauncherFileName(productTree.getUninstallerLauncher().getInstalledFileName());
        }
        ((GenericSoftwareObject)productTree.getRoot()).setUninstaller(uninstallerInfo.encodeRegistryValue());
    }

    protected OperationKey uninstallProduct(ProductTree productTree, ProductActionSupport productActionSupport) throws ServiceException {
        Uninstaller uninstaller = new Uninstaller(productTree, productActionSupport);
        this.startOperation(uninstaller);
        return uninstaller.getKey();
    }

    public OperationKey uninstallProduct(String string) throws ServiceException {
        Uninstaller uninstaller = new Uninstaller(string);
        this.startOperation(uninstaller);
        return uninstaller.getKey();
    }

    protected void uninstallProductAction(ProductAction productAction, ProductActionSupport productActionSupport) throws ProductException {
        this.logEvent(this, "msg1", "uninstalling " + productAction);
        productAction.uninstall(productActionSupport);
    }

    private void uninstallProductBean(ProductBean productBean, ProductTree productTree, Hashtable hashtable, ProductActionSupport productActionSupport, int n) throws ServiceException {
        ProductTreeIterator productTreeIterator = ProductTreeIteratorFactory.createUninstallerComponentIterator(productBean, n);
        ProductBean productBean2 = productTreeIterator.getPrevious(productTreeIterator.end());
        while (productBean2 != productTreeIterator.begin()) {
            this.uninstallSoftwareObject(productTree, productBean2, hashtable, productActionSupport, n);
            productBean2 = productTreeIterator.getPrevious(productBean2);
        }
    }

    protected void uninstallProductComponent(ProductBean productBean, ProductActionSupport productActionSupport, int n) throws ServiceException {
        StandardProductTreeIterator standardProductTreeIterator = new StandardProductTreeIterator(productBean);
        ProductActionTreeIterator productActionTreeIterator = new ProductActionTreeIterator(standardProductTreeIterator);
        ProductBean productBean2 = productActionTreeIterator.getPrevious(productActionTreeIterator.end());
        while (productBean2 != productActionTreeIterator.begin()) {
            ProductAction productAction = (ProductAction)productBean2;
            if (productAction.getTransientInstallState() || productAction.isActive()) {
                try {
                    this.uninstallProductAction(productAction, productActionSupport);
                }
                catch (ProductException productException) {
                    String string = LocalizedStringResolver.resolve("com.installshield.product.i18n.ProductResources", "PureJavaProductServiceImpl.uninstallationFailed");
                    string = this.appendLogFileToMsg(string);
                    productActionSupport.logEvent(this, "err", string);
                    this.getServices().logEvent(this, "err", string);
                    this.getServices().logEvent(productAction, "err", productException);
                }
            }
            productBean2 = productActionTreeIterator.getPrevious(productBean2);
        }
    }

    private void uninstallSoftwareObject(ProductTree productTree, ProductBean productBean, Hashtable hashtable, ProductActionSupport productActionSupport, int n) throws ServiceException {
        ProductBean productBean2;
        SoftwareObject softwareObject = null;
        SoftwareObjectKey softwareObjectKey = null;
        if (productBean instanceof SoftwareObjectReference) {
            productBean2 = (SoftwareObjectReference)productBean;
            softwareObjectKey = productBean2.getKey();
            softwareObject = productTree.resolveKey(productBean2.getKey());
            if (softwareObject == null) {
                softwareObject = this.getRegistryService().getSoftwareObject(softwareObjectKey);
            } else {
                softwareObjectKey = softwareObject.getKey();
                this.uninstallProductBean((ProductBean)((Object)softwareObject), productTree, hashtable, productActionSupport, n);
            }
        } else if (productBean instanceof SoftwareObject) {
            softwareObject = (SoftwareObject)((Object)productBean);
            softwareObjectKey = softwareObject.getKey();
        }
        if (softwareObject == null) {
            this.getServices().logEvent(this, "wrn", "Installed Component with UID = " + softwareObjectKey.getUID() + " was not found in the VPD.");
        } else {
            Object object;
            productBean2 = productBean.getProductTree().getParent(productBean);
            Node node = null;
            SoftwareObjectKey softwareObjectKey2 = null;
            if (productBean2 != null && productBean2 instanceof SoftwareObject) {
                softwareObjectKey2 = ((SoftwareObject)((Object)productBean2)).getKey();
                node = (Node)hashtable.get(softwareObjectKey2);
            }
            if (node != null && node.getActive()) {
                this.getRegistryService().removeParentSoftwareObjects(softwareObjectKey, new SoftwareObjectKey[]{softwareObjectKey2});
                object = (SoftwareObjectKey)softwareObjectKey.clone();
                ((SoftwareObjectKey)object).setInstance(0);
                this.getRegistryService().updateRequiredSoftwareObject(softwareObjectKey2, (SoftwareObjectKey)object);
            }
            if ((object = (Node)hashtable.get(softwareObjectKey)) != null && ((Node)object).getActive()) {
                SoftwareObject softwareObject2 = this.getRegistryService().getSoftwareObject(softwareObjectKey);
                if (softwareObject2 != null) {
                    if (softwareObject2.getParents().length == 0) {
                        if (softwareObject instanceof ProductComponent) {
                            this.uninstallProductComponent((ProductBean)((Object)softwareObject), productActionSupport, n);
                        }
                        this.getRegistryService().removeSoftwareObject(softwareObjectKey);
                        softwareObject.setInstallStatus(4);
                    } else if (productBean instanceof ProductFeature) {
                        this.getRegistryService().removeSoftwareObject(softwareObjectKey);
                        softwareObject.setInstallStatus(4);
                    } else if (softwareObject2.getParents().length == 1 && softwareObjectKey.equals(softwareObject2.getParents()[0])) {
                        boolean bl = true;
                        Enumeration enumeration = productTree.children(productBean);
                        while (bl && enumeration.hasMoreElements()) {
                            ProductBean productBean3 = (ProductBean)enumeration.nextElement();
                            SoftwareObject softwareObject3 = null;
                            if (productBean3 instanceof SoftwareObject) {
                                softwareObject3 = (SoftwareObject)((Object)productBean3);
                            } else if (productBean3 instanceof SoftwareObjectReference) {
                                SoftwareObjectReference softwareObjectReference = (SoftwareObjectReference)productBean3;
                                softwareObject3 = productTree.resolveKey(softwareObjectReference.getKey());
                            }
                            if (softwareObject3 == null) continue;
                            boolean bl2 = bl = softwareObject3.getInstallStatus() != 3 && softwareObject3.getInstallStatus() != 2;
                        }
                        if (bl) {
                            this.getRegistryService().removeSoftwareObject(softwareObjectKey);
                            softwareObject.setInstallStatus(4);
                        }
                    }
                } else {
                    if (softwareObject instanceof ProductComponent) {
                        this.uninstallProductComponent((ProductBean)((Object)softwareObject), productActionSupport, n);
                    }
                    softwareObject.setInstallStatus(4);
                }
            }
        }
    }

    protected void unregisterUninstaller(ProductTree productTree) throws ServiceException {
    }

    private void updateRequiredOnParent(ProductBean productBean, SoftwareObjectKey softwareObjectKey) throws ServiceException {
        ProductBean productBean2 = productBean.getProductTree().getParent(productBean);
        SoftwareObjectKey softwareObjectKey2 = null;
        if (productBean2 != null) {
            if (productBean2 instanceof SoftwareObject) {
                softwareObjectKey2 = ((SoftwareObject)((Object)productBean2)).getKey();
            } else if (productBean2 instanceof SoftwareObjectReference) {
                softwareObjectKey2 = ((SoftwareObjectReference)productBean2).getKey();
            }
        }
        if (softwareObjectKey2 != null && this.installingParent(productBean.getProductTree(), softwareObjectKey2)) {
            SoftwareObject softwareObject = this.getRegistryService().getSoftwareObject(softwareObjectKey2);
            if (softwareObject == null) {
                throw new ServiceException(399, "Error updating VPD for Parent");
            }
            SoftwareObjectReference[] softwareObjectReferenceArray = softwareObject.getRequired();
            int n = 0;
            while (n < softwareObjectReferenceArray.length) {
                if (softwareObjectReferenceArray[n].getKey().getInstance() == 0 && softwareObjectReferenceArray[n].getKey().equals(softwareObjectKey)) {
                    this.getRegistryService().updateRequiredSoftwareObject(softwareObject.getKey(), softwareObjectKey);
                }
                ++n;
            }
        }
    }

    private void updateUninstaller(ProductTree productTree, UninstallerInfo uninstallerInfo) {
        UninstallerArchive uninstallerArchive = productTree.getUninstallerArchive();
        UninstallerLauncher uninstallerLauncher = productTree.getUninstallerLauncher();
        uninstallerArchive.setArchiveName(uninstallerInfo.getArchiveFileName());
        uninstallerArchive.setResourcesFileName(uninstallerInfo.getDataFileName());
        uninstallerArchive.setInstallLocation(uninstallerInfo.getInstallLocation());
        uninstallerLauncher.setInstalledFileName(uninstallerInfo.getLauncherFileName());
    }

    private boolean useActiveFilter(Properties properties) {
        return ((Hashtable)properties).get("filter.active") != null;
    }

    private boolean useConditionFilter(Properties properties) {
        return ((Hashtable)properties).get("filter.condition") != null;
    }

    private void verifyChecksForProduct(String string, LogSummary logSummary) throws ServiceException {
        InstallCheck[] installCheckArray = this.getChecksForProduct(string);
        int n = 0;
        while (n < installCheckArray.length) {
            if (!installCheckArray[n].isValid()) {
                this.executeCheck(installCheckArray[n], string, this.getServices(), logSummary);
            }
            if (!installCheckArray[n].isPassed() && !installCheckArray[n].isOverridden()) {
                String string2 = new String("Cannot install: Check ").concat(installCheckArray[n].getName()).concat(" did not pass.");
                throw new ServiceException(315, string2);
            }
            ++n;
        }
    }

    private void verifyProductSourceChange(String string, GenericSoftwareObject genericSoftwareObject, String string2) {
        try {
            FileService fileService = (FileService)this.getServices().getService("fileService");
            if (!fileService.comparePaths(genericSoftwareObject.getInstallLocation(), string2)) {
                Object object;
                RegistryService registryService = (RegistryService)this.getServices().getService("registryService");
                int n = registryService.getInstalledInstance(genericSoftwareObject.getKey(), string2);
                String string3 = (String)this.redirectedProductSources.get(string);
                if (string3 != null) {
                    this.getServices().removeResourceLocation(string3);
                    this.redirectedProductSources.remove(string);
                }
                boolean bl = false;
                if (n != -1) {
                    genericSoftwareObject.getKey().setInstance(n);
                    object = this.getUninstallerInfo(genericSoftwareObject.getKey());
                    if (((UninstallerInfo)object).getUninstallerStatus() == 3) {
                        this.obtainUninstaller((UninstallerInfo)object);
                    }
                    if (((UninstallerInfo)object).getUninstallerStatus() == 2) {
                        String string4 = ((UninstallerInfo)object).getAbsoluteDataFileName();
                        this.getServices().putResourceLocation(string4);
                        try {
                            ProductTree productTree = this.loadProductTree(string);
                            ((GenericSoftwareObject)productTree.getRoot()).setInstallLocation(string2);
                            this.redirectedProductSources.put(string, string4);
                            this.updateUninstaller(productTree, (UninstallerInfo)object);
                            this.getServices().setValue(string.toString(), productTree);
                        }
                        catch (Exception exception) {
                            this.logEvent(this, "err", exception);
                            this.getServices().removeResourceLocation(string4);
                            bl = true;
                        }
                    }
                } else {
                    boolean bl2 = bl = string3 != null;
                }
                if (bl) {
                    try {
                        object = this.loadProductTree(string);
                        ((GenericSoftwareObject)((ProductTree)object).getRoot()).setInstallLocation(string2);
                        this.getServices().setValue(string.toString(), object);
                    }
                    catch (Exception exception) {
                        this.logEvent(this, "err", exception);
                        this.logEvent(this, "err", "critical error -- cannot load original product tree after redirect to " + string2);
                    }
                } else {
                    genericSoftwareObject.setInstallLocation(string2);
                }
            }
        }
        catch (Exception exception) {
            this.logEvent(this, "err", exception);
        }
    }

    public void writeProductTree(String string, String string2) throws ServiceException {
        ProductTree productTree = this.getProductTree(string);
        try {
            QJML.write((Object)productTree, class$com$installshield$product$ProductTree != null ? class$com$installshield$product$ProductTree : (class$com$installshield$product$ProductTree = PureJavaProductServiceImpl.class$("com.installshield.product.ProductTree")), string2);
        }
        catch (IOException iOException) {
            throw new ServiceException(iOException);
        }
    }

    private class Node {
        ProductBean bean = null;
        Vector parents = new Vector();
        Vector children = new Vector();
        boolean active = true;

        Node(ProductBean productBean) {
            this.bean = productBean;
        }

        void checkAncestors(Vector vector, ProductBean productBean, Vector vector2) {
            if (!vector2.contains(this)) {
                vector2.addElement(this);
                Enumeration enumeration = this.parents.elements();
                while (this.active && enumeration.hasMoreElements()) {
                    Node node = (Node)enumeration.nextElement();
                    SoftwareObjectKey softwareObjectKey = ((SoftwareObject)((Object)node.bean)).getKey();
                    if (!node.getActive()) {
                        this.active = false;
                        continue;
                    }
                    if (!vector.contains(softwareObjectKey)) {
                        this.active = false;
                        if (!(this.bean instanceof ProductFeature) || !this.bean.isActive()) continue;
                        this.active = true;
                        continue;
                    }
                    if (node.equals(this)) {
                        if (this.bean.equals(productBean)) continue;
                        this.active = false;
                        continue;
                    }
                    node.checkAncestors(vector, productBean, vector2);
                    this.active = node.getActive();
                }
            }
        }

        boolean getActive() {
            return this.active;
        }

        void setActive(boolean bl) {
            this.active = bl;
        }
    }

    private class WizardServicesLog
    implements Log {
        WizardServices services;

        WizardServicesLog(WizardServices wizardServices) {
            this.services = wizardServices;
        }

        public void logEvent(Object object, String string, Object object2) {
            this.services.logEvent(object, string, object2);
        }
    }

    protected class LogSummary
    implements LogListener {
        private String description;
        private Vector errors = new Vector();
        private Vector warnings = new Vector();
        private Vector messages = new Vector();

        public LogSummary(String string) {
            this.description = string;
        }

        public int errorCount() {
            return this.errors.size();
        }

        public Enumeration errors() {
            return this.errors.elements();
        }

        public void eventLogged(Object object, String string, Object object2) {
            if (string.equals("err")) {
                this.errors.addElement(object2);
            } else if (string.equals("wrn")) {
                this.warnings.addElement(object2);
            } else if (string.equals("msg1") || string.equals("msg2")) {
                this.messages.addElement(object2);
            }
        }

        public String getDescription() {
            return this.description;
        }

        public boolean hasErrors() {
            return this.errors.size() > 0;
        }

        public boolean hasMessages() {
            return this.messages.size() > 0;
        }

        public boolean hasWarnings() {
            return this.warnings.size() > 0;
        }

        public int messageCount() {
            return this.messages.size();
        }

        public Enumeration messages() {
            return this.messages.elements();
        }

        public int warningCount() {
            return this.warnings.size();
        }

        public Enumeration warnings() {
            return this.warnings.elements();
        }
    }

    private class Installer
    extends AsynchronousOperation {
        private String source;

        Installer(String string, AbstractServiceImplementor abstractServiceImplementor) {
            super("Installer for " + string, abstractServiceImplementor);
            this.source = string;
        }

        public void execute() {
            LogSummary logSummary = new LogSummary(PureJavaProductServiceImpl.this.getSummaryTypeDesc(2));
            try {
                PureJavaProductServiceImpl.this.addLogSummary(logSummary, 2, this.source);
                ProductTree productTree = PureJavaProductServiceImpl.this.getProductTree(this.source);
                this.setStatusDescription(LocalizedStringResolver.resolve("com.installshield.product.i18n.ProductResources", "PureJavaProductServiceImpl.Installer.installing", new String[]{PureJavaProductServiceImpl.this.getProductBeanDisplayName(productTree.getRoot())}));
                PureJavaProductServiceImpl.this.verifyChecksForProduct(this.source, logSummary);
                InstallProduct installProduct = new InstallProduct();
                ProductTreeIterator productTreeIterator = ProductTreeIteratorFactory.createProductIterator(productTree, new ProductTreeSource(PureJavaProductServiceImpl.this.getServices()), PureJavaProductServiceImpl.this);
                ProductBean productBean = productTreeIterator.getNext(productTreeIterator.begin());
                int n = 1;
                while (PureJavaProductServiceImpl.this.canContinueInstall(n) && productBean != productTreeIterator.end()) {
                    n = installProduct.install(productBean.getProductTree(), this, logSummary);
                    productBean = productTreeIterator.getNext(productBean);
                }
            }
            catch (Exception exception) {
                PureJavaProductServiceImpl.this.getServices().logEvent(this, "err", exception);
                logSummary.eventLogged(this, "err", exception.getMessage());
            }
        }
    }

    private class Uninstaller
    extends AsynchronousOperation {
        private ProductTree tree;
        private String source;
        private ProductActionSupport support;
        private int installState;

        Uninstaller(ProductTree productTree, ProductActionSupport productActionSupport) {
            super("Uninstaller for " + productTree, PureJavaProductServiceImpl.this);
            this.tree = productTree;
            this.support = productActionSupport;
            this.installState = 2;
        }

        Uninstaller(String string) {
            super("Uninstaller for " + string, PureJavaProductServiceImpl.this);
            this.source = string;
            this.installState = 3;
        }

        public void execute() {
            LogSummary logSummary = new LogSummary(PureJavaProductServiceImpl.this.getSummaryTypeDesc(4));
            try {
                PureJavaProductServiceImpl.this.addLogSummary(logSummary, 4, this.source);
                if (this.tree == null) {
                    this.tree = PureJavaProductServiceImpl.this.getProductTree(this.source);
                }
                this.setStatusDescription(LocalizedStringResolver.resolve("com.installshield.product.i18n.ProductResources", "PureJavaProductServiceImpl.Uninstaller.uninstalling", new String[]{PureJavaProductServiceImpl.this.getServices().resolveString(PureJavaProductServiceImpl.this.getProductBeanDisplayName(this.tree.getRoot()))}));
                UninstallResources uninstallResources = null;
                String string = null;
                if (this.support == null) {
                    string = FileUtils.createTempFile();
                    class Com_installshield_product_service_product_PureJavaProductServiceImpl$1 {
                        /* synthetic */ Com_installshield_product_service_product_PureJavaProductServiceImpl$1() {
                        }
                    }
                    uninstallResources = new UninstallResources(null, string, PureJavaProductServiceImpl.this.getServices().getId());
                    this.support = PureJavaProductServiceImpl.this.createProductActionSupport(uninstallResources, this, this.tree.getUninstallerArchive());
                }
                this.support.addLogListener(logSummary);
                PureJavaProductServiceImpl.this.preUninstallProduct(this.support, this.source);
                Hashtable hashtable = PureJavaProductServiceImpl.this.setActiveStateForUninstallation(this.tree, this.support, this.installState);
                ProductTreeIterator productTreeIterator = ProductTreeIteratorFactory.createUninstallableFeatureIterator(this.tree.getRoot(), this.installState);
                ProductBean productBean = productTreeIterator.getNext(productTreeIterator.begin());
                while (productBean != productTreeIterator.end()) {
                    PureJavaProductServiceImpl.this.uninstallProductBean(productBean, this.tree, hashtable, this.support, this.installState);
                    productBean = productTreeIterator.getNext(productBean);
                }
                productTreeIterator = ProductTreeIteratorFactory.createInstalledFeatureIterator(this.tree.getRoot());
                if (productTreeIterator.getNext(productTreeIterator.begin()) == productTreeIterator.end()) {
                    PureJavaProductServiceImpl.this.uninstallProductBean(this.tree.getRoot(), this.tree, hashtable, this.support, this.installState);
                }
                if (this.installState == 3) {
                    PureJavaProductServiceImpl.this.getRegistryService().finalizeRegistry();
                }
                PureJavaProductServiceImpl.this.postUninstallProduct(this.support, this.source);
                if (uninstallResources != null) {
                    if (this.installState == 3) {
                        uninstallResources.write();
                    }
                    uninstallResources.close();
                }
                if (this.installState == 3) {
                    UninstallerArchive uninstallerArchive = this.tree.getUninstallerArchive();
                    uninstallerArchive.setUninstallResources(string);
                    uninstallerArchive.uninstall(this.support);
                    if (((SoftwareObject)((Object)this.tree.getRoot())).getInstallStatus() == 4) {
                        if (this.tree.getUninstallerLauncher().isActive()) {
                            this.tree.getUninstallerLauncher().uninstall(this.support);
                        }
                        if (this.tree.getUninstallerJVMResolution().isActive()) {
                            this.tree.getUninstallerJVMResolution().uninstall(this.support);
                        }
                    }
                    PureJavaProductServiceImpl.this.unregisterUninstaller(this.tree);
                }
            }
            catch (Exception exception) {
                PureJavaProductServiceImpl.this.getServices().logEvent(this, "err", exception);
                logSummary.eventLogged(this, "err", exception.getMessage());
            }
        }
    }

    protected class DiskSpaceCheck
    extends InstallCheck {
        protected DiskSpaceCheck() {
        }

        public void execute(String string, WizardServices wizardServices, Log log) {
            try {
                FileService fileService = (FileService)wizardServices.getService("fileService");
                String string2 = ServiceFactory.getCurrentImplementorType(fileService);
                if (string2.endsWith("PureJavaFileServiceImpl")) {
                    log.logEvent(this, "wrn", LocalizedStringResolver.resolve("com.installshield.product.i18n.ProductResources", "PureJavaProductServiceImpl.DiskSpaceCheck.nativeSupportRequired"));
                    this.setPassed(true);
                } else {
                    boolean bl = false;
                    ProductBean productBean = null;
                    productBean = PureJavaProductServiceImpl.this.getProductBean(string, null);
                    if (productBean == null) {
                        bl = true;
                        log.logEvent(this, "wrn", LocalizedStringResolver.resolve("com.installshield.product.i18n.ProductResources", "PureJavaProductServiceImpl.DiskSpaceCheck.invalidProductSource", new String[]{string}));
                    } else {
                        String[] stringArray = fileService.getPartitionNames();
                        String string3 = FileUtils.getPartitionName(new File("").getAbsolutePath(), stringArray);
                        RequiredBytesTable requiredBytesTable = new RequiredBytes().getEstimatedRequiredBytes(productBean, PureJavaProductServiceImpl.this.getProductTree(string), new ProductTreeSource(PureJavaProductServiceImpl.this.getServices()), PureJavaProductServiceImpl.this.getRegistryService(), PureJavaProductServiceImpl.this);
                        requiredBytesTable = requiredBytesTable.consolidate(stringArray, string3);
                        Enumeration enumeration = requiredBytesTable.locations();
                        while (enumeration.hasMoreElements()) {
                            long l = 0L;
                            long l2 = 0L;
                            long l3 = 0L;
                            String string4 = (String)enumeration.nextElement();
                            l3 = requiredBytesTable.getBytes(string4);
                            if (l3 == 0L || (l = (l2 = fileService.getPartitionFreeSpace(string4, l3)) - l3) >= 0L) continue;
                            String string5 = FileUtils.formatSizeAsBytes(-l);
                            log.logEvent(this, "wrn", LocalizedStringResolver.resolve("com.installshield.product.i18n.ProductResources", "PureJavaProductServiceImpl.DiskSpaceCheck.insufficientSpace", new String[]{string4, string5}));
                            bl = true;
                        }
                        if (bl) {
                            this.setPassed(false);
                        } else {
                            this.setPassed(true);
                        }
                    }
                }
            }
            catch (ServiceException serviceException) {
                log.logEvent(this, "wrn", serviceException.getMessage());
                this.setPassed(true);
            }
        }

        public String getName() {
            return "diskspace";
        }
    }

    protected class DependenciesCheck
    extends InstallCheck {
        protected DependenciesCheck() {
        }

        private boolean checkDependenciesOnBean(ProductBean productBean, ProductTree productTree, Log log, WizardServices wizardServices) throws ServiceException {
            RegistryService registryService = (RegistryService)PureJavaProductServiceImpl.this.getServices().getService("registryService");
            boolean bl = true;
            ProductTreeIterator productTreeIterator = ProductTreeIteratorFactory.createRequiredComponentIterator(productBean);
            ProductBean productBean2 = productTreeIterator.getNext(productTreeIterator.begin());
            while (productBean2 != productTreeIterator.end()) {
                if (productBean2 instanceof SoftwareObjectReference) {
                    SoftwareObjectReference softwareObjectReference = (SoftwareObjectReference)productBean2;
                    SoftwareObject softwareObject = productTree.resolveKey(softwareObjectReference.getKey());
                    if (softwareObject != null) {
                        bl = bl && this.checkDependenciesOnBean((ProductBean)((Object)softwareObject), productTree, log, wizardServices);
                    } else if (softwareObjectReference.getResolutionPreference() == 2) {
                        softwareObject = registryService.getSoftwareObject(softwareObjectReference.getKey());
                    }
                    if (softwareObject == null) {
                        boolean bl2 = false;
                        if (softwareObjectReference.getSources() != null) {
                            int n = 0;
                            while (!bl2 && n < softwareObjectReference.getSources().length) {
                                ++n;
                            }
                        }
                        if (!bl2) {
                            bl = false;
                            ProductBean productBean3 = productBean2.getProductTree().getParent(productBean2);
                            String string = new String();
                            string = productBean3 instanceof SoftwareObject ? PureJavaProductServiceImpl.this.getProductBeanDisplayName(productBean3) : (productBean3 instanceof SoftwareObjectReference ? PureJavaProductServiceImpl.this.getProductBeanDisplayName(productBean3) : LocalizedStringResolver.resolve("com.installshield.product.i18n.ProductResources", "PureJavaProductServiceImpl.DependenciesCheck.parentNotFound"));
                            String string2 = LocalizedStringResolver.resolve("com.installshield.product.i18n.ProductResources", "PureJavaProductServiceImpl.DependenciesCheck.unresolvedDependency", new String[]{string, PureJavaProductServiceImpl.this.getProductBeanDisplayName(softwareObjectReference)});
                            log.logEvent(this, "err", string2);
                        }
                    }
                }
                productBean2 = productTreeIterator.getNext(productBean2);
            }
            return bl;
        }

        public void execute(String string, WizardServices wizardServices, Log log) {
            try {
                ProductTree productTree = PureJavaProductServiceImpl.this.getProductTree(string);
                this.setPassed(this.checkDependenciesOnBean(productTree.getRoot(), productTree, log, wizardServices));
            }
            catch (ServiceException serviceException) {
                log.logEvent(this, "err", serviceException.getMessage());
                this.invalidate();
            }
        }

        public String getName() {
            return "dependencies";
        }
    }

    private class InstallProduct
    extends InstallableObjectVisitor {
        InstallProduct() {
        }

        boolean actionsFailed(Object object) {
            int n = (Integer)object;
            return n != 0;
        }

        private int checkCanceled(ProductActionSupport productActionSupport) {
            if (productActionSupport.getOperationState().isCanceled()) {
                productActionSupport.logEvent(this, "wrn", LocalizedStringResolver.resolve("com.installshield.product.i18n.ProductResources", "PureJavaProductServiceImpl.installationCanceled"));
                PureJavaProductServiceImpl.this.getServices().logEvent(this, "wrn", "User cancelled installation.");
                return 3;
            }
            return 0;
        }

        boolean checkInstalledInstance(int n, SoftwareObject softwareObject, boolean bl) throws ServiceException {
            boolean bl2 = super.checkInstalledInstance(n, softwareObject, bl);
            if (bl2) {
                softwareObject.getKey().setInstance(n);
                softwareObject.setInstallStatus(3);
            } else {
                softwareObject.setInstallStatus(2);
                if (n > 0) {
                    softwareObject.getKey().setInstance(n);
                }
                PureJavaProductServiceImpl.this.addToVPD(softwareObject);
            }
            return bl2;
        }

        private void checkUninstallerJVMResolution(ProductTree productTree, ProductActionSupport productActionSupport) throws ServiceException {
            boolean bl = productTree.getUninstallerJVMResolution().isActive() ? (((SoftwareObject)((Object)productTree.getRoot())).getInstallStatus() == 3 ? productTree.getUninstallerJVMResolution().getResolveOnReinstalls() : true) : false;
            if (bl) {
                try {
                    productTree.getUninstallerJVMResolution().install(productActionSupport);
                }
                catch (ProductException productException) {
                    throw new ServiceException(productException);
                }
            }
        }

        Object getDefaultResult() {
            return new Integer(0);
        }

        boolean getResolveProductReferences() {
            return false;
        }

        Object getResultForProductAction(ProductAction productAction, ProductActionSupport productActionSupport) throws ServiceException {
            int n = this.checkCanceled(productActionSupport);
            if (n == 0) {
                try {
                    productAction.setTransientInstallState(true);
                    PureJavaProductServiceImpl.this.installProductAction(productAction, productActionSupport);
                    n = this.checkCanceled(productActionSupport);
                }
                catch (Throwable throwable) {
                    ProductComponent productComponent = productAction.getParentComponent();
                    n = productComponent.getProductTree().getInstallFailureOption(productComponent);
                    String string = productComponent.getOnFailSummaryMessage();
                    string = string == null || string.length() == 0 ? LocalizedStringResolver.resolve("com.installshield.product.i18n.ProductResources", "PureJavaProductServiceImpl.installationFailed") : PureJavaProductServiceImpl.this.getServices().resolveString(string);
                    string = PureJavaProductServiceImpl.this.appendLogFileToMsg(string);
                    productActionSupport.logEvent(this, "err", string);
                    PureJavaProductServiceImpl.this.getServices().logEvent(productAction, "err", string);
                    PureJavaProductServiceImpl.this.getServices().logEvent(productAction, "err", throwable);
                }
            }
            return new Integer(n);
        }

        int install(ProductTree productTree, AsynchronousOperation asynchronousOperation, LogSummary logSummary) throws IOException, ServiceException, ProductException {
            asynchronousOperation.setPercentComplete(0);
            asynchronousOperation.setStatusDescription(LocalizedStringResolver.resolve("com.installshield.product.i18n.ProductResources", "PureJavaProductServiceImpl.Installer.installing", new String[]{PureJavaProductServiceImpl.this.getProductBeanDisplayName(productTree.getRoot())}));
            boolean bl = PureJavaProductServiceImpl.this.isInstalled(productTree.getRoot());
            if (!bl) {
                PureJavaProductServiceImpl.this.configureUninstallerForCreation(productTree);
            }
            String string = FileUtils.createTempFile();
            UninstallResources uninstallResources = new UninstallResources(null, string, productTree.getRoot().getServices().getId());
            ProductActionSupport productActionSupport = PureJavaProductServiceImpl.this.createProductActionSupport(uninstallResources, asynchronousOperation, productTree.getUninstallerArchive());
            productActionSupport.addLogListener(logSummary);
            PureJavaProductServiceImpl.this.preInstallProduct(productTree, productActionSupport);
            String string2 = ((Product)productTree.getRoot()).getAbsoluteInstallLocation();
            FileService fileService = (FileService)PureJavaProductServiceImpl.this.getServices().getService("fileService");
            if (!fileService.fileExists(string2)) {
                fileService.createDirectory(string2);
                productTree.getUninstallerArchive().putInstalledFile(string2);
            }
            PureJavaProductServiceImpl.this.configureWizardLogForInstall(productTree);
            if (!bl) {
                PureJavaProductServiceImpl.this.setProductUninstaller(productTree);
            }
            asynchronousOperation.setEstimatedTimeToComplete(Math.max(new TimeToInstall().getEstimatedTimeToInstall(productTree.getRoot(), productTree, new ProductTreeSource(PureJavaProductServiceImpl.this.getServices()), PureJavaProductServiceImpl.this.getRegistryService(), PureJavaProductServiceImpl.this), 0));
            this.checkUninstallerJVMResolution(productTree, productActionSupport);
            asynchronousOperation.setLastMessage("install.start");
            int n = (Integer)this.visitProductBean(productTree.getRoot(), new ProductTreeSource(PureJavaProductServiceImpl.this.getServices()), productActionSupport, PureJavaProductServiceImpl.this.getRegistryService(), PureJavaProductServiceImpl.this);
            asynchronousOperation.setLastMessage("install.finish");
            switch (n) {
                case 0: 
                case 1: {
                    PureJavaProductServiceImpl.this.markProductBeanInstalled(productTree.getRoot(), productTree, productActionSupport);
                    if (productTree.getRoot() instanceof Product && ((Product)productTree.getRoot()).getInstallStatus() == 3) {
                        PureJavaProductServiceImpl.this.getRegistryService().finalizeRegistry();
                        asynchronousOperation.setStatusDescription(LocalizedStringResolver.resolve("com.installshield.product.i18n.ProductResources", "PureJavaProductServiceImpl.Installer.createUninstaller"));
                        break;
                    }
                    n = 2;
                    break;
                }
                case 3: {
                    PureJavaProductServiceImpl.this.setExitCode(2002);
                    this.rollbackProduct(productTree, productActionSupport);
                    PureJavaProductServiceImpl.this.markProductBeanInstalled(productTree.getRoot(), productTree, productActionSupport);
                    if (!bl) break;
                    PureJavaProductServiceImpl.this.getRegistryService().finalizeRegistry();
                    break;
                }
                case 2: {
                    PureJavaProductServiceImpl.this.setExitCode(2002);
                    PureJavaProductServiceImpl.this.markProductBeanInstalled(productTree.getRoot(), productTree, productActionSupport);
                    PureJavaProductServiceImpl.this.getRegistryService().finalizeRegistry();
                    break;
                }
            }
            if (PureJavaProductServiceImpl.this.canContinueInstall(n)) {
                PureJavaProductServiceImpl.this.postInstallProduct(productTree, productActionSupport);
            }
            if (PureJavaProductServiceImpl.this.canContinueInstall(n)) {
                uninstallResources.write();
            }
            uninstallResources.close();
            if (PureJavaProductServiceImpl.this.canContinueInstall(n) || bl) {
                asynchronousOperation.setLastMessage("uninstall.create.start");
                if (!bl && productTree.getUninstallerLauncher().isActive()) {
                    productTree.getUninstallerLauncher().install(productActionSupport);
                }
                UninstallerArchive uninstallerArchive = productTree.getUninstallerArchive();
                uninstallerArchive.setUninstallResources(string);
                uninstallerArchive.install(productActionSupport);
                PureJavaProductServiceImpl.this.registerUninstaller(productTree);
                asynchronousOperation.setLastMessage("uninstall.create.finish");
            }
            return n;
        }

        void postVisitComponent(ProductBean productBean, ProductActionSupport productActionSupport) throws ServiceException {
            PureJavaProductServiceImpl.this.postInstallProductComponent(productBean, productActionSupport);
        }

        boolean preVisitComponent(ProductBean productBean, ProductActionSupport productActionSupport) throws ServiceException {
            return PureJavaProductServiceImpl.this.preInstallProductComponent(productBean, productActionSupport);
        }

        void processActionsFailed(ProductBean productBean, ProductActionSupport productActionSupport, ProductTreeIterator productTreeIterator) throws ServiceException {
            ProductBean productBean2 = productTreeIterator.getNext(productTreeIterator.begin());
            while (productBean2 != productTreeIterator.end()) {
                ProductAction productAction = (ProductAction)productBean2;
                if (productAction.getTransientInstallState()) {
                    try {
                        PureJavaProductServiceImpl.this.uninstallProductAction(productAction, productActionSupport);
                    }
                    catch (Throwable throwable) {
                        String string = LocalizedStringResolver.resolve("com.installshield.product.i18n.ProductResources", "PureJavaProductServiceImpl.uninstallationFailed");
                        string = PureJavaProductServiceImpl.this.appendLogFileToMsg(string);
                        productActionSupport.logEvent(this, "err", string);
                        PureJavaProductServiceImpl.this.getServices().logEvent(this, "err", string);
                        PureJavaProductServiceImpl.this.getServices().logEvent(productAction, "err", throwable);
                    }
                    productAction.setTransientInstallState(false);
                }
                productBean2 = productTreeIterator.getNext(productBean2);
            }
            PureJavaProductServiceImpl.this.rollbackProductComponent((ProductComponent)productBean);
            ((ProductComponent)productBean).setInstallStatus(0);
        }

        Object processNewResult(Object object, Object object2) {
            return object2;
        }

        private void rollbackProduct(ProductTree productTree, ProductActionSupport productActionSupport) throws ServiceException {
            OperationKey operationKey = PureJavaProductServiceImpl.this.uninstallProduct(productTree, productActionSupport);
            AsynchronousOperation asynchronousOperation = PureJavaProductServiceImpl.this.getOperation(operationKey);
            while (!asynchronousOperation.isEnded()) {
                AsynchronousOperation asynchronousOperation2 = asynchronousOperation;
                synchronized (asynchronousOperation2) {
                    try {
                        asynchronousOperation.wait();
                    }
                    catch (InterruptedException interruptedException) {
                        throw new Error();
                    }
                }
            }
        }

        boolean shouldContinue(Object object) {
            int n = (Integer)object;
            return n == 0 || n == 1;
        }

        void updateSoftwareObject(ProductBean productBean, SoftwareObjectKey softwareObjectKey) throws ServiceException {
            PureJavaProductServiceImpl.this.addParentInVPD(productBean, softwareObjectKey);
            PureJavaProductServiceImpl.this.updateRequiredOnParent(productBean, softwareObjectKey);
        }
    }

    private class UninstallResources
    extends ArchiveWriter {
        private ZipOutputStream out;
        private FileOutputStream fileOut;

        /* synthetic */ UninstallResources(1 var2_2, String string, String string2) throws IOException {
            this(string, string2);
        }

        private UninstallResources(String string, String string2) throws IOException {
            this.fileOut = new FileOutputStream(string);
            this.out = new ZipOutputStream(this.fileOut);
            this.initialize(new StandardResourceReaderFactory(string2), new ZipResourceWriterFactory(this.out, string2));
        }

        void close() throws IOException {
            try {
                block4: {
                    try {
                        this.out.finish();
                        this.out.close();
                    }
                    catch (ZipException zipException) {
                        if (zipException.getMessage().startsWith("ZIP file must have at least one entry")) break block4;
                        throw zipException;
                    }
                }
                Object var2_2 = null;
            }
            catch (Throwable throwable) {
                Object var2_3 = null;
                this.fileOut.close();
                throw throwable;
            }
            this.fileOut.close();
        }
    }

    protected class UninstallerInfo {
        public final int NOT_AVAILABLE = 1;
        public final int AVAILABLE = 2;
        public final int OBTAINABLE = 3;
        private int uninstallerStatus = 1;
        private String productInstallLocation = "";
        private String installLocation = "";
        private String archiveFileName = "";
        private String dataFileName = "";
        private String launcherFileName = "";

        public void decodeRegistryValue(String string) {
            CommandLineTokenizer commandLineTokenizer = new CommandLineTokenizer(string);
            if (commandLineTokenizer.hasMoreElements()) {
                this.setInstallLocation((String)commandLineTokenizer.nextElement());
            } else {
                this.setInstallLocation("");
            }
            if (commandLineTokenizer.hasMoreElements()) {
                this.setArchiveFileName((String)commandLineTokenizer.nextElement());
            } else {
                this.setArchiveFileName("");
            }
            if (commandLineTokenizer.hasMoreElements()) {
                this.setDataFileName((String)commandLineTokenizer.nextElement());
            } else {
                this.setDataFileName("");
            }
            if (commandLineTokenizer.hasMoreElements()) {
                this.setLauncherFileName((String)commandLineTokenizer.nextElement());
            } else {
                this.setLauncherFileName("");
            }
        }

        public String encodeRegistryValue() {
            return CommandLineTokenizer.createSpaceDelimitedString(new String[]{this.installLocation, this.archiveFileName, this.dataFileName, this.launcherFileName});
        }

        public String getAbsoluteDataFileName() {
            String string = FileUtils.createFileName(this.productInstallLocation, FileUtils.createFileName(this.installLocation, this.dataFileName));
            return string;
        }

        public String getArchiveFileName() {
            return this.archiveFileName;
        }

        public String getDataFileName() {
            return this.dataFileName;
        }

        public String getInstallLocation() {
            return this.installLocation;
        }

        public String getLauncherFileName() {
            return this.launcherFileName;
        }

        public String getProductInstallLocation() {
            return this.productInstallLocation;
        }

        public int getUninstallerStatus() {
            return this.uninstallerStatus;
        }

        public void setArchiveFileName(String string) {
            this.archiveFileName = string;
        }

        public void setDataFileName(String string) {
            this.dataFileName = string;
        }

        public void setInstallLocation(String string) {
            this.installLocation = string;
        }

        public void setLauncherFileName(String string) {
            this.launcherFileName = string;
        }

        public void setProductInstallLocation(String string) {
            this.productInstallLocation = string;
        }

        public void setUninstallerStatus(int n) {
            this.uninstallerStatus = n;
        }
    }
}

