/*
 * Decompiled with CFR 0.152.
 */
package com.installshield.product.service.registry;

import com.installshield.product.GenericSoftwareObject;
import com.installshield.product.ProductBean;
import com.installshield.product.SoftwareObject;
import com.installshield.product.SoftwareObjectKey;
import com.installshield.product.SoftwareObjectReference;
import com.installshield.product.SoftwareVersion;
import com.installshield.product.service.registry.RegistryServiceImplementor;
import com.installshield.util.FileUtils;
import com.installshield.wizard.service.AbstractServiceImplementor;
import com.installshield.wizard.service.ServiceException;
import com.installshield.wizard.service.WizardLog;
import com.installshield.wizard.service.file.FileService;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.StringTokenizer;
import java.util.Vector;

public class PureJavaRegistryServiceImpl
extends AbstractServiceImplementor
implements RegistryServiceImplementor {
    private Hashtable vpd = new Hashtable();
    private static final String FIELD_DELIMITER = "|";

    public void addParentSoftwareObjects(SoftwareObjectKey softwareObjectKey, SoftwareObjectKey[] softwareObjectKeyArray) throws ServiceException {
        if (softwareObjectKeyArray.length == 0) {
            return;
        }
        SoftwareObject softwareObject = this.getFromVPD(softwareObjectKey);
        if (softwareObject instanceof GenericSoftwareObject) {
            GenericSoftwareObject genericSoftwareObject = (GenericSoftwareObject)softwareObject;
            Vector vector = this.makeSoftwareObjectKeyVector(genericSoftwareObject.getParents());
            boolean bl = false;
            int n = 0;
            while (n < softwareObjectKeyArray.length) {
                if (vector.indexOf(softwareObjectKeyArray[n]) < 0) {
                    vector.addElement(softwareObjectKeyArray[n]);
                    bl = true;
                }
                ++n;
            }
            if (bl) {
                SoftwareObjectKey[] softwareObjectKeyArray2 = this.loadSoftwareObjectKeyArray(vector);
                ((GenericSoftwareObject)softwareObject).setParents(softwareObjectKeyArray2);
                this.insertIntoVPD(softwareObjectKey, softwareObject, false);
            }
        }
    }

    public void addRequiredSoftwareObjects(SoftwareObjectKey softwareObjectKey, SoftwareObjectReference[] softwareObjectReferenceArray) throws ServiceException {
        if (softwareObjectReferenceArray == null || softwareObjectReferenceArray.length == 0) {
            return;
        }
        SoftwareObject softwareObject = this.getFromVPD(softwareObjectKey);
        if (softwareObject instanceof GenericSoftwareObject) {
            GenericSoftwareObject genericSoftwareObject = (GenericSoftwareObject)softwareObject;
            Vector vector = this.makeSoftwareObjectReferenceVector(genericSoftwareObject.getRequired());
            boolean bl = false;
            int n = 0;
            while (n < softwareObjectReferenceArray.length) {
                if (vector.indexOf(softwareObjectReferenceArray[n]) < 0) {
                    vector.addElement(softwareObjectReferenceArray[n]);
                    bl = true;
                }
                ++n;
            }
            if (bl) {
                SoftwareObjectReference[] softwareObjectReferenceArray2 = this.loadSoftwareObjectReferenceArray(vector);
                ((GenericSoftwareObject)softwareObject).setRequired(softwareObjectReferenceArray2);
                this.insertIntoVPD(softwareObjectKey, softwareObject, false);
            }
        }
    }

    private String dumpBoolean(boolean bl) {
        Boolean bl2 = new Boolean(bl);
        return bl2.toString();
    }

    private String dumpFieldValue(String string, boolean bl) {
        String string2 = string != null && string.length() > 0 ? string : " ";
        if (bl) {
            string2 = String.valueOf(string2) + FIELD_DELIMITER;
        }
        return string2;
    }

    private String dumpInt(int n) {
        return Integer.toString(n);
    }

    private String dumpSoftwareObject(SoftwareObject softwareObject) {
        String string = this.dumpFieldValue(softwareObject.getName(), true);
        string = String.valueOf(string) + this.dumpFieldValue(softwareObject.getDisplayName(), true);
        string = String.valueOf(string) + this.dumpFieldValue(softwareObject.getDescription(), true);
        string = String.valueOf(string) + this.dumpFieldValue(softwareObject.getVendor(), true);
        string = String.valueOf(string) + this.dumpFieldValue(softwareObject.getVendorWebsite(), true);
        string = String.valueOf(string) + this.dumpFieldValue(softwareObject.getProductNumber(), true);
        string = String.valueOf(string) + this.dumpFieldValue(softwareObject.getInstallLocation(), true);
        string = String.valueOf(string) + this.dumpFieldValue(this.dumpStringArray(softwareObject.getSources()), true);
        string = String.valueOf(string) + this.dumpFieldValue(this.dumpSoftwareObjectReferenceArray(softwareObject.getRequired()), true);
        string = String.valueOf(string) + this.dumpFieldValue(this.dumpSoftwareObjectKeyArray(softwareObject.getParents()), true);
        string = String.valueOf(string) + this.dumpFieldValue(this.dumpSoftwareVersionArray(softwareObject.getCompatibleVersions()), true);
        string = String.valueOf(string) + this.dumpFieldValue(this.dumpBoolean(softwareObject.isPubliclyShareable()), true);
        string = String.valueOf(string) + this.dumpFieldValue(softwareObject.getUninstaller(), true);
        string = String.valueOf(string) + this.dumpFieldValue(this.dumpBoolean(softwareObject.isActive()), true);
        string = String.valueOf(string) + this.dumpFieldValue(this.dumpInt(softwareObject.getInstallStatus()), true);
        string = String.valueOf(string) + this.dumpFieldValue(this.dumpSoftwareObjectKey(softwareObject.getKey()), false);
        return string;
    }

    private String dumpSoftwareObjectKey(SoftwareObjectKey softwareObjectKey) {
        String string = this.dumpFieldValue(softwareObjectKey.getUID(), true);
        string = String.valueOf(string) + this.dumpFieldValue(this.dumpSoftwareVersion(softwareObjectKey.getVersion()), true);
        string = String.valueOf(string) + this.dumpFieldValue(this.dumpInt(softwareObjectKey.getInstance()), false);
        return string;
    }

    private String dumpSoftwareObjectKeyArray(SoftwareObjectKey[] softwareObjectKeyArray) {
        String string = this.dumpFieldValue(this.dumpInt(softwareObjectKeyArray.length), false);
        int n = 0;
        while (n < softwareObjectKeyArray.length) {
            string = String.valueOf(string) + FIELD_DELIMITER;
            string = String.valueOf(string) + this.dumpFieldValue(this.dumpSoftwareObjectKey(softwareObjectKeyArray[n]), false);
            ++n;
        }
        return string;
    }

    private String dumpSoftwareObjectReference(SoftwareObjectReference softwareObjectReference) {
        String string = this.dumpFieldValue(this.dumpSoftwareObjectKey(softwareObjectReference.getKey()), true);
        string = String.valueOf(string) + this.dumpFieldValue(this.dumpStringArray(softwareObjectReference.getSources()), true);
        string = String.valueOf(string) + this.dumpFieldValue(this.dumpInt(softwareObjectReference.getResolutionPreference()), true);
        string = String.valueOf(string) + this.dumpFieldValue(softwareObjectReference.getDisplayName(), false);
        return string;
    }

    private String dumpSoftwareObjectReferenceArray(SoftwareObjectReference[] softwareObjectReferenceArray) {
        String string = this.dumpFieldValue(this.dumpInt(softwareObjectReferenceArray.length), false);
        int n = 0;
        while (n < softwareObjectReferenceArray.length) {
            string = String.valueOf(string) + FIELD_DELIMITER;
            string = String.valueOf(string) + this.dumpFieldValue(this.dumpSoftwareObjectReference(softwareObjectReferenceArray[n]), false);
            ++n;
        }
        return string;
    }

    private String dumpSoftwareVersion(SoftwareVersion softwareVersion) {
        String string = this.dumpFieldValue(softwareVersion.getMajor(), true);
        string = String.valueOf(string) + this.dumpFieldValue(softwareVersion.getMinor(), true);
        string = String.valueOf(string) + this.dumpFieldValue(softwareVersion.getUpdate(), true);
        string = String.valueOf(string) + this.dumpFieldValue(softwareVersion.getMaintenance(), true);
        string = String.valueOf(string) + this.dumpFieldValue(softwareVersion.getFormatted(), false);
        return string;
    }

    private String dumpSoftwareVersionArray(SoftwareVersion[] softwareVersionArray) {
        String string = this.dumpFieldValue(this.dumpInt(softwareVersionArray.length), false);
        int n = 0;
        while (n < softwareVersionArray.length) {
            string = String.valueOf(string) + FIELD_DELIMITER;
            string = String.valueOf(string) + this.dumpFieldValue(this.dumpSoftwareVersion(softwareVersionArray[n]), false);
            ++n;
        }
        return string;
    }

    private String dumpStringArray(String[] stringArray) {
        if (stringArray == null) {
            return this.dumpFieldValue(this.dumpInt(0), false);
        }
        String string = this.dumpFieldValue(this.dumpInt(stringArray.length), false);
        int n = 0;
        while (n < stringArray.length) {
            string = String.valueOf(string) + FIELD_DELIMITER;
            string = String.valueOf(string) + this.dumpFieldValue(stringArray[n], false);
            ++n;
        }
        return string;
    }

    public void finalizeRegistry() throws ServiceException {
        this.writeVPD();
    }

    private String getFieldValue(StringTokenizer stringTokenizer) {
        String string = stringTokenizer.nextToken();
        if (string.trim().length() == 0) {
            string = "";
        }
        return string;
    }

    private SoftwareObject getFromVPD(SoftwareObjectKey softwareObjectKey) {
        SoftwareObject softwareObject = null;
        Hashtable hashtable = (Hashtable)this.vpd.get(softwareObjectKey);
        if (hashtable != null) {
            softwareObject = (SoftwareObject)hashtable.get(new Integer(softwareObjectKey.getInstance()));
        }
        return softwareObject;
    }

    public int getInstalledInstance(SoftwareObjectKey softwareObjectKey, String string) throws ServiceException {
        int n = -1;
        Hashtable hashtable = (Hashtable)this.vpd.get(softwareObjectKey);
        if (hashtable != null) {
            FileService fileService = null;
            try {
                fileService = (FileService)this.getServices().getService("fileService");
            }
            catch (ServiceException serviceException) {
                this.logEvent(this, "err", serviceException);
            }
            Enumeration enumeration = hashtable.elements();
            while (n < 0 && enumeration.hasMoreElements()) {
                SoftwareObject softwareObject = (SoftwareObject)enumeration.nextElement();
                String string2 = softwareObject.getInstallLocation();
                boolean bl = false;
                if (fileService != null) {
                    try {
                        bl = fileService.comparePaths(string, string2);
                    }
                    catch (ServiceException serviceException) {
                        this.logEvent(this, "err", serviceException);
                        bl = FileUtils.comparePaths(string, string2);
                    }
                } else {
                    bl = FileUtils.comparePaths(string, string2);
                }
                if (!bl) continue;
                n = softwareObject.getKey().getInstance();
            }
        }
        return n;
    }

    public int getNewestInstance(SoftwareObjectKey softwareObjectKey) throws ServiceException {
        return this.getNextNewestInstance(softwareObjectKey, Integer.MAX_VALUE);
    }

    public int getNextNewestInstance(SoftwareObjectKey softwareObjectKey, int n) throws ServiceException {
        int n2 = -1;
        Hashtable hashtable = (Hashtable)this.vpd.get(softwareObjectKey);
        if (hashtable != null) {
            Enumeration enumeration = hashtable.elements();
            while (enumeration.hasMoreElements()) {
                SoftwareObject softwareObject = (SoftwareObject)enumeration.nextElement();
                int n3 = softwareObject.getKey().getInstance();
                if (n3 >= n || n3 <= n2) continue;
                n2 = n3;
            }
        }
        return n2;
    }

    public SoftwareObject getSoftwareObject(SoftwareObjectKey softwareObjectKey) throws ServiceException {
        SoftwareObject softwareObject = null;
        if (softwareObjectKey.getInstance() == 0) {
            Hashtable hashtable = (Hashtable)this.vpd.get(softwareObjectKey);
            if (hashtable != null) {
                Enumeration enumeration = hashtable.elements();
                while (softwareObject == null && enumeration.hasMoreElements()) {
                    SoftwareObject softwareObject2 = (SoftwareObject)enumeration.nextElement();
                    if (!softwareObject2.isPubliclyShareable()) continue;
                    softwareObject = softwareObject2;
                }
            }
        } else {
            softwareObject = this.getFromVPD(softwareObjectKey);
        }
        return softwareObject;
    }

    public int getSystemCompatibility() {
        return 1;
    }

    public String getVPDFileName() throws ServiceException {
        String string = System.getProperty("user.home");
        if (!(string.endsWith("/") || string.endsWith("\\") || string.endsWith(File.separator))) {
            string = String.valueOf(string) + "/";
        }
        return new String(String.valueOf(string) + "vpd.properties");
    }

    public void initializeRegistry() throws ServiceException {
        this.readVPD();
    }

    protected void initialized() {
        super.initialized();
        try {
            this.initializeRegistry();
        }
        catch (ServiceException serviceException) {}
    }

    private void insertIntoVPD(SoftwareObjectKey softwareObjectKey, SoftwareObject softwareObject, boolean bl) {
        Object object;
        if (bl && softwareObject instanceof GenericSoftwareObject) {
            object = (GenericSoftwareObject)softwareObject;
            ((GenericSoftwareObject)object).setInstallLocation(((ProductBean)object).getProductTree().getInstallLocation((ProductBean)object));
        }
        object = null;
        if (this.vpd.containsKey(softwareObjectKey)) {
            object = (Hashtable)this.vpd.get(softwareObjectKey);
        } else {
            object = new Hashtable();
            this.vpd.put(softwareObjectKey, object);
        }
        int n = softwareObjectKey.getInstance();
        if (softwareObjectKey.getInstance() == 0) {
            int n2 = 1;
            Enumeration enumeration = ((Hashtable)object).keys();
            while (enumeration.hasMoreElements()) {
                int n3 = (Integer)enumeration.nextElement();
                if (n3 < n2) continue;
                n2 = n3 + 1;
            }
            softwareObjectKey.setInstance(n2);
            n = n2;
        }
        ((Hashtable)object).put(new Integer(n), softwareObject);
    }

    private boolean loadBoolean(StringTokenizer stringTokenizer) {
        return Boolean.valueOf(this.getFieldValue(stringTokenizer));
    }

    private int loadInt(StringTokenizer stringTokenizer) {
        return Integer.parseInt(this.getFieldValue(stringTokenizer));
    }

    private SoftwareObject loadSoftwareObject(String string) {
        GenericSoftwareObject genericSoftwareObject = new GenericSoftwareObject();
        StringTokenizer stringTokenizer = new StringTokenizer(string, FIELD_DELIMITER, false);
        genericSoftwareObject.setName(this.getFieldValue(stringTokenizer));
        genericSoftwareObject.setDisplayName(this.getFieldValue(stringTokenizer));
        genericSoftwareObject.setDescription(this.getFieldValue(stringTokenizer));
        genericSoftwareObject.setVendor(this.getFieldValue(stringTokenizer));
        genericSoftwareObject.setVendorWebsite(this.getFieldValue(stringTokenizer));
        genericSoftwareObject.setProductNumber(this.getFieldValue(stringTokenizer));
        genericSoftwareObject.setInstallLocation(this.getFieldValue(stringTokenizer));
        genericSoftwareObject.setSources(this.loadStringArray(stringTokenizer));
        genericSoftwareObject.setRequired(this.loadSoftwareObjectReferenceArray(stringTokenizer));
        genericSoftwareObject.setParents(this.loadSoftwareObjectKeyArray(stringTokenizer));
        genericSoftwareObject.setCompatibleVersions(this.loadSoftwareVersionArray(stringTokenizer));
        genericSoftwareObject.setPubliclyShareable(this.loadBoolean(stringTokenizer));
        genericSoftwareObject.setUninstaller(this.getFieldValue(stringTokenizer));
        genericSoftwareObject.setActive(this.loadBoolean(stringTokenizer));
        genericSoftwareObject.setInstallStatus(this.loadInt(stringTokenizer));
        genericSoftwareObject.setKey(this.loadSoftwareObjectKey(stringTokenizer));
        return genericSoftwareObject;
    }

    private SoftwareObjectKey loadSoftwareObjectKey(String string) {
        StringTokenizer stringTokenizer = new StringTokenizer(string, FIELD_DELIMITER, false);
        return this.loadSoftwareObjectKey(stringTokenizer);
    }

    private SoftwareObjectKey loadSoftwareObjectKey(StringTokenizer stringTokenizer) {
        SoftwareObjectKey softwareObjectKey = new SoftwareObjectKey();
        softwareObjectKey.setUID(this.getFieldValue(stringTokenizer));
        softwareObjectKey.setVersion(this.loadSoftwareVersion(stringTokenizer));
        softwareObjectKey.setInstance(this.loadInt(stringTokenizer));
        return softwareObjectKey;
    }

    private SoftwareObjectKey[] loadSoftwareObjectKeyArray(StringTokenizer stringTokenizer) {
        int n = this.loadInt(stringTokenizer);
        SoftwareObjectKey[] softwareObjectKeyArray = new SoftwareObjectKey[n];
        int n2 = 0;
        while (n2 < n) {
            softwareObjectKeyArray[n2] = this.loadSoftwareObjectKey(stringTokenizer);
            ++n2;
        }
        return softwareObjectKeyArray;
    }

    private SoftwareObjectKey[] loadSoftwareObjectKeyArray(Vector vector) {
        SoftwareObjectKey[] softwareObjectKeyArray = new SoftwareObjectKey[vector.size()];
        int n = 0;
        while (n < vector.size()) {
            softwareObjectKeyArray[n] = (SoftwareObjectKey)vector.elementAt(n);
            ++n;
        }
        return softwareObjectKeyArray;
    }

    private SoftwareObjectReference loadSoftwareObjectReference(StringTokenizer stringTokenizer) {
        SoftwareObjectReference softwareObjectReference = new SoftwareObjectReference();
        softwareObjectReference.setKey(this.loadSoftwareObjectKey(stringTokenizer));
        softwareObjectReference.setSources(this.loadStringArray(stringTokenizer));
        softwareObjectReference.setResolutionPreference(this.loadInt(stringTokenizer));
        softwareObjectReference.setDisplayName(this.getFieldValue(stringTokenizer));
        return softwareObjectReference;
    }

    private SoftwareObjectReference[] loadSoftwareObjectReferenceArray(StringTokenizer stringTokenizer) {
        int n = this.loadInt(stringTokenizer);
        SoftwareObjectReference[] softwareObjectReferenceArray = new SoftwareObjectReference[n];
        int n2 = 0;
        while (n2 < n) {
            softwareObjectReferenceArray[n2] = this.loadSoftwareObjectReference(stringTokenizer);
            ++n2;
        }
        return softwareObjectReferenceArray;
    }

    private SoftwareObjectReference[] loadSoftwareObjectReferenceArray(Vector vector) {
        SoftwareObjectReference[] softwareObjectReferenceArray = new SoftwareObjectReference[vector.size()];
        int n = 0;
        while (n < vector.size()) {
            softwareObjectReferenceArray[n] = (SoftwareObjectReference)vector.elementAt(n);
            ++n;
        }
        return softwareObjectReferenceArray;
    }

    private SoftwareVersion loadSoftwareVersion(StringTokenizer stringTokenizer) {
        SoftwareVersion softwareVersion = new SoftwareVersion();
        softwareVersion.setMajor(this.getFieldValue(stringTokenizer));
        softwareVersion.setMinor(this.getFieldValue(stringTokenizer));
        softwareVersion.setUpdate(this.getFieldValue(stringTokenizer));
        softwareVersion.setMaintenance(this.getFieldValue(stringTokenizer));
        softwareVersion.setFormatted(this.getFieldValue(stringTokenizer));
        return softwareVersion;
    }

    private SoftwareVersion[] loadSoftwareVersionArray(StringTokenizer stringTokenizer) {
        int n = this.loadInt(stringTokenizer);
        SoftwareVersion[] softwareVersionArray = new SoftwareVersion[n];
        int n2 = 0;
        while (n2 < n) {
            softwareVersionArray[n2] = this.loadSoftwareVersion(stringTokenizer);
            ++n2;
        }
        return softwareVersionArray;
    }

    private String[] loadStringArray(StringTokenizer stringTokenizer) {
        int n = this.loadInt(stringTokenizer);
        String[] stringArray = new String[n];
        int n2 = 0;
        while (n2 < n) {
            stringArray[n2] = this.getFieldValue(stringTokenizer);
            ++n2;
        }
        return stringArray;
    }

    private Vector makeSoftwareObjectKeyVector(SoftwareObjectKey[] softwareObjectKeyArray) {
        Vector<SoftwareObjectKey> vector = new Vector<SoftwareObjectKey>(softwareObjectKeyArray.length);
        int n = 0;
        while (n < softwareObjectKeyArray.length) {
            vector.addElement(softwareObjectKeyArray[n]);
            ++n;
        }
        return vector;
    }

    private Vector makeSoftwareObjectReferenceVector(SoftwareObjectReference[] softwareObjectReferenceArray) {
        Vector<SoftwareObjectReference> vector = new Vector<SoftwareObjectReference>(softwareObjectReferenceArray.length);
        int n = 0;
        while (n < softwareObjectReferenceArray.length) {
            vector.addElement(softwareObjectReferenceArray[n]);
            ++n;
        }
        return vector;
    }

    private void readVPD() {
        this.vpd.clear();
        FileInputStream fileInputStream = null;
        BufferedReader bufferedReader = null;
        try {
            try {
                String string = this.getVPDFileName();
                File file = new File(string);
                if (file.canRead()) {
                    fileInputStream = new FileInputStream(file);
                    bufferedReader = new BufferedReader(new InputStreamReader((InputStream)fileInputStream, "8859_1"));
                    boolean bl = false;
                    while (!bl) {
                        char c;
                        String string2 = bufferedReader.readLine();
                        if (string2 == null) {
                            bl = true;
                            continue;
                        }
                        if (string2.trim().length() <= 0 || (c = string2.charAt(0)) == '#' || c == '!') continue;
                        int n = string2.indexOf(61);
                        String string3 = string2.substring(0, n);
                        String string4 = string2.substring(n + 1);
                        SoftwareObjectKey softwareObjectKey = this.loadSoftwareObjectKey(string3);
                        SoftwareObject softwareObject = this.loadSoftwareObject(string4);
                        this.insertIntoVPD(softwareObjectKey, softwareObject, false);
                    }
                }
            }
            catch (Throwable throwable) {
                this.logEvent(this, "err", throwable);
            }
            Object var4_14 = null;
        }
        catch (Throwable throwable) {
            Object var4_15 = null;
            try {
                if (fileInputStream != null) {
                    fileInputStream.close();
                }
            }
            catch (IOException iOException) {}
            try {
                if (bufferedReader != null) {
                    bufferedReader.close();
                }
            }
            catch (IOException iOException) {}
            throw throwable;
        }
        try {
            if (fileInputStream != null) {
                fileInputStream.close();
            }
        }
        catch (IOException iOException) {}
        try {
            if (bufferedReader != null) {
                bufferedReader.close();
            }
        }
        catch (IOException iOException) {}
    }

    public void removeParentSoftwareObjects(SoftwareObjectKey softwareObjectKey, SoftwareObjectKey[] softwareObjectKeyArray) throws ServiceException {
        if (softwareObjectKeyArray.length == 0) {
            return;
        }
        SoftwareObject softwareObject = this.getFromVPD(softwareObjectKey);
        if (softwareObject instanceof GenericSoftwareObject) {
            GenericSoftwareObject genericSoftwareObject = (GenericSoftwareObject)softwareObject;
            Vector vector = this.makeSoftwareObjectKeyVector(genericSoftwareObject.getParents());
            boolean bl = false;
            int n = 0;
            while (n < softwareObjectKeyArray.length) {
                if (vector.removeElement(softwareObjectKeyArray[n])) {
                    bl = true;
                }
                ++n;
            }
            if (bl) {
                SoftwareObjectKey[] softwareObjectKeyArray2 = this.loadSoftwareObjectKeyArray(vector);
                ((GenericSoftwareObject)softwareObject).setParents(softwareObjectKeyArray2);
                this.insertIntoVPD(softwareObjectKey, softwareObject, false);
            }
        }
    }

    public void removeRequiredSoftwareObjects(SoftwareObjectKey softwareObjectKey, SoftwareObjectReference[] softwareObjectReferenceArray) throws ServiceException {
        if (softwareObjectReferenceArray == null || softwareObjectReferenceArray.length == 0) {
            return;
        }
        SoftwareObject softwareObject = this.getFromVPD(softwareObjectKey);
        if (softwareObject instanceof GenericSoftwareObject) {
            GenericSoftwareObject genericSoftwareObject = (GenericSoftwareObject)softwareObject;
            Vector vector = this.makeSoftwareObjectReferenceVector(genericSoftwareObject.getRequired());
            boolean bl = false;
            int n = 0;
            while (n < softwareObjectReferenceArray.length) {
                if (vector.removeElement(softwareObjectReferenceArray[n])) {
                    bl = true;
                }
                ++n;
            }
            if (bl) {
                SoftwareObjectReference[] softwareObjectReferenceArray2 = this.loadSoftwareObjectReferenceArray(vector);
                ((GenericSoftwareObject)softwareObject).setRequired(softwareObjectReferenceArray2);
                this.insertIntoVPD(softwareObjectKey, softwareObject, false);
            }
        }
    }

    public void removeSoftwareObject(SoftwareObjectKey softwareObjectKey) throws ServiceException {
        Integer n;
        SoftwareObject softwareObject;
        Hashtable hashtable = (Hashtable)this.vpd.get(softwareObjectKey);
        if (hashtable != null && (softwareObject = (SoftwareObject)hashtable.get(n = new Integer(softwareObjectKey.getInstance()))) != null) {
            hashtable.remove(n);
            softwareObjectKey.setInstance(0);
        }
    }

    public SoftwareObjectKey setSoftwareObject(SoftwareObject softwareObject) throws ServiceException {
        SoftwareObjectKey softwareObjectKey = softwareObject.getKey();
        this.insertIntoVPD(softwareObjectKey, softwareObject, true);
        return softwareObjectKey;
    }

    public void updateParentSoftwareObject(SoftwareObjectKey softwareObjectKey, SoftwareObjectKey softwareObjectKey2) {
        SoftwareObject softwareObject = this.getFromVPD(softwareObjectKey);
        SoftwareObjectKey[] softwareObjectKeyArray = softwareObject.getParents();
        boolean bl = false;
        int n = 0;
        while (!bl && n < softwareObjectKeyArray.length) {
            if (softwareObjectKey2.equals(softwareObjectKeyArray[n])) {
                softwareObjectKeyArray[n] = softwareObjectKey2;
                bl = true;
            }
            ++n;
        }
    }

    public void updateRequiredSoftwareObject(SoftwareObjectKey softwareObjectKey, SoftwareObjectKey softwareObjectKey2) {
        SoftwareObject softwareObject = this.getFromVPD(softwareObjectKey);
        if (softwareObject != null) {
            SoftwareObjectReference[] softwareObjectReferenceArray = softwareObject.getRequired();
            boolean bl = false;
            int n = 0;
            while (!bl && n < softwareObjectReferenceArray.length) {
                if (softwareObjectKey2.equals(softwareObjectReferenceArray[n].getKey())) {
                    softwareObjectReferenceArray[n].setKey(softwareObjectKey2);
                    bl = true;
                }
                ++n;
            }
        }
    }

    private void writeVPD() {
        FileOutputStream fileOutputStream = null;
        BufferedWriter bufferedWriter = null;
        try {
            try {
                Enumeration enumeration = this.vpd.elements();
                String string = this.getVPDFileName();
                this.logEvent(this, WizardLog.subclassEvent("dbg", "registry"), "reading VPD from " + string);
                fileOutputStream = new FileOutputStream(string);
                bufferedWriter = new BufferedWriter(new OutputStreamWriter((OutputStream)fileOutputStream, "8859_1"));
                while (enumeration.hasMoreElements()) {
                    Hashtable hashtable = (Hashtable)enumeration.nextElement();
                    Enumeration enumeration2 = hashtable.elements();
                    while (enumeration2.hasMoreElements()) {
                        SoftwareObject softwareObject = (SoftwareObject)enumeration2.nextElement();
                        String string2 = this.dumpSoftwareObjectKey(softwareObject.getKey());
                        String string3 = this.dumpSoftwareObject(softwareObject);
                        bufferedWriter.write(new String(String.valueOf(string2) + "=" + string3));
                        bufferedWriter.newLine();
                    }
                }
            }
            catch (Throwable throwable) {
                this.logEvent(this, "err", throwable);
            }
            Object var4_11 = null;
        }
        catch (Throwable throwable) {
            Object var4_12 = null;
            try {
                if (bufferedWriter != null) {
                    bufferedWriter.close();
                }
            }
            catch (IOException iOException) {}
            try {
                if (fileOutputStream != null) {
                    fileOutputStream.close();
                }
            }
            catch (IOException iOException) {}
            throw throwable;
        }
        try {
            if (bufferedWriter != null) {
                bufferedWriter.close();
            }
        }
        catch (IOException iOException) {}
        try {
            if (fileOutputStream != null) {
                fileOutputStream.close();
            }
        }
        catch (IOException iOException) {}
    }
}

