/*
 * Decompiled with CFR 0.152.
 */
package com.installshield.product.wizardbeans;

import com.installshield.product.service.product.ProductService;
import com.installshield.util.LocalizedStringResolver;
import com.installshield.wizard.WizardBeanEvent;
import com.installshield.wizard.awt.ColumnConstraints;
import com.installshield.wizard.awt.ColumnLayout;
import com.installshield.wizard.awt.InsetsPanel;
import com.installshield.wizard.service.ServiceException;
import com.installshield.wizardx.panels.ExtendedWizardPanel;
import com.installshield.wizardx.ui.ChoiceComponent;
import com.installshield.wizardx.ui.ChoiceComponentEvent;
import com.installshield.wizardx.ui.ChoiceComponentListener;
import java.awt.Adjustable;
import java.awt.Component;
import java.awt.Container;
import java.awt.Insets;
import java.awt.ScrollPane;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Properties;
import java.util.Vector;

public class UninstallFeaturePanel
extends ExtendedWizardPanel
implements ChoiceComponentListener {
    private static final String PRODUCT_URL = "/product.xml";
    private ChoiceComponent choiceComponent = null;
    private String[] featureNames = new String[0];
    private int[] selectedIndexes = new int[0];
    private int[] uninstalledIndexes = new int[0];
    private int[] installedIndexes = new int[0];
    private Vector selectedFeatureList = new Vector();
    private Vector uninstalledFeatureList = new Vector();
    private Vector installedFeatureList = new Vector();
    private Hashtable featureBeanIds = new Hashtable();
    private Hashtable featuresRequiredByProduct = new Hashtable();
    private boolean firstEntry = true;
    private Container featureListContainer = null;
    static /* synthetic */ Class class$com$installshield$product$ProductFeature;

    public UninstallFeaturePanel() {
        this.setDescription("$L(com.installshield.product.i18n.ProductResources, UninstallFeaturePanel.description, $P(displayName))");
    }

    private void checkForRequiredByFeatures(String string, String string2) {
        try {
            ProductService productService = (ProductService)this.getService("productService");
            Properties[] propertiesArray = productService.getRequiredByFeatures(PRODUCT_URL, string, true);
            StringBuffer stringBuffer = new StringBuffer();
            boolean bl = true;
            int n = 0;
            while (n < propertiesArray.length) {
                if (!((Boolean)((Hashtable)propertiesArray[n]).get("active")).booleanValue()) {
                    if (n > 0 && n != propertiesArray.length) {
                        stringBuffer.append(", ");
                    }
                    bl = false;
                    stringBuffer.append("\"" + propertiesArray[n].getProperty("displayName") + "\"");
                }
                ++n;
            }
            if (!bl) {
                this.getWizard().getServices().displayUserMessage(LocalizedStringResolver.resolve("com.installshield.product.i18n.ProductResources", "FeaturePanel.updateStatus"), LocalizedStringResolver.resolve("com.installshield.product.i18n.ProductResources", "FeaturePanel.requiredBy", new String[]{string2, stringBuffer.toString()}), 1);
            }
        }
        catch (ServiceException serviceException) {
            this.logEvent(this, "err", serviceException);
        }
    }

    public void choiceComponentStateChanged(ChoiceComponentEvent choiceComponentEvent) {
        boolean bl = choiceComponentEvent.getState();
        int n = choiceComponentEvent.getSelectedIndex();
        String string = choiceComponentEvent.getItem();
        String string2 = (String)this.featureBeanIds.get(new Integer(n));
        boolean bl2 = false;
        if (bl) {
            this.selectedFeatureList.addElement(new Integer(n));
            this.refreshIndexes();
            boolean bl3 = this.isFeaturePubliclyShareable(string2, string);
            if (bl3) {
                try {
                    this.getWizard().getServices().displayUserMessage(LocalizedStringResolver.resolve("com.installshield.product.i18n.ProductResources", "FeaturePanel.updateStatus"), LocalizedStringResolver.resolve("com.installshield.product.i18n.ProductResources", "UninstallFeaturePanel.publiclyShared", new String[]{string}), 1);
                }
                catch (ServiceException serviceException) {
                    this.logEvent(this, "err", serviceException);
                }
            }
            if (this.isPartialUninstall()) {
                Object v = this.featuresRequiredByProduct.get(string2);
                if (v != null) {
                    try {
                        bl2 = true;
                        this.getWizard().getServices().displayUserMessage(LocalizedStringResolver.resolve("com.installshield.product.i18n.ProductResources", "FeaturePanel.updateStatus"), LocalizedStringResolver.resolve("com.installshield.product.i18n.ProductResources", "FeaturePanel.requiredByProduct", new String[]{this.featureNames[n]}), 1);
                    }
                    catch (ServiceException serviceException) {
                        this.logEvent(this, "err", serviceException);
                    }
                }
                if (!bl2 && !bl3) {
                    this.checkForRequiredByFeatures(string2, string);
                }
            }
            this.updateFeatureActiveState(string2, bl);
        } else {
            Vector<Integer> vector = new Vector<Integer>();
            vector.addElement(new Integer(n));
            this.refreshRequiredFeatures(string2, vector);
            int n2 = 0;
            while (n2 < vector.size()) {
                String string3 = (String)this.featureBeanIds.get(vector.elementAt(n2));
                this.updateFeatureActiveState(string3, false);
                ++n2;
            }
            this.refreshIndexes();
            this.choiceComponent.setSelectedIndexes(this.selectedIndexes);
        }
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    protected void createUI(WizardBeanEvent wizardBeanEvent) {
        super.createUI(wizardBeanEvent);
        this.choiceComponent.createComponentUI();
        this.featureListContainer.remove(this.choiceComponent);
        ((InsetsPanel)this.featureListContainer).setInsets(new Insets(10, 10, 10, 10));
        this.featureListContainer.add((Component)this.choiceComponent, new ColumnConstraints(1, 1));
        this.getContentPane().remove(this.featureListContainer);
        ScrollPane scrollPane = new ScrollPane(0);
        Adjustable adjustable = scrollPane.getVAdjustable();
        if (adjustable.getUnitIncrement() < 5) {
            adjustable.setUnitIncrement(15);
        }
        scrollPane.add(this.featureListContainer);
        this.getContentPane().add((Component)scrollPane, "Center");
    }

    public boolean entered(WizardBeanEvent wizardBeanEvent) {
        if (this.firstEntry) {
            this.retrieveFeaturesInformation();
            int n = 0;
            while (n < this.featureNames.length) {
                boolean bl = false;
                String string = (String)this.featureBeanIds.get(new Integer(n));
                bl = this.selectedFeatureList.contains(new Integer(n));
                this.updateFeatureActiveState(string, bl);
                ++n;
            }
            this.firstEntry = false;
        }
        if (this.choiceComponent != null) {
            this.choiceComponent.setSelectedIndexes(this.selectedIndexes);
            this.choiceComponent.setRequiredIndexes(this.uninstalledIndexes);
        }
        return true;
    }

    private void fillRequiredFeaturesList(ProductService productService, String string, Hashtable hashtable, String string2) throws ServiceException {
        Properties[] propertiesArray = productService.getRequiredFeatures(string, string2, true);
        int n = 0;
        while (n < propertiesArray.length) {
            Properties properties = propertiesArray[n];
            hashtable.put(properties.getProperty("beanId"), (Boolean)((Hashtable)properties).get("active"));
            this.fillRequiredFeaturesList(productService, string, hashtable, properties.getProperty("beanId"));
            ++n;
        }
    }

    private int getFeatureIndex(Object object) {
        if (object != null) {
            String string = (String)object;
            int n = 0;
            while (n < this.featureNames.length) {
                if (this.featureNames[n].equals(string)) {
                    return n;
                }
                ++n;
            }
        }
        return -1;
    }

    private int getFeatureIndexByBeanId(String string) {
        Enumeration enumeration = this.featureBeanIds.keys();
        while (enumeration.hasMoreElements()) {
            Object k = enumeration.nextElement();
            Object v = this.featureBeanIds.get(k);
            if (v == null || !((String)v).equals(string)) continue;
            return (Integer)k;
        }
        return -1;
    }

    public void initialize() {
        super.initialize();
        this.retrieveFeaturesInformation();
        this.choiceComponent = new ChoiceComponent();
        this.choiceComponent.setComponentType(2);
        this.choiceComponent.setOptions(this.featureNames);
        this.choiceComponent.setMultipleSelection(true);
        this.choiceComponent.setSelectedIndexes(this.selectedIndexes);
        this.choiceComponent.setRequiredIndexes(this.uninstalledIndexes);
        this.choiceComponent.addChoiceComponentListener(this);
        this.featureListContainer = this.getPane();
        this.featureListContainer.setLayout(new ColumnLayout());
        this.featureListContainer.add(this.choiceComponent);
        this.getContentPane().add((Component)this.featureListContainer, "Center");
    }

    private boolean isFeaturePubliclyShareable(String string, String string2) {
        try {
            ProductService productService = (ProductService)this.getService("productService");
            Boolean bl = (Boolean)productService.getProductBeanProperty(PRODUCT_URL, string, "publiclyShareable");
            return bl;
        }
        catch (ServiceException serviceException) {
            this.logEvent(this, "err", serviceException);
            return false;
        }
    }

    private boolean isPartialUninstall() {
        return this.selectedIndexes.length != this.installedIndexes.length;
    }

    public boolean queryExit(WizardBeanEvent wizardBeanEvent) {
        return true;
    }

    private void refreshIndexes() {
        Integer n;
        this.selectedIndexes = new int[this.selectedFeatureList.size()];
        int n2 = 0;
        Enumeration enumeration = this.selectedFeatureList.elements();
        while (enumeration.hasMoreElements()) {
            n = (Integer)enumeration.nextElement();
            this.selectedIndexes[n2++] = n;
        }
        this.uninstalledIndexes = new int[this.uninstalledFeatureList.size()];
        n2 = 0;
        enumeration = this.uninstalledFeatureList.elements();
        while (enumeration.hasMoreElements()) {
            n = (Integer)enumeration.nextElement();
            this.uninstalledIndexes[n2++] = n;
        }
        this.installedIndexes = new int[this.installedFeatureList.size()];
        n2 = 0;
        enumeration = this.installedFeatureList.elements();
        while (enumeration.hasMoreElements()) {
            n = (Integer)enumeration.nextElement();
            this.installedIndexes[n2++] = n;
        }
    }

    private void refreshRequiredFeatures(String string, Vector vector) {
        try {
            int n = this.getFeatureIndexByBeanId(string);
            boolean bl = this.selectedFeatureList.contains(new Integer(n));
            if (bl) {
                this.selectedFeatureList.removeElement(new Integer(n));
                vector.addElement(new Integer(n));
            }
            ProductService productService = (ProductService)this.getService("productService");
            Properties[] propertiesArray = productService.getRequiredFeatures(PRODUCT_URL, string, true);
            int n2 = 0;
            while (n2 < propertiesArray.length) {
                String string2 = propertiesArray[n2].getProperty("beanId");
                this.refreshRequiredFeatures(string2, vector);
                ++n2;
            }
        }
        catch (ServiceException serviceException) {
            this.logEvent(this, "err", serviceException);
        }
    }

    private void retrieveFeaturesInformation() {
        this.selectedFeatureList.removeAllElements();
        this.installedFeatureList.removeAllElements();
        this.uninstalledFeatureList.removeAllElements();
        this.featuresRequiredByProduct.clear();
        Properties properties = new Properties();
        ((Hashtable)properties).put("filter.condition", new Boolean(true));
        ((Hashtable)properties).put("filter.class", (class$com$installshield$product$ProductFeature != null ? class$com$installshield$product$ProductFeature : (class$com$installshield$product$ProductFeature = UninstallFeaturePanel.class$("com.installshield.product.ProductFeature"))).getName());
        try {
            ProductService productService = (ProductService)this.getService("productService");
            this.fillRequiredFeaturesList(productService, PRODUCT_URL, this.featuresRequiredByProduct, productService.getProductTreeRoot(PRODUCT_URL));
            Properties[] propertiesArray = productService.getProductBeanChildren(PRODUCT_URL, null, new String[]{"beanId", "displayName", "installStatus"}, properties);
            this.featureNames = new String[propertiesArray.length];
            int n = 0;
            while (n < propertiesArray.length) {
                boolean bl;
                this.featureNames[n] = this.resolveString(propertiesArray[n].getProperty("displayName"));
                this.featureBeanIds.put(new Integer(n), propertiesArray[n].getProperty("beanId"));
                boolean bl2 = bl = (Integer)((Hashtable)propertiesArray[n]).get("installStatus") == 3;
                if (bl) {
                    this.selectedFeatureList.addElement(new Integer(n));
                    this.installedFeatureList.addElement(new Integer(n));
                } else {
                    this.uninstalledFeatureList.addElement(new Integer(n));
                }
                ++n;
            }
            this.refreshIndexes();
        }
        catch (ServiceException serviceException) {
            this.logEvent(this, "err", serviceException);
        }
    }

    private void updateFeatureActiveState(String string, boolean bl) {
        try {
            ProductService productService = (ProductService)this.getService("productService");
            productService.setProductBeanProperty(PRODUCT_URL, string, "active", new Boolean(bl));
        }
        catch (ServiceException serviceException) {
            this.logEvent(this, "err", serviceException);
        }
    }
}

