/*
 * Decompiled with CFR 0.152.
 */
package com.installshield.util;

import com.installshield.util.LocalizedStringResolver;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.util.Enumeration;
import java.util.StringTokenizer;
import java.util.Vector;

public class TTYDisplay {
    private static PrintWriter outWriter;
    private static BufferedReader inReader;
    private static int consoleWidth;
    private static final int LINES = 20;
    private static final int INDENT = 3;
    public static final int TABLE_PADDING = 2;
    private static Vector displayedHelp;

    static {
        consoleWidth = 80;
    }

    public TTYDisplay() {
        TTYDisplay.initialize();
    }

    private static int arrayLargest(int[] nArray) {
        int n = 0;
        int n2 = 0;
        while (n2 < nArray.length) {
            n = nArray[n2] > nArray[n] ? n2 : n;
            ++n2;
        }
        return n;
    }

    public static void clear() {
        TTYDisplay.clear(20);
    }

    public static void clear(int n) {
        int n2 = 0;
        while (n2 < n) {
            System.out.println("");
            ++n2;
        }
    }

    private static String createTable(Vector vector) {
        int n;
        Object object;
        String string = new String();
        int n2 = vector.size();
        int n3 = 0;
        Enumeration enumeration = vector.elements();
        while (enumeration.hasMoreElements()) {
            object = (Vector)enumeration.nextElement();
            if (((Vector)object).size() <= n3) continue;
            n3 = ((Vector)object).size();
        }
        String[][] stringArray = new String[n2][n3];
        object = new int[n3];
        int n4 = 0;
        while (n4 < ((Object)object).length) {
            object[n4] = false;
            ++n4;
        }
        int n5 = 0;
        Enumeration enumeration2 = vector.elements();
        while (enumeration2.hasMoreElements()) {
            Vector vector2 = (Vector)enumeration2.nextElement();
            Enumeration enumeration3 = vector2.elements();
            n = 0;
            while (n < n3) {
                String string2 = "";
                if (enumeration3.hasMoreElements()) {
                    string2 = (String)enumeration3.nextElement();
                }
                if (string2 == null || string2.equals("")) {
                    string2 = " ";
                }
                stringArray[n5][n] = string2;
                if (string2.length() > object[n]) {
                    object[n] = string2.length();
                }
                ++n;
            }
            ++n5;
        }
        int n6 = 0;
        int n7 = 0;
        while (n7 < ((Object)object).length) {
            n6 += object[n7] + 2;
            ++n7;
        }
        while (n6 > consoleWidth) {
            Object object2 = object;
            int n8 = TTYDisplay.arrayLargest((int[])object);
            object2[n8] = object2[n8] - true;
            --n6;
        }
        n = 0;
        while (n < stringArray.length) {
            int n9 = 0;
            while (n9 < stringArray[0].length) {
                Object object3 = object[n9];
                String string3 = stringArray[n][n9];
                int n10 = string3.length();
                if (n10 > object3) {
                    string3 = string3.substring(0, (int)object3);
                }
                if (n10 < object3) {
                    int n11 = n10;
                    while (n11 < object3) {
                        string3 = String.valueOf(string3) + " ";
                        ++n11;
                    }
                }
                string3 = " " + string3 + " ";
                string = String.valueOf(string) + string3;
                ++n9;
            }
            string = String.valueOf(string) + "\n";
            ++n;
        }
        return string;
    }

    public static void displayTable(Vector vector) {
        outWriter.print(TTYDisplay.createTable(vector));
        outWriter.flush();
    }

    public static void exit() {
        System.exit(-1);
    }

    public static int getConsoleWidth() {
        return consoleWidth;
    }

    public static void initialize() {
        TTYDisplay.initialize(System.in, System.out, 80);
    }

    public static void initialize(int n) {
        TTYDisplay.initialize(System.in, System.out, n);
    }

    public static void initialize(InputStream inputStream, OutputStream outputStream, int n) {
        outWriter = new PrintWriter(outputStream, true);
        inReader = new BufferedReader(new InputStreamReader(inputStream));
        consoleWidth = n;
        displayedHelp = new Vector();
    }

    public static void pageText(String string) {
        boolean bl = false;
        int n = 0;
        StringTokenizer stringTokenizer = new StringTokenizer(string, "\n");
        while (!bl) {
            if (!stringTokenizer.hasMoreTokens()) {
                bl = true;
                continue;
            }
            String string2 = stringTokenizer.nextToken();
            TTYDisplay.showText(string2);
            if (++n % 20 != 0) continue;
            String string3 = TTYDisplay.resolveString("com.installshield.wizard.i18n.WizardResources", "ttyDisplayCharQ");
            if (!TTYDisplay.promptForNextLine().equalsIgnoreCase(string3)) continue;
            bl = true;
        }
    }

    private static void prettyPrintText(String string, boolean bl, int n) {
        String string2 = "";
        int n2 = 0;
        while (n2 < n) {
            string2 = String.valueOf(string2) + " ";
            ++n2;
        }
        string = String.valueOf(string2) + string;
        int n3 = consoleWidth - n;
        if (string.length() < n3) {
            outWriter.print(string);
        } else {
            StringBuffer stringBuffer = new StringBuffer(string);
            int n4 = 0;
            int n5 = 0;
            while (n5 < stringBuffer.length()) {
                ++n4;
                if (stringBuffer.charAt(n5) == '\n') {
                    stringBuffer.insert(n5 + 1, string2);
                    n4 = 0;
                }
                if (n4 == n3) {
                    while (stringBuffer.charAt(n5) != ' ' && stringBuffer.charAt(n5) != '\n' && n5 > 0) {
                        --n5;
                    }
                    if (stringBuffer.charAt(n5) == '\n' || n5 == 0) {
                        stringBuffer.insert(n5 += n3, "\n" + string2);
                    } else {
                        stringBuffer.setCharAt(n5, '\n');
                        stringBuffer.insert(n5 + 1, string2);
                    }
                    n4 = 0;
                }
                ++n5;
            }
            outWriter.print(stringBuffer.toString());
        }
        if (bl) {
            outWriter.print("\n");
        }
        outWriter.flush();
    }

    public static void print(String string) {
        outWriter.print(string);
        outWriter.flush();
    }

    private static String promptForNextLine() {
        TTYDisplay.showNewline();
        String string = TTYDisplay.resolveString("com.installshield.wizard.i18n.WizardResources", "ttyDisplayCharQ");
        String string2 = TTYDisplay.resolveString("com.installshield.wizard.i18n.WizardResources", "ttyDisplayReadText");
        String string3 = TTYDisplay.resolveString("com.installshield.wizard.i18n.WizardResources", "ttyDisplayQuit", new String[]{string});
        String string4 = TTYDisplay.resolveString("com.installshield.wizard.i18n.WizardResources", "ttyDisplayContinue", new String[]{string2});
        String string5 = TTYDisplay.queryValue(string4, string3, "");
        TTYDisplay.showNewline();
        return string5;
    }

    public static String queryValue(String string) {
        return TTYDisplay.queryValue(string, "");
    }

    public static int queryValue(String string, int n, int n2, int n3, String string2) {
        while (true) {
            String string3 = "";
            string3 = TTYDisplay.queryValue(string, String.valueOf(n), string2);
            try {
                int n4 = Integer.parseInt(string3);
                if (n4 >= n2 && n4 <= n3) {
                    return n4;
                }
            }
            catch (NumberFormatException numberFormatException) {}
            String[] stringArray = new String[]{String.valueOf(n2), String.valueOf(n3)};
            TTYDisplay.showNewline();
            TTYDisplay.showText(TTYDisplay.resolveString("com.installshield.wizard.i18n.WizardResources", "ttyDisplayEnterValueRange", stringArray));
            TTYDisplay.showNewline();
        }
    }

    public static String queryValue(String string, String string2) {
        String string3 = TTYDisplay.resolveString("com.installshield.wizard.i18n.WizardResources", "ttyDisplayNoDefault");
        return TTYDisplay.queryValue(string, string3, string2);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Lifted jumps to return sites
     */
    public static String queryValue(String string, String string2, String string3) {
        String string4 = TTYDisplay.resolveString("com.installshield.wizard.i18n.WizardResources", "ttyDisplayNoHelp");
        String string5 = TTYDisplay.resolveString("com.installshield.wizard.i18n.WizardResources", "ttyDisplayQuestionMark");
        String string6 = TTYDisplay.resolveString("com.installshield.wizard.i18n.WizardResources", "ttyDisplayNoDefault");
        if (string3 == null) {
            string3 = string4;
        } else if (TTYDisplay.showHelp(string3)) {
            TTYDisplay.showNewline();
            TTYDisplay.prettyPrintText(string3, true, 0);
            TTYDisplay.showNewline();
        }
        String string7 = string5;
        if (string2 == null) {
            string2 = "";
        }
        while (true) {
            String string8 = "";
            if (string2.equals("")) {
                string8 = " []";
            } else if (!string2.equals(string6)) {
                string8 = " [" + string2 + "]";
            }
            if (string.trim().endsWith(string7)) {
                string = string.trim().substring(0, string.trim().length() - 1);
                string8 = String.valueOf(string8) + "? ";
            } else if (string.trim().endsWith(":")) {
                string = string.trim().substring(0, string.trim().length() - 1);
                string8 = String.valueOf(string8) + ": ";
            } else if (!string8.equals("")) {
                string8 = String.valueOf(string8) + " ";
            }
            TTYDisplay.prettyPrintText(String.valueOf(string) + string8, false, 3);
            try {
                String string9 = inReader.readLine();
                if (string9 == null) {
                    System.exit(-1);
                }
                if (!string9.equals(string7)) {
                    if (!string9.equals("")) return string9;
                    if (string2.equals(string6)) return string9;
                    return string2;
                }
                TTYDisplay.showNewline();
                TTYDisplay.prettyPrintText(string3, true, 0);
                TTYDisplay.showNewline();
            }
            catch (IOException iOException) {
                System.err.println("Read exception: " + iOException);
                return null;
            }
        }
    }

    public static int queryValue(String string, String string2, String[] stringArray, int n, String string3) {
        TTYDisplay.showNewline();
        if (string3 != null && !string3.equals("") && TTYDisplay.showHelp(string3)) {
            TTYDisplay.showText(string3);
            TTYDisplay.showNewline();
        }
        if (string2 != null && !string2.equals("")) {
            TTYDisplay.showText(string2);
            TTYDisplay.showNewline();
        }
        int n2 = 0;
        while (n2 < stringArray.length) {
            TTYDisplay.showText(String.valueOf(n2 + 1) + ". " + stringArray[n2]);
            ++n2;
        }
        TTYDisplay.showNewline();
        int n3 = TTYDisplay.queryValue(string, n + 1, 1, stringArray.length, string3);
        return n3 - 1;
    }

    public static String queryValue(String string, String string2, String[] stringArray, String string3) {
        return TTYDisplay.queryValue(string, string2, stringArray, true, string3);
    }

    public static String queryValue(String string, String string2, String[] stringArray, boolean bl, String string3) {
        while (true) {
            String string4 = "";
            string4 = TTYDisplay.queryValue(string, string2, string3);
            if (stringArray.length == 1) {
                return stringArray[0];
            }
            int n = 0;
            while (n < stringArray.length) {
                if (bl ? string4.equalsIgnoreCase(stringArray[n]) : string4.equals(stringArray[n])) {
                    return stringArray[n];
                }
                ++n;
            }
            String string5 = "";
            int n2 = 0;
            while (n2 < stringArray.length - 2) {
                string5 = String.valueOf(string5) + "'" + stringArray[n2] + "' ";
                ++n2;
            }
            string5 = String.valueOf(string5) + "'" + stringArray[stringArray.length - 2] + "'";
            String string6 = "'" + stringArray[stringArray.length - 1] + "'";
            String[] stringArray2 = new String[]{string5, string6};
            String string7 = TTYDisplay.resolveString("com.installshield.wizard.i18n.WizardResources", "ttyDisplaySelectChoice", stringArray2);
            TTYDisplay.showNewline();
            TTYDisplay.showText(string7);
            TTYDisplay.showNewline();
        }
    }

    private static String resolveString(String string, String string2) {
        return LocalizedStringResolver.resolve(string, string2);
    }

    private static String resolveString(String string, String string2, String[] stringArray) {
        return LocalizedStringResolver.resolve(string, string2, stringArray);
    }

    public static void setConsoleWidth(int n) {
        consoleWidth = n;
    }

    private static boolean showHelp(String string) {
        if (string == null || string.equals("")) {
            return false;
        }
        if (!displayedHelp.contains(string)) {
            displayedHelp.addElement(string);
            return true;
        }
        return false;
    }

    public static void showNewline() {
        TTYDisplay.prettyPrintText("", true, 0);
    }

    public static void showText(String string) {
        TTYDisplay.showText(string, 0);
    }

    public static void showText(String string, int n) {
        TTYDisplay.prettyPrintText(string, true, n);
    }
}

