/*
 * Decompiled with CFR 0.152.
 */
package com.installshield.util.jvm;

import com.installshield.util.FileUtils;
import com.installshield.util.jvm.Instructions;
import com.installshield.util.jvm.JARFile;
import com.installshield.util.jvm.JVMFile;
import com.installshield.util.jvm.JVMInstaller;
import com.installshield.util.jvm.LaunchScript;
import com.installshield.util.jvm.LauncherEntry;
import com.installshield.util.jvm.VerifyClass;
import java.io.DataOutputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URL;
import java.util.Vector;

public class LauncherWriter {
    private Vector entries = new Vector();
    private Vector jvmFiles = new Vector();
    private Vector jarFiles = new Vector();
    private Instructions instructions = null;
    private LaunchScript launchScript = null;
    private JVMInstaller jvmInstaller = null;
    private URL launcherStub = null;
    private VerifyClass verifyClass = new VerifyClass();
    private String fileName = null;

    public void addJARFile(JARFile jARFile) {
        if (jARFile == null) {
            throw new IllegalArgumentException("jarFile cannot be null");
        }
        this.jarFiles.addElement(jARFile);
        this.refreshEntriesList();
    }

    public void addJVMFile(JVMFile jVMFile) {
        if (jVMFile == null) {
            throw new IllegalArgumentException("jvmFile cannot be null");
        }
        this.jvmFiles.addElement(jVMFile);
        this.refreshEntriesList();
    }

    public String getFileName() {
        return this.fileName;
    }

    public int getLauncherEntryIndex(int n) {
        return this.getLauncherEntryIndex(n, 0);
    }

    public int getLauncherEntryIndex(int n, int n2) {
        int n3 = 0;
        int n4 = 0;
        while (n4 < this.entries.size()) {
            if (((LauncherEntry)this.entries.elementAt(n4)).getType() == n && n3++ == n2) {
                return n4;
            }
            ++n4;
        }
        return -1;
    }

    private void refreshEntriesList() {
        this.entries.removeAllElements();
        if (this.verifyClass != null) {
            this.entries.addElement(this.verifyClass);
        }
        if (this.instructions != null) {
            this.entries.addElement(this.instructions);
        }
        if (this.launchScript != null) {
            this.entries.addElement(this.launchScript);
        }
        int n = 0;
        while (n < this.jvmFiles.size()) {
            this.entries.addElement(this.jvmFiles.elementAt(n));
            ++n;
        }
        int n2 = 0;
        while (n2 < this.jarFiles.size()) {
            this.entries.addElement(this.jarFiles.elementAt(n2));
            ++n2;
        }
        if (this.jvmInstaller != null) {
            this.entries.addElement(this.jvmInstaller);
        }
    }

    public void setFileName(String string) {
        this.fileName = string;
    }

    public void setInstructions(Instructions instructions) {
        this.instructions = instructions;
        this.refreshEntriesList();
    }

    public void setJVMInstaller(JVMInstaller jVMInstaller) {
        this.jvmInstaller = jVMInstaller;
        this.refreshEntriesList();
    }

    public void setLaunchScript(LaunchScript launchScript) {
        this.launchScript = launchScript;
        this.refreshEntriesList();
    }

    public void setLauncherStub(URL uRL) {
        this.launcherStub = uRL;
    }

    public void setVerifyClass(URL uRL) {
        this.verifyClass.setClassResource(uRL);
        this.refreshEntriesList();
    }

    public void write() throws IOException {
        if (this.launcherStub == null) {
            throw new IOException("launchStub not specified -- cannot write");
        }
        if (this.verifyClass.getClassResource() == null) {
            throw new IOException("verifyClass not specified -- cannot write");
        }
        if (this.instructions == null) {
            throw new IOException("instructions not specified -- cannot write");
        }
        if (this.launchScript == null) {
            throw new IOException("launchScript not specified -- cannot write");
        }
        int n = 0;
        Vector vector = new Vector();
        FileOutputStream fileOutputStream = new FileOutputStream(this.fileName);
        try {
            DataOutputStream dataOutputStream = new DataOutputStream(fileOutputStream);
            InputStream inputStream = this.launcherStub.openStream();
            n += FileUtils.copy(inputStream, dataOutputStream);
            inputStream.close();
            n += this.writeEntry(this.verifyClass, dataOutputStream, n, vector);
            n += this.writeEntry(this.instructions, dataOutputStream, n, vector);
            n += this.writeEntry(this.launchScript, dataOutputStream, n, vector);
            int n2 = 0;
            while (n2 < this.jvmFiles.size()) {
                JVMFile jVMFile = (JVMFile)this.jvmFiles.elementAt(n2);
                n += this.writeEntry(jVMFile, dataOutputStream, n, vector);
                ++n2;
            }
            if (this.jarFiles.size() > 0) {
                int n3 = 0;
                while (n3 < this.jarFiles.size()) {
                    JARFile jARFile = (JARFile)this.jarFiles.elementAt(n3);
                    n += this.writeEntry(jARFile, dataOutputStream, n, vector);
                    ++n3;
                }
            }
            if (this.jvmInstaller != null) {
                n += this.writeEntry(this.jvmInstaller, dataOutputStream, n, vector);
            }
            this.writeIndex(vector, n, dataOutputStream);
            dataOutputStream.flush();
        }
        catch (Throwable throwable) {
            Object var5_11 = null;
            try {
                fileOutputStream.close();
            }
            catch (IOException iOException) {}
            throw throwable;
        }
        Object var5_10 = null;
        try {
            fileOutputStream.close();
        }
        catch (IOException iOException) {}
    }

    private int writeEntry(LauncherEntry launcherEntry, OutputStream outputStream, int n, Vector vector) throws IOException {
        int n2 = launcherEntry.write(outputStream);
        class Com_installshield_util_jvm_LauncherWriter$1 {
            /* synthetic */ Com_installshield_util_jvm_LauncherWriter$1() {
            }
        }
        vector.addElement(new IndexEntry(null, launcherEntry.getType(), n2, n, launcherEntry.getName()));
        return n2;
    }

    private void writeIndex(Vector vector, int n, DataOutputStream dataOutputStream) throws IOException {
        dataOutputStream.writeInt(vector.size());
        int n2 = 0;
        while (n2 < vector.size()) {
            IndexEntry indexEntry = (IndexEntry)vector.elementAt(n2);
            dataOutputStream.writeByte(indexEntry.fileType);
            dataOutputStream.writeInt(n2);
            dataOutputStream.writeInt(indexEntry.byteLength);
            dataOutputStream.writeInt(indexEntry.offset);
            dataOutputStream.writeUTF(indexEntry.fileNameOnly);
            ++n2;
        }
        dataOutputStream.writeInt(n);
        dataOutputStream.writeInt(-897398142);
    }

    private class IndexEntry {
        final byte fileType;
        final int byteLength;
        final int offset;
        final String fileNameOnly;

        private IndexEntry(int n, int n2, int n3, String string) {
            if (string == null) {
                throw new IllegalArgumentException("fileName cannot be null");
            }
            this.fileNameOnly = string;
            this.fileType = new Integer(n).byteValue();
            this.offset = n3;
            this.byteLength = n2;
        }

        /* synthetic */ IndexEntry(1 var2_2, int n, int n2, int n3, String string) {
            this(n, n2, n3, string);
        }
    }
}

