/*
 * Decompiled with CFR 0.152.
 */
package com.installshield.wizard;

import com.installshield.wizard.Wizard;
import com.installshield.wizard.WizardBean;
import com.installshield.wizard.WizardBeanReference;
import com.installshield.wizard.WizardException;
import com.installshield.wizard.WizardTreeIterator;
import java.util.Hashtable;

public class MultiWizardTreeIterator
implements WizardTreeIterator {
    private Wizard root;
    private WizardTreeIterator iter;
    private Hashtable iterators = new Hashtable();
    private Hashtable iteratorRefs = new Hashtable();

    public MultiWizardTreeIterator(Wizard wizard, WizardTreeIterator wizardTreeIterator) {
        this.root = wizard;
        this.iter = wizardTreeIterator;
    }

    public WizardBean begin() {
        return this.iter.begin();
    }

    private WizardBean dereferenceNext(WizardBeanReference wizardBeanReference) throws WizardException {
        WizardTreeIterator wizardTreeIterator = this.initializeReferenceIterator(wizardBeanReference);
        return wizardTreeIterator.getNext(wizardTreeIterator.begin());
    }

    private WizardBean dereferencePrevious(WizardBeanReference wizardBeanReference) throws WizardException {
        WizardTreeIterator wizardTreeIterator = this.initializeReferenceIterator(wizardBeanReference);
        return wizardTreeIterator.getPrevious(wizardTreeIterator.end());
    }

    public WizardBean end() {
        return this.iter.end();
    }

    private WizardTreeIterator getExternalIterator(Wizard wizard, WizardBeanReference wizardBeanReference) throws WizardException {
        WizardTreeIterator wizardTreeIterator = (WizardTreeIterator)this.iterators.get(String.valueOf(wizardBeanReference.getWizardReference()) + "/" + wizardBeanReference.getBeanIdReference());
        if (wizardTreeIterator == null) {
            try {
                wizardTreeIterator = wizard.createIterator(wizardBeanReference.getBeanIdReference(), true);
                this.iterators.put(String.valueOf(wizardBeanReference.getWizardReference()) + "/" + wizardBeanReference.getBeanIdReference(), wizardTreeIterator);
            }
            catch (IllegalArgumentException illegalArgumentException) {
                illegalArgumentException.printStackTrace();
                throw new WizardException(100);
            }
        }
        return wizardTreeIterator;
    }

    public WizardBean getNext(WizardBean wizardBean) {
        WizardBean wizardBean2;
        WizardTreeIterator wizardTreeIterator = (WizardTreeIterator)wizardBean.getValue("iterator");
        if (wizardTreeIterator == null || wizardTreeIterator == this) {
            wizardTreeIterator = this.iter;
        }
        if ((wizardBean2 = wizardTreeIterator.getNext(wizardBean)) instanceof WizardBeanReference) {
            try {
                wizardBean2 = this.dereferenceNext((WizardBeanReference)wizardBean2);
            }
            catch (WizardException wizardException) {
                wizardException.printStackTrace();
                wizardBean2 = this.getNext(wizardBean2);
            }
        } else if (wizardBean2 == wizardTreeIterator.end() && wizardTreeIterator != this.iter) {
            wizardBean2 = this.getNext((WizardBeanReference)this.iteratorRefs.get(wizardTreeIterator));
        }
        return wizardBean2;
    }

    public WizardBean getPrevious(WizardBean wizardBean) {
        WizardBean wizardBean2;
        WizardTreeIterator wizardTreeIterator = (WizardTreeIterator)wizardBean.getValue("iterator");
        if (wizardTreeIterator == null || wizardTreeIterator == this) {
            wizardTreeIterator = this.iter;
        }
        if ((wizardBean2 = wizardTreeIterator.getPrevious(wizardBean)) instanceof WizardBeanReference) {
            try {
                wizardBean2 = this.dereferencePrevious((WizardBeanReference)wizardBean2);
            }
            catch (WizardException wizardException) {
                wizardException.printStackTrace();
                wizardBean2 = this.getPrevious(wizardBean2);
            }
        } else if (wizardBean2 == wizardTreeIterator.begin() && wizardTreeIterator != this.iter) {
            wizardBean2 = this.getPrevious((WizardBeanReference)this.iteratorRefs.get(wizardTreeIterator));
        }
        return wizardBean2;
    }

    private WizardTreeIterator initializeReferenceIterator(WizardBeanReference wizardBeanReference) throws WizardException {
        Wizard wizard = this.root.getExternalWizard(wizardBeanReference.getWizardReference());
        WizardTreeIterator wizardTreeIterator = this.getExternalIterator(wizard, wizardBeanReference);
        this.iteratorRefs.put(wizardTreeIterator, wizardBeanReference);
        return wizardTreeIterator;
    }
}

