/*
 * Decompiled with CFR 0.152.
 */
package com.installshield.wizard.commandline;

import com.installshield.wizard.CommandLineBean;
import com.installshield.wizard.CommandLineOption;
import com.installshield.wizard.Wizard;
import com.installshield.wizard.service.WizardLog;
import java.util.StringTokenizer;

public class WizardLogOption
extends CommandLineBean {
    private void addEvents(WizardLog wizardLog, String string) {
        StringTokenizer stringTokenizer = new StringTokenizer(string.substring(1), ";");
        while (stringTokenizer.hasMoreTokens()) {
            String string2 = stringTokenizer.nextToken();
            if (string2.equals("ALL")) {
                wizardLog.setAllEventsLogged(true);
                continue;
            }
            if (string2.equals("NONE")) {
                wizardLog.setAllEventsLogged(false);
                wizardLog.clearAllEventsLogged();
                continue;
            }
            wizardLog.setEventLogged(string2, true);
        }
    }

    public boolean execute(Wizard wizard, String[] stringArray) {
        WizardLog wizardLog = null;
        WizardLog wizardLog2 = null;
        boolean bl = false;
        boolean bl2 = false;
        boolean bl3 = false;
        try {
            if (wizard.getWizardLog() == null) {
                wizardLog2 = new WizardLog();
                wizardLog2.setLogService(wizard.getServices().getService("logService"));
                wizard.setWizardLog(wizardLog2);
            }
            wizardLog = wizard.getWizardLog();
            if (stringArray.length > 3) {
                this.exitWithDisplay(wizard);
            }
            int n = 0;
            while (n < stringArray.length) {
                if (stringArray[n].equals("#")) {
                    if (bl) {
                        this.exitWithDisplay(wizard);
                    } else {
                        wizardLog.setLogEchoedToScreen(true);
                        bl = true;
                    }
                } else if (stringArray[n].startsWith("@")) {
                    if (bl3) {
                        this.exitWithDisplay(wizard);
                    } else {
                        this.addEvents(wizardLog, stringArray[n]);
                        bl3 = true;
                    }
                } else if (stringArray[n].startsWith("!")) {
                    if (bl2) {
                        this.exitWithDisplay(wizard);
                    } else {
                        wizardLog.setLogOutputEnabled(true);
                        wizardLog.setLogOutput(stringArray[n].substring(1));
                        bl2 = true;
                    }
                } else {
                    this.exitWithDisplay(wizard);
                }
                ++n;
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        return true;
    }

    private void exitWithDisplay(Wizard wizard) {
        wizard.exit(1001, "Invalid command line option:\nParameter usage:\nParameter:    -log # ![filename] @[event-type];[event-type]...\n    #                    = Echoes display to the standard output.\n    ![filename]           = Name of a file for log output to save to.\n                             - \"!\" with no file name enables Wizard to use\n                                 a default logfile name.\n    @[type];[type]...    = List of log event types that should be logged.\n                             - \"ALL\" in list enables logging of all events.\n                             - \"NONE\" in list clears the list of events and\n                                 disables ALL logging.\n                             - Any other entries get set as logged event types.\n\n    NOTE:  This command-line parameter is non-repeatable.\n");
    }

    public String[] getIllegalOptions() {
        return new String[0];
    }

    public CommandLineOption getOption() {
        return new CommandLineOption("log");
    }
}

